-- MySQL dump 10.13  Distrib 5.7.44-48, for Linux (x86_64)
--
-- Host: localhost    Database: actdyinf_ojs
-- ------------------------------------------------------
-- Server version	5.7.44-48

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
/*!50717 SELECT COUNT(*) INTO @rocksdb_has_p_s_session_variables FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'performance_schema' AND TABLE_NAME = 'session_variables' */;
/*!50717 SET @rocksdb_get_is_supported = IF (@rocksdb_has_p_s_session_variables, 'SELECT COUNT(*) INTO @rocksdb_is_supported FROM performance_schema.session_variables WHERE VARIABLE_NAME=\'rocksdb_bulk_load\'', 'SELECT 0') */;
/*!50717 PREPARE s FROM @rocksdb_get_is_supported */;
/*!50717 EXECUTE s */;
/*!50717 DEALLOCATE PREPARE s */;
/*!50717 SET @rocksdb_enable_bulk_load = IF (@rocksdb_is_supported, 'SET SESSION rocksdb_bulk_load = 1', 'SET @rocksdb_dummy_bulk_load = 0') */;
/*!50717 PREPARE s FROM @rocksdb_enable_bulk_load */;
/*!50717 EXECUTE s */;
/*!50717 DEALLOCATE PREPARE s */;

--
-- Current Database: `actdyinf_ojs`
--


--
-- Table structure for table `announcement_settings`
--

DROP TABLE IF EXISTS `announcement_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `announcement_settings` (
  `announcement_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `announcement_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`announcement_setting_id`),
  UNIQUE KEY `announcement_settings_unique` (`announcement_id`,`locale`,`setting_name`),
  KEY `announcement_settings_announcement_id` (`announcement_id`),
  CONSTRAINT `announcement_settings_announcement_id_foreign` FOREIGN KEY (`announcement_id`) REFERENCES `announcements` (`announcement_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='More data about announcements, including localized properties like names and contents.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcement_settings`
--

LOCK TABLES `announcement_settings` WRITE;
/*!40000 ALTER TABLE `announcement_settings` DISABLE KEYS */;
INSERT INTO `announcement_settings` (`announcement_setting_id`, `announcement_id`, `locale`, `setting_name`, `setting_value`) VALUES (1,1,'en','title','Call for Papers'),(2,1,'hi','title',NULL),(3,1,'en','descriptionShort','<p class=\"MsoNormal\" style=\"text-align: center;\" align=\"center\"><strong style=\"mso-bidi-font-weight: normal;\"><span lang=\"EN-US\" style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif;\">CALL FOR PAPERS</span></strong></p>\n<p><strong><em><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-fareast-font-family: \'MS Mincho\'; mso-fareast-theme-font: minor-fareast; mso-bidi-font-family: \'Times New Roman\'; mso-bidi-theme-font: minor-bidi; mso-ansi-language: EN-IN; mso-fareast-language: EN-US; mso-bidi-language: AR-SA;\">Tecnia Journal of Management Studies</span></em><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-fareast-font-family: \'MS Mincho\'; mso-fareast-theme-font: minor-fareast; mso-bidi-font-family: \'Times New Roman\'; mso-bidi-theme-font: minor-bidi; mso-ansi-language: EN-IN; mso-fareast-language: EN-US; mso-bidi-language: AR-SA;\"> (ISSN: 0975-7104) – Volumes 1 &amp; 2, 2025</span><span lang=\"EN-US\" style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-fareast-font-family: \'MS Mincho\'; mso-fareast-theme-font: minor-fareast; mso-bidi-font-family: \'Times New Roman\'; mso-bidi-theme-font: minor-bidi; mso-ansi-language: EN-US; mso-fareast-language: EN-US; mso-bidi-language: AR-SA;\"><br style=\"mso-special-character: line-break;\"><!-- [if !supportLineBreakNewLine]--><br style=\"mso-special-character: line-break;\"><!--[endif]--></span></strong></p>'),(4,1,'hi','descriptionShort',NULL),(5,1,'en','description','<p class=\"MsoNormal\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Warm greetings from the Editorial Board of <em>Tecnia Journal of Management Studies</em>!</span></p>\n<p class=\"MsoNormal\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">We are pleased to invite you to submit your original research to the upcoming <strong>Volumes 1 &amp; 2 (2025) </strong>of the Tecnia Journal of Management Studies.</span></p>\n<p class=\"MsoNormal\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">As a peer-reviewed, open-access academic journal, we are committed to publishing high-quality, interdisciplinary research that offers managerial insight and innovation. This year, we especially welcome <strong>multidisciplinary submissions</strong> that intersect <strong>Management</strong> with:</span></p>\n<ul style=\"margin-top: 0cm;\" type=\"disc\">\n<li class=\"MsoNormal\" style=\"mso-list: l1 level1 lfo1; tab-stops: list 36.0pt;\"><strong><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Information and Communication Technology (ICT)</span></strong></li>\n<li class=\"MsoNormal\" style=\"mso-list: l1 level1 lfo1; tab-stops: list 36.0pt;\"><strong><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Journalism and Mass Communication</span></strong></li>\n<li class=\"MsoNormal\" style=\"mso-list: l1 level1 lfo1; tab-stops: list 36.0pt;\"><strong><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Social and Digital Media Studies</span></strong></li>\n<li class=\"MsoNormal\" style=\"mso-list: l1 level1 lfo1; tab-stops: list 36.0pt;\"><strong><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Innovation in Public Systems and Communication Strategy</span></strong></li>\n</ul>\n<p class=\"MsoNormal\"><strong><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Suggested Themes (but not limited to):</span></strong></p>\n<ul style=\"margin-top: 0cm;\" type=\"disc\">\n<li class=\"MsoNormal\" style=\"mso-list: l0 level1 lfo2; tab-stops: list 36.0pt;\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Digital Transformation and Strategic Management</span></li>\n<li class=\"MsoNormal\" style=\"mso-list: l0 level1 lfo2; tab-stops: list 36.0pt;\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">ICT in Organizational Planning and Decision-Making</span></li>\n<li class=\"MsoNormal\" style=\"mso-list: l0 level1 lfo2; tab-stops: list 36.0pt;\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Marketing and Consumer Behavior in the Era of Influencer Media</span></li>\n<li class=\"MsoNormal\" style=\"mso-list: l0 level1 lfo2; tab-stops: list 36.0pt;\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Data Analytics, AI, and Managerial Decision Support</span></li>\n<li class=\"MsoNormal\" style=\"mso-list: l0 level1 lfo2; tab-stops: list 36.0pt;\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Media Strategy, Corporate Communications, and Brand Management</span></li>\n<li class=\"MsoNormal\" style=\"mso-list: l0 level1 lfo2; tab-stops: list 36.0pt;\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">E-Governance, Public Relations, and Policy Innovation</span></li>\n<li class=\"MsoNormal\" style=\"mso-list: l0 level1 lfo2; tab-stops: list 36.0pt;\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Entrepreneurship and Innovation in Digital Platforms</span></li>\n</ul>\n<p class=\"MsoNormal\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">All manuscripts will undergo a <strong>rigorous double peer review</strong> and will be published at zero cost under our <strong>open access model</strong>, complete with DOI assignment and long-term digital archiving.</span></p>\n<p class=\"MsoNormal\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">We warmly invite you to contribute and also encourage you to share this invitation with your peers and research collaborators across disciplines.</span></p>\n<p class=\"MsoNormal\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">For submission guidelines or queries, please feel free to write to us. You can send the papers to the following email: <a href=\"mailto:research@tecnia.in\" target=\"_blank\" rel=\"noopener\">research@tecnia.in</a></span></p>\n<p class=\"MsoNormal\"><em><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\"> </span></em></p>\n<p class=\"MsoNormal\"><em><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Warm regards,<br><strong>Editorial Board</strong><br>Tecnia Journal of Management Studies<br>Tecnia Institute of Advanced Studies, Delhi</span></em></p>\n<p class=\"MsoNormal\"><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Email: <a href=\"mailto:research@tecnia.in\" target=\"_blank\" rel=\"noopener\">research@tecnia.in</a></span></p>\n<p class=\"MsoNormal\"><span lang=\"EN-US\" style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Segoe UI Emoji\',sans-serif; mso-bidi-font-family: \'Segoe UI Emoji\';\">'),(6,1,'hi','description',NULL),(7,1,'','image',NULL);
/*!40000 ALTER TABLE `announcement_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcement_type_settings`
--

DROP TABLE IF EXISTS `announcement_type_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `announcement_type_settings` (
  `announcement_type_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`announcement_type_setting_id`),
  UNIQUE KEY `announcement_type_settings_unique` (`type_id`,`locale`,`setting_name`),
  KEY `announcement_type_settings_type_id` (`type_id`),
  CONSTRAINT `announcement_type_settings_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `announcement_types` (`type_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about announcement types, including localized properties like their names.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcement_type_settings`
--

LOCK TABLES `announcement_type_settings` WRITE;
/*!40000 ALTER TABLE `announcement_type_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcement_type_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcement_types`
--

DROP TABLE IF EXISTS `announcement_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `announcement_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`type_id`),
  KEY `announcement_types_context_id` (`context_id`),
  CONSTRAINT `announcement_types_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Announcement types allow for announcements to optionally be categorized.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcement_types`
--

LOCK TABLES `announcement_types` WRITE;
/*!40000 ALTER TABLE `announcement_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcement_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `announcements` (
  `announcement_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` smallint(6) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `type_id` bigint(20) DEFAULT NULL,
  `date_expire` date DEFAULT NULL,
  `date_posted` datetime NOT NULL,
  PRIMARY KEY (`announcement_id`),
  KEY `announcements_type_id` (`type_id`),
  KEY `announcements_assoc` (`assoc_type`,`assoc_id`),
  CONSTRAINT `announcements_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `announcement_types` (`type_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Announcements are messages that can be presented to users e.g. on the homepage.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` (`announcement_id`, `assoc_type`, `assoc_id`, `type_id`, `date_expire`, `date_posted`) VALUES (1,256,NULL,NULL,NULL,'2025-06-25 12:17:47');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `author_affiliation_settings`
--

DROP TABLE IF EXISTS `author_affiliation_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `author_affiliation_settings` (
  `author_affiliation_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `author_affiliation_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`author_affiliation_setting_id`),
  UNIQUE KEY `author_affiliation_settings_unique` (`author_affiliation_id`,`locale`,`setting_name`),
  CONSTRAINT `author_affiliation_settings_author_affiliation_id_foreign` FOREIGN KEY (`author_affiliation_id`) REFERENCES `author_affiliations` (`author_affiliation_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about author affiliations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `author_affiliation_settings`
--

LOCK TABLES `author_affiliation_settings` WRITE;
/*!40000 ALTER TABLE `author_affiliation_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `author_affiliation_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `author_affiliations`
--

DROP TABLE IF EXISTS `author_affiliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `author_affiliations` (
  `author_affiliation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `author_id` bigint(20) NOT NULL,
  `ror` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`author_affiliation_id`),
  KEY `author_affiliations_ror` (`ror`),
  KEY `author_affiliations_author_id_foreign` (`author_id`),
  CONSTRAINT `author_affiliations_author_id_foreign` FOREIGN KEY (`author_id`) REFERENCES `authors` (`author_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Author affiliations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `author_affiliations`
--

LOCK TABLES `author_affiliations` WRITE;
/*!40000 ALTER TABLE `author_affiliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `author_affiliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `author_settings`
--

DROP TABLE IF EXISTS `author_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `author_settings` (
  `author_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `author_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`author_setting_id`),
  UNIQUE KEY `author_settings_unique` (`author_id`,`locale`,`setting_name`),
  KEY `author_settings_author_id` (`author_id`),
  CONSTRAINT `author_settings_author_id` FOREIGN KEY (`author_id`) REFERENCES `authors` (`author_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='More data about authors, including localized properties such as their name and affiliation.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `author_settings`
--

LOCK TABLES `author_settings` WRITE;
/*!40000 ALTER TABLE `author_settings` DISABLE KEYS */;
INSERT INTO `author_settings` (`author_setting_id`, `author_id`, `locale`, `setting_name`, `setting_value`) VALUES (4,2,'en','biography',NULL),(5,2,'','country','IN'),(6,2,'en','familyName','Pradeep'),(7,2,'en','givenName','K.V'),(8,2,'en','preferredPublicName','Dr. K.V Pradeep'),(9,3,'en','biography','<p>Dr. Saurav Kumar is an assistant Professor</p>'),(10,3,'','country','IN'),(11,3,'en','familyName','Kumar'),(12,3,'en','givenName','Saurav'),(13,3,'en','preferredPublicName','Dr. Saurav Kumar');
/*!40000 ALTER TABLE `author_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authors`
--

DROP TABLE IF EXISTS `authors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authors` (
  `author_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(90) NOT NULL,
  `include_in_browse` smallint(6) NOT NULL DEFAULT '1',
  `publication_id` bigint(20) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `user_group_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`author_id`),
  KEY `authors_user_group_id` (`user_group_id`),
  KEY `authors_publication_id` (`publication_id`),
  CONSTRAINT `authors_publication_id_foreign` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE,
  CONSTRAINT `authors_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='The authors of a publication.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authors`
--

LOCK TABLES `authors` WRITE;
/*!40000 ALTER TABLE `authors` DISABLE KEYS */;
INSERT INTO `authors` (`author_id`, `email`, `include_in_browse`, `publication_id`, `seq`, `user_group_id`) VALUES (2,'Pradeepkv@gmail.com',1,2,0,32),(3,'sk@gmail.com',1,4,0,32);
/*!40000 ALTER TABLE `authors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) DEFAULT NULL,
  `path` varchar(255) NOT NULL,
  `image` text,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `category_path` (`context_id`,`path`),
  KEY `category_context_id` (`context_id`),
  KEY `category_context_parent_id` (`context_id`,`parent_id`),
  KEY `category_parent_id` (`parent_id`),
  CONSTRAINT `categories_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `categories_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `categories` (`category_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Categories permit the organization of submissions into a heirarchical structure.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category_settings`
--

DROP TABLE IF EXISTS `category_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `category_settings` (
  `category_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`category_setting_id`),
  UNIQUE KEY `category_settings_unique` (`category_id`,`locale`,`setting_name`),
  KEY `category_settings_category_id` (`category_id`),
  CONSTRAINT `category_settings_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about categories, including localized properties such as names.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category_settings`
--

LOCK TABLES `category_settings` WRITE;
/*!40000 ALTER TABLE `category_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `category_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `citation_settings`
--

DROP TABLE IF EXISTS `citation_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `citation_settings` (
  `citation_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `citation_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`citation_setting_id`),
  UNIQUE KEY `citation_settings_unique` (`citation_id`,`locale`,`setting_name`),
  KEY `citation_settings_citation_id` (`citation_id`),
  CONSTRAINT `citation_settings_citation_id` FOREIGN KEY (`citation_id`) REFERENCES `citations` (`citation_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Additional data about citations, including localized content.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `citation_settings`
--

LOCK TABLES `citation_settings` WRITE;
/*!40000 ALTER TABLE `citation_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `citation_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `citations`
--

DROP TABLE IF EXISTS `citations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `citations` (
  `citation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `raw_citation` text NOT NULL,
  `seq` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`citation_id`),
  UNIQUE KEY `citations_publication_seq` (`publication_id`,`seq`),
  KEY `citations_publication` (`publication_id`),
  CONSTRAINT `citations_publication` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A citation made by an associated publication.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `citations`
--

LOCK TABLES `citations` WRITE;
/*!40000 ALTER TABLE `citations` DISABLE KEYS */;
/*!40000 ALTER TABLE `citations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `completed_payments`
--

DROP TABLE IF EXISTS `completed_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `completed_payments` (
  `completed_payment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `payment_type` bigint(20) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `amount` decimal(8,2) unsigned NOT NULL,
  `currency_code_alpha` varchar(3) DEFAULT NULL,
  `payment_method_plugin_name` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`completed_payment_id`),
  KEY `completed_payments_context_id` (`context_id`),
  KEY `completed_payments_user_id` (`user_id`),
  CONSTRAINT `completed_payments_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `completed_payments_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of completed (fulfilled) payments relating to a payment type such as a subscription payment.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `completed_payments`
--

LOCK TABLES `completed_payments` WRITE;
/*!40000 ALTER TABLE `completed_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `completed_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `controlled_vocab_entries`
--

DROP TABLE IF EXISTS `controlled_vocab_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `controlled_vocab_entries` (
  `controlled_vocab_entry_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `controlled_vocab_id` bigint(20) NOT NULL,
  `seq` double DEFAULT NULL,
  PRIMARY KEY (`controlled_vocab_entry_id`),
  KEY `controlled_vocab_entries_controlled_vocab_id` (`controlled_vocab_id`),
  KEY `controlled_vocab_entries_cv_id` (`controlled_vocab_id`,`seq`),
  CONSTRAINT `controlled_vocab_entries_controlled_vocab_id_foreign` FOREIGN KEY (`controlled_vocab_id`) REFERENCES `controlled_vocabs` (`controlled_vocab_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COMMENT='The order that a word or phrase used in a controlled vocabulary should appear. For example, the order of keywords in a publication.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `controlled_vocab_entries`
--

LOCK TABLES `controlled_vocab_entries` WRITE;
/*!40000 ALTER TABLE `controlled_vocab_entries` DISABLE KEYS */;
INSERT INTO `controlled_vocab_entries` (`controlled_vocab_entry_id`, `controlled_vocab_id`, `seq`) VALUES (25,6,1),(26,6,2),(27,6,3),(36,14,1),(37,14,2);
/*!40000 ALTER TABLE `controlled_vocab_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `controlled_vocab_entry_settings`
--

DROP TABLE IF EXISTS `controlled_vocab_entry_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `controlled_vocab_entry_settings` (
  `controlled_vocab_entry_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `controlled_vocab_entry_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`controlled_vocab_entry_setting_id`),
  UNIQUE KEY `c_v_e_s_pkey` (`controlled_vocab_entry_id`,`locale`,`setting_name`),
  KEY `c_v_e_s_entry_id` (`controlled_vocab_entry_id`),
  CONSTRAINT `c_v_e_s_entry_id` FOREIGN KEY (`controlled_vocab_entry_id`) REFERENCES `controlled_vocab_entries` (`controlled_vocab_entry_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COMMENT='More data about a controlled vocabulary entry, including localized properties such as the actual word or phrase.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `controlled_vocab_entry_settings`
--

LOCK TABLES `controlled_vocab_entry_settings` WRITE;
/*!40000 ALTER TABLE `controlled_vocab_entry_settings` DISABLE KEYS */;
INSERT INTO `controlled_vocab_entry_settings` (`controlled_vocab_entry_setting_id`, `controlled_vocab_entry_id`, `locale`, `setting_name`, `setting_value`) VALUES (25,25,'en','name','Human Capital'),(26,26,'en','name','Artificial Intelligence'),(27,27,'en','name','Human Resource Management'),(36,36,'en','name','Advertising'),(37,37,'en','name','Television Commercial');
/*!40000 ALTER TABLE `controlled_vocab_entry_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `controlled_vocabs`
--

DROP TABLE IF EXISTS `controlled_vocabs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `controlled_vocabs` (
  `controlled_vocab_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(64) NOT NULL,
  `assoc_type` bigint(20) NOT NULL DEFAULT '0',
  `assoc_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`controlled_vocab_id`),
  UNIQUE KEY `controlled_vocab_symbolic` (`symbolic`,`assoc_type`,`assoc_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='Every word or phrase used in a controlled vocabulary. Controlled vocabularies are used for submission metadata like keywords and subjects, reviewer interests, and wherever a similar dictionary of words or phrases is required. Each entry corresponds to a word or phrase like "cellular reproduction" and a type like "submissionKeyword".';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `controlled_vocabs`
--

LOCK TABLES `controlled_vocabs` WRITE;
/*!40000 ALTER TABLE `controlled_vocabs` DISABLE KEYS */;
INSERT INTO `controlled_vocabs` (`controlled_vocab_id`, `symbolic`, `assoc_type`, `assoc_id`) VALUES (1,'interest',0,NULL),(9,'submissionAgency',1048588,2),(13,'submissionAgency',1048588,3),(17,'submissionAgency',1048588,4),(8,'submissionDiscipline',1048588,2),(12,'submissionDiscipline',1048588,3),(16,'submissionDiscipline',1048588,4),(6,'submissionKeyword',1048588,2),(10,'submissionKeyword',1048588,3),(14,'submissionKeyword',1048588,4),(7,'submissionSubject',1048588,2),(11,'submissionSubject',1048588,3),(15,'submissionSubject',1048588,4);
/*!40000 ALTER TABLE `controlled_vocabs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `custom_issue_orders`
--

DROP TABLE IF EXISTS `custom_issue_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custom_issue_orders` (
  `custom_issue_order_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `journal_id` bigint(20) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`custom_issue_order_id`),
  UNIQUE KEY `custom_issue_orders_unique` (`issue_id`),
  KEY `custom_issue_orders_issue_id` (`issue_id`),
  KEY `custom_issue_orders_journal_id` (`journal_id`),
  CONSTRAINT `custom_issue_orders_issue_id` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE,
  CONSTRAINT `custom_issue_orders_journal_id` FOREIGN KEY (`journal_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Ordering information for the issue list, when custom issue ordering is specified.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `custom_issue_orders`
--

LOCK TABLES `custom_issue_orders` WRITE;
/*!40000 ALTER TABLE `custom_issue_orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_issue_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `custom_section_orders`
--

DROP TABLE IF EXISTS `custom_section_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custom_section_orders` (
  `custom_section_order_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `section_id` bigint(20) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`custom_section_order_id`),
  UNIQUE KEY `custom_section_orders_unique` (`issue_id`,`section_id`),
  KEY `custom_section_orders_issue_id` (`issue_id`),
  KEY `custom_section_orders_section_id` (`section_id`),
  CONSTRAINT `custom_section_orders_issue_id` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE,
  CONSTRAINT `custom_section_orders_section_id` FOREIGN KEY (`section_id`) REFERENCES `sections` (`section_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Ordering information for sections within issues, when issue-specific section ordering is specified.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `custom_section_orders`
--

LOCK TABLES `custom_section_orders` WRITE;
/*!40000 ALTER TABLE `custom_section_orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_section_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_object_tombstone_oai_set_objects`
--

DROP TABLE IF EXISTS `data_object_tombstone_oai_set_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_object_tombstone_oai_set_objects` (
  `object_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tombstone_id` bigint(20) NOT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  PRIMARY KEY (`object_id`),
  KEY `data_object_tombstone_oai_set_objects_tombstone_id` (`tombstone_id`),
  CONSTRAINT `data_object_tombstone_oai_set_objects_tombstone_id` FOREIGN KEY (`tombstone_id`) REFERENCES `data_object_tombstones` (`tombstone_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relationships between tombstones and other data that can be collected in OAI sets, e.g. sections.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_object_tombstone_oai_set_objects`
--

LOCK TABLES `data_object_tombstone_oai_set_objects` WRITE;
/*!40000 ALTER TABLE `data_object_tombstone_oai_set_objects` DISABLE KEYS */;
/*!40000 ALTER TABLE `data_object_tombstone_oai_set_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_object_tombstone_settings`
--

DROP TABLE IF EXISTS `data_object_tombstone_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_object_tombstone_settings` (
  `tombstone_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tombstone_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`tombstone_setting_id`),
  UNIQUE KEY `data_object_tombstone_settings_unique` (`tombstone_id`,`locale`,`setting_name`),
  KEY `data_object_tombstone_settings_tombstone_id` (`tombstone_id`),
  CONSTRAINT `data_object_tombstone_settings_tombstone_id` FOREIGN KEY (`tombstone_id`) REFERENCES `data_object_tombstones` (`tombstone_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about data object tombstones, including localized content.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_object_tombstone_settings`
--

LOCK TABLES `data_object_tombstone_settings` WRITE;
/*!40000 ALTER TABLE `data_object_tombstone_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `data_object_tombstone_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_object_tombstones`
--

DROP TABLE IF EXISTS `data_object_tombstones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_object_tombstones` (
  `tombstone_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `data_object_id` bigint(20) NOT NULL,
  `date_deleted` datetime NOT NULL,
  `set_spec` varchar(255) NOT NULL,
  `set_name` varchar(255) NOT NULL,
  `oai_identifier` varchar(255) NOT NULL,
  PRIMARY KEY (`tombstone_id`),
  KEY `data_object_tombstones_data_object_id` (`data_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Entries for published data that has been removed. Usually used in the OAI endpoint.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_object_tombstones`
--

LOCK TABLES `data_object_tombstones` WRITE;
/*!40000 ALTER TABLE `data_object_tombstones` DISABLE KEYS */;
/*!40000 ALTER TABLE `data_object_tombstones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `doi_settings`
--

DROP TABLE IF EXISTS `doi_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `doi_settings` (
  `doi_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `doi_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`doi_setting_id`),
  UNIQUE KEY `doi_settings_unique` (`doi_id`,`locale`,`setting_name`),
  KEY `doi_settings_doi_id` (`doi_id`),
  CONSTRAINT `doi_settings_doi_id_foreign` FOREIGN KEY (`doi_id`) REFERENCES `dois` (`doi_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about DOIs, including the registration agency.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `doi_settings`
--

LOCK TABLES `doi_settings` WRITE;
/*!40000 ALTER TABLE `doi_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `doi_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dois`
--

DROP TABLE IF EXISTS `dois`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dois` (
  `doi_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `doi` varchar(255) NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`doi_id`),
  KEY `dois_context_id` (`context_id`),
  CONSTRAINT `dois_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores all DOIs used in the system.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dois`
--

LOCK TABLES `dois` WRITE;
/*!40000 ALTER TABLE `dois` DISABLE KEYS */;
/*!40000 ALTER TABLE `dois` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `edit_decisions`
--

DROP TABLE IF EXISTS `edit_decisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `edit_decisions` (
  `edit_decision_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `review_round_id` bigint(20) DEFAULT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  `round` smallint(6) DEFAULT NULL,
  `editor_id` bigint(20) NOT NULL,
  `decision` smallint(6) NOT NULL COMMENT 'A numeric constant indicating the decision that was taken. Possible values are listed in the Decision class.',
  `date_decided` datetime NOT NULL,
  PRIMARY KEY (`edit_decision_id`),
  KEY `edit_decisions_submission_id` (`submission_id`),
  KEY `edit_decisions_editor_id` (`editor_id`),
  KEY `edit_decisions_review_round_id` (`review_round_id`),
  CONSTRAINT `edit_decisions_editor_id` FOREIGN KEY (`editor_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `edit_decisions_review_round_id_foreign` FOREIGN KEY (`review_round_id`) REFERENCES `review_rounds` (`review_round_id`) ON DELETE CASCADE,
  CONSTRAINT `edit_decisions_submission_id` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='Editorial decisions recorded on a submission, such as decisions to accept or decline the submission, as well as decisions to send for review, send to copyediting, request revisions, and more.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `edit_decisions`
--

LOCK TABLES `edit_decisions` WRITE;
/*!40000 ALTER TABLE `edit_decisions` DISABLE KEYS */;
INSERT INTO `edit_decisions` (`edit_decision_id`, `submission_id`, `review_round_id`, `stage_id`, `round`, `editor_id`, `decision`, `date_decided`) VALUES (1,2,NULL,1,NULL,6,17,'2025-06-25 14:10:30'),(2,2,NULL,4,NULL,6,7,'2025-06-25 14:10:48'),(3,4,NULL,1,NULL,6,17,'2025-06-25 16:20:30'),(4,4,NULL,4,NULL,6,7,'2025-06-25 16:21:44');
/*!40000 ALTER TABLE `edit_decisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_log`
--

DROP TABLE IF EXISTS `email_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `sender_id` bigint(20) DEFAULT NULL,
  `date_sent` datetime NOT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `from_address` varchar(255) DEFAULT NULL,
  `recipients` text,
  `cc_recipients` text,
  `bcc_recipients` text,
  `subject` varchar(255) DEFAULT NULL,
  `body` text,
  PRIMARY KEY (`log_id`),
  KEY `email_log_sender_id` (`sender_id`),
  KEY `email_log_assoc` (`assoc_type`,`assoc_id`),
  CONSTRAINT `email_log_sender_id_foreign` FOREIGN KEY (`sender_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='A record of email messages that are sent in relation to an associated entity, such as a submission.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_log`
--

LOCK TABLES `email_log` WRITE;
/*!40000 ALTER TABLE `email_log` DISABLE KEYS */;
INSERT INTO `email_log` (`log_id`, `assoc_type`, `assoc_id`, `sender_id`, `date_sent`, `event_type`, `from_address`, `recipients`, `cc_recipients`, `bcc_recipients`, `subject`, `body`) VALUES (1,1048585,2,NULL,'2025-06-25 14:08:47',805306370,'\"SB\" <sbahuguna.bciit@gmail.com>','\"bk bk\" <bk@gmail.com>','','','You have been assigned as an editor on a submission to Sb-Act-dy-ICTSample','<p>Dear bk bk,</p><p>The following submission has been assigned to you to see through the editorial process.</p><p><a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/en/dashboard/editorial?workflowSubmissionId=2\">Artificial Intelligence and Human Capital: A Review</a><br />Dr. K.V Pradeep</p><p><b>Abstract</b></p>\n\n\n\n<p><em>Artificial Intelligence (AI) has primarily impacted the global human capital. The human capital has been elucidated, focusing on their developing relationship with AI. The complex facets of human capital, including aptitude, proficiency, and competence, have been examined in this review, concentrating on the intricate association between AI and human capital. A secondary data analysis was conducted for this study, incorporating 16 studies that were meticulously chosen from online search engines. Key search words such as \"Human Capital and AI\" and \"AI and Human Resource Management\" were employed for collecting the articles. Compelling data was extracted from these articles to uncover the linkage between AI and human capital. The study yielded both affirmative and negative outcomes following a thorough review of articles. The research identified major concerns associated with AI-powered HR processes concerning bias, fairness, privacy, and security. It underscores the urgency for incorporating responsible AI practices and harnessing the potential of AI while mitigating risks and ensuring equitable human capital development. The connection between AI and human capital provides an invaluable resource for researchers, practitioners, and policymakers navigating the evolving landscape of workforce development in an era of AI-driven innovation.</em></p>\n\n\n\n\n<p> </p><p>If you find the submission to be relevant for Sb-Act-dy-ICTSample, please forward the submission to the review stage by selecting \"Send to Review\" and then assign reviewers by clicking \"Add Reviewer\".</p><p>If the submission is not appropriate for this journal, please decline the submission.</p><p>Thank you in advance.</p><p>Kind regards,</p><br><br>—<br><p>This is an automated message from <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample\">Sb-Act-dy-ICTSample</a>.</p>'),(2,1048585,2,NULL,'2025-06-25 14:08:47',805306373,'\"SB\" <sbahuguna.bciit@gmail.com>','\"tiasadmin tiasadmin\" <bahuguna.tias@gmail.com>','','','A new submission needs an editor to be assigned: \"Artificial Intelligence and Human Capital: A Review\"','<p>Dear tiasadmin tiasadmin,</p><p>The following submission has been submitted and there is no editor assigned.</p><p><a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/en/dashboard/editorial?workflowSubmissionId=2\">\"Artificial Intelligence and Human Capital: A Review\"</a><br />Dr. K.V Pradeep</p><p><b>Abstract</b></p>\n\n\n\n<p><em>Artificial Intelligence (AI) has primarily impacted the global human capital. The human capital has been elucidated, focusing on their developing relationship with AI. The complex facets of human capital, including aptitude, proficiency, and competence, have been examined in this review, concentrating on the intricate association between AI and human capital. A secondary data analysis was conducted for this study, incorporating 16 studies that were meticulously chosen from online search engines. Key search words such as \"Human Capital and AI\" and \"AI and Human Resource Management\" were employed for collecting the articles. Compelling data was extracted from these articles to uncover the linkage between AI and human capital. The study yielded both affirmative and negative outcomes following a thorough review of articles. The research identified major concerns associated with AI-powered HR processes concerning bias, fairness, privacy, and security. It underscores the urgency for incorporating responsible AI practices and harnessing the potential of AI while mitigating risks and ensuring equitable human capital development. The connection between AI and human capital provides an invaluable resource for researchers, practitioners, and policymakers navigating the evolving landscape of workforce development in an era of AI-driven innovation.</em></p>\n\n\n\n\n<p> </p><p>Please assign an editor who will be responsible for the submission by clicking the title above and assigning an editor under the Participants section.</p><hr><p>This is an automated email from <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/en\">Sb-Act-dy-ICTSample</a>.</p>'),(3,1048585,2,NULL,'2025-06-25 14:08:47',805306373,'\"SB\" <sbahuguna.bciit@gmail.com>','\"bk bk\" <bk@gmail.com>','','','A new submission needs an editor to be assigned: \"Artificial Intelligence and Human Capital: A Review\"','<p>Dear bk bk,</p><p>The following submission has been submitted and there is no editor assigned.</p><p><a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/en/dashboard/editorial?workflowSubmissionId=2\">\"Artificial Intelligence and Human Capital: A Review\"</a><br />Dr. K.V Pradeep</p><p><b>Abstract</b></p>\n\n\n\n<p><em>Artificial Intelligence (AI) has primarily impacted the global human capital. The human capital has been elucidated, focusing on their developing relationship with AI. The complex facets of human capital, including aptitude, proficiency, and competence, have been examined in this review, concentrating on the intricate association between AI and human capital. A secondary data analysis was conducted for this study, incorporating 16 studies that were meticulously chosen from online search engines. Key search words such as \"Human Capital and AI\" and \"AI and Human Resource Management\" were employed for collecting the articles. Compelling data was extracted from these articles to uncover the linkage between AI and human capital. The study yielded both affirmative and negative outcomes following a thorough review of articles. The research identified major concerns associated with AI-powered HR processes concerning bias, fairness, privacy, and security. It underscores the urgency for incorporating responsible AI practices and harnessing the potential of AI while mitigating risks and ensuring equitable human capital development. The connection between AI and human capital provides an invaluable resource for researchers, practitioners, and policymakers navigating the evolving landscape of workforce development in an era of AI-driven innovation.</em></p>\n\n\n\n\n<p> </p><p>Please assign an editor who will be responsible for the submission by clicking the title above and assigning an editor under the Participants section.</p><hr><p>This is an automated email from <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/en\">Sb-Act-dy-ICTSample</a>.</p>'),(4,1048585,2,NULL,'2025-06-25 14:08:47',536870914,'\"SB\" <sbahuguna.bciit@gmail.com>','\"Dr. K.V Pradeep\" <Pradeepkv@gmail.com>','','','Submission confirmation','<p>Dear Dr. K.V Pradeep,</p><p>You have been named as a co-author on a submission to Sb-Act-dy-ICTSample. The submitter, , provided the following details:</p><p>\"Artificial Intelligence and Human Capital: A Review\"<br></p><p>If any of these details are incorrect, or you do not wish to be named on this submission, please contact me.</p><p>Thank you for considering Sb-Act-dy-ICTSample as a venue for your work.</p><p>Kind regards,</p><br><br>—<br><p>This is an automated message from <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample\">Sb-Act-dy-ICTSample</a>.</p>'),(5,1048585,4,NULL,'2025-06-25 16:19:59',805306370,'\"SB\" <sbahuguna.bciit@gmail.com>','\"bk bk\" <bk@gmail.com>','','','You have been assigned as an editor on a submission to Sb-Act-dy-ICTSample','<p>Dear bk bk,</p><p>The following submission has been assigned to you to see through the editorial process.</p><p><a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/en/dashboard/editorial?workflowSubmissionId=4\">Changing face of Authority figures and Influencers in the new age : A Study of New Emerging Practices in the Indian Advertising Industry</a><br />Dr. Saurav Kumar</p><p><b>Abstract</b></p>\n\n\n\n<p>Advertising is the key focus because it plays a pivotal role at the junction where the economy and culture interact. Advertising trends have evolved from the quintessentially traditional print ads and TV spots to new marketing strategies that include QR codes, co-branding, content marketing and online advertising. While print and TV are steadfast in the ad industry, new technology is opening new avenues to reach consumers. India’s ad revenue is expected to grow by a subdued 12% to .3 billion in 2023, according to a report by advertising agency GroupM. In marketing, authority figures can have a significant influence on customer decisions. Endorsements from celebrities, experts, or even satisfied customers can add credibility to a product or service. This can lead to increased sales and brand loyalty. Moreover, Influencer collaboration has moved beyond the status of merely being an improvement in the dynamic world of modern marketing, and has instead established itself as a crucial component of a well-planned marketing strategy. Leading organizations now assign particular budgets designed for influencer marketing campaigns in an effort to stay at the very forefront of industry trends. Every firm appears to be eager to utilize influencer marketing to its fullest potential as the market matures and changes. <em>The research aims to propose an in-depth review on the strategic change happening in the Indian advertising industry in relation to the use of authority figures and influencers for promotional activities.</em></p>\n<p> </p>\n\n\n\n\n<p> </p><p>If you find the submission to be relevant for Sb-Act-dy-ICTSample, please forward the submission to the review stage by selecting \"Send to Review\" and then assign reviewers by clicking \"Add Reviewer\".</p><p>If the submission is not appropriate for this journal, please decline the submission.</p><p>Thank you in advance.</p><p>Kind regards,</p><br><br>—<br><p>This is an automated message from <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample\">Sb-Act-dy-ICTSample</a>.</p>'),(6,1048585,4,NULL,'2025-06-25 16:19:59',805306373,'\"SB\" <sbahuguna.bciit@gmail.com>','\"tiasadmin tiasadmin\" <bahuguna.tias@gmail.com>','','','A new submission needs an editor to be assigned: \"Changing face of Authority figures and Influencers in the new age : A Study of New Emerging Practices in the Indian Advertising Industry\"','<p>Dear tiasadmin tiasadmin,</p><p>The following submission has been submitted and there is no editor assigned.</p><p><a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/en/dashboard/editorial?workflowSubmissionId=4\">\"Changing face of Authority figures and Influencers in the new age : A Study of New Emerging Practices in the Indian Advertising Industry\"</a><br />Dr. Saurav Kumar</p><p><b>Abstract</b></p>\n\n\n\n<p>Advertising is the key focus because it plays a pivotal role at the junction where the economy and culture interact. Advertising trends have evolved from the quintessentially traditional print ads and TV spots to new marketing strategies that include QR codes, co-branding, content marketing and online advertising. While print and TV are steadfast in the ad industry, new technology is opening new avenues to reach consumers. India’s ad revenue is expected to grow by a subdued 12% to .3 billion in 2023, according to a report by advertising agency GroupM. In marketing, authority figures can have a significant influence on customer decisions. Endorsements from celebrities, experts, or even satisfied customers can add credibility to a product or service. This can lead to increased sales and brand loyalty. Moreover, Influencer collaboration has moved beyond the status of merely being an improvement in the dynamic world of modern marketing, and has instead established itself as a crucial component of a well-planned marketing strategy. Leading organizations now assign particular budgets designed for influencer marketing campaigns in an effort to stay at the very forefront of industry trends. Every firm appears to be eager to utilize influencer marketing to its fullest potential as the market matures and changes. <em>The research aims to propose an in-depth review on the strategic change happening in the Indian advertising industry in relation to the use of authority figures and influencers for promotional activities.</em></p>\n<p> </p>\n\n\n\n\n<p> </p><p>Please assign an editor who will be responsible for the submission by clicking the title above and assigning an editor under the Participants section.</p><hr><p>This is an automated email from <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/en\">Sb-Act-dy-ICTSample</a>.</p>'),(7,1048585,4,NULL,'2025-06-25 16:19:59',805306373,'\"SB\" <sbahuguna.bciit@gmail.com>','\"bk bk\" <bk@gmail.com>','','','A new submission needs an editor to be assigned: \"Changing face of Authority figures and Influencers in the new age : A Study of New Emerging Practices in the Indian Advertising Industry\"','<p>Dear bk bk,</p><p>The following submission has been submitted and there is no editor assigned.</p><p><a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/en/dashboard/editorial?workflowSubmissionId=4\">\"Changing face of Authority figures and Influencers in the new age : A Study of New Emerging Practices in the Indian Advertising Industry\"</a><br />Dr. Saurav Kumar</p><p><b>Abstract</b></p>\n\n\n\n<p>Advertising is the key focus because it plays a pivotal role at the junction where the economy and culture interact. Advertising trends have evolved from the quintessentially traditional print ads and TV spots to new marketing strategies that include QR codes, co-branding, content marketing and online advertising. While print and TV are steadfast in the ad industry, new technology is opening new avenues to reach consumers. India’s ad revenue is expected to grow by a subdued 12% to .3 billion in 2023, according to a report by advertising agency GroupM. In marketing, authority figures can have a significant influence on customer decisions. Endorsements from celebrities, experts, or even satisfied customers can add credibility to a product or service. This can lead to increased sales and brand loyalty. Moreover, Influencer collaboration has moved beyond the status of merely being an improvement in the dynamic world of modern marketing, and has instead established itself as a crucial component of a well-planned marketing strategy. Leading organizations now assign particular budgets designed for influencer marketing campaigns in an effort to stay at the very forefront of industry trends. Every firm appears to be eager to utilize influencer marketing to its fullest potential as the market matures and changes. <em>The research aims to propose an in-depth review on the strategic change happening in the Indian advertising industry in relation to the use of authority figures and influencers for promotional activities.</em></p>\n<p> </p>\n\n\n\n\n<p> </p><p>Please assign an editor who will be responsible for the submission by clicking the title above and assigning an editor under the Participants section.</p><hr><p>This is an automated email from <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/en\">Sb-Act-dy-ICTSample</a>.</p>'),(8,1048585,4,NULL,'2025-06-25 16:19:59',536870914,'\"SB\" <sbahuguna.bciit@gmail.com>','\"Dr. Saurav Kumar\" <sk@gmail.com>','','','Submission confirmation','<p>Dear Dr. Saurav Kumar,</p><p>You have been named as a co-author on a submission to Sb-Act-dy-ICTSample. The submitter, , provided the following details:</p><p>\"Changing face of Authority figures and Influencers in the new age : A Study of New Emerging Practices in the Indian Advertising Industry\"<br></p><p>If any of these details are incorrect, or you do not wish to be named on this submission, please contact me.</p><p>Thank you for considering Sb-Act-dy-ICTSample as a venue for your work.</p><p>Kind regards,</p><br><br>—<br><p>This is an automated message from <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample\">Sb-Act-dy-ICTSample</a>.</p>');
/*!40000 ALTER TABLE `email_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_log_users`
--

DROP TABLE IF EXISTS `email_log_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_log_users` (
  `email_log_user_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_log_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`email_log_user_id`),
  UNIQUE KEY `email_log_user_id` (`email_log_id`,`user_id`),
  KEY `email_log_users_email_log_id` (`email_log_id`),
  KEY `email_log_users_user_id` (`user_id`),
  CONSTRAINT `email_log_users_email_log_id_foreign` FOREIGN KEY (`email_log_id`) REFERENCES `email_log` (`log_id`) ON DELETE CASCADE,
  CONSTRAINT `email_log_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='A record of users associated with an email log entry.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_log_users`
--

LOCK TABLES `email_log_users` WRITE;
/*!40000 ALTER TABLE `email_log_users` DISABLE KEYS */;
INSERT INTO `email_log_users` (`email_log_user_id`, `email_log_id`, `user_id`) VALUES (1,1,6),(2,2,1),(3,3,6),(4,5,6),(5,6,1),(6,7,6);
/*!40000 ALTER TABLE `email_log_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_templates`
--

DROP TABLE IF EXISTS `email_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_templates` (
  `email_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) NOT NULL COMMENT 'Unique identifier for this email.',
  `context_id` bigint(20) NOT NULL,
  `alternate_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`email_id`),
  UNIQUE KEY `email_templates_email_key` (`email_key`,`context_id`),
  KEY `email_templates_context_id` (`context_id`),
  KEY `email_templates_alternate_to` (`alternate_to`),
  CONSTRAINT `email_templates_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='Custom email templates created by each context, and overrides of the default templates.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_templates`
--

LOCK TABLES `email_templates` WRITE;
/*!40000 ALTER TABLE `email_templates` DISABLE KEYS */;
INSERT INTO `email_templates` (`email_id`, `email_key`, `context_id`, `alternate_to`) VALUES (1,'COPYEDIT_REQUEST',1,'DISCUSSION_NOTIFICATION_COPYEDITING'),(2,'EDITOR_ASSIGN_SUBMISSION',1,'DISCUSSION_NOTIFICATION_SUBMISSION'),(3,'EDITOR_ASSIGN_REVIEW',1,'DISCUSSION_NOTIFICATION_REVIEW'),(4,'EDITOR_ASSIGN_PRODUCTION',1,'DISCUSSION_NOTIFICATION_PRODUCTION'),(5,'LAYOUT_REQUEST',1,'DISCUSSION_NOTIFICATION_PRODUCTION'),(6,'LAYOUT_COMPLETE',1,'DISCUSSION_NOTIFICATION_PRODUCTION'),(7,'COPYEDIT_REQUEST',2,'DISCUSSION_NOTIFICATION_COPYEDITING'),(8,'EDITOR_ASSIGN_SUBMISSION',2,'DISCUSSION_NOTIFICATION_SUBMISSION'),(9,'EDITOR_ASSIGN_REVIEW',2,'DISCUSSION_NOTIFICATION_REVIEW'),(10,'EDITOR_ASSIGN_PRODUCTION',2,'DISCUSSION_NOTIFICATION_PRODUCTION'),(11,'LAYOUT_REQUEST',2,'DISCUSSION_NOTIFICATION_PRODUCTION'),(12,'LAYOUT_COMPLETE',2,'DISCUSSION_NOTIFICATION_PRODUCTION');
/*!40000 ALTER TABLE `email_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_templates_default_data`
--

DROP TABLE IF EXISTS `email_templates_default_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_templates_default_data` (
  `email_templates_default_data_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) NOT NULL COMMENT 'Unique identifier for this email.',
  `locale` varchar(28) NOT NULL DEFAULT 'en',
  `name` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text,
  PRIMARY KEY (`email_templates_default_data_id`),
  UNIQUE KEY `email_templates_default_data_unique` (`email_key`,`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=146 DEFAULT CHARSET=utf8 COMMENT='Default email templates created for every installed locale.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_templates_default_data`
--

LOCK TABLES `email_templates_default_data` WRITE;
/*!40000 ALTER TABLE `email_templates_default_data` DISABLE KEYS */;
INSERT INTO `email_templates_default_data` (`email_templates_default_data_id`, `email_key`, `locale`, `name`, `subject`, `body`) VALUES (1,'PASSWORD_RESET_CONFIRM','en','Password Reset Confirm','Password Reset Confirmation','We have received a request to reset your password for the {$siteTitle} web site.<br />\n<br />\nIf you did not make this request, please ignore this email and your password will not be changed. If you wish to reset your password, click on the below URL.<br />\n<br />\nReset my password: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),(2,'PASSWORD_RESET_CONFIRM','hi','','पासवर्ड रीसेट पुष्टि','हमें {$siteTitle} वेब साइट के लिए आपका पासवर्ड रीसेट करने का अनुरोध मिला है.<br />\n<br />\nयदि आपने यह अनुरोध नहीं किया है, तो कृपया इस ईमेल को अनदेखा करें और आपका पासवर्ड परिवर्तित नहीं किया जाएगा। यदि आप अपना पासवर्ड रीसेट करना चाहते हैं, तो नीचे दिए गए URL पर क्लिक करें.<br />\n<br />\nReset my password: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),(3,'USER_REGISTER','en','User Created','Journal Registration','{$recipientName}<br />\n<br />\nYou have now been registered as a user with {$journalName}. We have included your username and password in this email, which are needed for all work with this journal through its website. At any point, you can ask to be removed from the journal\'s list of users by contacting me.<br />\n<br />\nUsername: {$recipientUsername}<br />\nPassword: {$password}<br />\n<br />\nThank you,<br />\n{$signature}'),(4,'USER_REGISTER','hi','','जर्नल पंजीकरण','{$recipientName}<br />\n<br />\nअब आपको {$journalName} वाले उपयोगकर्ता के रूप में पंजीकृत किया गया है। हमने इस ईमेल में आपके उपयोगकर्ता नाम और पासवर्ड को शामिल किया है, जो इस वेबसाइट के माध्यम से इस जर्नल के साथ काम करने के लिए आवश्यक हैं। किसी भी बिंदु पर, आप मुझसे संपर्क करके जर्नल की उपयोगकर्ताओं की सूची से निकाले जाने के लिए कह सकते हैं.<br />\n<br />\nUsername: {$recipientUsername}<br />\nPassword: {$password}<br />\n<br />\nThank you,<br />\n{$signature}'),(5,'USER_VALIDATE_CONTEXT','en','Validate Email (Journal Registration)','Validate Your Account','{$recipientName}<br />\n<br />\nYou have created an account with {$journalName}, but before you can start using it, you need to validate your email account. To do this, simply follow the link below:<br />\n<br />\n{$activateUrl}<br />\n<br />\nThank you,<br />\n{$journalSignature}'),(6,'USER_VALIDATE_CONTEXT','hi','','अपना खाता मान्य करें','{$recipientName}<br />\n<br />\nआपने {$journalName} के साथ एक खाता बनाया है, लेकिन इससे पहले कि आप इसका उपयोग शुरू कर सकें, आपको अपने ईमेल खाते को मान्य करना होगा। ऐसा करने के लिए, बस नीचे दिए गए लिंक का पालन करें:<br />\n<br />\n{$activateUrl}<br />\n<br />\nThank you,<br />\n{$journalSignature}'),(7,'USER_VALIDATE_SITE','en','Validate Email (Site)','Validate Your Account','{$recipientName}<br />\n<br />\nYou have created an account with {$siteTitle}, but before you can start using it, you need to validate your email account. To do this, simply follow the link below:<br />\n<br />\n{$activateUrl}<br />\n<br />\nThank you,<br />\n{$siteSignature}'),(8,'USER_VALIDATE_SITE','hi','','',''),(9,'REVIEWER_REGISTER','en','Reviewer Register','Registration as Reviewer with {$journalName}','<p>Dear {$recipientName},</p><p>In light of your expertise, we have registered your name in the reviewer database for {$journalName}. This does not entail any form of commitment on your part, but simply enables us to approach you with a submission to possibly review. On being invited to review, you will have an opportunity to see the title and abstract of the paper in question, and you\'ll always be in a position to accept or decline the invitation. You can also ask at any point to have your name removed from this reviewer list.</p><p>We are providing you with a username and password, which is used in all interactions with the journal through its website. You may wish, for example, to update your profile, including your reviewing interests.</p><p>Username: {$recipientUsername}<br />Password: {$password}</p><p>Thank you,</p>{$signature}'),(10,'REVIEWER_REGISTER','hi','','{$journalName}के साथ समीक्षक के रूप में पंजीकरण','आपकी विशेषज्ञता के प्रकाश में, हमने {$journalName} के लिए समीक्षक डेटाबेस में आपका नाम दर्ज करने की स्वतंत्रता ले ली है। यह आपकी ओर से किसी भी प्रकार की प्रतिबद्धता को पूरा नहीं करता है, लेकिन संभवतया समीक्षा के लिए प्रस्तुत करने के लिए बस हमें आपसे संपर्क करने में सक्षम बनाता है। समीक्षा के लिए आमंत्रित किए जाने पर, आपके पास प्रश्न में कागज का शीर्षक और सार देखने का अवसर होगा, और आप हमेशा आमंत्रण को स्वीकार या अस्वीकार करने की स्थिति में होंगे। आप किसी भी बिंदु पर इस समीक्षक सूची से अपना नाम हटाने के लिए कह सकते हैं.<br />\n<br />\nहम आपको एक उपयोगकर्ता नाम और पासवर्ड प्रदान कर रहे हैं, जो अपनी वेबसाइट के माध्यम से जर्नल के साथ सभी बातचीत में उपयोग किया जाता है। उदाहरण के लिए, आप अपनी समीक्षा हितों सहित अपनी प्रोफ़ाइल को अपडेट कर सकते हैं.<br />\n<br />\nUsername: {$recipientUsername}<br />\nPassword: {$password}<br />\n<br />\nThank you,<br />\n{$signature}'),(11,'ISSUE_PUBLISH_NOTIFY','en','Issue Published Notify','Just published: {$issueIdentification} of {$journalName}','<p>Dear {$recipientName},</p><p>We are pleased to announce the publication of <a href=\"{$issueUrl}\">{$issueIdentification}</a> of {$journalName}.  We invite you to read and share this work with your scholarly community.</p><p>Many thanks to our authors, reviewers, and editors for their valuable contributions, and to our readers for your continued interest.</p><div>{$issueToc}</div><p>Thank you,</p>{$signature}'),(12,'ISSUE_PUBLISH_NOTIFY','hi','','नया अंक प्रकाशित','Readers:<br />\n<br />\n{$journalName} ने अभी हाल ही में  {$journalUrl} पर अपना नवीनतम अंक प्रकाशित किया है। हम आपको यहां सामग्री की समीक्षा करने के लिए आमंत्रित करते हैं और फिर लेख और रुचि की वस्तुओं की समीक्षा करने के लिए हमारी वेब साइट पर जाते हैं.<br />\n<br />\nहमारे काम में निरंतर रुचि के लिए धन्यवाद,<br />\n{$signature}'),(13,'SUBMISSION_ACK','en','Submission Confirmation','Thank you for your submission to {$journalName}','<p>Dear {$recipientName},</p><p>Thank you for your submission to {$journalName}. We have received your submission, \"{$submissionTitle}\", and a member of our editorial team will see it soon. You will be sent an email when an initial decision is made, and we may contact you for further information.</p><p>You can view your submission and track its progress through the editorial process at the following location:</p><p>Submission URL: {$authorSubmissionUrl}</p><p>If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p><p>Thank you for considering {$journalName} as a venue for your work.</p>{$journalSignature}'),(14,'SUBMISSION_ACK','hi','','सबमिशन स्वीकृति','{$recipientName}:<br />\n<br />\nपांडुलिपि प्रस्तुत करने के लिए धन्यवाद, &quot;{$submissionTitle}&quot; to {$journalName}. जिस ऑनलाइन जर्नल प्रबंधन प्रणाली का हम उपयोग कर रहे हैं, आप जर्नल साइट पर लॉग इन करके संपादकीय प्रक्रिया के माध्यम से इसकी प्रगति को ट्रैक कर पाएंगे।:<br />\n<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$recipientUsername}<br />\n<br />\nयदि आपके पास किसी तरह का प्रश्न है, तो कृपया मुझ से सम्पर्क करें। अपने काम के लिए इस जर्नल को एक स्थान के रूप में विचार करने के लिए धन्यवाद.<br />\n<br />\n{$journalSignature}'),(15,'SUBMISSION_ACK_NOT_USER','en','Submission Confirmation (Other Authors)','Submission confirmation','<p>Dear {$recipientName},</p><p>You have been named as a co-author on a submission to {$journalName}. The submitter, {$submitterName}, provided the following details:</p><p>\"{$submissionTitle}\"<br>{$authorsWithAffiliation}</p><p>If any of these details are incorrect, or you do not wish to be named on this submission, please contact me.</p><p>Thank you for considering {$journalName} as a venue for your work.</p><p>Kind regards,</p>{$journalSignature}'),(16,'SUBMISSION_ACK_NOT_USER','hi','','सबमिशन स्वीकृति','Hello,<br />\n<br />\n{$submitterName} ने पांडुलिपि जमा की है, &quot;{$submissionTitle}&quot; to {$journalName}. <br />\n<br />\nयदि आपके पास किसी तरह का प्रश्न है, तो कृपया मुझ से सम्पर्क करें। अपने काम के लिए इस जर्नल को एक स्थान के रूप में विचार करने के लिए धन्यवाद.<br />\n<br />\n{$journalSignature}'),(17,'EDITOR_ASSIGN','en','Editor Assigned','You have been assigned as an editor on a submission to {$journalName}','<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the editorial process.</p><p><a href=\"{$submissionUrl}\">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>If you find the submission to be relevant for {$journalName}, please forward the submission to the review stage by selecting \"Send to Review\" and then assign reviewers by clicking \"Add Reviewer\".</p><p>If the submission is not appropriate for this journal, please decline the submission.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$journalSignature}'),(18,'EDITOR_ASSIGN','hi','','संपादकीय असाइनमेंट','{$recipientName}:<br />\n<br />\nप्रस्तुत, &quot;{$submissionTitle},&quot; to {$journalName} आपको सेक्शन एडिटर के रूप में अपनी भूमिका में संपादकीय प्रक्रिया के माध्यम से देखने का काम सौंपा गया है.<br />\n<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$recipientUsername}<br />\n<br />\nThank you.'),(19,'REVIEW_CANCEL','en','Reviewer Unassign','Request for Review Cancelled','<p>Dear {$recipientName},</p><p>Recently, we asked you to review a submission to {$journalName}. We have decided to cancel the request for you to reivew the submission, {$submissionTitle}.</p><p>We apologize any inconvenience this may cause you and hope that we will be able to call on you to assist with this journal\'s review process in the future.</p><p>If you have any questions, please contact me.</p>{$signature}'),(20,'REVIEW_CANCEL','hi','','समीक्षा रद्द करने का अनुरोध','{$recipientName}:<br />\n<br />\nहमने इस बिंदु पर निर्णय लिया है कि आप सबमिशन की समीक्षा करने के लिए हमारा अनुरोध रद्द कर दें, &quot;{$submissionTitle},&quot; for {$journalName}. हम आपसे किसी भी असुविधा के लिए क्षमा चाहते हैं और यह आशा करते हैं कि हम भविष्य में इस पत्रिका की समीक्षा प्रक्रिया में सहायता करने के लिए आपको कॉल कर सकेंगे।.<br />\n<br />\nयदि आपके पास किसी तरह का प्रश्न है, तो कृपया मुझ से सम्पर्क करें.'),(21,'REVIEW_REINSTATE','en','Reviewer Reinstate','Can you still review something for {$journalName}?','<p>Dear {$recipientName},</p><p>We recently cancelled our request for you to review a submission, {$submissionTitle}, for {$journalName}. We\'ve reversed that decision and we hope that you are still able to conduct the review.</p><p>If you are able to assist with this submission\'s review, you can <a href=\"{$reviewAssignmentUrl}\">login to the journal</a> to view the submission, upload review files, and submit your review request.</p><p>If you have any questions, please contact me.</p><p>Kind regards,</p>{$signature}'),(22,'REVIEW_REINSTATE','hi','','पुनर्स्थापना के लिए अनुरोध','{$recipientName}:<br />\n<br />\nहम आपके द्वारा प्रस्तुत समीक्षा की समीक्षा करने के लिए आपके अनुरोध को पुनः स्थापित करना चाहेंगे, &quot;{$submissionTitle},&quot; for {$journalName}. हमें उम्मीद है कि आप इस पत्रिका की समीक्षा प्रक्रिया में सहायता कर पाएंगे.<br />\n<br />\nयदि आपके पास किसी तरह का प्रश्न है, तो कृपया मुझ से सम्पर्क करें।'),(23,'REVIEW_RESEND_REQUEST','en','Resend Review Request to Reviewer','Requesting your review again for {$journalName}','<p>Dear {$recipientName},</p><p>Recently, you declined our request to review a submission, \"{$submissionTitle}\", for {$journalName}. I\'m writing to see if you are able to conduct the review after all.</p><p>We would be grateful if you\'re able to perform this review, but we understand if that is not possible at this time. Either way, please <a href=\"{$reviewAssignmentUrl}\">accept or decline the request</a> by {$responseDueDate}, so that we can find an alternate reviewer.</p><p>If you have any questions, please contact me.</p><p>Kind regards,</p>{$signature}'),(24,'REVIEW_RESEND_REQUEST','hi','','',''),(25,'REVIEW_REQUEST','en','Review Request','Invitation to review','<p>Dear {$recipientName},</p><p>I believe that you would serve as an excellent reviewer for a submission  to {$journalName}. The submission\'s title and abstract are below, and I hope that you will consider undertaking this important task for us.</p><p>If you are able to review this submission, your review is due by {$reviewDueDate}. You can view the submission, upload review files, and submit your review by logging into the journal site and following the steps at the link below.</p><p><a href=\"{$reviewAssignmentUrl}\">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please <a href=\"{$reviewAssignmentUrl}\">accept or decline</a> the review by <b>{$responseDueDate}</b>.</p><p>You may contact me with any questions about the submission or the review process.</p><p>Thank you for considering this request. Your help is much appreciated.</p><p>Kind regards,</p>{$signature}'),(26,'REVIEW_REQUEST','hi','','लेख समीक्षा का अनुरोध','{$recipientName}:<br />\n<br />\nमुझे विश्वास है कि आप पांडुलिपि के एक उत्कृष्ट समीक्षक के रूप में काम करेंगे, &quot;{$submissionTitle},&quot; जिसे {$journalName}को सबमिट किया गया है। सबमिशन का सार नीचे दिया गया है, और मुझे आशा है कि आप हमारे लिए इस महत्वपूर्ण कार्य को करने पर विचार करेंगे.<br />\n<br />\nकृपया जर्नल वेब साइट पर लॉग इन करें {$responseDueDate} यह इंगित करने के लिए कि क्या आप समीक्षा करेंगे या नहीं, साथ ही सबमिशन तक पहुँचने के लिए और अपनी समीक्षा और अनुशंसा दर्ज करने के लिए। वेब साइट है {$journalUrl}<br />\n<br />\nThe review itself is due {$reviewDueDate}.<br />\n<br />\nयदि आपके पास जर्नल की वेब साइट के लिए आपका उपयोगकर्ता नाम और पासवर्ड नहीं है, तो आप अपना पासवर्ड रीसेट करने के लिए इस लिंक का उपयोग कर सकते हैं (जो तब आपके उपयोगकर्ता नाम के साथ आपको ईमेल किया जाएगा). {$passwordLostUrl}<br />\n<br />\nSubmission URL: {$reviewAssignmentUrl}<br />\n<br />\nइस अनुरोध पर विचार करने के लिए धन्यवाद.<br />\n<br />\n{$signature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}'),(27,'REVIEW_REQUEST_SUBSEQUENT','en','Review Request Subsequent','Request to review a revised submission','<p>Dear {$recipientName},</p><p>Thank you for your review of <a href=\"{$reviewAssignmentUrl}\">{$submissionTitle}</a>. The authors have considered the reviewers\' feedback and have now submitted a revised version of their work. I\'m writing to ask if you would conduct a second round of peer review for this submission.</p><p>If you are able to review this submission, your review is due by {$reviewDueDate}. You can <a href=\"{$reviewAssignmentUrl}\">follow the review steps</a> to view the submission, upload review files, and submit your review comments.<p><p><a href=\"{$reviewAssignmentUrl}\">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please <a href=\"{$reviewAssignmentUrl}\">accept or decline</a> the review by <b>{$responseDueDate}</b>.</p><p>Please feel free to contact me with any questions about the submission or the review process.</p><p>Thank you for considering this request. Your help is much appreciated.</p><p>Kind regards,</p>{$signature}'),(28,'REVIEW_REQUEST_SUBSEQUENT','hi','','लेख समीक्षा का अनुरोध','{$recipientName}:<br />\n<br />\nयह पांडुलिपि का संबंध है &quot;{$submissionTitle},&quot; जो विचाराधीन है {$journalName}.<br />\n<br />\nपांडुलिपि के पिछले संस्करण की समीक्षा के बाद, लेखकों ने अब अपने पेपर का एक संशोधित संस्करण प्रस्तुत किया है। यदि आप इसका मूल्यांकन करने में मदद कर सकते हैं तो हम इसकी सराहना करेंगे.<br />\n<br />\nकृपया यह दिखाने के लिए कि क्या आप समीक्षा करेंगे या नहीं, साथ ही सबमिशन एक्सेस करने और अपनी समीक्षा और अनुशंसा दर्ज करने के लिए कृपया {$responseDueDate} द्वारा जर्नल वेब साइट पर लॉग इन करें। वेब साइट है {$journalUrl}<br />\n<br />\nसमीक्षा स्वयं होने वाली है{$reviewDueDate}.<br />\n<br />\nयदि आपके पास जर्नल की वेब साइट के लिए आपका उपयोगकर्ता नाम और पासवर्ड नहीं है, तो आप अपना पासवर्ड रीसेट करने के लिए इस लिंक का उपयोग कर सकते हैं (जो तब आपके उपयोगकर्ता नाम के साथ आपको ईमेल किया जाएगा). {$passwordLostUrl}<br />\n<br />\nसबमिशन URL: {$reviewAssignmentUrl}<br />\n<br />\nइस अनुरोध पर विचार करने के लिए धन्यवाद।<br />\n<br />\n{$signature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}'),(29,'REVIEW_RESPONSE_OVERDUE_AUTO','en','Review Response Overdue (Automated)','Will you be able to review this for us?','<p>Dear {$recipientName},</p><p>This email is an automated reminder from {$journalName} in regards to our request for your review of the submission, \"{$submissionTitle}.\"</p><p>You are receiving this email because we have not yet received a confirmation from you indicating whether or not you are able to undertake the review of this submission.</p><p>Please let us know whether or not you are able to undertake this review by using our submission management software to accept or decline this request.</p><p>If you are able to review this submission, your review is due by {$reviewDueDate}. You can follow the review steps to view the submission, upload review files, and submit your review comments.</p><p><a href=\"{$reviewAssignmentUrl}\">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please feel free to contact me with any questions about the submission or the review process.</p><p>Thank you for considering this request. Your help is much appreciated.</p><p>Kind regards,</p>{$journalSignature}'),(30,'REVIEW_RESPONSE_OVERDUE_AUTO','hi','','लेख समीक्षा का अनुरोध','{$recipientName}:<br />\nप्रस्तुत करने की आपकी समीक्षा के लिए हमारे अनुरोध का एक सौम्य अनुस्मारक, &quot;{$submissionTitle},&quot; for {$journalName}. हम {$ responseDueDate} द्वारा आपकी प्रतिक्रिया की उम्मीद कर रहे थे, और यह ईमेल स्वचालित रूप से जनरेट किया गया है और उस तारीख को पारित करने के साथ भेजा गया है.\n<br />\nमुझे विश्वास है कि आप पांडुलिपि के एक उत्कृष्ट समीक्षक के रूप में काम करेंगे। सबमिशन का सार नीचे दिया गया है, और मुझे आशा है कि आप हमारे लिए इस महत्वपूर्ण कार्य को करने पर विचार करेंगे.<br />\n<br />\nकृपया यह दर्शाने के लिए जर्नल वेब साइट पर लॉग इन करें कि क्या आप समीक्षा करेंगे या नहीं, साथ ही सबमिशन तक पहुँचने के लिए और अपनी समीक्षा और सिफारिश रिकॉर्ड करने के लिए। वेब साइट है {$journalUrl}<br />\n<br />\nसमीक्षा स्वयं होने वाली है {$reviewDueDate}.<br />\n<br />\nयदि आपके पास जर्नल की वेब साइट के लिए आपका उपयोगकर्ता नाम और पासवर्ड नहीं है, तो आप अपना पासवर्ड रीसेट करने के लिए इस लिंक का उपयोग कर सकते हैं (जो तब आपके उपयोगकर्ता नाम के साथ आपको ईमेल किया जाएगा). {$passwordLostUrl}<br />\n<br />\nSubmission URL: {$reviewAssignmentUrl}<br />\n<br />\nइस अनुरोध पर विचार करने के लिए धन्यवाद.<br />\n<br />\n{$journalSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}'),(31,'REVIEW_CONFIRM','en','Review Confirm','Review accepted: {$reviewerName} accepted review assignment for #{$submissionId} {$authorsShort} — \"{$submissionTitle}\"','<p>Dear {$recipientName},</p><p>{$reviewerName} has accepted the following review:</p><p><a href=\"{$submissionUrl}\">#{$submissionId} {$authorsShort} — \"{$submissionTitle}\"</a><br /><b>Type:</b> {$reviewMethod}</p><p><b>Review Due:</b> {$reviewDueDate}</p><p>Login to <a href=\"{$submissionUrl}\">view all reviewer assignments</a> for this submission.</p><br><br>—<br>This is an automated message from <a href=\"{$journalUrl}\">{$journalName}</a>.'),(32,'REVIEW_CONFIRM','hi','','समीक्षा करने में सक्षम','Editors:<br />\n<br />\nमैं सबमिशन की समीक्षा करने में सक्षम और तैयार हूं, &quot;{$submissionTitle},&quot; for {$journalName}. मेरे बारे में सोचने के लिए धन्यवाद, और मेरी योजना इसकी नियत तारीख, {$ reviewDueDate} से पूरी होने की है, अगर पहले नहीं.<br />\n<br />\n{$senderName}'),(33,'REVIEW_DECLINE','en','Review Decline','Unable to Review','Editors:<br />\n<br />\nI am afraid that at this time I am unable to review the submission, &quot;{$submissionTitle},&quot; for {$journalName}. Thank you for thinking of me, and another time feel free to call on me.<br />\n<br />\n{$senderName}'),(34,'REVIEW_DECLINE','hi','','समीक्षा करने में असमर्थ','Editors:<br />\n<br />\nमुझे डर है कि इस समय मैं सबमिशन की समीक्षा करने में असमर्थ हूं, &quot;{$submissionTitle},&quot; for {$journalName}. मुझे सोचने के लिए धन्यवाद, और एक और समय मुझे कॉल करने के लिए स्वतंत्र महसूस हो रहा है.<br />\n<br />\n{$senderName}'),(35,'REVIEW_ACK','en','Review Acknowledgement','Thank you for your review','<p>Dear {$recipientName},</p>\n<p>Thank you for completing your review of the submission, \"{$submissionTitle}\", for {$journalName}. We appreciate your time and expertise in contributing to the quality of the work that we publish.</p>\n<p>It has been a pleasure to work with you as a reviewer for {$journalName}, and we hope to have the opportunity to work with you again in the future.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>'),(36,'REVIEW_ACK','hi','','लेख समीक्षा आभार','{$recipientName}:<br />\n<br />\nसबमिशन की समीक्षा को पूरा करने के लिए धन्यवाद, &quot;{$submissionTitle},&quot; for {$journalName}. हम आपके द्वारा प्रकाशित किए जाने वाले कार्य की गुणवत्ता में आपके योगदान की सराहना करते हैं.'),(37,'REVIEW_REMIND','en','Review Reminder','A reminder to please complete your review','<p>Dear {$recipientName},</p><p>Just a gentle reminder of our request for your review of the submission, \"{$submissionTitle},\" for {$journalName}. We were expecting to have this review by {$reviewDueDate} and we would be pleased to receive it as soon as you are able to prepare it.</p><p>You can <a href=\"{$reviewAssignmentUrl}\">login to the journal</a> and follow the review steps to view the submission, upload review files, and submit your review comments.</p><p>If you need an extension of the deadline, please contact me. I look forward to hearing from you.</p><p>Thank you in advance and kind regards,</p>{$signature}'),(38,'REVIEW_REMIND','hi','','सबमिशन रिव्यू रिमाइंडर','{$recipientName}:<br />\n<br />\nप्रस्तुत करने की आपकी समीक्षा के लिए हमारे अनुरोध का एक सौम्य अनुस्मारक, &quot;{$submissionTitle},&quot; for {$journalName}. हम {$ reviewDueDate} द्वारा इस समीक्षा की उम्मीद कर रहे थे, और जैसे ही आप इसे तैयार करने वाले हैं, इसे प्राप्त करके प्रसन्न होंगे.<br />\n<br />\nयदि आपके पास जर्नल की वेब साइट के लिए आपका उपयोगकर्ता नाम और पासवर्ड नहीं है, तो आप अपना पासवर्ड रीसेट करने के लिए इस लिंक का उपयोग कर सकते हैं (जो तब आपके उपयोगकर्ता नाम के साथ आपको ईमेल किया जाएगा)। {$ PasswordResetUrl}<br />\n<br />\nSubmission URL: {$reviewAssignmentUrl}<br />\n<br />\nकृपया जर्नल के काम में इस महत्वपूर्ण योगदान को पूरा करने की अपनी क्षमता की पुष्टि करें। तुम्हारे उत्तर की प्रतीक्षा है मुझे.<br />\n<br />\n{$signature}'),(39,'REVIEW_REMIND_AUTO','en','Review Reminder (Automated)','A reminder to please complete your review','<p>Dear {$recipientName}:</p><p>This email is an automated reminder from {$journalName} in regards to our request for your review of the submission, \"{$submissionTitle}.\"</p><p>We were expecting to have this review by {$reviewDueDate} and we would be pleased to receive it as soon as you are able to prepare it.</p><p>Please <a href=\"{$reviewAssignmentUrl}\">login to the journal</a> and follow the review steps to view the submission, upload review files, and submit your review comments.</p><p>If you need an extension of the deadline, please contact me. I look forward to hearing from you.</p><p>Thank you in advance and kind regards,</p>{$journalSignature}'),(40,'REVIEW_REMIND_AUTO','hi','','ऑटोमेटेड सबमिशन रिव्यू रिमाइंडर','{$recipientName}:<br />\n<br />\nप्रस्तुत करने की आपकी समीक्षा के लिए हमारे अनुरोध का एक सौम्य अनुस्मारक, &quot;{$submissionTitle},&quot; for {$journalName}. हम {$ reviewDueDate} द्वारा इस समीक्षा की उम्मीद कर रहे थे, और यह ईमेल स्वचालित रूप से जनरेट किया गया है और उस तारीख को पारित करने के साथ भेजा गया है। जैसे ही आप इसे तैयार करने में सक्षम होंगे, हम इसे प्राप्त करके प्रसन्न होंगे.<br />\n<br />\nयदि आपके पास जर्नल की वेब साइट के लिए आपका उपयोगकर्ता नाम और पासवर्ड नहीं है, तो आप अपना पासवर्ड रीसेट करने के लिए इस लिंक का उपयोग कर सकते हैं (जो तब आपके उपयोगकर्ता नाम के साथ आपको ईमेल किया जाएगा)। {$ PasswordResetUrl}<br />\n<br />\nSubmission URL: {$reviewAssignmentUrl}<br />\n<br />\nकृपया जर्नल के काम में इस महत्वपूर्ण योगदान को पूरा करने की अपनी क्षमता की पुष्टि करें। तुम्हारे उत्तर की प्रतीक्षा है मुझे.<br />\n<br />\n{$journalSignature}'),(41,'REVIEW_COMPLETE','en','Review Completed','Review complete: {$reviewerName} recommends {$reviewRecommendation} for #{$submissionId} {$authorsShort} — \"{$submissionTitle}\"','<p>Dear {$recipientName},</p><p>{$reviewerName} completed the following review:</p><p><a href=\"{$submissionUrl}\">#{$submissionId} {$authorsShort} — \"{$submissionTitle}\"</a><br /><b>Recommendation:</b> {$reviewRecommendation}<br /><b>Type:</b> {$reviewMethod}</p><p>Login to <a href=\"{$submissionUrl}\">view all files and comments</a> provided by this reviewer.</p>'),(42,'REVIEW_COMPLETE','hi','','',''),(43,'REVIEW_EDIT','en','Review Edited','Your review assignment has been changed for {$journalName}','<p>Dear {$recipientName},</p><p>An editor has made changes to your review assignment for {$journalName}. Please review the details below and let us know if you have any questions.</p><p><a href=\"{$reviewAssignmentUrl}\">\"{$submissionTitle}\"</a><br /><b>Type:</b> {$reviewMethod}<br /><b>Accept or Decline By:</b> {$responseDueDate}<br /><b>Submit Review By:</b> {$reviewDueDate}</p><p>You can login to <a href=\"{$reviewAssignmentUrl}\">complete this review</a> at any time.</p>'),(44,'REVIEW_EDIT','hi','','',''),(45,'EDITOR_DECISION_ACCEPT','en','Submission Accepted','Your submission has been accepted to {$journalName}','<p>Dear {$recipientName},</p><p>I am pleased to inform you that we have decided to accept your submission without further revision. After careful review, we found your submission, {$submissionTitle}, to meet or exceed our expectations. We are excited to publish your piece in {$journalName} and we thank you for choosing our journal as a venue for your work.</p><p>Your submission is now forthcoming in a future issue of {$journalName} and you are welcome to include it in your list of publications. We recognize the hard work that goes into every successful submission and we want to congratulate you on reaching this stage.</p><p>Your submission will now undergo copy editing and formatting to prepare it for publication.</p><p>You will shortly receive further instructions.</p><p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p><p>Kind regards,</p>{$signature}'),(46,'EDITOR_DECISION_ACCEPT','hi','','संपादक का निर्णय','{$authors}:<br />\n<br />\nहम आपके सबमिशन के बारे में निर्णय ले चुके हैं to {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nहमारा निर्णय है: सबमिशन को स्वीकार करना'),(47,'EDITOR_DECISION_SEND_TO_EXTERNAL','en','Sent to Review','Your submission has been sent for review','<p>Dear {$recipientName},</p><p>I am pleased to inform you that an editor has reviewed your submission, \"{$submissionTitle}\", and has decided to send it for peer review. An editor will identify qualified reviewers who will provide feedback on your submission.</p><p>{$reviewTypeDescription} You will hear from us with feedback from the reviewers and information about the next steps.</p><p>Please note that sending the submission to peer review does not guarantee that it will be published. We will consider the reviewers\' recommendations before deciding to accept the submission for publication. You may be asked to make revisions and respond to the reviewers\' comments before a final decision is made.</p><p>If you have any questions, please contact me from your submission dashboard.</p><p>{$signature}</p>'),(48,'EDITOR_DECISION_SEND_TO_EXTERNAL','hi','','संपादक का निर्णय','{$authors}:<br />\n<br />\nहम आपके सबमिशन के बारे में निर्णय ले चुके हैं to {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOur decision is to: Send to Review<br />\n<br />\nSubmission URL: {$submissionUrl}'),(49,'EDITOR_DECISION_SEND_TO_PRODUCTION','en','Sent to Production','Next steps for publishing your submission','<p>Dear {$recipientName},</p><p>I am writing from {$journalName} to let you know that the editing of your submission, \"{$submissionTitle}\", is complete. Your submission will now advance to the production stage, where the final galleys will be prepared for publication. We will contact you if we need any further assistance.</p><p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p><p>Kind regards,</p>{$signature}'),(50,'EDITOR_DECISION_SEND_TO_PRODUCTION','hi','','संपादक का निर्णय','{$authors}:<br />\n<br />\nआपके सबमिशन का संपादन, &quot;{$submissionTitle},&quot; पूरा है। अब हम इसे उत्पादन के लिए भेज रहे हैं.<br />\n<br />\nSubmission URL: {$submissionUrl}'),(51,'EDITOR_DECISION_REVISIONS','en','Revisions Requested','Your submission has been reviewed and we encourage you to submit revisions','<p>Dear {$recipientName},</p><p>Your submission \"{$submissionTitle}\" has been reviewed and we would like to encourage you to submit revisions that address the reviewers\' comments. An editor will review these revisions and if they address the concerns adequately, your submission may be accepted for publication.</p><p>The reviewers\' comments are included at the bottom of this email. Please respond to each point in the reviewers\' comments and identify what changes you have made. If you find any of the reviewer\'s comments to be unjustified or inappropriate, please explain your perspective.</p><p>When you have completed your revisions, you can upload revised documents along with your response to the reviewers\' comments at your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>. If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p><p>We look forward to receiving your revised submission.</p><p>Kind regards,</p>{$signature}<hr><p>The following comments were received from reviewers.</p>{$allReviewerComments}'),(52,'EDITOR_DECISION_REVISIONS','hi','','संपादक का निर्णय','{$authors}:<br />\n<br />\nआपके द्वारा सबमिट किए जाने के संबंध में हम एक निर्णय पर पहुंच गए हैं {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOur decision is: Revisions Required'),(53,'EDITOR_DECISION_RESUBMIT','en','Resubmit for Review','Your submission has been reviewed - please revise and resubmit','<p>Dear {$recipientName},</p><p>After reviewing your submission, \"{$submissionTitle}\", the reviewers have recommended that your submission cannot be accepted for publication in its current form. However, we would like to encourage you to submit a revised version that addresses the reviewers\' comments. Your revisions will be reviewed by an editor and may be sent out for another round of peer review.</p><p>Please note that resubmitting your work does not guarantee that it will be accepted.</p><p>The reviewers\' comments are included at the bottom of this email. Please respond to each point and identify what changes you have made. If you find any of the reviewer\'s comments inappropriate, please explain your perspective. If you have questions about the recommendations in your review, please include these in your response.</p><p>When you have completed your revisions, you can upload revised documents along with your response to the reviewers\' comments <a href=\"{$authorSubmissionUrl}\">at your submission dashboard</a>. If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p><p>We look forward to receiving your revised submission.</p><p>Kind regards,</p>{$signature}<hr><p>The following comments were received from reviewers.</p>{$allReviewerComments}'),(54,'EDITOR_DECISION_RESUBMIT','hi','','संपादक का निर्णय',''),(55,'EDITOR_DECISION_DECLINE','en','Submission Declined','Your submission has been declined','<p>Dear {$recipientName},</p><p>While we appreciate receiving your submission, we are unable to accept \"{$submissionTitle}\" for publication on the basis of the comments from reviewers.</p><p>The reviewers\' comments are included at the bottom of this email.</p><p>Thank you for submitting to {$journalName}. Although it is disappointing to have a submission declined, I hope you find the reviewers\' comments to be constructive and helpful.</p><p>You are now free to submit the work elsewhere if you choose to do so.</p><p>Kind regards,</p>{$signature}<hr><p>The following comments were received from reviewers.</p>{$allReviewerComments}'),(56,'EDITOR_DECISION_DECLINE','hi','','संपादक का निर्णय','{$authors}:<br />\n<br />\nआपके द्वारा सबमिट किए जाने के संबंध में हम एक निर्णय पर पहुंच गए हैं {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nहमारा निर्णय है: सबमिशन को अस्वीकार करना'),(57,'EDITOR_DECISION_INITIAL_DECLINE','en','Submission Declined (Pre-Review)','Your submission has been declined','<p>Dear {$recipientName},</p><p>I’m sorry to inform you that, after reviewing your submission, \"{$submissionTitle}\", the editor has found that it does not meet our requirements for publication in {$journalName}.</p><p>I wish you success if you consider submitting your work elsewhere.</p><p>Kind regards,</p>{$signature}'),(58,'EDITOR_DECISION_INITIAL_DECLINE','hi','','संपादक का निर्णय','\n			{$authors}:<br />\n<br />\n'),(59,'EDITOR_RECOMMENDATION','en','Recommendation Made','Editor Recommendation','<p>Dear {$recipientName},</p><p>After considering the reviewers\' feedback, I would like to make the following recommendation regarding the submission \"{$submissionTitle}\".</p><p>My recommendation is: {$recommendation}.</p><p>Please visit the submission\'s <a href=\"{$submissionUrl}\">editorial workflow</a> to act on this recommendation.</p><p>Please feel free to contact me with any questions.</p><p>Kind regards,</p><p>{$senderName}</p>'),(60,'EDITOR_RECOMMENDATION','hi','','संपादक की सिफारिश','{$editors}:<br />\n<br />\nको प्रस्तुत करने के संबंध में सिफारिश {$journalName}, &quot;{$submissionTitle}&quot; is: {$recommendation}'),(61,'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS','en','Notify Other Authors','An update regarding your submission','<p>The following email was sent to {$submittingAuthorName} from {$journalName} regarding \"{$submissionTitle}\".</p>\n<p>You are receiving a copy of this notification because you are identified as an author of the submission. Any instructions in the message below are intended for the submitting author, {$submittingAuthorName}, and no action is required of you at this time.</p>\n\n{$messageToSubmittingAuthor}'),(62,'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS','hi','','',''),(63,'EDITOR_DECISION_NOTIFY_REVIEWERS','en','Notify Reviewers of Decision','Thank you for your review','<p>Dear {$recipientName},</p>\n<p>Thank you for completing your review of the submission, \"{$submissionTitle}\", for {$journalName}. We appreciate your time and expertise in contributing to the quality of the work that we publish. We have shared your comments with the authors, along with our other reviewers\' comments and the editor\'s decision.</p>\n<p>Based on the feedback we received, we have notified the authors of the following:</p>\n<p>{$decisionDescription}</p>\n<p>Your recommendation was considered alongside the recommendations of other reviewers before coming to a decision. Occasionally the editor\'s decision may differ from the recommendation made by one or more reviewers. The editor considers many factors, and does not take these decisions lightly. We are grateful for our reviewers\' expertise and suggestions.</p>\n<p>It has been a pleasure to work with you as a reviewer for {$journalName}, and we hope to have the opportunity to work with you again in the future.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>'),(64,'EDITOR_DECISION_NOTIFY_REVIEWERS','hi','','',''),(65,'EDITOR_DECISION_NEW_ROUND','en','New Review Round Initiated','Your submission has been sent for another round of review','<p>Dear {$recipientName},</p>\n<p>Your revised submission, \"{$submissionTitle}\", has been sent for a new round of peer review. \nYou will hear from us with feedback from the reviewers and information about the next steps.</p>\n<p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),(66,'EDITOR_DECISION_NEW_ROUND','hi','','',''),(67,'EDITOR_DECISION_REVERT_DECLINE','en','Reinstate Declined Submission','We have reversed the decision to decline your submission','<p>Dear {$recipientName},</p>\n<p>The decision to decline your submission, \"{$submissionTitle}\", has been reversed. \nAn editor will complete the round of review and you will be notified when a \ndecision is made.</p>\n<p>Occasionally, a decision to decline a submission will be recorded accidentally in \nour system and must be reverted. I apologize for any confusion this may have caused.</p>\n<p>We will contact you if we need any further assistance.</p>\n<p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),(68,'EDITOR_DECISION_REVERT_DECLINE','hi','','',''),(69,'EDITOR_DECISION_REVERT_INITIAL_DECLINE','en','Reinstate Submission Declined Without Review','We have reversed the decision to decline your submission','<p>Dear {$recipientName},</p>\n<p>The decision to decline your submission, \"{$submissionTitle}\", has been reversed. \nAn editor will look further at your submission before deciding whether to decline \nthe submission or send it for review.</p>\n<p>Occasionally, a decision to decline a submission will be recorded accidentally in \nour system and must be reverted. I apologize for any confusion this may have caused.</p>\n<p>We will contact you if we need any further assistance.</p>\n<p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),(70,'EDITOR_DECISION_REVERT_INITIAL_DECLINE','hi','','',''),(71,'EDITOR_DECISION_SKIP_REVIEW','en','Submission Accepted (Without Review)','Your submission has been sent for copyediting','<p>Dear {$recipientName},</p>\n<p>I am pleased to inform you that we have decided to accept your submission without peer review. We found your submission, {$submissionTitle}, to meet our expectations, and we do not require that work of this type undergo peer review. We are excited to publish your piece in {$journalName} and we thank you for choosing our journal as a venue for your work.</p>\nYour submission is now forthcoming in a future issue of {$journalName} and you are welcome to include it in your list of publications. We recognize the hard work that goes into every successful submission and we want to congratulate you on your efforts.</p>\n<p>Your submission will now undergo copy editing and formatting to prepare it for publication. </p>\n<p>You will shortly receive further instructions.</p>\n<p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),(72,'EDITOR_DECISION_SKIP_REVIEW','hi','','',''),(73,'EDITOR_DECISION_BACK_FROM_PRODUCTION','en','Submission Sent Back to Copyediting','Your submission has been sent back to copyediting','<p>Dear {$recipientName},</p><p>Your submission, \"{$submissionTitle}\", has been sent back to the copyediting stage, where it will undergo further copyediting and formatting to prepare it for publication.</p><p>Occasionally, a submission is sent to the production stage before it is ready for the final galleys to be prepared for publication. Your submission is still forthcoming. I apologize for any confusion.</p><p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p><p>We will contact you if we need any further assistance.</p><p>Kind regards,</p><p>{$signature}</p>'),(74,'EDITOR_DECISION_BACK_FROM_PRODUCTION','hi','','',''),(75,'EDITOR_DECISION_BACK_FROM_COPYEDITING','en','Submission Sent Back from Copyediting','Your submission has been sent back to review','<p>Dear {$recipientName},</p><p>Your submission, \"{$submissionTitle}\", has been sent back to the review stage. It will undergo further review before it can be accepted for publication.</p><p>Occasionally, a decision to accept a submission will be recorded accidentally in our system and we must send it back to review. I apologize for any confusion this has caused. We will work to complete any further review quickly so that you have a final decision as soon as possible.</p><p>We will contact you if we need any further assistance.</p><p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p><p>Kind regards,</p><p>{$signature}</p>'),(76,'EDITOR_DECISION_BACK_FROM_COPYEDITING','hi','','',''),(77,'EDITOR_DECISION_CANCEL_REVIEW_ROUND','en','Review Round Cancelled','A review round for your submission has been cancelled','<p>Dear {$recipientName},</p><p>We recently opened a new review round for your submission, \"{$submissionTitle}\". We are closing this review round now.</p><p>Occasionally, a decision to open a round of review will be recorded accidentally in our system and we must cancel this review round. I apologize for any confusion this may have caused.</p><p>We will contact you if we need any further assistance.</p><p>If you have any questions, please contact me from your <a href=\"{$authorSubmissionUrl}\">submission dashboard</a>.</p><p>Kind regards,</p><p>{$signature}</p>'),(78,'EDITOR_DECISION_CANCEL_REVIEW_ROUND','hi','','',''),(79,'SUBSCRIPTION_NOTIFY','en','Subscription Notify','Subscription Notification','{$recipientName}:<br />\n<br />\nYou have now been registered as a subscriber in our online journal management system for {$journalName}, with the following subscription:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nTo access content that is available only to subscribers, simply log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nOnce you have logged in to the system you can change your profile details and password at any point.<br />\n<br />\nPlease note that if you have an institutional subscription, there is no need for users at your institution to log in, since requests for subscription content will be automatically authenticated by the system.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),(80,'SUBSCRIPTION_NOTIFY','hi','','सदस्यता अधिसूचना','{$recipientName}:<br />\n<br />\nअब आप हमारी ऑनलाइन जर्नल मैनेजमेंट सिस्टम में {$journalName} के लिए एक सब्सक्राइबर के रूप में पंजीकृत हो गए हैं, निम्नलिखित सदस्यता के साथ:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nकेवल ग्राहकों के लिए उपलब्ध सामग्री तक पहुँचने के लिए, सिस्टम में अपने यूज़रनेम के साथ लॉग इन करें, &quot;{$recipientUsername}&quot;.<br />\n<br />\nएक बार जब आप सिस्टम में लॉग इन कर लेते हैं तो आप किसी भी बिंदु पर अपना प्रोफ़ाइल विवरण और पासवर्ड बदल सकते हैं.<br />\n<br />\nकृपया ध्यान दें कि यदि आपके पास एक संस्थागत सदस्यता है, तो आपके संस्थान में उपयोगकर्ताओं को लॉग इन करने की कोई आवश्यकता नहीं है, क्योंकि सदस्यता सामग्री के लिए अनुरोध स्वचालित रूप से सिस्टम द्वारा प्रमाणित किया जाएगा।.<br />\n<br />\nयदि आपके कोई प्रश्न हैं, तो कृपया मुझसे बेझिझक संपर्क करें.<br />\n<br />\n{$subscriptionSignature}'),(81,'OPEN_ACCESS_NOTIFY','en','Open Access Notify','Free to read: {$issueIdentification} of {$journalName} is now open access','<p>Dear {$recipientName},</p><p>We are pleased to inform you that <a href=\"{$issueUrl}\">{$issueIdentification}</a> of {$journalName} is now available under open access.  A subscription is no longer required to read this issue.</p><p>Thank you for your continuing interest in our work.</p>{$journalSignature}'),(82,'OPEN_ACCESS_NOTIFY','hi','','अंक अब ओपन एक्सेस','Readers:<br />\n<br />\n{$journalName} निम्नलिखित मुद्दे पर सिर्फ एक ओपन एक्सेस फॉर्मेट में उपलब्ध कराया गया है। हम आपको यहां सामग्री की तालिका की समीक्षा करने के लिए आमंत्रित करते हैं और फिर लेख और रुचि की वस्तुओं की समीक्षा करने के लिए हमारी वेब साइट ({$journalUrl}) पर जाएं।.<br />\n<br />\nहमारे काम में निरंतर रुचि के लिए धन्यवाद,<br />\n{$journalSignature}'),(83,'SUBSCRIPTION_BEFORE_EXPIRY','en','Subscription Expires Soon','Notice of Subscription Expiry','{$recipientName}:<br />\n<br />\nYour {$journalName} subscription is about to expire.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nTo ensure the continuity of your access to this journal, please go to the journal website and renew your subscription. You are able to log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),(84,'SUBSCRIPTION_BEFORE_EXPIRY','hi','','सदस्यता समाप्ति की सूचना','{$recipientName}:<br />\n<br />\nआपकी {$journalName} सदस्यता समाप्त होने वाली है.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nइस पत्रिका तक अपनी पहुंच की निरंतरता सुनिश्चित करने के लिए, कृपया वेबसाइट पर जाएं और अपनी सदस्यता को नवीनीकृत करें। आप अपने उपयोगकर्ता नाम के साथ सिस्टम में लॉग इन करने में सक्षम हैं, &quot;{$recipientUsername}&quot;.<br />\n<br />\nयदि आपके कोई प्रश्न हैं, तो कृपया मुझसे बेझिझक संपर्क करें.<br />\n<br />\n{$subscriptionSignature}'),(85,'SUBSCRIPTION_AFTER_EXPIRY','en','Subscription Expired','Subscription Expired','{$recipientName}:<br />\n<br />\nYour {$journalName} subscription has expired.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nTo renew your subscription, please go to the journal website. You are able to log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),(86,'SUBSCRIPTION_AFTER_EXPIRY','hi','','सदस्यता समाप्त हो गई','{$recipientName}:<br />\n<br />\nआपकी {$journalName} सदस्यता समाप्त हो गई है.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nअपनी सदस्यता को नवीनीकृत करने के लिए, कृपया जर्नल वेबसाइट पर जाएं। आप अपने उपयोगकर्ता नाम के साथ सिस्टम में लॉग इन करने में सक्षम हैं, &quot;{$recipientUsername}&quot;.<br />\n<br />\nयदि आपके कोई प्रश्न हैं, तो कृपया मुझसे बेझिझक संपर्क करें.<br />\n<br />\n{$subscriptionSignature}'),(87,'SUBSCRIPTION_AFTER_EXPIRY_LAST','en','Subscription Expired Last','Subscription Expired - Final Reminder','{$recipientName}:<br />\n<br />\nYour {$journalName} subscription has expired.<br />\nPlease note that this is the final reminder that will be emailed to you.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nTo renew your subscription, please go to the journal website. You are able to log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),(88,'SUBSCRIPTION_AFTER_EXPIRY_LAST','hi','','सदस्यता समाप्त - अंतिम अनुस्मारक','{$recipientName}:<br />\n<br />\nआपकी {$journalName} सदस्यता समाप्त हो गई है.<br />\nकृपया ध्यान दें कि यह अंतिम अनुस्मारक है जिसे आपको ईमेल किया जाएगा.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nअपनी सदस्यता को नवीनीकृत करने के लिए, कृपया जर्नल वेबसाइट पर जाएं। आप अपने उपयोगकर्ता नाम के साथ सिस्टम में लॉग इन करने में सक्षम हैं, &quot;{$recipientUsername}&quot;.<br />\n<br />\nयदि आपके कोई प्रश्न हैं, तो कृपया मुझसे बेझिझक संपर्क करें.<br />\n<br />\n{$subscriptionSignature}'),(89,'SUBSCRIPTION_PURCHASE_INDL','en','Purchase Individual Subscription','Subscription Purchase: Individual','An individual subscription has been purchased online for {$journalName} with the following details.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nUser:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),(90,'SUBSCRIPTION_PURCHASE_INDL','hi','','सदस्यता खरीद: व्यक्तिगत','निम्नलिखित विवरण के साथ {$ contextName} के लिए एक व्यक्तिगत सदस्यता ऑनलाइन खरीदी गई है।<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nUser:<br />\n{$subscriberDetails}<br />\n<br />\nसदस्यता जानकारी (यदि प्रदान की गई है):<br />\n{$membership}<br />\n<br />\nइस सदस्यता को देखने या संपादित करने के लिए, कृपया निम्न URL का उपयोग करें.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),(91,'SUBSCRIPTION_PURCHASE_INSTL','en','Purchase Institutional Subscription','Subscription Purchase: Institutional','An institutional subscription has been purchased online for {$journalName} with the following details. To activate this subscription, please use the provided Subscription URL and set the subscription status to \'Active\'.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomain (if provided):<br />\n{$domain}<br />\n<br />\nIP Ranges (if provided):<br />\n{$ipRanges}<br />\n<br />\nContact Person:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),(92,'SUBSCRIPTION_PURCHASE_INSTL','hi','','सदस्यता खरीद: व्यक्तिगत','निम्नलिखित विवरण के साथ {$journalName} के लिए एक संस्थागत सदस्यता ऑनलाइन खरीदी गई है। इस सदस्यता को सक्रिय करने के लिए, कृपया दिए गए सदस्यता URL का उपयोग करें और सदस्यता की स्थिति को \'सक्रिय\' पर सेट करें.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomain (if provided):<br />\n{$domain}<br />\n<br />\nIP Ranges (if provided):<br />\n{$ipRanges}<br />\n<br />\nContact Person:<br />\n{$subscriberDetails}<br />\n<br />\nसदस्यता जानकारी (यदि प्रदान की गई है):<br />\n{$membership}<br />\n<br />\nइस सदस्यता को देखने या संपादित करने के लिए, कृपया निम्न URL का उपयोग करें.<br />\n<br />\nसदस्यता URL: {$subscriptionUrl}<br />\n'),(93,'SUBSCRIPTION_RENEW_INDL','en','Renew Individual Subscription','Subscription Renewal: Individual','An individual subscription has been renewed online for {$journalName} with the following details.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nUser:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),(94,'SUBSCRIPTION_RENEW_INDL','hi','','सदस्यता नवीनीकरण: व्यक्तिगत','निम्नलिखित विवरण के साथ {$journalName} के लिए एक व्यक्तिगत सदस्यता ऑनलाइन नवीनीकृत की गई है.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nUser:<br />\n{$subscriberDetails}<br />\n<br />\nसदस्यता जानकारी (यदि प्रदान की गई है):<br />\n{$membership}<br />\n<br />\nइस सदस्यता को देखने या संपादित करने के लिए, कृपया निम्न URL का उपयोग करें.<br />\n<br />\nसदस्यता URL: {$subscriptionUrl}<br />\n'),(95,'SUBSCRIPTION_RENEW_INSTL','en','Renew Institutional Subscription','Subscription Renewal: Institutional','An institutional subscription has been renewed online for {$journalName} with the following details.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomain (if provided):<br />\n{$domain}<br />\n<br />\nIP Ranges (if provided):<br />\n{$ipRanges}<br />\n<br />\nContact Person:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),(96,'SUBSCRIPTION_RENEW_INSTL','hi','','सदस्यता नवीनीकरण: व्यक्तिगत','निम्नलिखित विवरण के साथ {$journalName} के लिए एक संस्थागत सदस्यता ऑनलाइन नवीनीकृत की गई है.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nडोमेन (यदि प्रदान किया गया है):<br />\n{$domain}<br />\n<br />\nआईपी रेंज (यदि प्रदान की गई है):<br />\n{$ipRanges}<br />\n<br />\nसंपर्क व्यक्ति:<br />\n{$subscriberDetails}<br />\n<br />\nसदस्यता जानकारी (यदि प्रदान की गई है):<br />\n{$membership}<br />\n<br />\nइस सदस्यता को देखने या संपादित करने के लिए, कृपया निम्न URL का उपयोग करें.<br />\n<br />\nसदस्यता URL: {$subscriptionUrl}<br />\n'),(97,'REVISED_VERSION_NOTIFY','en','Revised Version Notification','Revised Version Uploaded','<p>Dear {$recipientName},</p><p>The author has uploaded revisions for the submission, <b>{$authorsShort} — {$submissionTitle}</b>. <p>As an assigned editor, we ask that you login and <a href=\"{$submissionUrl}\">view the revisions</a> and make a decision to accept, decline or send the submission for further review.</p><br><br>—<br>This is an automated message from <a href=\"{$journalUrl}\">{$journalName}</a>.'),(98,'REVISED_VERSION_NOTIFY','hi','','संशोधित संस्करण अपलोड किया गया','संपादकों:<br />\n<br />\nका संशोधित संस्करण &quot;{$submissionTitle}&quot; लेखक द्वारा अपलोड किया गया है {$submitterName}.<br />\n<br />\nसबमिशन URL: {$submissionUrl}<br />\n<br />\n{$signature}'),(99,'STATISTICS_REPORT_NOTIFICATION','en','Statistics Report Notification','Editorial activity for {$month}, {$year}','\n{$recipientName}, <br />\n<br />\nYour journal health report for {$month}, {$year} is now available. Your key stats for this month are below.<br />\n<ul>\n	<li>New submissions this month: {$newSubmissions}</li>\n	<li>Declined submissions this month: {$declinedSubmissions}</li>\n	<li>Accepted submissions this month: {$acceptedSubmissions}</li>\n	<li>Total submissions in the system: {$totalSubmissions}</li>\n</ul>\nLogin to the journal to view more detailed <a href=\"{$editorialStatsLink}\">editorial trends</a> and <a href=\"{$publicationStatsLink}\">published article stats</a>. A full copy of this month\'s editorial trends is attached.<br />\n<br />\nSincerely,<br />\n{$journalSignature}'),(100,'STATISTICS_REPORT_NOTIFICATION','hi','','{$ माह}, {$ वर्ष} के लिए संपादकीय गतिविधि',''),(101,'ANNOUNCEMENT','en','New Announcement','{$announcementTitle}','<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisit our website to read the <a href=\"{$announcementUrl}\">full announcement</a>.'),(102,'ANNOUNCEMENT','hi','','',''),(103,'DISCUSSION_NOTIFICATION_SUBMISSION','en','Discussion (Submission)','A message regarding {$journalName}','Please enter your message.'),(104,'DISCUSSION_NOTIFICATION_SUBMISSION','hi','','{$journalName} के बारे में एक संदेश','कृपया अपना संदेश लिखें.'),(105,'DISCUSSION_NOTIFICATION_REVIEW','en','Discussion (Review)','A message regarding {$journalName}','Please enter your message.'),(106,'DISCUSSION_NOTIFICATION_REVIEW','hi','','{$journalName} के बारे में एक संदेश','कृपया अपना संदेश लिखें.'),(107,'DISCUSSION_NOTIFICATION_COPYEDITING','en','Discussion (Copyediting)','A message regarding {$journalName}','Please enter your message.'),(108,'DISCUSSION_NOTIFICATION_COPYEDITING','hi','','{$journalName} के बारे में एक संदेश','कृपया अपना संदेश लिखें.'),(109,'DISCUSSION_NOTIFICATION_PRODUCTION','en','Discussion (Production)','A message regarding {$journalName}','Please enter your message.'),(110,'DISCUSSION_NOTIFICATION_PRODUCTION','hi','','{$journalName} के बारे में एक संदेश','कृपया अपना संदेश लिखें.'),(111,'COPYEDIT_REQUEST','en','Request Copyedit','Submission {$submissionId} is ready to be copyedited for {$contextAcronym}','<p>Dear {$recipientName},</p><p>A new submission is ready to be copyedited:</p><p><a href\"{$submissionUrl}\">{$submissionId} — \"{$submissionTitle}\"</a><br />{$journalName}</p><p>Please follow these steps to complete this task:</p><ol><li>Click on the Submission URL below.</li><li>Open any files available under Draft Files and edit the files. Use the Copyediting Discussions area if you need to contact the editor(s) or author(s).</li><li>Save the copyedited file(s) and upload them to the Copyedited panel.</li><li>Use the Copyediting Discussions to notify the editor(s) that all files have been prepared, and that the Production process may begin.</li></ol><p>If you are unable to undertake this work at this time or have any questions, please contact me. Thank you for your contribution to {$journalName}.</p><p>Kind regards,</p>{$signature}'),(112,'COPYEDIT_REQUEST','hi','','प्रतिलिपि अनुरोध','{$recipientName}:<br />\n<br />\nI would ask that you undertake the copyediting of &quot;{$submissionTitle}&quot; for {$journalName} by following these steps.<br />\n1. नीचे दिए गए सबमिशन यूआरएल पर क्लिक करें.<br />\n2. ड्राफ्ट फ़ाइलों के तहत उपलब्ध किसी भी फाइल को खोलें और आवश्यकतानुसार अपनी कॉपी की गई चर्चाओं को जोड़ते हुए, अपनी प्रतिलिपि बनाएँ.<br />\n3. Save copyedited file(s), and upload to Copyedited panel.<br />\n4. संपादक को सूचित करें कि सभी फाइलें तैयार हो गई हैं, और यह कि उत्पादन प्रक्रिया शुरू हो सकती है.<br />\n<br />\n{$journalName} URL: {$journalUrl}<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$recipientUsername}'),(113,'EDITOR_ASSIGN_SUBMISSION','en','Assign Editor','You have been assigned as an editor on a submission to {$journalName}','<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the editorial process.</p><p><a href=\"{$submissionUrl}\">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>If you find the submission to be relevant for {$journalName}, please forward the submission to the review stage by selecting \"Send to Review\" and then assign reviewers by clicking \"Add Reviewer\".</p><p>If the submission is not appropriate for this journal, please decline the submission.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$journalSignature}'),(114,'EDITOR_ASSIGN_SUBMISSION','hi','','संपादकीय असाइनमेंट','{$recipientName}:<br />\n<br />\nप्रस्तुत, &quot;{$submissionTitle},&quot; to {$journalName} आपको सेक्शन एडिटर के रूप में अपनी भूमिका में संपादकीय प्रक्रिया के माध्यम से देखने का काम सौंपा गया है.<br />\n<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$recipientUsername}<br />\n<br />\nThank you.'),(115,'EDITOR_ASSIGN_REVIEW','en','Assign Editor','You have been assigned as an editor on a submission to {$journalName}','<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the peer review process.</p><p><a href=\"{$submissionUrl}\">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please login to <a href=\"{$submissionUrl}\">view the submission</a> and assign qualified reviewers. You can assign a reviewer by clicking \"Add Reviewer\".</p><p>Thank you in advance.</p><p>Kind regards,</p>{$signature}'),(116,'EDITOR_ASSIGN_REVIEW','hi','','संपादकीय असाइनमेंट',''),(117,'EDITOR_ASSIGN_PRODUCTION','en','Assign Editor','You have been assigned as an editor on a submission to {$journalName}','<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the production stage.</p><p><a href=\"{$submissionUrl}\">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please login to <a href=\"{$submissionUrl}\">view the submission</a>. Once production-ready files are available, upload them under the <strong>Publication > Galleys</strong> section. Then schedule the work for publication by clicking the <strong>Schedule for Publication</strong> button.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$signature}'),(118,'EDITOR_ASSIGN_PRODUCTION','hi','','संपादकीय असाइनमेंट',''),(119,'LAYOUT_REQUEST','en','Ready for Production','Submission {$submissionId} is ready for production at {$contextAcronym}','<p>Dear {$recipientName},</p><p>A new submission is ready for layout editing:</p><p><a href=\"{$submissionUrl}\">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><ol><li>Click on the Submission URL above.</li><li>Download the Production Ready files and use them to create the galleys according to the journal\'s standards.</li><li>Upload the galleys to the Publication section of the submission.</li><li>Use the  Production Discussions to notify the editor that the galleys are ready.</li></ol><p>If you are unable to undertake this work at this time or have any questions, please contact me. Thank you for your contribution to this journal.</p><p>Kind regards,</p>{$signature}'),(120,'LAYOUT_REQUEST','hi','','अनुरोध गैलीज़','{$recipientName}:<br />\n<br />\nThe submission &quot;{$submissionTitle}&quot; to {$journalName} अब इन चरणों का पालन करके गैलियों की जरूरत है.<br />\n1. नीचे दिए गए सबमिशन यूआरएल पर क्लिक करें.<br />\n2. जर्नल में लॉग इन करें और जर्नल के मानकों के अनुसार गैलिलियों को बनाने के लिए प्रोडक्शन रेडी फाइलों का उपयोग करें.<br />\n3. गैलीज़ को गैली फ़ाइल्स अनुभाग में अपलोड करें.<br />\n4. प्रोडक्शन डिस्कशन का उपयोग करके संपादक को सूचित करें कि गैलिसियां अपलोड और तैयार हैं.<br />\n<br />\n{$journalName} URL: {$journalUrl}<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$recipientUsername}<br />\n<br />\nयदि आप इस समय यह कार्य करने में असमर्थ हैं या कोई प्रश्न हैं, तो कृपया मुझसे संपर्क करें। इस जर्नल में आपके योगदान के लिए धन्यवाद.'),(121,'LAYOUT_COMPLETE','en','Galleys Complete','Galleys Complete','<p>Dear {$recipientName},</p><p>Galleys have now been prepared for the following submission and are ready for final review.</p><p><a href=\"{$submissionUrl}\">{$submissionTitle}</a><br />{$journalName}</p><p>If you have any questions, please contact me.</p><p>Kind regards,</p><p>{$signature}</p>'),(122,'LAYOUT_COMPLETE','hi','','गैलीज़ पूर्ण','{$recipientName}:<br />\n<br />\nपांडुलिपि के लिए अब गैलीज़  तैयार की गई हैं, &quot;{$submissionTitle},&quot; for {$journalName} and are ready for proofreading.<br />\n<br />\nयदि आपके पास किसी तरह का प्रश्न है, तो कृपया मुझ से सम्पर्क करें.<br />\n<br />\n{$senderName}'),(123,'VERSION_CREATED','en','Version Created','A new version was created for \"{$submissionTitle}\"','<p>Dear {$recipientName}, </p><p>This is an automated message to inform you that a new version of your submission, \"{$submissionTitle}\", was created. You can view this version from your submission dashboard at the following link:</p><p><a href=\"{$submissionUrl}\">\"{$submissionTitle}\"</a></p><hr><p>This is an automatic email sent from <a href=\"{$journalUrl}\">{$journalName}</a>.</p>'),(124,'VERSION_CREATED','hi','','',''),(125,'EDITORIAL_REMINDER','en','Editorial Reminder','Outstanding editorial tasks for {$journalName}','<p>Dear {$recipientName},</p><p>You are currently assigned to {$numberOfSubmissions} submissions in <a href=\"{$journalUrl}\">{$journalName}</a>. The following submissions are <b>waiting for your response</b>.</p>{$outstandingTasks}<p>View all of your assignments in your <a href=\"{$submissionsUrl}\">submission dashboard</a>.</p><p>If you have any questions about your assignments, please contact {$contactName} at {$contactEmail}.</p>'),(126,'EDITORIAL_REMINDER','hi','','',''),(127,'SUBMISSION_SAVED_FOR_LATER','en','Submission Saved for Later','Resume your submission to {$journalName}','<p>Dear {$recipientName},</p><p>Your submission details have been saved in our system, but it has not yet been submitted for consideration. You can return to complete your submission at any time by following the link below.</p><p><a href=\"{$submissionWizardUrl}\">{$authorsShort} — \"{$submissionTitle}\"</a></p><hr><p>This is an automated email from <a href=\"{$journalUrl}\">{$journalName}</a>.</p>'),(128,'SUBMISSION_SAVED_FOR_LATER','hi','','',''),(129,'SUBMISSION_NEEDS_EDITOR','en','Submission Needs Editor','A new submission needs an editor to be assigned: \"{$submissionTitle}\"','<p>Dear {$recipientName},</p><p>The following submission has been submitted and there is no editor assigned.</p><p><a href=\"{$submissionUrl}\">\"{$submissionTitle}\"</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please assign an editor who will be responsible for the submission by clicking the title above and assigning an editor under the Participants section.</p><hr><p>This is an automated email from <a href=\"{$journalUrl}\">{$journalName}</a>.</p>'),(130,'SUBMISSION_NEEDS_EDITOR','hi','','',''),(131,'PAYMENT_REQUEST_NOTIFICATION','en','Payment Request','Payment Request Notification','<p>Dear {$recipientName},</p><p>Congratulations on the acceptance of your submission, {$submissionTitle}, to {$journalName}. Now that your submission has been accepted, we would like to request payment of the publication fee.</p><p>This fee covers the production costs of bringing your submission to publication. To make the payment, please visit <a href=\"{$queuedPaymentUrl}\">{$queuedPaymentUrl}</a>.</p><p>If you have any questions, please see our <a href=\"{$submissionGuidelinesUrl}\">Submission Guidelines</a></p>'),(132,'PAYMENT_REQUEST_NOTIFICATION','hi','','',''),(133,'CHANGE_EMAIL','en','Change Email Address Invitation','Confirm account contact email change request','<p>Dear {$recipientName},</p><p>You are receiving this email because someone has requested a change of your email to {$newEmail}.</p><p>If you have made this request please <a href=\"{$acceptInvitationUrl}\">confirm</a> the email change.</p><p>You can always <a href=\"{$declineInvitationUrl}\">reject</a> this email change.</p><p>Please feel free to contact me with any questions about the submission or the review process.</p><p>Kind regards,</p>{$siteContactName}'),(134,'CHANGE_EMAIL','hi','','',''),(135,'ORCID_COLLECT_AUTHOR_ID','en','orcidCollectAuthorId','Submission ORCID','Dear {$recipientName},<br/>\n<br/>\nYou have been listed as an author on a manuscript submission to {$journalName}.<br/>\nTo confirm your authorship, please add your ORCID id to this submission by visiting the link provided below.<br/>\n<br/>\n<a href=\"{$authorOrcidUrl}\"><img id=\"orcid-id-logo\" src=\"https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png\" width=\'16\' height=\'16\' alt=\"ORCID iD icon\" style=\"display: block; margin: 0 .5em 0 0; padding: 0; float: left;\"/>Register or connect your ORCID iD</a><br/>\n<br/>\n<br>\n<a href=\"{$orcidAboutUrl}\">More information about ORCID at {$journalName}</a><br/>\n<br/>\nIf you have any questions, please contact me.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),(136,'ORCID_COLLECT_AUTHOR_ID','hi','','',''),(137,'ORCID_REQUEST_AUTHOR_AUTHORIZATION','en','orcidRequestAuthorAuthorization','Requesting ORCID record access','Dear {$recipientName},<br>\n<br>\nYou have been listed as an author on the manuscript submission \"{$submissionTitle}\" to {$journalName}.\n<br>\n<br>\nPlease allow us to add your ORCID id to this submission and also to add the submission to your ORCID profile on publication.<br>\nVisit the link to the official ORCID website, login with your profile and authorize the access by following the instructions.<br>\n<br>\n<a href=\"{$authorOrcidUrl}\" style=\"display: inline-flex; align-items: center; background-color: white; text-align: center; padding: 10px 20px; text-decoration: none; border-radius: 5px; border: 2px solid #d7d4d4;\"><img id=\"orcid-id-logo\" src=\"https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png\" width=\'16\' height=\'16\' alt=\"ORCID iD icon\" style=\"display: block; margin: 0 .5em 0 0; padding: 0; float: left;\"/>Register or Connect your ORCID iD</a><br/>\n<br>\n<br>\nClick here to verify your account with ORCID: <a href=\"{$authorOrcidUrl}\">{$authorOrcidUrl}.</a>\n<br>\n<br>\n<a href=\"{$orcidAboutUrl}\">More about ORCID at {$journalName}</a><br/>\n<br>\n<br>\nIf you have any questions, please contact me.<br>\n<br>\n{$principalContactSignature}<br>\n'),(138,'ORCID_REQUEST_AUTHOR_AUTHORIZATION','hi','','',''),(139,'USER_ROLE_ASSIGNMENT_INVITATION','en','User Invited to Role Notification','You are invited to new roles','<div class=\'email-container\'>    <div class=\'email-header\'>        <h2>Invitation to New Role</h2>    </div>    <div class=\'email-content\'>        <p>Dear {$recipientName},</p>        <p>In light of your expertise, you have been invited by {$inviterName} to take on new roles at {$journalName}</p>        <p>At {$journalName}, we value your privacy. As such, we have taken steps to ensure that we are fully GDPR compliant. These steps include you being accountable to enter your own data and choosing who can see what information. For additional information on how we handled your data, please refer to our Privacy Policy.</p>        <div>{$existingRoles}</div>        <div>{$rolesAdded}</div>        <p>On accepting the invite, you will be redirected to {$journalName}.</p>        <p>Feel free to contact me with any questions about the process.</p>        <p><a href=\'{$acceptUrl}\' class=\'btn btn-accept\'>Accept Invitation</a></p>        <p><a href=\'{$declineUrl}\' class=\'btn btn-decline\'>Decline Invitation</a></p>        <p>Kind regards,</p>        <p>{$journalName}</p>    </div></div><style>{$emailTemplateStyle}</style>'),(140,'USER_ROLE_ASSIGNMENT_INVITATION','hi','','',''),(141,'USER_ROLE_END','en','User Role Ended Notification','You have been removed from a role','<div class=\'email-container\'>    <div class=\'email-header\'>        <h2>Removed from a Role</h2>    </div>    <div class=\'email-content\'>        <p>Dear {$recipientName},</p>        <p>Thank you very much for your participation in the role of {$roleRemoved} at {$journalName}.</p>        <p>This is a notice to let you know that you have been removed from the following role at {$journalName}: <b>{$roleRemoved}</b>.</p>        <p>Your account with {$journalName} is still active and any other roles you previously held are still active.</p>        <p>Feel free to contact me with any questions about the process.</p>        <p>Kind regards,</p>        <p>{$journalName}</p>    </div></div><style>{$emailTemplateStyle}</style>'),(142,'USER_ROLE_END','hi','','',''),(143,'ORCID_REQUEST_UPDATE_SCOPE','en','orcidRequestUpdateScope','Requesting updated ORCID record access','Dear {$recipientName},<br>\n<br>\nYou are listed as a contributor (author or reviewer) on the manuscript submission \"{$submissionTitle}\" to {$journalName}.\n<br>\n<br>\nYou have previously authorized {$journalName} to list your ORCID id on the site, and we require updateded permissions to add your contribution to your ORCID profile.<br>\nVisit the link to the official ORCID website, login with your profile and authorize the access by following the instructions.<br>\n<br>\n<a href=\"{$authorOrcidUrl}\" style=\"display: inline-flex; align-items: center; background-color: white; text-align: center; padding: 10px 20px; text-decoration: none; border-radius: 5px; border: 2px solid #d7d4d4;\"><img id=\"orcid-id-logo\" src=\"https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png\" width=\'16\' height=\'16\' alt=\"ORCID iD icon\" style=\"display: block; margin: 0 .5em 0 0; padding: 0; float: left;\"/>Register or Connect your ORCID iD</a><br/>\n<br>\n<br>\nClick here to update your account with ORCID: <a href=\"{$authorOrcidUrl}\">{$authorOrcidUrl}.</a>\n<br>\n<br>\n<a href=\"{$orcidAboutUrl}\">More about ORCID at {$journalName}</a><br/>\n<br>\n<br>\nIf you have any questions, please contact me.<br>\n<br>\n{$principalContactSignature}<br>\n'),(144,'ORCID_REQUEST_UPDATE_SCOPE','hi','','',''),(145,'MANUAL_PAYMENT_NOTIFICATION','en','Manual Payment Notify','Manual Payment Notification','A manual payment needs to be processed for the journal {$journalName} and the user &quot;{$senderUsername}&quot;.<br />\n<br />\nThe item being paid for is &quot;{$paymentName}&quot;.<br />\nThe cost is {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nThis email was generated by Open Journal Systems\' Manual Payment plugin.');
/*!40000 ALTER TABLE `email_templates_default_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_templates_settings`
--

DROP TABLE IF EXISTS `email_templates_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_templates_settings` (
  `email_template_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`email_template_setting_id`),
  UNIQUE KEY `email_templates_settings_unique` (`email_id`,`locale`,`setting_name`),
  KEY `email_templates_settings_email_id` (`email_id`),
  CONSTRAINT `email_templates_settings_email_id` FOREIGN KEY (`email_id`) REFERENCES `email_templates` (`email_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about custom email templates, including localized properties such as the subject and body.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_templates_settings`
--

LOCK TABLES `email_templates_settings` WRITE;
/*!40000 ALTER TABLE `email_templates_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_templates_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_log`
--

DROP TABLE IF EXISTS `event_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL COMMENT 'NULL if it''s system or automated event',
  `date_logged` datetime NOT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `message` text,
  `is_translated` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `event_log_user_id` (`user_id`),
  KEY `event_log_assoc` (`assoc_type`,`assoc_id`),
  CONSTRAINT `event_log_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COMMENT='A log of all events related to an object like a submission.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event_log`
--

LOCK TABLES `event_log` WRITE;
/*!40000 ALTER TABLE `event_log` DISABLE KEYS */;
INSERT INTO `event_log` (`log_id`, `assoc_type`, `assoc_id`, `user_id`, `date_logged`, `event_type`, `message`, `is_translated`) VALUES (5,1048585,2,6,'2025-06-25 14:00:35',268435458,'submission.event.general.metadataUpdated',0),(6,1048585,2,6,'2025-06-25 14:01:37',268435458,'submission.event.general.metadataUpdated',0),(7,1048585,2,6,'2025-06-25 14:02:30',268435458,'submission.event.general.metadataUpdated',0),(8,515,1,6,'2025-06-25 14:06:40',1342177281,'submission.event.fileUploaded',0),(9,1048585,2,6,'2025-06-25 14:06:40',1342177288,'submission.event.fileRevised',0),(10,515,1,6,'2025-06-25 14:06:46',1342177296,'submission.event.fileEdited',0),(11,1048585,2,6,'2025-06-25 14:08:47',268435457,'submission.event.submissionSubmitted',0),(12,1048585,2,6,'2025-06-25 14:10:30',805306371,'editor.submission.decision.skipReview.log',0),(13,515,2,6,'2025-06-25 14:10:30',1342177281,'submission.event.fileUploaded',0),(14,1048585,2,6,'2025-06-25 14:10:30',1342177288,'submission.event.fileRevised',0),(15,1048585,2,6,'2025-06-25 14:10:48',805306371,'editor.submission.decision.sendToProduction.log',0),(16,1048585,2,6,'2025-06-25 14:11:36',268435458,'submission.event.general.metadataUpdated',0),(17,1048585,2,6,'2025-06-25 14:11:45',268435462,'publication.event.scheduled',0),(18,1048585,2,6,'2025-06-25 14:12:14',268435458,'submission.event.general.metadataUpdated',0),(19,1048585,2,6,'2025-06-25 14:13:25',268435458,'submission.event.general.metadataUpdated',0),(20,1048585,2,1,'2025-06-25 15:07:53',268435458,'submission.event.general.metadataUpdated',0),(21,1048585,3,6,'2025-06-25 15:09:34',268435458,'submission.event.general.metadataUpdated',0),(22,1048585,2,6,'2025-06-25 15:11:05',268435462,'publication.event.published',0),(23,1048585,2,1,'2025-06-25 15:26:53',268435458,'submission.event.general.metadataUpdated',0),(24,1048585,4,6,'2025-06-25 16:14:10',268435458,'submission.event.general.metadataUpdated',0),(25,1048585,4,6,'2025-06-25 16:15:31',268435458,'submission.event.general.metadataUpdated',0),(26,515,3,6,'2025-06-25 16:17:00',1342177281,'submission.event.fileUploaded',0),(27,1048585,4,6,'2025-06-25 16:17:00',1342177288,'submission.event.fileRevised',0),(28,515,3,6,'2025-06-25 16:17:18',1342177296,'submission.event.fileEdited',0),(29,1048585,4,6,'2025-06-25 16:19:59',268435457,'submission.event.submissionSubmitted',0),(30,1048585,4,6,'2025-06-25 16:20:30',805306371,'editor.submission.decision.skipReview.log',0),(31,515,4,6,'2025-06-25 16:20:30',1342177281,'submission.event.fileUploaded',0),(32,1048585,4,6,'2025-06-25 16:20:30',1342177288,'submission.event.fileRevised',0),(33,515,5,6,'2025-06-25 16:21:25',1342177281,'submission.event.fileUploaded',0),(34,1048585,4,6,'2025-06-25 16:21:25',1342177288,'submission.event.fileRevised',0),(35,1048585,4,6,'2025-06-25 16:21:44',805306371,'editor.submission.decision.sendToProduction.log',0),(36,515,6,6,'2025-06-25 16:21:44',1342177281,'submission.event.fileUploaded',0),(37,1048585,4,6,'2025-06-25 16:21:44',1342177288,'submission.event.fileRevised',0),(38,1048585,4,6,'2025-06-25 16:22:03',268435458,'submission.event.general.metadataUpdated',0),(39,515,6,6,'2025-06-25 16:23:19',1342177288,'submission.event.revisionUploaded',0),(40,515,6,6,'2025-06-25 16:23:24',1342177296,'submission.event.fileEdited',0),(41,1048585,4,6,'2025-06-25 16:24:00',268435458,'submission.event.general.metadataUpdated',0),(42,1048585,4,6,'2025-06-25 16:24:10',268435462,'publication.event.scheduled',0),(43,1048585,4,6,'2025-06-25 16:25:29',268435462,'publication.event.published',0);
/*!40000 ALTER TABLE `event_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_log_settings`
--

DROP TABLE IF EXISTS `event_log_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_log_settings` (
  `event_log_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`event_log_setting_id`),
  UNIQUE KEY `event_log_settings_unique` (`log_id`,`setting_name`,`locale`),
  KEY `event_log_settings_log_id` (`log_id`),
  KEY `event_log_settings_name_value` (`setting_name`(50),`setting_value`(150)),
  CONSTRAINT `event_log_settings_log_id` FOREIGN KEY (`log_id`) REFERENCES `event_log` (`log_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=utf8 COMMENT='Data about an event log entry. This data is commonly used to display information about an event to a user.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event_log_settings`
--

LOCK TABLES `event_log_settings` WRITE;
/*!40000 ALTER TABLE `event_log_settings` DISABLE KEYS */;
INSERT INTO `event_log_settings` (`event_log_setting_id`, `log_id`, `locale`, `setting_name`, `setting_value`) VALUES (1,8,'','fileId','1'),(2,8,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(3,8,'','fileStage','2'),(4,8,'','submissionFileId','1'),(5,8,'','submissionId','2'),(6,8,'','username','bk'),(7,9,'','fileId','1'),(8,9,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(9,9,'','fileStage','2'),(10,9,'','submissionFileId','1'),(11,9,'','submissionId','2'),(12,9,'','username','bk'),(13,10,'','fileId','1'),(14,10,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(15,10,'','fileStage','2'),(16,10,'','submissionFileId','1'),(17,10,'','submissionId','2'),(18,10,'','username','bk'),(19,12,'','editorName','bk bk'),(20,13,'','fileId','1'),(21,13,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(22,13,'','fileStage','6'),(23,13,'','sourceSubmissionFileId','1'),(24,13,'','submissionFileId','2'),(25,13,'','submissionId','2'),(26,13,'','username','bk'),(27,14,'','fileId','1'),(28,14,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(29,14,'','fileStage','6'),(30,14,'','sourceSubmissionFileId','1'),(31,14,'','submissionFileId','2'),(32,14,'','submissionId','2'),(33,14,'','username','bk'),(34,15,'','editorName','bk bk'),(35,26,'','fileId','2'),(36,26,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(37,26,'','fileStage','2'),(38,26,'','submissionFileId','3'),(39,26,'','submissionId','4'),(40,26,'','username','bk'),(41,27,'','fileId','2'),(42,27,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(43,27,'','fileStage','2'),(44,27,'','submissionFileId','3'),(45,27,'','submissionId','4'),(46,27,'','username','bk'),(47,28,'','fileId','2'),(48,28,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(49,28,'','fileStage','2'),(50,28,'','submissionFileId','3'),(51,28,'','submissionId','4'),(52,28,'','username','bk'),(53,30,'','editorName','bk bk'),(54,31,'','fileId','2'),(55,31,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(56,31,'','fileStage','6'),(57,31,'','sourceSubmissionFileId','3'),(58,31,'','submissionFileId','4'),(59,31,'','submissionId','4'),(60,31,'','username','bk'),(61,32,'','fileId','2'),(62,32,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(63,32,'','fileStage','6'),(64,32,'','sourceSubmissionFileId','3'),(65,32,'','submissionFileId','4'),(66,32,'','submissionId','4'),(67,32,'','username','bk'),(68,33,'','fileId','2'),(69,33,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(70,33,'','fileStage','9'),(71,33,'','sourceSubmissionFileId','4'),(72,33,'','submissionFileId','5'),(73,33,'','submissionId','4'),(74,33,'','username','bk'),(75,34,'','fileId','2'),(76,34,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(77,34,'','fileStage','9'),(78,34,'','sourceSubmissionFileId','4'),(79,34,'','submissionFileId','5'),(80,34,'','submissionId','4'),(81,34,'','username','bk'),(82,35,'','editorName','bk bk'),(83,36,'','fileId','2'),(84,36,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(85,36,'','fileStage','11'),(86,36,'','sourceSubmissionFileId','5'),(87,36,'','submissionFileId','6'),(88,36,'','submissionId','4'),(89,36,'','username','bk'),(90,37,'','fileId','2'),(91,37,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(92,37,'','fileStage','11'),(93,37,'','sourceSubmissionFileId','5'),(94,37,'','submissionFileId','6'),(95,37,'','submissionId','4'),(96,37,'','username','bk'),(97,39,'','fileId','2'),(98,39,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(99,39,'','fileStage','11'),(100,39,'','sourceSubmissionFileId','5'),(101,39,'','submissionFileId','6'),(102,39,'','submissionId','4'),(103,39,'','username','bk'),(104,40,'','fileId','3'),(105,40,'en','filename','1. Article-Dr. K. V. Pradeep and Dr. N. Karunakaran-2024-Technia J.pdf'),(106,40,'','fileStage','11'),(107,40,'','sourceSubmissionFileId','5'),(108,40,'','submissionFileId','6'),(109,40,'','submissionId','4'),(110,40,'','username','bk');
/*!40000 ALTER TABLE `event_log_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A log of all failed jobs.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `files`
--

DROP TABLE IF EXISTS `files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `files` (
  `file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) NOT NULL,
  `mimetype` varchar(255) NOT NULL,
  PRIMARY KEY (`file_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='Records information in the database about files tracked by the system, linking them to the local filesystem.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `files`
--

LOCK TABLES `files` WRITE;
/*!40000 ALTER TABLE `files` DISABLE KEYS */;
INSERT INTO `files` (`file_id`, `path`, `mimetype`) VALUES (1,'journals/2/articles/2/685bb51868def.pdf','application/pdf'),(2,'journals/2/articles/4/685bd3a4d3a2d.pdf','application/pdf'),(3,'journals/2/articles/4/685bd51fb1208.pdf','application/pdf');
/*!40000 ALTER TABLE `files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `filter_groups`
--

DROP TABLE IF EXISTS `filter_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filter_groups` (
  `filter_group_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `input_type` varchar(255) DEFAULT NULL,
  `output_type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`filter_group_id`),
  UNIQUE KEY `filter_groups_symbolic` (`symbolic`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COMMENT='Filter groups are used to organized filters into named sets, which can be retrieved by the application for invocation.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `filter_groups`
--

LOCK TABLES `filter_groups` WRITE;
/*!40000 ALTER TABLE `filter_groups` DISABLE KEYS */;
INSERT INTO `filter_groups` (`filter_group_id`, `symbolic`, `display_name`, `description`, `input_type`, `output_type`) VALUES (1,'issue=>crossref-xml','plugins.importexport.crossref.displayName','plugins.importexport.crossref.description','class::classes.issue.Issue[]','xml::schema(https://www.crossref.org/schemas/crossref5.4.0.xsd)'),(2,'article=>crossref-xml','plugins.importexport.crossref.displayName','plugins.importexport.crossref.description','class::classes.submission.Submission[]','xml::schema(https://www.crossref.org/schemas/crossref5.4.0.xsd)'),(3,'issue=>datacite-xml','plugins.importexport.datacite.displayName','plugins.importexport.datacite.description','class::classes.issue.Issue','xml::schema(http://schema.datacite.org/meta/kernel-4/metadata.xsd)'),(4,'article=>datacite-xml','plugins.importexport.datacite.displayName','plugins.importexport.datacite.description','class::classes.submission.Submission','xml::schema(http://schema.datacite.org/meta/kernel-4/metadata.xsd)'),(5,'galley=>datacite-xml','plugins.importexport.datacite.displayName','plugins.importexport.datacite.description','class::lib.pkp.classes.galley.Galley','xml::schema(http://schema.datacite.org/meta/kernel-4/metadata.xsd)'),(6,'article=>dc11','plugins.metadata.dc11.articleAdapter.displayName','plugins.metadata.dc11.articleAdapter.description','class::classes.submission.Submission','metadata::APP\\plugins\\metadata\\dc11\\schema\\Dc11Schema(ARTICLE)'),(7,'user=>user-xml','plugins.importexport.users.displayName','plugins.importexport.users.description','class::PKP\\user\\User[]','xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)'),(8,'user-xml=>user','plugins.importexport.users.displayName','plugins.importexport.users.description','xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)','class::PKP\\user\\User[]'),(9,'usergroup=>user-xml','plugins.importexport.users.displayName','plugins.importexport.users.description','class::PKP\\userGroup\\UserGroup[]','xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)'),(10,'user-xml=>usergroup','plugins.importexport.native.displayName','plugins.importexport.native.description','xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)','class::PKP\\userGroup\\UserGroup[]'),(11,'article=>native-xml','plugins.importexport.native.displayName','plugins.importexport.native.description','class::classes.submission.Submission[]','xml::schema(plugins/importexport/native/native.xsd)'),(12,'native-xml=>article','plugins.importexport.native.displayName','plugins.importexport.native.description','xml::schema(plugins/importexport/native/native.xsd)','class::classes.submission.Submission[]'),(13,'issue=>native-xml','plugins.importexport.native.displayName','plugins.importexport.native.description','class::classes.issue.Issue[]','xml::schema(plugins/importexport/native/native.xsd)'),(14,'native-xml=>issue','plugins.importexport.native.displayName','plugins.importexport.native.description','xml::schema(plugins/importexport/native/native.xsd)','class::classes.issue.Issue[]'),(15,'issuegalley=>native-xml','plugins.importexport.native.displayName','plugins.importexport.native.description','class::classes.issue.IssueGalley[]','xml::schema(plugins/importexport/native/native.xsd)'),(16,'native-xml=>issuegalley','plugins.importexport.native.displayName','plugins.importexport.native.description','xml::schema(plugins/importexport/native/native.xsd)','class::classes.issue.IssueGalley[]'),(17,'author=>native-xml','plugins.importexport.native.displayName','plugins.importexport.native.description','class::classes.author.Author[]','xml::schema(plugins/importexport/native/native.xsd)'),(18,'native-xml=>author','plugins.importexport.native.displayName','plugins.importexport.native.description','xml::schema(plugins/importexport/native/native.xsd)','class::classes.author.Author[]'),(19,'SubmissionFile=>native-xml','plugins.importexport.native.displayName','plugins.importexport.native.description','class::lib.pkp.classes.submissionFile.SubmissionFile','xml::schema(plugins/importexport/native/native.xsd)'),(20,'native-xml=>SubmissionFile','plugins.importexport.native.displayName','plugins.importexport.native.description','xml::schema(plugins/importexport/native/native.xsd)','class::lib.pkp.classes.submissionFile.SubmissionFile[]'),(21,'article-galley=>native-xml','plugins.importexport.native.displayName','plugins.importexport.native.description','class::lib.pkp.classes.galley.Galley','xml::schema(plugins/importexport/native/native.xsd)'),(22,'native-xml=>ArticleGalley','plugins.importexport.native.displayName','plugins.importexport.native.description','xml::schema(plugins/importexport/native/native.xsd)','class::lib.pkp.classes.galley.Galley[]'),(23,'publication=>native-xml','plugins.importexport.native.displayName','plugins.importexport.native.description','class::classes.publication.Publication','xml::schema(plugins/importexport/native/native.xsd)'),(24,'native-xml=>Publication','plugins.importexport.native.displayName','plugins.importexport.native.description','xml::schema(plugins/importexport/native/native.xsd)','class::classes.publication.Publication[]'),(25,'article=>pubmed-xml','plugins.importexport.pubmed.displayName','plugins.importexport.pubmed.description','class::classes.submission.Submission[]','xml::dtd'),(26,'article=>doaj-xml','plugins.importexport.doaj.displayName','plugins.importexport.doaj.description','class::classes.submission.Submission[]','xml::schema(plugins/importexport/doaj/doajArticles.xsd)'),(27,'article=>doaj-json','plugins.importexport.doaj.displayName','plugins.importexport.doaj.description','class::classes.submission.Submission','primitive::string');
/*!40000 ALTER TABLE `filter_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `filter_settings`
--

DROP TABLE IF EXISTS `filter_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filter_settings` (
  `filter_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`filter_setting_id`),
  UNIQUE KEY `filter_settings_unique` (`filter_id`,`locale`,`setting_name`),
  KEY `filter_settings_id` (`filter_id`),
  CONSTRAINT `filter_settings_filter_id_foreign` FOREIGN KEY (`filter_id`) REFERENCES `filters` (`filter_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about filters, including localized content.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `filter_settings`
--

LOCK TABLES `filter_settings` WRITE;
/*!40000 ALTER TABLE `filter_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `filter_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `filters`
--

DROP TABLE IF EXISTS `filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filters` (
  `filter_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_group_id` bigint(20) NOT NULL,
  `context_id` bigint(20) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `class_name` varchar(255) DEFAULT NULL,
  `is_template` smallint(6) NOT NULL DEFAULT '0',
  `parent_filter_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`filter_id`),
  KEY `filters_filter_group_id` (`filter_group_id`),
  KEY `filters_context_id` (`context_id`),
  KEY `filters_parent_filter_id` (`parent_filter_id`),
  CONSTRAINT `filters_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `filters_filter_group_id_foreign` FOREIGN KEY (`filter_group_id`) REFERENCES `filter_groups` (`filter_group_id`) ON DELETE CASCADE,
  CONSTRAINT `filters_parent_filter_id_foreign` FOREIGN KEY (`parent_filter_id`) REFERENCES `filters` (`filter_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COMMENT='Filters represent a transformation of a supported piece of data from one form to another, such as a PHP object into an XML document.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `filters`
--

LOCK TABLES `filters` WRITE;
/*!40000 ALTER TABLE `filters` DISABLE KEYS */;
INSERT INTO `filters` (`filter_id`, `filter_group_id`, `context_id`, `display_name`, `class_name`, `is_template`, `parent_filter_id`, `seq`) VALUES (1,1,NULL,'Crossref XML issue export','APP\\plugins\\generic\\crossref\\filter\\IssueCrossrefXmlFilter',0,NULL,0),(2,2,NULL,'Crossref XML article export','APP\\plugins\\generic\\crossref\\filter\\ArticleCrossrefXmlFilter',0,NULL,0),(3,3,NULL,'DataCite XML export','APP\\plugins\\generic\\datacite\\filter\\DataciteXmlFilter',0,NULL,0),(4,4,NULL,'DataCite XML export','APP\\plugins\\generic\\datacite\\filter\\DataciteXmlFilter',0,NULL,0),(5,5,NULL,'DataCite XML export','APP\\plugins\\generic\\datacite\\filter\\DataciteXmlFilter',0,NULL,0),(6,6,NULL,'Extract metadata from a(n) Submission','APP\\plugins\\metadata\\dc11\\filter\\Dc11SchemaArticleAdapter',0,NULL,0),(7,7,NULL,'User XML user export','PKP\\plugins\\importexport\\users\\filter\\PKPUserUserXmlFilter',0,NULL,0),(8,8,NULL,'User XML user import','PKP\\plugins\\importexport\\users\\filter\\UserXmlPKPUserFilter',0,NULL,0),(9,9,NULL,'Native XML user group export','PKP\\plugins\\importexport\\users\\filter\\UserGroupNativeXmlFilter',0,NULL,0),(10,10,NULL,'Native XML user group import','PKP\\plugins\\importexport\\users\\filter\\NativeXmlUserGroupFilter',0,NULL,0),(11,11,NULL,'Native XML submission export','APP\\plugins\\importexport\\native\\filter\\ArticleNativeXmlFilter',0,NULL,0),(12,12,NULL,'Native XML submission import','APP\\plugins\\importexport\\native\\filter\\NativeXmlArticleFilter',0,NULL,0),(13,13,NULL,'Native XML issue export','APP\\plugins\\importexport\\native\\filter\\IssueNativeXmlFilter',0,NULL,0),(14,14,NULL,'Native XML issue import','APP\\plugins\\importexport\\native\\filter\\NativeXmlIssueFilter',0,NULL,0),(15,15,NULL,'Native XML issue galley export','APP\\plugins\\importexport\\native\\filter\\IssueGalleyNativeXmlFilter',0,NULL,0),(16,16,NULL,'Native XML issue galley import','APP\\plugins\\importexport\\native\\filter\\NativeXmlIssueGalleyFilter',0,NULL,0),(17,17,NULL,'Native XML author export','APP\\plugins\\importexport\\native\\filter\\AuthorNativeXmlFilter',0,NULL,0),(18,18,NULL,'Native XML author import','APP\\plugins\\importexport\\native\\filter\\NativeXmlAuthorFilter',0,NULL,0),(19,20,NULL,'Native XML submission file import','APP\\plugins\\importexport\\native\\filter\\NativeXmlArticleFileFilter',0,NULL,0),(20,19,NULL,'Native XML submission file export','PKP\\plugins\\importexport\\native\\filter\\SubmissionFileNativeXmlFilter',0,NULL,0),(21,21,NULL,'Native XML representation export','APP\\plugins\\importexport\\native\\filter\\ArticleGalleyNativeXmlFilter',0,NULL,0),(22,22,NULL,'Native XML representation import','APP\\plugins\\importexport\\native\\filter\\NativeXmlArticleGalleyFilter',0,NULL,0),(23,23,NULL,'Native XML Publication export','APP\\plugins\\importexport\\native\\filter\\PublicationNativeXmlFilter',0,NULL,0),(24,24,NULL,'Native XML publication import','APP\\plugins\\importexport\\native\\filter\\NativeXmlPublicationFilter',0,NULL,0),(25,25,NULL,'APP\\plugins\\importexport\\pubmed\\filter\\ArticlePubMedXmlFilter','APP\\plugins\\importexport\\pubmed\\filter\\ArticlePubMedXmlFilter',0,NULL,0),(26,26,NULL,'DOAJ XML export','APP\\plugins\\importexport\\doaj\\filter\\DOAJXmlFilter',0,NULL,0),(27,27,NULL,'DOAJ JSON export','APP\\plugins\\importexport\\doaj\\filter\\DOAJJsonFilter',0,NULL,0);
/*!40000 ALTER TABLE `filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genre_settings`
--

DROP TABLE IF EXISTS `genre_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genre_settings` (
  `genre_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `genre_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`genre_setting_id`),
  UNIQUE KEY `genre_settings_unique` (`genre_id`,`locale`,`setting_name`),
  KEY `genre_settings_genre_id` (`genre_id`),
  CONSTRAINT `genre_settings_genre_id_foreign` FOREIGN KEY (`genre_id`) REFERENCES `genres` (`genre_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COMMENT='More data about file genres, including localized properties such as the genre name.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genre_settings`
--

LOCK TABLES `genre_settings` WRITE;
/*!40000 ALTER TABLE `genre_settings` DISABLE KEYS */;
INSERT INTO `genre_settings` (`genre_setting_id`, `genre_id`, `locale`, `setting_name`, `setting_value`, `setting_type`) VALUES (1,1,'en','name','Article Text','string'),(2,2,'en','name','Research Instrument','string'),(3,3,'en','name','Research Materials','string'),(4,4,'en','name','Research Results','string'),(5,5,'en','name','Transcripts','string'),(6,6,'en','name','Data Analysis','string'),(7,7,'en','name','Data Set','string'),(8,8,'en','name','Source Texts','string'),(9,9,'en','name','Multimedia','string'),(10,10,'en','name','Image','string'),(11,11,'en','name','HTML Stylesheet','string'),(12,12,'en','name','Other','string'),(13,13,'en','name','Article Text','string'),(14,13,'hi','name','लेख पाठ','string'),(15,14,'en','name','Research Instrument','string'),(16,14,'hi','name','शोध उपकरण','string'),(17,15,'en','name','Research Materials','string'),(18,15,'hi','name','शोध सामग्री','string'),(19,16,'en','name','Research Results','string'),(20,16,'hi','name','शोध परिणाम','string'),(21,17,'en','name','Transcripts','string'),(22,17,'hi','name','प्रतिलिपि','string'),(23,18,'en','name','Data Analysis','string'),(24,18,'hi','name','डेटा विश्लेषण','string'),(25,19,'en','name','Data Set','string'),(26,19,'hi','name','डाटा सेट','string'),(27,20,'en','name','Source Texts','string'),(28,20,'hi','name','स्रोत पाठ','string'),(29,21,'en','name','Multimedia','string'),(30,21,'hi','name','##default.genres.multimedia##','string'),(31,22,'en','name','Image','string'),(32,22,'hi','name','##default.genres.image##','string'),(33,23,'en','name','HTML Stylesheet','string'),(34,23,'hi','name','##default.genres.styleSheet##','string'),(35,24,'en','name','Other','string'),(36,24,'hi','name','##default.genres.other##','string');
/*!40000 ALTER TABLE `genre_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genres`
--

DROP TABLE IF EXISTS `genres`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genres` (
  `genre_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `seq` bigint(20) NOT NULL,
  `enabled` smallint(6) NOT NULL DEFAULT '1',
  `category` bigint(20) NOT NULL DEFAULT '1',
  `dependent` smallint(6) NOT NULL DEFAULT '0',
  `supplementary` smallint(6) NOT NULL DEFAULT '0',
  `required` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Whether or not at least one file of this genre is required for a new submission.',
  `entry_key` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`genre_id`),
  KEY `genres_context_id` (`context_id`),
  CONSTRAINT `genres_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COMMENT='The types of submission files configured for each context, such as Article Text, Data Set, Transcript, etc.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genres`
--

LOCK TABLES `genres` WRITE;
/*!40000 ALTER TABLE `genres` DISABLE KEYS */;
INSERT INTO `genres` (`genre_id`, `context_id`, `seq`, `enabled`, `category`, `dependent`, `supplementary`, `required`, `entry_key`) VALUES (1,1,0,1,1,0,0,1,'SUBMISSION'),(2,1,1,1,3,0,1,0,'RESEARCHINSTRUMENT'),(3,1,2,1,3,0,1,0,'RESEARCHMATERIALS'),(4,1,3,1,3,0,1,0,'RESEARCHRESULTS'),(5,1,4,1,3,0,1,0,'TRANSCRIPTS'),(6,1,5,1,3,0,1,0,'DATAANALYSIS'),(7,1,6,1,3,0,1,0,'DATASET'),(8,1,7,1,3,0,1,0,'SOURCETEXTS'),(9,1,8,1,1,1,1,0,'MULTIMEDIA'),(10,1,9,1,2,1,0,0,'IMAGE'),(11,1,10,1,1,1,0,0,'STYLE'),(12,1,11,1,3,0,1,0,'OTHER'),(13,2,0,1,1,0,0,1,'SUBMISSION'),(14,2,1,1,3,0,1,0,'RESEARCHINSTRUMENT'),(15,2,2,1,3,0,1,0,'RESEARCHMATERIALS'),(16,2,3,1,3,0,1,0,'RESEARCHRESULTS'),(17,2,4,1,3,0,1,0,'TRANSCRIPTS'),(18,2,5,1,3,0,1,0,'DATAANALYSIS'),(19,2,6,1,3,0,1,0,'DATASET'),(20,2,7,1,3,0,1,0,'SOURCETEXTS'),(21,2,8,1,1,1,1,0,'MULTIMEDIA'),(22,2,9,1,2,1,0,0,'IMAGE'),(23,2,10,1,1,1,0,0,'STYLE'),(24,2,11,1,3,0,1,0,'OTHER');
/*!40000 ALTER TABLE `genres` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `highlight_settings`
--

DROP TABLE IF EXISTS `highlight_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `highlight_settings` (
  `highlight_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `highlight_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`highlight_setting_id`),
  UNIQUE KEY `highlight_settings_unique` (`highlight_id`,`locale`,`setting_name`),
  KEY `highlight_settings_highlight_id` (`highlight_id`),
  CONSTRAINT `highlight_settings_highlight_id_foreign` FOREIGN KEY (`highlight_id`) REFERENCES `highlights` (`highlight_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about highlights, including localized properties like title and description.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `highlight_settings`
--

LOCK TABLES `highlight_settings` WRITE;
/*!40000 ALTER TABLE `highlight_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `highlight_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `highlights`
--

DROP TABLE IF EXISTS `highlights`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `highlights` (
  `highlight_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `sequence` bigint(20) NOT NULL,
  `url` varchar(2047) NOT NULL,
  PRIMARY KEY (`highlight_id`),
  KEY `highlights_context_id` (`context_id`),
  CONSTRAINT `highlights_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Highlights are featured items that can be presented to users, for example on the homepage.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `highlights`
--

LOCK TABLES `highlights` WRITE;
/*!40000 ALTER TABLE `highlights` DISABLE KEYS */;
/*!40000 ALTER TABLE `highlights` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `institution_ip`
--

DROP TABLE IF EXISTS `institution_ip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `institution_ip` (
  `institution_ip_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `institution_id` bigint(20) NOT NULL,
  `ip_string` varchar(40) NOT NULL,
  `ip_start` bigint(20) NOT NULL,
  `ip_end` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`institution_ip_id`),
  KEY `institution_ip_institution_id` (`institution_id`),
  KEY `institution_ip_start` (`ip_start`),
  KEY `institution_ip_end` (`ip_end`),
  CONSTRAINT `institution_ip_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records IP address ranges and associates them with institutions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `institution_ip`
--

LOCK TABLES `institution_ip` WRITE;
/*!40000 ALTER TABLE `institution_ip` DISABLE KEYS */;
/*!40000 ALTER TABLE `institution_ip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `institution_settings`
--

DROP TABLE IF EXISTS `institution_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `institution_settings` (
  `institution_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `institution_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`institution_setting_id`),
  UNIQUE KEY `institution_settings_unique` (`institution_id`,`locale`,`setting_name`),
  KEY `institution_settings_institution_id` (`institution_id`),
  CONSTRAINT `institution_settings_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about institutions, including localized properties like names.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `institution_settings`
--

LOCK TABLES `institution_settings` WRITE;
/*!40000 ALTER TABLE `institution_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `institution_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `institutional_subscriptions`
--

DROP TABLE IF EXISTS `institutional_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `institutional_subscriptions` (
  `institutional_subscription_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subscription_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `mailing_address` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`institutional_subscription_id`),
  KEY `institutional_subscriptions_subscription_id` (`subscription_id`),
  KEY `institutional_subscriptions_institution_id` (`institution_id`),
  KEY `institutional_subscriptions_domain` (`domain`),
  CONSTRAINT `institutional_subscriptions_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE,
  CONSTRAINT `institutional_subscriptions_subscription_id` FOREIGN KEY (`subscription_id`) REFERENCES `subscriptions` (`subscription_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of institutional subscriptions, linking a subscription with an institution.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `institutional_subscriptions`
--

LOCK TABLES `institutional_subscriptions` WRITE;
/*!40000 ALTER TABLE `institutional_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `institutional_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `institutions`
--

DROP TABLE IF EXISTS `institutions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `institutions` (
  `institution_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `ror` varchar(255) DEFAULT NULL COMMENT 'ROR (Research Organization Registry) ID',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`institution_id`),
  KEY `institutions_context_id` (`context_id`),
  CONSTRAINT `institutions_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Institutions for statistics and subscriptions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `institutions`
--

LOCK TABLES `institutions` WRITE;
/*!40000 ALTER TABLE `institutions` DISABLE KEYS */;
/*!40000 ALTER TABLE `institutions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invitations`
--

DROP TABLE IF EXISTS `invitations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invitations` (
  `invitation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `key_hash` varchar(255) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `inviter_id` bigint(20) DEFAULT NULL,
  `expiry_date` datetime DEFAULT NULL,
  `payload` json DEFAULT NULL,
  `status` enum('INITIALIZED','PENDING','ACCEPTED','DECLINED','CANCELLED') NOT NULL,
  `email` varchar(255) DEFAULT NULL COMMENT 'When present, the email address of the invitation recipient; when null, user_id must be set and the email can be fetched from the users table.',
  `context_id` bigint(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`invitation_id`),
  KEY `invitations_user_id` (`user_id`),
  KEY `invitations_inviter_id` (`inviter_id`),
  KEY `invitations_context_id` (`context_id`),
  KEY `invitations_status_context_id_user_id_type_index` (`status`,`context_id`,`user_id`,`type`),
  KEY `invitations_expiry_date_index` (`expiry_date`),
  CONSTRAINT `invitations_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `invitations_inviter_id_foreign` FOREIGN KEY (`inviter_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `invitations_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Invitations are sent to request a person (by email) to allow them to accept or reject an operation or position, such as a board membership or a submission peer review.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invitations`
--

LOCK TABLES `invitations` WRITE;
/*!40000 ALTER TABLE `invitations` DISABLE KEYS */;
INSERT INTO `invitations` (`invitation_id`, `key_hash`, `type`, `user_id`, `inviter_id`, `expiry_date`, `payload`, `status`, `email`, `context_id`, `created_at`, `updated_at`) VALUES (1,NULL,'userRoleAssignment',1,1,NULL,'{\"orcid\": null, \"password\": null, \"username\": null, \"emailBody\": null, \"givenName\": null, \"familyName\": null, \"affiliation\": null, \"userCountry\": null, \"emailSubject\": null, \"passwordHashed\": null, \"orcidIsVerified\": null, \"userGroupsToAdd\": [{\"masthead\": true, \"dateStart\": \"2025-06-18\", \"userGroupId\": 14}], \"orcidAccessScope\": null, \"orcidAccessToken\": null, \"sendEmailAddress\": null, \"orcidAccessDenied\": null, \"orcidRefreshToken\": null, \"inviteStagePayload\": null, \"shouldUseInviteData\": null, \"orcidAccessExpiresOn\": null}','INITIALIZED',NULL,1,'2025-06-18 00:28:26','2025-06-18 00:28:26');
/*!40000 ALTER TABLE `invitations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `issue_files`
--

DROP TABLE IF EXISTS `issue_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `issue_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `file_name` varchar(90) NOT NULL,
  `file_type` varchar(255) NOT NULL,
  `file_size` bigint(20) NOT NULL,
  `content_type` bigint(20) NOT NULL,
  `original_file_name` varchar(127) DEFAULT NULL,
  `date_uploaded` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`file_id`),
  KEY `issue_files_issue_id` (`issue_id`),
  CONSTRAINT `issue_files_issue_id` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relationships between issues and issue files, such as cover images.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `issue_files`
--

LOCK TABLES `issue_files` WRITE;
/*!40000 ALTER TABLE `issue_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `issue_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `issue_galley_settings`
--

DROP TABLE IF EXISTS `issue_galley_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `issue_galley_settings` (
  `issue_galley_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `galley_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`issue_galley_setting_id`),
  UNIQUE KEY `issue_galley_settings_unique` (`galley_id`,`locale`,`setting_name`),
  KEY `issue_galley_settings_galley_id` (`galley_id`),
  CONSTRAINT `issue_galleys_settings_galley_id` FOREIGN KEY (`galley_id`) REFERENCES `issue_galleys` (`galley_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about issue galleys, including localized content such as labels.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `issue_galley_settings`
--

LOCK TABLES `issue_galley_settings` WRITE;
/*!40000 ALTER TABLE `issue_galley_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `issue_galley_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `issue_galleys`
--

DROP TABLE IF EXISTS `issue_galleys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `issue_galleys` (
  `galley_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `locale` varchar(28) DEFAULT NULL,
  `issue_id` bigint(20) NOT NULL,
  `file_id` bigint(20) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `url_path` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`galley_id`),
  KEY `issue_galleys_issue_id` (`issue_id`),
  KEY `issue_galleys_file_id` (`file_id`),
  KEY `issue_galleys_url_path` (`url_path`),
  CONSTRAINT `issue_galleys_file_id` FOREIGN KEY (`file_id`) REFERENCES `issue_files` (`file_id`) ON DELETE CASCADE,
  CONSTRAINT `issue_galleys_issue_id` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Issue galleys are representations of the entire issue in a single file, such as a complete issue PDF.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `issue_galleys`
--

LOCK TABLES `issue_galleys` WRITE;
/*!40000 ALTER TABLE `issue_galleys` DISABLE KEYS */;
/*!40000 ALTER TABLE `issue_galleys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `issue_settings`
--

DROP TABLE IF EXISTS `issue_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `issue_settings` (
  `issue_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`issue_setting_id`),
  UNIQUE KEY `issue_settings_unique` (`issue_id`,`locale`,`setting_name`),
  KEY `issue_settings_issue_id` (`issue_id`),
  KEY `issue_settings_name_value` (`setting_name`(50),`setting_value`(150)),
  CONSTRAINT `issue_settings_issue_id` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='More data about issues, including localized properties such as issue titles.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `issue_settings`
--

LOCK TABLES `issue_settings` WRITE;
/*!40000 ALTER TABLE `issue_settings` DISABLE KEYS */;
INSERT INTO `issue_settings` (`issue_setting_id`, `issue_id`, `locale`, `setting_name`, `setting_value`) VALUES (1,1,'en','description',''),(2,1,'en','title','SB-ACT-VOL1'),(3,2,'en','description','<p>This issue covers all the relevant themes of the times.</p>'),(4,2,'en','title','Tecnia Journal of Management Studie, Volume 19'),(5,3,'en','description','<p class=\"MsoNormal\" style=\"text-align: justify; line-height: 150%;\"><span style=\"font-size: 12.0pt; line-height: 150%; font-family: \'Times New Roman\',serif; mso-ansi-language: EN-IN;\">Tecnia Journals is envisioned as a multidisciplinary scholarly platform that brings together critical inquiry, empirical research, and reflective scholarship from a broad range of academic domains. The primary aim of the journal is to foster an inclusive and rigorous academic environment that not only accommodates traditional disciplinary boundaries but also encourages cross-sectoral dialogue and interdisciplinary contributions.</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify; line-height: 150%;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>'),(6,3,'en','title','Tecnia Journal of Management Studies');
/*!40000 ALTER TABLE `issue_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `issues`
--

DROP TABLE IF EXISTS `issues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `issues` (
  `issue_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `journal_id` bigint(20) NOT NULL,
  `volume` smallint(6) DEFAULT NULL,
  `number` varchar(40) DEFAULT NULL,
  `year` smallint(6) DEFAULT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  `date_published` datetime DEFAULT NULL,
  `date_notified` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `access_status` smallint(6) NOT NULL DEFAULT '1',
  `open_access_date` datetime DEFAULT NULL,
  `show_volume` smallint(6) NOT NULL DEFAULT '0',
  `show_number` smallint(6) NOT NULL DEFAULT '0',
  `show_year` smallint(6) NOT NULL DEFAULT '0',
  `show_title` smallint(6) NOT NULL DEFAULT '0',
  `style_file_name` varchar(90) DEFAULT NULL,
  `original_style_file_name` varchar(255) DEFAULT NULL,
  `url_path` varchar(64) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`issue_id`),
  KEY `issues_journal_id` (`journal_id`),
  KEY `issues_doi_id` (`doi_id`),
  KEY `issues_url_path` (`url_path`),
  CONSTRAINT `issues_doi_id_foreign` FOREIGN KEY (`doi_id`) REFERENCES `dois` (`doi_id`) ON DELETE SET NULL,
  CONSTRAINT `issues_journal_id` FOREIGN KEY (`journal_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='A list of all journal issues, with identifying information like year, number, volume, etc.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `issues`
--

LOCK TABLES `issues` WRITE;
/*!40000 ALTER TABLE `issues` DISABLE KEYS */;
INSERT INTO `issues` (`issue_id`, `journal_id`, `volume`, `number`, `year`, `published`, `date_published`, `date_notified`, `last_modified`, `access_status`, `open_access_date`, `show_volume`, `show_number`, `show_year`, `show_title`, `style_file_name`, `original_style_file_name`, `url_path`, `doi_id`) VALUES (1,1,1,'1',2025,0,'2025-07-31 00:00:00',NULL,'2025-06-18 06:17:08',1,NULL,1,1,1,1,NULL,NULL,NULL,NULL),(2,2,19,'1',2024,1,'2025-06-25 15:11:05',NULL,'2025-06-25 15:11:05',1,NULL,1,1,1,1,NULL,NULL,NULL,NULL),(3,2,19,'2',2025,1,'2025-06-25 00:00:00',NULL,'2025-06-25 16:26:51',1,NULL,1,1,1,1,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `issues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_batches`
--

DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` text NOT NULL,
  `options` mediumtext,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Job batches allow jobs to be collected into groups for managed processing.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `job_batches`
--

LOCK TABLES `job_batches` WRITE;
/*!40000 ALTER TABLE `job_batches` DISABLE KEYS */;
INSERT INTO `job_batches` (`id`, `name`, `total_jobs`, `pending_jobs`, `failed_jobs`, `failed_job_ids`, `options`, `cancelled_at`, `created_at`, `finished_at`) VALUES ('9f2e21d5-3943-4af6-9581-29e37da5d563','',0,0,0,'[]','a:0:{}',NULL,1750204849,NULL),('9f3d063d-fee8-4953-a8a6-080a0ca55d34','',1,0,0,'[]','a:0:{}',NULL,1750844465,1750844476),('9f3d20d9-95a8-4121-8661-adf0211bebf3','',1,0,0,'[]','a:0:{}',NULL,1750848929,1750848934);
/*!40000 ALTER TABLE `job_batches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_reserved_at_index` (`queue`,`reserved_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='All pending or in-progress jobs.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `journal_settings`
--

DROP TABLE IF EXISTS `journal_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `journal_settings` (
  `journal_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `journal_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`journal_setting_id`),
  UNIQUE KEY `journal_settings_unique` (`journal_id`,`locale`,`setting_name`),
  KEY `journal_settings_journal_id` (`journal_id`),
  CONSTRAINT `journal_settings_journal_id` FOREIGN KEY (`journal_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8 COMMENT='More data about journals, including localized properties like policies.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `journal_settings`
--

LOCK TABLES `journal_settings` WRITE;
/*!40000 ALTER TABLE `journal_settings` DISABLE KEYS */;
INSERT INTO `journal_settings` (`journal_setting_id`, `journal_id`, `locale`, `setting_name`, `setting_value`) VALUES (1,1,'en','acronym','Sb-Act-dy'),(2,1,'hi','acronym',NULL),(3,1,'en','authorGuidelines','<p>Authors are invited to make a submission to this journal. All submissions will be assessed by an editor to determine whether they meet the aims and scope of this journal. Those considered to be a good fit will be sent for peer review before determining whether they will be accepted or rejected.</p><p>Before making a submission, authors are responsible for obtaining permission to publish any material included with the submission, such as photos, documents and datasets. All authors identified on the submission must consent to be identified as an author. Where appropriate, research should be approved by an appropriate ethics committee in accordance with the legal requirements of the study\'s country.</p><p>An editor may desk reject a submission if it does not meet minimum standards of quality. Before submitting, please ensure that the study design and research argument are structured and articulated properly. The title should be concise and the abstract should be able to stand on its own. This will increase the likelihood of reviewers agreeing to review the paper. When you\'re satisfied that your submission meets this standard, please follow the checklist below to prepare your submission.</p>'),(4,1,'en','authorInformation','Interested in submitting to this journal? We recommend that you review the <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/Sb-Act-dy/about\">About the Journal</a> page for the journal\'s section policies, as well as the <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/Sb-Act-dy/about/submissions#authorGuidelines\">Author Guidelines</a>. Authors need to <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/Sb-Act-dy/user/register\">register</a> with the journal prior to submitting or, if already registered, can simply <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/index/login\">log in</a> and begin the five-step process.'),(5,1,'en','beginSubmissionHelp','<p>Thank you for submitting to the Sb-Act-dy-Sample. You will be asked to upload files, identify co-authors, and provide information such as the title and abstract.<p><p>Please read our <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/Sb-Act-dy/about/submissions\" target=\"_blank\">Submission Guidelines</a> if you have not done so already. When filling out the forms, provide as many details as possible in order to help our editors evaluate your work.</p><p>Once you begin, you can save your submission and come back to it later. You will be able to review and correct any information before you submit.</p>'),(6,1,'','contactEmail','bahuguna.tias@gmail.com'),(7,1,'','contactName','9811345938'),(8,1,'en','contributorsHelp','<p>Add details for all of the contributors to this submission. Contributors added here will be sent an email confirmation of the submission, as well as a copy of all editorial decisions recorded against this submission.</p><p>If a contributor can not be contacted by email, because they must remain anonymous or do not have an email account, please do not enter a fake email address. You can add information about this contributor in a message to the editor at a later step in the submission process.</p>'),(9,1,'','country','IN'),(10,1,'','defaultReviewMode','2'),(11,1,'en','description','<p>Test</p>'),(12,1,'hi','description',NULL),(13,1,'en','detailsHelp','<p>Please provide the following details to help us manage your submission in our system.</p>'),(14,1,'','copySubmissionAckPrimaryContact','0'),(15,1,'','copySubmissionAckAddress',''),(16,1,'','emailSignature','<br><br>—<br><p>This is an automated message from <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/Sb-Act-dy\">Sb-Act-dy-Sample</a>.</p>'),(17,1,'','enableDois','1'),(18,1,'','doiSuffixType','default'),(19,1,'','registrationAgency',''),(20,1,'','disableSubmissions','0'),(21,1,'','editorialStatsEmail','1'),(22,1,'en','forTheEditorsHelp','<p>Please provide the following details in order to help our editorial team manage your submission.</p><p>When entering metadata, provide entries that you think would be most helpful to the person managing your submission. This information can be changed before publication.</p>'),(23,1,'','itemsPerPage','25'),(24,1,'','keywords','request'),(25,1,'en','librarianInformation','We encourage research librarians to list this journal among their library\'s electronic journal holdings. As well, it may be worth noting that this journal\'s open source publishing system is suitable for libraries to host for their faculty members to use with journals they are involved in editing (see <a href=\"https://pkp.sfu.ca/ojs\">Open Journal Systems</a>).'),(26,1,'en','name','Sb-Act-dy-Sample'),(27,1,'hi','name',NULL),(28,1,'','notifyAllAuthors','1'),(29,1,'','numPageLinks','10'),(30,1,'','numWeeksPerResponse','4'),(31,1,'','numWeeksPerReview','4'),(32,1,'','numReviewsPerSubmission','0'),(33,1,'en','openAccessPolicy','This journal provides immediate open access to its content on the principle that making research freely available to the public supports a greater global exchange of knowledge.'),(34,1,'','orcidCity',''),(35,1,'','orcidClientId',''),(36,1,'','orcidClientSecret',''),(37,1,'','orcidEnabled','0'),(38,1,'','orcidLogLevel','ERROR'),(39,1,'','orcidSendMailToAuthorsOnPublication','0'),(40,1,'en','privacyStatement','<p>The names and email addresses entered in this journal site will be used exclusively for the stated purposes of this journal and will not be made available for any other purpose or to any other party.</p>'),(41,1,'en','readerInformation','We encourage readers to sign up for the publishing notification service for this journal. Use the <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/Sb-Act-dy/user/register\">Register</a> link at the top of the home page for the journal. This registration will result in the reader receiving the Table of Contents by email for each new issue of the journal. This list also allows the journal to claim a certain level of support or readership. See the journal\'s <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/Sb-Act-dy/about/submissions#privacyStatement\">Privacy Statement</a>, which assures readers that their name and email address will not be used for other purposes.'),(42,1,'en','reviewHelp','<p>Review the information you have entered before you complete your submission. You can change any of the details displayed here by clicking the edit button at the top of each section.</p><p>Once you complete your submission, a member of our editorial team will be assigned to review it. Please ensure the details you have entered here are as accurate as possible.</p>'),(43,1,'','submissionAcknowledgement','allAuthors'),(44,1,'en','submissionChecklist','<p>All submissions must meet the following requirements.</p><ul><li>This submission meets the requirements outlined in the <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/Sb-Act-dy/about/submissions\">Author Guidelines</a>.</li><li>This submission has not been previously published, nor is it before another journal for consideration.</li><li>All references have been checked for accuracy and completeness.</li><li>All tables and figures have been numbered and labeled.</li><li>Permission has been obtained to publish all photos, datasets and other material provided with this submission.</li></ul>'),(45,1,'','submitWithCategories','0'),(46,1,'','supportedAddedSubmissionLocales','[\"en\"]'),(47,1,'','supportedDefaultSubmissionLocale','en'),(48,1,'','supportedFormLocales','[\"en\"]'),(49,1,'','supportedLocales','[\"en\"]'),(50,1,'','supportedSubmissionLocales','[\"en\"]'),(51,1,'','supportedSubmissionMetadataLocales','[\"en\"]'),(52,1,'','themePluginPath','default'),(53,1,'en','uploadFilesHelp','<p>Provide any files our editorial team may need to evaluate your submission. In addition to the main work, you may wish to submit data sets, conflict of interest statements, or other supplementary files if these will be helpful for our editors.</p>'),(54,1,'','enableGeoUsageStats','disabled'),(55,1,'','enableInstitutionUsageStats','0'),(56,1,'','isSushiApiPublic','1'),(57,1,'en','abbreviation','Sb-Act-dy'),(58,1,'hi','abbreviation',NULL),(59,1,'en','clockssLicense','This journal utilizes the CLOCKSS system to create a distributed archiving system among participating libraries and permits those libraries to create permanent archives of the journal for purposes of preservation and restoration. <a href=\"https://clockss.org\">More...</a>'),(60,1,'','copyrightYearBasis','issue'),(61,1,'','enabledDoiTypes','[\"publication\"]'),(62,1,'','doiCreationTime','copyEditCreationTime'),(63,1,'','enableOai','1'),(64,1,'en','lockssLicense','This journal utilizes the LOCKSS system to create a distributed archiving system among participating libraries and permits those libraries to create permanent archives of the journal for purposes of preservation and restoration. <a href=\"https://www.lockss.org\">More...</a>'),(65,1,'','membershipFee','0'),(66,1,'','publicationFee','0'),(67,1,'','purchaseArticleFee','0'),(68,1,'','doiVersioning','0'),(69,1,'en','reviewerSuggestionsHelp','<p>When submitting, you have the option to suggest several potential reviewers. This can help streamline the review process and provide valueable input for the editorial team. Please choose reviewers who are expert in your field and have no conflict of interest with your work. This feature aims to enhance the review process and support a more efficient experience for both authors and editorial team.</p>'),(70,1,'','disableUserReg','0'),(71,1,'','restrictSiteAccess','1'),(72,1,'','restrictArticleAccess','1'),(73,1,'','sidebar','[\"makesubmissionblockplugin\"]'),(74,2,'en','acronym','Sb-Act-dyICT'),(75,2,'hi','acronym',NULL),(76,2,'en','authorGuidelines','<p>Authors are invited to make a submission to this journal. All submissions will be assessed by an editor to determine whether they meet the aims and scope of this journal. Those considered to be a good fit will be sent for peer review before determining whether they will be accepted or rejected.</p><p>Before making a submission, authors are responsible for obtaining permission to publish any material included with the submission, such as photos, documents and datasets. All authors identified on the submission must consent to be identified as an author. Where appropriate, research should be approved by an appropriate ethics committee in accordance with the legal requirements of the study\'s country.</p><p>An editor may desk reject a submission if it does not meet minimum standards of quality. Before submitting, please ensure that the study design and research argument are structured and articulated properly. The title should be concise and the abstract should be able to stand on its own. This will increase the likelihood of reviewers agreeing to review the paper. When you\'re satisfied that your submission meets this standard, please follow the checklist below to prepare your submission.</p>'),(77,2,'hi','authorGuidelines','##default.contextSettings.authorGuidelines##'),(78,2,'en','authorInformation','Interested in submitting to this journal? We recommend that you review the <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/about\">About the Journal</a> page for the journal\'s section policies, as well as the <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/about/submissions#authorGuidelines\">Author Guidelines</a>. Authors need to <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/user/register\">register</a> with the journal prior to submitting or, if already registered, can simply <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/index/login\">log in</a> and begin the five-step process.'),(79,2,'hi','authorInformation','इस जर्नल को प्रस्तुत करने के इच्छुक हैं? हम अनुशंसा करते हैं कि आप समीक्षा करें <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/about\">About the Journal</a> जर्नल की अनुभाग नीतियों के लिए पेज, साथ ही <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/about/submissions#authorGuidelines\">Author Guidelines</a>. लेखकों की जरूरत है <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/user/register\">register</a> with the journal prior to submitting or, if already registered, can simply <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/index/login\">log in</a> और पांच-चरण की प्रक्रिया शुरू करें.'),(80,2,'en','beginSubmissionHelp','<p>Thank you for submitting to the Sb-Act-dy-ICTSample. You will be asked to upload files, identify co-authors, and provide information such as the title and abstract.<p><p>Please read our <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/about/submissions\" target=\"_blank\">Submission Guidelines</a> if you have not done so already. When filling out the forms, provide as many details as possible in order to help our editors evaluate your work.</p><p>Once you begin, you can save your submission and come back to it later. You will be able to review and correct any information before you submit.</p>'),(81,2,'hi','beginSubmissionHelp','##default.submission.step.beforeYouBegin##'),(82,2,'','contactEmail','sbahuguna.bciit@gmail.com'),(83,2,'','contactName','SB'),(84,2,'en','contributorsHelp','<p>Add details for all of the contributors to this submission. Contributors added here will be sent an email confirmation of the submission, as well as a copy of all editorial decisions recorded against this submission.</p><p>If a contributor can not be contacted by email, because they must remain anonymous or do not have an email account, please do not enter a fake email address. You can add information about this contributor in a message to the editor at a later step in the submission process.</p>'),(85,2,'hi','contributorsHelp','##default.submission.step.contributors##'),(86,2,'','country','IN'),(87,2,'','defaultReviewMode','2'),(88,2,'en','description','<p>ICT Test Sample</p>'),(89,2,'hi','description',NULL),(90,2,'en','detailsHelp','<p>Please provide the following details to help us manage your submission in our system.</p>'),(91,2,'hi','detailsHelp','##default.submission.step.details##'),(92,2,'','copySubmissionAckPrimaryContact','0'),(93,2,'','copySubmissionAckAddress',''),(94,2,'','emailSignature','<br><br>—<br><p>This is an automated message from <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample\">Sb-Act-dy-ICTSample</a>.</p>'),(95,2,'','enableDois','1'),(96,2,'','doiSuffixType','default'),(97,2,'','registrationAgency',''),(98,2,'','disableSubmissions','0'),(99,2,'','editorialStatsEmail','1'),(100,2,'en','forTheEditorsHelp','<p>Please provide the following details in order to help our editorial team manage your submission.</p><p>When entering metadata, provide entries that you think would be most helpful to the person managing your submission. This information can be changed before publication.</p>'),(101,2,'hi','forTheEditorsHelp','##default.submission.step.forTheEditors##'),(102,2,'','itemsPerPage','25'),(103,2,'','keywords','request'),(104,2,'en','librarianInformation','We encourage research librarians to list this journal among their library\'s electronic journal holdings. As well, it may be worth noting that this journal\'s open source publishing system is suitable for libraries to host for their faculty members to use with journals they are involved in editing (see <a href=\"https://pkp.sfu.ca/ojs\">Open Journal Systems</a>).'),(105,2,'hi','librarianInformation','हम अपने पुस्तकालय की इलेक्ट्रॉनिक जर्नल होल्डिंग्स के बीच इस जर्नल को सूचीबद्ध करने के लिए अनुसंधान पुस्तकालयों को प्रोत्साहित करते हैं। साथ ही, यह ध्यान देने योग्य हो सकता है कि इस जर्नल का ओपन सोर्स पब्लिशिंग सिस्टम पुस्तकालयों के लिए उपयुक्त है कि वे अपने संकाय सदस्यों के लिए उन जर्नलस के साथ होस्ट करें जो वे संपादन में शामिल हैं। (see <a href=\"http://pkp.sfu.ca/ojs\">Open Journal Systems</a>).'),(106,2,'en','name','Sb-Act-dy-ICTSample'),(107,2,'hi','name',NULL),(108,2,'','notifyAllAuthors','1'),(109,2,'','numPageLinks','10'),(110,2,'','numWeeksPerResponse','4'),(111,2,'','numWeeksPerReview','4'),(112,2,'','numReviewsPerSubmission','0'),(113,2,'en','openAccessPolicy','This journal provides immediate open access to its content on the principle that making research freely available to the public supports a greater global exchange of knowledge.'),(114,2,'hi','openAccessPolicy','यह जर्नल सिद्धांत पर अपनी सामग्री के लिए तत्काल खुली पहुंच प्रदान करती है जो अनुसंधान को स्वतंत्र रूप से जनता के लिए उपलब्ध कराती है, ज्ञान के अधिक वैश्विक आदान-प्रदान का समर्थन करती है.'),(115,2,'','orcidCity',''),(116,2,'','orcidClientId',''),(117,2,'','orcidClientSecret',''),(118,2,'','orcidEnabled','0'),(119,2,'','orcidLogLevel','ERROR'),(120,2,'','orcidSendMailToAuthorsOnPublication','0'),(121,2,'en','privacyStatement','<p>The names and email addresses entered in this journal site will be used exclusively for the stated purposes of this journal and will not be made available for any other purpose or to any other party.</p>'),(122,2,'hi','privacyStatement','<p>इस जर्नल साइट में दर्ज किए गए नाम और ईमेल पते इस जर्नल के घोषित उद्देश्यों के लिए विशेष रूप से उपयोग किए जाएंगे और किसी अन्य उद्देश्य या किसी अन्य पार्टी के लिए उपलब्ध नहीं किए जाएंगे।.</p>'),(123,2,'en','readerInformation','We encourage readers to sign up for the publishing notification service for this journal. Use the <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/user/register\">Register</a> link at the top of the home page for the journal. This registration will result in the reader receiving the Table of Contents by email for each new issue of the journal. This list also allows the journal to claim a certain level of support or readership. See the journal\'s <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/about/submissions#privacyStatement\">Privacy Statement</a>, which assures readers that their name and email address will not be used for other purposes.'),(124,2,'hi','readerInformation','हम पाठकों को इस जर्नल के लिए प्रकाशन अधिसूचना सेवा के लिए साइन अप करने के लिए प्रोत्साहित करते हैं। उपयोग <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/user/register\">Register</a> जर्नल के लिए मुख पृष्ठ के शीर्ष पर लिंक हैं। यह पंजीकरण पाठक को जर्नल के प्रत्येक नए अंक के लिए ईमेल द्वारा सामग्री तालिका प्राप्त करने का परिणाम देगा। यह सूची जर्नल को एक निश्चित स्तर के समर्थन या पाठक का दावा करने की भी अनुमति देती है। जर्नल को देखें <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/about/submissions#privacyStatement\">Privacy Statement</a>, जो पाठकों को आश्वस्त करता है कि उनके नाम और ईमेल पते का उपयोग अन्य उद्देश्यों के लिए नहीं किया जाएगा.'),(125,2,'en','reviewHelp','<p>Review the information you have entered before you complete your submission. You can change any of the details displayed here by clicking the edit button at the top of each section.</p><p>Once you complete your submission, a member of our editorial team will be assigned to review it. Please ensure the details you have entered here are as accurate as possible.</p>'),(126,2,'hi','reviewHelp','##default.submission.step.review##'),(127,2,'','submissionAcknowledgement','allAuthors'),(128,2,'en','submissionChecklist','<p>All submissions must meet the following requirements.</p><ul><li>This submission meets the requirements outlined in the <a href=\"https://act-dy.info/ojs35/ojs-3.5.0-0/index.php/ICTSample/about/submissions\">Author Guidelines</a>.</li><li>This submission has not been previously published, nor is it before another journal for consideration.</li><li>All references have been checked for accuracy and completeness.</li><li>All tables and figures have been numbered and labeled.</li><li>Permission has been obtained to publish all photos, datasets and other material provided with this submission.</li></ul>'),(129,2,'hi','submissionChecklist','##default.contextSettings.checklist##'),(130,2,'','submitWithCategories','0'),(131,2,'','supportedAddedSubmissionLocales','[\"en\"]'),(132,2,'','supportedDefaultSubmissionLocale','en'),(133,2,'','supportedFormLocales','[\"en\"]'),(134,2,'','supportedLocales','[\"en\",\"hi\"]'),(135,2,'','supportedSubmissionLocales','[\"en\"]'),(136,2,'','supportedSubmissionMetadataLocales','[\"en\"]'),(137,2,'','themePluginPath','default'),(138,2,'en','uploadFilesHelp','<p>Provide any files our editorial team may need to evaluate your submission. In addition to the main work, you may wish to submit data sets, conflict of interest statements, or other supplementary files if these will be helpful for our editors.</p>'),(139,2,'hi','uploadFilesHelp','##default.submission.step.uploadFiles##'),(140,2,'','enableGeoUsageStats','disabled'),(141,2,'','enableInstitutionUsageStats','0'),(142,2,'','isSushiApiPublic','1'),(143,2,'en','abbreviation','Sb-Act-dyICT'),(144,2,'hi','abbreviation',NULL),(145,2,'en','clockssLicense','This journal utilizes the CLOCKSS system to create a distributed archiving system among participating libraries and permits those libraries to create permanent archives of the journal for purposes of preservation and restoration. <a href=\"https://clockss.org\">More...</a>'),(146,2,'hi','clockssLicense','यह जर्नल प्रतिभागी पुस्तकालयों के बीच वितरित संग्रह प्रणाली बनाने के लिए CLOCKSS प्रणाली का उपयोग करती है और उन पुस्तकालयों को संरक्षण और बहाली के प्रयोजनों के लिए जर्नल के स्थायी अभिलेखागार बनाने की अनुमति देती है।. <a href=\"http://clockss.org/\">More...</a>'),(147,2,'','copyrightYearBasis','issue'),(148,2,'','enabledDoiTypes','[\"publication\"]'),(149,2,'','doiCreationTime','copyEditCreationTime'),(150,2,'','enableOai','1'),(151,2,'en','lockssLicense','This journal utilizes the LOCKSS system to create a distributed archiving system among participating libraries and permits those libraries to create permanent archives of the journal for purposes of preservation and restoration. <a href=\"https://www.lockss.org\">More...</a>'),(152,2,'hi','lockssLicense','यह जर्नल प्रतिभागी पुस्तकालयों के बीच वितरित संग्रह प्रणाली बनाने के लिए LOCKSS प्रणाली का उपयोग करती है और उन पुस्तकालयों को संरक्षण और बहाली के प्रयोजनों के लिए जर्नल के स्थायी अभिलेखागार बनाने की अनुमति देती है।. <a href=\"http://www.lockss.org/\">More...</a>'),(153,2,'','membershipFee','0'),(154,2,'','publicationFee','0'),(155,2,'','purchaseArticleFee','0'),(156,2,'','doiVersioning','0'),(157,2,'en','reviewerSuggestionsHelp','<p>When submitting, you have the option to suggest several potential reviewers. This can help streamline the review process and provide valueable input for the editorial team. Please choose reviewers who are expert in your field and have no conflict of interest with your work. This feature aims to enhance the review process and support a more efficient experience for both authors and editorial team.</p>'),(158,2,'hi','reviewerSuggestionsHelp','##default.submission.step.reviewerSuggestions##'),(160,2,'en','pageHeaderLogoImage','{\"name\":\"images.jpeg\",\"uploadName\":\"pageHeaderLogoImage_en.jpg\",\"width\":225,\"height\":225,\"dateUploaded\":\"2025-06-25 15:52:02\"}'),(161,2,'','sidebar','[\"subscriptionblockplugin\"]'),(162,2,'en','pageFooter','<ul style=\"margin-top: 0cm;\" type=\"disc\">\n<li class=\"MsoNormal\" style=\"text-align: justify; line-height: 150%; mso-list: l0 level1 lfo1; tab-stops: list 36.0pt;\"><strong><span style=\"font-size: 12.0pt; line-height: 150%; font-family: \'Times New Roman\',serif; mso-ansi-language: EN-IN;\">Editorial Office Email:</span></strong><span style=\"font-size: 12.0pt; line-height: 150%; font-family: \'Times New Roman\',serif; mso-ansi-language: EN-IN;\"> </span><span lang=\"EN-GB\"><a href=\"mailto:editor@tecniajournals.com\"><span lang=\"EN-IN\" style=\"font-size: 12.0pt; line-height: 150%; font-family: \'Times New Roman\',serif; mso-ansi-language: EN-IN;\">editor@tecniajournals.com</span></a></span></li>\n<li class=\"MsoNormal\" style=\"text-align: justify; line-height: 150%; mso-list: l0 level1 lfo1; tab-stops: list 36.0pt;\"><strong><span style=\"font-size: 12.0pt; line-height: 150%; font-family: \'Times New Roman\',serif; mso-ansi-language: EN-IN;\">Physical Address:</span></strong><span style=\"font-size: 12.0pt; line-height: 150%; font-family: \'Times New Roman\',serif; mso-ansi-language: EN-IN;\"> Tecnia Institute of Advanced Studies, Sector-7, Rohini, New Delhi 110085, India.</span></li>\n<li class=\"MsoNormal\" style=\"text-align: justify; line-height: 150%; mso-list: l0 level1 lfo1; tab-stops: list 36.0pt;\"><strong><span style=\"font-size: 12.0pt; line-height: 150%; font-family: \'Times New Roman\',serif; mso-ansi-language: EN-IN;\">Phone:</span></strong><span style=\"font-size: 12.0pt; line-height: 150%; font-family: \'Times New Roman\',serif; mso-ansi-language: EN-IN;\"> +91-11-2778-XXXX | <strong>Fax:</strong> +91-11-2778-XXXX</span></li>\n</ul>\n<p><strong><span style=\"font-size: 12.0pt; line-height: 107%; font-family: \'Times New Roman\',serif; mso-fareast-font-family: Calibri; mso-fareast-theme-font: minor-latin; mso-ansi-language: EN-IN; mso-fareast-language: EN-US; mso-bidi-language: AR-SA;\">Social Media:</span></strong><span style=\"font-size: 12.0pt; line-height: 107%; font-family: \'Times New Roman\',serif; mso-fareast-font-family: Calibri; mso-fareast-theme-font: minor-latin; mso-ansi-language: EN-IN; mso-fareast-language: EN-US; mso-bidi-language: AR-SA;\"> LinkedIn, Twitter (@TecniaJournals), Facebook.</span></p>'),(163,2,'en','additionalHomeContent','<p>Welcome to Tecnia Journal of Mangement Studies</p>'),(164,2,'en','announcementsIntroduction','<p class=\"MsoNormal\" style=\"text-align: center;\" align=\"center\"><strong style=\"mso-bidi-font-weight: normal;\"><span lang=\"EN-US\" style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif;\">CALL FOR PAPERS</span></strong></p>\n<p class=\"MsoNormal\" style=\"text-align: center;\" align=\"center\"><strong><em><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\">Tecnia Journal of Management Studies</span></em></strong><strong><span style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif; mso-ansi-language: EN-IN;\"> (ISSN: 0975-7104) – Volumes 1 &amp; 2, 2025</span></strong><strong><span lang=\"EN-US\" style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif;\"><br></span></strong><span lang=\"EN-US\" style=\"font-size: 12.0pt; line-height: 115%; font-family: \'Amasis MT Pro\',serif;\"><br style=\"mso-special-character: line-break;\"><!-- [if !supportLineBreakNewLine]--><br style=\"mso-special-character: line-break;\"><!--[endif]--></span></p>'),(165,2,'','enableAnnouncements','1'),(166,2,'','numAnnouncementsHomepage','1'),(167,2,'en','dateFormatLong','F j, Y'),(168,2,'en','dateFormatShort','Y-m-d'),(169,2,'en','datetimeFormatLong','F j, Y - h:i A'),(170,2,'en','datetimeFormatShort','Y-m-d h:i A'),(171,2,'en','timeFormat','h:i A'),(172,2,'en','journalThumbnail','{\"name\":\"images.jpeg\",\"uploadName\":\"journalThumbnail_en.jpg\",\"width\":225,\"height\":225,\"dateUploaded\":\"2025-06-25 15:50:05\"}'),(173,2,'en','homepageImage','{\"name\":\"tecnia journal head (1).jpg\",\"uploadName\":\"homepageImage_en.jpg\",\"width\":2200,\"height\":400,\"dateUploaded\":\"2025-06-25 15:51:30\"}');
/*!40000 ALTER TABLE `journal_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `journals`
--

DROP TABLE IF EXISTS `journals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `journals` (
  `journal_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` varchar(32) NOT NULL,
  `seq` double NOT NULL DEFAULT '0' COMMENT 'Used to order lists of journals',
  `primary_locale` varchar(28) NOT NULL,
  `enabled` smallint(6) NOT NULL DEFAULT '1' COMMENT 'Controls whether or not the journal is considered "live" and will appear on the website. (Note that disabled journals may still be accessible, but only if the user knows the URL.)',
  `current_issue_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`journal_id`),
  UNIQUE KEY `journals_path` (`path`),
  KEY `journals_issue_id` (`current_issue_id`),
  CONSTRAINT `journals_current_issue_id_foreign` FOREIGN KEY (`current_issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='A list of all journals in the installation of OJS.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `journals`
--

LOCK TABLES `journals` WRITE;
/*!40000 ALTER TABLE `journals` DISABLE KEYS */;
INSERT INTO `journals` (`journal_id`, `path`, `seq`, `primary_locale`, `enabled`, `current_issue_id`) VALUES (1,'Sb-Act-dy',1,'en',1,NULL),(2,'ICTSample',2,'en',1,3);
/*!40000 ALTER TABLE `journals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `library_file_settings`
--

DROP TABLE IF EXISTS `library_file_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `library_file_settings` (
  `library_file_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object|date)',
  PRIMARY KEY (`library_file_setting_id`),
  UNIQUE KEY `library_file_settings_unique` (`file_id`,`locale`,`setting_name`),
  KEY `library_file_settings_file_id` (`file_id`),
  CONSTRAINT `library_file_settings_file_id_foreign` FOREIGN KEY (`file_id`) REFERENCES `library_files` (`file_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about library files, including localized content such as names.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `library_file_settings`
--

LOCK TABLES `library_file_settings` WRITE;
/*!40000 ALTER TABLE `library_file_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `library_file_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `library_files`
--

DROP TABLE IF EXISTS `library_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `library_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `original_file_name` varchar(255) NOT NULL,
  `file_type` varchar(255) NOT NULL,
  `file_size` bigint(20) NOT NULL,
  `type` smallint(6) NOT NULL,
  `date_uploaded` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `submission_id` bigint(20) DEFAULT NULL,
  `public_access` smallint(6) DEFAULT '0',
  PRIMARY KEY (`file_id`),
  KEY `library_files_context_id` (`context_id`),
  KEY `library_files_submission_id` (`submission_id`),
  CONSTRAINT `library_files_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `library_files_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Library files can be associated with the context (press/server/journal) or with individual submissions, and are typically forms, agreements, and other administrative documents that are not part of the scholarly content.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `library_files`
--

LOCK TABLES `library_files` WRITE;
/*!40000 ALTER TABLE `library_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `library_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metrics_context`
--

DROP TABLE IF EXISTS `metrics_context`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metrics_context` (
  `metrics_context_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_context_id`),
  KEY `metrics_context_load_id` (`load_id`),
  KEY `metrics_context_context_id` (`context_id`),
  CONSTRAINT `metrics_context_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views of the homepage.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metrics_context`
--

LOCK TABLES `metrics_context` WRITE;
/*!40000 ALTER TABLE `metrics_context` DISABLE KEYS */;
/*!40000 ALTER TABLE `metrics_context` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metrics_counter_submission_daily`
--

DROP TABLE IF EXISTS `metrics_counter_submission_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metrics_counter_submission_daily` (
  `metrics_counter_submission_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_daily_id`),
  UNIQUE KEY `msd_uc_load_id_context_id_submission_id_date` (`load_id`,`context_id`,`submission_id`,`date`),
  KEY `msd_load_id` (`load_id`),
  KEY `metrics_counter_submission_daily_context_id` (`context_id`),
  KEY `metrics_counter_submission_daily_submission_id` (`submission_id`),
  KEY `msd_context_id_submission_id` (`context_id`,`submission_id`),
  CONSTRAINT `msd_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `msd_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics matching the COUNTER R5 protocol for views and downloads of published submissions and galleys.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metrics_counter_submission_daily`
--

LOCK TABLES `metrics_counter_submission_daily` WRITE;
/*!40000 ALTER TABLE `metrics_counter_submission_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `metrics_counter_submission_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metrics_counter_submission_institution_daily`
--

DROP TABLE IF EXISTS `metrics_counter_submission_institution_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metrics_counter_submission_institution_daily` (
  `metrics_counter_submission_institution_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_institution_daily_id`),
  UNIQUE KEY `msid_uc_load_id_context_id_submission_id_institution_id_date` (`load_id`,`context_id`,`submission_id`,`institution_id`,`date`),
  KEY `msid_load_id` (`load_id`),
  KEY `metrics_counter_submission_institution_daily_context_id` (`context_id`),
  KEY `metrics_counter_submission_institution_daily_submission_id` (`submission_id`),
  KEY `metrics_counter_submission_institution_daily_institution_id` (`institution_id`),
  KEY `msid_context_id_submission_id` (`context_id`,`submission_id`),
  CONSTRAINT `msid_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `msid_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE,
  CONSTRAINT `msid_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics matching the COUNTER R5 protocol for views and downloads from institutions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metrics_counter_submission_institution_daily`
--

LOCK TABLES `metrics_counter_submission_institution_daily` WRITE;
/*!40000 ALTER TABLE `metrics_counter_submission_institution_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `metrics_counter_submission_institution_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metrics_counter_submission_institution_monthly`
--

DROP TABLE IF EXISTS `metrics_counter_submission_institution_monthly`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metrics_counter_submission_institution_monthly` (
  `metrics_counter_submission_institution_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `month` int(11) NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_institution_monthly_id`),
  UNIQUE KEY `msim_uc_context_id_submission_id_institution_id_month` (`context_id`,`submission_id`,`institution_id`,`month`),
  KEY `metrics_counter_submission_institution_monthly_context_id` (`context_id`),
  KEY `metrics_counter_submission_institution_monthly_submission_id` (`submission_id`),
  KEY `metrics_counter_submission_institution_monthly_institution_id` (`institution_id`),
  KEY `msim_context_id_submission_id` (`context_id`,`submission_id`),
  CONSTRAINT `msim_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `msim_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE,
  CONSTRAINT `msim_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics matching the COUNTER R5 protocol for views and downloads from institutions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metrics_counter_submission_institution_monthly`
--

LOCK TABLES `metrics_counter_submission_institution_monthly` WRITE;
/*!40000 ALTER TABLE `metrics_counter_submission_institution_monthly` DISABLE KEYS */;
/*!40000 ALTER TABLE `metrics_counter_submission_institution_monthly` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metrics_counter_submission_monthly`
--

DROP TABLE IF EXISTS `metrics_counter_submission_monthly`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metrics_counter_submission_monthly` (
  `metrics_counter_submission_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `month` int(11) NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_monthly_id`),
  UNIQUE KEY `msm_uc_context_id_submission_id_month` (`context_id`,`submission_id`,`month`),
  KEY `metrics_counter_submission_monthly_context_id` (`context_id`),
  KEY `metrics_counter_submission_monthly_submission_id` (`submission_id`),
  KEY `msm_context_id_submission_id` (`context_id`,`submission_id`),
  CONSTRAINT `msm_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `msm_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics matching the COUNTER R5 protocol for views and downloads of published submissions and galleys.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metrics_counter_submission_monthly`
--

LOCK TABLES `metrics_counter_submission_monthly` WRITE;
/*!40000 ALTER TABLE `metrics_counter_submission_monthly` DISABLE KEYS */;
/*!40000 ALTER TABLE `metrics_counter_submission_monthly` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metrics_issue`
--

DROP TABLE IF EXISTS `metrics_issue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metrics_issue` (
  `metrics_issue_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `issue_id` bigint(20) NOT NULL,
  `issue_galley_id` bigint(20) DEFAULT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_issue_id`),
  KEY `metrics_issue_load_id` (`load_id`),
  KEY `metrics_issue_context_id` (`context_id`),
  KEY `metrics_issue_issue_id` (`issue_id`),
  KEY `metrics_issue_issue_galley_id` (`issue_galley_id`),
  KEY `metrics_issue_context_id_issue_id` (`context_id`,`issue_id`),
  CONSTRAINT `metrics_issue_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `metrics_issue_issue_galley_id_foreign` FOREIGN KEY (`issue_galley_id`) REFERENCES `issue_galleys` (`galley_id`) ON DELETE CASCADE,
  CONSTRAINT `metrics_issue_issue_id_foreign` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views and downloads of published issues.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metrics_issue`
--

LOCK TABLES `metrics_issue` WRITE;
/*!40000 ALTER TABLE `metrics_issue` DISABLE KEYS */;
/*!40000 ALTER TABLE `metrics_issue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metrics_submission`
--

DROP TABLE IF EXISTS `metrics_submission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metrics_submission` (
  `metrics_submission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `representation_id` bigint(20) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `file_type` bigint(20) DEFAULT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_id`),
  KEY `ms_load_id` (`load_id`),
  KEY `metrics_submission_context_id` (`context_id`),
  KEY `metrics_submission_submission_id` (`submission_id`),
  KEY `metrics_submission_representation_id` (`representation_id`),
  KEY `metrics_submission_submission_file_id` (`submission_file_id`),
  KEY `ms_context_id_submission_id_assoc_type_file_type` (`context_id`,`submission_id`,`assoc_type`,`file_type`),
  CONSTRAINT `metrics_submission_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `metrics_submission_representation_id_foreign` FOREIGN KEY (`representation_id`) REFERENCES `publication_galleys` (`galley_id`) ON DELETE CASCADE,
  CONSTRAINT `metrics_submission_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  CONSTRAINT `metrics_submission_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views and downloads of published submissions and galleys.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metrics_submission`
--

LOCK TABLES `metrics_submission` WRITE;
/*!40000 ALTER TABLE `metrics_submission` DISABLE KEYS */;
/*!40000 ALTER TABLE `metrics_submission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metrics_submission_geo_daily`
--

DROP TABLE IF EXISTS `metrics_submission_geo_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metrics_submission_geo_daily` (
  `metrics_submission_geo_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  `metric_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_geo_daily_id`),
  UNIQUE KEY `msgd_uc_load_context_submission_c_r_c_date` (`load_id`,`context_id`,`submission_id`,`country`,`region`,`city`(80),`date`),
  KEY `msgd_load_id` (`load_id`),
  KEY `metrics_submission_geo_daily_context_id` (`context_id`),
  KEY `metrics_submission_geo_daily_submission_id` (`submission_id`),
  KEY `msgd_context_id_submission_id` (`context_id`,`submission_id`),
  CONSTRAINT `msgd_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `msgd_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics by country, region and city for views and downloads of published submissions and galleys.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metrics_submission_geo_daily`
--

LOCK TABLES `metrics_submission_geo_daily` WRITE;
/*!40000 ALTER TABLE `metrics_submission_geo_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `metrics_submission_geo_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metrics_submission_geo_monthly`
--

DROP TABLE IF EXISTS `metrics_submission_geo_monthly`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metrics_submission_geo_monthly` (
  `metrics_submission_geo_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `month` int(11) NOT NULL,
  `metric` int(11) NOT NULL,
  `metric_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_geo_monthly_id`),
  UNIQUE KEY `msgm_uc_context_submission_c_r_c_month` (`context_id`,`submission_id`,`country`,`region`,`city`(80),`month`),
  KEY `metrics_submission_geo_monthly_context_id` (`context_id`),
  KEY `metrics_submission_geo_monthly_submission_id` (`submission_id`),
  KEY `msgm_context_id_submission_id` (`context_id`,`submission_id`),
  CONSTRAINT `msgm_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `msgm_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics by country, region and city for views and downloads of published submissions and galleys.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metrics_submission_geo_monthly`
--

LOCK TABLES `metrics_submission_geo_monthly` WRITE;
/*!40000 ALTER TABLE `metrics_submission_geo_monthly` DISABLE KEYS */;
/*!40000 ALTER TABLE `metrics_submission_geo_monthly` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `navigation_menu_item_assignment_settings`
--

DROP TABLE IF EXISTS `navigation_menu_item_assignment_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `navigation_menu_item_assignment_settings` (
  `navigation_menu_item_assignment_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_menu_item_assignment_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`navigation_menu_item_assignment_setting_id`),
  UNIQUE KEY `navigation_menu_item_assignment_settings_unique` (`navigation_menu_item_assignment_id`,`locale`,`setting_name`),
  KEY `navigation_menu_item_assignment_settings_n_m_i_a_id` (`navigation_menu_item_assignment_id`),
  CONSTRAINT `assignment_settings_navigation_menu_item_assignment_id` FOREIGN KEY (`navigation_menu_item_assignment_id`) REFERENCES `navigation_menu_item_assignments` (`navigation_menu_item_assignment_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about navigation menu item assignments to navigation menus, including localized content.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `navigation_menu_item_assignment_settings`
--

LOCK TABLES `navigation_menu_item_assignment_settings` WRITE;
/*!40000 ALTER TABLE `navigation_menu_item_assignment_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `navigation_menu_item_assignment_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `navigation_menu_item_assignments`
--

DROP TABLE IF EXISTS `navigation_menu_item_assignments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `navigation_menu_item_assignments` (
  `navigation_menu_item_assignment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `navigation_menu_id` bigint(20) NOT NULL,
  `navigation_menu_item_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) DEFAULT '0',
  PRIMARY KEY (`navigation_menu_item_assignment_id`),
  KEY `navigation_menu_item_assignments_navigation_menu_id` (`navigation_menu_id`),
  KEY `navigation_menu_item_assignments_navigation_menu_item_id` (`navigation_menu_item_id`),
  KEY `navigation_menu_item_assignments_parent_id` (`parent_id`),
  CONSTRAINT `navigation_menu_item_assignments_navigation_menu_id_foreign` FOREIGN KEY (`navigation_menu_id`) REFERENCES `navigation_menus` (`navigation_menu_id`) ON DELETE CASCADE,
  CONSTRAINT `navigation_menu_item_assignments_navigation_menu_item_id_foreign` FOREIGN KEY (`navigation_menu_item_id`) REFERENCES `navigation_menu_items` (`navigation_menu_item_id`) ON DELETE CASCADE,
  CONSTRAINT `navigation_menu_item_assignments_parent_id` FOREIGN KEY (`parent_id`) REFERENCES `navigation_menu_items` (`navigation_menu_item_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COMMENT='Links navigation menu items to navigation menus.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `navigation_menu_item_assignments`
--

LOCK TABLES `navigation_menu_item_assignments` WRITE;
/*!40000 ALTER TABLE `navigation_menu_item_assignments` DISABLE KEYS */;
INSERT INTO `navigation_menu_item_assignments` (`navigation_menu_item_assignment_id`, `navigation_menu_id`, `navigation_menu_item_id`, `parent_id`, `seq`) VALUES (1,1,1,NULL,0),(2,1,2,NULL,1),(3,1,3,NULL,2),(4,1,4,3,0),(5,1,5,3,1),(6,1,6,3,2),(7,1,7,3,3),(8,2,8,NULL,0),(9,2,9,NULL,1),(10,2,10,NULL,2),(11,2,11,10,0),(12,2,12,10,1),(13,2,13,10,2),(14,2,14,10,3),(15,3,15,NULL,0),(16,3,16,NULL,1),(17,3,17,NULL,2),(18,3,18,NULL,3),(19,3,19,18,0),(20,3,20,18,1),(21,3,21,18,2),(22,3,22,18,3),(23,3,23,18,4),(24,4,25,NULL,0),(25,4,26,NULL,1),(26,4,27,NULL,2),(27,4,28,27,0),(28,4,29,27,1),(29,4,30,27,2),(30,4,31,27,3),(31,5,32,NULL,0),(32,5,33,NULL,1),(33,5,34,NULL,2),(34,5,35,NULL,3),(35,5,36,35,0),(36,5,37,35,1),(37,5,38,35,2),(38,5,39,35,3),(39,5,40,35,4);
/*!40000 ALTER TABLE `navigation_menu_item_assignments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `navigation_menu_item_settings`
--

DROP TABLE IF EXISTS `navigation_menu_item_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `navigation_menu_item_settings` (
  `navigation_menu_item_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_menu_item_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` longtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`navigation_menu_item_setting_id`),
  UNIQUE KEY `navigation_menu_item_settings_unique` (`navigation_menu_item_id`,`locale`,`setting_name`),
  KEY `navigation_menu_item_settings_navigation_menu_item_id` (`navigation_menu_item_id`),
  CONSTRAINT `navigation_menu_item_settings_navigation_menu_id` FOREIGN KEY (`navigation_menu_item_id`) REFERENCES `navigation_menu_items` (`navigation_menu_item_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8 COMMENT='More data about navigation menu items, including localized content such as names.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `navigation_menu_item_settings`
--

LOCK TABLES `navigation_menu_item_settings` WRITE;
/*!40000 ALTER TABLE `navigation_menu_item_settings` DISABLE KEYS */;
INSERT INTO `navigation_menu_item_settings` (`navigation_menu_item_setting_id`, `navigation_menu_item_id`, `locale`, `setting_name`, `setting_value`, `setting_type`) VALUES (1,1,'','titleLocaleKey','navigation.register','string'),(2,2,'','titleLocaleKey','navigation.login','string'),(3,3,'','titleLocaleKey','{$loggedInUsername}','string'),(4,4,'','titleLocaleKey','navigation.dashboard','string'),(5,5,'','titleLocaleKey','common.viewProfile','string'),(6,6,'','titleLocaleKey','navigation.admin','string'),(7,7,'','titleLocaleKey','user.logOut','string'),(8,8,'','titleLocaleKey','navigation.register','string'),(9,9,'','titleLocaleKey','navigation.login','string'),(10,10,'','titleLocaleKey','{$loggedInUsername}','string'),(11,11,'','titleLocaleKey','navigation.dashboard','string'),(12,12,'','titleLocaleKey','common.viewProfile','string'),(13,13,'','titleLocaleKey','navigation.admin','string'),(14,14,'','titleLocaleKey','user.logOut','string'),(15,15,'','titleLocaleKey','navigation.current','string'),(16,16,'','titleLocaleKey','navigation.archives','string'),(17,17,'','titleLocaleKey','manager.announcements','string'),(18,18,'','titleLocaleKey','navigation.about','string'),(19,19,'','titleLocaleKey','about.aboutContext','string'),(20,20,'','titleLocaleKey','about.submissions','string'),(21,21,'','titleLocaleKey','common.editorialMasthead','string'),(22,22,'','titleLocaleKey','manager.setup.privacyStatement','string'),(23,23,'','titleLocaleKey','about.contact','string'),(24,24,'','titleLocaleKey','common.search','string'),(25,25,'','titleLocaleKey','navigation.register','string'),(26,26,'','titleLocaleKey','navigation.login','string'),(27,27,'','titleLocaleKey','{$loggedInUsername}','string'),(28,28,'','titleLocaleKey','navigation.dashboard','string'),(29,29,'','titleLocaleKey','common.viewProfile','string'),(30,30,'','titleLocaleKey','navigation.admin','string'),(31,31,'','titleLocaleKey','user.logOut','string'),(32,32,'','titleLocaleKey','navigation.current','string'),(33,33,'','titleLocaleKey','navigation.archives','string'),(34,34,'','titleLocaleKey','manager.announcements','string'),(35,35,'','titleLocaleKey','navigation.about','string'),(36,36,'','titleLocaleKey','about.aboutContext','string'),(37,37,'','titleLocaleKey','about.submissions','string'),(38,38,'','titleLocaleKey','common.editorialMasthead','string'),(39,39,'','titleLocaleKey','manager.setup.privacyStatement','string'),(40,40,'','titleLocaleKey','about.contact','string'),(41,41,'','titleLocaleKey','common.search','string');
/*!40000 ALTER TABLE `navigation_menu_item_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `navigation_menu_items`
--

DROP TABLE IF EXISTS `navigation_menu_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `navigation_menu_items` (
  `navigation_menu_item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `path` varchar(255) DEFAULT '',
  `type` varchar(255) DEFAULT '',
  PRIMARY KEY (`navigation_menu_item_id`),
  KEY `navigation_menu_items_context_id` (`context_id`),
  CONSTRAINT `navigation_menu_items_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8 COMMENT='Navigation menu items are single elements within a navigation menu.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `navigation_menu_items`
--

LOCK TABLES `navigation_menu_items` WRITE;
/*!40000 ALTER TABLE `navigation_menu_items` DISABLE KEYS */;
INSERT INTO `navigation_menu_items` (`navigation_menu_item_id`, `context_id`, `path`, `type`) VALUES (1,NULL,NULL,'NMI_TYPE_USER_REGISTER'),(2,NULL,NULL,'NMI_TYPE_USER_LOGIN'),(3,NULL,NULL,'NMI_TYPE_USER_DASHBOARD'),(4,NULL,NULL,'NMI_TYPE_USER_DASHBOARD'),(5,NULL,NULL,'NMI_TYPE_USER_PROFILE'),(6,NULL,NULL,'NMI_TYPE_ADMINISTRATION'),(7,NULL,NULL,'NMI_TYPE_USER_LOGOUT'),(8,1,NULL,'NMI_TYPE_USER_REGISTER'),(9,1,NULL,'NMI_TYPE_USER_LOGIN'),(10,1,NULL,'NMI_TYPE_USER_DASHBOARD'),(11,1,NULL,'NMI_TYPE_USER_DASHBOARD'),(12,1,NULL,'NMI_TYPE_USER_PROFILE'),(13,1,NULL,'NMI_TYPE_ADMINISTRATION'),(14,1,NULL,'NMI_TYPE_USER_LOGOUT'),(15,1,NULL,'NMI_TYPE_CURRENT'),(16,1,NULL,'NMI_TYPE_ARCHIVES'),(17,1,NULL,'NMI_TYPE_ANNOUNCEMENTS'),(18,1,NULL,'NMI_TYPE_ABOUT'),(19,1,NULL,'NMI_TYPE_ABOUT'),(20,1,NULL,'NMI_TYPE_SUBMISSIONS'),(21,1,NULL,'NMI_TYPE_MASTHEAD'),(22,1,NULL,'NMI_TYPE_PRIVACY'),(23,1,NULL,'NMI_TYPE_CONTACT'),(24,1,NULL,'NMI_TYPE_SEARCH'),(25,2,NULL,'NMI_TYPE_USER_REGISTER'),(26,2,NULL,'NMI_TYPE_USER_LOGIN'),(27,2,NULL,'NMI_TYPE_USER_DASHBOARD'),(28,2,NULL,'NMI_TYPE_USER_DASHBOARD'),(29,2,NULL,'NMI_TYPE_USER_PROFILE'),(30,2,NULL,'NMI_TYPE_ADMINISTRATION'),(31,2,NULL,'NMI_TYPE_USER_LOGOUT'),(32,2,NULL,'NMI_TYPE_CURRENT'),(33,2,NULL,'NMI_TYPE_ARCHIVES'),(34,2,NULL,'NMI_TYPE_ANNOUNCEMENTS'),(35,2,NULL,'NMI_TYPE_ABOUT'),(36,2,NULL,'NMI_TYPE_ABOUT'),(37,2,NULL,'NMI_TYPE_SUBMISSIONS'),(38,2,NULL,'NMI_TYPE_MASTHEAD'),(39,2,NULL,'NMI_TYPE_PRIVACY'),(40,2,NULL,'NMI_TYPE_CONTACT'),(41,2,NULL,'NMI_TYPE_SEARCH');
/*!40000 ALTER TABLE `navigation_menu_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `navigation_menus`
--

DROP TABLE IF EXISTS `navigation_menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `navigation_menus` (
  `navigation_menu_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `area_name` varchar(255) DEFAULT '',
  `title` varchar(255) NOT NULL,
  PRIMARY KEY (`navigation_menu_id`),
  KEY `navigation_menus_context_id` (`context_id`),
  CONSTRAINT `navigation_menus_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Navigation menus on the website are installed with the software as a default set, and can be customized.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `navigation_menus`
--

LOCK TABLES `navigation_menus` WRITE;
/*!40000 ALTER TABLE `navigation_menus` DISABLE KEYS */;
INSERT INTO `navigation_menus` (`navigation_menu_id`, `context_id`, `area_name`, `title`) VALUES (1,NULL,'user','User Navigation Menu'),(2,1,'user','User Navigation Menu'),(3,1,'primary','Primary Navigation Menu'),(4,2,'user','User Navigation Menu'),(5,2,'primary','Primary Navigation Menu');
/*!40000 ALTER TABLE `navigation_menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notes` (
  `note_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `contents` text,
  PRIMARY KEY (`note_id`),
  KEY `notes_user_id` (`user_id`),
  KEY `notes_assoc` (`assoc_type`,`assoc_id`),
  CONSTRAINT `notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Notes allow users to annotate associated entities, such as submissions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notification_settings`
--

DROP TABLE IF EXISTS `notification_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_settings` (
  `notification_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `notification_id` bigint(20) NOT NULL,
  `locale` varchar(28) DEFAULT NULL,
  `setting_name` varchar(64) NOT NULL,
  `setting_value` mediumtext NOT NULL,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`notification_setting_id`),
  UNIQUE KEY `notification_settings_unique` (`notification_id`,`locale`,`setting_name`),
  KEY `notification_settings_notification_id` (`notification_id`),
  CONSTRAINT `notification_settings_notification_id_foreign` FOREIGN KEY (`notification_id`) REFERENCES `notifications` (`notification_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='More data about notifications, including localized properties.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notification_settings`
--

LOCK TABLES `notification_settings` WRITE;
/*!40000 ALTER TABLE `notification_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `notification_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notification_subscription_settings`
--

DROP TABLE IF EXISTS `notification_subscription_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_subscription_settings` (
  `setting_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `setting_name` varchar(64) NOT NULL,
  `setting_value` mediumtext NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `context_id` bigint(20) DEFAULT NULL,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`setting_id`),
  KEY `notification_subscription_settings_user_id` (`user_id`),
  KEY `notification_subscription_settings_context` (`context_id`),
  CONSTRAINT `notification_subscription_settings_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `notification_subscription_settings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Which email notifications a user has chosen to unsubscribe from.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notification_subscription_settings`
--

LOCK TABLES `notification_subscription_settings` WRITE;
/*!40000 ALTER TABLE `notification_subscription_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `notification_subscription_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `notification_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `level` bigint(20) NOT NULL,
  `type` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_read` datetime DEFAULT NULL,
  `assoc_type` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`notification_id`),
  KEY `notifications_context_id` (`context_id`),
  KEY `notifications_user_id` (`user_id`),
  KEY `notifications_context_id_user_id` (`context_id`,`user_id`,`level`),
  KEY `notifications_context_id_level` (`context_id`,`level`),
  KEY `notifications_assoc` (`assoc_type`,`assoc_id`),
  KEY `notifications_user_id_level` (`user_id`,`level`),
  CONSTRAINT `notifications_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  CONSTRAINT `notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8 COMMENT='User notifications created during certain operations.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notifications`
--

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
INSERT INTO `notifications` (`notification_id`, `context_id`, `user_id`, `level`, `type`, `date_created`, `date_read`, `assoc_type`, `assoc_id`) VALUES (45,2,1,3,16777247,'2025-06-25 14:08:47','2025-06-25 15:07:27',1048585,2),(46,2,6,3,16777247,'2025-06-25 14:08:47','2025-06-25 14:12:46',1048585,2),(47,2,NULL,2,16777243,'2025-06-25 14:08:47',NULL,1048585,2),(48,2,NULL,2,16777245,'2025-06-25 14:08:47',NULL,1048585,2),(49,2,6,2,16777254,'2025-06-25 14:10:48','2025-06-25 14:10:51',1048585,2),(51,2,6,2,268435477,'2025-06-25 15:11:05',NULL,259,2),(52,2,6,2,268435477,'2025-06-25 15:11:16',NULL,259,2),(53,2,5,2,268435477,'2025-06-25 15:11:16',NULL,259,2),(54,2,1,2,268435477,'2025-06-25 15:11:16',NULL,259,2),(57,2,1,3,16777247,'2025-06-25 16:19:59',NULL,1048585,4),(58,2,6,3,16777247,'2025-06-25 16:19:59',NULL,1048585,4),(59,2,NULL,2,16777243,'2025-06-25 16:19:59',NULL,1048585,4),(60,2,NULL,2,16777245,'2025-06-25 16:19:59',NULL,1048585,4),(61,2,6,2,16777254,'2025-06-25 16:21:44','2025-06-25 16:21:49',1048585,4),(62,2,6,2,268435477,'2025-06-25 16:25:29',NULL,259,3),(63,2,6,2,268435477,'2025-06-25 16:25:34',NULL,259,3),(64,2,5,2,268435477,'2025-06-25 16:25:34',NULL,259,3),(65,2,1,2,268435477,'2025-06-25 16:25:34',NULL,259,3);
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oai_resumption_tokens`
--

DROP TABLE IF EXISTS `oai_resumption_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oai_resumption_tokens` (
  `oai_resumption_token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(32) NOT NULL,
  `expire` bigint(20) NOT NULL,
  `record_offset` int(11) NOT NULL,
  `params` text,
  PRIMARY KEY (`oai_resumption_token_id`),
  UNIQUE KEY `oai_resumption_tokens_unique` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='OAI resumption tokens are used to allow for pagination of large result sets into manageable pieces.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oai_resumption_tokens`
--

LOCK TABLES `oai_resumption_tokens` WRITE;
/*!40000 ALTER TABLE `oai_resumption_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oai_resumption_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `plugin_settings`
--

DROP TABLE IF EXISTS `plugin_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `plugin_settings` (
  `plugin_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `plugin_name` varchar(80) NOT NULL,
  `context_id` bigint(20) DEFAULT NULL,
  `setting_name` varchar(80) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`plugin_setting_id`),
  UNIQUE KEY `plugin_settings_unique` (`plugin_name`,`context_id`,`setting_name`),
  KEY `plugin_settings_context_id` (`context_id`),
  KEY `plugin_settings_plugin_name` (`plugin_name`),
  CONSTRAINT `plugin_settings_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8 COMMENT='More data about plugins, including localized properties. This table is frequently used to store plugin-specific configuration.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `plugin_settings`
--

LOCK TABLES `plugin_settings` WRITE;
/*!40000 ALTER TABLE `plugin_settings` DISABLE KEYS */;
INSERT INTO `plugin_settings` (`plugin_setting_id`, `plugin_name`, `context_id`, `setting_name`, `setting_value`, `setting_type`) VALUES (1,'defaultthemeplugin',NULL,'enabled','1','bool'),(2,'tinymceplugin',NULL,'enabled','1','bool'),(3,'usageeventplugin',NULL,'enabled','1','bool'),(4,'developedbyblockplugin',NULL,'enabled','0','bool'),(5,'developedbyblockplugin',NULL,'seq','0','int'),(6,'languagetoggleblockplugin',NULL,'enabled','1','bool'),(7,'languagetoggleblockplugin',NULL,'seq','4','int'),(8,'googleanalyticsplugin',NULL,'enabled','0','bool'),(9,'googlescholarplugin',NULL,'enabled','1','bool'),(10,'urnpubidplugin',NULL,'enabled','0','bool'),(11,'pdfjsviewerplugin',NULL,'enabled','1','bool'),(12,'recommendbyauthorplugin',NULL,'enabled','1','bool'),(13,'recommendbysimilarityplugin',NULL,'enabled','1','bool'),(14,'tinymceplugin',1,'enabled','1','bool'),(15,'developedbyblockplugin',1,'enabled','1','bool'),(16,'developedbyblockplugin',1,'seq','0','int'),(17,'subscriptionblockplugin',1,'enabled','1','bool'),(18,'subscriptionblockplugin',1,'seq','2','int'),(19,'languagetoggleblockplugin',1,'enabled','1','bool'),(20,'languagetoggleblockplugin',1,'seq','4','int'),(21,'informationblockplugin',1,'enabled','1','bool'),(22,'informationblockplugin',1,'seq','7','int'),(23,'webfeedplugin',1,'enabled','1','bool'),(24,'webfeedplugin',1,'displayPage','homepage','string'),(25,'webfeedplugin',1,'displayItems','1','bool'),(26,'webfeedplugin',1,'recentItems','30','int'),(27,'webfeedplugin',1,'includeIdentifiers','0','bool'),(28,'lensgalleyplugin',1,'enabled','1','bool'),(29,'jatstemplateplugin',1,'enabled','1','bool'),(30,'dublincoremetaplugin',1,'enabled','1','bool'),(31,'googlescholarplugin',1,'enabled','1','bool'),(32,'htmlarticlegalleyplugin',1,'enabled','1','bool'),(33,'pdfjsviewerplugin',1,'enabled','1','bool'),(34,'defaultthemeplugin',1,'enabled','1','bool'),(35,'makesubmissionblockplugin',1,'enabled','1','bool'),(36,'tinymceplugin',2,'enabled','1','bool'),(37,'developedbyblockplugin',2,'enabled','0','bool'),(38,'developedbyblockplugin',2,'seq','0','int'),(39,'subscriptionblockplugin',2,'enabled','1','bool'),(40,'subscriptionblockplugin',2,'seq','2','int'),(41,'languagetoggleblockplugin',2,'enabled','1','bool'),(42,'languagetoggleblockplugin',2,'seq','4','int'),(43,'informationblockplugin',2,'enabled','1','bool'),(44,'informationblockplugin',2,'seq','7','int'),(45,'webfeedplugin',2,'enabled','1','bool'),(46,'webfeedplugin',2,'displayPage','homepage','string'),(47,'webfeedplugin',2,'displayItems','1','bool'),(48,'webfeedplugin',2,'recentItems','30','int'),(49,'webfeedplugin',2,'includeIdentifiers','0','bool'),(50,'lensgalleyplugin',2,'enabled','1','bool'),(51,'jatstemplateplugin',2,'enabled','1','bool'),(52,'dublincoremetaplugin',2,'enabled','1','bool'),(53,'googlescholarplugin',2,'enabled','1','bool'),(54,'htmlarticlegalleyplugin',2,'enabled','1','bool'),(55,'pdfjsviewerplugin',2,'enabled','1','bool'),(56,'defaultthemeplugin',2,'enabled','1','bool'),(57,'browseblockplugin',NULL,'enabled','1','bool'),(58,'informationblockplugin',NULL,'enabled','1','bool'),(59,'makesubmissionblockplugin',NULL,'enabled','1','bool'),(60,'subscriptionblockplugin',NULL,'enabled','1','bool'),(61,'announcementfeedplugin',NULL,'enabled','1','bool'),(62,'customblockmanagerplugin',NULL,'enabled','1','bool'),(63,'staticpagesplugin',NULL,'enabled','1','bool'),(64,'defaultthemeplugin',NULL,'typography','notoSans','string'),(65,'defaultthemeplugin',NULL,'baseColour','#1E6292','string'),(66,'defaultthemeplugin',NULL,'showDescriptionInJournalIndex','true','string'),(67,'defaultthemeplugin',NULL,'useHomepageImageAsHeader','true','string'),(68,'defaultthemeplugin',NULL,'displayStats','none','string'),(69,'browseblockplugin',2,'enabled','1','bool'),(70,'announcementfeedplugin',2,'enabled','1','bool'),(71,'customblockmanagerplugin',2,'enabled','1','bool');
/*!40000 ALTER TABLE `plugin_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `publication_categories`
--

DROP TABLE IF EXISTS `publication_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `publication_categories` (
  `publication_category_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `category_id` bigint(20) NOT NULL,
  PRIMARY KEY (`publication_category_id`),
  UNIQUE KEY `publication_categories_id` (`publication_id`,`category_id`),
  KEY `publication_categories_publication_id` (`publication_id`),
  KEY `publication_categories_category_id` (`category_id`),
  CONSTRAINT `publication_categories_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `publication_categories_publication_id_foreign` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Associates publications (and thus submissions) with categories.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `publication_categories`
--

LOCK TABLES `publication_categories` WRITE;
/*!40000 ALTER TABLE `publication_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `publication_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `publication_galley_settings`
--

DROP TABLE IF EXISTS `publication_galley_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `publication_galley_settings` (
  `publication_galley_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `galley_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`publication_galley_setting_id`),
  UNIQUE KEY `publication_galley_settings_unique` (`galley_id`,`locale`,`setting_name`),
  KEY `publication_galley_settings_galley_id` (`galley_id`),
  KEY `publication_galley_settings_name_value` (`setting_name`(50),`setting_value`(150)),
  CONSTRAINT `publication_galley_settings_galley_id` FOREIGN KEY (`galley_id`) REFERENCES `publication_galleys` (`galley_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about publication galleys, including localized content such as labels.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `publication_galley_settings`
--

LOCK TABLES `publication_galley_settings` WRITE;
/*!40000 ALTER TABLE `publication_galley_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `publication_galley_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `publication_galleys`
--

DROP TABLE IF EXISTS `publication_galleys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `publication_galleys` (
  `galley_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `locale` varchar(28) DEFAULT NULL,
  `publication_id` bigint(20) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `remote_url` varchar(2047) DEFAULT NULL,
  `is_approved` smallint(6) NOT NULL DEFAULT '0',
  `url_path` varchar(64) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`galley_id`),
  KEY `publication_galleys_publication_id` (`publication_id`),
  KEY `publication_galleys_submission_file_id` (`submission_file_id`),
  KEY `publication_galleys_doi_id` (`doi_id`),
  KEY `publication_galleys_url_path` (`url_path`),
  CONSTRAINT `publication_galleys_doi_id_foreign` FOREIGN KEY (`doi_id`) REFERENCES `dois` (`doi_id`) ON DELETE SET NULL,
  CONSTRAINT `publication_galleys_publication_id` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE,
  CONSTRAINT `publication_galleys_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Publication galleys are representations of a publication in a specific format, e.g. a PDF.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `publication_galleys`
--

LOCK TABLES `publication_galleys` WRITE;
/*!40000 ALTER TABLE `publication_galleys` DISABLE KEYS */;
/*!40000 ALTER TABLE `publication_galleys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `publication_settings`
--

DROP TABLE IF EXISTS `publication_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `publication_settings` (
  `publication_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`publication_setting_id`),
  UNIQUE KEY `publication_settings_unique` (`publication_id`,`locale`,`setting_name`),
  KEY `publication_settings_name_value` (`setting_name`(50),`setting_value`(150)),
  KEY `publication_settings_publication_id` (`publication_id`),
  CONSTRAINT `publication_settings_publication_id` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='More data about publications, including localized properties such as the title and abstract.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `publication_settings`
--

LOCK TABLES `publication_settings` WRITE;
/*!40000 ALTER TABLE `publication_settings` DISABLE KEYS */;
INSERT INTO `publication_settings` (`publication_setting_id`, `publication_id`, `locale`, `setting_name`, `setting_value`) VALUES (3,2,'en','title','Artificial Intelligence and Human Capital: A Review'),(4,2,'en','abstract','<table class=\"MsoTableGrid\" style=\"border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-yfti-tbllook: 1184; mso-padding-alt: 0cm 5.4pt 0cm 5.4pt;\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr style=\"mso-yfti-irow: 0; mso-yfti-firstrow: yes; mso-yfti-lastrow: yes; height: 247.6pt;\">\n<td style=\"width: 280.6pt; border: solid windowtext 1.0pt; mso-border-alt: solid windowtext .5pt; padding: 0cm 5.4pt 0cm 5.4pt; height: 247.6pt;\" valign=\"top\" width=\"374\">\n<p class=\"MsoNormal\" style=\"margin-bottom: 0cm; margin-top: 0cm; mso-margin-bottom-alt: 12.75pt; mso-margin-top-alt: 0cm; mso-add-space: auto; text-align: justify; line-height: 200%;\"><em style=\"mso-bidi-font-style: normal;\"><span style=\"font-size: 12.0pt; line-height: 200%; font-family: \'Times New Roman\',serif; mso-bidi-font-weight: bold;\">Artificial Intelligence (AI) has primarily impacted the global human capital. The human capital has been elucidated, focusing on their developing relationship with AI. The complex facets of human capital, including aptitude, proficiency, and competence, have been examined in this review, concentrating on the intricate association between AI and human capital. A secondary data analysis was conducted for this study, incorporating 16 studies that were meticulously chosen from online search engines. Key search words such as \"Human Capital and AI\" and \"AI and Human Resource Management\" were employed for collecting the articles. Compelling data was extracted from these articles to uncover the linkage between AI and human capital. The study yielded both affirmative and negative outcomes following a thorough review of articles. The research identified major concerns associated with AI-powered HR processes concerning bias, fairness, privacy, and security. It underscores the urgency for incorporating responsible AI practices and harnessing the potential of AI while mitigating risks and ensuring equitable human capital development. The connection between AI and human capital provides an invaluable resource for researchers, practitioners, and policymakers navigating the evolving landscape of workforce development in an era of AI-driven innovation.</span></em></p>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>'),(5,2,'en','copyrightHolder','Sb-Act-dy-ICTSample'),(6,2,'','copyrightYear','2025'),(7,2,'en','coverImage','{\"dateUploaded\":\"2025-06-25 15:26:53\",\"uploadName\":\"submission_2_2_coverImage_en.jpg\",\"altText\":\"\"}'),(8,4,'en','title','Changing face of Authority figures and Influencers in the new age : A Study of New Emerging Practices in the Indian Advertising Industry'),(9,4,'en','abstract','<table class=\"MsoTableGrid\" style=\"border-collapse: collapse; border: none; mso-border-alt: solid windowtext .5pt; mso-yfti-tbllook: 1184; mso-padding-alt: 0cm 5.4pt 0cm 5.4pt;\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr style=\"mso-yfti-irow: 0; mso-yfti-firstrow: yes; mso-yfti-lastrow: yes; height: 247.6pt;\">\n<td style=\"width: 280.6pt; border: solid windowtext 1.0pt; mso-border-alt: solid windowtext .5pt; padding: 0cm 5.4pt 0cm 5.4pt; height: 247.6pt;\" valign=\"top\" width=\"374\">\n<p class=\"MsoNormal\" style=\"margin-bottom: 0cm; text-align: justify; line-height: normal;\"><span style=\"font-size: 13.0pt; mso-bidi-font-size: 12.0pt; font-family: \'Times New Roman\',serif;\">Advertising is the key focus because it plays a pivotal role at the junction where the economy and culture interact. Advertising trends have evolved from the quintessentially traditional print ads and TV spots to new marketing strategies that include QR codes, co-branding, content marketing and online advertising. While print and TV are steadfast in the ad industry, new technology is opening new avenues to reach consumers. India’s ad revenue is expected to grow by a subdued 12% to $17.3 billion in 2023, according to a report by advertising agency GroupM. In marketing, authority figures can have a significant influence on customer decisions. Endorsements from celebrities, experts, or even satisfied customers can add credibility to a product or service. This can lead to increased sales and brand loyalty. Moreover, Influencer collaboration has moved beyond the status of merely being an improvement in the dynamic world of modern marketing, and has instead established itself as a crucial component of a well-planned marketing strategy. Leading organizations now assign particular budgets designed for influencer marketing campaigns in an effort to stay at the very forefront of industry trends. Every firm appears to be eager to utilize influencer marketing to its fullest potential as the market matures and changes. <em style=\"mso-bidi-font-style: normal;\">The research aims to propose an in-depth review on the strategic change happening in the Indian advertising industry in relation to the use of authority figures and influencers for promotional activities.</em></span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 0cm; margin-top: 0cm; mso-margin-bottom-alt: 12.75pt; mso-margin-top-alt: 0cm; mso-add-space: auto; text-align: justify; line-height: 200%;\"><span style=\"font-size: 12.0pt; line-height: 200%; font-family: \'Times New Roman\',serif; mso-fareast-font-family: \'Times New Roman\'; mso-fareast-language: EN-IN;\"> </span></p>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>'),(10,4,'en','copyrightHolder','Sb-Act-dy-ICTSample'),(11,4,'','copyrightYear','2025');
/*!40000 ALTER TABLE `publication_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `publications`
--

DROP TABLE IF EXISTS `publications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `publications` (
  `publication_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `access_status` bigint(20) DEFAULT '0',
  `date_published` date DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `primary_contact_id` bigint(20) DEFAULT NULL,
  `section_id` bigint(20) DEFAULT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `submission_id` bigint(20) NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '1',
  `url_path` varchar(64) DEFAULT NULL,
  `version` bigint(20) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  `issue_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`publication_id`),
  KEY `publications_primary_contact_id` (`primary_contact_id`),
  KEY `publications_section_id` (`section_id`),
  KEY `publications_submission_id` (`submission_id`),
  KEY `publications_doi_id` (`doi_id`),
  KEY `publications_issue_id_index` (`issue_id`),
  KEY `publications_url_path` (`url_path`),
  CONSTRAINT `publications_doi_id_foreign` FOREIGN KEY (`doi_id`) REFERENCES `dois` (`doi_id`) ON DELETE SET NULL,
  CONSTRAINT `publications_issue_id_foreign` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE SET NULL,
  CONSTRAINT `publications_primary_contact_id` FOREIGN KEY (`primary_contact_id`) REFERENCES `authors` (`author_id`) ON DELETE SET NULL,
  CONSTRAINT `publications_section_id` FOREIGN KEY (`section_id`) REFERENCES `sections` (`section_id`) ON DELETE SET NULL,
  CONSTRAINT `publications_submission_id` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='Each publication is one version of a submission.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `publications`
--

LOCK TABLES `publications` WRITE;
/*!40000 ALTER TABLE `publications` DISABLE KEYS */;
INSERT INTO `publications` (`publication_id`, `access_status`, `date_published`, `last_modified`, `primary_contact_id`, `section_id`, `seq`, `submission_id`, `status`, `url_path`, `version`, `doi_id`, `issue_id`) VALUES (2,0,'2025-06-25','2025-06-25 15:26:53',NULL,2,0,2,3,NULL,1,NULL,2),(3,0,NULL,'2025-06-25 15:09:34',NULL,2,0,3,1,NULL,1,NULL,NULL),(4,0,'2025-06-25','2025-06-25 16:25:29',NULL,2,0,4,3,NULL,1,NULL,3);
/*!40000 ALTER TABLE `publications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `queries`
--

DROP TABLE IF EXISTS `queries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queries` (
  `query_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `date_posted` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `closed` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`query_id`),
  KEY `queries_assoc_id` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Discussions, usually related to a submission, created by editors, authors and other editorial staff.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `queries`
--

LOCK TABLES `queries` WRITE;
/*!40000 ALTER TABLE `queries` DISABLE KEYS */;
/*!40000 ALTER TABLE `queries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `query_participants`
--

DROP TABLE IF EXISTS `query_participants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `query_participants` (
  `query_participant_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `query_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`query_participant_id`),
  UNIQUE KEY `query_participants_unique` (`query_id`,`user_id`),
  KEY `query_participants_query_id` (`query_id`),
  KEY `query_participants_user_id` (`user_id`),
  CONSTRAINT `query_participants_query_id_foreign` FOREIGN KEY (`query_id`) REFERENCES `queries` (`query_id`) ON DELETE CASCADE,
  CONSTRAINT `query_participants_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The users assigned to a discussion.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `query_participants`
--

LOCK TABLES `query_participants` WRITE;
/*!40000 ALTER TABLE `query_participants` DISABLE KEYS */;
/*!40000 ALTER TABLE `query_participants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `queued_payments`
--

DROP TABLE IF EXISTS `queued_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queued_payments` (
  `queued_payment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_created` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `payment_data` text,
  PRIMARY KEY (`queued_payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Unfulfilled (queued) payments, i.e. payments that have not yet been completed via an online payment system.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `queued_payments`
--

LOCK TABLES `queued_payments` WRITE;
/*!40000 ALTER TABLE `queued_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `queued_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `review_assignment_settings`
--

DROP TABLE IF EXISTS `review_assignment_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `review_assignment_settings` (
  `review_assignment_settings_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key.',
  `review_id` bigint(20) NOT NULL COMMENT 'Foreign key referencing record in review_assignments table',
  `locale` varchar(28) DEFAULT NULL COMMENT 'Locale key.',
  `setting_name` varchar(255) NOT NULL COMMENT 'Name of settings record.',
  `setting_value` mediumtext COMMENT 'Settings value.',
  PRIMARY KEY (`review_assignment_settings_id`),
  UNIQUE KEY `review_assignment_settings_unique` (`review_id`,`locale`,`setting_name`),
  KEY `review_assignment_settings_review_id` (`review_id`),
  CONSTRAINT `review_assignment_settings_review_id_foreign` FOREIGN KEY (`review_id`) REFERENCES `review_assignments` (`review_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `review_assignment_settings`
--

LOCK TABLES `review_assignment_settings` WRITE;
/*!40000 ALTER TABLE `review_assignment_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `review_assignment_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `review_assignments`
--

DROP TABLE IF EXISTS `review_assignments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `review_assignments` (
  `review_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `reviewer_id` bigint(20) NOT NULL,
  `competing_interests` text,
  `recommendation` smallint(6) DEFAULT NULL,
  `date_assigned` datetime DEFAULT NULL,
  `date_notified` datetime DEFAULT NULL,
  `date_confirmed` datetime DEFAULT NULL,
  `date_completed` datetime DEFAULT NULL,
  `date_considered` datetime DEFAULT NULL,
  `date_acknowledged` datetime DEFAULT NULL,
  `date_due` datetime DEFAULT NULL,
  `date_response_due` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reminder_was_automatic` smallint(6) NOT NULL DEFAULT '0',
  `declined` smallint(6) NOT NULL DEFAULT '0',
  `cancelled` smallint(6) NOT NULL DEFAULT '0',
  `date_cancelled` datetime DEFAULT NULL,
  `date_rated` datetime DEFAULT NULL,
  `date_reminded` datetime DEFAULT NULL,
  `quality` smallint(6) DEFAULT NULL,
  `review_round_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `review_method` smallint(6) NOT NULL DEFAULT '1',
  `round` smallint(6) NOT NULL DEFAULT '1',
  `step` smallint(6) NOT NULL DEFAULT '1',
  `review_form_id` bigint(20) DEFAULT NULL,
  `considered` smallint(6) DEFAULT NULL,
  `request_resent` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`review_id`),
  KEY `review_assignments_submission_id` (`submission_id`),
  KEY `review_assignments_reviewer_id` (`reviewer_id`),
  KEY `review_assignment_reviewer_round` (`review_round_id`,`reviewer_id`),
  KEY `review_assignments_form_id` (`review_form_id`),
  KEY `review_assignments_reviewer_review` (`reviewer_id`,`review_id`),
  CONSTRAINT `review_assignments_review_form_id_foreign` FOREIGN KEY (`review_form_id`) REFERENCES `review_forms` (`review_form_id`),
  CONSTRAINT `review_assignments_review_round_id_foreign` FOREIGN KEY (`review_round_id`) REFERENCES `review_rounds` (`review_round_id`),
  CONSTRAINT `review_assignments_reviewer_id_foreign` FOREIGN KEY (`reviewer_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `review_assignments_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data about peer review assignments for all submissions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `review_assignments`
--

LOCK TABLES `review_assignments` WRITE;
/*!40000 ALTER TABLE `review_assignments` DISABLE KEYS */;
/*!40000 ALTER TABLE `review_assignments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `review_files`
--

DROP TABLE IF EXISTS `review_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `review_files` (
  `review_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_id` bigint(20) NOT NULL,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`review_file_id`),
  UNIQUE KEY `review_files_unique` (`review_id`,`submission_file_id`),
  KEY `review_files_review_id` (`review_id`),
  KEY `review_files_submission_file_id` (`submission_file_id`),
  CONSTRAINT `review_files_review_id_foreign` FOREIGN KEY (`review_id`) REFERENCES `review_assignments` (`review_id`) ON DELETE CASCADE,
  CONSTRAINT `review_files_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of the submission files made available to each assigned reviewer.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `review_files`
--

LOCK TABLES `review_files` WRITE;
/*!40000 ALTER TABLE `review_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `review_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `review_form_element_settings`
--

DROP TABLE IF EXISTS `review_form_element_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `review_form_element_settings` (
  `review_form_element_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_element_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`review_form_element_setting_id`),
  UNIQUE KEY `review_form_element_settings_unique` (`review_form_element_id`,`locale`,`setting_name`),
  KEY `review_form_element_settings_review_form_element_id` (`review_form_element_id`),
  CONSTRAINT `review_form_element_settings_review_form_element_id` FOREIGN KEY (`review_form_element_id`) REFERENCES `review_form_elements` (`review_form_element_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about review form elements, including localized content such as question text.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `review_form_element_settings`
--

LOCK TABLES `review_form_element_settings` WRITE;
/*!40000 ALTER TABLE `review_form_element_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `review_form_element_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `review_form_elements`
--

DROP TABLE IF EXISTS `review_form_elements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `review_form_elements` (
  `review_form_element_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `review_form_id` bigint(20) NOT NULL,
  `seq` double DEFAULT NULL,
  `element_type` bigint(20) DEFAULT NULL,
  `required` smallint(6) DEFAULT NULL,
  `included` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`review_form_element_id`),
  KEY `review_form_elements_review_form_id` (`review_form_id`),
  CONSTRAINT `review_form_elements_review_form_id` FOREIGN KEY (`review_form_id`) REFERENCES `review_forms` (`review_form_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each review form element represents a single question on a review form.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `review_form_elements`
--

LOCK TABLES `review_form_elements` WRITE;
/*!40000 ALTER TABLE `review_form_elements` DISABLE KEYS */;
/*!40000 ALTER TABLE `review_form_elements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `review_form_responses`
--

DROP TABLE IF EXISTS `review_form_responses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `review_form_responses` (
  `review_form_response_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_element_id` bigint(20) NOT NULL,
  `review_id` bigint(20) NOT NULL,
  `response_type` varchar(6) DEFAULT NULL,
  `response_value` text,
  PRIMARY KEY (`review_form_response_id`),
  KEY `review_form_responses_review_form_element_id` (`review_form_element_id`),
  KEY `review_form_responses_review_id` (`review_id`),
  KEY `review_form_responses_unique` (`review_form_element_id`,`review_id`),
  CONSTRAINT `review_form_responses_review_form_element_id_foreign` FOREIGN KEY (`review_form_element_id`) REFERENCES `review_form_elements` (`review_form_element_id`) ON DELETE CASCADE,
  CONSTRAINT `review_form_responses_review_id_foreign` FOREIGN KEY (`review_id`) REFERENCES `review_assignments` (`review_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each review form response records a reviewer''s answer to a review form element associated with a peer review.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `review_form_responses`
--

LOCK TABLES `review_form_responses` WRITE;
/*!40000 ALTER TABLE `review_form_responses` DISABLE KEYS */;
/*!40000 ALTER TABLE `review_form_responses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `review_form_settings`
--

DROP TABLE IF EXISTS `review_form_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `review_form_settings` (
  `review_form_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`review_form_setting_id`),
  UNIQUE KEY `review_form_settings_unique` (`review_form_id`,`locale`,`setting_name`),
  KEY `review_form_settings_review_form_id` (`review_form_id`),
  CONSTRAINT `review_form_settings_review_form_id` FOREIGN KEY (`review_form_id`) REFERENCES `review_forms` (`review_form_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about review forms, including localized content such as names.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `review_form_settings`
--

LOCK TABLES `review_form_settings` WRITE;
/*!40000 ALTER TABLE `review_form_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `review_form_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `review_forms`
--

DROP TABLE IF EXISTS `review_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `review_forms` (
  `review_form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `seq` double DEFAULT NULL,
  `is_active` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Review forms provide custom templates for peer reviews with several types of questions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `review_forms`
--

LOCK TABLES `review_forms` WRITE;
/*!40000 ALTER TABLE `review_forms` DISABLE KEYS */;
/*!40000 ALTER TABLE `review_forms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `review_round_files`
--

DROP TABLE IF EXISTS `review_round_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `review_round_files` (
  `review_round_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `review_round_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`review_round_file_id`),
  UNIQUE KEY `review_round_files_unique` (`submission_id`,`review_round_id`,`submission_file_id`),
  KEY `review_round_files_submission_id` (`submission_id`),
  KEY `review_round_files_review_round_id` (`review_round_id`),
  KEY `review_round_files_submission_file_id` (`submission_file_id`),
  CONSTRAINT `review_round_files_review_round_id_foreign` FOREIGN KEY (`review_round_id`) REFERENCES `review_rounds` (`review_round_id`) ON DELETE CASCADE,
  CONSTRAINT `review_round_files_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  CONSTRAINT `review_round_files_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records the files made available to reviewers for a round of reviews. These can be further customized on a per review basis with review_files.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `review_round_files`
--

LOCK TABLES `review_round_files` WRITE;
/*!40000 ALTER TABLE `review_round_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `review_round_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `review_rounds`
--

DROP TABLE IF EXISTS `review_rounds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `review_rounds` (
  `review_round_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  `round` smallint(6) NOT NULL,
  `review_revision` bigint(20) DEFAULT NULL,
  `status` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`review_round_id`),
  UNIQUE KEY `review_rounds_submission_id_stage_id_round_pkey` (`submission_id`,`stage_id`,`round`),
  KEY `review_rounds_submission_id` (`submission_id`),
  CONSTRAINT `review_rounds_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Peer review assignments are organized into multiple rounds on a submission.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `review_rounds`
--

LOCK TABLES `review_rounds` WRITE;
/*!40000 ALTER TABLE `review_rounds` DISABLE KEYS */;
/*!40000 ALTER TABLE `review_rounds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reviewer_suggestion_settings`
--

DROP TABLE IF EXISTS `reviewer_suggestion_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reviewer_suggestion_settings` (
  `reviewer_suggestion_id` bigint(20) NOT NULL COMMENT 'The foreign key mapping of this setting to reviewer_suggestions table',
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  UNIQUE KEY `reviewer_suggestion_settings_unique` (`reviewer_suggestion_id`,`locale`,`setting_name`),
  KEY `reviewer_suggestion_settings_reviewer_suggestion_id` (`reviewer_suggestion_id`),
  KEY `reviewer_suggestion_settings_locale_setting_name_index` (`setting_name`,`locale`),
  CONSTRAINT `reviewer_suggestion_settings_reviewer_suggestion_id_foreign` FOREIGN KEY (`reviewer_suggestion_id`) REFERENCES `reviewer_suggestions` (`reviewer_suggestion_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Reviewer suggestion settings table to contain multilingual or extra information';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reviewer_suggestion_settings`
--

LOCK TABLES `reviewer_suggestion_settings` WRITE;
/*!40000 ALTER TABLE `reviewer_suggestion_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `reviewer_suggestion_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reviewer_suggestions`
--

DROP TABLE IF EXISTS `reviewer_suggestions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reviewer_suggestions` (
  `reviewer_suggestion_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `suggesting_user_id` bigint(20) DEFAULT NULL COMMENT 'The user/author who has made the suggestion',
  `submission_id` bigint(20) NOT NULL COMMENT 'Submission at which the suggestion was made',
  `email` varchar(255) NOT NULL COMMENT 'Suggested reviewer email address',
  `orcid_id` varchar(255) DEFAULT NULL COMMENT 'Suggested reviewer optional Orcid Id',
  `approved_at` timestamp NULL DEFAULT NULL COMMENT 'If and when the suggestion approved to add/invite suggested_reviewer',
  `approver_id` bigint(20) DEFAULT NULL COMMENT 'The user who has approved the suggestion',
  `reviewer_id` bigint(20) DEFAULT NULL COMMENT 'The reviewer who has been added/invited through this suggestion',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`reviewer_suggestion_id`),
  KEY `reviewer_suggestions_suggesting_user_id` (`suggesting_user_id`),
  KEY `reviewer_suggestions_submission_id` (`submission_id`),
  KEY `reviewer_suggestions_approver_id_foreign` (`approver_id`),
  KEY `reviewer_suggestions_reviewer_id_foreign` (`reviewer_id`),
  CONSTRAINT `reviewer_suggestions_approver_id_foreign` FOREIGN KEY (`approver_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL,
  CONSTRAINT `reviewer_suggestions_reviewer_id_foreign` FOREIGN KEY (`reviewer_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL,
  CONSTRAINT `reviewer_suggestions_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE,
  CONSTRAINT `reviewer_suggestions_suggesting_user_id_foreign` FOREIGN KEY (`suggesting_user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Author suggested reviewers at the submission time';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reviewer_suggestions`
--

LOCK TABLES `reviewer_suggestions` WRITE;
/*!40000 ALTER TABLE `reviewer_suggestions` DISABLE KEYS */;
/*!40000 ALTER TABLE `reviewer_suggestions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ror_settings`
--

DROP TABLE IF EXISTS `ror_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ror_settings` (
  `ror_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ror_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`ror_setting_id`),
  UNIQUE KEY `ror_settings_unique` (`ror_id`,`locale`,`setting_name`),
  CONSTRAINT `ror_settings_ror_id_foreign` FOREIGN KEY (`ror_id`) REFERENCES `rors` (`ror_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=148586 DEFAULT CHARSET=utf8 COMMENT='More data about Ror registry dataset cache';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ror_settings`
--

LOCK TABLES `ror_settings` WRITE;
/*!40000 ALTER TABLE `ror_settings` DISABLE KEYS */;
INSERT INTO `ror_settings` (`ror_setting_id`, `ror_id`, `locale`, `setting_name`, `setting_value`) VALUES (1,1,'en','name','National University of Río Cuarto'),(2,1,'es','name','Universidad Nacional de Río Cuarto'),(3,2,'no_lang_code','name','Bundelkhand University'),(4,3,'en','name','Hokuyukai Neurology Hospital'),(5,3,'ja','name','医療法人北祐会 北祐会神経内科病院'),(6,4,'en','name','First Affiliated Hospital of Xiamen University'),(7,4,'zh','name','厦门大学附属第一医院'),(8,5,'en','name','Liverpool Heart and Chest Hospital'),(9,6,'en','name','Piedmont Atlanta Hospital'),(10,7,'en','name','Autonomous University of San Luis Potosí'),(11,7,'es','name','Universidad Autónoma de San Luis Potosí'),(12,8,'en','name','Centre for European Policy Studies'),(13,9,'no_lang_code','name','Biomarker Technologies (China)'),(14,9,'zh','name','百迈客生物科技'),(15,10,'de','name','Max-Planck-Institut für Medizinische Forschung'),(16,10,'en','name','Max Planck Institute for Medical Research'),(17,11,'ar','name','مستشفى العين'),(18,11,'en','name','Al Ain Hospital'),(19,12,'en','name','Sawai Man Singh Hospital'),(20,13,'en','name','Queen Sirikit National Institute of Child Health'),(21,14,'ar','name','مستشفى المفرق'),(22,14,'no_lang_code','name','Mafraq Hospital'),(23,15,'bn','name','ময়মনসিংহ মেডিকেল কলেজ'),(24,15,'en','name','Mymensingh Medical College Hospital'),(25,16,'en','name','Western Galilee Hospital'),(26,17,'en','name','National Skin Centre'),(27,18,'en','name','Baptist Hospital of Miami'),(28,19,'en','name','Korea University of Science and Technology'),(29,19,'ko','name','과학기술연합대학원대학교'),(30,20,'en','name','VA Connecticut Healthcare System'),(31,21,'fr','name','Hôpital de la Providence'),(32,22,'no_lang_code','name','Medical Decision Logic'),(33,23,'fr','name','Centre Hospitalier Saint-Charles'),(34,24,'ar','name','مستشفى رفيق الحريري الجامعي‎‎'),(35,24,'no_lang_code','name','Rafik Hariri University Hospital'),(36,25,'en','name','Health & Medical Publishing Group'),(37,26,'en','name','Memphis VA Medical Center'),(38,27,'en','name','Social Insurance Yokohama Central Hospital'),(39,27,'ja','name','横浜中央病院'),(40,28,'en','name','Institute of Public Health'),(41,28,'sq','name','Instituti i Shëndetit Publik'),(42,29,'en','name','Bridgeport Hospital'),(43,30,'en','name','NHS Tayside'),(44,31,'en','name','Franklin W. Olin College of Engineering'),(45,32,'en','name','Saint Agnes Hospital'),(46,33,'en','name','University of Tennessee Health Science Center'),(47,34,'en','name','Hannah Research Foundation'),(48,35,'ja','name','東京都立大塚病院'),(49,35,'no_lang_code','name','Tokyo Metropolitan Ohtsuka Hospital'),(50,36,'en','name','Government Medical College Bhavnagar'),(51,37,'no_lang_code','name','Ballard Power Systems (Canada)'),(52,38,'en','name','Northwestern Health Sciences University'),(53,39,'en','name','Gajara Raja Medical College'),(54,40,'en','name','National Center for Complementary and Integrative Health'),(55,41,'en','name','National University of Trujillo'),(56,41,'es','name','Universidad Nacional de Trujillo'),(57,42,'en','name','Centennial Medical Center'),(58,43,'ro','name','Unitatea Executiva Pentru Finantarea Invatamantului Superior Si A Cercetarii Stiintifice Universitare'),(59,44,'en','name','University of Science and Arts of Oklahoma'),(60,45,'en','name','New Britain General Hospital'),(61,46,'en','name','Medical Technology and Practice Patterns Institute'),(62,47,'en','name','Toyota Technological Institute'),(63,47,'ja','name','豊田工業大学'),(64,48,'en','name','Capital Regional District'),(65,49,'en','name','Darent Valley Hospital'),(66,50,'no_lang_code','name','State of The Art'),(67,51,'tr','name','Eskişehir Osmangazi Üniversitesi Tıp Fakültesi Hastanesi'),(68,52,'en','name','The Fourth People\'s Hospital'),(69,53,'fr','name','HIA du Val-de-Grâce à Paris, Hôpital d\'instruction des armées du Val-de-Grâce'),(70,54,'en','name','St Mary\'s Hospital'),(71,55,'en','name','Covenant Health'),(72,56,'en','name','Kuang Tien General Hospital'),(73,56,'zh','name','光田綜合醫院'),(74,57,'en','name','Institute for Interdisciplinary Studies of Austrian Universities'),(75,58,'en','name','Aberdeen Maternity Hospital'),(76,59,'en','name','Hunter Medical Research Institute'),(77,60,'en','name','Nottingham City Hospital'),(78,61,'en','name','Monroe Community Hospital'),(79,62,'en','name','National Institute of Public Health'),(80,62,'ja','name','国立保健医療科学院'),(81,63,'en','name','Bir Hospital'),(82,63,'ne','name','बीर अस्पताल'),(83,64,'no_lang_code','name','TIBCO Software (United States)'),(84,65,'en','name','Luigi Sacco Hospital'),(85,65,'it','name','Ospedale Luigi Sacco'),(86,66,'it','name','Ospedale San Paolo'),(87,67,'ko','name','부평 힘찬병원'),(88,67,'no_lang_code','name','Himchan Hospital'),(89,68,'en','name','Community Medical Center'),(90,69,'en','name','California Pacific University'),(91,70,'en','name','Geological Society of America'),(92,71,'en','name','Southern Taiwan University of Science and Technology'),(93,72,'de','name','München Klinik Schwabing'),(94,73,'en','name','Avila University'),(95,74,'en','name','Inoue Hospital'),(96,74,'ja','name','井上病院'),(97,75,'pt','name','Instituto Superior de Educação e Trabalho'),(98,76,'en','name','Tufts Medical Center'),(99,77,'en','name','Vikram University'),(100,77,'hi','name','विक्रम विश्वविद्यालय'),(101,78,'en','name','Mary Crowley Cancer Research Center'),(102,79,'en','name','Seoul Medical Center'),(103,79,'ko','name','서울 의료원'),(104,80,'en','name','Henrietta Egleston Hospital for Children'),(105,81,'ja','name','青山学院大学'),(106,81,'no_lang_code','name','Aoyama Gakuin University'),(107,82,'en','name','Shaikh Zayed Hospital'),(108,83,'tr','name','Mareşal Çakmak Askeri Hastanesi'),(109,84,'en','name','Kuakini Medical Center'),(110,85,'en','name','Waikato Hospital'),(111,86,'en','name','Ganesh Shankar Vidyarthi Memorial Medical College'),(112,86,'hi','name','गणेश शंकर विद्यार्थी मेमोरियल मेडिकल कॉलेज'),(113,87,'en','name','Goa Medical College'),(114,87,'pt','name','Escola Médico-Cirúrgica de Goa'),(115,88,'en','name','Henan Provincial Institute of Occupational Health'),(116,88,'zh','name','职业健康河南省研究所'),(117,89,'en','name','Hankyong National University'),(118,89,'ko','name','한경대학교'),(119,90,'en','name','Chubu National Hospital'),(120,90,'ja','name','中部国立病院'),(121,91,'ja','name','甲子園大学'),(122,91,'no_lang_code','name','Koshien University'),(123,92,'en','name','Texas A&M University System'),(124,92,'es','name','Sistema Universitario Texas A&M'),(125,93,'en','name','National Institute of Biomedical Imaging and Bioengineering'),(126,94,'en','name','Exploratorium'),(127,95,'en','name','Newman University'),(128,96,'ko','name','광주기독병원'),(129,96,'no_lang_code','name','Kwangju Christian Hospital'),(130,97,'en','name','Walsh University'),(131,98,'fr','name','Centre Technique Des Industries De La Fonderie'),(132,99,'no_lang_code','name','Litron Laboratories (United States)'),(133,100,'it','name','Ospedale Antonio Cardarelli'),(134,101,'pt','name','Hospital Madre Teresa'),(135,102,'en','name','Haskins Laboratories'),(136,103,'en','name','Advocate Health Care'),(137,104,'en','name','Michigan Public Health Institute'),(138,105,'pt','name','Instituto Superior de Administração e Línguas'),(139,106,'no_lang_code','name','Lourdes Hospital'),(140,107,'en','name','St. Luke\'s Hospital'),(141,107,'mt','name','L-Isptar San Luqa'),(142,108,'en','name','Christchurch Hospital'),(143,109,'en','name','Holy Spirit Northside Private Hospital'),(144,110,'de','name','Oldenburger Institut für Informatik'),(145,110,'en','name','Institute for Information Technology'),(146,111,'en','name','Tianjin Medical University General Hospital'),(147,111,'zh','name','天津医科大学总医院'),(148,112,'en','name','Soroka Medical Center'),(149,113,'en','name','Agruicultural Research Institute'),(150,114,'en','name','Inland Hospital'),(151,114,'no','name','Sykehuset Innlandet'),(152,115,'en','name','Glenbrook Hospital'),(153,116,'en','name','University of Burundi'),(154,116,'fr','name','Université du Burundi'),(155,117,'en','name','University of Teacher Education Fukuoka'),(156,117,'ja','name','福岡教育大学'),(157,118,'no_lang_code','name','Profilarbed (Luxembourg)'),(158,119,'es','name','Hospital San Agustin'),(159,120,'en','name','Sendai Red Cross Hospital'),(160,120,'ja','name','仙台赤十字病院'),(161,121,'en','name','Rady Children\'s Hospital-San Diego'),(162,122,'en','name','Sultanah Aminah Hospital'),(163,122,'ms','name','Hospital Sultanah Aminah'),(164,123,'en','name','Tianjin Beichen Hospital'),(165,124,'ar','name','جامعة النجاح الوطنية'),(166,124,'en','name','An-Najah National University'),(167,125,'it','name','Ospedale del Ceppo'),(168,126,'en','name','Kookmin University'),(169,126,'ko','name','국민대학교'),(170,127,'sv','name','Blekingesjukhuset'),(171,128,'en','name','King\'s Cross Hospital'),(172,129,'en','name','Kursk State Medical University'),(173,129,'ru','name','Курский государственный медицинский университет'),(174,130,'no_lang_code','name','Technical Resources International (United States)'),(175,131,'de','name','Landeskrankenhaus Feldkirch'),(176,132,'en','name','Swedish Medical Center'),(177,133,'en','name','Maricopa County Community College District'),(178,134,'en','name','Barnet Hospital'),(179,135,'no_lang_code','name','Technical Research Associates (United States)'),(180,136,'es','name','Hospital General De Segovia'),(181,137,'en','name','Masonic Medical Research Laboratory'),(182,138,'en','name','Abilene Christian University'),(183,138,'es','name','Universidad Cristiana de Abilene'),(184,139,'en','name','North Park University'),(185,140,'ja','name','総合病院 土浦協同病院'),(186,140,'no_lang_code','name','Tsuchiura Kyodo General Hospital'),(187,141,'en','name','Holy Family Hospital'),(188,142,'en','name','Third Affiliated Hospital of Southern Medical University'),(189,142,'zh','name','南方医科大学第三附属医院'),(190,143,'it','name','Centro Studi Sui Sistemi Di Trasporto Spa'),(191,144,'en','name','Royal Hallamshire Hospital'),(192,145,'en','name','South Carolina State University'),(193,146,'en','name','United States Air Force Academy'),(194,146,'es','name','Academia de la Fuerza Aérea de los Estados Unidos'),(195,147,'en','name','Mercy San Juan Medical Center'),(196,148,'en','name','John D. Dingell VA Medical Center'),(197,149,'en','name','Indian Institute of Technology Roorkee'),(198,149,'hi','name','भारतीय प्रौद्योगिकी संस्थान रुड़की'),(199,149,'ml','name','ഇന്ത്യൻ ഇൻസ്റ്റിറ്റ്യൂട്ട് ഓഫ് ടെക്നോളജി റൂർക്കി'),(200,149,'ta','name','இந்திய தொழில்நுட்பக் கழகம் ரூர்க்கி'),(201,149,'te','name','ఇండియన్ ఇన్స్టిట్యూట్ ఆఫ్ టెక్నాలజీ రూర్కీ'),(202,150,'en','name','Ching Kuo Institute of Management and Health'),(203,150,'zh','name','經國管理暨健康學院'),(204,151,'en','name','Prefectural University of Hiroshima'),(205,151,'ja','name','県立広島大学'),(206,152,'fr','name','Hôpital Farhat Hached'),(207,153,'no_lang_code','name','NEC (United Kingdom)'),(208,154,'en','name','Eulji University'),(209,154,'ko','name','을지대학교'),(210,155,'en','name','South-West State University'),(211,155,'ru','name','Юго-Западный государственный университет'),(212,156,'en','name','Dayanand Medical College & Hospital'),(213,157,'en','name','National Changhua University of Education'),(214,157,'zh','name','國立彰化師範大學'),(215,158,'en','name','Metropolitan Hospital Center'),(216,159,'en','name','Government Medical College'),(217,160,'en','name','Wakayama Medical University'),(218,160,'ja','name','和歌山県立医科大学'),(219,161,'en','name','Munson Medical Center'),(220,162,'en','name','Royal Derby Hospital'),(221,163,'it','name','Azienda Ospedaliera Ospedale San Carlo Borromeo'),(222,164,'en','name','Antrim Area Hospital'),(223,165,'en','name','University Clinical Center of Kosovo'),(224,166,'en','name','Lawrence University'),(225,166,'es','name','Universidad Lawrence'),(226,167,'en','name','Children\'s Hospital Mansoura University'),(227,168,'no_lang_code','name','STAR Analytical Services'),(228,169,'en','name','Friends University'),(229,170,'en','name','Southern Nazarene University'),(230,171,'en','name','United States National Library of Medicine'),(231,171,'es','name','Biblioteca Nacional de Medicina'),(232,172,'en','name','Center for Studying Health System Change'),(233,173,'es','name','Hospital Costa del Sol'),(234,174,'ko','name','원광대학교'),(235,174,'no_lang_code','name','Wonkwang University'),(236,175,'en','name','Missouri Baptist Medical Center'),(237,176,'en','name','Detroit Receiving Hospital'),(238,177,'en','name','Tokushima Breast Care Clinic'),(239,177,'ja','name','とくしまブレストケアクリニック'),(240,178,'en','name','Hengyang Normal University'),(241,179,'en','name','UK Material Technology Research Institute'),(242,180,'no_lang_code','name','Intelligent Hearing Systems (United States)'),(243,181,'en','name','Social Science Research Council'),(244,182,'en','name','Duchess of Kent Children\'s Hospital'),(245,182,'zh','name','大口環根德公爵夫人兒童醫院'),(246,183,'en','name','Birmingham–Southern College'),(247,184,'en','name','Meijo Hospital'),(248,184,'ja','name','名城病院'),(249,185,'en','name','North Dakota Department of Health'),(250,186,'en','name','Georgia Department of Human Services'),(251,187,'en','name','University of Colorado Hospital'),(252,187,'es','name','Hospital de la Universidad de Colorado'),(253,188,'en','name','Bond University'),(254,189,'de','name','Universitätsklinikum Düsseldorf'),(255,189,'en','name','Düsseldorf University Hospital'),(256,190,'es','name','Instituto Tecnológico del Calzado y Conexas'),(257,191,'en','name','Mackenzie Presbyterian University'),(258,191,'pt','name','Universidade Presbiteriana Mackenzie'),(259,192,'en','name','Ambrose Alli University'),(260,192,'yo','name','Yunifásítì Ambrose Alli'),(261,193,'ja','name','福井県立病院'),(262,193,'no_lang_code','name','Fukui Prefectural Hospital'),(263,194,'pt','name','Universidade do Sul de Santa Catarina'),(264,195,'no_lang_code','name','FORCE Technology (Denmark)'),(265,196,'en','name','LeTourneau University'),(266,197,'en','name','National Institute of Engineering, Technology and Innovation'),(267,197,'pt','name','Instituto Nacional de Engenharia, Tecnologia e Inovação'),(268,198,'no_lang_code','name','Koronis Biomedical Technologies (United States)'),(269,199,'nl','name','Geneeskundige en Gezondheidsdienst'),(270,200,'en','name','James A. Haley Veterans\' Hospital'),(271,201,'en','name','Keesler Medical Center'),(272,202,'en','name','Min Sheng General Hospital'),(273,202,'zh','name','敏盛綜合醫院'),(274,203,'en','name','John F. Kennedy Medical Center'),(275,204,'en','name','Queen Elizabeth II Medical Centre'),(276,205,'no_lang_code','name','Barlow Scientific'),(277,206,'en','name','Greater Baltimore Medical Center'),(278,207,'en','name','Manitoba Health'),(279,208,'en','name','Iowa Department of Human Services'),(280,209,'en','name','National Polytechnic University of Armenia'),(281,209,'hy','name','Հայաստանի ազգային պոլիտեխնիկական համալսարան'),(282,210,'en','name','Bloomsburg University'),(283,211,'en','name','Miyagi Children\'s Hospital'),(284,211,'ja','name','宮城県立こども病院'),(285,212,'en','name','Cooper Medical School of Rowan University'),(286,213,'ar','name','جامعة بغداد'),(287,213,'en','name','University of Baghdad'),(288,214,'en','name','Government Medical College'),(289,214,'ml','name','ഗവൺമെന്റ് മെഡിക്കൽ കോളേജ്, തിരുവനന്തപുരം'),(290,215,'en','name','VA Salt Lake City Healthcare System'),(291,216,'en','name','University of Tampa'),(292,216,'es','name','Universidad de Tampa'),(293,217,'fr','name','Hôpital Saint Lazare'),(294,218,'en','name','Society For Developmental Biology'),(295,219,'en','name','Purdue Research Foundation'),(296,220,'en','name','INTEGRIS Baptist Medical Center'),(297,221,'en','name','Seton Hall University'),(298,222,'en','name','North Karelia Central Hospital'),(299,222,'fi','name','Pohjois-Karjalan Sairaanhoito- Ja Sosiaalipalvelujen Kuntayhtymä'),(300,223,'en','name','Center for Devices and Radiological Health'),(301,224,'en','name','The Health Council of the Netherlands'),(302,224,'nl','name','Gezondheidsraad'),(303,225,'de','name','Klinikum Klagenfurt'),(304,226,'en','name','John Radcliffe Hospital'),(305,227,'en','name','Acadia University'),(306,228,'tr','name','Bayındır Hastanesi'),(307,229,'fr','name','Centre Hospitalier Universitaire de Besançon'),(308,230,'en','name','Arnold Palmer Hospital for Children'),(309,231,'en','name','University of Sargodha'),(310,232,'en','name','Manhattan Eye, Ear and Throat Hospital'),(311,233,'ja','name','新潟県立新発田病院'),(312,233,'no_lang_code','name','Niigata Prefectural Shibata Hospital'),(313,234,'fr','name','Hôpital Ophtalmique Jules-Gonin'),(314,235,'en','name','East–West Center'),(315,236,'en','name','JILA, Joint Institute for Laboratory Astrophysics'),(316,237,'en','name','Aintree University Hospital'),(317,238,'fr','name','Héma-Québec'),(318,239,'en','name','Lamar University'),(319,240,'en','name','Guangdong Province Stomatological Hospital'),(320,240,'zh','name','广东省口腔医院'),(321,241,'en','name','Florida Memorial University'),(322,242,'en','name','Louisiana State University Hospital'),(323,243,'en','name','Lata Medical Research Foundation'),(324,244,'pt','name','Instituto Superior de Ciências Educativas'),(325,245,'de','name','Universität Antwerpen'),(326,245,'en','name','University of Antwerp'),(327,245,'fr','name','Université d\'Anvers'),(328,245,'nl','name','Universiteit Antwerpen'),(329,246,'fa','name','بیمارستان بقیةالله'),(330,246,'no_lang_code','name','Hospital Bqyhallh'),(331,247,'en','name','Mercy Health System'),(332,248,'en','name','Hackensack University Medical Center'),(333,249,'en','name','Oita Medical Center'),(334,249,'ja','name','国立病院機構 大分医療センタ'),(335,250,'no_lang_code','name','Sanaria'),(336,251,'en','name','Ashikaga Red Cross Hospital'),(337,251,'ja','name','足利赤十字病院'),(338,252,'en','name','National Central University'),(339,253,'en','name','Kurashiki Central Hospital'),(340,253,'ja','name','倉敷中央病院'),(341,254,'en','name','Jinnah Postgraduate Medical Center'),(342,255,'ja','name','楽天株式会社'),(343,255,'no_lang_code','name','Rakuten (Japan)'),(344,256,'en','name','Sardar Patel Medical College'),(345,257,'en','name','Provincial Laboratory of Public Health'),(346,258,'fr','name','Hôpital Laveran'),(347,259,'en','name','Intermountain Medical Center'),(348,260,'ar','name','مدينة الملك عبد العزيز الطبية للحرس الوطني'),(349,260,'en','name','King Abdulaziz Medical City'),(350,261,'en','name','Sun Moon University'),(351,261,'ko','name','선문대학교'),(352,262,'en','name','Falun Hospital'),(353,263,'en','name','Sharp Rees-Stealy Medical Group'),(354,264,'pl','name','Szpital im Tadeusza Marciniaka'),(355,265,'en','name','Malabar Institute of Medical Sciences'),(356,266,'pt','name','Hospital Moinhos de Vento'),(357,267,'en','name','Grady Memorial Hospital'),(358,268,'en','name','Northern Health'),(359,269,'fr','name','Centre Hospitalier Universitaire Mohammed VI'),(360,270,'en','name','Tilka Manjhi Bhagalpur University'),(361,270,'hi','name','तिलका मांझी भागलपुर विश्वविद्यालय'),(362,271,'no_lang_code','name','Virogenomics BioDevelopment (United States)'),(363,272,'en','name','Lehigh Valley Hospital Muhlenberg'),(364,273,'en','name','Mercy Medical Center'),(365,274,'en','name','Inova Loudoun Hospital'),(366,275,'en','name','Royal Liverpool and Broadgreen University Hospital NHS Trust'),(367,276,'en','name','Armed Forces Health Surveillance Center'),(368,277,'en','name','Churchill Hospital'),(369,278,'en','name','University Children’s Hospital'),(370,278,'pl','name','Uniwersytecki Szpital Dziecięcy'),(371,279,'en','name','Cook Children\'s Medical Center'),(372,280,'en','name','London School of Hygiene & Tropical Medicine'),(373,281,'en','name','MultiCare Good Samaritan Hospital'),(374,282,'en','name','Eastern State Hospital'),(375,283,'en','name','Ya\'an Polytechnic College'),(376,283,'zh','name','雅安职业技术学院'),(377,284,'en','name','Cancer Hospital of Shantou University Medical College'),(378,284,'zh','name','汕头大学医学院附属肿瘤医院'),(379,285,'en','name','Royal United Hospital'),(380,286,'en','name','Korea Institute of Radiological and Medical Sciences'),(381,286,'ko','name','한국 방사선 과학 연구소'),(382,287,'en','name','Second Affiliated Hospital of Guangzhou Medical University'),(383,287,'zh','name','广州医科大学附属第二医院'),(384,288,'no_lang_code','name','GABO:mi'),(385,289,'pt','name','Instituto Superior Autónomo de Estudos Politécnicos'),(386,290,'no_lang_code','name','Performance Plants (Canada)'),(387,291,'en','name','London Metropolitan University'),(388,292,'en','name','Isfahan University of Technology'),(389,292,'fa','name','دانشگاه صنعتی اصفهان'),(390,293,'tr','name','Dr. Behçet Uz Çocuk Hastalıkları Hastanesi'),(391,294,'es','name','Hospital General San Juan de Dios'),(392,295,'en','name','Sejong University'),(393,295,'ko','name','세종대학교'),(394,296,'en','name','Martha Jefferson Hospital'),(395,297,'en','name','Computing Research Association'),(396,298,'tr','name','Gaziantep Onkoloji Hastanesi'),(397,299,'en','name','UK Water Industry Research'),(398,300,'en','name','Kettering Medical Center'),(399,300,'fr','name','Centre médical de kettering'),(400,301,'en','name','Privolzhsky Research Medical University'),(401,301,'ru','name','Приволжский исследовательский медицинский университет'),(402,302,'en','name','Milwaukee Public Museum'),(403,303,'en','name','Florida Hospital Cancer Institute'),(404,304,'en','name','Accreditation Council for Graduate Medical Education'),(405,305,'en','name','Chubu Rosai Hospital'),(406,305,'ja','name','中部ろうさい病院'),(407,306,'en','name','Health and Safety Executive'),(408,307,'en','name','The Graduate Center, CUNY'),(409,308,'no_lang_code','name','Swedish Nuclear Fuel and Waste Management (Sweden)'),(410,309,'en','name','Loewenstein Hospital Rehabilitation Center'),(411,310,'en','name','North Shore Medical Center'),(412,311,'en','name','Shadyside Hospital'),(413,312,'it','name','Centro Ricerche FIAT'),(414,313,'en','name','Prefectural University of Kumamoto'),(415,313,'ja','name','熊本県立大学'),(416,314,'de','name','Klinik Schillerhöhe'),(417,315,'en','name','Rood and Riddle Equine Hospital'),(418,316,'en','name','National Human Genome Research Institute'),(419,317,'en','name','Vladivostok State Medical University'),(420,317,'ru','name','Тихоокеанский государственный медицинский университет'),(421,318,'en','name','Guru Angad Dev Veterinary and Animal Sciences University'),(422,318,'pa','name','ਗੁਰੂ ਅੰਗਦ ਦੇਵ ਵੈਟਨਰੀ ਅਤੇ ਐਨੀਮਲ ਸਾਇੰਸਜ਼ ਯੂਨੀਵਰਸਿਟੀ'),(423,319,'en','name','Glasgow Royal Infirmary'),(424,320,'de','name','Fraunhofer Institut für Mikrotechnik und Mikrosysteme'),(425,320,'en','name','Fraunhofer Institute for Microengineering and Microsystems'),(426,321,'en','name','Emma Children’s Hospital'),(427,321,'nl','name','Emma Kinderziekenhuis'),(428,322,'en','name','Gembloux Agro-Bio Tech'),(429,323,'it','name','Ospedale San Paolo'),(430,324,'es','name','Hospital Italiano de Buenos Aires'),(431,325,'ja','name','青森県立中央病院'),(432,325,'no_lang_code','name','Aomori Prefectural Central Hospital'),(433,326,'ja','name','長崎みなとメディカルセンター市民病院'),(434,326,'no_lang_code','name','Nagasaki Municipal Hospital'),(435,327,'en','name','Kanchi Mamunivar Centre for Post Graduate Studies'),(436,328,'en','name','Ireland Army Community Hospital'),(437,329,'en','name','Newark Beth Israel Medical Center'),(438,330,'en','name','Hosei University'),(439,330,'ja','name','法政大学'),(440,331,'en','name','Coombe Women & Infants University Hospital'),(441,331,'ga','name','Ospidéal Ollscoile Ban agus Naíonán an Chúim'),(442,332,'en','name','Vidant Medical Center'),(443,333,'no_lang_code','name','MTU Aero Engines (Germany)'),(444,334,'en','name','National Science Teachers Association'),(445,335,'en','name','University of Dubuque'),(446,335,'fr','name','Université de dubuque'),(447,336,'en','name','Dillard University'),(448,337,'en','name','The Ohio State University Wexner Medical Center'),(449,338,'en','name','Technical Centre for Mechanical Industry'),(450,338,'fr','name','Centre Technique des Industries Mécaniques'),(451,339,'en','name','First People\'s Hospital of Yunnan Province'),(452,339,'zh','name','云南省第一人民医院'),(453,340,'en','name','Groote Schuur Hospital'),(454,341,'tr','name','Gülhane Askerî Tıp Akademisi'),(455,342,'en','name','Long Island Jewish Medical Center'),(456,343,'en','name','Merlin Park University Hospital'),(457,344,'en','name','American Dental Association'),(458,345,'ar','name','جامعة عين شمس'),(459,345,'en','name','Ain Shams University'),(460,346,'en','name','University of Western São Paulo'),(461,346,'pt','name','Universidade do Oeste Paulista'),(462,347,'en','name','Southern Polytechnic State University'),(463,348,'en','name','Frontier Medical College'),(464,348,'ur','name','فرنٹیئر میڈیکل کالج'),(465,349,'en','name','Shanghai Children\'s Medical Center'),(466,349,'zh','name','上海儿童医学中心'),(467,350,'en','name','Freeman Hospital'),(468,351,'es','name','Hospital General Universitario Santa María del Rosell'),(469,352,'en','name','Hiratsuka City Hospital'),(470,352,'ja','name','平塚市民病院'),(471,353,'en','name','Royal Cornwall Hospital'),(472,354,'es','name','Hospital General Universitario Morales Meseguer'),(473,355,'en','name','TRTech'),(474,356,'en','name','Bhabha Atomic Research Center Hospital'),(475,357,'en','name','Seoul National University of Science and Technology'),(476,357,'ko','name','서울과학기술대학교'),(477,358,'en','name','Gaia Regional Conservatory Foundation'),(478,358,'pt','name','Fundação Conservatório Regional de Gaia'),(479,359,'it','name','Azienda Ospedaliera G.Rummo'),(480,360,'de','name','Krankenhaus Bozen'),(481,360,'it','name','Ospedale di Bolzano'),(482,361,'en','name','St. Elizabeth\'s Medical Center'),(483,362,'da','name','Center for Klinisk Forskning og Forebyggelse'),(484,362,'en','name','Center for Clinical Research and Prevention'),(485,363,'en','name','Bristol City Council'),(486,364,'en','name','Pál Heim Children\'s Hospital'),(487,364,'hu','name','Heim Pál Gyermekkórház'),(488,365,'ko','name','우리들 병원'),(489,365,'no_lang_code','name','Wooridul Hospital'),(490,366,'en','name','Frederiksberg Hospital'),(491,367,'en','name','Chang Gung University'),(492,368,'en','name','Södertörn University'),(493,368,'sv','name','Södertörns högskola'),(494,369,'en','name','Topiwala National Medical College & BYL Nair Charitable Hospital'),(495,370,'en','name','Jiangxi Agricultural University'),(496,370,'zh','name','江西农业大学'),(497,371,'en','name','Pine Rest Christian Mental Health Services'),(498,372,'en','name','Good Moonhwa Hospital'),(499,372,'ko','name','좋은문화병원'),(500,373,'en','name','American Meteorological Society'),(501,374,'en','name','Hangzhou Center for Disease Control and Prevention'),(502,374,'zh','name','杭州市疾病预防控制中心'),(503,375,'en','name','Alcorn State University'),(504,376,'en','name','Fukuoka Institute of Health and Environmental Sciences'),(505,376,'ja','name','福岡県保健環境研究所'),(506,377,'en','name','Argyll and Bute Hospital'),(507,378,'no_lang_code','name','Experimental Pathology Laboratories'),(508,379,'en','name','Sheppard Pratt Health System'),(509,380,'en','name','Osun State University'),(510,381,'en','name','China University of Political Science and Law'),(511,381,'zh','name','中国政法大学'),(512,382,'en','name','Ross University School of Veterinary Medicine'),(513,383,'ko','name','대구파티마병원'),(514,383,'no_lang_code','name','Daegu Fatima Hospital'),(515,384,'en','name','Ingalls Memorial Hospital'),(516,385,'en','name','Polytechnic University of the Philippines'),(517,386,'en','name','University of Maine at Machias'),(518,387,'en','name','Robert Wood Johnson University Hospital'),(519,388,'en','name','Hebrew Hospital'),(520,389,'ko','name','홍익대학교'),(521,389,'no_lang_code','name','Hongik University'),(522,390,'no_lang_code','name','E-Da Hospital'),(523,391,'en','name','Bloodworks Northwest'),(524,392,'en','name','Moscow State University of Civil Engineering'),(525,392,'ru','name','Московский Государственный Строительный Университет'),(526,393,'ko','name','우석대학교'),(527,393,'no_lang_code','name','Woosuk University'),(528,394,'en','name','Kaohsiung Municipal Kai-Syuan Psychiatric Hospital'),(529,395,'en','name','Aurelia Hospital'),(530,396,'en','name','Greenlane Clinical Centre'),(531,397,'en','name','Advocate Good Samaritan Hospital'),(532,398,'en','name','University of Ribeirão Preto'),(533,398,'pt','name','Universidade de Ribeirão Preto'),(534,399,'en','name','Holy Family Hospital'),(535,399,'ur','name','ہولی فیملی ہسپتال'),(536,400,'en','name','Liverpool Women\'s Hospital'),(537,401,'no_lang_code','name','Robosoft (France)'),(538,402,'en','name','Chonnam National University Hospital'),(539,403,'en','name','Lankenau Medical Center'),(540,404,'ja','name','北里大学'),(541,404,'no_lang_code','name','Kitasato University'),(542,405,'en','name','Chesapeake Research Consortium'),(543,406,'en','name','RAND Corporation'),(544,407,'en','name','Gaziantep Children\'s Hospital'),(545,407,'tr','name','Gaziantep Çocuk Hastanesi'),(546,408,'en','name','McKay Dee Hospital'),(547,409,'en','name','GF Jooste Hospital'),(548,410,'ja','name','賛育会病院'),(549,410,'no_lang_code','name','San-ikukai Hospital'),(550,411,'no_lang_code','name','MBN Nanomaterialia (Italy)'),(551,412,'en','name','Aomori Rosai Hospital'),(552,412,'ja','name','青森労災病院'),(553,413,'en','name','Krishna Institute of Medical Sciences'),(554,414,'en','name','Daegu Catholic University Medical Center'),(555,414,'ko','name','대구가톨릭대학교병원 모바일'),(556,415,'en','name','Arcadia University'),(557,416,'en','name','Kaiser Permanente San Diego Medical Center'),(558,417,'no_lang_code','name','Hindu Rao Hospital'),(559,418,'en','name','Vladimir State University for the Humanities'),(560,418,'ru','name','Владимирский государственный гуманитарный университет'),(561,419,'en','name','Good Samaritan Regional Medical Center'),(562,420,'en','name','Kunming Children\'s Hospital'),(563,420,'zh','name','昆明市儿童医院'),(564,421,'en','name','Plastic Surgery Hospital'),(565,422,'en','name','Hamburg Ship Model Basin'),(566,422,'no_lang_code','name','Hamburgische Schiffbau-Versuchsanstalt (Germany)'),(567,423,'en','name','John B. Pierce Laboratory'),(568,424,'en','name','Kuopio University Hospital'),(569,425,'en','name','Lankenau Heart Institute'),(570,426,'en','name','Beebe Healthcare'),(571,427,'en','name','Marion duPont Scott Equine Medical Center'),(572,428,'en','name','Wesley Medical Center'),(573,429,'en','name','Daping Hospital'),(574,429,'zh','name','第三军医大学大坪医院'),(575,430,'en','name','University Dental Hospital on Cardiff University'),(576,431,'en','name','MRC Laboratory for Molecular Cell Biology'),(577,432,'en','name','Colby College'),(578,433,'en','name','George Washington University Hospital'),(579,434,'en','name','Lee University'),(580,435,'no_lang_code','name','Novartis (China)'),(581,435,'zh','name','北京诺华制药有限公司'),(582,436,'de','name','HFR Freiburg Kantonsspital'),(583,437,'en','name','Central DuPage Hospital'),(584,438,'en','name','First Affiliated Hospital of Jiangxi Medical College'),(585,439,'no_lang_code','name','Oregon Center For Applied Science (United States)'),(586,440,'en','name','Chowan University'),(587,441,'en','name','Maimonides Medical Center'),(588,442,'en','name','Ferdowsi University of Mashhad'),(589,442,'fa','name','دانشگاه فردوسی مشهد'),(590,443,'en','name','Usmanu Danfodiyo University Teaching Hospital, Sokoto'),(591,444,'en','name','Saint Agnes Medical Center'),(592,445,'en','name','Sendai Nishitaga National Hospital'),(593,445,'ja','name','国立病院機構仙台西多賀病院'),(594,446,'en','name','Gyeongsang National University Hospital'),(595,447,'en','name','MESA Hospital'),(596,447,'tr','name','Mesa Hastanesi'),(597,448,'en','name','Vermont Department of Mental Health'),(598,449,'ar','name','المستشفى الجامعي الرابطة'),(599,449,'fr','name','Hôpital La Rabta'),(600,450,'en','name','Orel State University named after I.S. Turgenev'),(601,450,'ru','name','Орловский государственный университет имени И. С. Тургенева'),(602,451,'en','name','Midwestern Regional Medical Center'),(603,452,'en','name','Lagos University Teaching Hospital'),(604,453,'en','name','Tokai University Hachioji Hospital'),(605,453,'ja','name','東海大学医学部付属八王子病院'),(606,454,'en','name','Bellin Memorial Hospital'),(607,455,'en','name','University of Pernambuco'),(608,455,'pt','name','Universidade de Pernambuco'),(609,456,'es','name','Hospital Barros Luco-Trudeau'),(610,457,'en','name','King George\'s Medical University'),(611,457,'hi','name','छत्रपति शाहूजी महाराज आयुर्विज्ञान विश्वविद्यालय'),(612,458,'en','name','Rotherham General Hospital'),(613,459,'en','name','McNeese State University'),(614,460,'fr','name','Centre Hospitalier Universitaire de Yopougon'),(615,461,'en','name','Deaconess Hospital'),(616,462,'ar','name','جامعة حلوان'),(617,462,'en','name','Helwan University'),(618,463,'no_lang_code','name','Sensimetrics Corporation'),(619,464,'no_lang_code','name','Tembec'),(620,465,'pt','name','Instituto de Estudos Superiores Financeiros e Fiscais'),(621,466,'en','name','MGMA Health Care Consulting Group'),(622,467,'no_lang_code','name','Ecogenomics (Japan)'),(623,468,'pt','name','Hospital Felício Rocho'),(624,469,'en','name','Jawaharlal Nehru Medical College'),(625,470,'en','name','General Hospital of Guangzhou Military Command'),(626,470,'zh','name','广州军区广州总医院'),(627,471,'en','name','Japan Society for the Promotion of Science'),(628,471,'ja','name','日本学術振興会'),(629,472,'en','name','Royal Hampshire County Hospital'),(630,473,'ja','name','西宮市立中央病院'),(631,473,'no_lang_code','name','Nishinomiya Municipal Central Hospital'),(632,474,'sv','name','Danderyds sjukhus'),(633,475,'en','name','Barzilai Medical Center'),(634,476,'en','name','Broomfield Hospital'),(635,477,'no_lang_code','name','Luna Innovations (United States)'),(636,478,'en','name','Mammoth Hospital'),(637,479,'es','name','Hospital Clínico Universitario de Valencia'),(638,480,'en','name','Ministry of Health'),(639,481,'ar','name','الجامعة اللبنانية الأمريكية'),(640,481,'en','name','Lebanese American University'),(641,482,'ja','name','静岡市立清水病院'),(642,482,'no_lang_code','name','Shizuoka City Shimizu Hospital'),(643,483,'en','name','National University of Salta'),(644,483,'es','name','Universidad Nacional de Salta'),(645,484,'en','name','Baba Memorial Hospital'),(646,484,'ja','name','社会医療法人ペガサス 馬場記念病院'),(647,485,'tr','name','Ankara Fizik Tedavi ve Rehabilitasyon Eğitim ve Araştırma Hastanesi'),(648,486,'en','name','Sasebo City General Hospital'),(649,486,'ja','name','佐世保市総合医療センター'),(650,487,'en','name','Sinai Grace Hospital'),(651,488,'en','name','Regional Medical Research Center'),(652,488,'hi','name','क्षेत्रीय आयुर्विगिनं अनुसंधान केंद्र'),(653,489,'en','name','Alabama Department of Public Health'),(654,490,'en','name','Narayana Dental College and Hospital'),(655,491,'en','name','Virginia Department of Health'),(656,492,'en','name','National Institute of Environmental Health Sciences'),(657,493,'en','name','Maharaja Krishna Chandra Gajapati Medical College and Hospital'),(658,494,'es','name','Hospital de Basurto'),(659,495,'en','name','Swami Keshwanand Rajasthan Agricultural University'),(660,496,'no_lang_code','name','Inflexxion (United States)'),(661,497,'en','name','Cambridge Military Hospital'),(662,498,'en','name','Sir Sayajirao General Hospital Medical College'),(663,499,'en','name','Oslo University Hospital'),(664,500,'es','name','Hospital Terrassa'),(665,501,'en','name','Buffalo VA Medical Center'),(666,502,'en','name','Central Baptist Hospital'),(667,503,'en','name','PRIST University'),(668,504,'en','name','New Mexico Department of Health'),(669,505,'no_lang_code','name','Medical Protective'),(670,506,'en','name','Regent University'),(671,507,'en','name','Harvard–MIT Division of Health Sciences and Technology'),(672,508,'en','name','The Hamner Institutes for Health Sciences'),(673,509,'no_lang_code','name','TECO'),(674,510,'pt','name','Instituto Superior Manuel Teixeira Gomes'),(675,511,'en','name','Hillingdon Hospital'),(676,512,'fr','name','Centre Hospitalier Universitaire de Tours'),(677,513,'en','name','Cardinal Glennon Children’s Medical Center'),(678,514,'en','name','Louisiana Board of Regents'),(679,515,'nl','name','Slingeland Ziekenhuis'),(680,516,'en','name','Gifu Prefectural Tajimi Hospital'),(681,516,'ja','name','岐阜県立多治見病院'),(682,517,'en','name','Meitan General Hospital'),(683,517,'zh','name','煤炭总医院'),(684,518,'en','name','Capital University'),(685,519,'en','name','Alfred I. duPont Hospital for Children'),(686,520,'en','name','Astrakhan State Technical University'),(687,520,'ru','name','Астраханский государственный технический университет'),(688,521,'en','name','Museum of Science'),(689,522,'en','name','Grady Health System'),(690,523,'no_lang_code','name','Oxford Biomedical Research'),(691,524,'es','name','Hospital Virgen de la Luz'),(692,525,'pt','name','Instituto Superior de Novas Profissões'),(693,526,'en','name','West Virginia University at Parkersburg'),(694,527,'en','name','Molde Hospital'),(695,527,'no','name','Molde sjukehus'),(696,528,'en','name','Xuan Wu Hospital of the Capital Medical University'),(697,528,'zh','name','北京市老年病医疗研究中心'),(698,529,'en','name','California Animal Hospital'),(699,530,'en','name','Ahmedabad Civil Hospital'),(700,531,'en','name','Applied Technology Council'),(701,532,'en','name','Sri Devaraj Urs Medical College'),(702,533,'pt','name','Universidade Gama Filho, University Gama Filho'),(703,534,'en','name','Lutheran University of Brazil'),(704,534,'es','name','Universidad Luterana de Brasil'),(705,534,'pt','name','Universidade Luterana do Brasil'),(706,535,'en','name','Mito Red Cross Hospital'),(707,535,'ja','name','水戸赤十字病院'),(708,536,'en','name','Women & Children\'s Hospital of Buffalo'),(709,537,'en','name','Hawaii Department of Health'),(710,538,'en','name','Tokyo Gakugei University'),(711,538,'ja','name','東京学芸大学'),(712,539,'en','name','Hawke\'s Bay Hospital'),(713,540,'tr','name','Ankara Atatürk Eğitim ve Araştırma Hastanesi'),(714,541,'no_lang_code','name','Hektoen Institute'),(715,542,'en','name','UK Intelligent Systems Research Institute'),(716,543,'en','name','Nippon Medical School'),(717,543,'ja','name','日本医科大学'),(718,544,'en','name','Kyoto Prefectural University'),(719,544,'ja','name','京都府立大学'),(720,545,'no_lang_code','name','BT Group (United Kingdom)'),(721,546,'en','name','Fukui Red Cross Hospital'),(722,546,'ja','name','福井赤十字病院'),(723,547,'en','name','VA Puget Sound Health Care System'),(724,548,'no_lang_code','name','Gemite Group'),(725,549,'en','name','Nippon Sport Science University'),(726,549,'ja','name','日本体育大学'),(727,550,'no_lang_code','name','CAE (Canada)'),(728,551,'en','name','Archbold Biological Station'),(729,552,'en','name','Holy Family Hospital Nazareth'),(730,553,'en','name','Government Medical College'),(731,554,'en','name','Christopher Newport University'),(732,555,'en','name','Maebashi Red Cross Hospital'),(733,555,'ja','name','前橋赤十字病院'),(734,556,'en','name','Saint Joseph\'s Hospital'),(735,557,'en','name','St. Joseph\'s Hospital and Medical Center'),(736,558,'en','name','German Telecom'),(737,558,'no_lang_code','name','Deutsche Telekom (Germany)'),(738,559,'en','name','Kanazawa Medical Center'),(739,559,'ja','name','金沢医療センター'),(740,560,'en','name','Philadelphia College of Osteopathic Medicine'),(741,561,'en','name','National Hospital Organization Mito Medical Center'),(742,561,'ja','name','国立病院機構水戸医療センター'),(743,562,'en','name','Timescape Surveys'),(744,563,'en','name','University Medical Center of Princeton'),(745,564,'it','name','Ospedale San Giovanni Bellinzona'),(746,565,'en','name','Mudanjiang Medical University'),(747,565,'zh','name','牡丹江医学院'),(748,566,'it','name','Ospedale Cisanello'),(749,567,'en','name','John Muir Medical Center'),(750,568,'en','name','National University of San Luis'),(751,568,'es','name','Universidad Nacional de San Luis'),(752,569,'en','name','Home for Relief of the Suffering'),(753,569,'it','name','Casa Sollievo della Sofferenza'),(754,570,'en','name','Naruto University of Education'),(755,570,'ja','name','鳴門教育大学'),(756,571,'en','name','St. Lawrence River Institute of Environmental Sciences'),(757,572,'en','name','St. Francis Hospital'),(758,573,'en','name','Children\'s Hospital Colorado'),(759,574,'en','name','National School of Public Health'),(760,575,'en','name','National Sun Yat-sen University'),(761,576,'en','name','Mahatma Phule Krishi Vidyapeeth'),(762,577,'en','name','Savannah State University'),(763,577,'fr','name','Université d\'État de Savannah'),(764,578,'en','name','Ministry of Health'),(765,578,'ms','name','Kementerian Kesihatan Singapura'),(766,578,'ta','name','சிங்கப்பூர் சுகாதார அமைச்சகம்'),(767,578,'zh','name','新加坡卫生部'),(768,579,'en','name','Ramkhamhaeng University'),(769,579,'th','name','มหาวิทยาลัยรามคำแหง'),(770,580,'es','name','Hospital Nacional Cayetano Heredia'),(771,581,'en','name','Hemwati Nandan Bahuguna Garhwal University'),(772,581,'hi','name','गढ़वाल विश्वविद्यालय'),(773,582,'en','name','New York Academy of Medicine'),(774,582,'fr','name','Académie new-yorkaise de médecine'),(775,583,'en','name','Mae Fah Luang University'),(776,583,'th','name','มหาวิทยาลัยแม่ฟ้าหลวง'),(777,584,'no_lang_code','name','Glazer Medical Solutions (United States)'),(778,585,'en','name','Boise VA Medical Center'),(779,586,'en','name','Korea Polar Research Institute'),(780,586,'ko','name','극지연구소'),(781,587,'en','name','MedStar Union Memorial Hospital'),(782,588,'en','name','Presbyterian Hospital'),(783,589,'en','name','Takasaki University of Health and Welfare'),(784,589,'ja','name','高崎健康福祉大学'),(785,590,'en','name','Westmar University'),(786,591,'en','name','Cho Ray Hospital'),(787,591,'vi','name','Bệnh viện Chợ Rẫy'),(788,592,'en','name','Good Samaritan Hospital'),(789,593,'no_lang_code','name','Ericsson (Canada)'),(790,594,'en','name','Central Maine Medical Center'),(791,595,'en','name','Indira Gandhi Medical College and Research Institute'),(792,596,'en','name','Chapel Allerton Hospital'),(793,597,'en','name','Arak University'),(794,597,'fa','name','دانشگاه اراک'),(795,598,'en','name','St Bartholomew\'s Hospital'),(796,599,'en','name','Juravinski Hospital'),(797,600,'en','name','University of Maine at Presque Isle'),(798,601,'en','name','James Paget University Hospital'),(799,602,'en','name','University Medical Center of El Paso'),(800,603,'en','name','Cama and Albless Hospital'),(801,604,'en','name','VA Palo Alto Health Care System'),(802,605,'en','name','Cattinara Hospital'),(803,605,'it','name','Ospedale di Cattinara'),(804,606,'it','name','Azienda Ospedaliero Universitaria San Giovanni Battista'),(805,607,'en','name','King Edward Memorial Hospital'),(806,608,'en','name','Omaha VA Medical Center'),(807,609,'en','name','Geological Survey of India'),(808,609,'hi','name','भारतीय भूवैज्ञानिक सर्वेक्षण'),(809,610,'de','name','Universitätsklinikum des Saarlandes'),(810,611,'tr','name','İstanbul Eğitim ve Araştırma Hastanesi'),(811,612,'en','name','Mater Research'),(812,613,'en','name','HR Wallingford'),(813,614,'bn','name','গৌহাটী চিকিৎসা মহাবিদ্যালয়'),(814,614,'en','name','Gauhati Medical College and Hospital'),(815,615,'en','name','Peking University Cancer Hospital'),(816,615,'zh','name','北京大学肿瘤医院'),(817,616,'en','name','Ferrarotto Hospital'),(818,617,'en','name','Antioch University New England'),(819,618,'pt','name','Instituto Superior de Espinho'),(820,619,'en','name','Southend Hospital'),(821,620,'en','name','Salus University'),(822,621,'be','name','Беларускі дзяржаўны медыцынскі ўніверсітэт'),(823,621,'en','name','Belarusian State Medical University'),(824,621,'ru','name','Белорусский государственный медицинский университет'),(825,622,'en','name','Karpov Institute of Physical Chemistry'),(826,622,'ru','name','Акционерное общество Ордена Трудового Красного Знамени научно-исследовательский физико-химический институт имени Л.Я. Карпова'),(827,623,'en','name','Natural History Museum of Los Angeles County'),(828,624,'en','name','Bay Pines VA Healthcare System'),(829,625,'en','name','Bauman Moscow State Technical University'),(830,625,'ru','name','Московский государственный технический университет имени Н. Э. Баумана'),(831,626,'cy','name','Yr Amgueddfa Brydeinig'),(832,626,'en','name','British Museum'),(833,627,'en','name','Chengdu University of Traditional Chinese Medicine'),(834,627,'zh','name','成都中医药大学'),(835,628,'en','name','Sinclair Community College'),(836,629,'en','name','Museum of Heilongjiang Province'),(837,629,'zh','name','黑龙江省博物馆'),(838,630,'no_lang_code','name','Theragen'),(839,631,'en','name','Francis Marion University'),(840,632,'en','name','Al Noor Hospitals'),(841,633,'en','name','Sørlandet Hospital Arendal'),(842,633,'no','name','Sørlandet Sykehus HF'),(843,634,'no_lang_code','name','Talisman Energy'),(844,635,'no_lang_code','name','Energias de Portugal (Portugal)'),(845,636,'no_lang_code','name','Alion Science and Technology (United States)'),(846,637,'en','name','National University of the Littoral'),(847,637,'es','name','Universidad Nacional del Litoral'),(848,637,'fr','name','Université Nationale du Littoral'),(849,638,'de','name','Univ. Klinikum Graz'),(850,638,'en','name','Graz University Hospital'),(851,639,'en','name','National Taiwan University of Science and Technology'),(852,640,'no_lang_code','name','Lerdsin Hospital'),(853,640,'th','name','โรงพยาบาลเลิดสิน'),(854,641,'en','name','Plains Health Centre'),(855,642,'en','name','Ellis Hospital'),(856,643,'no_lang_code','name','Tianjin Huanhu Hospital'),(857,643,'zh','name','天津市环湖医院'),(858,644,'en','name','South Tyneside District Hospital'),(859,645,'en','name','Manipal College of Medical Sciences'),(860,646,'ja','name','星ヶ丘医療センター'),(861,646,'no_lang_code','name','Hoshigaoka Medical Center'),(862,647,'en','name','Korea National Institute of Health'),(863,648,'en','name','Middlesex Hospital'),(864,649,'ja','name','池田市立病院'),(865,649,'no_lang_code','name','Ikeda Municipal Hospital'),(866,650,'no_lang_code','name','PerkinElmer Biosignal'),(867,651,'no_lang_code','name','Miltenyi Biotec (Germany)'),(868,652,'en','name','Jessa Hospital'),(869,652,'nl','name','Jessa Ziekenhuis'),(870,653,'en','name','Nakamura Gakuen University'),(871,653,'ja','name','中村学園大学'),(872,654,'en','name','Kindai University Hospital'),(873,654,'ja','name','近畿大学医学部 附属病院'),(874,655,'en','name','King George Hospital'),(875,656,'en','name','Amref Health Africa'),(876,657,'it','name','Ospedale San Filippo Neri'),(877,658,'no_lang_code','name','Arttic (France)'),(878,659,'en','name','Doheny Eye Institute'),(879,660,'no_lang_code','name','EA Technology'),(880,661,'en','name','Chiba Institute of Technology'),(881,661,'ja','name','千葉工業大学'),(882,662,'en','name','University of North Carolina Health Care'),(883,663,'no_lang_code','name','Quality Biological'),(884,664,'en','name','Noor Eye Hospital'),(885,664,'fa','name','بیمارستان چشم‌پزشکی نور'),(886,665,'en','name','Ascamm Technologic Center'),(887,665,'es','name','Centro Tecnológico Ascamm'),(888,666,'en','name','North Kansas City Hospital'),(889,667,'en','name','Nenagh Hospital'),(890,667,'ga','name','Ospidéal an Aonaigh'),(891,668,'en','name','Western New Mexico University'),(892,669,'en','name','Natural England'),(893,670,'en','name','Second Affiliated Hospital of Chongqing Medical University'),(894,671,'en','name','Oregon University System'),(895,672,'en','name','Pennsylvania Department of Health'),(896,673,'no_lang_code','name','General Electric (Canada)'),(897,674,'en','name','Cameron University'),(898,675,'en','name','Institute For Defense Analyses'),(899,675,'es','name','Instituto de Análisis de la Defensa'),(900,676,'no_lang_code','name','TDA Research (United States)'),(901,677,'en','name','Lilavati Hospital & Research Centre'),(902,678,'en','name','Belvidere Hospital'),(903,679,'en','name','King Edward VII Hospital'),(904,680,'en','name','American Psychological Association'),(905,681,'en','name','Gimpo Airport Wooridul Spine Hospital'),(906,681,'ko','name','서울우리들병원'),(907,682,'en','name','Mississippi Valley State University'),(908,683,'cs','name','Institut postgraduálního vzdělávání ve zdravotnictví'),(909,683,'en','name','Institute for Postgraduate Medical Education'),(910,684,'en','name','Operation PAR'),(911,685,'en','name','Doctor Negrín University Hospital'),(912,685,'es','name','Hospital Universitario de Gran Canaria Doctor Negrín'),(913,686,'en','name','Instituto Superior Bissaya Barreto'),(914,687,'en','name','Almirante Nef Naval Hospital'),(915,687,'es','name','Hospital Naval Almirante Nef'),(916,688,'pt','name','Universidade Vale do Rio Verde'),(917,689,'en','name','Myongji University'),(918,689,'ko','name','명지대학교'),(919,690,'en','name','Sacred Heart Medical Center'),(920,691,'en','name','Summit Oaks Hospital'),(921,692,'en','name','Lehigh Valley Health Network'),(922,693,'bn','name','ব্র্যাক ইউনিভার্সিটি'),(923,693,'en','name','BRAC University'),(924,694,'en','name','Southwestern Oregon Community College'),(925,695,'en','name','PBMA\'s H.V. Desai Eye Hospital'),(926,696,'en','name','Colorado Department of Human Services'),(927,697,'en','name','Fukuoka Women\'s University'),(928,697,'ja','name','福岡女子大学'),(929,698,'it','name','Azienda Ospedaliera Universitaria Integrata Verona'),(930,699,'ja','name','徳島文理大学'),(931,699,'no_lang_code','name','Tokushima Bunri University'),(932,700,'en','name','Shriners Hospitals for Children - Portland'),(933,701,'no_lang_code','name','Whalen Biomedical'),(934,702,'en','name','Los Angeles Medical Center'),(935,703,'fr','name','Centre hospitalier Emile Roux'),(936,704,'en','name','Gynuity Health Projects'),(937,705,'ar','name','المستشفى الصدري'),(938,705,'en','name','Chest Diseases Hospital'),(939,706,'en','name','Penn Presbyterian Medical Center'),(940,707,'en','name','Harper University Hospital'),(941,708,'pt','name','Escola Superior de Educadores de Infância Maria Ulrich'),(942,709,'en','name','Kaplan Medical Center'),(943,709,'he','name','מרכז רפואי קפלן'),(944,710,'fr','name','Hôpital Kirchberg'),(945,711,'da','name','Roskilde Sygehus'),(946,711,'en','name','Roskilde Hospital'),(947,712,'en','name','Midwestern State University'),(948,712,'fr','name','Université d\'État du midwest'),(949,713,'en','name','Lok Nayak Jai Prakash Narayan Hospital'),(950,714,'en','name','Clayton State University'),(951,715,'it','name','Azienda ospedaliero-universitaria Policlinico Sant’Orsola Malpighi, Policlinico S.Orsola-Malpighi'),(952,716,'en','name','Kaiser Permanente'),(953,717,'en','name','Ijinkai Takeda General Hospital'),(954,717,'ja','name','武田総合病院は'),(955,718,'en','name','University of South Carolina Upstate'),(956,719,'en','name','Association of American Universities'),(957,719,'es','name','Asociación de Universidades Americanas'),(958,719,'fr','name','Association des universités américaines'),(959,720,'en','name','American School Health Association'),(960,721,'en','name','Kathmandu Medical College Teaching Hospital'),(961,722,'es','name','Hospital Fernández'),(962,723,'fi','name','Mikkelin keskussairaala'),(963,724,'en','name','Center for Medical, Agricultural and Veterinary Entomology'),(964,725,'no_lang_code','name','Aetna (United States)'),(965,726,'en','name','Keimyung University'),(966,726,'ko','name','계명대학교'),(967,727,'en','name','Gartnavel General Hospital'),(968,728,'cy','name','Adran yr Amgylchedd, Bwyd a Materion Gwledig'),(969,728,'en','name','Department for Environment Food and Rural Affairs'),(970,729,'en','name','Suzuka University of Medical Science'),(971,729,'ja','name','鈴鹿医療科学大学'),(972,730,'en','name','Shriners Hospitals for Children - Greenville'),(973,731,'en','name','SRC'),(974,732,'en','name','Public Dental Service Västra Götaland'),(975,732,'sv','name','Folktandvården Västra Götaland'),(976,733,'en','name','MRC Laboratory of Molecular Biology'),(977,734,'en','name','Teikyo University Hospital'),(978,734,'ja','name','帝京大学医学部附属病院'),(979,735,'en','name','Danish Maritime Institute'),(980,736,'en','name','University of Dallas'),(981,736,'es','name','Universidad de Dallas'),(982,736,'fr','name','Université de Dallas'),(983,737,'en','name','Leeds Teaching Hospitals NHS Trust'),(984,738,'en','name','Derriford Hospital'),(985,739,'en','name','Calvary Hospital'),(986,740,'en','name','University of Worcester'),(987,741,'en','name','Mokpo National University'),(988,741,'ko','name','목포대학교'),(989,742,'en','name','Autonomous University of Queretaro'),(990,742,'es','name','Universidad Autónoma de Querétaro'),(991,743,'en','name','American Geophysical Union'),(992,744,'en','name','Montgomery General Hospital'),(993,745,'en','name','Catholic University of Santos'),(994,745,'pt','name','Universidade Católica de Santos'),(995,746,'en','name','Marywood University'),(996,747,'en','name','Howard Payne University'),(997,748,'en','name','Battle Hospital'),(998,749,'en','name','Ministry of Health'),(999,750,'en','name','University Malaya Medical Centre'),(1000,751,'en','name','Kyoritsu Women\'s University'),(1001,751,'ja','name','共立女子大学'),(1002,752,'en','name','Seacroft Hospital'),(1003,753,'en','name','Tokyo Medical University Hachioji Medical Center'),(1004,753,'ja','name','東京医科大学八王子医療センター'),(1005,754,'en','name','Honolulu Community College'),(1006,755,'no_lang_code','name','SMEC (Australia)'),(1007,756,'ja','name','福岡病院'),(1008,756,'no_lang_code','name','Fukuoka Hospital'),(1009,757,'en','name','Sookmyung Women\'s University'),(1010,757,'ko','name','숙명여자대학교'),(1011,758,'en','name','Lapland Central Hospital'),(1012,758,'fi','name','Lapin keskussairaala'),(1013,759,'de','name','Sternwarte Stuttgart, Stuttgart Observatory'),(1014,760,'en','name','Eastern Health'),(1015,761,'no_lang_code','name','Alpha Universe'),(1016,762,'ja','name','刈谷豊田総合病院'),(1017,762,'no_lang_code','name','Kariya Toyota General Hospital'),(1018,763,'no_lang_code','name','Sir Hurkisondas Nurrotumdas Medical Research Society'),(1019,764,'en','name','Hyogo Prefectural Awaji Medical Center'),(1020,764,'ja','name','兵庫県立淡路医療センター'),(1021,765,'pt','name','Instituto Superior de Entre Douro e Vouga'),(1022,766,'en','name','National University of Health Sciences'),(1023,767,'en','name','Institute of Nanostructured Materials'),(1024,767,'it','name','Istituto per lo Studio dei Materiali Nanostrutturati'),(1025,768,'en','name','American Society of Health-System Pharmacists'),(1026,769,'en','name','America\'s Health Insurance Plans'),(1027,770,'fr','name','Hôpital Albert Calmette'),(1028,771,'cs','name','Nemocnice Na Homolce'),(1029,771,'en','name','Na Homolce Hospital'),(1030,772,'en','name','College of Saint Benedict and Saint John\'s University'),(1031,772,'fr','name','Collège de saint benedict et université de saint jean'),(1032,773,'en','name','University of Washington Medical Center'),(1033,774,'en','name','University of Lomé'),(1034,774,'fr','name','Université de Lomé'),(1035,775,'en','name','Women\'s & Children\'s Health Research Institute'),(1036,776,'en','name','Hyogo University of Teacher Education'),(1037,776,'ja','name','兵庫教育大学'),(1038,777,'en','name','Youjiang Medical College for Nationalities'),(1039,777,'zh','name','右江民族医学院'),(1040,778,'en','name','Charles Sturt University'),(1041,779,'en','name','Minnesota Department of Human Services'),(1042,780,'en','name','Royal University Hospital'),(1043,781,'no_lang_code','name','BioTek (United States)'),(1044,782,'da','name','Regionshospitalet Skive'),(1045,782,'en','name','Skive Hospital'),(1046,783,'en','name','Reinier de Graaf Hospital'),(1047,784,'en','name','National Institute of Biological Sciences, Beijing'),(1048,784,'zh','name','北京生命科学研究所'),(1049,785,'en','name','Van Andel Institute'),(1050,786,'en','name','American University of Beirut Medical Center'),(1051,787,'en','name','University of Virginia Health System'),(1052,788,'en','name','Grey Nuns Community Hospital'),(1053,789,'en','name','Lutheran Medical Center'),(1054,790,'en','name','Canterbury Health Laboratories'),(1055,791,'no_lang_code','name','Westat (United States)'),(1056,792,'en','name','Highland Hospital'),(1057,793,'en','name','Governors State University'),(1058,794,'en','name','Dongseo University'),(1059,794,'ko','name','동서대학교'),(1060,795,'en','name','Herlev Hospital'),(1061,796,'en','name','Royal Alexandra Hospital'),(1062,797,'en','name','Ohio Cancer Research Associates'),(1063,798,'en','name','Mendota Mental Health Institute'),(1064,799,'en','name','Tomsk State Pedagogical University'),(1065,799,'ru','name','Томский государственный педагогический университет'),(1066,800,'en','name','Carroll College'),(1067,801,'en','name','University of Wisconsin–La Crosse'),(1068,801,'fr','name','Université du Wisconsin–La Crosse'),(1069,802,'en','name','Southern Arizona VA Health Care System'),(1070,803,'en','name','Punjabi University'),(1071,803,'hi','name','पंजाबी विश्वविद्यालय'),(1072,803,'pa','name','ਪੰਜਾਬੀ ਯੂਨੀਵਰਸਿਟੀ'),(1073,804,'en','name','Seoul Veterans Hospital'),(1074,805,'en','name','Ghent University Hospital'),(1075,805,'nl','name','Universitair Ziekenhuis Gent'),(1076,806,'en','name','Monmouth Medical Center'),(1077,807,'pt','name','Hospital Alemão Oswaldo Cruz'),(1078,808,'en','name','Grey\'s Hospital'),(1079,809,'en','name','Wyoming State Department of Health'),(1080,810,'en','name','Federal Rural University of Rio de Janeiro'),(1081,810,'pt','name','Universidade Federal Rural do Rio de Janeiro'),(1082,811,'en','name','Kunming University of Science and Technology'),(1083,811,'zh','name','昆明理工大学'),(1084,812,'fr','name','Hôpital régional'),(1085,813,'en','name','Auburn Community Hospital'),(1086,814,'en','name','NIMTS Hospital'),(1087,815,'en','name','Monroe Carell Jr. Children\'s Hospital'),(1088,816,'no_lang_code','name','Revolution Analytics (United States)'),(1089,817,'en','name','University of Maine at Farmington'),(1090,818,'no_lang_code','name','Compact Membrane Systems (United States)'),(1091,819,'en','name','Kaiser Foundation Hospital'),(1092,820,'en','name','Iranian Institute for Health Sciences Research'),(1093,821,'en','name','Lake Superior State University'),(1094,821,'fr','name','Université d\'État du lac supérieur'),(1095,822,'en','name','Hendrix College'),(1096,823,'en','name','Independent University of Moscow'),(1097,823,'ru','name','Независимый Московский университет'),(1098,824,'ar','name','جامعة قطر'),(1099,824,'en','name','Qatar University'),(1100,824,'es','name','Universidad de Catar'),(1101,825,'en','name','Hunterdon Medical Center'),(1102,826,'pt','name','Instituto Superior de Línguas e Administração'),(1103,827,'pt','name','Hospital Militar Principal'),(1104,828,'en','name','Udmurt State University'),(1105,828,'ru','name','Удмуртский государственный университет'),(1106,829,'en','name','Nagaoka University of Technology'),(1107,829,'ja','name','長岡技術科学大学'),(1108,830,'en','name','Institute of Post Graduate Medical Education and Research'),(1109,831,'en','name','Prince George\'s Community College'),(1110,832,'en','name','Barnsley Hospital NHS Foundation Trust'),(1111,833,'en','name','Silsoe Research Institute'),(1112,834,'no_lang_code','name','Agnico Eagle (Canada)'),(1113,835,'en','name','Saint Francis Hospital'),(1114,836,'en','name','Santa Maria alle Scotte Hospital'),(1115,836,'it','name','Ospedale Santa Maria alle Scotte'),(1116,837,'ar','name','مستشفى الملك فهد للقوات المسلحة'),(1117,837,'en','name','King Fahd Armed Forces Hospital'),(1118,838,'it','name','Azienda ospedaliera \"Bianchi-Melacrino-Morelli\"'),(1119,839,'en','name','University of Wisconsin–Superior'),(1120,839,'fr','name','Université du Wisconsin–Superior'),(1121,840,'pt','name','Hospital de Faro EPE'),(1122,841,'pt','name','Escola Superior de Educação de Torres Novas'),(1123,842,'en','name','Highland Hospital'),(1124,843,'en','name','Butler Hospital'),(1125,844,'en','name','Guangzhou Medical University'),(1126,844,'zh','name','广州医科大学'),(1127,845,'en','name','Ural State University of Economics'),(1128,845,'ru','name','Уральский государственный экономический университет'),(1129,846,'es','name','Hospital Xeral Calde'),(1130,847,'pt','name','Hospital de São José'),(1131,848,'en','name','Vestfold University College'),(1132,849,'en','name','National Tsing Hua University'),(1133,850,'en','name','National Development and Research Institutes'),(1134,851,'en','name','Tunghai University'),(1135,851,'zh','name','東海大學'),(1136,852,'tr','name','Dicle Üniversitesi Hastaneleri'),(1137,853,'en','name','VA San Diego Healthcare System'),(1138,854,'en','name','Nevill Hall Hospital'),(1139,855,'en','name','General Hospital of Athens G. Genimatas'),(1140,856,'es','name','Hospital del Salvador'),(1141,857,'en','name','Al Amal Hospital Jeddah'),(1142,858,'en','name','Latrobe Regional Hospital'),(1143,859,'tr','name','Adana Numune Eğitim ve Araştırma Hastanesi'),(1144,860,'es','name','Hospital Alto Deba'),(1145,861,'en','name','Australian Centre for Sexual Health'),(1146,862,'el','name','Ελληνικός Ερυθρός Σταυρός'),(1147,862,'en','name','Hellenic Red Cross'),(1148,863,'en','name','Hollywood Private Hospital'),(1149,864,'no_lang_code','name','Teleflex (Canada)'),(1150,865,'no_lang_code','name','Shanghai Changzheng Hospital'),(1151,866,'en','name','Golden Jubilee National Hospital'),(1152,867,'fr','name','Centre Hospitalier Universitaire Amiens-Picardie'),(1153,868,'en','name','Canisius College'),(1154,869,'no_lang_code','name','Novogene Bioinformatics Institute'),(1155,870,'en','name','Akron Children\'s Hospital'),(1156,871,'en','name','Shanghai Ninth People\'s Hospital'),(1157,871,'zh','name','上海第九人民医院'),(1158,872,'en','name','Applied Research and Communications Fund'),(1159,873,'en','name','Sri Ramachandra Institute of Higher Education and Research'),(1160,873,'hi','name','श्री रामचंद्र मेडिकल कालिज एवं अनुसंधान संस्थान'),(1161,873,'ta','name','சிறீ இராமச்சந்திரா மருத்துவக் கல்லூரி மற்றும் ஆய்வுக் கழகம்'),(1162,874,'en','name','University of West Alabama'),(1163,875,'en','name','Michigan Health Council'),(1164,876,'pt','name','Hospital Prof. Dr. Fernando Fonseca'),(1165,877,'ja','name','筑波記念病院'),(1166,877,'no_lang_code','name','Tsukuba Memorial Hospital'),(1167,878,'it','name','Ospedale Sant\'Anna'),(1168,879,'no_lang_code','name','Praxis (United States)'),(1169,880,'en','name','Government Medical College and Hospital'),(1170,881,'en','name','Sikkim Manipal University'),(1171,882,'no','name','Bærum Sykehus'),(1172,883,'no_lang_code','name','Integrated Plant Genetics (United States)'),(1173,884,'it','name','Ospedale Sacro Cuore Don Calabria'),(1174,885,'en','name','Embry–Riddle Aeronautical University'),(1175,886,'en','name','National Institute of Agricultural Botany'),(1176,887,'ja','name','中通総合病院'),(1177,887,'no_lang_code','name','Nakadōri General Hospital'),(1178,888,'en','name','Oklahoma City VA Medical Center'),(1179,889,'en','name','Southeast Missouri State University'),(1180,890,'en','name','Craig Hospital'),(1181,891,'en','name','North Memorial Medical Center'),(1182,892,'tr','name','Haseki Eğitim ve Araştırma Hastanesi'),(1183,893,'en','name','South Infirmary Victoria University Hospital'),(1184,894,'en','name','Nagatomi Neurosurgical Hospital'),(1185,894,'ja','name','永冨脳神経外科病院'),(1186,895,'it','name','Ospedale Maggiore Carlo Alberto Pizzardi'),(1187,896,'en','name','Raja Isteri Pengiran Anak Saleha Hospital'),(1188,897,'en','name','Kemerovo State Medical Academy'),(1189,897,'ru','name','Кемеровская государственная медицинская академия'),(1190,898,'pt','name','Escola Universitária Vasco da Gama'),(1191,899,'en','name','Canadian Institute for Health Information'),(1192,900,'en','name','San Salvatore Hospital'),(1193,900,'it','name','Presidio Ospedaliero San Salvatore - Pesaro'),(1194,901,'en','name','Graduate Hospital'),(1195,902,'no_lang_code','name','Glsynthesis'),(1196,903,'en','name','Glanrhyd Hospital'),(1197,904,'fr','name','Centre Hospitalier Universitaire Brugmann'),(1198,905,'fr','name','Centre Hospitalier Jean-Rostand'),(1199,906,'en','name','Cheng Shiu University'),(1200,907,'en','name','Dowling College'),(1201,908,'en','name','St. Luke\'s Hospital'),(1202,909,'en','name','National Hospital of Sri Lanka'),(1203,910,'en','name','CRUK/MRC Oxford Institute for Radiation Oncology'),(1204,911,'en','name','Iranian Academy of Medical Sciences'),(1205,911,'fa','name','فرهنگستان علوم پزشکی جمهوری اسلامی ایران‎‎'),(1206,912,'en','name','Kaiser Permanente Walnut Creek Medical Center'),(1207,913,'en','name','Prince Philip Dental Hospital'),(1208,913,'zh','name','菲臘牙科醫院'),(1209,914,'en','name','Riverview Medical Center'),(1210,915,'en','name','Indira Gandhi Government Medical College & Hospital'),(1211,915,'hi','name','इंदिरा गांधी शासकीय वैद्यकीय महाविद्यालय व रुग्णालय'),(1212,916,'en','name','Linyi People\'s Hospital'),(1213,916,'zh','name','临沂市人民医院'),(1214,917,'en','name','St. Luke\'s-Roosevelt Hospital Center'),(1215,918,'ja','name','パナソニック'),(1216,918,'no_lang_code','name','Panasonic (Japan)'),(1217,919,'en','name','Queens Hospital Center'),(1218,920,'de','name','München Klinik Bogenhausen'),(1219,921,'en','name','Himeji Dokkyo University'),(1220,921,'ja','name','姫路獨協大学'),(1221,922,'en','name','Affiliated Hospital of Xuzhou Medical College'),(1222,923,'en','name','University Clinic of Traumatology'),(1223,924,'nl','name','Spaarne Ziekenhuis'),(1224,925,'en','name','Muhlenberg Regional Medical Center'),(1225,926,'en','name','Prince Philip Hospital'),(1226,927,'en','name','University of Tennessee at Martin'),(1227,928,'sv','name','Hallands sjukhus Kungsbacka'),(1228,929,'de','name','Klinikum Region Hannover'),(1229,930,'en','name','Anqing Normal University'),(1230,930,'zh','name','安庆师范学院'),(1231,931,'no_lang_code','name','Italtel (Italy)'),(1232,932,'fr','name','Hôpital 20 Août'),(1233,933,'da','name','Medicinsk-historisk Museum i Næstved'),(1234,934,'en','name','University of Agriculture in Krakow'),(1235,934,'pl','name','Uniwersytet Rolniczy im. Hugona Kołłątaja w Krakowie'),(1236,935,'en','name','Rotorua Hospital'),(1237,936,'pt','name','Universidade Cidade de São Paulo'),(1238,937,'pt','name','Hospital de Egas Moniz'),(1239,938,'ja','name','洛和会音羽病院'),(1240,938,'no_lang_code','name','Rakuwakai Otowa Hospital'),(1241,939,'en','name','University of Groningen'),(1242,939,'nl','name','Rijksuniversiteit Groningen'),(1243,940,'ar','name','وزارة الصحة'),(1244,940,'en','name','Ministry of Health'),(1245,941,'en','name','Manitoba Pork Council'),(1246,942,'en','name','Doctors Medical Center'),(1247,943,'no_lang_code','name','Huadong Hospital'),(1248,943,'zh','name','复旦大学附属华东医院'),(1249,944,'no_lang_code','name','COM DEV International'),(1250,945,'en','name','Delaware Division of Public Health'),(1251,946,'en','name','Skellefteå Hospital'),(1252,946,'sv','name','Skellefteå Lasarett'),(1253,947,'no_lang_code','name','Yogi Vemana University'),(1254,947,'ta','name','யோகி வேமனா பல்கலைக்கழகம்'),(1255,947,'te','name','యోగి వేమన విశ్వవిద్యాలయం'),(1256,948,'no_lang_code','name','Golder Associates (Canada)'),(1257,949,'en','name','Gifu Municipal Hospital'),(1258,949,'ja','name','岐阜市民病院'),(1259,950,'en','name','Beijing Technology and Business University'),(1260,950,'zh','name','北京工商大学'),(1261,951,'en','name','Beijing Tongren Hospital'),(1262,951,'zh','name','首都医科大学附属北京同仁医院'),(1263,952,'ko','name','강북삼성병원'),(1264,952,'no_lang_code','name','Kangbuk Samsung Hospital'),(1265,953,'en','name','University of Alberta Hospital'),(1266,954,'en','name','Lesley University'),(1267,955,'en','name','Twin Cities Public Television'),(1268,956,'en','name','Kazan State Medical University'),(1269,956,'ru','name','Казанский государственный медицинский университет'),(1270,957,'en','name','Lewis & Clark College'),(1271,958,'en','name','Universeum'),(1272,959,'tr','name','Ankara Numune Eğitim ve Araştırma Hastanesi'),(1273,960,'fr','name','Hôpital Mongi Slim'),(1274,961,'en','name','Hiroshima General Hospital'),(1275,961,'ja','name','広島総合病院'),(1276,962,'de','name','Umweltbundesamt'),(1277,962,'en','name','Environment Agency Austria'),(1278,963,'en','name','Indraprastha Apollo Hospitals'),(1279,964,'en','name','Yokohama Welfare Service Association'),(1280,965,'en','name','Johns Hopkins All Children\'s Hospital'),(1281,966,'en','name','National University of Kaohsiung'),(1282,967,'es','name','Hospital Universitario Fundación Alcorcón'),(1283,968,'pt','name','Hospital do Espírito Santo'),(1284,969,'pt','name','Universidade Santa Úrsula'),(1285,970,'en','name','Cheng Hsin General Hospital'),(1286,971,'en','name','Sojo University'),(1287,971,'ja','name','崇城大学'),(1288,972,'en','name','University Health Care System'),(1289,973,'ja','name','福岡徳洲会病院'),(1290,973,'no_lang_code','name','Fukuoka Tokushukai Hospital'),(1291,974,'ja','name','市立舞鶴市民病院'),(1292,974,'no_lang_code','name','Maizuru Municipal Hospital'),(1293,975,'en','name','Moscow State Aviation Technological University'),(1294,975,'ru','name','Российский государственный технологический университет имени К. Э. Циолковского'),(1295,976,'es','name','Hospital Universitario Austral'),(1296,977,'en','name','Crichton Royal Hospital'),(1297,978,'en','name','Bangour Village Hospital'),(1298,979,'en','name','Health Research Institute of the Hospital Clínico San Carlos'),(1299,979,'es','name','Instituto de Investigación Sanitaria del Hospital Clínico San Carlos'),(1300,980,'en','name','Shandong Pingyi Tianyu Museum of Natural History'),(1301,980,'zh','name','山东省天宇自然博物馆'),(1302,981,'en','name','Jacksonville State University'),(1303,981,'fr','name','Université d\'État de jacksonville'),(1304,982,'de','name','Zentrum für Sonnenenergie- und Wasserstoff-Forschung Baden-Württemberg'),(1305,982,'en','name','Centre for Solar Energy and Hydrogen Research Baden-Württemberg'),(1306,983,'ko','name','보라매 병원'),(1307,983,'no_lang_code','name','Boramae Medical Center'),(1308,984,'en','name','MedStar Franklin Square Medical Center'),(1309,985,'bn','name','ঢাকা মেডিকেল কলেজ'),(1310,985,'en','name','Dhaka Medical College and Hospital'),(1311,986,'en','name','Wested'),(1312,987,'en','name','Health Sciences and Nutrition'),(1313,988,'en','name','Tianjin Medical University Cancer Institute and Hospital'),(1314,988,'zh','name','天津医科大学肿瘤医院'),(1315,989,'no_lang_code','name','Maharat Nakhon Ratchasima Hospital'),(1316,989,'th','name','โรงพยาบาลมหาราชนครราชสีมา'),(1317,990,'en','name','University of Azad Jammu and Kashmir'),(1318,991,'en','name','South London and Maudsley NHS Foundation Trust'),(1319,992,'en','name','York College, City University of New York'),(1320,993,'no_lang_code','name','En Chu Kong Hospital'),(1321,993,'zh','name','行天宮醫療志業醫療財團法人恩主公醫院'),(1322,994,'en','name','Mackay Memorial Hospital'),(1323,994,'zh','name','馬偕紀念醫院'),(1324,995,'en','name','Queen Elizabeth Hospital'),(1325,996,'en','name','Madonna Rehabilitation Hospital'),(1326,997,'en','name','Boston Public Health Commission'),(1327,998,'en','name','English Heritage'),(1328,999,'no_lang_code','name','Kai Research (United States)'),(1329,1000,'en','name','MRC Cancer Unit'),(1330,1001,'en','name','Edith Nourse Rogers Memorial Veterans Hospital'),(1331,1002,'de','name','Stiftung Tierärztliche Hochschule Hannover'),(1332,1002,'en','name','University of Veterinary Medicine Hannover, Foundation'),(1333,1003,'en','name','Catholic University of Health and Allied Sciences'),(1334,1004,'en','name','Hamanomachi Hospital'),(1335,1004,'ja','name','浜の町病院'),(1336,1005,'en','name','Providence Portland Medical Center'),(1337,1006,'en','name','Jeonju University'),(1338,1006,'ko','name','전주대학교'),(1339,1007,'pt','name','Instituto Superior Politécnico do Oeste'),(1340,1008,'en','name','University of Toledo Medical Center'),(1341,1009,'en','name','Kyoto City Hospital'),(1342,1009,'ja','name','京都市立病院'),(1343,1010,'en','name','Jefferson College of Health Sciences'),(1344,1011,'de','name','Hanusch-Krankenhaus'),(1345,1011,'en','name','Hanusch Hospital'),(1346,1012,'es','name','Hospital San Juan de Dios'),(1347,1013,'en','name','Affiliated Hospital of North Sichuan Medical College'),(1348,1013,'zh','name','川北医学院附属医院'),(1349,1014,'no_lang_code','name','Exodus (Greece)'),(1350,1015,'en','name','Mangla Hospital and Research Center'),(1351,1016,'ja','name','順天堂大学'),(1352,1016,'no_lang_code','name','Juntendo University'),(1353,1017,'el','name','251 Γενικό Νοσοκομείο Αεροπορίας'),(1354,1017,'en','name','Hellenic Airforce General Hospital'),(1355,1018,'az','name','Azərbaycan Tibb Universiteti'),(1356,1018,'en','name','Azerbaijan Medical University'),(1357,1018,'ru','name','Азербайджанский медицинский университет'),(1358,1019,'en','name','Hahnemann University Hospital'),(1359,1020,'en','name','Kanagawa Prefectural Institute of Public Health'),(1360,1020,'ja','name','神奈川県衛生研究所'),(1361,1021,'en','name','Ministry of Health'),(1362,1021,'lo','name','กระทรวงสาธารณสุข'),(1363,1022,'en','name','Sint Lucas Andreas Hospital'),(1364,1022,'nl','name','Sint Lucas Andreas Ziekenhuis'),(1365,1023,'en','name','Government Medical College'),(1366,1024,'en','name','Morgan Stanley Children\'s Hospital'),(1367,1025,'en','name','Mercy Children\'s Hospital'),(1368,1026,'es','name','Hospital Universitario de Maracaibo'),(1369,1027,'en','name','New Mexico Highlands University'),(1370,1028,'es','name','Hospital Clínico de la Universidad Católica'),(1371,1029,'en','name','Dakota State University'),(1372,1030,'en','name','University of Ontario Institute of Technology'),(1373,1031,'en','name','National Institute of Advanced Industrial Science and Technology'),(1374,1031,'ja','name','産業技術総合研究所'),(1375,1032,'no_lang_code','name','Iogen Corporation'),(1376,1033,'sv','name','Göteborgs barnsjukhus'),(1377,1034,'en','name','Aultman Hospital'),(1378,1035,'en','name','Milwaukee VA Medical Center'),(1379,1036,'en','name','Huston–Tillotson University'),(1380,1037,'en','name','Gleneagles Hospital'),(1381,1038,'no_lang_code','name','Hatyai Hospital'),(1382,1038,'th','name','โรงพยาบาลหาดใหญ่'),(1383,1039,'en','name','Federal University of Minas Gerais'),(1384,1039,'fr','name','Université fédérale du minas gerais'),(1385,1039,'pt','name','Universidade Federal de Minas Gerais'),(1386,1040,'en','name','Institute of Agrobiological Sciences'),(1387,1040,'ja','name','生物機能利用研究部門'),(1388,1041,'no_lang_code','name','Altera (United States)'),(1389,1042,'en','name','University of North Carolina at Asheville'),(1390,1043,'en','name','Burwood Hospital'),(1391,1044,'en','name','Los Angeles County Department of Public Health'),(1392,1044,'es','name','Departamento de Salud Pública del Condado de Los Ángeles'),(1393,1045,'en','name','Municipality of Amaroussion'),(1394,1046,'en','name','Kaiser Permanente Hayward Medical Center'),(1395,1047,'en','name','Ehime University'),(1396,1047,'ja','name','愛媛大学'),(1397,1048,'en','name','Kobe Central Hospital'),(1398,1048,'ja','name','神戸中央病院'),(1399,1049,'en','name','Fukuoka Children\'s Hospital and Medical Center for Infectious Diseases'),(1400,1049,'ja','name','福岡市立こども病院'),(1401,1050,'en','name','Health Policy Alternatives, Inc.'),(1402,1051,'bg','name','Университет за национално и световно стопанство'),(1403,1051,'en','name','University of National and World Economy'),(1404,1051,'tr','name','Ulusal ve Uluslararası Ekonomi Üniversitesi'),(1405,1052,'en','name','Urban Institute'),(1406,1053,'en','name','Mercy University Hospital'),(1407,1054,'fr','name','Hôpital Max Fourestier'),(1408,1055,'no_lang_code','name','Ford (Germany)'),(1409,1056,'en','name','University System of Georgia'),(1410,1057,'en','name','Soongsil University'),(1411,1057,'ko','name','숭실대학교'),(1412,1058,'en','name','San Francisco Department of Public Health'),(1413,1059,'no_lang_code','name','Messerschmitt-Bölkow-Blohm (Germany)'),(1414,1060,'en','name','American Academy of Arts and Sciences'),(1415,1061,'en','name','Buena Vista University'),(1416,1062,'en','name','Wonkwang University Medical Center'),(1417,1062,'ko','name','원광대학교병원'),(1418,1063,'de','name','Steinbeis-Stiftung'),(1419,1063,'en','name','Steinbeis Foundation'),(1420,1064,'en','name','Nevada Department of Health and Human Services'),(1421,1065,'en','name','John Hunter Hospital'),(1422,1066,'en','name','Sparrow Hospital'),(1423,1067,'en','name','Ministry of Health'),(1424,1067,'km','name','ក្រសួងសុខាភិបាល'),(1425,1068,'en','name','Baylor Medical Center at Garland'),(1426,1069,'ja','name','新潟県立中央病院'),(1427,1069,'no_lang_code','name','Niigata Prefectural Central Hospital'),(1428,1070,'en','name','Jewish Hospital'),(1429,1071,'en','name','International Cooperative Administrative Support Services'),(1430,1072,'en','name','VA Ann Arbor Healthcare System'),(1431,1073,'es','name','Hospital General de Granollers'),(1432,1074,'en','name','Henry Ford Hospital'),(1433,1074,'fr','name','Hôpital henry ford'),(1434,1075,'en','name','St. Luke\'s Episcopal Hospital'),(1435,1076,'en','name','Public Health Institute'),(1436,1077,'en','name','Inje University Haeundae Paik Hospital'),(1437,1077,'ko','name','인제 대학교 해운대 백병원'),(1438,1078,'no_lang_code','name','Metabolic Solutions'),(1439,1079,'en','name','University Dental Hospital of Manchester'),(1440,1080,'en','name','Clinical Center University of Sarajevo'),(1441,1081,'en','name','Government Medical College'),(1442,1081,'pa','name','ਸਰਕਾਰੀ ਮੈਡੀਕਲ ਕਾਲਜ'),(1443,1082,'en','name','Erie County Medical Center'),(1444,1083,'en','name','Royal Berkshire Hospital'),(1445,1084,'en','name','St Helier Hospital'),(1446,1085,'fr','name','Énergie atomique du Canada'),(1447,1085,'no_lang_code','name','Atomic Energy (Canada)'),(1448,1086,'en','name','Brooklyn College'),(1449,1086,'es','name','College de Brooklyn de la Universidad de la Ciudad de Nueva York'),(1450,1087,'en','name','The University of Texas at Arlington'),(1451,1087,'fr','name','Université du Texas à Arlington'),(1452,1088,'en','name','Medical Group Management Association'),(1453,1089,'en','name','Royal London Hospital'),(1454,1090,'de','name','Krankenanstalt Rudolfstiftung der Stadt Wien'),(1455,1091,'en','name','Colorado Department of Public Health and Environment'),(1456,1092,'en','name','Montgomery County Department of Health and Human Services'),(1457,1093,'en','name','Far Eastern Memorial Hospital'),(1458,1094,'sv','name','Ersta sjukhus'),(1459,1095,'en','name','Sheffield Hallam University'),(1460,1096,'no_lang_code','name','Science and Engineering Services (United States)'),(1461,1097,'en','name','National Taipei University of Nursing and Health Science'),(1462,1097,'zh','name','國立臺北護理健康大學'),(1463,1098,'en','name','Mount Elizabeth Hospital'),(1464,1098,'ta','name','மவுண்ட் எலிசபெத் மருத்துவமனை'),(1465,1099,'en','name','Upstate University Hospital'),(1466,1100,'no_lang_code','name','Kingston Process Metallurgy (Canada)'),(1467,1101,'en','name','Princess of Wales Hospital'),(1468,1102,'no_lang_code','name','Ruttonjee Hospital'),(1469,1102,'zh','name','律敦治醫院'),(1470,1103,'en','name','Pondicherry University'),(1471,1103,'hi','name','पॉन्डिचेरी विश्वविद्यालय'),(1472,1103,'ml','name','പോണ്ടിച്ചേരി സർവകലാശാല'),(1473,1103,'ta','name','புதுவைப் பல்கலைக்கழகம்'),(1474,1103,'te','name','పాండిచ్చేరి విశ్వవిద్యాలయం'),(1475,1104,'it','name','Ospedale Regionale di Locarno'),(1476,1105,'no_lang_code','name','Aastrom Biosciences (United States)'),(1477,1106,'en','name','Cantox Health Sciences International'),(1478,1107,'en','name','Jawaharlal Nehru Medical College'),(1479,1108,'en','name','Harry S. Truman Memorial Veterans\' Hospital'),(1480,1109,'en','name','Hillel Yaffe Medical Center'),(1481,1110,'no_lang_code','name','Seonam University'),(1482,1111,'en','name','Shriners Hospitals for Children - Cincinnati'),(1483,1112,'en','name','American Association of Physics Teachers'),(1484,1113,'ar','name','مستشفى الفروانية'),(1485,1113,'no_lang_code','name','Farwaniya Hospital'),(1486,1114,'no_lang_code','name','SomaGenics (United States)'),(1487,1115,'en','name','John Paul II Hospital'),(1488,1115,'pl','name','Krakowski Szpital Specjalistyczny im. Jana Pawła II'),(1489,1116,'en','name','Uppsala University Hospital'),(1490,1116,'sv','name','Akademiska sjukhuset'),(1491,1117,'en','name','The Aerospace Corporation'),(1492,1118,'en','name','Southeastern Oklahoma State University'),(1493,1119,'en','name','Harrisburg Hospital'),(1494,1120,'no_lang_code','name','Biotex (United States)'),(1495,1121,'en','name','North Oaks Health System'),(1496,1122,'en','name','Nagasaki Kawatana Medical Center'),(1497,1122,'ja','name','国立病院機構長崎川棚医療センター'),(1498,1123,'no_lang_code','name','Juniata College'),(1499,1124,'en','name','Rajendra Hospital'),(1500,1125,'es','name','Hospital Carmen y Severo Ochoa'),(1501,1126,'ar','name','وزارة الصحة'),(1502,1126,'en','name','Ministry of Health'),(1503,1127,'en','name','Kowloon Hospital'),(1504,1127,'zh','name','九龍醫院'),(1505,1128,'es','name','Hospital Sierrallana'),(1506,1129,'en','name','New York State Office of Mental Health'),(1507,1130,'no_lang_code','name','Nova Research Company (United States)'),(1508,1131,'en','name','Garvan Institute of Medical Research'),(1509,1132,'no_lang_code','name','Schlumberger (France)'),(1510,1133,'hr','name','Klinička bolnica Merkur'),(1511,1134,'en','name','Federal University of Santa Maria'),(1512,1134,'es','name','Universidad Federal de Santa María'),(1513,1134,'pt','name','Universidade Federal de Santa Maria'),(1514,1135,'no_lang_code','name','Athens Technology Center (Greece)'),(1515,1136,'en','name','National Cheng Kung University'),(1516,1137,'en','name','Kyushu University of Health and Welfare'),(1517,1137,'ja','name','九州保健福祉大学'),(1518,1138,'en','name','Fisk University'),(1519,1138,'es','name','Universidad de Fisk'),(1520,1139,'en','name','Basingstoke and North Hampshire Hospital'),(1521,1140,'fr','name','Centre Hospitalier d\'Orsay'),(1522,1141,'en','name','Benenden Hospital'),(1523,1142,'en','name','University of Guilan'),(1524,1142,'fa','name','دانشگاه گیلان'),(1525,1143,'no_lang_code','name','Hamad General Hospital'),(1526,1144,'en','name','Affiliated Hospital of Chengde Medical College'),(1527,1144,'zh','name','承德医学院附属医院'),(1528,1145,'en','name','Southern Command Hospital'),(1529,1146,'en','name','Chengdu Military General Hospital'),(1530,1146,'zh','name','中国人民解放军成都军区总医院'),(1531,1147,'pt','name','Hospital Heliópolis'),(1532,1148,'en','name','Maesot General Hospital'),(1533,1148,'th','name','โรงพยาบาลแม่สอด'),(1534,1149,'en','name','Heritage Valley Beaver'),(1535,1150,'es','name','Hospital Ramos Mejía'),(1536,1151,'en','name','Northwest Nazarene University'),(1537,1152,'en','name','Northern Light Mercy Hospital'),(1538,1153,'no_lang_code','name','Corixa Corporation'),(1539,1154,'it','name','Ospedale San Giacomo Apostolo'),(1540,1155,'no_lang_code','name','GIUNTI Intenational Division (Italy)'),(1541,1156,'en','name','Academy of Georgofili'),(1542,1156,'it','name','Accademia dei Georgofili'),(1543,1157,'gu','name','મહારાજા સયાજીરાવ વિશ્વવિદ્યાલય'),(1544,1157,'no_lang_code','name','Maharaja Sayajirao University of Baroda'),(1545,1157,'ta','name','மகாராஜா சாயாஜிராவ் பல்கலைக்கழகம்'),(1546,1158,'en','name','Santa Casa Hospital'),(1547,1159,'es','name','Fundación Hospital de Jove'),(1548,1160,'no_lang_code','name','Automotive Fuel Cell Cooperation (Canada)'),(1549,1161,'en','name','Ajou University Hospital'),(1550,1161,'ko','name','아주 대학교 병원'),(1551,1162,'en','name','Baystate Franklin Medical Center'),(1552,1163,'tr','name','Dr Lütfi Kırdar Kartal Eğitim ve Araştırma Hastanesi'),(1553,1164,'en','name','Shih Chien University'),(1554,1165,'en','name','King Fahd Military Medical Complex'),(1555,1166,'el','name','Γενικό Νοσοκομείο Σερρών'),(1556,1166,'en','name','General Hospital of Serres'),(1557,1167,'fr','name','Institut d\'Économie Rurale'),(1558,1168,'no_lang_code','name','STMicroelectronics (France)'),(1559,1169,'no_lang_code','name','First Point Scientific'),(1560,1170,'en','name','Royal Hospital for Children'),(1561,1171,'en','name','Hutt Hospital'),(1562,1172,'en','name','Mercy Hospital for Women'),(1563,1173,'ja','name','長崎労災病院'),(1564,1173,'no_lang_code','name','Nagasaki Rousai Hospital'),(1565,1174,'no_lang_code','name','Lickenbrock'),(1566,1175,'no_lang_code','name','Materials Modification (United States)'),(1567,1176,'en','name','McLaren Regional Medical Center'),(1568,1177,'en','name','Rangsit University'),(1569,1177,'th','name','มหาวิทยาลัยรังสิต'),(1570,1178,'ar','name','مركز هداسا الطبي'),(1571,1178,'en','name','Hadassah Medical Center'),(1572,1179,'en','name','Italian Aerospace Research Centre'),(1573,1179,'it','name','Centro Italiano Ricerche Aerospaziali'),(1574,1180,'en','name','University of West Georgia'),(1575,1181,'en','name','Triangle Coalition For Science and Technology Education'),(1576,1182,'en','name','Royal Belfast Hospital for Sick Children'),(1577,1183,'en','name','Fairfield Infectious Diseases Hospital'),(1578,1184,'en','name','Hannam University'),(1579,1184,'ko','name','한남대학교'),(1580,1185,'pl','name','Centrum Medyczne Kształcenia Podyplomowego'),(1581,1186,'en','name','Santa Maria Nuova Hospital'),(1582,1186,'it','name','Ospedale di Santa Maria Nuova'),(1583,1187,'en','name','Huzhou Central Hospital'),(1584,1187,'zh','name','湖州市中心医院'),(1585,1188,'bn','name','কেপিসি মেডিকাল কলেজ ও কে এস রায় টিবি হাসপাতাল'),(1586,1188,'en','name','KPC Medical College and Hospital'),(1587,1189,'es','name','Clínica La Luz, Hospital La Luz'),(1588,1190,'en','name','Furness General Hospital'),(1589,1191,'no_lang_code','name','E-One Moli Energy (Canada)'),(1590,1192,'en','name','Central Military Hospital'),(1591,1192,'nl','name','Centraal Militair Hospitaal'),(1592,1193,'ar','name','وزارة الصحة الإتحادية'),(1593,1193,'en','name','Federal Ministry of Health'),(1594,1194,'en','name','University of Sindh'),(1595,1194,'ur','name','سندھ یونیورسٹی'),(1596,1195,'it','name','Ospedale San Carlo'),(1597,1196,'en','name','University Health System'),(1598,1197,'ar','name','هيئة الصحة بدبي'),(1599,1197,'en','name','Dubai Health Authority'),(1600,1198,'en','name','Sathyabama Institute of Science and Technology'),(1601,1198,'ta','name','சத்யபாமா ப‌ல்கலைக்கழகம்'),(1602,1198,'te','name','సత్యభామ విశ్వవిద్యాలయం'),(1603,1199,'en','name','Era\'s Lucknow Medical College and Hospital'),(1604,1200,'it','name','Ospedale Cristo Re'),(1605,1201,'en','name','Rider University'),(1606,1201,'es','name','Universidad Rider'),(1607,1201,'fr','name','Université de rider'),(1608,1202,'no_lang_code','name','Dalsa Corporation'),(1609,1203,'ja','name','東京都立墨東病院'),(1610,1203,'no_lang_code','name','Tokyo Metropolitan Bokutoh Hospital'),(1611,1204,'ja','name','心臓血管センター北海道大野病院'),(1612,1204,'no_lang_code','name','Cardiovascular Center Hokkaido Ohno Hospital'),(1613,1205,'pt','name','Hospital Santa Izabel'),(1614,1206,'en','name','Sabbatsberg Hospital'),(1615,1206,'sv','name','Sabbatsbergs Sjukhus'),(1616,1207,'en','name','Lexington VA Health Care System'),(1617,1208,'en','name','Lakeshore Hospital'),(1618,1209,'en','name','Shriners Hospitals for Children - Northern California'),(1619,1210,'en','name','Scripps Memorial Hospital'),(1620,1211,'cy','name','Ysbyty Clattebridge'),(1621,1211,'en','name','Clatterbridge Hospital'),(1622,1212,'en','name','Jiangxi Provincial People\'s Hospital'),(1623,1212,'zh','name','江西省人民医院'),(1624,1213,'en','name','Repatriation General Hospital'),(1625,1214,'en','name','University Hospital Ayr'),(1626,1215,'en','name','Sapporo Azabu Neurosurgical Hospital'),(1627,1215,'ja','name','札幌麻生脳神経外科病院'),(1628,1216,'it','name','Società Anonima Italiana Perforazioni E Montaggi'),(1629,1216,'no_lang_code','name','Saipem (Italy)'),(1630,1217,'en','name','Nara City Hospital'),(1631,1217,'ja','name','市立奈良病院'),(1632,1218,'en','name','Prince George\'s Hospital Center'),(1633,1219,'fr','name','Hôpital Saint-Philibert'),(1634,1220,'fr','name','Hôpital Saint Charles'),(1635,1221,'en','name','Portland Community College'),(1636,1222,'en','name','Priest Hospital'),(1637,1222,'th','name','โรงพยาบาลสงฆ์'),(1638,1223,'no_lang_code','name','Nanomaterials Research (United States)'),(1639,1224,'en','name','Oregon Museum of Science and Industry'),(1640,1225,'en','name','Jaswant Rai Speciality Hospital'),(1641,1226,'en','name','Jackson State University'),(1642,1226,'fr','name','Université d\'État de Jackson'),(1643,1227,'en','name','Alabama State University'),(1644,1228,'no_lang_code','name','Bell Helicopter Textron (Canada)'),(1645,1229,'en','name','Beijing Chao-Yang Hospital'),(1646,1229,'zh','name','北京朝阳医院'),(1647,1230,'en','name','Stetson University'),(1648,1231,'en','name','Baptist Health System'),(1649,1232,'no_lang_code','name','Nantong Tumor Hospital'),(1650,1232,'zh','name','南通市肿瘤医院'),(1651,1233,'en','name','Sandviken Hospital'),(1652,1233,'sv','name','Sandviken sykehus'),(1653,1234,'ar','name','جامعة محمد الأول'),(1654,1234,'en','name','Mohamed I University'),(1655,1234,'fr','name','Université Mohammed Ier'),(1656,1235,'pl','name','4. Wojskowy Szpital Kliniczny z Polikliniką'),(1657,1236,'en','name','Blood Systems Research Institute'),(1658,1237,'en','name','Konyang University Hospital'),(1659,1237,'ko','name','한양 대학교 병원'),(1660,1238,'ja','name','佐賀県医療センター好生館'),(1661,1238,'no_lang_code','name','Saga-Ken Medical Centre Koseikan'),(1662,1239,'en','name','Mansfield University'),(1663,1240,'pt','name','Hospital Pedro Hispano'),(1664,1241,'en','name','Lady Reading Hospital'),(1665,1242,'en','name','Hokko Memorial Hospital'),(1666,1242,'ja','name','北光記念病院'),(1667,1243,'no_lang_code','name','Northwest Media (United States)'),(1668,1244,'en','name','Beijing Chest Hospital'),(1669,1245,'es','name','Hospital Médica Sur'),(1670,1246,'en','name','Portuguese Naval School'),(1671,1246,'pt','name','Escola Naval'),(1672,1247,'en','name','King University'),(1673,1248,'en','name','Malcom Randall VA Medical Center'),(1674,1249,'en','name','Kern Medical Center'),(1675,1250,'en','name','College of Medical Sciences'),(1676,1251,'en','name','Anyang Academy of Agricultural Sciences'),(1677,1251,'zh','name','安阳市农业科学院'),(1678,1252,'en','name','Magee-Womens Hospital'),(1679,1253,'en','name','Denver Health Medical Center'),(1680,1254,'en','name','University of Montevallo'),(1681,1255,'en','name','Maritime Research Institute Netherlands'),(1682,1256,'en','name','Gaustad Hospital'),(1683,1256,'no','name','Gaustad Sykehus'),(1684,1257,'ar','name','مشفى رمبام'),(1685,1257,'en','name','Rambam Health Care Campus'),(1686,1257,'he','name','רמב\"ם - הקריה הרפואית לבריאות האדם‎'),(1687,1258,'ja','name','弘前愛成会病院'),(1688,1258,'no_lang_code','name','Hirosakiaiseikai Hospital'),(1689,1259,'en','name','Catholic University of Korea'),(1690,1259,'ko','name','가톨릭대학교'),(1691,1260,'no_lang_code','name','Yuan Ze University'),(1692,1261,'en','name','Tajen University'),(1693,1262,'en','name','Presbyterian Medical Center'),(1694,1262,'ko','name','예수병원'),(1695,1263,'en','name','Center for Health Care Law'),(1696,1264,'en','name','Doshisha University'),(1697,1264,'ja','name','同志社大学'),(1698,1265,'en','name','Abbott Northwestern Hospital'),(1699,1266,'en','name','Alice Ho Miu Ling Nethersole Hospital'),(1700,1266,'zh','name','雅麗氏何妙齡那打素醫院'),(1701,1267,'en','name','International Union of Railways'),(1702,1267,'fr','name','Union internationale des chemins de fer'),(1703,1268,'pt','name','Instituto Superior de Gestão e Administração de Santarém'),(1704,1269,'no_lang_code','name','BG Group (United Kingdom)'),(1705,1270,'en','name','Mississippi Department of Mental Health'),(1706,1271,'en','name','Mercer University Health Sciences Center'),(1707,1272,'es','name','Hospital de Hellín'),(1708,1273,'en','name','Saint John\'s Health Center'),(1709,1274,'no_lang_code','name','Stantec (Canada)'),(1710,1275,'en','name','Japanese Red Cross Medical Center'),(1711,1275,'ja','name','日本赤十字社医療センター'),(1712,1276,'en','name','Canadian Foundation for Healthcare Improvement'),(1713,1277,'no_lang_code','name','Trevigen'),(1714,1278,'ko','name','상지대학교'),(1715,1278,'no_lang_code','name','Sangji University'),(1716,1279,'en','name','Center for Tuberculosis Control of Guangdong Province'),(1717,1279,'zh','name','广东省结核病控制'),(1718,1280,'en','name','Torrey Pines Institute For Molecular Studies'),(1719,1281,'en','name','New York City Department of Health and Mental Hygiene'),(1720,1282,'en','name','University of Taubaté'),(1721,1282,'pt','name','Universidade de Taubaté'),(1722,1283,'en','name','National Sagamihara Hospital'),(1723,1283,'ja','name','国立病院機構相模原病院'),(1724,1284,'en','name','Christiana Hospital'),(1725,1285,'en','name','Sharp Memorial Hospital'),(1726,1286,'en','name','Kun Shan University'),(1727,1287,'en','name','PBR Laboratories'),(1728,1288,'en','name','Penn State Milton S. Hershey Medical Center'),(1729,1289,'no_lang_code','name','Spartan Bioscience (Canada)'),(1730,1290,'en','name','Birjand University of Medical Sciences'),(1731,1290,'fa','name','دانشگاه علوم پزشکی بیرجند'),(1732,1291,'en','name','Jewish Hospital'),(1733,1292,'en','name','Transylvania University'),(1734,1293,'no_lang_code','name','SurModics (United States)'),(1735,1294,'no_lang_code','name','TXT e-solutions (Italy)'),(1736,1295,'no_lang_code','name','Friday Systems (United States)'),(1737,1296,'en','name','Mount Sinai Hospital'),(1738,1297,'en','name','Princess Margaret Rose Orthopaedic Hospital'),(1739,1298,'no_lang_code','name','Progenra (United States)'),(1740,1299,'en','name','Cincinnati Children\'s Hospital Medical Center'),(1741,1300,'cs','name','Výzkumný Ústav Zdraví Dítěte'),(1742,1301,'en','name','University of Benin Teaching Hospital'),(1743,1302,'en','name','Hiroshima City Asa Citizens Hospital'),(1744,1302,'ja','name','広島市立安佐市民病院'),(1745,1303,'en','name','Mississippi University for Women'),(1746,1304,'en','name','St John\'s Hospital'),(1747,1305,'de','name','Gesellschaft für Chemische Technik und Biotechnologie'),(1748,1305,'en','name','Society for Chemical Engineering and Biotechnology'),(1749,1306,'en','name','Michigan Surgical Hospital'),(1750,1307,'en','name','University of Minnesota, Duluth'),(1751,1308,'no_lang_code','name','Neova Technologies Inc.'),(1752,1309,'en','name','Chaudhary Charan Singh University'),(1753,1309,'hi','name','चौधरी चरण सिंह विश्वविद्यालय'),(1754,1309,'ta','name','சௌதரி சரண் சிங் பல்கலைக்கழகம்'),(1755,1310,'en','name','University of Phoenix'),(1756,1310,'es','name','Universidad de Phoenix'),(1757,1310,'fr','name','Université de phoenix'),(1758,1311,'it','name','Ospedali Riuniti di Ancona'),(1759,1312,'en','name','New York Hospital Queens'),(1760,1313,'en','name','Kelowna General Hospital'),(1761,1314,'ar','name','مستشفئ الرازي'),(1762,1314,'fr','name','Hôpital Razi de La Manouba'),(1763,1315,'de','name','Leopoldina Krankenhaus Schweinfurt'),(1764,1316,'tr','name','Dr Sami Ulus Çocuk Sağlığı ve Hastalıkları Eğitim ve Araştırma Hastanesi'),(1765,1317,'en','name','Golmud People\'s Hospital'),(1766,1317,'zh','name','格尔木市人民医院'),(1767,1318,'en','name','District of Columbia Department of Health'),(1768,1319,'en','name','Shimane University'),(1769,1319,'ja','name','島根大学'),(1770,1320,'en','name','Kin-ikyo Chuo Hospital'),(1771,1320,'ja','name','勤医協中央病院'),(1772,1321,'en','name','Berkeley Geochronology Center'),(1773,1322,'fr','name','Centre Technique Industriel De La Construction Metallique'),(1774,1323,'en','name','Pacific Institute For Research and Evaluation'),(1775,1324,'en','name','Gosford Hospital'),(1776,1325,'en','name','Istanbul Florence Nightingale Hospital'),(1777,1325,'tr','name','İstanbul Florence Nightingale Hastanesi'),(1778,1326,'en','name','Kishiwada City Hospital'),(1779,1326,'ja','name','市立岸和田市民病院'),(1780,1327,'pt','name','Hospital de Dona Estefânia'),(1781,1328,'en','name','Hospital of the Holy Spirit'),(1782,1328,'it','name','Ospedale di Santo Spirito, Ospedale di Santo Spirito in Sassia'),(1783,1329,'en','name','Broward Health Medical Center'),(1784,1330,'en','name','Banner Desert Medical Center'),(1785,1331,'no_lang_code','name','Sirehna'),(1786,1332,'en','name','Rochester General Hospital'),(1787,1333,'en','name','Mission Heritage Medical Group'),(1788,1334,'no_lang_code','name','TuTech Innovation (Germany)'),(1789,1335,'en','name','Chuvash State University'),(1790,1335,'ru','name','Чувашский государственный университет имени И. Н. Ульянова'),(1791,1336,'es','name','Hospital General Universitario de Elche'),(1792,1337,'fr','name','Hôpital de Jolimont'),(1793,1338,'en','name','Mediterranean Center for Environmental Studies'),(1794,1338,'es','name','Centro de Estudios Ambientales del Mediterráneo'),(1795,1339,'en','name','Wayne Memorial Health System'),(1796,1340,'ja','name','大阪大谷大学'),(1797,1340,'no_lang_code','name','Osaka Ohtani University'),(1798,1341,'en','name','Mercy Catholic Medical Center'),(1799,1342,'en','name','Ashworth College'),(1800,1343,'ja','name','熊本労災病院'),(1801,1343,'no_lang_code','name','Kumamotorosaibyoin'),(1802,1344,'no_lang_code','name','AUG Signals (Canada)'),(1803,1345,'en','name','Dr. V. M. Government Medical College'),(1804,1345,'mr','name','डॉ. वैशंपायन स्मृती शासकीय वैद्यकीय महाविद्यालय'),(1805,1346,'en','name','Jan Evangelista Purkyně Military Medical Academy'),(1806,1347,'en','name','Omsk State University'),(1807,1347,'ru','name','Омский государственный университет имени Ф. М. Достоевского'),(1808,1348,'en','name','Hennepin County Medical Center'),(1809,1349,'en','name','Keio University Hospital'),(1810,1349,'ja','name','慶應義塾大学病院'),(1811,1350,'no_lang_code','name','Infinite Biomedical Technologies (United States)'),(1812,1351,'en','name','Ugo Bordoni Foundation'),(1813,1351,'it','name','Fondazione \"Ugo Bordoni\"'),(1814,1352,'en','name','Kent Hospital'),(1815,1353,'es','name','Hospital La Paloma'),(1816,1354,'de','name','Battelle-Institut ev'),(1817,1355,'no_lang_code','name','Electrical Geodesics (United States)'),(1818,1356,'en','name','Second Affiliated Hospital of Kunming Medical College'),(1819,1356,'zh','name','昆明医科大学第二附属医院'),(1820,1357,'en','name','Sansum Diabetes Research Institute'),(1821,1358,'en','name','Kurihama Medical and Addiction Center'),(1822,1358,'ja','name','久里浜医療センター'),(1823,1359,'en','name','Rivers State University'),(1824,1360,'en','name','University of Virginia Children\'s Hospital'),(1825,1361,'en','name','Seoul National University Children\'s Hospital'),(1826,1361,'ko','name','서울대학교어린이병원'),(1827,1362,'en','name','McLean Hospital'),(1828,1363,'no_lang_code','name','Ontario Power Generation'),(1829,1364,'en','name','South Australia Pathology'),(1830,1365,'no_lang_code','name','BGI Group (Japan)'),(1831,1366,'no_lang_code','name','Atos (Spain)'),(1832,1367,'pt','name','Hospital Federal dos Servidores do Estado'),(1833,1368,'en','name','Qiqihar Medical University'),(1834,1368,'zh','name','齐齐哈尔医学院'),(1835,1369,'en','name','Thiel College'),(1836,1370,'ar','name','مستشفى الملك فهد التخصصي'),(1837,1370,'en','name','King Fahad Specialist Hospital'),(1838,1371,'en','name','University Hospital of Geneva'),(1839,1371,'fr','name','Hôpitaux universitaires de Genève'),(1840,1372,'en','name','Association Of Atlantic Universities'),(1841,1373,'en','name','Copernicus Memorial Hospital'),(1842,1374,'en','name','All India Institute of Hygiene and Public Health'),(1843,1374,'hi','name','अखिल भारतीय स्वास्थ्य र्विज्ञान एवं जन स्वास्थ्य संस्थान'),(1844,1375,'no_lang_code','name','Smithers Pira'),(1845,1376,'es','name','Hospital Central Dr. Ignacio Morones Prieto'),(1846,1377,'en','name','Dauphin Island Sea Lab'),(1847,1378,'en','name','Federation of American Societies for Experimental Biology'),(1848,1379,'en','name','St Martha\'s Regional Hospital'),(1849,1380,'en','name','Government Kilpauk Medical College'),(1850,1380,'ta','name','கீழ்பாக்கம் மருத்துவக் கல்லூரி'),(1851,1381,'es','name','Hospital Regional Universitario de Málaga'),(1852,1382,'en','name','Federal University of Mato Grosso'),(1853,1382,'pt','name','Universidade Federal de Mato Grosso'),(1854,1383,'no_lang_code','name','Dornier Flugzeugwerke (Germany)'),(1855,1384,'ar','name','مستشفى العدان'),(1856,1384,'no_lang_code','name','Adan Hospital'),(1857,1385,'en','name','San Jacinto Methodist Hospital'),(1858,1386,'en','name','First Affiliated Hospital of Guangzhou University of Chinese Medicine'),(1859,1387,'en','name','Nayoro City General Hospital'),(1860,1387,'ja','name','名寄市立総合病院'),(1861,1388,'en','name','Sivas State Hospital'),(1862,1388,'tr','name','Sivas Devlet Hastanesi'),(1863,1389,'en','name','Chu Shang Show Chwan Hospital'),(1864,1390,'fr','name','Hôpital Aristide Le Dantec'),(1865,1391,'en','name','Rancho Santa Ana Botanic Garden'),(1866,1392,'en','name','Meyer Children\'s Hospital'),(1867,1392,'it','name','Ospedale Pediatrico Meyer'),(1868,1393,'en','name','Forest Department Sarawak'),(1869,1394,'en','name','Birmingham and Midland Eye Centre'),(1870,1395,'pt','name','Escola Superior de Enfermagem S. Francisco das Misericórdias'),(1871,1396,'no_lang_code','name','Bioqual'),(1872,1397,'en','name','Rosie Hospital'),(1873,1398,'en','name','Institute of Global Environment and Society'),(1874,1399,'en','name','Charlie Norwood VA Medical Center'),(1875,1400,'ja','name','名古屋掖済会病院'),(1876,1400,'no_lang_code','name','Nagoya Ekisaikai Hospital'),(1877,1401,'en','name','Froedtert Hospital'),(1878,1402,'fr','name','Hydro-Québec'),(1879,1403,'en','name','Hinchingbrooke Hospital'),(1880,1404,'en','name','Royal Alexandra Hospital'),(1881,1405,'el','name','Ινστιτούτο Επιταχυντικών Συστημάτων και Εφαρμογών'),(1882,1405,'en','name','Institute of Accelerating Systems and Applications'),(1883,1406,'en','name','National Ilan University'),(1884,1406,'zh','name','國立宜蘭大學'),(1885,1407,'no_lang_code','name','Aerodyne Research'),(1886,1408,'en','name','Ljubljana University Medical Centre'),(1887,1409,'es','name','Instituto Tecnologico Del Embalaje, Transporte Y Logistica'),(1888,1410,'en','name','Shiga Medical Center for Children'),(1889,1410,'ja','name','子供のための滋賀医療センター'),(1890,1411,'en','name','Vladimir State University'),(1891,1411,'ru','name','Федеральное государственное бюджетное образовательное учреждение высшего образования Владимирский государственный университет имени Александра Григорьевича и Николая Григорьевича Столетовых'),(1892,1412,'en','name','Second Affiliated Hospital of Nanchang University'),(1893,1412,'zh','name','南昌大学第二附属医院'),(1894,1413,'en','name','Oita University'),(1895,1413,'ja','name','大分大学'),(1896,1414,'en','name','Breach Candy Hospital'),(1897,1415,'en','name','Taoyuan Armed Forces General Hospital'),(1898,1415,'zh','name','桃园武装部队总医院'),(1899,1416,'en','name','Dickinson State University'),(1900,1417,'en','name','Heilongjiang Center for Tuberculosis Control and Prevention'),(1901,1418,'en','name','Kansas Wesleyan University'),(1902,1419,'es','name','Hospital Universitari Arnau de Vilanova'),(1903,1420,'en','name','Mississippi College'),(1904,1421,'cy','name','Ysbyty Treforus'),(1905,1421,'en','name','Morriston Hospital'),(1906,1422,'it','name','Ospedale Amedeo di Savoia'),(1907,1423,'en','name','University of Tabriz'),(1908,1423,'fa','name','دانشگاه تبریز'),(1909,1424,'en','name','302 Military Hospital of China'),(1910,1424,'zh','name','中国人民解放军第302医院'),(1911,1425,'en','name','Boca Raton Regional Hospital'),(1912,1426,'en','name','Akdeniz University Hospital'),(1913,1426,'tr','name','Akdeniz Üniversitesi Hastanesi'),(1914,1427,'en','name','Nordland Hospital'),(1915,1428,'en','name','Eastbourne District General Hospital'),(1916,1429,'en','name','Akashi Municipal City Hospital'),(1917,1429,'ja','name','明石市立市民病院'),(1918,1430,'en','name','South Nassau Communities Hospital'),(1919,1431,'tr','name','Antalya Eğitim ve Araştırma Hastanesi'),(1920,1432,'en','name','National Institute of Occupational Health'),(1921,1433,'no_lang_code','name','Fountain Biopharma (Taiwan)'),(1922,1434,'ja','name','石切生喜病院'),(1923,1434,'no_lang_code','name','Ishikiriseiki Hospital'),(1924,1435,'ar','name','جامعة البعث'),(1925,1435,'en','name','Al-Baath University'),(1926,1436,'en','name','Bentley University'),(1927,1437,'en','name','Sun Yat-sen Memorial Hospital'),(1928,1438,'en','name','Meyer Children\'s Hospital'),(1929,1439,'en','name','Miyazaki Prefectural Hospital'),(1930,1439,'ja','name','宮崎県立病院'),(1931,1440,'en','name','Centre for Research in Medical Entomology'),(1932,1441,'en','name','Inje University Busan Paik Hospital'),(1933,1442,'eu','name','Hospital Txagorritxu'),(1934,1443,'fr','name','Hôpital Pierre Wertheimer'),(1935,1444,'en','name','Roper Hospital'),(1936,1445,'el','name','Πανεπιστημιακό Νοσοκομείο ΑΧΕΠΑ'),(1937,1445,'en','name','AHEPA University Hospital'),(1938,1446,'en','name','Virginia Tech - Wake Forest University School of Biomedical Engineering & Sciences'),(1939,1447,'en','name','Baystate Medical Center'),(1940,1448,'en','name','State of Maine Department of Health and Human Services'),(1941,1448,'es','name','Departamento de Salud y Servicios Sociales de los Estados Unidos'),(1942,1448,'fr','name','Département de la santé et des services sociaux des États-unis'),(1943,1449,'no_lang_code','name','Hydro One (Canada)'),(1944,1450,'it','name','Ospedale Garibaldi'),(1945,1451,'nl','name','Elkerliek Ziekenhuis'),(1946,1452,'no_lang_code','name','BASF (Germany)'),(1947,1453,'en','name','Boys Town National Research Hospital'),(1948,1454,'en','name','Papworth Hospital NHS Foundation Trust'),(1949,1455,'en','name','Association of Academic Health Centers'),(1950,1456,'no_lang_code','name','Mahosot Hospital'),(1951,1457,'en','name','Mario Negri Sud Foundation'),(1952,1457,'it','name','Fondazione Mario Negri Sud'),(1953,1458,'en','name','Bryn Mawr Rehabilitation Hospital'),(1954,1459,'en','name','Family and Social Services Administration'),(1955,1460,'en','name','Ministry of Health'),(1956,1460,'es','name','Ministerio de Salud de Chile'),(1957,1461,'en','name','Manipal Teaching Hospital'),(1958,1461,'ne','name','मणिपाल टीचिंग हस्पिटल'),(1959,1462,'en','name','Sichuan Academy of Medical Sciences & Sichuan Provincial People\'s Hospital'),(1960,1462,'zh','name','四川省中医药科学院'),(1961,1463,'sv','name','Västmanlands sjukhus Västerås'),(1962,1464,'en','name','Yuri Gagarin State Technical University of Saratov'),(1963,1464,'ru','name','Саратовский государственный технический университет имени Ю. А. Гагарина'),(1964,1465,'es','name','Hospital Español'),(1965,1466,'en','name','Regional Medical Research Centre'),(1966,1467,'en','name','Tohoku Fukushi University'),(1967,1467,'ja','name','東北福祉大学'),(1968,1468,'en','name','Lithuanian Bioethics Committee'),(1969,1468,'lt','name','Lietuvos Bioetikos Komitetas'),(1970,1469,'en','name','Federal Office of Public Health'),(1971,1470,'en','name','Technical University of Nova Scotia'),(1972,1471,'en','name','University of Port Harcourt Teaching Hospital'),(1973,1472,'no_lang_code','name','Universal Stabilization Technologies'),(1974,1473,'en','name','Dominican University'),(1975,1474,'en','name','Hoseo University'),(1976,1474,'ko','name','호서대학교'),(1977,1475,'en','name','Brighton and Sussex Medical School'),(1978,1476,'en','name','Chung-Ang University'),(1979,1476,'ko','name','중앙대학교'),(1980,1477,'tr','name','Ankara Onkoloji Eğitim ve Araştırma Hastanesi'),(1981,1478,'ja','name','平塚共済病院'),(1982,1478,'no_lang_code','name','Hiratsuka Kyosai Hospital'),(1983,1479,'en','name','Saint John\'s Hospital'),(1984,1480,'tr','name','S.B. Keçiören Eğitim ve Araştırma Hastanesi'),(1985,1481,'de','name','Von Karman Institut für Strömungsmechanik'),(1986,1481,'en','name','Von Karman Institute for Fluid Dynamics'),(1987,1481,'fr','name','Institut von karman de dynamique des fluides'),(1988,1482,'en','name','Royal Victoria Regional Health Centre'),(1989,1483,'en','name','Niigata City General Hospital'),(1990,1483,'ja','name','新潟市民病院'),(1991,1484,'en','name','Bristol Hospital'),(1992,1485,'en','name','Blackpool Victoria Hospital'),(1993,1486,'pt','name','Hospital Nossa Senhora das Graças'),(1994,1487,'en','name','Department of Human Services'),(1995,1488,'no_lang_code','name','Inspiralia'),(1996,1489,'sk','name','Univerzitná Nemocnica Louisa Pasteura'),(1997,1490,'en','name','Shariati Hospital'),(1998,1490,'fa','name','بیمارستان شریعتی'),(1999,1491,'en','name','M. P. Shah Medical College'),(2000,1491,'gu','name','શ્રી એમપી શાહ સરકારી મેડિકલ કોલેજ'),(2001,1492,'en','name','Lee Memorial Hospital'),(2002,1493,'es','name','Hospital Provincial de Conxo'),(2003,1494,'en','name','Kangwon National University Hospital'),(2004,1494,'ko','name','강원대학교병원'),(2005,1495,'en','name','University of Alabama at Birmingham Hospital'),(2006,1496,'ja','name','県立広島病院'),(2007,1496,'no_lang_code','name','Hiroshima Prefectural Hospital'),(2008,1497,'en','name','Ministry of Health and Medical Education'),(2009,1498,'en','name','Mitate Hospital'),(2010,1498,'ja','name','見立病院'),(2011,1499,'en','name','Military Hospital'),(2012,1500,'en','name','Korea Institute of Materials Science'),(2013,1501,'en','name','Ahvaz Jundishapur University of Medical Sciences'),(2014,1501,'fa','name','دانشگاه علوم پزشکی جندی‌شاپور اهواز'),(2015,1502,'pt','name','Guarulhos University'),(2016,1503,'en','name','La Trobe University'),(2017,1504,'no_lang_code','name','Balance Technology Consulting'),(2018,1505,'en','name','Sentara Rockingham Memorial Hospital Medical Center'),(2019,1506,'en','name','Inverclyde Royal Hospital'),(2020,1507,'en','name','Nathan Kline Institute for Psychiatric Research'),(2021,1508,'ja','name','静岡済生会総合病院'),(2022,1508,'no_lang_code','name','Shizuoka Saiseikai General Hospital'),(2023,1509,'en','name','Lunenfeld-Tanenbaum Research Institute'),(2024,1510,'en','name','University Hospital of Larissa'),(2025,1511,'en','name','Central Arkansas Veterans Healthcare System'),(2026,1512,'en','name','Miyagi University of Education'),(2027,1512,'ja','name','宮城教育大学'),(2028,1513,'fr','name','Hotel Dieu Hospital'),(2029,1514,'en','name','Lviv University'),(2030,1514,'hu','name','Ivan Franko Nemzeti Egyetem Lviv'),(2031,1514,'pl','name','Uniwersytet Lwowski'),(2032,1514,'ru','name','Львовский национальный университет имени Ивана Франко'),(2033,1514,'uk','name','Львівський національний університет імені Івана Франка'),(2034,1515,'en','name','Eastern Oregon University'),(2035,1516,'en','name','Kushiro Rosai Hospital'),(2036,1516,'ja','name','釧路ろうさい病院'),(2037,1517,'en','name','Trinitas Regional Medical Center'),(2038,1518,'en','name','East Orange VA Medical Center'),(2039,1519,'en','name','Millard Fillmore Suburban Hospital'),(2040,1520,'en','name','Lower Manhattan Hospital'),(2041,1521,'de','name','Bundesinstitut für gesundheitlichen Verbraucherschutz und Veterinärmedizin'),(2042,1521,'en','name','Federal Institute for Health Protection of Consumers and Veterinary Medicine'),(2043,1522,'en','name','Doctors Hospital'),(2044,1523,'en','name','Arizona Department of Health Services'),(2045,1524,'en','name','The University of Texas Health Science Center at Tyler'),(2046,1525,'en','name','Ministry of Health'),(2047,1525,'uk','name','Міністерство охорони здоров\'я України'),(2048,1526,'en','name','National Science Museum'),(2049,1527,'it','name','Consorzio Pisa Ricerche'),(2050,1528,'en','name','Arkansas Children\'s Hospital'),(2051,1529,'en','name','Central Chest Institute of Thailand'),(2052,1530,'en','name','Regional Hospital Holstebro'),(2053,1531,'en','name','Grantham Hospital'),(2054,1531,'zh','name','葛量洪醫院'),(2055,1532,'en','name','Queen Fabiola Children\'s University Hospital'),(2056,1532,'fr','name','Hôpital Universitaire Des Enfants Reine Fabiola'),(2057,1533,'en','name','St. Luke\'s Hospital'),(2058,1534,'en','name','Mary Free Bed Rehabilitation Hospital'),(2059,1535,'en','name','Consortium of Universities for Research in Earthquake Engineering'),(2060,1536,'en','name','University of Houston - Clear Lake'),(2061,1537,'en','name','University of California San Francisco Medical Center'),(2062,1538,'no_lang_code','name','Aurum Institute'),(2063,1539,'hu','name','Bács-Kiskun Megyei Kórház'),(2064,1540,'en','name','Dongshin University'),(2065,1540,'ko','name','동신대학교'),(2066,1541,'pt','name','Universidade Sagrado Coração'),(2067,1542,'en','name','Montana State University Billings'),(2068,1543,'en','name','Nagasaki International University'),(2069,1543,'ja','name','長崎国際大学'),(2070,1544,'en','name','North Wales Hospital'),(2071,1545,'en','name','Hayashi Eye Hospital'),(2072,1546,'pt','name','Universidade Ibirapuera'),(2073,1547,'en','name','Command Hospital'),(2074,1548,'en','name','Children\'s Medical Center'),(2075,1549,'en','name','Saint Louis University Hospital'),(2076,1550,'en','name','National Board of Health and Welfare'),(2077,1551,'en','name','Autonomous University of Campeche'),(2078,1551,'es','name','Universidad Autónoma de Campeche'),(2079,1552,'en','name','Siena College'),(2080,1553,'no_lang_code','name','Semex'),(2081,1554,'en','name','Korea Maritime and Ocean University'),(2082,1554,'ko','name','한국해양대학교'),(2083,1555,'en','name','National Sanyo Hospital'),(2084,1555,'ja','name','国立病院機構山口宇部医療センター'),(2085,1556,'en','name','Shriners Hospitals for Children - Galveston'),(2086,1557,'en','name','Mie University Hospital'),(2087,1557,'ja','name','三重大学病院'),(2088,1558,'en','name','Ibis Reproductive Health'),(2089,1559,'en','name','Kyung Hee University Medical Center'),(2090,1560,'pt','name','Escola Superior Artística do Porto'),(2091,1561,'en','name','Christian Medical College'),(2092,1562,'bs','name','Federalni Zavod za geologiju'),(2093,1562,'en','name','The Federal Institute for Geology'),(2094,1563,'en','name','Rabin Medical Center'),(2095,1564,'en','name','Eiju General Hospital'),(2096,1564,'ja','name','永寿総合病院'),(2097,1565,'en','name','CARE Hospitals'),(2098,1566,'ar','name','المستشفى الجامعي بصفاقس'),(2099,1566,'fr','name','Hopital Universitaire Hedi Chaker'),(2100,1567,'en','name','Khyber Medical College'),(2101,1568,'pt','name','Escola Superior de Actividades Imobiliárias'),(2102,1569,'es','name','Hospital Pablo Tobon Uribe'),(2103,1570,'en','name','King Abdul Aziz University Hospital'),(2104,1571,'en','name','Addington Hospital'),(2105,1572,'en','name','Korle Bu Teaching Hospital'),(2106,1573,'en','name','University of Missouri–Kansas City'),(2107,1574,'en','name','University of Maryland Global Campus'),(2108,1575,'en','name','Arnot Ogden Medical Center'),(2109,1576,'en','name','Lanzhou Army General Hospital'),(2110,1576,'zh','name','陆军总院'),(2111,1577,'nl','name','Slotervaartziekenhuis'),(2112,1578,'en','name','Buffalo Medical Group'),(2113,1579,'en','name','Advanced Institute of Convergence Technology'),(2114,1579,'ko','name','차세대융합기술연구원'),(2115,1580,'en','name','Gorgan University of Agricultural Sciences and Natural Resources'),(2116,1580,'fa','name','دانشگاه علوم کشاورزی و منابع طبیعی گرگان'),(2117,1581,'en','name','Shizuoka University'),(2118,1581,'ja','name','静岡大学'),(2119,1582,'en','name','Meriter Hospital'),(2120,1583,'en','name','University of Oklahoma Medical Center'),(2121,1584,'en','name','Providence Sacred Heart Medical Center'),(2122,1585,'en','name','Joseph Eye Hospital'),(2123,1586,'en','name','Bayfront Medical Center'),(2124,1587,'en','name','The Alfred Hospital'),(2125,1588,'en','name','Eastern Command Hospital'),(2126,1589,'en','name','Kaiser Permanente Riverside Medical Center'),(2127,1590,'en','name','Mokwon University'),(2128,1590,'ko','name','목원대학교'),(2129,1591,'en','name','Nizam\'s Institute of Medical Sciences'),(2130,1592,'en','name','Atlanta University Center'),(2131,1593,'en','name','Canadian Foundation For The International Space University'),(2132,1594,'en','name','Lemuel Shattuck Hospital'),(2133,1595,'en','name','Kyushu Sangyo University'),(2134,1595,'ja','name','九州産業大学'),(2135,1596,'en','name','Jersey City Medical Center'),(2136,1597,'en','name','BongSeng Memorial Hospital'),(2137,1597,'ko','name','봉생병원입니다'),(2138,1598,'en','name','Astley Ainslie Hospital'),(2139,1599,'en','name','Katsushika Medical Center'),(2140,1599,'ja','name','葛飾医療センタ'),(2141,1600,'no_lang_code','name','Sir Ganga Ram Hospital'),(2142,1601,'no_lang_code','name','Microsoft (Netherlands)'),(2143,1602,'en','name','Annamalai University'),(2144,1602,'hi','name','अन्नामलाई विश्वविद्यालय'),(2145,1602,'ml','name','അണ്ണാമലൈ സർവകലാശാല'),(2146,1602,'pa','name','ਅੰਨਾਮਲਾਈ ਯੂਨੀਵਰਸਿਟੀ'),(2147,1602,'ta','name','அண்ணாமலைப் பல்கலைக்கழகம்'),(2148,1603,'en','name','Lee Memorial Health System'),(2149,1604,'en','name','Driscoll Children\'s Hospital'),(2150,1605,'en','name','Uzhhorod National University'),(2151,1605,'pl','name','Użhorodzki Uniwersytet Narodowy'),(2152,1605,'ru','name','Ужгородский национальный университет'),(2153,1605,'uk','name','Ужгородський національний університет'),(2154,1606,'en','name','Sangmyung University'),(2155,1606,'ko','name','상명대학교'),(2156,1607,'en','name','HealthONE Spalding Rehabilitation Hospital'),(2157,1608,'it','name','Ospedale di Santa Maria dei Battuti'),(2158,1609,'en','name','Children\'s & Women\'s Health Centre of British Columbia'),(2159,1610,'en','name','South Karelia Central Hospital'),(2160,1610,'fi','name','Etelä-Karjalan keskussairaala'),(2161,1611,'no_lang_code','name','Ension'),(2162,1612,'en','name','Cabrini Medical Center'),(2163,1613,'en','name','Flower Hospital'),(2164,1614,'en','name','Summa Akron City Hospital'),(2165,1615,'en','name','Southwest Washington Medical Center'),(2166,1616,'en','name','Iwata City Hospital'),(2167,1616,'ja','name','磐田市立総合病院'),(2168,1617,'en','name','Jamaica Hospital'),(2169,1618,'it','name','Azienda Ospedaliera San Gerardo'),(2170,1619,'en','name','Fitzgerald Health Education Associates'),(2171,1620,'en','name','Birmingham Dental Hospital'),(2172,1621,'ar','name','جامعة أم القرى'),(2173,1621,'en','name','Umm al-Qura University'),(2174,1622,'de','name','Universitäts-Augenklinik Bonn'),(2175,1623,'en','name','Health Promotion Board'),(2176,1623,'zh','name','新加坡保健促进局'),(2177,1624,'de','name','Schulthess-Klinik'),(2178,1625,'en','name','Woodruff Health Sciences Center'),(2179,1626,'en','name','Brandon Regional Health Authority'),(2180,1627,'en','name','Fortis Escorts Hospital'),(2181,1628,'en','name','Scarborough General Hospital'),(2182,1629,'de','name','Universitätsklinikum Bonn'),(2183,1629,'en','name','University Hospital Bonn'),(2184,1630,'en','name','Menninger Clinic'),(2185,1631,'en','name','Hasbro Children\'s Hospital'),(2186,1632,'en','name','Haywood Community Hospital'),(2187,1633,'en','name','Jaipur National University'),(2188,1634,'no_lang_code','name','Sahara Hospital'),(2189,1635,'en','name','Meenakshi Mission Hospital and Research Centre'),(2190,1636,'fr','name','Institut Laue-Langevin'),(2191,1637,'en','name','Northport VA Medical Center'),(2192,1638,'ar','name','جامعة طيبة'),(2193,1638,'en','name','Taibah University'),(2194,1639,'en','name','New York Blood Center'),(2195,1640,'ar','name','جامعة البلمند'),(2196,1640,'en','name','University of Balamand'),(2197,1640,'fr','name','Université de Balamand'),(2198,1641,'en','name','Kosair Children\'s Hospital'),(2199,1642,'en','name','National Institute of Nursing Research'),(2200,1643,'en','name','Islamic Azad University, Karaj, Karaj Islamic Azad University'),(2201,1643,'fa','name','دانشگاه آزاد اسلامی واحد کرج'),(2202,1644,'en','name','Southwestern Oklahoma State University'),(2203,1645,'bn','name','চট্টগ্রাম মেডিকেল কলেজ'),(2204,1645,'en','name','Chittagong Medical College'),(2205,1646,'en','name','Sarawak General Hospital'),(2206,1646,'ms','name','Hospital Umum Sarawak'),(2207,1647,'en','name','Conference Board Math Sciences'),(2208,1648,'en','name','University Hospital Complex Of Vigo'),(2209,1649,'en','name','Dundee Dental Hospital'),(2210,1650,'en','name','Royal Liverpool University Hospital'),(2211,1651,'en','name','Kunming General Hospital of Chengdu Military Command'),(2212,1651,'zh','name','成都军区昆明总医院'),(2213,1652,'en','name','Catalyst Health Economics Consultants Ltd'),(2214,1653,'en','name','Sherman Hospital'),(2215,1654,'en','name','National University of Luján'),(2216,1654,'es','name','Universidad Nacional de Luján'),(2217,1655,'en','name','Bemidji State University'),(2218,1656,'en','name','Fulbourn Hospital'),(2219,1657,'el','name','Γενικό Νοσοκομείο Ιωαννίνων \"Γ. Χατζηκώστα\"'),(2220,1657,'no_lang_code','name','General Hospital of Ioannina G. Hatzikosta'),(2221,1658,'es','name','Hospital San Pedro de Alcántara'),(2222,1659,'no_lang_code','name','Ecofys (Netherlands)'),(2223,1660,'en','name','Kuban State University'),(2224,1660,'ru','name','Кубанский государственный университет'),(2225,1661,'en','name','Baqiyatallah University of Medical Sciences'),(2226,1661,'fa','name','دانشگاه علوم پزشکی بقیةالله'),(2227,1662,'ja','name','九段坂病院'),(2228,1662,'no_lang_code','name','Kudanzaka Hospital'),(2229,1663,'en','name','Bnai Zion Medical Center'),(2230,1663,'he','name','מרכז רפואי בני ציון'),(2231,1664,'en','name','Queen Victoria Hospital'),(2232,1665,'en','name','University Clinic of Pulmonary and Allergic Diseases Golnik'),(2233,1666,'en','name','Kanagawa Rehabilitation Hospital'),(2234,1666,'ja','name','神奈川リハビリテーション病院'),(2235,1667,'en','name','Wingate University'),(2236,1668,'es','name','Hospital Central de la Cruz Roja San José y Santa Adela'),(2237,1669,'en','name','Chung Hua University'),(2238,1670,'en','name','Hubei Polytechnic University'),(2239,1670,'zh','name','湖北理工学院'),(2240,1671,'en','name','Shriners Hospitals for Children - Canada'),(2241,1672,'en','name','Schneider Children\'s Medical Center'),(2242,1673,'en','name','Seoul National University Hospital'),(2243,1673,'ko','name','서울대학교병원'),(2244,1674,'en','name','Scripps Clinic Medical Group'),(2245,1675,'tr','name','Diyarbakır Askeri Hastanesi'),(2246,1676,'fr','name','Adi Valor'),(2247,1677,'en','name','International Center for Public Health'),(2248,1678,'en','name','Okazaki City Hospital'),(2249,1678,'ja','name','岡崎市民病院'),(2250,1679,'en','name','Lagos State University'),(2251,1679,'yo','name','Yunifásítì Ìpínlẹ̀ Èkó'),(2252,1680,'fi','name','Keski-Satakunnan Terveydenhuollon kuntayhtymä'),(2253,1681,'en','name','Meenakshi Ammal Dental College and Hospital'),(2254,1682,'en','name','Royal South Hants Hospital'),(2255,1683,'ja','name','古賀病院'),(2256,1683,'no_lang_code','name','Koga Hospital'),(2257,1684,'en','name','Louisville VA Medical Center'),(2258,1685,'en','name','Government Rajaji Hospital'),(2259,1686,'en','name','National Taiwan Sport University'),(2260,1687,'en','name','Mount Sinai Hospital'),(2261,1687,'es','name','Hospital Monte Sinaí'),(2262,1688,'it','name','Ospedale Santa Maria Annunziata'),(2263,1689,'fi','name','Forssan Seudun Terveydenhuollon Kuntayhtymä'),(2264,1690,'en','name','Research Medical Center'),(2265,1691,'en','name','Daegu University'),(2266,1691,'ko','name','대구대학교'),(2267,1692,'en','name','Kyung Hee University'),(2268,1692,'ko','name','경희대학교'),(2269,1693,'no_lang_code','name','Caritas Medical Centre'),(2270,1693,'zh','name','明愛醫院'),(2271,1694,'en','name','Colorado Center For Hospice and Palliative Care'),(2272,1695,'en','name','Chosun University'),(2273,1695,'ko','name','조선대학교'),(2274,1696,'en','name','Auckland University of Technology'),(2275,1697,'en','name','Athens State University'),(2276,1697,'fr','name','Université d\'État d\'athens'),(2277,1698,'en','name','Inje University Ilsan Paik Hospital'),(2278,1698,'ko','name','인제 대학교 일산 백병원'),(2279,1699,'en','name','Harvard Pilgrim Health Care'),(2280,1700,'en','name','North Tyneside General Hospital'),(2281,1701,'el','name','401 Γενικό Στρατιωτικό Νοσοκομείο Αθηνών'),(2282,1701,'en','name','401 General Military Hospital of Athens'),(2283,1702,'en','name','Musgrave Park Hospital'),(2284,1703,'de','name','Papiertechnische Stiftung'),(2285,1704,'en','name','Federation of American Hospitals'),(2286,1705,'hr','name','Opća bolnica Karlovac'),(2287,1706,'en','name','Institute For European Environmental Policy'),(2288,1707,'en','name','Lowell Observatory'),(2289,1708,'no_lang_code','name','Mirus Bio (United States)'),(2290,1709,'en','name','Canadian Mathematical Society'),(2291,1710,'en','name','Rajendra Memorial Research Institute of Medical Sciences'),(2292,1711,'he','name','בית חולים הרצוג'),(2293,1711,'no_lang_code','name','Herzog Hospital'),(2294,1712,'en','name','Integrated Laboratory Systems, Inc.'),(2295,1713,'en','name','Tbilisi State Medical University'),(2296,1713,'hy','name','Թբիլիսիի պետական բժշկական համալսարան'),(2297,1713,'ka','name','თბილისის სახელმწიფო სამედიცინო უნივერსიტეტი'),(2298,1714,'en','name','Foundation University Medical College'),(2299,1715,'en','name','Autonomous Operator of Parisian Transports'),(2300,1715,'no_lang_code','name','Régie Autonome des Transports Parisiens (France)'),(2301,1716,'no_lang_code','name','Information Management Services'),(2302,1717,'en','name','Bexar County Medical Examiner\'s Office'),(2303,1718,'pt','name','Instituto Superior de Ciências da Administração'),(2304,1719,'en','name','University of Bangui'),(2305,1719,'fr','name','Université de Bangui'),(2306,1720,'no_lang_code','name','DuPont (Canada)'),(2307,1721,'fr','name','Centre Hospitalier Universitaire de Sherbrooke'),(2308,1722,'tr','name','Konya Eğitim ve Araştırma Hastanesi'),(2309,1723,'no_lang_code','name','Envirogen (United States)'),(2310,1724,'en','name','Satakunta Central Hospital'),(2311,1725,'en','name','Sheba Medical Center'),(2312,1726,'en','name','Aomori University of Health and Welfare'),(2313,1726,'ja','name','青森県立保健大学'),(2314,1727,'en','name','Roosevelt University'),(2315,1728,'en','name','Huron Hospital'),(2316,1729,'de','name','Studienzentrum für Kernenergie'),(2317,1729,'en','name','Belgian Nuclear Research Centre'),(2318,1729,'fr','name','Centre d\'Étude de l\'énergie Nucléaire'),(2319,1729,'nl','name','Studiecentrum voor Kernenergie'),(2320,1730,'it','name','Azienda Ospedaliero Universitaria Ospedali Riuniti'),(2321,1731,'en','name','Middlebury College'),(2322,1732,'pt','name','Escola do Serviço de Saúde Militar'),(2323,1733,'fr','name','Hôpital Saint-André'),(2324,1734,'en','name','Rush Children\'s Hospital'),(2325,1735,'en','name','Decision Research'),(2326,1736,'fr','name','Hôpital Saint Joseph'),(2327,1737,'en','name','New York City College of Technology'),(2328,1738,'bn','name','ডাঃ আর আহমেদ ডেন্টাল কলেজ ও হাসপাতাল'),(2329,1738,'en','name','Dr. R. Ahmed Dental College and Hospital'),(2330,1739,'ja','name','名鉄病院'),(2331,1739,'no_lang_code','name','Meitetsu Hospital'),(2332,1740,'da','name','Regionshospitalet Horsens'),(2333,1740,'en','name','Regional Hospital Horsens'),(2334,1741,'ar','name','جامعة الكويت'),(2335,1741,'en','name','Kuwait University'),(2336,1742,'it','name','Azienda Ospedaliera S.Giuseppe Moscati'),(2337,1743,'en','name','Long Beach Memorial Medical Center'),(2338,1744,'ja','name','宝ホールディングス株式会社'),(2339,1744,'no_lang_code','name','Takara (Japan)'),(2340,1745,'bn','name','কলকাতা মেডিক্যাল কলেজ ও হাসপাতাল'),(2341,1745,'en','name','Medical College and Hospital, Kolkata'),(2342,1745,'hi','name','कलकत्ता मेडिकल कॉलेज'),(2343,1746,'no_lang_code','name','Physical Sciences (United States)'),(2344,1747,'ca','name','Hospital Sant Pau i Santa Tecla'),(2345,1748,'fr','name','Hôpital Fontmaure'),(2346,1749,'no_lang_code','name','Qi2'),(2347,1750,'en','name','Kirwan Health Campus'),(2348,1751,'en','name','Norfolk and Norwich University Hospital'),(2349,1752,'en','name','Evans Army Community Hospital'),(2350,1753,'en','name','National Kyushu Medical Center'),(2351,1753,'ja','name','国立病院機構 九州医療センター'),(2352,1754,'it','name','Ospedaliero Sirai'),(2353,1755,'en','name','Probity Medical Research'),(2354,1756,'en','name','Eugene Applebaum College of Pharmacy and Health Sciences'),(2355,1757,'en','name','Mahatma Gandhi Memorial Medical College'),(2356,1758,'no_lang_code','name','Sociometrics Corporation'),(2357,1759,'en','name','KK Women\'s and Children\'s Hospital'),(2358,1760,'en','name','Massachusetts Mental Health Center'),(2359,1761,'ja','name','いわき共立総合病院'),(2360,1761,'no_lang_code','name','Iwaki Kyoritsu General Hospital'),(2361,1762,'en','name','Prince of Wales Hospital'),(2362,1763,'de','name','Bundesforschungsinstitut für Kulturpflanzen, Julius Kühn-Institut'),(2363,1763,'en','name','Federal Research Centre for Cultivated Plants'),(2364,1764,'en','name','National Animal Husbandry Service'),(2365,1764,'zh','name','全国畜牧总站'),(2366,1765,'en','name','de Duve Institute'),(2367,1765,'fr','name','L\'Institut de Duve'),(2368,1765,'nl','name','De Duve Instituut'),(2369,1766,'en','name','Louisiana State University System'),(2370,1767,'en','name','Kanagawa Children\'s Medical Center'),(2371,1767,'ja','name','神奈川県立こども医療センター'),(2372,1768,'en','name','Kamuzu Central Hospital'),(2373,1768,'es','name','Hospital central de Kamuzu'),(2374,1769,'en','name','Dallas Diabetes Research Center'),(2375,1770,'no_lang_code','name','Taylor Wimpey (United Kingdom)'),(2376,1771,'en','name','Nishi Eye Hospital'),(2377,1771,'ja','name','西眼科病院'),(2378,1772,'en','name','Japanese Red Cross Fukuoka Hospital'),(2379,1772,'ja','name','福岡赤十字病院'),(2380,1773,'en','name','Melbourne Centre for Nanofabrication'),(2381,1774,'en','name','Brenau University'),(2382,1775,'no_lang_code','name','Trojan Technologies (Canada)'),(2383,1776,'en','name','National Brain Research Centre'),(2384,1776,'hi','name','राष्ट्रीय मस्तिष्क अनुसंधान केंद्र, मानेसर, हरियाणा'),(2385,1777,'el','name','Ανδρέας Συγγρός Νοσοκομείο'),(2386,1777,'en','name','Andreas Sygros Hospital'),(2387,1778,'fr','name','Hôpital Orthopédique de la Suisse Romande'),(2388,1779,'en','name','Centre for Technical Research and Studies'),(2389,1779,'es','name','Centro de Estudios e Investigaciones Técnicas de Gipuzkoa'),(2390,1780,'no_lang_code','name','Microbiotix (United States)'),(2391,1781,'pt','name','Hospital Universitário Evangélico de Curitiba'),(2392,1782,'en','name','University College Hospital, Ibadan'),(2393,1783,'ar','name','مستشفى جامعة الملك فيصل'),(2394,1783,'en','name','King Fahd Hospital of the University'),(2395,1784,'en','name','Lenox Hill Hospital'),(2396,1785,'en','name','Lake Regional Hospital'),(2397,1786,'es','name','Hospital de l\'Esperança'),(2398,1787,'en','name','Raja Ramanna Centre for Advanced Technology'),(2399,1787,'hi','name','राजा रामन्ना प्रगत प्रौद्योगिकी केन्द्र'),(2400,1787,'ml','name','രാജാ രാമണ്ണ സെന്റർ ഫോർ അഡ്വാൻസ്ഡ് ടെക്നോളജി'),(2401,1787,'mr','name','राजा रामण्णा अत्याधुनिक तंत्रज्ञान केंद्र'),(2402,1788,'en','name','Rajavithi Hospital'),(2403,1789,'en','name','Institute for Theoretical and Experimental Physics'),(2404,1789,'ru','name','Институт теоретической и экспериментальной физики'),(2405,1790,'en','name','Saint Petersburg State Electrotechnical University'),(2406,1790,'ru','name','Санкт-Петербургский государственный электротехнический университет'),(2407,1791,'en','name','Center for Epidemiology and Animal Health'),(2408,1792,'en','name','Madrid Health Service'),(2409,1792,'es','name','Servicio Madrileño de Salud'),(2410,1793,'no_lang_code','name','DNA Link (South Korea)'),(2411,1794,'en','name','Colchester Hospital'),(2412,1795,'en','name','Güven Hospital'),(2413,1795,'tr','name','Güven Hastanesi'),(2414,1796,'en','name','East Georgia State College'),(2415,1797,'en','name','Memorial Hospital'),(2416,1798,'en','name','National Institute for Agro-Environmental Sciences'),(2417,1798,'ja','name','農業環境変動研究センター'),(2418,1799,'en','name','Istanbul Bilim University'),(2419,1799,'tr','name','İstanbul Bilim Üniversitesi'),(2420,1800,'es','name','Hospital Santiago Apostol'),(2421,1801,'en','name','Central Queensland University'),(2422,1802,'en','name','Ignatius Hospital'),(2423,1802,'nl','name','Sint Ignatiusziekenhuis'),(2424,1803,'en','name','DeKalb Medical Center'),(2425,1804,'en','name','Enterprise Ireland'),(2426,1805,'en','name','St Petersburg University'),(2427,1805,'ru','name','Санкт-Петербургский государственный университет'),(2428,1806,'en','name','Belfast City Hospital'),(2429,1807,'en','name','National Center of Hygiene Medical Ecology and Nutrition'),(2430,1808,'fr','name','Polyclinique de Bordeaux-Tondu'),(2431,1809,'en','name','Gomal University'),(2432,1809,'ur','name','جامعہ گومل'),(2433,1810,'en','name','University of Minnesota, Waseca'),(2434,1811,'en','name','Birmingham VA Medical Center'),(2435,1812,'no_lang_code','name','Unilever (Netherlands)'),(2436,1813,'en','name','Queen Astrid Military Hospital'),(2437,1813,'nl','name','Militair Hospitaal Koningin Astrid'),(2438,1814,'en','name','Adler Planetarium'),(2439,1815,'en','name','Institute for Computer Science and Control'),(2440,1815,'hu','name','Magyar Tudományos Akadémia Számítástechnikai és Automatizálási Kutatóintézete'),(2441,1816,'en','name','Federal Agency for Health and Social Development'),(2442,1816,'ru','name','Федеральное агентство по здравоохранению и социальному развитию'),(2443,1817,'en','name','Casa Colina Centers for Rehabilitation'),(2444,1818,'en','name','Sharif University of Technology'),(2445,1818,'fa','name','دانشگاه صنعتی شریف'),(2446,1819,'fr','name','Centre Hospitalier Philippe Pinel'),(2447,1820,'no_lang_code','name','Social and Scientific Systems (United States)'),(2448,1821,'en','name','Saint Barnabas Medical Center'),(2449,1822,'en','name','Armed Forces Hospital'),(2450,1823,'en','name','St. John\'s Hospital'),(2451,1823,'hu','name','Szent János Kórház'),(2452,1824,'en','name','Hacettepe University Hospital'),(2453,1825,'en','name','Kansai Rosai Hospital'),(2454,1825,'ja','name','関西ろうさい病院'),(2455,1826,'no_lang_code','name','ArcelorMittal (France)'),(2456,1827,'en','name','Nashville VA Medical Center'),(2457,1828,'en','name','Tottori University'),(2458,1828,'ja','name','鳥取大学'),(2459,1829,'en','name','Sisters of Mercy Health System'),(2460,1830,'en','name','Hunan Cancer Hospital'),(2461,1831,'en','name','Saurashtra University'),(2462,1832,'no_lang_code','name','Starks Associates'),(2463,1833,'en','name','European Synchrotron Radiation Facility'),(2464,1834,'en','name','Islamic Azad University, Arak'),(2465,1834,'fa','name','دانشگاه آزاد اسلامی واحد اراک'),(2466,1835,'es','name','Hospital de Galdakao'),(2467,1836,'en','name','Imo State University'),(2468,1836,'yo','name','Yunifásítì Ìpínlẹ̀ Ímò'),(2469,1837,'en','name','University Hospital Coventry'),(2470,1838,'en','name','Kansas Department of Health and Environment'),(2471,1839,'en','name','Rajendra Institute of Medical Sciences'),(2472,1840,'en','name','The Military General Hospital of Beijing PLA'),(2473,1840,'zh','name','中国人民解放军空军总医院'),(2474,1841,'ja','name','川崎市立川崎病院'),(2475,1841,'no_lang_code','name','Kawasaki Municipal Hospital'),(2476,1842,'en','name','Marshfield Clinic'),(2477,1843,'en','name','Children\'s Hospital of Zhejiang University'),(2478,1844,'ko','name','건국대학교'),(2479,1844,'no_lang_code','name','Konkuk University'),(2480,1845,'en','name','Ripon College'),(2481,1846,'en','name','Ho Chi Minh City Medicine and Pharmacy University'),(2482,1846,'fr','name','Université de pharmacie et médecine d\'hô-chi-minh-ville'),(2483,1846,'vi','name','Trường Đại học Y Dược Thành phố Hồ Chí Minh'),(2484,1847,'en','name','Adelphi University'),(2485,1848,'no_lang_code','name','Canadian Natural Resources'),(2486,1849,'en','name','George Eliot Hospital'),(2487,1850,'es','name','Hospital General Dr. Manuel Gea Gonzalez'),(2488,1851,'fr','name','Centre Hospitalier et Universitaire de Brazzaville'),(2489,1852,'en','name','Queen Elizabeth Central Hospital'),(2490,1853,'en','name','MRC Unit the Gambia'),(2491,1854,'en','name','Oregon Social Learning Center'),(2492,1855,'en','name','Public Health Ontario'),(2493,1855,'fr','name','Santé publique Ontario'),(2494,1856,'no_lang_code','name','NuroRestore (United States)'),(2495,1857,'en','name','Chaudhary Charan Singh Haryana Agricultural University'),(2496,1857,'hi','name','चौधरी चरण सिंह हरियाणा कृषि विश्वविद्यालय'),(2497,1857,'ta','name','சௌதரி சரண் சிங் அரியானா வேளாண்மை பல்கலைக்கழகம்'),(2498,1858,'en','name','National Research Mordovia State University'),(2499,1858,'ru','name','Мордовский государственный университет имени Н. П. Огарёва'),(2500,1859,'no_lang_code','name','PTV Group (Germany)'),(2501,1860,'en','name','Spalding University'),(2502,1861,'en','name','Royal Aberdeen Children\'s Hospital'),(2503,1862,'no_lang_code','name','Safdarjang Hospital'),(2504,1863,'en','name','St. Mary\'s Hospital'),(2505,1864,'es','name','Hospital Angeles Pedregal'),(2506,1865,'en','name','Government Medical College'),(2507,1866,'en','name','Union for International Cancer Control'),(2508,1866,'fr','name','Union internationale contre le cancer'),(2509,1867,'en','name','Federal Medical Centre'),(2510,1868,'en','name','Affiliated Hospital of Qingdao University'),(2511,1869,'en','name','Maryknoll Medical Center'),(2512,1869,'ko','name','메리놀병원'),(2513,1870,'en','name','Chongqing Academy of Animal Science'),(2514,1870,'zh','name','重庆市畜牧科学院'),(2515,1871,'en','name','Cohen Children\'s Medical Center'),(2516,1872,'en','name','Memorial Health University Medical Center'),(2517,1873,'tr','name','Zekai Tahir Burak Kadın Sağlığı Eğitim ve Araştırma Hastanesi'),(2518,1874,'ja','name','福山市民病院'),(2519,1874,'no_lang_code','name','Fukuyama City Hospital'),(2520,1875,'en','name','West Virginia State Department of Health and Human Resources'),(2521,1876,'en','name','Solapur University'),(2522,1876,'mr','name','सोलापूर विद्यापीठ'),(2523,1877,'en','name','National Interuniversity Consortium for the Physical Sciences of Matter'),(2524,1878,'en','name','Royal Cornwall Hospital Trust'),(2525,1879,'no_lang_code','name','Assaf Harofeh Medical Center'),(2526,1880,'en','name','Aurora University'),(2527,1881,'en','name','Douglass Hanly Moir Pathology'),(2528,1882,'en','name','University of Tennessee Medical Center'),(2529,1883,'no_lang_code','name','Emergent BioSolutions (United States)'),(2530,1884,'en','name','Dr. Ram Manohar Lohia Avadh University'),(2531,1884,'hi','name','डॉ राम मनोहर लोहिया अवध विश्वविद्यालय'),(2532,1885,'no_lang_code','name','Kema International (Netherlands)'),(2533,1886,'en','name','Bethesda Hospital East'),(2534,1887,'tr','name','Özel Ortadoğu 19 Mayıs Hastanesi'),(2535,1888,'en','name','Shimonoseki City Hospital'),(2536,1888,'ja','name','下関市立市民病院'),(2537,1889,'no_lang_code','name','Emmes (United States)'),(2538,1890,'en','name','Inje University Sanggye Paik Hospital'),(2539,1891,'de','name','Institut Universitaire Kurt Bösch'),(2540,1892,'ja','name','椙山女学園大学'),(2541,1892,'no_lang_code','name','Sugiyama Jogakuen University'),(2542,1893,'no_lang_code','name','INRAD (United States)'),(2543,1894,'no_lang_code','name','S&N (Germany)'),(2544,1895,'en','name','Alexandra Hospital'),(2545,1896,'en','name','Salford Royal Hospital'),(2546,1897,'no_lang_code','name','Radiation Monitoring Devices (United States)'),(2547,1898,'en','name','Miller Children\'s & Women\'s Hospital'),(2548,1899,'en','name','Eastern Maine Medical Center'),(2549,1900,'no_lang_code','name','CAS Software (Germany)'),(2550,1901,'en','name','El Paso County Public Health'),(2551,1902,'hr','name','Klinički Bolnički Centar Rijeka'),(2552,1903,'en','name','Mother Teresa Hospital'),(2553,1903,'sq','name','Qendra Spitalore Universitare Nene Tereza'),(2554,1904,'no_lang_code','name','Prapokklao Hospital'),(2555,1904,'th','name','โรงพยาบาลพระปกเกล้า'),(2556,1905,'en','name','Pusan National University Hospital'),(2557,1906,'en','name','Prince of Wales Hospital'),(2558,1907,'bs','name','Univerzitet u Banja Luci'),(2559,1907,'no_lang_code','name','University of Banja Luka'),(2560,1907,'sr','name','Универзитет у Бањој Луци'),(2561,1908,'en','name','Children\'s Hospital of Orange County'),(2562,1909,'en','name','Chia Nan University of Pharmacy and Science'),(2563,1910,'en','name','Anne Arundel Medical Center'),(2564,1911,'en','name','Behavioral Tech Research, Inc.'),(2565,1912,'en','name','American Red Cross'),(2566,1912,'es','name','Cruz Roja Americana'),(2567,1912,'fr','name','Croix-rouge américaine'),(2568,1913,'fr','name','Cité Internationale Universitaire de Paris'),(2569,1914,'nl','name','De Wever-Ziekenhuis'),(2570,1915,'en','name','NTT Medical Center'),(2571,1915,'ja','name','NTT東日本関東病院'),(2572,1916,'en','name','Shaoguan University'),(2573,1916,'zh','name','韶关学院'),(2574,1917,'no_lang_code','name','Siemens (United Kingdom)'),(2575,1918,'no_lang_code','name','Sequella (United States)'),(2576,1919,'en','name','Institute of Development Studies'),(2577,1920,'es','name','Hospital El Bierzo'),(2578,1921,'en','name','Dairy Farmers Of Canada'),(2579,1922,'en','name','Kaiser Permanente Center for Health Research'),(2580,1923,'de','name','Universitätsklinikum Leipzig'),(2581,1923,'en','name','University Hospital Leipzig'),(2582,1924,'de','name','Österreichische Forschungsförderungsgesellschaft'),(2583,1924,'en','name','Austrian Research Promotion Agency'),(2584,1925,'ar','name','جامعة آل البيت'),(2585,1925,'en','name','Al al-Bayt University'),(2586,1926,'it','name','Ospedale Koelliker'),(2587,1927,'en','name','Multnomah County Health Department'),(2588,1928,'en','name','Affiliated Hospital of Jiangxi College of TCM'),(2589,1928,'zh','name','江西中医学院附属医院'),(2590,1929,'en','name','Temple University Hospital'),(2591,1930,'no_lang_code','name','PotashCorp (Canada)'),(2592,1931,'no_lang_code','name','Vattenfall (Sweden)'),(2593,1932,'en','name','East Surrey Hospital'),(2594,1933,'en','name','Kyoto Prefectural University of Medicine'),(2595,1933,'ja','name','京都府立医科大学'),(2596,1934,'en','name','Albert Schweitzer Hospital'),(2597,1934,'fr','name','Hôpital albert-schweitzer'),(2598,1935,'en','name','Hospital of the University of Pennsylvania'),(2599,1936,'en','name','Asahikawa City Hospital'),(2600,1936,'ja','name','市立旭川病院'),(2601,1937,'en','name','University of Santo Tomas Hospital'),(2602,1938,'en','name','NC Department of Health and Human Services'),(2603,1939,'en','name','Laconia Women\'s Health Center'),(2604,1940,'en','name','St. Barnabas Hospital'),(2605,1941,'no_lang_code','name','WNET (United States)'),(2606,1942,'en','name','JA Toride Medical Center'),(2607,1942,'ja','name','JAとりで総合医療センター'),(2608,1943,'en','name','Kaiser Permanente San Rafael Medical Center'),(2609,1944,'en','name','University of Central Arkansas'),(2610,1945,'en','name','Kijabe Hospital'),(2611,1946,'en','name','Resurrection Medical Center'),(2612,1947,'en','name','Alaska Native Tribal Health Consortium'),(2613,1948,'en','name','Canadian Science Centre for Human and Animal Health'),(2614,1949,'en','name','Semnan University'),(2615,1949,'fa','name','دانشگاه سمنان'),(2616,1950,'en','name','Dunedin Public Hospital'),(2617,1951,'en','name','Medical Society of Delaware'),(2618,1952,'en','name','Alexandra Hospital'),(2619,1953,'en','name','Rappaport Family Institute for Research in the Medical Sciences'),(2620,1954,'en','name','Troy University'),(2621,1955,'en','name','Perm State University'),(2622,1955,'ru','name','Пермский государственный университет'),(2623,1956,'en','name','Levanger Hospital'),(2624,1956,'no','name','Sykehuset Levanger'),(2625,1957,'en','name','Federal Medical Centre'),(2626,1958,'en','name','Cairns Hospital'),(2627,1959,'no_lang_code','name','Xenon Pharmaceuticals (Canada)'),(2628,1960,'en','name','St. Vincent\'s University Hospital'),(2629,1961,'en','name','Regina General Hospital'),(2630,1962,'en','name','Our Lady of the Lake University'),(2631,1963,'en','name','Sichuan Cancer Hospital'),(2632,1963,'zh','name','四川省肿瘤研究所'),(2633,1964,'en','name','Regina Qu\'Appelle Health Region'),(2634,1965,'en','name','Blackburn College'),(2635,1966,'en','name','Nagoya Memorial Hospital'),(2636,1966,'ja','name','名古屋記念病院'),(2637,1967,'en','name','Health Services Academy'),(2638,1968,'es','name','Hospital Universitario HM Madrid'),(2639,1969,'ar','name','جامعة هولير الطبية'),(2640,1969,'en','name','Hawler Medical University'),(2641,1970,'fr','name','Université pontificale catholique de goiás'),(2642,1970,'pt','name','Pontifícia Universidade Católica de Goiás'),(2643,1971,'en','name','The People\'s Hospital of Guangxi Zhuang Autonomous Region'),(2644,1971,'zh','name','广西壮族自治区人民医院'),(2645,1972,'cy','name','Ysbyty Singleton'),(2646,1972,'en','name','Singleton Hospital'),(2647,1973,'no_lang_code','name','Doty Scientific (United States)'),(2648,1974,'en','name','Nagoya City University Hospital'),(2649,1974,'ja','name','名古屋市立大学病院'),(2650,1975,'pt','name','IADE Superior de Marketing e Publicidade'),(2651,1976,'bn','name','যাদবপুর বিশ্ববিদ্যালয়'),(2652,1976,'en','name','Jadavpur University'),(2653,1976,'fr','name','Université jadavpur'),(2654,1976,'gu','name','જાદવપુર યુનિવર્સિટી'),(2655,1976,'hi','name','यादवपुर विश्वविद्यालय'),(2656,1976,'kn','name','ಜಾದವ್ ಪುರ ವಿಶ್ವವಿದ್ಯಾಲಯ'),(2657,1976,'pa','name','ਜਾਦਵਪੁਰ ਯੂਨੀਵਰਸਿਟੀ'),(2658,1976,'te','name','జాదవ్ పూర్ విశ్వవిద్యాలయం'),(2659,1977,'en','name','Karachi Medical and Dental College'),(2660,1978,'en','name','Biomedical Primate Research Centre'),(2661,1979,'en','name','St. Luke\'s Hospital'),(2662,1980,'en','name','Emory University Hospital Midtown'),(2663,1981,'en','name','Trimbos Institute'),(2664,1981,'nl','name','Trimbos instituut'),(2665,1982,'ar','name','شبكة الجامعات المصرية'),(2666,1982,'en','name','Egyptian Universities Network'),(2667,1983,'no_lang_code','name','Dassault Aviation (France)'),(2668,1984,'en','name','Australian Centre for Disease Preparedness'),(2669,1985,'en','name','Sarasota Memorial Hospital'),(2670,1986,'es','name','Hospital Rio Carrion'),(2671,1987,'no_lang_code','name','Barkatullah University'),(2672,1988,'en','name','University of Health Sciences Vientiane'),(2673,1988,'lo','name','ມະຫາວິທະຍາໄລ ວິທະຍາສາດ ສຸຂະພາບ'),(2674,1989,'de','name','Universitäres Cancer Center Hamburg'),(2675,1989,'en','name','University Cancer Center Hamburg'),(2676,1990,'en','name','Wilberforce University'),(2677,1990,'fr','name','Université de wilberforce'),(2678,1991,'it','name','Ospedale Santa Maria'),(2679,1992,'en','name','Abbasi Shaheed Hospital'),(2680,1992,'ur','name','عباسی شهيد ہسپتال'),(2681,1993,'pt','name','Instituto Superior de Ciências da Informação e da Administração'),(2682,1994,'en','name','American Anthropological Association'),(2683,1995,'no_lang_code','name','Foxconn (Japan)'),(2684,1996,'en','name','La Salle University'),(2685,1996,'es','name','Universidad de la Salle'),(2686,1996,'fr','name','Université la Salle'),(2687,1997,'en','name','Regions Hospital'),(2688,1998,'en','name','Alaska Native Medical Center'),(2689,1999,'es','name','Hospital Virgen de la Concha'),(2690,2000,'en','name','River Oaks Hospital'),(2691,2001,'en','name','National Defense Medical Center'),(2692,2002,'en','name','First Affiliated Hospital of Shantou University Medical College'),(2693,2002,'zh','name','汕头大学医学院第一附属医院'),(2694,2003,'en','name','Jerry L. Pettis Memorial VA Medical Center'),(2695,2004,'en','name','Oklahoma City University'),(2696,2005,'it','name','Ospedale “M. Bufalini” di Cesena'),(2697,2006,'en','name','Academia Nacional Superior de Orquestra'),(2698,2007,'en','name','Knoxville College'),(2699,2008,'en','name','Kobe Rosai Hospital'),(2700,2008,'ja','name','神戸労災病院'),(2701,2009,'en','name','Community Regional Medical Center'),(2702,2010,'no_lang_code','name','Hiram College'),(2703,2011,'en','name','Kaiser Permanente Redwood City Medical Center'),(2704,2012,'en','name','Chengde Medical University'),(2705,2012,'zh','name','承德医学院'),(2706,2013,'en','name','Magee Rehabilitation Hospital'),(2707,2014,'en','name','Royal Inland Hospital'),(2708,2015,'en','name','University of Ulsan'),(2709,2015,'ko','name','울산대학교'),(2710,2016,'en','name','James J. Peters VA Medical Center'),(2711,2017,'el','name','Περιφερειακό Γενικό Νοσοκομείο - Μαιευτήριο - \"ΕΛΕΝΑ ΒΕΝΙΖΕΛΟΥ\"'),(2712,2017,'en','name','General-Maternity District Hospital Helena Venizelou'),(2713,2018,'no_lang_code','name','ArcelorMittal (Canada)'),(2714,2019,'en','name','Fuzhou Dermatosis Prevention Hospital'),(2715,2019,'zh','name','福州市皮肤病防治院'),(2716,2020,'es','name','Hospital Nacional Dos de Mayo'),(2717,2021,'fr','name','Hôpital Debrousse'),(2718,2022,'no_lang_code','name','Proportional Technologies'),(2719,2023,'en','name','Prince Charles Hospital'),(2720,2024,'en','name','Mississippi State Medical Association'),(2721,2025,'pt','name','Hospital Pulido Valente'),(2722,2026,'it','name','Azienda Ospedaliera Santa Maria Degli Angeli'),(2723,2027,'da','name','Regionshospitalet Herning'),(2724,2027,'en','name','Herning Regional Hospital'),(2725,2028,'en','name','Raritan Bay Medical Center'),(2726,2029,'en','name','Kerala Institute of Medical Sciences'),(2727,2030,'el','name','424 Γενικό Στρατιωτικό Νοσοκομείο Θεσσαλονίκης'),(2728,2030,'en','name','424 General Military Hospital'),(2729,2031,'en','name','Counties Manukau District Health Board'),(2730,2032,'no_lang_code','name','INRA Transfert (France)'),(2731,2033,'en','name','Nottingham General Hospital'),(2732,2034,'en','name','Singapore Eye Research Institute'),(2733,2035,'en','name','Busan Medical Center'),(2734,2035,'ko','name','부산의료원'),(2735,2036,'no_lang_code','name','Network Rail'),(2736,2037,'en','name','John Brown University'),(2737,2038,'en','name','Ishikawa Prefectural Central Hospital'),(2738,2038,'ja','name','石川県立中央病院'),(2739,2039,'en','name','Carmel Medical Center'),(2740,2040,'en','name','SUNY Korea'),(2741,2040,'ko','name','한국뉴욕주립대학교'),(2742,2041,'en','name','Positive University'),(2743,2041,'pt','name','Universidade Positivo'),(2744,2042,'de','name','UMIT - Private Universität für Gesundheitswissenschaften, Medizinische Informatik und Technik'),(2745,2043,'en','name','Silpakorn University'),(2746,2043,'th','name','มหาวิทยาลัยศิลปากร'),(2747,2044,'tr','name','Dokuz Eylül Üniversitesi Hastanesi'),(2748,2045,'no_lang_code','name','Medical Physics Consultants'),(2749,2046,'en','name','St Francis Medical Center'),(2750,2047,'en','name','University Mental Health Research Institute'),(2751,2048,'en','name','Sarojini Naidu Medical College'),(2752,2048,'hi','name','सरोजिनी नायडू चिकित्सा महाविद्यालय'),(2753,2049,'it','name','Consorzio Milano Ricerche'),(2754,2050,'en','name','University of South Carolina Aiken'),(2755,2051,'pt','name','Hospital São Teotónio'),(2756,2052,'en','name','Central Texas Veterans Health Care System'),(2757,2053,'no_lang_code','name','Bridgepoint (United Kingdom)'),(2758,2054,'en','name','Southwest Baptist University'),(2759,2055,'no_lang_code','name','Numerical Mechanics Applications International (Belgium)'),(2760,2056,'en','name','Institute for Scientific Analysis'),(2761,2057,'en','name','Providence St. Vincent Medical Center'),(2762,2058,'en','name','Cornwall Regional Hospital'),(2763,2059,'en','name','East Kent Hospitals University NHS Foundation Trust'),(2764,2060,'en','name','Medical Radiological Research Center'),(2765,2060,'ru','name','Медицинский радиологический научный центр'),(2766,2061,'en','name','Laiko General Hospital of Athens'),(2767,2062,'no_lang_code','name','Bio Chem Analysis Corporation (United States)'),(2768,2063,'en','name','Hokkaido University'),(2769,2063,'ja','name','北海道大学'),(2770,2064,'en','name','Hauptman-Woodward Medical Research Institute'),(2771,2065,'en','name','Maryland Department of Health'),(2772,2066,'en','name','Western Infirmary'),(2773,2067,'bn','name','কলিকাতা জাতীয় আয়ুর্বিজ্ঞান বিদ্যামন্দির'),(2774,2067,'en','name','Calcutta National Medical College and Hospital'),(2775,2067,'te','name','జాతీయ వైద్య కళాశాల'),(2776,2068,'en','name','Middlesex London Health Unit'),(2777,2069,'en','name','Charlton Memorial Hospital'),(2778,2070,'en','name','Helsinki University Hospital'),(2779,2071,'en','name','Kwangwoon University'),(2780,2071,'ko','name','광운대학교'),(2781,2072,'en','name','Association for the Advancement of Artificial Intelligence'),(2782,2073,'en','name','Rocky Mountain University of Health Professions'),(2783,2074,'en','name','European Committee for Standardization'),(2784,2074,'fr','name','Comité Européen de Normalisation'),(2785,2075,'en','name','Kings County Hospital Center'),(2786,2076,'en','name','Daejeon University'),(2787,2076,'ko','name','대전대학교'),(2788,2077,'en','name','Lanzhou University Second Hospital'),(2789,2078,'en','name','Children\'s Hospital of New Orleans'),(2790,2079,'pt','name','Escola Superior de Enfermagem de Santa Maria'),(2791,2080,'en','name','Apollo Hospitals'),(2792,2081,'en','name','Ministry of Health'),(2793,2082,'no_lang_code','name','Hungkuang University'),(2794,2083,'es','name','Hospital General Universitario de Ciudad Real'),(2795,2084,'pt','name','Hospital São Rafael'),(2796,2085,'en','name','Alexandra Hospital'),(2797,2085,'zh','name','亚历山大医院'),(2798,2086,'en','name','MRC Centre for Reproductive Health'),(2799,2087,'fr','name','Hôpital Charles-Nicolle'),(2800,2088,'en','name','Hanyang University Guri Hospital'),(2801,2088,'ko','name','한양대학교구리병원'),(2802,2089,'de','name','Universität Hildesheim'),(2803,2089,'en','name','University of Hildesheim'),(2804,2090,'en','name','Wildlife Conservation Society Indonesia'),(2805,2091,'en','name','Ivanovo State University of Chemistry and Technology'),(2806,2091,'ru','name','Ивановский государственный химико-технологический университет'),(2807,2092,'fi','name','Kanta-Hämeen Keskussairaala'),(2808,2093,'en','name','Building Research Establishment'),(2809,2094,'en','name','American Association For Cancer Research'),(2810,2095,'en','name','Missouri Department of Mental Health'),(2811,2096,'en','name','First Teaching Hospital of Tianjin University of Traditional Chinese Medicine'),(2812,2096,'zh','name','中国传统医药的天津大学第一附属医院'),(2813,2097,'fr','name','Hôpital l\'Archet'),(2814,2098,'en','name','Mother Teresa Women\'s University'),(2815,2098,'ta','name','அன்னை தெரசா மகளிர் பல்கலைக்கழகம்'),(2816,2099,'en','name','Deenanath Mangeshkar Hospital and Research Center'),(2817,2099,'mr','name','दीनानाथ मंगेशकर रुग्णालय'),(2818,2100,'es','name','Tecnalia'),(2819,2101,'en','name','Spenshult Hospital'),(2820,2102,'en','name','Canadian Agency for Drugs and Technologies in Health'),(2821,2103,'en','name','Norwich University of the Arts'),(2822,2104,'no_lang_code','name','Intelligent Automation (United States)'),(2823,2105,'en','name','Kaiser Permanente San Francisco Medical Center'),(2824,2106,'en','name','Sri Krishnadevaraya University'),(2825,2106,'te','name','శ్రీ కృష్ణదేవరాయ విశ్వవిద్యాలయము'),(2826,2107,'en','name','Star General Hospital'),(2827,2107,'ja','name','星総合病院'),(2828,2108,'en','name','American Statistical Association'),(2829,2109,'en','name','First Affiliated Hospital of Kunming Medical University'),(2830,2110,'en','name','Centers for Medicare and Medicaid Services'),(2831,2111,'en','name','Cheongju St. Mary\'s Hospital'),(2832,2111,'ko','name','청주 성모 병원'),(2833,2112,'en','name','Amager Hospital'),(2834,2113,'en','name','Shriners Hospitals for Children - Boston'),(2835,2114,'en','name','Chris Hani Baragwanath Hospital'),(2836,2115,'de','name','Gesellschaft Fur Mathematik Und Datenverarbeitung'),(2837,2116,'en','name','Federal Medical Centre'),(2838,2117,'en','name','Royal Cornhill Hospital'),(2839,2118,'en','name','University Library in Bratislava'),(2840,2118,'sk','name','Univerzitná knižnica v Bratislave'),(2841,2119,'en','name','Charing Cross Hospital'),(2842,2120,'en','name','Scott & White Memorial Hospital'),(2843,2121,'en','name','Federal University from Jequitinhonha and Mucuri\'s Valleys'),(2844,2121,'pt','name','Universidade Federal dos Vales do Jequitinhonha e Mucuri'),(2845,2122,'en','name','Humber River Regional Hospital'),(2846,2123,'en','name','Apollo Gleneagles Hospitals'),(2847,2124,'en','name','St. Luke\'s Magic Valley Medical Center'),(2848,2125,'no_lang_code','name','Labor (Italy)'),(2849,2126,'en','name','University of Arkansas – Fort Smith'),(2850,2127,'en','name','Missouri Institute of Mental Health'),(2851,2128,'en','name','Nakamura Memorial Hospital'),(2852,2128,'ja','name','中村記念病院'),(2853,2129,'en','name','Allegheny General Hospital'),(2854,2130,'en','name','Seattle Pacific University'),(2855,2131,'en','name','Taipei City Hospital'),(2856,2131,'zh','name','臺北市政府'),(2857,2132,'en','name','University of the Andes'),(2858,2132,'es','name','Universidad de Los Andes'),(2859,2133,'en','name','Maternal and Child Health Care Hospital of Bao\'an'),(2860,2133,'zh','name','宝安区妇幼保健院'),(2861,2134,'en','name','Beijing Anzhen Hospital'),(2862,2134,'zh','name','北京市心肺血管疾病研究所'),(2863,2135,'en','name','Quality Education for Minorities Network'),(2864,2136,'en','name','Princess Margaret Hospital'),(2865,2137,'en','name','Allen University'),(2866,2138,'en','name','Ningxia Medical University'),(2867,2138,'zh','name','宁夏医科大学'),(2868,2139,'en','name','Christiana Care Health System'),(2869,2140,'en','name','San Joaquin General Hospital'),(2870,2141,'no_lang_code','name','Airbus (United Kingdom)'),(2871,2142,'es','name','Hospital de Clínicas \"José de San Martín\", Hospital de Clínicas José de San Martín'),(2872,2143,'en','name','National Research Tomsk State University'),(2873,2143,'ru','name','Национа́льный иссле́довательский То́мский госуда́рственный университе́т'),(2874,2144,'en','name','Rotterdam Eye Hospital'),(2875,2144,'nl','name','Oogziekenhuis Rotterdam'),(2876,2145,'no_lang_code','name','European Institute For Research and Strategic Studies In Telecommunications'),(2877,2146,'en','name','Rocky Mountain Hospital for Children'),(2878,2147,'en','name','Summa Barberton Hospital'),(2879,2148,'en','name','Fukuoka University Tsukushi Hospital'),(2880,2148,'ja','name','福岡大学筑紫病院'),(2881,2149,'en','name','Riverside Methodist Hospital'),(2882,2150,'en','name','Shizuoka City Hospital'),(2883,2150,'ja','name','静岡市立静岡病院'),(2884,2151,'no_lang_code','name','EIC Laboratories'),(2885,2152,'nl','name','Ziekenhuis Bethesda'),(2886,2153,'en','name','National Institute for Environmental Studies'),(2887,2153,'ja','name','国立環境研究所'),(2888,2154,'en','name','Memorial Medical Center'),(2889,2155,'el','name','Ιατρικό Διαβαλκανικό Κέντρο'),(2890,2155,'en','name','Interbalkan Medical Center'),(2891,2156,'no_lang_code','name','De Gezondheidsdienst voor Dieren'),(2892,2157,'en','name','Center for Urban Population Health'),(2893,2158,'no_lang_code','name','ArcelorMittal (Spain)'),(2894,2159,'en','name','Grand River Hospital'),(2895,2160,'en','name','John Muir Health'),(2896,2161,'ja','name','駒木野病院'),(2897,2161,'no_lang_code','name','Komagino Hospital'),(2898,2162,'be','name','Нацыянальная акадэмія навук Беларусі'),(2899,2162,'en','name','National Academy of Sciences of Belarus'),(2900,2162,'ru','name','Национальная академия наук Беларуси'),(2901,2163,'en','name','Gulbarga University'),(2902,2163,'hi','name','गुलबर्गा विश्वविद्यालय'),(2903,2163,'kn','name','ಗುಲ್ಬರ್ಗಾ ವಿಶ್ವವಿದ್ಯಾಲಯ'),(2904,2163,'ta','name','குல்பர்கா பல்கலைக்கழகம்'),(2905,2163,'te','name','గుల్బర్గా విశ్వవిద్యాలయం'),(2906,2164,'en','name','Yuanpei University'),(2907,2164,'zh','name','元培醫事科技大學'),(2908,2165,'en','name','Moorgreen Hospital'),(2909,2166,'en','name','Southeastern Universities Research Association'),(2910,2167,'en','name','Gallup Indian Medical Center'),(2911,2168,'en','name','Sacred Heart Hospital'),(2912,2169,'en','name','Imam Khomeini International University'),(2913,2169,'fa','name','دانشگاه بین‌المللی امام خمینی'),(2914,2170,'en','name','Dade County Medical Examiner Department'),(2915,2171,'no_lang_code','name','Artron Bioresearch (Canada)'),(2916,2172,'da','name','Aalborg Universitetshospital'),(2917,2172,'en','name','Aalborg University Hospital'),(2918,2173,'en','name','Saratov State Medical University'),(2919,2173,'ru','name','Саратовский государственный медицинский университет'),(2920,2174,'en','name','Riverview Psychiatric Center'),(2921,2175,'en','name','Qingdao Municipal Hospital'),(2922,2176,'en','name','Ursinus College'),(2923,2177,'en','name','Institute for Energy Technology'),(2924,2178,'en','name','Federico II University Hospital'),(2925,2178,'it','name','Azienda Ospedaliera Universitaria Federico II'),(2926,2179,'en','name','IBM Research - Zurich'),(2927,2180,'en','name','Hanseo University'),(2928,2181,'en','name','Diakonhjemmet Hospital'),(2929,2182,'en','name','Kaiser Permanente Fontana Medical Center'),(2930,2183,'en','name','Hammerfest Hospital'),(2931,2183,'no','name','Hammerfest Sykehus'),(2932,2184,'en','name','Port Moresby General Hospital'),(2933,2185,'no_lang_code','name','Goroka Base Hospital'),(2934,2186,'en','name','Makati Medical Center'),(2935,2187,'en','name','Changes in Health Care Financing & Organization'),(2936,2188,'en','name','Atlantic Health System'),(2937,2189,'en','name','Children\'s Hospital of Winnipeg'),(2938,2190,'no_lang_code','name','Sankara Nethralaya'),(2939,2191,'es','name','Hospital Luis Calvo Mackenna'),(2940,2192,'en','name','Pfeiffer University'),(2941,2193,'bn','name','রাজশাহী মেডিকেল কলেজ'),(2942,2193,'en','name','Rajshahi Medical College'),(2943,2194,'en','name','Helen Hayes Hospital'),(2944,2195,'de','name','Klinikum Lüneburg'),(2945,2196,'en','name','American Society for Cell Biology'),(2946,2197,'no_lang_code','name','TagCyx Biotechnologies (Japan)'),(2947,2198,'de','name','Universitätskinderklinik Bern'),(2948,2198,'en','name','University Children’s Hospital Bern'),(2949,2199,'en','name','Earl K. Long Medical Center'),(2950,2200,'en','name','MRC Human Immunology Unit'),(2951,2201,'en','name','Tianjin Central Hospital of Gynecology Obstetrics'),(2952,2201,'zh','name','天津市中心妇产科医院'),(2953,2202,'en','name','Miami Valley Hospital'),(2954,2203,'no_lang_code','name','AnyGen (South Korea)'),(2955,2204,'en','name','University of La Verne'),(2956,2204,'es','name','Universidad de La Verne'),(2957,2205,'en','name','Institute of Electron Technology'),(2958,2206,'pt','name','Instituto Superior de Comunicação Empresarial'),(2959,2207,'en','name','American Bar Foundation'),(2960,2208,'en','name','Creative England'),(2961,2209,'en','name','Organization For Tropical Studies'),(2962,2210,'it','name','Istituto Nazionale per la Fisica della Materia'),(2963,2211,'en','name','Metropolitan Autonomous University'),(2964,2211,'es','name','Universidad Autónoma Metropolitana'),(2965,2212,'en','name','Karlstad Central Hospital'),(2966,2213,'el','name','Γενικό Νοσοκομείο Ημαθίας'),(2967,2213,'no_lang_code','name','Veria General Hospital'),(2968,2214,'en','name','University of Akron'),(2969,2215,'bg','name','Медицински университет - Пловдив'),(2970,2215,'de','name','Medizinischen Universität Plovdiv'),(2971,2215,'en','name','Medical University Plovdiv'),(2972,2216,'de','name','Klinikum Südstadt Rostock'),(2973,2217,'de','name','Hochschule Furtwangen'),(2974,2217,'en','name','Furtwangen University'),(2975,2218,'no_lang_code','name','Taconic (United States)'),(2976,2219,'ar','name','الدكتور سليمان فقية'),(2977,2219,'en','name','Soliman Fakeeh Hospital'),(2978,2220,'de','name','Hochschule Kempten'),(2979,2220,'en','name','Kempten University of Applied Sciences'),(2980,2221,'no_lang_code','name','Dr. Balabhai Nanavati Hospital'),(2981,2222,'ar','name','جامعة قناة السويس'),(2982,2222,'fr','name','Université du Canal de Suez'),(2983,2222,'no_lang_code','name','Suez Canal University'),(2984,2223,'pt','name','Hospital de Santo António'),(2985,2224,'en','name','Rawalpindi Medical University'),(2986,2225,'en','name','Hampden–Sydney College'),(2987,2226,'it','name','Azienda USL di Bologna'),(2988,2227,'en','name','Tribhuvan University Teaching Hospital'),(2989,2228,'fr','name','Hôpital Bonnet'),(2990,2229,'en','name','Acharya Nagarjuna University'),(2991,2229,'te','name','ఆచార్య నాగార్జున విశ్వవిద్యాలయం'),(2992,2230,'en','name','Winona Medical Cosmetic Center'),(2993,2230,'zh','name','薇诺娜皮肤医疗美容中心'),(2994,2231,'en','name','University of Hawaii at Hilo'),(2995,2231,'es','name','Universidad de Hawái en Hilo'),(2996,2231,'fr','name','Université d\'hawaï à hilo'),(2997,2232,'no_lang_code','name','Creare (United States)'),(2998,2233,'ja','name','長野市民病院'),(2999,2233,'no_lang_code','name','Nagano Municipal Hospital'),(3000,2234,'en','name','Immaculata University'),(3001,2235,'en','name','Kobe City Nishi-Kobe Medical Center'),(3002,2235,'ja','name','神戸市立西神戸医療センター'),(3003,2236,'en','name','Bradley Hospital'),(3004,2237,'en','name','St Joseph\'s Hospital Health Center'),(3005,2238,'en','name','Okanagan University College'),(3006,2239,'en','name','Hubei University of Chinese Medicine'),(3007,2239,'zh','name','湖北中医药大学'),(3008,2240,'en','name','Maryville University'),(3009,2241,'en','name','Long Beach Animal Hospital'),(3010,2242,'en','name','AdventHealth Orlando'),(3011,2243,'en','name','Koshigaya Municipal Hospital'),(3012,2243,'ja','name','越谷市立病院'),(3013,2244,'en','name','University of New England'),(3014,2245,'en','name','Elizabeth City State University'),(3015,2246,'en','name','Victoria General Hospital'),(3016,2247,'no_lang_code','name','Coanda Research and Development Corporation (Canada)'),(3017,2248,'en','name','Cheyney University of Pennsylvania'),(3018,2248,'es','name','Universidad de Cheyney de Pensilvania'),(3019,2248,'fr','name','Université cheyney de pennsylvanie'),(3020,2249,'en','name','Children\'s Medical Center'),(3021,2250,'en','name','Evanston Hospital'),(3022,2251,'en','name','Shimane Prefectural Institute of Public Health and Environmental Sciences'),(3023,2251,'ja','name','島根県保健環境科学研究所'),(3024,2252,'no_lang_code','name','BMT Group (United Kingdom)'),(3025,2253,'en','name','Letterman Army Medical Center'),(3026,2254,'en','name','Center for Biologics Evaluation and Research'),(3027,2255,'en','name','Chestnut Hill Hospital'),(3028,2256,'en','name','National Aeronautical Research Institute'),(3029,2256,'sv','name','Flygtekniska försöksanstalten'),(3030,2257,'en','name','Institute for Clinical Efectiveness and Health Policy'),(3031,2257,'es','name','Instituto de Efectividad Clínica y Sanitaria'),(3032,2258,'en','name','College of New Jersey'),(3033,2259,'en','name','Funabashi Municipal Medical Center'),(3034,2259,'ja','name','船橋市立医療センター'),(3035,2260,'en','name','Science Museum of Minnesota'),(3036,2261,'es','name','Hospital Luis Vernaza'),(3037,2262,'en','name','Kent and Canterbury Hospital'),(3038,2263,'de','name','Kaiser-Franz-Josef-Spital'),(3039,2264,'en','name','Treatment Research Institute'),(3040,2265,'en','name','Blood Center of Zhejiang Province'),(3041,2265,'zh','name','浙江省血液中心'),(3042,2266,'en','name','Moncton Hospital'),(3043,2267,'en','name','Monilek Hospital and Research Center'),(3044,2268,'en','name','University of Cincinnati Medical Center'),(3045,2269,'en','name','K S Hegde Medical Academy'),(3046,2270,'en','name','Concord Hospital'),(3047,2271,'en','name','Hutzel Women\'s Hospital'),(3048,2272,'en','name','Archimedes Foundation'),(3049,2273,'tr','name','Bahriye Merkez Hastanesi, Kasımpaşa Asker Hastanesi'),(3050,2274,'fr','name','Hôpital Léon Bérard'),(3051,2275,'de','name','Krankenhaus der Elisabethinen'),(3052,2276,'no_lang_code','name','Immunomedics (United States)'),(3053,2277,'no_lang_code','name','Nongwoo Bio (South Korea)'),(3054,2278,'es','name','Hospital Casa de Salud'),(3055,2279,'en','name','University of Aizu'),(3056,2279,'ja','name','会津大学'),(3057,2280,'en','name','Ming Chuan University'),(3058,2281,'de','name','Fraunhofer-Institut für Windenergiesysteme'),(3059,2281,'en','name','Fraunhofer Institute for Wind Energy Systems'),(3060,2282,'en','name','St George Hospital'),(3061,2283,'no_lang_code','name','Deschutes Research'),(3062,2284,'en','name','Punjab Government Dental College and Hospital'),(3063,2285,'es','name','Hospital Universitario Son Dureta'),(3064,2286,'en','name','Lions Gate Hospital'),(3065,2287,'en','name','Health Resources Unlimited'),(3066,2288,'en','name','St. Cloud VA Health Care System'),(3067,2289,'no_lang_code','name','Suncor Energy (Canada)'),(3068,2290,'no_lang_code','name','Sinte Gleska University'),(3069,2291,'no_lang_code','name','Tangam Gaming Inc'),(3070,2292,'cy','name','Prifysgol Newydd Swydd Buckingham'),(3071,2292,'en','name','Buckinghamshire New University'),(3072,2293,'en','name','Kaiser Permanente Sacramento Medical Center'),(3073,2294,'en','name','Henderson State University'),(3074,2294,'fr','name','Université d\'État henderson'),(3075,2295,'fr','name','Institut Technologique Forêt Cellulose Bois-Construction Ameublement'),(3076,2296,'en','name','American Institute of Physics'),(3077,2297,'en','name','Shotley Bridge Hospital'),(3078,2298,'en','name','Somerset Medical Center'),(3079,2299,'en','name','Geisinger Health System'),(3080,2300,'en','name','University of Louisiana at Monroe'),(3081,2300,'fr','name','Université de Louisiane à Monroe'),(3082,2301,'en','name','Tacoma Community College'),(3083,2302,'en','name','Sardar Patel Post Graduate Institute of Dental and Medical Sciences'),(3084,2303,'de','name','Zentrum für Europäische Wirtschaftsforschung'),(3085,2303,'en','name','Centre for European Economic Research'),(3086,2304,'en','name','Walden University'),(3087,2305,'en','name','Jaipur Golden Hospital'),(3088,2306,'no_lang_code','name','Alstom (United Kingdom)'),(3089,2307,'en','name','Nagasaki Medical Center'),(3090,2307,'ja','name','長崎医療センター'),(3091,2308,'no_lang_code','name','Aretaeio Hospital'),(3092,2309,'en','name','First Affiliated Hospital of Xinjiang Medical University'),(3093,2309,'zh','name','新疆医科大学第一附属医院'),(3094,2310,'en','name','People\'s Hospital of Xinjiang Uygur Autonomous Region'),(3095,2310,'zh','name','新疆维吾尔自治区人民医院'),(3096,2311,'en','name','Polyclinic Medical Center'),(3097,2312,'en','name','Saraswati Dental College and Hospital'),(3098,2313,'en','name','Kaiser Permanente Vallejo Medical Center'),(3099,2314,'ar','name','مدينة الحسين الطبية'),(3100,2314,'en','name','King Hussein Medical Center'),(3101,2315,'pt','name','Hospital de Santa Cruz'),(3102,2316,'en','name','Babol University of Medical Sciences'),(3103,2316,'fa','name','دانشگاه علوم پزشکی بابل'),(3104,2317,'no_lang_code','name','Thermal Technologies (United States)'),(3105,2318,'en','name','University of Jammu'),(3106,2318,'hi','name','जम्मू विश्वविद्यालय'),(3107,2319,'ja','name','島田市民病院'),(3108,2319,'no_lang_code','name','Shimada Municipal Hospital'),(3109,2320,'en','name','Southwest Bahia State University'),(3110,2320,'es','name','Universidad Estatal del Sudoeste de Bahía'),(3111,2320,'pt','name','Universidade Estadual do Sudoeste da Bahia'),(3112,2321,'en','name','Madonna University'),(3113,2321,'fr','name','Université madonna'),(3114,2322,'en','name','Mulago Hospital'),(3115,2323,'en','name','Nishtar Medical College and Hospital'),(3116,2324,'en','name','Princess Mary Maternity Hospital'),(3117,2325,'ar','name','مستشفى الكورنيش للأمومة'),(3118,2325,'en','name','Corniche Hospital'),(3119,2326,'en','name','Queen\'s Hospital'),(3120,2327,'en','name','King Edward Medical University'),(3121,2327,'ur','name','کنگ ایڈورڈ میڈیکل یونیورسٹی'),(3122,2328,'en','name','Point Loma Nazarene University'),(3123,2329,'en','name','Misericordia Community Hospital'),(3124,2330,'en','name','Bai Jerbai Wadia Hospital for Children'),(3125,2331,'en','name','Agency for the Promotion of European Research'),(3126,2331,'it','name','Agenzia per la Promozione della Ricerca Europea'),(3127,2332,'en','name','Indiana University South Bend'),(3128,2333,'en','name','New Hanover Regional Medical Center'),(3129,2334,'en','name','Chang Jung Christian University'),(3130,2335,'ar','name','مستشفى القطيف المركزي'),(3131,2335,'en','name','Qatif Central Hospital'),(3132,2336,'en','name','Conquest Hospital'),(3133,2337,'en','name','Calgary General Hospital'),(3134,2338,'en','name','Himachal Pradesh University'),(3135,2339,'en','name','Circolo Hospital and Macchi Foundation'),(3136,2339,'it','name','Ospedale di Circolo e Fondazione Macchi'),(3137,2340,'en','name','University of Bamako'),(3138,2340,'fr','name','Université de Bamako'),(3139,2341,'en','name','Fourth Affiliated Hospital of Harbin Medical University'),(3140,2341,'zh','name','哈尔滨医科大学第四附属医院'),(3141,2342,'it','name','Azienda Ospedaliera Universitaria Senese'),(3142,2343,'es','name','Hospital Arnau de Vilanova'),(3143,2344,'en','name','Thammasat University Hospital'),(3144,2344,'th','name','โรงพยาบาลธรรมศาสตร์เฉลิมพระเกียรติ'),(3145,2345,'en','name','PVS Memorial Hospital'),(3146,2346,'fr','name','Centre Hospitalier de Mulhouse'),(3147,2347,'en','name','Kaleida Health'),(3148,2348,'en','name','American Association of Geographers'),(3149,2349,'be','name','Беларускі дзяржаўны ўніверсітэт інфарматыкі і радыёэлектронікі'),(3150,2349,'en','name','Belarusian State University of Informatics and Radioelectronics'),(3151,2349,'ru','name','Белорусский государственный университет информатики и радиоэлектроники'),(3152,2350,'en','name','Versiti Blood Center of Wisconsin'),(3153,2351,'tr','name','Bakırköy Dr.Sadi Konuk Eğitim ve Araştırma Hastanesi'),(3154,2352,'en','name','Birmingham City Hospital'),(3155,2353,'pt','name','Hospital Nossa Senhora da Conceição'),(3156,2354,'en','name','Toyota Technological Institute at Chicago'),(3157,2355,'en','name','University Hospital, Newark'),(3158,2356,'en','name','Burke Medical Research Institute'),(3159,2357,'en','name','Royal Jubilee Hospital'),(3160,2358,'en','name','Erzurum Regional Training and Research Hospital'),(3161,2358,'tr','name','Erzurum Bölge Eğitim ve Araştırma Hastanesi'),(3162,2359,'en','name','Kansai Electric Power Hospital'),(3163,2359,'ja','name','関西電力病院'),(3164,2360,'en','name','Emerson Hospital'),(3165,2361,'en','name','National Hospital Niamey'),(3166,2361,'fr','name','Hôpital National de Niamey'),(3167,2362,'en','name','Kyushu Central Hospital of the Mutual Aid Association of Public School Teachers'),(3168,2362,'ja','name','公立学校共済組合 九州中央病院'),(3169,2363,'en','name','Mercy Hospital'),(3170,2364,'ko','name','대항병원'),(3171,2364,'no_lang_code','name','Daehang Hospital'),(3172,2365,'en','name','Hirosaki University'),(3173,2365,'ja','name','弘前大学'),(3174,2366,'en','name','Methodist Hospital'),(3175,2367,'en','name','University of North Carolina Wilmington'),(3176,2367,'es','name','Universidad de Carolina del Norte en Wilmington'),(3177,2367,'fr','name','Université de wilmington'),(3178,2368,'en','name','Regional Institute of Medical Sciences'),(3179,2369,'en','name','Sejong General Hospital'),(3180,2369,'ko','name','세종 병원'),(3181,2370,'no_lang_code','name','Radikal Therapeutics'),(3182,2371,'en','name','Lakehead Psychiatric Hospital'),(3183,2372,'no_lang_code','name','Adipogen (South Korea)'),(3184,2373,'it','name','Azienda Ospedaliera S.Maria'),(3185,2374,'no_lang_code','name','University Research Co (United States)'),(3186,2375,'en','name','Irish Universities Association'),(3187,2375,'ga','name','Cumann Ollscoileanna Éireann'),(3188,2376,'en','name','Xinjiang Academy of Animal Science'),(3189,2376,'zh','name','新疆维吾尔自治区畜牧科学院'),(3190,2377,'tr','name','Fırat Üniversitesi Hastanesi'),(3191,2378,'en','name','Belfast Health and Social Care Trust'),(3192,2379,'en','name','La Rabida Children\'s Hospital'),(3193,2380,'en','name','Sydney Children\'s Hospital'),(3194,2381,'en','name','Institute for Systems Biology'),(3195,2382,'en','name','National Cancer Center'),(3196,2383,'en','name','Bryn Mawr Hospital'),(3197,2384,'ja','name','公立学校共済組合関東中央病院'),(3198,2384,'no_lang_code','name','Kanto Central Hospital'),(3199,2385,'en','name','New School'),(3200,2385,'es','name','La Nueva Escuela'),(3201,2386,'en','name','Riverside Research Institute'),(3202,2387,'en','name','Clemente Álvarez Emergency Hospital'),(3203,2387,'es','name','Hospital de Emergencias Dr. Clemente Álvarez'),(3204,2388,'en','name','Robinson Memorial Hospital'),(3205,2389,'fr','name','Hôpital Louis-H Lafontaine'),(3206,2390,'en','name','MRC/CSO Social and Public Health Sciences Unit'),(3207,2391,'en','name','Portland VA Medical Center'),(3208,2392,'en','name','St David\'s Medical Center'),(3209,2393,'ar','name','مستشفى خولة'),(3210,2393,'no_lang_code','name','Khoula Hospital'),(3211,2394,'en','name','Santa Clara Valley Medical Center'),(3212,2395,'no_lang_code','name','Guru Teg Bahadur Hospital'),(3213,2396,'ko','name','건양대학교'),(3214,2396,'no_lang_code','name','Konyang University'),(3215,2397,'en','name','Madras Medical Mission'),(3216,2398,'en','name','Geneva College'),(3217,2399,'no_lang_code','name','ThyssenKrupp (Germany)'),(3218,2400,'en','name','Administration of Occupational Safety and Health'),(3219,2400,'is','name','Vinnueftirlitið'),(3220,2401,'no_lang_code','name','Estácio (Brazil)'),(3221,2402,'en','name','Chang Gung Memorial Hospital'),(3222,2403,'en','name','Charleston Area Medical Center'),(3223,2404,'en','name','Kinki Central Hospital'),(3224,2404,'ja','name','近畿中央病院'),(3225,2405,'en','name','Kumamoto University Hospital'),(3226,2405,'ja','name','熊本大学医学部附属病院'),(3227,2406,'en','name','Zhangzhou Normal University'),(3228,2406,'zh','name','闽南师范大学'),(3229,2407,'en','name','Fort Sanders Regional Medical Center'),(3230,2408,'en','name','Ulyanovsk State University'),(3231,2408,'ru','name','Ульяновский государственный университет'),(3232,2409,'nl','name','Streekziekenhuis Koningin Beatrix'),(3233,2410,'en','name','Mills Peninsula Health Services'),(3234,2411,'en','name','James Cook University Hospital'),(3235,2412,'en','name','Jen-Ai Hospital'),(3236,2412,'zh','name','仁愛醫療財團法人'),(3237,2413,'en','name','Reina Sofia Hospital'),(3238,2413,'es','name','Hospital Universitario Reina Sofía'),(3239,2414,'en','name','Allen Hospital'),(3240,2415,'en','name','Smolensk University for Humanities'),(3241,2415,'ru','name','Смоленский гуманитарный университет'),(3242,2416,'en','name','London South Bank University'),(3243,2417,'no_lang_code','name','Fortis Hospital'),(3244,2418,'en','name','Fairview Southdale Hospital'),(3245,2419,'ar','name','جامعة عدن'),(3246,2419,'en','name','University of Aden'),(3247,2420,'en','name','Bashkir State Medical University'),(3248,2420,'ru','name','Башкирский государственный медицинский университет'),(3249,2421,'en','name','Ruchill Hospital'),(3250,2422,'fr','name','Hôpital Gui de Chauliac'),(3251,2423,'en','name','Keller Army Community Hospital'),(3252,2424,'en','name','Silla University'),(3253,2424,'ko','name','신라대학교'),(3254,2425,'as','name','অসম চিকিৎসা মহাবিদ্যালয়'),(3255,2425,'en','name','Assam Medical College'),(3256,2426,'en','name','Assiut University Hospitals'),(3257,2427,'en','name','Datta Meghe Institute of Medical Sciences'),(3258,2428,'en','name','Royal Surrey County Hospital'),(3259,2429,'en','name','Shriners Hospitals for Children - Tampa'),(3260,2430,'en','name','Chung Yuan Christian University'),(3261,2431,'en','name','Lagos State University Teaching Hospital'),(3262,2432,'en','name','Eye & ENT Hospital of Fudan University'),(3263,2433,'en','name','Larkin Community Hospital'),(3264,2434,'en','name','Catholic Health Association of the United States'),(3265,2435,'no_lang_code','name','Keskuslaboratorio'),(3266,2436,'no_lang_code','name','GenVec'),(3267,2437,'en','name','Chidicon Medical Center'),(3268,2438,'fr','name','Produits forestiers Résolu'),(3269,2438,'no_lang_code','name','Resolute Forest Products (Canada)'),(3270,2439,'en','name','Grant Medical Center'),(3271,2440,'en','name','Miyake Eye Hospital'),(3272,2440,'ja','name','眼科三宅病院'),(3273,2441,'pt','name','Fundacao Universitaria Jose Bonifacio'),(3274,2442,'en','name','Mazandaran University of Medical Sciences'),(3275,2442,'fa','name','دانشگاه علوم پزشکی مازندران'),(3276,2443,'es','name','Hospital General Yagüe'),(3277,2444,'en','name','Chungbuk National University'),(3278,2444,'ko','name','충북대학교'),(3279,2445,'en','name','Saskatchewan Health Authority'),(3280,2446,'en','name','Chesterfield Royal Hospital'),(3281,2447,'no_lang_code','name','Echelon Biosciences'),(3282,2448,'fr','name','Hôpital Militaire Moulay Ismail'),(3283,2449,'en','name','St. John’s Health Sciences Centre'),(3284,2450,'fa','name','بیمارستان حافظ'),(3285,2450,'no_lang_code','name','Hafez Hospital'),(3286,2451,'en','name','Pontifical Catholic University of Paraná'),(3287,2451,'es','name','Pontificia Universidad Católica de Paraná'),(3288,2451,'fr','name','Université pontificale catholique du paraná'),(3289,2451,'pt','name','Pontifícia Universidade Católica do Paraná'),(3290,2452,'en','name','Millersville University'),(3291,2453,'en','name','Florida Medical Entomology Laboratory'),(3292,2454,'no_lang_code','name','Personal Improvement Computer Systems'),(3293,2455,'en','name','Sawai ManSingh Medical College and Hospital'),(3294,2456,'en','name','Bridgewater State University'),(3295,2456,'fr','name','Université d\'État de bridgewater'),(3296,2457,'en','name','Cleveland Clinic Lerner College of Medicine'),(3297,2458,'pt','name','Hospital Geral de Bonsucesso'),(3298,2459,'fr','name','Hôpital Pellegrin'),(3299,2460,'en','name','University of Electro-Communications'),(3300,2460,'ja','name','電気通信大学'),(3301,2461,'en','name','Peter the Great St. Petersburg Polytechnic University'),(3302,2461,'ru','name','Санкт-Петербургский политехнический университет Петра Великого'),(3303,2462,'en','name','Brooklyn Hospital Center'),(3304,2463,'en','name','Eastern New Mexico University'),(3305,2464,'en','name','St. Boniface Hospital'),(3306,2465,'en','name','North Manchester General Hospital'),(3307,2466,'en','name','JSS Medical College and Hospital'),(3308,2467,'en','name','Incheon National University'),(3309,2467,'ko','name','인천대학교'),(3310,2468,'en','name','Hanil General Hospital'),(3311,2468,'ko','name','한전병원'),(3312,2469,'en','name','University of Prince Edward Island'),(3313,2469,'fr','name','Université de l\'Île-du-prince-Édouard'),(3314,2470,'pt','name','Universidade Veiga de Almeida'),(3315,2471,'en','name','Kosin University Gospel Hospital'),(3316,2471,'ko','name','고신대학교 복음병원'),(3317,2472,'en','name','Queen Mary Hospital'),(3318,2472,'zh','name','瑪麗醫院'),(3319,2473,'en','name','Kibi International University'),(3320,2473,'ja','name','吉備国際大学'),(3321,2474,'no_lang_code','name','Micronet (United States)'),(3322,2475,'es','name','Hospital Clínico de la Universidad de Chile'),(3323,2476,'en','name','Muhimbili National Hospital'),(3324,2477,'en','name','Sisters of Charity Hospital'),(3325,2478,'no_lang_code','name','FEV (Germany)'),(3326,2479,'en','name','National Council of Teachers of Mathematics'),(3327,2480,'ja','name','北海道病院'),(3328,2480,'no_lang_code','name','Hokkaido hospital'),(3329,2481,'en','name','Gannon University'),(3330,2482,'en','name','Jackson Memorial Hospital'),(3331,2483,'en','name','George Eliot Hospital NHS Trust'),(3332,2484,'en','name','Pravara Institute of Medical Sciences'),(3333,2485,'en','name','General Leonard Wood Army Community Hospital'),(3334,2486,'en','name','Chi Mei Medical Center'),(3335,2487,'en','name','Lovelace Medical Center'),(3336,2488,'pt','name','Hospital Infantil Joana de Gusmão'),(3337,2489,'en','name','Morehouse College'),(3338,2490,'en','name','University of Nairobi'),(3339,2490,'sw','name','Chuo Kikuu cha Nairobi'),(3340,2491,'pt','name','Hospital de São Bernardo'),(3341,2492,'en','name','Shenyang Medical College'),(3342,2492,'zh','name','沈阳医学院'),(3343,2493,'no_lang_code','name','Electrosonics Medical'),(3344,2494,'en','name','Dongzhimen Hospital Affiliated to Beijing University of Chinese Medicine'),(3345,2494,'zh','name','北京中医药大学东直门医院'),(3346,2495,'es','name','Universidad Nacional Experimental Francisco de Miranda'),(3347,2496,'en','name','Health Sciences Authority'),(3348,2496,'ms','name','Penguasa Sains Kesihatan'),(3349,2497,'en','name','Civil Hospital Karachi'),(3350,2498,'en','name','Program for Appropriate Technology in Health'),(3351,2499,'en','name','Keystone Symposia On Molecular and Cellular Biology'),(3352,2500,'en','name','Carroll University'),(3353,2501,'en','name','International Vaccine Institute'),(3354,2502,'en','name','Interfaith Medical Center'),(3355,2503,'en','name','Kunsan National University'),(3356,2503,'ko','name','군산대학교'),(3357,2504,'en','name','Princess Anne Hospital'),(3358,2505,'en','name','Savannah Technical College'),(3359,2506,'en','name','Razi University'),(3360,2506,'fa','name','دانشگاه رازی'),(3361,2507,'en','name','Oklahoma Department of Mental Health and Substance Abuse Services'),(3362,2508,'tr','name','Kayseri Eğitim ve Araştırma Hastanesi'),(3363,2509,'de','name','Bundesamt für Strahlenschutz'),(3364,2509,'en','name','Federal Office for Radiation Protection'),(3365,2510,'en','name','Palmetto Health Richland'),(3366,2511,'en','name','University of Miami Hospital'),(3367,2512,'en','name','Borders General Hospital'),(3368,2513,'en','name','Mercy Medical Center North Iowa'),(3369,2514,'no_lang_code','name','Kyowa-kako (Japan)'),(3370,2515,'no_lang_code','name','Spire Corporation (United States)'),(3371,2516,'en','name','Zhongshan Hospital of Xiamen University'),(3372,2516,'zh','name','厦门大学附属中山医院'),(3373,2517,'en','name','Yunnan Academy of Agricultural Sciences'),(3374,2517,'zh','name','云南省农业科学院'),(3375,2518,'en','name','Wheeling Jesuit University'),(3376,2519,'en','name','University of Charleston'),(3377,2519,'fr','name','Université de Charleston'),(3378,2520,'en','name','College of Idaho'),(3379,2521,'en','name','Japanese Red Cross Katsushika Maternity Hospital'),(3380,2521,'ja','name','日本赤十字社葛飾マタニティ病院'),(3381,2522,'tr','name','Izmir Bozyaka Eğitim ve Araştırma Hastanesi'),(3382,2523,'en','name','Exempla Saint Joseph Hospital'),(3383,2524,'en','name','Mayo General Hospital'),(3384,2525,'en','name','Dr. Mohan\'s Diabetes Specialities Centre'),(3385,2526,'en','name','BJC HealthCare'),(3386,2527,'es','name','Universidad Anáhuac'),(3387,2528,'en','name','Bethlem Royal Hospital'),(3388,2529,'en','name','Babol Noshirvani University of Technology'),(3389,2529,'fa','name','دانشگاه صنعتی نوشیروانی بابل'),(3390,2530,'en','name','Tufts Children\'s Hospital'),(3391,2531,'en','name','National Institute of Public Health'),(3392,2531,'sl','name','Nacionalni Inštitut za Javno Zdravje'),(3393,2532,'en','name','Leicester General Hospital'),(3394,2533,'en','name','Vancouver General Hospital'),(3395,2534,'en','name','National Registry of Emergency Medical Technicians'),(3396,2535,'en','name','Beijing Museum of Natural History'),(3397,2535,'zh','name','北京自然博物馆'),(3398,2536,'ja','name','日本電子'),(3399,2536,'no_lang_code','name','JEOL (Japan)'),(3400,2537,'no_lang_code','name','INTRASOFT International (Luxembourg)'),(3401,2538,'it','name','Ospedale Santa Maria della Misericordia di Udine'),(3402,2539,'en','name','University of Bahr El-Ghazal'),(3403,2540,'en','name','National University of Comahue'),(3404,2540,'es','name','Universidad Nacional del Comahue'),(3405,2541,'en','name','Hamad Medical Corporation'),(3406,2542,'en','name','Sharp Grossmont Hospital'),(3407,2543,'en','name','Virginia Union University'),(3408,2544,'no_lang_code','name','Profectus Biosciences (United States)'),(3409,2545,'en','name','Mayo Clinic Health System'),(3410,2546,'it','name','Ospedale San Giovanni Bosco'),(3411,2547,'en','name','Bahian School of Medicine and Public Health'),(3412,2547,'pt','name','Escola Bahiana de Medicina e Saúde Pública'),(3413,2548,'en','name','AC Camargo Hospital'),(3414,2549,'en','name','Levine Children\'s Hospital'),(3415,2550,'en','name','Durban University of Technology'),(3416,2550,'zu','name','Inyuvesi yasethekwini yezobuchwepheshe'),(3417,2551,'en','name','Harrogate District Hospital'),(3418,2552,'pt','name','Instituto Superior de Serviço Social do Porto'),(3419,2553,'no_lang_code','name','MatTek Corporation (United States)'),(3420,2554,'en','name','Association of Commonwealth Universities'),(3421,2555,'no_lang_code','name','Enerkem (Canada)'),(3422,2556,'en','name','Higher Institute of Police Sciences and Homeland Security'),(3423,2556,'pt','name','Instituto Superior de Ciências Policiais e Segurança Interna'),(3424,2557,'no_lang_code','name','123 Certification (Canada)'),(3425,2558,'en','name','Royal Oldham Hospital'),(3426,2559,'en','name','First Affiliated Hospital of Fujian Medical University'),(3427,2559,'zh','name','福建医科大学附属第一医院'),(3428,2560,'en','name','Lankenau Institute for Medical Research'),(3429,2561,'en','name','Yunnan Nationalities University'),(3430,2561,'zh','name','云南民族大学'),(3431,2562,'en','name','Alessandro Manzoni Hospital'),(3432,2562,'it','name','Ospedale Alessandro Manzoni'),(3433,2563,'en','name','Tatung University'),(3434,2563,'zh','name','大同大學'),(3435,2564,'en','name','Ralph H. Johnson VA Medical Center'),(3436,2565,'en','name','Robert Jones and Agnes Hunt Orthopaedic Hospital'),(3437,2566,'no_lang_code','name','Cleveland Medical Devices'),(3438,2567,'no_lang_code','name','Univax (United States)'),(3439,2568,'en','name','Norfolk State University'),(3440,2568,'fr','name','Université d\'État de norfolk'),(3441,2569,'en','name','National Police Hospital'),(3442,2569,'ko','name','국립경찰병원'),(3443,2570,'en','name','University of the Philippines Los Baños'),(3444,2571,'en','name','First Affiliated Hospital of GuangXi Medical University'),(3445,2572,'en','name','Rocky Mountain Biological Laboratory'),(3446,2573,'ar','name','جامعة مصر الدولية'),(3447,2573,'en','name','Misr International University'),(3448,2574,'en','name','Finnish Institute of Occupational Health'),(3449,2575,'en','name','University Hospital of Heraklion'),(3450,2576,'en','name','Başkent University Hospital'),(3451,2577,'en','name','Children\'s Hospital Agia Sophia'),(3452,2578,'en','name','Payame Noor University'),(3453,2578,'fa','name','دانشگاه پیام نور'),(3454,2579,'ar','name','جامعة البحرين'),(3455,2579,'en','name','University of Bahrain'),(3456,2580,'no_lang_code','name','Bastyr University'),(3457,2581,'en','name','City College of San Francisco'),(3458,2582,'no_lang_code','name','Lucigen Corporation'),(3459,2583,'de','name','Universität Mannheim'),(3460,2583,'en','name','University of Mannheim'),(3461,2584,'es','name','Universidad del Norte'),(3462,2585,'en','name','Autonomous University of Hidalgo State'),(3463,2585,'es','name','Universidad Autónoma del Estado de Hidalgo'),(3464,2586,'no_lang_code','name','Dow Chemical (Canada)'),(3465,2587,'en','name','Tokyo Medical University Ibaraki Medical Center'),(3466,2587,'ja','name','東京医科大学茨城医療センター'),(3467,2588,'en','name','Chung Hwa University of Medical Technology'),(3468,2588,'zh','name','中華醫事科技大學'),(3469,2589,'en','name','Second Affiliated Hospital of Chengdu University of Traditional Chinese'),(3470,2589,'zh','name','成都中医药大学'),(3471,2590,'en','name','Bedford Hospital NHS Trust'),(3472,2591,'en','name','Dakota Wesleyan University'),(3473,2592,'no_lang_code','name','Boehringer Ingelheim (Canada)'),(3474,2593,'pt','name','Instituto Superior de Ciências Empresariais e do Turismo'),(3475,2594,'en','name','Tulane Medical Center'),(3476,2595,'en','name','Sound Shore Medical Center'),(3477,2596,'en','name','Social Security Children\'s Hospital'),(3478,2597,'fr','name','Institut Universitaire de Gériatrie de Montréal'),(3479,2598,'en','name','City Hospital'),(3480,2599,'en','name','MRIGlobal'),(3481,2600,'it','name','Ospedale San Giovanni Antica Sede'),(3482,2601,'it','name','Azienda Ospedaliera Sant\'Andrea'),(3483,2602,'en','name','Spartanburg Regional Medical Center'),(3484,2603,'en','name','Kitakyushu Municipal Medical Center'),(3485,2603,'ja','name','北九州市立医療センター'),(3486,2604,'en','name','Ahmadu Bello University Teaching Hospital'),(3487,2605,'en','name','Anhui Agricultural University'),(3488,2605,'zh','name','安徽农业大学'),(3489,2606,'no_lang_code','name','Gweru Provincial Hospital'),(3490,2607,'en','name','Mind Research Network'),(3491,2608,'en','name','Tan Tock Seng Hospital'),(3492,2608,'ms','name','Hospital Tan Tock Seng'),(3493,2608,'ta','name','மருத்துவமனையில்ல்'),(3494,2608,'zh','name','陈笃生医院'),(3495,2609,'en','name','Urmia University'),(3496,2609,'fa','name','دانشگاه ارومیه'),(3497,2610,'en','name','Kettering General Hospital'),(3498,2611,'en','name','Mayville State University'),(3499,2612,'en','name','Rani Durgavati University'),(3500,2613,'en','name','Iowa Department of Public Health'),(3501,2614,'en','name','RTI Health Solutions'),(3502,2615,'no','name','Privatsykehuset Haugesund'),(3503,2616,'en','name','American Academy of Orthopaedic Surgeons'),(3504,2617,'en','name','Michigan State Medical Society'),(3505,2618,'en','name','Kaiser Permanente South San Francisco Medical Center'),(3506,2619,'en','name','Zhongshan Hospital'),(3507,2619,'zh','name','中山医院'),(3508,2620,'en','name','Kyonggi University'),(3509,2620,'ko','name','경기대학교'),(3510,2621,'bg','name','Военномедицинска академия'),(3511,2621,'en','name','Military Medical Academy'),(3512,2622,'en','name','Bronson Methodist Hospital'),(3513,2623,'ja','name','宮田眼科病院'),(3514,2623,'no_lang_code','name','Miyata Eye Hospital'),(3515,2624,'no_lang_code','name','McPhee Research (United States)'),(3516,2625,'no_lang_code','name','Suez (Canada)'),(3517,2626,'en','name','Institute of Higher Studies of Fafe'),(3518,2626,'pt','name','Instituto de Estudos Superiores de Fafe LDA'),(3519,2627,'en','name','Tokushima Red Cross Hospital'),(3520,2627,'ja','name','徳島赤十字病院'),(3521,2628,'en','name','Fukuyama Cardiovascular Hospital'),(3522,2628,'ja','name','福山循環器病院'),(3523,2629,'en','name','Royal Hospital Haslar'),(3524,2630,'no_lang_code','name','Creusot-Loire Entreprises (France)'),(3525,2631,'bg','name','Лесотехнически университет'),(3526,2631,'en','name','University of Forestry'),(3527,2632,'en','name','Institute of Dermatology & Venereology of the Yunnan Province'),(3528,2633,'en','name','Belmont University'),(3529,2634,'es','name','Tekniker'),(3530,2635,'it','name','Policlinico Universitario di Catania'),(3531,2636,'en','name','General Hospital of Shenyang Military Region'),(3532,2636,'zh','name','中国人民解放军沈阳军区总医院'),(3533,2637,'en','name','Changzhi Medical College'),(3534,2637,'zh','name','长治医学院'),(3535,2638,'ja','name','東京都済生会中央病院'),(3536,2638,'no_lang_code','name','Saiseikai Central Hospital'),(3537,2639,'en','name','Durham VA Medical Center'),(3538,2640,'en','name','Maine Medical Center'),(3539,2641,'en','name','Amarillo VA Health Care System'),(3540,2642,'en','name','Chandka Medical College'),(3541,2643,'en','name','Utah Department of Health'),(3542,2644,'no_lang_code','name','NuvOx Pharma (United States)'),(3543,2645,'de','name','Empirica. Gesellschaft für Kommunikations- und Technologieforschung'),(3544,2645,'en','name','empirica - Communication and Technology Research'),(3545,2646,'en','name','Dallas VA Medical Center'),(3546,2647,'en','name','North Carolina Division of Public Health'),(3547,2648,'tr','name','Özel Trakya Hastanesi'),(3548,2649,'en','name','Orenburg State Medical Academy'),(3549,2649,'ru','name','Оренбургский государственный медицинский университет'),(3550,2650,'tr','name','Ergani Devlet Hastanesi'),(3551,2651,'en','name','Shinkyo Hospital'),(3552,2652,'pt','name','Hospital Curry Cabral'),(3553,2653,'en','name','Sydney South West Area Health Service'),(3554,2654,'no_lang_code','name','Kinexus Bioinformatics Corporation (Canada)'),(3555,2655,'en','name','Medical Products Agency'),(3556,2655,'sv','name','Läkemedelsverket'),(3557,2656,'en','name','Ministry of Health'),(3558,2657,'en','name','Lincoln Medical Center'),(3559,2658,'en','name','World Health Organization - Australia'),(3560,2659,'no_lang_code','name','Tecnatom (Spain)'),(3561,2660,'no_lang_code','name','Orange (France)'),(3562,2661,'en','name','New York Hall of Science'),(3563,2662,'en','name','Hyogo Social Welfare Corporation'),(3564,2662,'ja','name','兵庫県立リハビリテーション中央病院'),(3565,2663,'no_lang_code','name','Membrane Technology & Research (United States)'),(3566,2664,'en','name','Security Forces Hospital'),(3567,2665,'en','name','St John of Jerusalem Eye Hospital Group'),(3568,2666,'en','name','Keimyung University Dongsan Medical Center'),(3569,2666,'ko','name','계명대학교 동산의료원'),(3570,2667,'en','name','Kunming University'),(3571,2667,'zh','name','昆明学院'),(3572,2668,'en','name','Beijing Jishuitan Hospital'),(3573,2668,'zh','name','北京市创伤骨科研究所'),(3574,2669,'de','name','Kinderspital Zürich'),(3575,2669,'en','name','University Children\'s Hospital Zurich'),(3576,2670,'en','name','Al-Sabah Hospital'),(3577,2671,'en','name','Audie L. Murphy Memorial VA Hospital'),(3578,2672,'en','name','Consortium For Mathematics & Its Applications'),(3579,2673,'en','name','Eastern Illinois University'),(3580,2673,'fr','name','Université de l\'illinois de l\'est'),(3581,2674,'en','name','Oklahoma Medical Research Foundation'),(3582,2675,'en','name','LDS Hospital'),(3583,2676,'en','name','United Kingdom Atomic Energy Authority'),(3584,2677,'en','name','Ministry of Health'),(3585,2678,'nl','name','Stichting Technasium'),(3586,2679,'en','name','Denizli State Hospital'),(3587,2679,'tr','name','Denizli Devlet Hastanesi'),(3588,2680,'no_lang_code','name','HEF Groupe (France)'),(3589,2681,'en','name','Eulji University Hospital'),(3590,2681,'ko','name','을지대학교병원'),(3591,2682,'en','name','East Central University'),(3592,2683,'nl','name','Atrium Medisch Centrum Parkstad'),(3593,2684,'en','name','China Medical University Hospital'),(3594,2685,'no_lang_code','name','Nanchang Hangkong University'),(3595,2685,'zh','name','南昌航空大学'),(3596,2686,'en','name','Slippery Rock University'),(3597,2687,'en','name','Baltimore VA Medical Center'),(3598,2688,'en','name','Washington University Medical Center'),(3599,2689,'en','name','Niigata Prefectural Museum of History'),(3600,2689,'ja','name','新潟県立歴史博物館'),(3601,2690,'pt','name','Hospital do Desterro'),(3602,2691,'es','name','Hospital Santa Caterina'),(3603,2692,'en','name','Banff Mineral Springs Hospital'),(3604,2693,'en','name','Ministry of Health'),(3605,2694,'en','name','Carilion Roanoke Memorial Hospital'),(3606,2695,'en','name','Greenwich Hospital'),(3607,2696,'en','name','Monash Medical Centre'),(3608,2697,'en','name','Southern Arkansas University'),(3609,2698,'en','name','Educational Commission for Foreign Medical Graduates'),(3610,2699,'ar','name','مستشفى الأردن'),(3611,2699,'no_lang_code','name','Jordan Hospital'),(3612,2700,'en','name','Kemerovo State University'),(3613,2700,'ru','name','Кемеровский государственный университет'),(3614,2701,'pt','name','Fundação Ricardo do Espírito Santo Silva'),(3615,2702,'en','name','Gifu Pharmaceutical University'),(3616,2702,'ja','name','岐阜薬科大学'),(3617,2703,'en','name','Kongju National University'),(3618,2703,'ko','name','공주대학교'),(3619,2704,'en','name','Children\'s Hospital of Pittsburgh'),(3620,2705,'en','name','Haskell Indian Nations University'),(3621,2706,'en','name','Catholic University of Pelotas'),(3622,2706,'pt','name','Universidade Católica de Pelotas'),(3623,2707,'en','name','Lewis University'),(3624,2708,'en','name','Himeji Medical Center'),(3625,2708,'ja','name','独立行政法人 国立病院機構 姫路医療センター'),(3626,2709,'en','name','Handa City Hospital'),(3627,2709,'ja','name','半田市立半田病院'),(3628,2710,'en','name','Nizhny Novgorod State Technical University'),(3629,2710,'ru','name','Нижегородский государственный технический университет'),(3630,2711,'en','name','Shriners Hospitals for Children - Houston'),(3631,2712,'en','name','Regional West Medical Center'),(3632,2713,'en','name','Japanese Red Cross Asahikawa Hospital'),(3633,2713,'ja','name','旭川赤十字病院'),(3634,2714,'no_lang_code','name','Pera (United Kingdom)'),(3635,2715,'no_lang_code','name','Xstrata (United Kingdom)'),(3636,2716,'no_lang_code','name','Pinnacle Technology'),(3637,2717,'no_lang_code','name','Physical Optics Corporation'),(3638,2718,'en','name','Buddhist Tzu Chi General Hospital'),(3639,2719,'en','name','National Academy of Agricultural Science'),(3640,2719,'ko','name','국립농업과학원'),(3641,2720,'en','name','Shatin Hospital'),(3642,2720,'zh','name','沙田醫院'),(3643,2721,'en','name','Imelda Hospital'),(3644,2721,'nl','name','Imelda ziekenhuis'),(3645,2722,'en','name','Memorial Hermann Institute for Rehabilitation and Research Foundation'),(3646,2723,'en','name','University of the District of Columbia'),(3647,2723,'fr','name','Université du district de columbia'),(3648,2724,'de','name','Klinikum Ludwigshafen'),(3649,2725,'en','name','Kolding Hospital'),(3650,2726,'en','name','Baptist Medical Center Jacksonville'),(3651,2727,'tr','name','Etlik Zübeyde Hanım Kadın Hastalıkları Eğitim ve Araştırma Hastanesi'),(3652,2728,'en','name','Ealing Hospital NHS Trust'),(3653,2729,'es','name','Hospital Riotinto'),(3654,2730,'en','name','Nambu University'),(3655,2731,'en','name','Dr Gray\'s Hospital'),(3656,2732,'en','name','Gladstone Institutes'),(3657,2733,'en','name','National Center for Drug Screening'),(3658,2733,'zh','name','国家新药筛选中心'),(3659,2734,'en','name','Guangxi Maternal and Child Health Hospital'),(3660,2734,'zh','name','广西妇幼保健院'),(3661,2735,'en','name','Center for High Pressure Science and Technology Advanced Research'),(3662,2735,'zh','name','北京高压科学研究中心'),(3663,2736,'en','name','Altai State Technical University'),(3664,2736,'ru','name','Алтайский государственный технический университет имени И. И. Ползунова'),(3665,2737,'en','name','Okayama Prefectural University'),(3666,2737,'ja','name','岡山県立大学'),(3667,2738,'en','name','Kunming Medical University'),(3668,2738,'zh','name','昆明医科大学'),(3669,2739,'en','name','Poudre Valley Hospital'),(3670,2740,'ja','name','株式会社カネカ'),(3671,2740,'no_lang_code','name','Kaneka (Japan)'),(3672,2741,'en','name','Northrop University'),(3673,2742,'en','name','National Wildlife Health Center'),(3674,2743,'hi','name','कुमाऊँ विश्वविद्यालय'),(3675,2743,'no_lang_code','name','Kumaun University'),(3676,2743,'ta','name','குமாவுன் பல்கலைக்கழகம்'),(3677,2744,'en','name','Shinmatsudo Central General Hospital'),(3678,2744,'ja','name','新松戸中央総合病院'),(3679,2745,'en','name','UPMC Hamot'),(3680,2746,'en','name','National Satellite Ocean Application Service'),(3681,2746,'zh','name','国家卫星海洋应用中心'),(3682,2747,'tr','name','Izmir Tepecik Eğitim ve Araştırma Hastanesi'),(3683,2748,'en','name','Shanghai Institute of Hypertension'),(3684,2749,'en','name','Natividad Medical Center'),(3685,2750,'en','name','National Academy of Sciences'),(3686,2751,'no_lang_code','name','Nerviano Medical Sciences'),(3687,2752,'en','name','Olivet Nazarene University'),(3688,2753,'en','name','Lovelace Respiratory Research Institute'),(3689,2754,'no_lang_code','name','IM Systems (United States)'),(3690,2755,'en','name','Rapid City Regional Hospital'),(3691,2756,'en','name','Delaware County Memorial Hospital'),(3692,2757,'en','name','Charles R. Drew University of Medicine and Science'),(3693,2758,'en','name','Inner Mongolia Medical College Hospital'),(3694,2758,'zh','name','内蒙古医科大学附属医院'),(3695,2759,'en','name','Kaiser Permanente Santa Clara Medical Center'),(3696,2760,'en','name','Youngstown State University'),(3697,2761,'no_lang_code','name','Habib hospital Thameur'),(3698,2762,'en','name','Allergy and Asthma Medical Group and Research Center'),(3699,2763,'en','name','Borgess Medical Center'),(3700,2764,'fr','name','Hôpital Louis Pradel'),(3701,2765,'en','name','First Affiliated Hospital of Chinese PLA General Hospital'),(3702,2765,'zh','name','中国人民解放军总医院第一附属医院'),(3703,2766,'en','name','Clark Atlanta University'),(3704,2767,'es','name','Hospital Muñiz, Hospital de Infecciosas “Dr. Francisco Javier Muñiz\"'),(3705,2768,'no_lang_code','name','Weyerhauser (Canada)'),(3706,2769,'it','name','Ospedale Infermi di Rimini'),(3707,2770,'en','name','Ninewells Hospital'),(3708,2771,'no_lang_code','name','Dhaka Shishu Hospital'),(3709,2772,'en','name','LeMoyne–Owen College'),(3710,2773,'pt','name','Instituto Português de Administração de Marketing'),(3711,2774,'en','name','Municipal Institute for Medical Research'),(3712,2775,'en','name','Springfield Technical Community College'),(3713,2776,'en','name','Capital and Coast District Health Board'),(3714,2777,'en','name','Bangkok Hospital'),(3715,2777,'th','name','โรงพยาบาลกรุงเทพ'),(3716,2778,'en','name','Third Affiliated Hospital of Zhengzhou University'),(3717,2778,'zh','name','郑州大学第三附属医院'),(3718,2779,'en','name','Dongduk Women\'s University'),(3719,2779,'ko','name','동덕여자대학교'),(3720,2780,'en','name','Edward Francis Small Teaching Hospital'),(3721,2781,'be','name','Гродзенскі дзяржаўны медыцынскі універсітэт'),(3722,2781,'en','name','Grodno State Medical University'),(3723,2781,'ru','name','Гродненский государственный медицинский университет'),(3724,2782,'en','name','County Hospital'),(3725,2783,'en','name','Sri Venkateswara Institute of Medical Sciences'),(3726,2784,'en','name','Sree Balaji Dental College and Hospital'),(3727,2785,'en','name','Queen Elizabeth the Queen Mother Hospital'),(3728,2786,'en','name','University Institute of European Studies'),(3729,2786,'it','name','Istituto Universitario di Studi Europei'),(3730,2787,'en','name','Jikei University School of Medicine'),(3731,2787,'ja','name','東京慈恵会医科大学'),(3732,2788,'en','name','Integral University'),(3733,2788,'fr','name','Université intégrale de lucknow'),(3734,2788,'hi','name','इंटीग्रल विश्वविद्यालय'),(3735,2789,'en','name','Canadian Space Agency'),(3736,2789,'fr','name','Agence spatiale canadienne'),(3737,2790,'en','name','Kätilöopisto Maternity Hospital'),(3738,2791,'en','name','Health Protection Surveillance Centre'),(3739,2791,'ga','name','Lárionad Faire um Chosaint Sláinte'),(3740,2792,'en','name','Augustana University'),(3741,2793,'en','name','Queensborough Community College, CUNY'),(3742,2794,'pt','name','Universidade do Oeste de Santa Catarina'),(3743,2795,'en','name','Lurie Children\'s Hospital'),(3744,2796,'es','name','Hospital Del Mar'),(3745,2797,'en','name','KLE University'),(3746,2798,'en','name','American Society For Engineering Education'),(3747,2799,'en','name','North Memorial Health Care'),(3748,2800,'pt','name','Universidade Estadual de Ciências da Saúde de Alagoas'),(3749,2801,'no_lang_code','name','Allied Technology (United States)'),(3750,2802,'sv','name','Helsingborgs lasarett'),(3751,2803,'en','name','Christian Brothers University'),(3752,2804,'en','name','Queen\'s Medical Centre'),(3753,2805,'en','name','Martin Luther King, Jr. Multi-Service Ambulatory Care Center'),(3754,2806,'en','name','Coney Island Hospital'),(3755,2807,'en','name','University of California San Diego Medical Center'),(3756,2808,'no_lang_code','name','Arup Group (United States)'),(3757,2809,'en','name','Police General Hospital'),(3758,2809,'th','name','โรงพยาบาลตำรวจ'),(3759,2810,'en','name','Kagawa Nutrition University'),(3760,2810,'ja','name','女子栄養大学'),(3761,2811,'en','name','Ayub Medical College'),(3762,2812,'en','name','Diana Princess of Wales Hospital'),(3763,2813,'en','name','Saint Michael\'s College'),(3764,2814,'es','name','Hospital Padre Hurtado'),(3765,2815,'en','name','University of Mary Washington'),(3766,2815,'fr','name','Université de mary washington'),(3767,2816,'en','name','Educational Testing Service'),(3768,2817,'en','name','Southern University System'),(3769,2818,'es','name','Hospital Vargas'),(3770,2819,'en','name','Colmery-O\'Neil VA Medical Center'),(3771,2820,'en','name','Post Graduate Medical Institute'),(3772,2821,'en','name','Ladoke Akintola University of Technology Teaching Hospital'),(3773,2822,'en','name','Arkansas Tech University'),(3774,2823,'en','name','Beckman Laser Institute and Medical Clinic'),(3775,2824,'en','name','American Public Health Association'),(3776,2825,'no_lang_code','name','Tata Steel (United Kingdom)'),(3777,2826,'en','name','Institute for Medical Research'),(3778,2827,'no_lang_code','name','Barrick Gold (Canada)'),(3779,2828,'no_lang_code','name','National Institute of Technology'),(3780,2829,'en','name','Queen Victoria Hospital NHS Foundation Trust'),(3781,2830,'en','name','Shaukat Khanum Memorial Cancer Hospital and Research Center'),(3782,2830,'ur','name','شوکت خانم یادگاری سرطان شفاخانہ اور مرکز تحقیق'),(3783,2831,'en','name','National Taiwan Ocean University'),(3784,2832,'it','name','Fondazione Eni Enrico Mattei'),(3785,2833,'en','name','Slovak National Library'),(3786,2833,'sk','name','Slovenska Narodna Kniznica, Slovenská národná knižnica'),(3787,2834,'en','name','Kyushu Dental University'),(3788,2834,'ja','name','九州歯科大学'),(3789,2835,'en','name','Cancer Prevention Institute of California'),(3790,2836,'en','name','Chonbuk National University Hospital'),(3791,2837,'en','name','Clarke University'),(3792,2838,'en','name','UPMC Montefiore'),(3793,2839,'en','name','175th Hospital of People\'s Liberation Army'),(3794,2839,'zh','name','解放军第175医院'),(3795,2840,'no_lang_code','name','One Cell Systems (United States)'),(3796,2841,'en','name','Gifu Prefectural General Medical Center'),(3797,2841,'ja','name','岐阜県総合医療センター'),(3798,2842,'en','name','General University Hospital of Patras'),(3799,2843,'en','name','National Academy for State Health Policy'),(3800,2844,'en','name','Ehime Prefectural Central Hospital'),(3801,2844,'ja','name','愛媛県立中央病院'),(3802,2845,'en','name','Sri Aurobindo Institute of Medical Sciences'),(3803,2846,'en','name','Cathay General Hospital'),(3804,2847,'en','name','Sewickley Valley Hospital'),(3805,2848,'en','name','University of Western States'),(3806,2849,'tr','name','SSK İhtisas Hastanesi'),(3807,2850,'en','name','Lakeland Regional Medical Center'),(3808,2851,'en','name','Nassau University Medical Center'),(3809,2852,'en','name','California Institute for Medical Research'),(3810,2853,'en','name','VA Sierra Nevada Health Care System'),(3811,2854,'ja','name','川崎病院'),(3812,2854,'no_lang_code','name','Kawasaki Hospital'),(3813,2855,'en','name','Coe College'),(3814,2856,'en','name','Hope College'),(3815,2857,'en','name','Royal Hospital'),(3816,2858,'pt','name','Hospital Municipal Souza Aguiar'),(3817,2859,'en','name','Craigavon Area Hospital'),(3818,2860,'en','name','Connecticut Department of Public Health'),(3819,2861,'en','name','Muhlenberg College'),(3820,2862,'pt','name','Universidade Estadual do Centro-Oeste'),(3821,2863,'en','name','First Affiliated Hospital of Wenzhou Medical University'),(3822,2864,'no_lang_code','name','Electrosynthesis Company (United States)'),(3823,2865,'no_lang_code','name','Epoch Biosciences (United States)'),(3824,2866,'en','name','Maine Medical Center Research Institute'),(3825,2867,'en','name','Central Taiwan University of Science and Technology'),(3826,2868,'fr','name','Hôpital Xavier Arnozan'),(3827,2869,'en','name','National Neuroscience Institute'),(3828,2870,'pt','name','Escola Superior de Enfermagem de São José de Cluny'),(3829,2871,'en','name','Karnataka Institute of Medical Sciences'),(3830,2871,'kn','name','ಕರ್ನಾಟಕ ವೈದ್ಯಕೀಯ ವಿಜ್ಞಾನ ಸಂಸ್ಥೆ'),(3831,2872,'no_lang_code','name','Ross Video (Canada)'),(3832,2873,'en','name','Princess Royal University Hospital'),(3833,2874,'en','name','Illinois State Museum'),(3834,2875,'en','name','Northeast Radio Observatory Corporation'),(3835,2876,'en','name','Alaska Department of Health and Social Services'),(3836,2877,'no_lang_code','name','Pyrogenesis (Canada)'),(3837,2878,'en','name','Anhui Provincial Center for Disease Control and Prevention'),(3838,2878,'zh','name','安徽省疾病预防控制中心'),(3839,2879,'en','name','Research Centre for Medical Genetics'),(3840,2880,'it','name','Ospedale Generale Regionale Francesco Miulli'),(3841,2881,'en','name','Association of Science-Technology Centers'),(3842,2882,'en','name','East Jefferson General Hospital'),(3843,2883,'no_lang_code','name','Artann Laboratories, Inc.'),(3844,2884,'en','name','Grant Medical College and Sir Jamshedjee Jeejeebhoy Group of Hospitals'),(3845,2885,'en','name','Christ Hospital'),(3846,2886,'no_lang_code','name','Scimar Engineering Ltd'),(3847,2887,'en','name','Salem University'),(3848,2888,'no_lang_code','name','Systems, Applications & Products in Data Processing (Germany)'),(3849,2889,'ca','name','Hospital Mare de Déu de la Mercè'),(3850,2890,'en','name','Elazig Education and Research Hospital'),(3851,2890,'tr','name','Elazığ Eğitim ve Araştırma Hastanesi'),(3852,2891,'en','name','Maulana Azad Medical College'),(3853,2891,'ta','name','மௌலானா ஆசாத் மருத்துவக் கல்லூரி'),(3854,2892,'no_lang_code','name','Jamia Hamdard'),(3855,2893,'en','name','Royal National Orthopaedic Hospital NHS Trust'),(3856,2894,'en','name','DSO National Laboratories'),(3857,2895,'en','name','University of Minnesota Medical Center'),(3858,2896,'en','name','Florida Department of Health'),(3859,2897,'en','name','Donetsk State University of Management'),(3860,2897,'ru','name','Донецкий государственный университет управления'),(3861,2897,'uk','name','Донецький державний університет управління'),(3862,2898,'no_lang_code','name','Naresuan University'),(3863,2898,'th','name','มหาวิทยาลัยนเรศวร'),(3864,2899,'en','name','ABC Medical Center'),(3865,2899,'es','name','Centro Médico ABC'),(3866,2900,'en','name','Federal Medical Centre'),(3867,2901,'en','name','Gunma Prefectural Institute of Public Health and Environmental Sciences'),(3868,2901,'ja','name','群馬県衛生環境研究所'),(3869,2902,'de','name','Potsdam-Institut für Klimafolgenforschung'),(3870,2902,'en','name','Potsdam Institute for Climate Impact Research'),(3871,2903,'en','name','Bethesda North Hospital'),(3872,2904,'en','name','Boys Town'),(3873,2905,'en','name','Bogomolets National Medical University'),(3874,2905,'pl','name','Narodowy Medyczny Uniwersytet im. O.Bohomolca'),(3875,2905,'ru','name','Национальный медицинский университет имени А. А. Богомольца'),(3876,2905,'uk','name','Національний медичний університет імені Олександра Богомольця'),(3877,2906,'en','name','Teikyo University Chiba Medical Center'),(3878,2906,'ja','name','帝京大学ちば総合医療センター'),(3879,2907,'it','name','A. O. Ordine Mauriziano di Torino'),(3880,2908,'en','name','Shanghai Changning Mental Health Center'),(3881,2908,'zh','name','长宁区精神卫生中心'),(3882,2909,'pt','name','Hospital de Clínicas Universidade Federal do Paraná'),(3883,2910,'en','name','Winthrop-University Hospital'),(3884,2911,'en','name','Antioch University'),(3885,2912,'en','name','California State University, Fresno'),(3886,2912,'fr','name','Université d\'État de Californie à Fresno'),(3887,2913,'da','name','Dronning Ingrids Hospital'),(3888,2913,'en','name','Queen Ingrid\'s Hospital'),(3889,2914,'en','name','Moisio Hospital'),(3890,2914,'fi','name','Moision Sairaala'),(3891,2915,'en','name','Loma Linda University Medical Center'),(3892,2915,'fr','name','Centre médical universitaire de loma linda'),(3893,2916,'en','name','East Tennessee Children\'s Hospital'),(3894,2917,'en','name','Ewha Womans University Medical Center'),(3895,2917,'ko','name','이화여자대학교 목동병원'),(3896,2918,'en','name','Littlemore Hospital'),(3897,2919,'en','name','Iwate Biotechnology Research Center'),(3898,2919,'ja','name','財団法人 岩手生物工学研究センター'),(3899,2920,'en','name','Saint Thomas Midtown Hospital'),(3900,2921,'en','name','National University of Asuncion'),(3901,2921,'es','name','Universidad Nacional de Asunción'),(3902,2922,'en','name','Somali National University'),(3903,2922,'it','name','Università nazionale somala'),(3904,2922,'so','name','Jaamacada Ummada Soomaaliyeed'),(3905,2923,'ja','name','榛原総合病院'),(3906,2923,'no_lang_code','name','Haibara General Hospital'),(3907,2924,'en','name','Museum of the Earth'),(3908,2925,'pt','name','Instituto Superior Dom Afonso III'),(3909,2926,'en','name','Methodist University'),(3910,2927,'en','name','Colorado Permanente Medical Group'),(3911,2928,'no_lang_code','name','Bombardier (Canada)'),(3912,2929,'en','name','Providence University'),(3913,2929,'zh','name','靜宜大學'),(3914,2930,'en','name','Tougaloo College'),(3915,2931,'en','name','Hardin–Simmons University'),(3916,2932,'en','name','Kagawa National Children\'s Hospital'),(3917,2932,'ja','name','国立病院機構香川小児病院'),(3918,2933,'en','name','Novant Health Presbyterian Medical Center'),(3919,2934,'ar','name','جامعة بنغازي'),(3920,2934,'en','name','University of Benghazi'),(3921,2935,'en','name','Center for Molecular Medicine and Immunology'),(3922,2936,'en','name','University of the West Indies'),(3923,2937,'en','name','Black Hills State University'),(3924,2938,'es','name','Hospital Juan Ramón Jiménez'),(3925,2939,'en','name','University of Uyo Teaching Hospital'),(3926,2940,'en','name','Institute of Fundamental Technological Research'),(3927,2940,'pl','name','Instytut Podstawowych Problemów Techniki'),(3928,2941,'en','name','Saitama International Medical Center'),(3929,2941,'ja','name','埼玉医科大学国際医療センター'),(3930,2942,'en','name','Lokmanya Tilak Municipal General Hospital and Lokmanya Tilak Municipal Medical College'),(3931,2943,'en','name','Baptist Health Louisville'),(3932,2944,'en','name','Sentara Norfolk General Hospital'),(3933,2945,'en','name','Shanghai Institute of Hematology'),(3934,2945,'zh','name','上海血液学研究所'),(3935,2946,'hu','name','Markusovszky Egyetemi Oktatókórház'),(3936,2947,'es','name','Hospital Universitari Sagrat Cor'),(3937,2948,'no_lang_code','name','3M (Canada)'),(3938,2949,'en','name','Delaware State University'),(3939,2950,'en','name','University of Birjand'),(3940,2950,'fa','name','دانشگاه بیرجند'),(3941,2951,'fi','name','Keski-Pohjanmaan keskussairaala'),(3942,2952,'el','name','ΠΑΝΕΠΙΣΤΗΜΙΑΚΟ ΓΕΝΙΚΟ ΝΟΣΟΚΟΜΕΙΟ \"ΑΤΤΙΚΟΝ\"'),(3943,2952,'en','name','University General Hospital Attikon'),(3944,2953,'en','name','Holmes Regional Medical Center'),(3945,2954,'ar','name','مدينة الشيخ خليفة الطبية'),(3946,2954,'en','name','Shaikh Khalifa Medical City'),(3947,2955,'en','name','Sher-i-Kashmir Institute of Medical Sciences'),(3948,2955,'ur','name','شیرِ کشمیر انسٹیچیوٹ آف میڈیکل سائنسز'),(3949,2956,'en','name','Al-Ameen Medical College'),(3950,2957,'en','name','Sheppard and Enoch Pratt Hospital'),(3951,2958,'en','name','Nordic School of Public Health'),(3952,2959,'no_lang_code','name','Sierra Wireless (Canada)'),(3953,2960,'en','name','Kaohsiung Medical University'),(3954,2961,'en','name','World Technology Evaluation Center'),(3955,2962,'en','name','Jacobs Institute of Women\'s Health'),(3956,2963,'en','name','University Centre of Legal Medicine'),(3957,2964,'en','name','Clinical Emergency Hospital Bucharest'),(3958,2964,'ro','name','Spitalul Clinic de Urgenta Bucuresti'),(3959,2965,'en','name','Diego Portales University'),(3960,2965,'es','name','Universidad Diego Portales'),(3961,2966,'no_lang_code','name','Edendale Hospital'),(3962,2967,'it','name','Ospedale Annunziata di Cosenza'),(3963,2968,'en','name','Argerich Hospital'),(3964,2969,'en','name','Saint Francis Hospital & Medical Center'),(3965,2970,'en','name','Oxford University Hospitals NHS Trust'),(3966,2971,'no_lang_code','name','Matériaux Blanchet'),(3967,2972,'es','name','Hospital Pediátrico Moctezuma'),(3968,2973,'en','name','Lehigh Valley Hospital'),(3969,2974,'en','name','Connolly Hospital Blanchardstown'),(3970,2974,'ga','name','Ospidéal Uí Chonghaile, Baile Bhlainséir'),(3971,2975,'en','name','University of Massachusetts Lowell'),(3972,2975,'es','name','Universidad de Massachusetts Lowell'),(3973,2976,'fr','name','Université Félix Houphouët-Boigny'),(3974,2977,'no_lang_code','name','Therapeutics Systems Research Laboratories (United States)'),(3975,2978,'it','name','Ospedale Sandro Pertini'),(3976,2979,'en','name','Legacy Emanuel Medical Center'),(3977,2980,'no_lang_code','name','Advanced Liquid Logic'),(3978,2981,'en','name','Newton Wellesley Hospital'),(3979,2982,'en','name','Bibra International'),(3980,2983,'en','name','UCSF Benioff Children\'s Hospital'),(3981,2984,'en','name','Harvard Vanguard Medical Associates'),(3982,2985,'en','name','Philadelphia VA Medical Center'),(3983,2986,'en','name','Slade Hospital'),(3984,2987,'en','name','Beijing Great Wall Hospital'),(3985,2987,'zh','name','北京市长城医院'),(3986,2988,'en','name','Magellan Health'),(3987,2989,'en','name','University HealthSystem Consortium'),(3988,2990,'el','name','\'\'Καραμανδάνειο\'\' Γενικό Νοσοκομείο Παίδων Πατρών'),(3989,2990,'en','name','General Hospital Pediatric Karamandanio'),(3990,2991,'en','name','M.S. Ramaiah Medical College'),(3991,2992,'fr','name','Hôpital Ambroise-Paré'),(3992,2993,'en','name','Kaiser Foundation Hospital'),(3993,2994,'en','name','Shizuoka Red Cross Hospital'),(3994,2994,'ja','name','静岡赤十字病院'),(3995,2995,'ja','name','北海道中央病院'),(3996,2995,'no_lang_code','name','Hokkaido Central Hospital'),(3997,2996,'en','name','Geisinger Medical Center'),(3998,2997,'en','name','MedStar Georgetown University Hospital'),(3999,2998,'en','name','Doctors Hospital'),(4000,2999,'en','name','Elliot Hospital'),(4001,3000,'fa','name','بیمارستان میلاد'),(4002,3000,'no_lang_code','name','Milad Hospital'),(4003,3001,'en','name','Dwight D. Eisenhower VA Medical Center'),(4004,3002,'en','name','First Affiliated Hospital of Chengdu Medical College'),(4005,3002,'zh','name','成都医学院第一附属医院'),(4006,3003,'en','name','National Maternity Hospital'),(4007,3004,'en','name','Kobe Children\'s Hospital'),(4008,3004,'ja','name','兵庫県立こども病院'),(4009,3005,'it','name','Ospedale G.B. Morgagni - L.Pierantoni'),(4010,3006,'en','name','Luodong Poh-Ai Hospital'),(4011,3006,'zh','name','羅東博愛醫院'),(4012,3007,'en','name','Cone Health'),(4013,3008,'en','name','Shigei Medical Research Institute'),(4014,3008,'ja','name','重井医学研究所'),(4015,3009,'en','name','Dorothea Dix Hospital'),(4016,3010,'en','name','Abington Memorial Hospital'),(4017,3011,'en','name','Center for Information Technology'),(4018,3012,'en','name','Museum Of Northern Arizona'),(4019,3013,'en','name','Motilal Nehru Medical College'),(4020,3014,'en','name','Agency for Healthcare Research and Quality'),(4021,3015,'en','name','Guangdong General Hospital'),(4022,3015,'zh','name','广东省老年医学研究所'),(4023,3016,'cy','name','Ysbyty Glan Clwyd'),(4024,3016,'en','name','Glan Clwyd Hospital'),(4025,3017,'pt','name','Instituto de Soldadura e Qualidade'),(4026,3018,'pt','name','Hospital da Luz'),(4027,3019,'no_lang_code','name','GlaxoSmithKline (China)'),(4028,3020,'en','name','University of Agricultural Sciences, Bangalore'),(4029,3021,'pt','name','Dr. Euryclides Hospital de Jesus Zerbini'),(4030,3022,'de','name','Universitätskliniken Salzburg'),(4031,3023,'no_lang_code','name','Lynntech (United States)'),(4032,3024,'no_lang_code','name','Aphios Corporation'),(4033,3025,'en','name','The Open University of Japan'),(4034,3025,'ja','name','放送大学'),(4035,3026,'no_lang_code','name','SNC-Lavalin (Canada)'),(4036,3027,'en','name','Indiana State Department of Education'),(4037,3028,'en','name','National Center of Biomedical Analysis'),(4038,3028,'zh','name','国家生物医学分析中心'),(4039,3029,'en','name','Friarage Hospital'),(4040,3030,'el','name','Γεωπονικό πανεπιστήμιο Τιράνων'),(4041,3030,'en','name','Agricultural University of Tirana'),(4042,3030,'sq','name','Universiteti Bujqësor i Tiranës'),(4043,3031,'en','name','Health South Rehabilitation Hospital'),(4044,3032,'bn','name','পশ্চিমবঙ্গ প্রাণী ও মৎস্যবিজ্ঞান বিশ্ববিদ্যালয়'),(4045,3032,'en','name','West Bengal University of Animal and Fishery Sciences'),(4046,3032,'hi','name','पश्चिम बंगाल मत्स्य एवं पशुपालन विज्ञान विश्वविद्यालय'),(4047,3033,'en','name','National Institute of Statistical Sciences'),(4048,3034,'en','name','Iwakuni Medical Center'),(4049,3034,'ja','name','岩国医療センター'),(4050,3035,'en','name','University of Southern Maine'),(4051,3036,'ar','name','جامعة العرب الطبية'),(4052,3036,'en','name','Al-Arab Medical University'),(4053,3037,'en','name','Genome Research Foundation'),(4054,3038,'en','name','Pondicherry Institute of Medical Sciences'),(4055,3039,'en','name','New Jersey Department of Health'),(4056,3039,'es','name','Departamento de Salud y Servicios para las Personas Mayores del Estado de Nueva Jersey'),(4057,3040,'en','name','Herttoniemi Hospital'),(4058,3041,'en','name','MRC Unit for Lifelong Health and Ageing'),(4059,3042,'en','name','Inova Alexandria Hospital'),(4060,3043,'no_lang_code','name','MPC Computers (United States)'),(4061,3044,'bn','name','আলিগড় মুসলিম বিশ্ববিদ্যালয়'),(4062,3044,'en','name','Aligarh Muslim University'),(4063,3044,'fr','name','Université musulmane d\'aligarh'),(4064,3044,'hi','name','अलीगढ़ मुस्लिम विश्वविद्यालय'),(4065,3044,'kn','name','ಅಲಿಘರ್ ಮುಸ್ಲಿಮ್ ವಿಶ್ವವಿದ್ಯಾಲಯ'),(4066,3044,'ml','name','അലിഗഢ് മുസ്ലിം സർവകലാശാല'),(4067,3044,'pa','name','ਅਲੀਗੜ ਮੁਸਲਿਮ ਯੂਨੀਵਰਸਿਟੀ'),(4068,3044,'ta','name','அலிகார் முஸ்லிம் பல்கலைக்கழகம்'),(4069,3044,'te','name','అలీఘర్ ముస్లిం విశ్వవిద్యాలయం'),(4070,3044,'ur','name','جامعہ علی گڑھ'),(4071,3045,'en','name','MedStar Good Samaritan Hospital'),(4072,3046,'de','name','Universitätsklinikum Magdeburg'),(4073,3046,'en','name','University Hospital Magdeburg'),(4074,3047,'fr','name','Centre Hospitalier Universitaire Hassan II'),(4075,3048,'en','name','Marianjoy Rehabilitation Hospital'),(4076,3049,'en','name','Morristown Medical Center'),(4077,3050,'en','name','Nebraska Department of Health and Human Services'),(4078,3051,'en','name','Lehman College'),(4079,3052,'en','name','Aichi University of Education'),(4080,3052,'ja','name','愛知教育大学'),(4081,3053,'tr','name','Izmir Atatürk Eğitim ve Araştırma Hastanesi'),(4082,3054,'en','name','Lahey Hospital and Medical Center'),(4083,3055,'en','name','Derbyshire Children\'s Hospital'),(4084,3056,'en','name','Amala Institute of Medical Sciences'),(4085,3056,'ml','name','അമല ഇൻസ്റ്റിട്ട്യൂട്ട് ഓഫ് മെഡിക്കൽ സയൻസസ്'),(4086,3057,'en','name','Hokushin General Hospital'),(4087,3057,'ja','name','北信総合病院'),(4088,3058,'en','name','King County Medical Examiner\'s Office'),(4089,3059,'en','name','Hangzhou Red Cross Hospital'),(4090,3059,'zh','name','杭州市红十字会医院'),(4091,3060,'en','name','Mater Health Services'),(4092,3061,'no_lang_code','name','Blackberry (Canada)'),(4093,3062,'en','name','University of Wisconsin–Eau Claire'),(4094,3062,'fr','name','Université du Wisconsin à Eau Claire'),(4095,3063,'en','name','Metropolitan State University of Denver'),(4096,3064,'en','name','MSPCA-Angell'),(4097,3065,'en','name','Minnesota State University Moorhead'),(4098,3065,'fr','name','Université d\'État du minnesota'),(4099,3066,'de','name','Europäisches Laboratorium für Molekularbiologie'),(4100,3066,'en','name','European Molecular Biology Laboratory'),(4101,3067,'en','name','Lyndon Baines Johnson Hospital'),(4102,3068,'es','name','Hospital San Juan de Dios'),(4103,3069,'it','name','Ospedale Cannizzaro'),(4104,3070,'no_lang_code','name','Arthur D. Little (Czechia)'),(4105,3071,'en','name','HCI International Medical Centre'),(4106,3072,'en','name','Ministry of Health Labour and Welfare'),(4107,3072,'ja','name','厚生労働省'),(4108,3073,'en','name','Charleston Southern University'),(4109,3074,'es','name','Hospital Montecelo'),(4110,3075,'en','name','Children\'s Hospital at Montefiore'),(4111,3076,'ms','name','Hospital Kuala Lumpur'),(4112,3077,'en','name','Awadhesh Pratap Singh University'),(4113,3077,'hi','name','अवधेश प्रताप सिंह विश्वविद्यालय'),(4114,3078,'en','name','South Texas Veterans Health Care System'),(4115,3079,'en','name','Elmhurst Hospital Center'),(4116,3080,'no_lang_code','name','Shuguang Hospital'),(4117,3081,'en','name','Medwin Hospital'),(4118,3082,'en','name','Anhui Provincial Hospital'),(4119,3083,'it','name','Ospedale G.F. Ingrassia'),(4120,3084,'no_lang_code','name','Ricerca sul Sistema Energetico (Italy)'),(4121,3085,'fr','name','Hôpital Avicenne'),(4122,3086,'es','name','Hospital Militar Dr. Carlos Arvelo'),(4123,3087,'ja','name','横浜労災病院'),(4124,3087,'no_lang_code','name','Yokohama Rosai Hospital'),(4125,3088,'fr','name','Hôpital Mère-Enfant'),(4126,3089,'no_lang_code','name','Jordanian Universities Network (Jordan)'),(4127,3090,'no_lang_code','name','Charles River Laboratories (United States)'),(4128,3091,'en','name','Flushing Hospital Medical Center'),(4129,3092,'en','name','Houston Health and Human Services Department'),(4130,3093,'en','name','University of Trinidad and Tobago'),(4131,3093,'es','name','Universidad de Trinidad y Tobago'),(4132,3094,'en','name','Queen Elizabeth Hospital'),(4133,3095,'ar','name','مستشفى القوات المسلحة بالشمالية'),(4134,3095,'en','name','North West Armed Forces Hospital'),(4135,3096,'en','name','Centinela Hospital Medical Center'),(4136,3097,'no_lang_code','name','General Electric (Denmark)'),(4137,3098,'en','name','National Taiwan University Hospital'),(4138,3099,'en','name','Shimane University Hospital'),(4139,3099,'ja','name','島根大学病院'),(4140,3100,'en','name','Alberta Hospital Edmonton'),(4141,3101,'no_lang_code','name','NovoMedix (United States)'),(4142,3102,'en','name','Cruces University Hospital'),(4143,3102,'es','name','Hospital de Cruces'),(4144,3103,'en','name','Health Net'),(4145,3104,'no_lang_code','name','Danya International, Inc.'),(4146,3105,'de','name','Universität Augsburg'),(4147,3105,'en','name','University of Augsburg'),(4148,3106,'en','name','Lincoln County Hospital'),(4149,3107,'ms','name','Hospital Selayang'),(4150,3108,'en','name','Lanzhou University of Technology'),(4151,3108,'zh','name','兰州理工大学'),(4152,3109,'tr','name','Haydarpaşa Numune Eğitim ve Araştırma Hastanesi'),(4153,3110,'en','name','Fooyin University'),(4154,3111,'en','name','Dhahran Health Center'),(4155,3112,'en','name','Kumamoto Health Science University'),(4156,3112,'ja','name','熊本保健科学大学'),(4157,3113,'ja','name','神鋼記念病院'),(4158,3113,'no_lang_code','name','Shinko Hospital'),(4159,3114,'en','name','Asian Institute of Gastroenterology'),(4160,3115,'en','name','Halton General Hospital'),(4161,3116,'sl','name','Splošna Bolnišnica Celje'),(4162,3117,'en','name','National Academy of Medical Sciences'),(4163,3118,'no_lang_code','name','Gangneung Asan Hospital'),(4164,3119,'en','name','Auburn University System'),(4165,3120,'en','name','Zoological Society of London'),(4166,3121,'en','name','Alberta Health'),(4167,3122,'it','name','Azienda Sanitaria Ospedaliera S.Croce e Carle Cuneo'),(4168,3123,'da','name','Sydvestjysk Sygehus'),(4169,3123,'en','name','Hospital South West Jutland'),(4170,3124,'en','name','Fujieda Municipal General Hospital'),(4171,3124,'ja','name','藤枝市立総合病院'),(4172,3125,'es','name','Hospital Can Misses'),(4173,3126,'no_lang_code','name','Neoleukin Therapeutics (Canada)'),(4174,3127,'ar','name','جامعة القاهرة'),(4175,3127,'en','name','Cairo University'),(4176,3127,'fr','name','Université du Caire'),(4177,3128,'en','name','MedStar National Rehabilitation Hospital'),(4178,3129,'en','name','Huizhou University'),(4179,3129,'zh','name','惠州学院'),(4180,3130,'en','name','South Dakota Foundation for Medical Care'),(4181,3131,'en','name','Haga Hospital'),(4182,3131,'nl','name','HagaZiekenhuis'),(4183,3132,'en','name','Ibaraki Prefectural Central Hospital'),(4184,3132,'ja','name','茨城県立中央病院'),(4185,3133,'sv','name','Capio Lundby Sjukhus'),(4186,3134,'ja','name','石巻専修大学'),(4187,3134,'no_lang_code','name','Ishinomaki Senshu University'),(4188,3135,'es','name','Universidad Centroccidental Lisandro Alvarado'),(4189,3136,'en','name','Dayton VA Medical Center'),(4190,3137,'en','name','Soonchunhyang University'),(4191,3137,'ko','name','순천향대학교'),(4192,3138,'en','name','Korea National University of Transportation'),(4193,3138,'ko','name','한국교통대학교'),(4194,3139,'en','name','Heilongjiang Provincial Hospital'),(4195,3139,'zh','name','黑龙江省医院'),(4196,3140,'en','name','Hirosaki National Hospital'),(4197,3140,'ja','name','国立病院機構弘前病院'),(4198,3141,'el','name','Υγεία'),(4199,3141,'no_lang_code','name','Hygeia Hospital'),(4200,3142,'en','name','Dong-A University'),(4201,3142,'ko','name','동아대학교'),(4202,3143,'en','name','Duran i Reynals Hospital'),(4203,3144,'pt','name','Hospital of St. Francis Xavier'),(4204,3145,'en','name','Little Company of Mary Hospital'),(4205,3146,'no_lang_code','name','Photon Imaging (United States)'),(4206,3147,'en','name','Idaho Department of Health and Welfare'),(4207,3148,'en','name','Robert Morris University'),(4208,3148,'es','name','Universidad Robert Morris'),(4209,3149,'de','name','Israelitisches Krankenhaus'),(4210,3150,'en','name','Ministry of Health'),(4211,3150,'id','name','Kementerian Kesehatan'),(4212,3151,'en','name','King Edward VIII Hospital'),(4213,3152,'en','name','Syrian-Lebanese Hospital'),(4214,3152,'pt','name','Hospital Sírio-Libanês'),(4215,3153,'en','name','Institute of Occupational Medicine'),(4216,3154,'en','name','Cambridge Hospital'),(4217,3155,'en','name','Saint Alphonsus Regional Medical Center'),(4218,3156,'en','name','Bronovo Hospital'),(4219,3156,'nl','name','Bronovo Ziekenhuis'),(4220,3157,'en','name','Tulane Lakeside Hospital'),(4221,3158,'en','name','Monmouth College'),(4222,3159,'en','name','Northampton General Hospital'),(4223,3160,'en','name','Day General Hospital'),(4224,3160,'fa','name','بیمارستان دی'),(4225,3161,'en','name','Good Samaritan Hospital'),(4226,3162,'ar','name','الجامعة الألمانية بالقاهرة'),(4227,3162,'en','name','German University in Cairo'),(4228,3163,'en','name','Children\'s Hospital Zagreb'),(4229,3163,'hr','name','Klinika za Djecje bolesti Zagreb'),(4230,3164,'en','name','Aga Khan University Hospital Nairobi'),(4231,3165,'ja','name','島根県立中央病院'),(4232,3165,'no_lang_code','name','Shimane Prefectural Central Hospital'),(4233,3166,'en','name','Royal Victoria Hospital'),(4234,3167,'en','name','Ivanovo State University'),(4235,3167,'ru','name','Ивановский государственный университет'),(4236,3168,'en','name','Armstrong Atlantic State University'),(4237,3169,'en','name','University of South Carolina System'),(4238,3170,'en','name','Maryland State Medical Society'),(4239,3171,'en','name','Carraway Methodist Medical Center'),(4240,3172,'it','name','Ospedale L. Bonomo'),(4241,3173,'en','name','Lancaster General Hospital'),(4242,3174,'en','name','Kawasaki University of Medical Welfare'),(4243,3174,'ja','name','川崎医療福祉大学'),(4244,3175,'en','name','Queen Elizabeth II Hospital'),(4245,3176,'it','name','Ospedale Bassini'),(4246,3177,'en','name','St Mary\'s Hospital'),(4247,3177,'fr','name','Centre hospitalier de St- Mary'),(4248,3178,'en','name','Asan Medical Center'),(4249,3178,'ko','name','서울아산병원'),(4250,3179,'en','name','VA NY Harbor Healthcare System'),(4251,3180,'en','name','Second Affiliated Hospital of Harbin Medical University'),(4252,3181,'en','name','HealthPartners'),(4253,3182,'no_lang_code','name','Kwong Wah Hospital'),(4254,3182,'zh','name','廣華醫院'),(4255,3183,'fr','name','Centre Hospitalier Universitaire Ibn Rochd'),(4256,3184,'en','name','Hallym University'),(4257,3184,'ko','name','한림대학교'),(4258,3185,'en','name','Hitachi General Hospital'),(4259,3185,'ja','name','日立総合病院'),(4260,3186,'en','name','Royal Orthopaedic Hospital'),(4261,3187,'en','name','University of São Paulo Faculty of Medicine Clinics Hospital'),(4262,3187,'pt','name','Hospital das Clínicas da Faculdade de Medicina da Universidade de São Paulo'),(4263,3188,'en','name','Showa Women\'s University'),(4264,3188,'ja','name','昭和女子大学'),(4265,3189,'en','name','Rockefeller Foundation'),(4266,3190,'en','name','BC Cancer Agency'),(4267,3191,'en','name','Kazan State Technological University'),(4268,3191,'ru','name','Казанский национальный исследовательский технологический университет'),(4269,3192,'en','name','Inouye Eye Hospital'),(4270,3192,'ja','name','井上眼科病院'),(4271,3193,'en','name','Point Blue Conservation Science'),(4272,3194,'en','name','Genesys Regional Medical Center'),(4273,3195,'en','name','Kagoshima University'),(4274,3195,'ja','name','鹿児島大学'),(4275,3196,'en','name','University of Mobile'),(4276,3196,'fr','name','Université de mobile'),(4277,3197,'en','name','Ottawa County Health Department'),(4278,3198,'es','name','Hospital General Universitario De Valencia'),(4279,3199,'en','name','International Women\'s Health Coalition'),(4280,3200,'en','name','First Affiliated Hospital of Anhui Medical University'),(4281,3201,'en','name','Rancho Los Amigos National Rehabilitation Center'),(4282,3202,'en','name','Substance Abuse and Mental Health Services Administration'),(4283,3203,'no_lang_code','name','Hypres (United States)'),(4284,3204,'ro','name','Spitalul Clinic de Urgenta Sfantul Ioan'),(4285,3205,'en','name','Regional Medical Center'),(4286,3206,'en','name','Public Health Foundation Enterprises'),(4287,3207,'en','name','Rampton Hospital'),(4288,3208,'en','name','Shandong Eye Institute & Hospital'),(4289,3208,'zh','name','山东省眼科研究所青岛与医院'),(4290,3209,'en','name','University of the Philippines Diliman'),(4291,3210,'en','name','Ohio Department of Mental Health & Addiction Services'),(4292,3211,'en','name','Rex Hospital'),(4293,3212,'it','name','Azienda Ospedaliera Universitaria Policlinico \"G. Martino\"'),(4294,3213,'es','name','Hospital Vega Baja'),(4295,3214,'en','name','Odisha University of Agriculture and Technology'),(4296,3214,'ne','name','उडिसा कृषि एवं प्रौद्योगिकी विश्वविद्यालय'),(4297,3215,'en','name','American Type Culture Collection'),(4298,3216,'en','name','Meikai University'),(4299,3216,'ja','name','明海大学'),(4300,3217,'el','name','Σισμανόγλειο-Αμαλία Φλέμινγκ Γενικό Νοσοκομείο'),(4301,3217,'en','name','Simanogleio-Amalia Fleming General Hospital'),(4302,3218,'en','name','Western Oklahoma State College'),(4303,3219,'ar','name','جامعة بنها'),(4304,3219,'en','name','Benha University'),(4305,3219,'fr','name','Université de Banha'),(4306,3220,'en','name','Geha Mental Health Center'),(4307,3220,'he','name','המרכז לבריאות הנפש גהה'),(4308,3221,'en','name','Sachs\' Children and Youth Hospital'),(4309,3222,'en','name','Narayan Medical College and Hospital'),(4310,3223,'en','name','University of Life Sciences in Poznań'),(4311,3223,'pl','name','Uniwersytet Przyrodniczy w Poznaniu'),(4312,3224,'en','name','Fairfield General Hospital'),(4313,3225,'en','name','Hunan Entry-Exit Inspection and Quarantine Bureau'),(4314,3226,'en','name','Alexian Brothers Medical Center'),(4315,3227,'en','name','Earthquake Engineering Research Institute'),(4316,3228,'en','name','Damghan University'),(4317,3228,'fa','name','دانشگاه دامغان'),(4318,3229,'en','name','Moses Taylor Hospital'),(4319,3230,'no_lang_code','name','Metaxa Hospital'),(4320,3231,'en','name','Central University Hospital of Asturias'),(4321,3232,'en','name','National Interuniversity Consortium for Informatics'),(4322,3232,'it','name','Consorzio Interuniversitario Nazionale per l\'Informatica'),(4323,3233,'en','name','MRC University of Glasgow Centre for Virus Research'),(4324,3234,'en','name','County Durham and Darlington NHS Foundation Trust'),(4325,3235,'ar','name','جامعة تكساس أي اند إم'),(4326,3235,'en','name','Texas A&M University at Qatar'),(4327,3236,'en','name','Cappagh National Orthopaedic Hospital'),(4328,3237,'en','name','Osaka Bio Headquarters'),(4329,3238,'en','name','Kitasato University Medical Center'),(4330,3238,'ja','name','北里大学メディカルセンター'),(4331,3239,'en','name','AtlantiCare'),(4332,3240,'hr','name','Klinički bolnički centar Osijek'),(4333,3241,'no_lang_code','name','Ichor Medical Systems (United States)'),(4334,3242,'ja','name','旭川大学'),(4335,3242,'no_lang_code','name','Asahikawa University'),(4336,3243,'en','name','San Francicso Brain Research Institute & SAM Technology'),(4337,3244,'en','name','Beijing Dao Pei Hospital'),(4338,3244,'zh','name','北京道培医院'),(4339,3245,'en','name','Shanghai Tenth People\'s Hospital'),(4340,3245,'zh','name','上海第十人民医院'),(4341,3246,'en','name','Batra Hospital and Medical Research Centre'),(4342,3247,'en','name','Nagara Medical Center'),(4343,3247,'ja','name','国立病院機構長良医療センター'),(4344,3248,'en','name','Missouri Western State University'),(4345,3249,'no_lang_code','name','Maxwell Sensors'),(4346,3250,'en','name','Duke Children\'s Hospital & Health Center'),(4347,3251,'en','name','Transport for London'),(4348,3252,'en','name','Hayatabad Medical Complex'),(4349,3253,'en','name','Ministry of Health and Social Welfare'),(4350,3254,'fr','name','Hôpital Saint-Vincent-de-Paul'),(4351,3255,'ja','name','中国労災病院'),(4352,3255,'no_lang_code','name','Chugoku Rosai Hospital'),(4353,3256,'en','name','Ziauddin University'),(4354,3257,'de','name','Universitätsklinikum Freiburg'),(4355,3257,'en','name','University Medical Center Freiburg'),(4356,3258,'en','name','Hospital for Special Care'),(4357,3259,'en','name','Einstein Medical Center Philadelphia'),(4358,3260,'en','name','Beijing Sport University'),(4359,3260,'zh','name','北京体育大学'),(4360,3261,'en','name','Army Medical College'),(4361,3262,'es','name','El Hospital General de Agudos Carlos G. Durand'),(4362,3263,'no_lang_code','name','Molecular GPS Technologies (United States)'),(4363,3264,'en','name','Alta Bates Summit Medical Center'),(4364,3265,'en','name','Brigham and Women\'s Faulkner Hospital'),(4365,3266,'en','name','Adventist University of Health Sciences'),(4366,3267,'en','name','Rega Institute for Medical Research'),(4367,3268,'en','name','Bendigo Health'),(4368,3269,'no_lang_code','name','Yibin University'),(4369,3270,'bg','name','Университетска акушеро-гинекологична болница “Майчин дом”'),(4370,3270,'no_lang_code','name','Maichin Dom'),(4371,3271,'en','name','Jessop Hospital'),(4372,3272,'no_lang_code','name','Southwest Sciences (United States)'),(4373,3273,'en','name','Eginition Hospital'),(4374,3274,'en','name','Sema Hospital'),(4375,3274,'tr','name','Sema Hastanesi'),(4376,3275,'en','name','Hamilton Medical Center'),(4377,3276,'no_lang_code','name','Barron Associates (United States)'),(4378,3277,'no_lang_code','name','Beijing HuiLongGuan Hospital'),(4379,3277,'zh','name','北京回龙观医院'),(4380,3278,'de','name','Vereinigte Stahlhütten Burbach-Eich-Düdelingen'),(4381,3278,'lb','name','Aciéries Réunies de Burbach-Eich-Dudelange'),(4382,3278,'no_lang_code','name','Arbed (Luxembourg)'),(4383,3279,'en','name','National Eye Institute'),(4384,3280,'no_lang_code','name','Anandaban Hospital'),(4385,3281,'no_lang_code','name','Novelis (Canada)'),(4386,3282,'en','name','North Medical Center'),(4387,3282,'ja','name','京都府立医科大学附属北部医療センター'),(4388,3283,'en','name','Milpark Hospital'),(4389,3284,'en','name','Mount Carmel Health'),(4390,3285,'en','name','Pacific Northwest Diabetes Research Institute'),(4391,3286,'en','name','Central China Normal University'),(4392,3286,'zh','name','华中师范大学'),(4393,3287,'no_lang_code','name','Sant Parmanand Hospital'),(4394,3288,'de','name','Bundesanstalt für Materialforschung und -prüfung'),(4395,3288,'en','name','Federal Institute For Materials Research and Testing'),(4396,3289,'en','name','Lady Hardinge Medical College'),(4397,3290,'el','name','Ναυτικό Νοσοκομείο Αθηνών'),(4398,3290,'en','name','Athens Naval & Veterans Hospital'),(4399,3291,'en','name','Kansai University'),(4400,3291,'ja','name','関西大学'),(4401,3292,'en','name','Toyama Prefectural University'),(4402,3292,'ja','name','富山県立大学'),(4403,3293,'ar','name','وزارة الصحة'),(4404,3293,'en','name','Ministry of Health'),(4405,3294,'en','name','Central State University'),(4406,3295,'en','name','Chongqing Emergency Medical Center'),(4407,3295,'zh','name','重庆市急救医疗中心'),(4408,3296,'en','name','Cleveland Clinic'),(4409,3297,'en','name','Central Police University'),(4410,3298,'en','name','Bombay Hospital'),(4411,3299,'en','name','Nebraska Wesleyan University'),(4412,3300,'en','name','Pandit Bhagwat Dayal Sharma University of Health Sciences'),(4413,3301,'en','name','Shizuoka Medical Center'),(4414,3301,'ja','name','静岡医療センター'),(4415,3302,'en','name','Wakasa History and Folklore Museum'),(4416,3302,'ja','name','福井県立 若狭歴史博物館'),(4417,3303,'en','name','Nicolae Testemițanu State University of Medicine and Pharmacy'),(4418,3303,'ro','name','Universitatea de Medicină și Farmacie Nicolae Testemițanu din Chișinău'),(4419,3303,'ru','name','Государственный университет медицины и фармакологии имени Николая Тестемицяну'),(4420,3304,'ja','name','湘南鎌倉総合病院'),(4421,3304,'no_lang_code','name','Shonan Kamakura General Hospital'),(4422,3305,'en','name','Hyvinkää Hospital'),(4423,3306,'tr','name','Göztepe Şafak Hastanesi'),(4424,3307,'en','name','Infectious Disease Research Institute'),(4425,3308,'it','name','Ospedale Santa Maria della Misericordia di Rovigo'),(4426,3309,'en','name','University of Wisconsin System'),(4427,3309,'es','name','Sistema Universitario de Wisconsin'),(4428,3309,'fr','name','Université du Wisconsin'),(4429,3310,'es','name','Hospital Alemán'),(4430,3311,'en','name','Alice Springs Hospital'),(4431,3312,'en','name','University of Findlay'),(4432,3313,'fr','name','Centre Hospitalier National Universitaire de Fann'),(4433,3314,'en','name','Center for Interuniversity Research and Analysis on Organizations'),(4434,3315,'en','name','Institute of Child Health'),(4435,3316,'no_lang_code','name','Ansaldo (Italy)'),(4436,3317,'no_lang_code','name','Renji Hospital'),(4437,3317,'zh','name','上海交通大学医学院附属仁济医院'),(4438,3318,'en','name','University of Suwon'),(4439,3318,'ko','name','수원대학교'),(4440,3319,'en','name','Electronics and Telecommunications Research Institute'),(4441,3319,'ko','name','한국전자통신연구원'),(4442,3320,'en','name','Kasumigaura Medical Center'),(4443,3320,'ja','name','霞ヶ浦医療センター'),(4444,3321,'en','name','North Shore Hospital'),(4445,3322,'no_lang_code','name','3C Institute'),(4446,3323,'en','name','Mysore Medical College'),(4447,3324,'it','name','Ospedale Regina Apostolorum'),(4448,3325,'ko','name','분당제생병원'),(4449,3325,'no_lang_code','name','Bundang Jesaeng Hospital'),(4450,3326,'en','name','University of San Simón'),(4451,3326,'es','name','Universidad Mayor de San Simón'),(4452,3327,'en','name','Dewsbury and District Hospital'),(4453,3328,'de','name','Lindenhofspital'),(4454,3329,'es','name','Hospital Materno-Infantil'),(4455,3330,'en','name','Women & Infants Hospital of Rhode Island'),(4456,3331,'en','name','Frenchay Hospital'),(4457,3332,'en','name','Princess Margaret Cancer Centre'),(4458,3333,'ja','name','神戸朝日病院'),(4459,3333,'no_lang_code','name','Kobe Asahi Hospital'),(4460,3334,'it','name','Consorzio Universitario In Ingegneria Della Qualita'),(4461,3335,'en','name','Horton General Hospital'),(4462,3336,'en','name','Easton Hospital'),(4463,3337,'en','name','Kyoto University of Education'),(4464,3337,'ja','name','京都教育大学'),(4465,3338,'en','name','London Chest Hospital'),(4466,3339,'en','name','Population Council'),(4467,3340,'en','name','Luton and Dunstable University Hospital NHS Foundation Trust'),(4468,3341,'en','name','Good Samaritan Hospital'),(4469,3342,'en','name','University Teaching Hospital'),(4470,3343,'no_lang_code','name','Bikur Cholim Hospital'),(4471,3344,'en','name','Kingston General Hospital'),(4472,3344,'fr','name','Hôpital général de kingston'),(4473,3345,'bg','name','Технически университет - Варна'),(4474,3345,'en','name','Technical University of Varna'),(4475,3346,'en','name','Hanwa Memorial Hospital'),(4476,3346,'ja','name','阪和記念病院'),(4477,3347,'en','name','University of Arkansas at Pine Bluff'),(4478,3347,'fr','name','Université de l\'arkansas à pine bluff'),(4479,3348,'en','name','Randolph–Macon College'),(4480,3349,'en','name','WellStar Kennestone Hospital'),(4481,3350,'en','name','Macclesfield District General Hospital'),(4482,3351,'en','name','University Hospital of Ioannina'),(4483,3352,'en','name','AcademyHealth'),(4484,3353,'en','name','Fields Institute for Research in Mathematical Sciences'),(4485,3354,'en','name','Nishinomiya Kyoritsu Neurosurgical Hospital'),(4486,3354,'ja','name','西宮協立脳神経外科病院'),(4487,3355,'de','name','Klinikum im Friedrichshain'),(4488,3356,'en','name','Tohoku Medical Megabank Organization'),(4489,3356,'ja','name','東北メディカル・メガバンク機構'),(4490,3357,'en','name','Liverpool Hospital'),(4491,3358,'en','name','La Jolla Institute For Molecular Medicine'),(4492,3359,'en','name','Guglielmo da Saliceto Hospital'),(4493,3360,'en','name','Austral University'),(4494,3360,'es','name','Universidad Austral'),(4495,3361,'en','name','Mercy Medical Center'),(4496,3362,'ja','name','練馬総合病院'),(4497,3362,'no_lang_code','name','Nerima General Hospital'),(4498,3363,'en','name','Saint Ambrose University'),(4499,3363,'fr','name','Université saint ambroise'),(4500,3364,'en','name','B.J. Medical College'),(4501,3365,'en','name','Delaware Department of Health and Social Services'),(4502,3366,'en','name','University of Cartagena'),(4503,3366,'es','name','Universidad de Cartagena'),(4504,3367,'pt','name','Hospital de São Marcos'),(4505,3368,'en','name','Community Health Network'),(4506,3369,'en','name','Pennington Biomedical Research Center'),(4507,3370,'no_lang_code','name','Starlab Barcelona Sl'),(4508,3371,'no_lang_code','name','Senvion SE (Germany)'),(4509,3372,'en','name','Istanbul Memorial Hospital'),(4510,3373,'en','name','Santobono Children\'s Hospital'),(4511,3374,'ja','name','犬山中央病院'),(4512,3374,'no_lang_code','name','Inuyama Chuo Hospital'),(4513,3375,'en','name','Borough of Manhattan Community College'),(4514,3376,'fr','name','Centre Hospitalier de Saint Jean de Dieu'),(4515,3377,'en','name','Samuel Merritt University'),(4516,3378,'en','name','Skaraborg Hospital'),(4517,3378,'sv','name','Skaraborgs Sjukhus'),(4518,3379,'hu','name','Baranya Megyei Kórház'),(4519,3380,'en','name','West China Medical Center of Sichuan University'),(4520,3380,'zh','name','四川大学华西医学中心'),(4521,3381,'en','name','Aomori University'),(4522,3381,'ja','name','青森大学'),(4523,3382,'en','name','G.V. (Sonny) Montgomery VA Medical Center'),(4524,3383,'hi','name','छत्रपति शाहूजी महाराज विश्वविद्यालय'),(4525,3383,'no_lang_code','name','Chhatrapati Shahu Ji Maharaj University'),(4526,3383,'ta','name','சத்ரபதி ஷாகுஜி மகராஜ் பல்கலைக்கழகம்'),(4527,3384,'da','name','Skejby Sygehus'),(4528,3384,'en','name','Aarhus University Hospital'),(4529,3385,'en','name','North West Regional Hospital'),(4530,3386,'en','name','University of Houston System'),(4531,3387,'fi','name','Kainuun keskussairaala'),(4532,3388,'en','name','Ragas Dental College & Hospital'),(4533,3389,'en','name','Ecpi University'),(4534,3390,'es','name','Hospital Universitario Lucus Augusti'),(4535,3391,'de','name','Institut für Rundfunktechnik'),(4536,3392,'en','name','Korea Basic Science Institute'),(4537,3393,'en','name','Setsunan University'),(4538,3393,'ja','name','摂南大学'),(4539,3394,'en','name','University of Florida Health Science Center'),(4540,3395,'en','name','China Three Gorges University'),(4541,3395,'zh','name','三峡大学'),(4542,3396,'no_lang_code','name','Olympus (Australia)'),(4543,3397,'ja','name','関東学院大学'),(4544,3397,'no_lang_code','name','Kanto Gakuin University'),(4545,3398,'en','name','Bhumibol Adulyadej Hospital'),(4546,3398,'th','name','โรงพยาบาลภูมิพลอดุลยเดช'),(4547,3399,'en','name','University Hospital Crosshouse'),(4548,3400,'en','name','Countess of Chester Hospital'),(4549,3401,'en','name','University of San Carlos'),(4550,3402,'en','name','Selly Oak Hospital'),(4551,3403,'en','name','Providence VA Medical Center'),(4552,3404,'no_lang_code','name','Fisher Bioservices (United States)'),(4553,3405,'no_lang_code','name','Chrysler (Canada)'),(4554,3406,'ja','name','信楽園病院'),(4555,3406,'no_lang_code','name','Shinrakuen Hospital'),(4556,3407,'en','name','LungenClinic Grosshansdorf'),(4557,3408,'en','name','University of Havana'),(4558,3408,'es','name','Universidad de La Habana'),(4559,3409,'en','name','Silver Cross Hospital'),(4560,3410,'ja','name','複十字病院'),(4561,3410,'no_lang_code','name','Fukujuji Hospital'),(4562,3411,'en','name','Scripps Whittier Diabetes Institute'),(4563,3412,'en','name','Medical City Children\'s Hospital'),(4564,3413,'no_lang_code','name','NeuroComp Systems (United States)'),(4565,3414,'en','name','Maharani Laxmi Bai Medical College'),(4566,3415,'en','name','China Animal Health and Epidemiology Center'),(4567,3415,'zh','name','中国动物卫生与流行病学中心'),(4568,3416,'en','name','Castle Hill Hospital'),(4569,3417,'en','name','MCNC Research and Development Institute'),(4570,3418,'en','name','Nova Southeastern University'),(4571,3418,'es','name','Universidad de Nova Southeastern'),(4572,3419,'en','name','Swedish Steel'),(4573,3419,'no_lang_code','name','Svenskt Stål (Finland)'),(4574,3420,'en','name','Burdwan Medical College & Hospital'),(4575,3421,'en','name','Hyogo Ion Beam Medical Center'),(4576,3421,'ja','name','兵庫県立粒子線医療センター'),(4577,3422,'en','name','Research Foundation For Mental Hygiene'),(4578,3423,'fr','name','Multitel'),(4579,3424,'en','name','Musgrove Park Hospital'),(4580,3425,'en','name','Public Health Service of Amsterdam'),(4581,3425,'nl','name','GGD Amsterdam'),(4582,3426,'en','name','Air Force General Hospital PLA'),(4583,3427,'bn','name','বঙ্গবন্ধু শেখ মুজিব মেডিকেল বিশ্ববিদ্যালয়'),(4584,3427,'en','name','Bangabandhu Sheikh Mujib Medical University'),(4585,3428,'el','name','ΣΙΔΕΝΟΡ'),(4586,3428,'no_lang_code','name','Sidenor (Greece)'),(4587,3429,'en','name','Ministry of Health'),(4588,3429,'my','name','ကျန်းမာရေးဝန်ကြီးဌာန'),(4589,3430,'en','name','Nissan Tamagawa Hospital'),(4590,3430,'ja','name','日産厚生会 玉川病院'),(4591,3431,'en','name','Manly Hospital'),(4592,3432,'pt','name','Instituto Superior de Educação e Ciências'),(4593,3433,'en','name','Jos University Teaching Hospital'),(4594,3434,'pt','name','Escola Superior de Enfermagem Dr. José Timóteo Montalvão Machado'),(4595,3435,'en','name','McKendree University'),(4596,3436,'en','name','University of Roehampton'),(4597,3437,'fr','name','Hôpital Riviera-Chablais'),(4598,3438,'en','name','Gunma Children\'s Medical Center'),(4599,3438,'ja','name','群馬県立小児医療センター'),(4600,3439,'en','name','Guangdong Academy of Medical Sciences'),(4601,3440,'en','name','Ashford Hospital'),(4602,3441,'en','name','K.N.Toosi University of Technology'),(4603,3441,'fa','name','دانشگاه صنعتی خواجه نصیرالدین طوسی'),(4604,3442,'en','name','Pukyong National University'),(4605,3442,'ko','name','부경대학교'),(4606,3443,'en','name','Chungnam National University Hospital'),(4607,3444,'el','name','Γενικό Νοσοκομείο Ηρακλείου \"Βενιζέλειο - Πανάνειο\"'),(4608,3444,'en','name','The General Hospital of Heraklion \"Venizeleio-Pananio\"'),(4609,3445,'en','name','Kuo General Hospital'),(4610,3445,'zh','name','郭综合医院'),(4611,3446,'en','name','Rehabilitation Hospital of Indiana'),(4612,3447,'no_lang_code','name','Microfab Technologies (United States)'),(4613,3448,'en','name','Civil Aerospace Medical Institute'),(4614,3449,'en','name','Henan Cancer Hospital'),(4615,3449,'zh','name','河南省肿瘤医院'),(4616,3450,'el','name','Γενικό Νοσοκομείο Νίκαιας'),(4617,3450,'en','name','General Hospital of Nikea'),(4618,3451,'en','name','Akita Red Cross Hospital'),(4619,3451,'ja','name','秋田赤十字病院'),(4620,3452,'en','name','Royal National Orthopaedic Hospital'),(4621,3453,'en','name','Sunchon National University'),(4622,3453,'ko','name','순천대학교'),(4623,3454,'en','name','Povisa Hospital'),(4624,3454,'es','name','Hospital Povisa'),(4625,3455,'en','name','Institute For Community Research'),(4626,3456,'en','name','Beaumont Hospital'),(4627,3457,'en','name','JR Tokyo General Hospital'),(4628,3457,'ja','name','JR東京総合病院'),(4629,3458,'it','name','Ospedale San Donato'),(4630,3459,'en','name','Arbor Research Collaborative for Health'),(4631,3460,'no_lang_code','name','Profactor (Austria)'),(4632,3461,'en','name','Eastern Hepatobiliary Surgery Hospital'),(4633,3461,'zh','name','东方肝胆外科医院'),(4634,3462,'en','name','Carney Hospital'),(4635,3463,'en','name','The Evergreen State College'),(4636,3464,'en','name','Central India Institute of Medical Sciences'),(4637,3465,'fr','name','Hôpital Sahloul'),(4638,3466,'en','name','Birmingham Accident Hospital'),(4639,3467,'en','name','National University of Life and Environmental Sciences of Ukraine'),(4640,3467,'ru','name','Национальный университет биоресурсов и природопользования'),(4641,3467,'uk','name','Національний університет біоресурсів і природокористування України'),(4642,3468,'en','name','Bucheon St. Mary\'s Hospital'),(4643,3469,'fr','name','Hôpital des Diaconesses'),(4644,3470,'en','name','Western Kentucky University'),(4645,3471,'en','name','Oklahoma Panhandle State University'),(4646,3472,'en','name','University of Miyazaki'),(4647,3472,'ja','name','宮崎大学'),(4648,3473,'en','name','Prairie View A&M University'),(4649,3474,'en','name','University of the Incarnate Word'),(4650,3474,'es','name','Universidad del Verbo Encarnado'),(4651,3474,'fr','name','Université du verbe incarné'),(4652,3475,'en','name','Ministry of Health and Child Welfare'),(4653,3476,'en','name','Tennessee Department of Mental Health and Substance Abuse Services'),(4654,3477,'en','name','Ministry of Natural Resources and Wildlife'),(4655,3477,'fr','name','Ministère de l\'Énergie et des Ressources naturelles'),(4656,3478,'en','name','Rhode Island Department of Behavioral Healthcare, Developmental Disabilities and Hospitals'),(4657,3479,'fr','name','Hôpital des Enfants'),(4658,3480,'en','name','Severance Hospital'),(4659,3480,'ko','name','세브란스 병원'),(4660,3481,'sv','name','AlbaNova'),(4661,3482,'en','name','Vidant Health'),(4662,3483,'no_lang_code','name','Mycologics'),(4663,3484,'en','name','University of Mississippi Medical Center'),(4664,3485,'en','name','Georgia Southwestern State University'),(4665,3486,'en','name','Holy Family Hospital'),(4666,3487,'en','name','Ouachita Baptist University'),(4667,3488,'en','name','Hanoi School Of Public Health'),(4668,3488,'vi','name','Trường Đại học Y tế công cộng'),(4669,3489,'en','name','Japanese Red Cross Society, Japan'),(4670,3489,'ja','name','日本赤十字社'),(4671,3490,'en','name','Frere Hospital'),(4672,3491,'es','name','Centro de Alta Resolución San Millán'),(4673,3492,'en','name','Advocate Children\'s Hospital'),(4674,3493,'en','name','Tokushima University'),(4675,3493,'ja','name','徳島大学'),(4676,3494,'no_lang_code','name','Laniado Hospital'),(4677,3495,'en','name','Boone Hospital Center'),(4678,3496,'en','name','Queen Mary\'s Hospital Sidcup'),(4679,3497,'it','name','Ospedale dei Bambini Vittore Buzzi'),(4680,3498,'en','name','Uganda Virus Research Institute'),(4681,3499,'en','name','National Society of French Railways'),(4682,3499,'no_lang_code','name','Société Nationale des Chemins de Fer Français (France)'),(4683,3500,'en','name','Ministry of Health'),(4684,3501,'en','name','Bishop Auckland Hospital'),(4685,3502,'ja','name','有限会社 HREM'),(4686,3502,'no_lang_code','name','HREM Research (Japan)'),(4687,3503,'en','name','Acıbadem Kadıköy Hospital'),(4688,3503,'tr','name','Kadıköy Hastanesi'),(4689,3504,'en','name','University of Oklahoma Health Sciences Center'),(4690,3505,'en','name','Geisinger Wyoming Valley Medical Center'),(4691,3506,'en','name','University of San Francisco'),(4692,3506,'pt','name','Universidade São Francisco'),(4693,3507,'en','name','Mamata Medical College'),(4694,3508,'en','name','Cape Fear Valley Medical Center'),(4695,3509,'tr','name','Ulucanlar Göz Eğitim ve Araştırma Hastanesi'),(4696,3510,'en','name','Iowa Methodist Medical Center'),(4697,3511,'no_lang_code','name','Portiuncula Hospital'),(4698,3512,'en','name','Armed Forces Capital Hospital'),(4699,3512,'ko','name','국군수도병원'),(4700,3512,'zh','name','國軍首都病院'),(4701,3513,'de','name','Max Rubner Institut'),(4702,3514,'en','name','Cooperative Research Centre for Polymers'),(4703,3515,'en','name','Kyoto Medical Center'),(4704,3515,'ja','name','京都医療センター'),(4705,3516,'bn','name','ডিব্রুগড় বিশ্ববিদ্যালয়'),(4706,3516,'no_lang_code','name','Dibrugarh University'),(4707,3517,'en','name','Moses H Cone Memorial Hospital'),(4708,3518,'nl','name','Tergooi'),(4709,3519,'en','name','Ubon Ratchathani University'),(4710,3519,'th','name','มหาวิทยาลัยอุบลราชธานี'),(4711,3520,'en','name','Cincinnati VA Medical Center'),(4712,3521,'en','name','American Sociological Association'),(4713,3522,'en','name','Kentucky Cabinet For Health and Family Services'),(4714,3523,'ja','name','江東病院'),(4715,3523,'no_lang_code','name','Koto Hospital'),(4716,3524,'en','name','Bedford Hospital'),(4717,3525,'en','name','Chicago Department of Public Health'),(4718,3526,'en','name','University of Ilorin Teaching Hospital'),(4719,3527,'en','name','Daegu Haany University'),(4720,3527,'ko','name','대구한의대학교'),(4721,3528,'en','name','McMurry University'),(4722,3529,'en','name','Netaji Subhash Chandra Bose Medical College'),(4723,3530,'el','name','ΕΥΓΕΝΙΔΕΙΟ ΘΕΡΑΠΕΥΤΗΡΙΟ'),(4724,3530,'en','name','Eugenides Hospital'),(4725,3531,'en','name','Sacred Heart Hospital'),(4726,3532,'en','name','Kyoto first Red Cross hospital'),(4727,3532,'ja','name','京都第一赤十字病院'),(4728,3533,'en','name','Gangneung–Wonju National University'),(4729,3533,'ko','name','강릉원주대학교'),(4730,3534,'no_lang_code','name','G. Papanikolaou General Hospital'),(4731,3535,'en','name','Muskingum University'),(4732,3536,'en','name','Beppu Medical Center'),(4733,3536,'ja','name','別府医療センター'),(4734,3537,'en','name','Kobe City Medical Center West Hospital'),(4735,3537,'ja','name','神戸市立医療センター西市民病院'),(4736,3538,'it','name','Ospedale di Belcolle'),(4737,3539,'ko','name','한양대학교'),(4738,3539,'no_lang_code','name','Hanyang University'),(4739,3540,'en','name','Space Science Institute'),(4740,3541,'es','name','Hospital de Niños de la Santísima Trinidad'),(4741,3542,'en','name','Lock Haven University'),(4742,3543,'en','name','Government Medical College, Amritsar'),(4743,3543,'pa','name','ਸਰਕਾਰੀ ਮੈਡੀਕਲ ਕਾਲਜ'),(4744,3544,'en','name','Guangzhou Medical University Cancer Hospital'),(4745,3544,'zh','name','广州医科大学附属肿瘤医院'),(4746,3545,'en','name','Sioux Valley Hospital'),(4747,3546,'en','name','St Lawrence Hospital'),(4748,3547,'en','name','Kentucky Community and Technical College System'),(4749,3548,'en','name','The Heart Research Institute'),(4750,3549,'en','name','Gunma University'),(4751,3549,'ja','name','群馬大学'),(4752,3550,'en','name','Dandenong Hospital'),(4753,3551,'en','name','Tri-Service General Hospital Songshan Branch'),(4754,3552,'en','name','Mayo Hospital'),(4755,3553,'en','name','University of Virginia Medical Center'),(4756,3554,'en','name','St Mary\'s Hospital'),(4757,3555,'de','name','St. Josef-Hospital'),(4758,3556,'en','name','MRC Biostatistics Unit'),(4759,3557,'it','name','Azienda Ospedaliera Ospedale Civile di Legnano'),(4760,3558,'es','name','Hospital Virgen del Camino'),(4761,3559,'en','name','The 309th Hospital of Chinese People\'s Liberation Army'),(4762,3559,'zh','name','中国人民解放军第三〇九医院'),(4763,3560,'en','name','Heartland Regional Medical Center'),(4764,3561,'fr','name','Hôpital Principal de Dakar'),(4765,3562,'en','name','Capella University'),(4766,3563,'en','name','Tainan Municipal Hospital'),(4767,3563,'zh','name','台南市立醫院'),(4768,3564,'no_lang_code','name','Srinakharinwirot University'),(4769,3564,'th','name','มหาวิทยาลัยศรีนครินทรวิโรฒ'),(4770,3565,'en','name','Taurida National V.I. Vernadsky University'),(4771,3565,'pl','name','Tawrijski Uniwersytet Narodowy im. Władimira Wiernadskiego'),(4772,3565,'ru','name','Таврический национальный университет имени В. И. Вернадского'),(4773,3565,'uk','name','Таврійський національний університет імені В. І. Вернадського'),(4774,3566,'ja','name','金城学院大学'),(4775,3566,'no_lang_code','name','Kinjo Gakuin University'),(4776,3567,'tr','name','GATA Haydarpaşa Eğitim Hastanesi'),(4777,3568,'en','name','Roger Williams Medical Center'),(4778,3569,'en','name','Medical Research Institute of New Zealand'),(4779,3570,'nl','name','Juliana Kinderziekenhuis'),(4780,3571,'en','name','Eastern Nazarene College'),(4781,3572,'en','name','Hesperia Hospital'),(4782,3573,'en','name','Kaiser Permanente Anaheim Medical Center'),(4783,3574,'en','name','South Dakota Department of Health'),(4784,3575,'ar','name','جامعة الأزهر في غزة'),(4785,3575,'en','name','Al-Azhar University – Gaza'),(4786,3576,'es','name','Hospital César Milstein'),(4787,3577,'en','name','Aichi Prefectural University'),(4788,3577,'ja','name','愛知県立大学'),(4789,3578,'en','name','South Carolina State Governor\'s Office'),(4790,3579,'en','name','Himeji Red Cross Hospital'),(4791,3579,'ja','name','姫路赤十字病院'),(4792,3580,'en','name','Coastal Area Health Education Center'),(4793,3581,'en','name','Maidstone Hospital'),(4794,3582,'no_lang_code','name','MATIMOP'),(4795,3583,'en','name','Johannesburg Hospital'),(4796,3584,'tr','name','Malatya Devlet Hastanesi'),(4797,3585,'en','name','Catholic University of America'),(4798,3585,'es','name','Universidad Católica de América'),(4799,3585,'fr','name','Université catholique d\'amérique'),(4800,3586,'ar','name','مدينة الطب'),(4801,3586,'en','name','Baghdad Medical City'),(4802,3587,'en','name','Semiconductor Research Corporation'),(4803,3588,'es','name','Empresarios Agrupados'),(4804,3589,'en','name','Carolinas Medical Center'),(4805,3590,'en','name','Box Hill Hospital'),(4806,3591,'pt','name','Instituto de Investigacao das Pescas e do Mar'),(4807,3592,'en','name','Hairmyres Hospital'),(4808,3593,'en','name','Cardiff and Vale University Health Board'),(4809,3594,'en','name','Glenfield Hospital'),(4810,3595,'en','name','Miami Children\'s Hospital'),(4811,3596,'en','name','Frostburg State University'),(4812,3596,'fr','name','Université d\'État de frostburg'),(4813,3597,'en','name','Health Research and Educational Trust'),(4814,3598,'fr','name','Centre Hospitalier Universitaire de Cocody'),(4815,3599,'en','name','Joseph Brant Hospital'),(4816,3600,'en','name','National Aerospace University – Kharkiv Aviation Institute'),(4817,3600,'ru','name','Национальный аэрокосмический университет имени Н. Е. Жуковского'),(4818,3600,'uk','name','Національний аерокосмічний університет імені М. Є. Жуковського Харківський авіаційний інститут'),(4819,3601,'en','name','American Health Information Management Association'),(4820,3602,'en','name','Fulton County Medical Examiner\'s Office'),(4821,3603,'en','name','AdventHealth Celebration'),(4822,3604,'en','name','National Association of County and City Health Officials'),(4823,3605,'en','name','Children\'s Research Hospital'),(4824,3605,'ja','name','小児研究病院'),(4825,3606,'en','name','NewYork–Presbyterian Brooklyn Methodist Hospital'),(4826,3607,'ja','name','富士フイルム株式会社'),(4827,3607,'no_lang_code','name','Fujifilm (Japan)'),(4828,3608,'no_lang_code','name','Lallemand (Canada)'),(4829,3609,'en','name','National Institute on Minority Health and Health Disparities'),(4830,3610,'en','name','Carl T. Hayden Veterans Affairs Medical Center'),(4831,3611,'en','name','Millsaps College'),(4832,3612,'en','name','Guangxi University for Nationalities'),(4833,3612,'zh','name','广西民族大学'),(4834,3613,'es','name','Hospital Municipal de Badalona'),(4835,3614,'en','name','Taishan Medical University'),(4836,3614,'zh','name','泰山医学院'),(4837,3615,'be','name','Министерство здравоохранения Республики Беларусь'),(4838,3615,'en','name','Ministry of Health'),(4839,3616,'en','name','Bezmialem Foundation University Medical Faculty Hospital'),(4840,3616,'tr','name','Bezmiâlem Vakıf Üniversitesi Tıp Fakültesi Hastanesi'),(4841,3617,'en','name','Northwestern State University'),(4842,3617,'fr','name','Université d\'État northwestern'),(4843,3618,'de','name','Joanneum Research Forschungsgesellschaft mbH'),(4844,3618,'en','name','Joanneum Research'),(4845,3619,'en','name','Children\'s Hospital of Wisconsin'),(4846,3620,'en','name','Ningxia Medical University General Hospital'),(4847,3620,'zh','name','宁夏医科大学总医院'),(4848,3621,'en','name','Henry Mayo Newhall Memorial Hospital'),(4849,3622,'en','name','Shriners Hospitals for Children - St. Louis'),(4850,3623,'en','name','Indira Gandhi Institute of Medical Sciences'),(4851,3624,'en','name','San Francisco VA Medical Center'),(4852,3625,'en','name','Kent State University'),(4853,3625,'fr','name','Université d\'État de kent'),(4854,3626,'en','name','Anqing City Hospital'),(4855,3627,'en','name','Chiba Rosai Hospital'),(4856,3627,'ja','name','千葉労災病院'),(4857,3628,'en','name','Doernbecher Children\'s Hospital'),(4858,3629,'en','name','Cooper University Hospital'),(4859,3630,'en','name','Shaw University'),(4860,3631,'ar','name','مستشفى جامعة السلطان قابوس'),(4861,3631,'en','name','Sultan Qaboos University Hospital'),(4862,3632,'en','name','Winston-Salem State University'),(4863,3633,'en','name','Houston Medical Center'),(4864,3634,'en','name','Communications and Information Technology Ontario'),(4865,3635,'en','name','Robert Jones and Agnes Hunt Orthopaedic Hospital NHS Trust'),(4866,3636,'en','name','Shanghai Sixth People\'s Hospital'),(4867,3636,'zh','name','上海市第六人民医院'),(4868,3637,'bg','name','Медицински университет - Плевен'),(4869,3637,'en','name','Medical University Pleven'),(4870,3638,'en','name','Hispanic Health Council'),(4871,3639,'en','name','Seton Medical Center'),(4872,3640,'no_lang_code','name','Airbus (Germany)'),(4873,3641,'en','name','Hospital General Universitario de Albacete'),(4874,3641,'es','name','Complejo Hospitalario Universitario de Albacete'),(4875,3642,'pt','name','Centro Universitário São Camilo'),(4876,3643,'en','name','Radiolabs'),(4877,3644,'en','name','Andrews University'),(4878,3644,'es','name','Universidad Andrews'),(4879,3645,'no_lang_code','name','Israel Aerospace Industries (Israel)'),(4880,3646,'es','name','Hospital Ruber Internacional'),(4881,3647,'pt','name','Hospital Santo António dos Capuchos'),(4882,3648,'en','name','Brookings Institution'),(4883,3648,'es','name','Institución Brookings'),(4884,3649,'en','name','Mount Vernon Hospital'),(4885,3650,'en','name','Instituto Superior D. Dinis'),(4886,3651,'no_lang_code','name','Hlabisa Hospital'),(4887,3652,'en','name','Kingston Hospital'),(4888,3653,'cs','name','Univerzita Obrany'),(4889,3653,'en','name','University of Defence'),(4890,3654,'en','name','Jichi Medical University Hospital'),(4891,3654,'ja','name','自治医科大学附属病院'),(4892,3655,'en','name','Poriya Medical Center'),(4893,3655,'he','name','בית חולים ברוך פדה'),(4894,3656,'en','name','Wolfson Medical Center'),(4895,3656,'he','name','מרכז רפואי וולפסון'),(4896,3657,'en','name','Guangdong University of Technology'),(4897,3657,'zh','name','广东工业大学'),(4898,3658,'en','name','Government Medical College'),(4899,3658,'ml','name','ഗവൺമെന്റ് മെഡിക്കൽ കോളേജ്, കോഴിക്കോട്'),(4900,3658,'ta','name','கோழிக்கோடு மருத்துவக் கல்லூரி'),(4901,3659,'en','name','Imakiire General Hospital'),(4902,3659,'ja','name','公益財団法人昭和会 今給黎総合病院'),(4903,3660,'es','name','Hospital General de Elda'),(4904,3661,'en','name','Seoul Women\'s University'),(4905,3661,'ko','name','서울여자대학교'),(4906,3662,'ar','name','مستشفى راشد'),(4907,3662,'en','name','Rashid Hospital'),(4908,3663,'en','name','Social Sciences Innovations'),(4909,3664,'en','name','Green Pastures Hospital and Rehabilitation Centre'),(4910,3665,'en','name','Santa Barbara Cottage Hospital'),(4911,3666,'en','name','Yamaguchi Prefectural University'),(4912,3666,'ja','name','山口県立大学'),(4913,3667,'bg','name','университетска болница „Александровска'),(4914,3667,'no_lang_code','name','Alexandrovska Hospital'),(4915,3668,'no_lang_code','name','MC3 (United States)'),(4916,3669,'en','name','European University of Lisbon'),(4917,3669,'pt','name','Universidade Europeia'),(4918,3670,'en','name','University of Balochistan'),(4919,3670,'ur','name','جامعہ بلوچستان'),(4920,3671,'en','name','Stowers Institute for Medical Research'),(4921,3672,'en','name','Ministry of Public Health'),(4922,3672,'fr','name','Ministère de la Santé Publique du Cameroun'),(4923,3673,'tr','name','Dışkapı Yıldırım Beyazıt Eğitim ve Araştırma Hastanesi'),(4924,3674,'it','name','Azienda Ospedaliera di Padova'),(4925,3675,'en','name','Genesis Medical Center'),(4926,3676,'en','name','Walsall Manor Hospital'),(4927,3677,'no_lang_code','name','Pingtung Christian Hospital'),(4928,3677,'zh','name','屏東基督教醫院'),(4929,3678,'pt','name','Escola Superior de Saúde Ribeiro Sanches'),(4930,3679,'en','name','Commonwealth Medical College'),(4931,3680,'en','name','Mercy General Hospital'),(4932,3681,'en','name','Institute of Mental Health'),(4933,3682,'en','name','Memorial Hospital of Rhode Island'),(4934,3683,'en','name','Truckee Meadows Community College'),(4935,3684,'en','name','Services Institute of Medical Sciences'),(4936,3684,'pa','name','ਸੈਰਵਿਸਜ਼ ਇੰਸਟਿਟਿਊਟ ਆਫ਼ ਮੈਡੀਕਲ ਸਾਈਨਸਜ਼'),(4937,3684,'ur','name','سروسز انسٹیٹوٹ آف میڈیکل سائنسز'),(4938,3685,'en','name','PSG Institute of Medical Sciences & Research'),(4939,3686,'es','name','Hospital Monte Naranco'),(4940,3687,'en','name','St. James\'s Hospital'),(4941,3688,'no_lang_code','name','P2D Bioscience (United States)'),(4942,3689,'en','name','Scottish Rite Hospital'),(4943,3690,'en','name','Ca\' Foncello Hospital'),(4944,3691,'es','name','Hospital Universitario Insular de Gran Canaria'),(4945,3692,'en','name','Iwate University'),(4946,3692,'ja','name','岩手大学'),(4947,3693,'bn','name','কাশী হিন্দু বিশ্ববিদ্যালয়'),(4948,3693,'en','name','Banaras Hindu University'),(4949,3693,'fr','name','Université hindoue de bénarès'),(4950,3693,'gu','name','બનારસ હિંદુ યુનિવર્સિટી'),(4951,3693,'hi','name','काशी हिन्दू विश् वविद्यालय'),(4952,3693,'kn','name','ಬನಾರಸ್ ಹಿಂದೂ ವಿಶ್ವವಿದ್ಯಾನಿಲಯ'),(4953,3693,'ml','name','ബനാറസ് ഹിന്ദു യൂണിവേഴ്സിറ്റി'),(4954,3693,'ta','name','பனாரசு இந்து பல்கலைக்கழகம்'),(4955,3693,'te','name','బెనారస్ హిందూ విశ్వవిద్యాలయం'),(4956,3694,'es','name','Hospital Juárez de México'),(4957,3695,'en','name','University of Vermont Medical Center'),(4958,3696,'da','name','Holbæk Sygehus'),(4959,3697,'no_lang_code','name','Shanghai GenomePilot Technology (China)'),(4960,3697,'zh','name','上海佰真生物科技有限公司'),(4961,3698,'en','name','Atmospheric and Environmental Research'),(4962,3699,'ar','name','مستشفى الملك عبدالعزي'),(4963,3699,'en','name','King Abdulaziz Hospital'),(4964,3700,'no_lang_code','name','Honeywell (Canada)'),(4965,3701,'en','name','Sri Manakula Vinayagar Medical College and Hospital'),(4966,3702,'fr','name','Hôpital Laennec'),(4967,3703,'en','name','University of the Arts London'),(4968,3704,'en','name','Bess Kaiser Hospital'),(4969,3705,'en','name','Southern Illinois University Edwardsville'),(4970,3706,'en','name','Mahatma Gandhi Institute of Medical Sciences'),(4971,3706,'hi','name','महात्मा गांधी वैद्यकीय संस्था'),(4972,3707,'no_lang_code','name','Charoenkrung Pracharak Hospital'),(4973,3707,'th','name','โรงพยาบาลเจริญกรุงประชารักษ์'),(4974,3708,'it','name','Ospedale Maria Vittoria'),(4975,3709,'en','name','Inner Mongolia University for Nationalities'),(4976,3710,'en','name','Australian Catholic University'),(4977,3711,'es','name','Hospital de Mataró'),(4978,3712,'en','name','General de Jesus College'),(4979,3713,'ar','name','مستشفى دبـــي'),(4980,3713,'en','name','Dubai Hospital'),(4981,3714,'en','name','Shaare Zedek Medical Center'),(4982,3714,'he','name','מרכז רפואי שערי צדק'),(4983,3715,'fr','name','Hôpital du Hasenrain'),(4984,3716,'fr','name','Société de Mathématiques Appliquées et de Sciences Humaines'),(4985,3717,'en','name','Lawrence Technological University'),(4986,3717,'fr','name','Université technologique lawrence'),(4987,3718,'de','name','Europäisches Institut für Energieforschung'),(4988,3718,'en','name','European Institute for Energy Research'),(4989,3719,'en','name','Aurora Health Care'),(4990,3720,'en','name','Red Cross War Memorial Children\'s Hospital'),(4991,3721,'en','name','I-Shou University'),(4992,3722,'it','name','Azienda Ospedaliera Universitaria \"San Martino\", Ospedale Policlinico San Martino'),(4993,3723,'en','name','VA Eastern Colorado Health Care System'),(4994,3724,'en','name','Doai Memorial Hospital'),(4995,3724,'ja','name','同愛記念病院'),(4996,3725,'en','name','Sankt Hans Hospital'),(4997,3726,'de','name','Klinik Donaustauf'),(4998,3727,'en','name','Fujisawa City Hospital'),(4999,3727,'ja','name','藤沢市民病院'),(5000,3728,'no_lang_code','name','Biorem Technologies (Canada)'),(5001,3729,'en','name','Heidelberg Repatriation Hospital'),(5002,3730,'en','name','Buenos Aires British Hospital'),(5003,3730,'es','name','Hospital Británico de Buenos Aires'),(5004,3731,'de','name','Universitätsmedizin Rostock'),(5005,3732,'fr','name','Hôpital de la Tour'),(5006,3733,'en','name','American University of Armenia'),(5007,3733,'hy','name','Հայաստանի ամերիկյան համալսարան'),(5008,3734,'en','name','Brighton General Hospital'),(5009,3735,'en','name','Burke Rehabilitation Hospital'),(5010,3736,'en','name','Hangang Sacred Heart Hospital'),(5011,3736,'ko','name','한강 성심 병원'),(5012,3737,'en','name','Beth Israel Deaconess Medical Center'),(5013,3738,'ja','name','国際医療福祉大学三田病院'),(5014,3738,'no_lang_code','name','Mita Hospital'),(5015,3739,'en','name','Military Medical Academy'),(5016,3739,'sr','name','Војномедицинска академија'),(5017,3740,'en','name','Mount Desert Island Biological Laboratory'),(5018,3741,'en','name','Tanglewood Research'),(5019,3742,'en','name','Nanning Normal University'),(5020,3742,'zh','name','南宁师范大学'),(5021,3743,'en','name','Exeter Hospital'),(5022,3744,'en','name','National Health Promotion Associates'),(5023,3745,'en','name','Hackensack University Medical Center Mountainside'),(5024,3746,'en','name','XinHua Hospital'),(5025,3746,'zh','name','上海交通大学医学院附属新华医院'),(5026,3747,'en','name','Bethune-Cookman University'),(5027,3748,'fr','name','Hôpital d\'Hautepierre'),(5028,3749,'en','name','Croydon University Hospital'),(5029,3750,'en','name','Lala Lajpat Rai Memorial Medical College'),(5030,3751,'ja','name','公立南丹病院'),(5031,3751,'no_lang_code','name','Nantan General Hospital'),(5032,3752,'en','name','American Society of Mechanical Engineers'),(5033,3753,'en','name','Institute for Medical Informatics and Biostatistics'),(5034,3754,'no_lang_code','name','King Fahad Hospital Hufūf'),(5035,3755,'en','name','Regina Margherita hospital'),(5036,3755,'it','name','Ospedale Regina Margherita'),(5037,3756,'de','name','Helmut-Schmidt-Universität'),(5038,3756,'en','name','Helmut Schmidt University'),(5039,3757,'en','name','Hyogo Prefectural Amagasaki General Medical Center'),(5040,3757,'ja','name','兵庫県立尼崎総合医療センター'),(5041,3758,'en','name','Northeastern Illinois University'),(5042,3759,'en','name','Ecologic Institute'),(5043,3760,'en','name','Zhejiang Chinese Medical University'),(5044,3760,'zh','name','浙江中医药大学'),(5045,3761,'en','name','European Science Foundation'),(5046,3762,'en','name','Imam Hossein University'),(5047,3762,'fa','name','دانشگاه امام حسین'),(5048,3763,'en','name','Allina Health'),(5049,3764,'en','name','Virginia State University'),(5050,3764,'fr','name','Université d\'État de virginie'),(5051,3765,'no_lang_code','name','Beijing YouAn Hospital'),(5052,3765,'zh','name','北京佑安医院'),(5053,3766,'it','name','Consorzio Nazionale Interuniversitario per i Trasporti e la Logistica'),(5054,3767,'pt','name','Instituto Superior de Paços de Brandão'),(5055,3768,'en','name','Toyohashi University of Technology'),(5056,3768,'ja','name','豊橋技術科学大学'),(5057,3769,'tr','name','Medeniyet Üniversitesi Göztepe Eğitim ve Araştırma Hastanesi'),(5058,3770,'it','name','Polo Universitario Città di Prato'),(5059,3771,'pt','name','Centro Universitário Filadélfia'),(5060,3772,'en','name','Hospital Labbafinejad'),(5061,3772,'fa','name','بیمارستان لبافی‌نژ'),(5062,3773,'pt','name','Instituto Superior da Maia'),(5063,3774,'en','name','Palo Alto University'),(5064,3775,'es','name','Hospital de Especialidades'),(5065,3776,'no_lang_code','name','Ganga Hospital'),(5066,3777,'ar','name','وزارة الصحة - الصفحة الرئيسية'),(5067,3777,'en','name','Ministry of Health and Population'),(5068,3778,'sv','name','Hallands sjukhus Halmstad'),(5069,3779,'en','name','West Virginia University Hospitals'),(5070,3780,'en','name','Dorset County Hospital'),(5071,3781,'en','name','Methodist University Hospital'),(5072,3782,'en','name','Bharathiar University'),(5073,3782,'hi','name','भरतिआर विश्वविध्यालय'),(5074,3782,'ml','name','ഭാരതിയാർ സർവ്വകലാശാല'),(5075,3782,'ta','name','பாரதியார் பல்கலைக்கழகம்'),(5076,3783,'en','name','Hospital Colentina'),(5077,3783,'ro','name','Spitalul Clinic Colentina'),(5078,3784,'en','name','Hunter Holmes McGuire VA Medical Center'),(5079,3785,'en','name','National University Hospital'),(5080,3786,'en','name','Iowa Medical Society'),(5081,3787,'en','name','Institute of Medical Biology'),(5082,3788,'en','name','Lakewood Regional Medical Center'),(5083,3789,'en','name','American Health Care Association'),(5084,3790,'en','name','Shri Maharaja Hari Singh Hospital'),(5085,3791,'en','name','Harefield Hospital'),(5086,3792,'en','name','International Goodwill Hospital'),(5087,3792,'ja','name','国際親善総合病院'),(5088,3793,'en','name','Catholic University of Daegu'),(5089,3793,'ko','name','대구가톨릭대학교'),(5090,3794,'en','name','Nagoya Central Hospital'),(5091,3794,'ja','name','名古屋セントラル病院'),(5092,3795,'en','name','University of Cauca'),(5093,3795,'es','name','Universidad del Cauca'),(5094,3796,'en','name','Minami Wakayama Medical Center'),(5095,3796,'ja','name','国立病院機構南和歌山医療センタ'),(5096,3797,'en','name','MultiCare Health System'),(5097,3798,'ca','name','Hospital Universitari de Girona Doctor Josep Trueta'),(5098,3798,'es','name','Residencia Sanitaria de la Seguridad Social de Gerona'),(5099,3799,'en','name','Birmingham General Hospital'),(5100,3800,'en','name','Norrköping Hospital'),(5101,3801,'en','name','Massachusetts Eye and Ear Infirmary'),(5102,3802,'sv','name','Länssjukhuset i Kalmar'),(5103,3803,'en','name','Kanchi Kamakoti CHILDS Trust Hospital'),(5104,3804,'en','name','Minnesota Department of Health'),(5105,3805,'en','name','First Pavlov State Medical University of St. Petersburg'),(5106,3805,'ru','name','Первый Санкт-Петербургский государственный медицинский университет имени академика И. П. Павлова'),(5107,3806,'en','name','North Maharashtra University'),(5108,3806,'hi','name','उत्तर महाराष्ट्र विश्वविद्यालय'),(5109,3807,'en','name','Holy Cross Hospital'),(5110,3808,'en','name','Legacy Health'),(5111,3809,'en','name','Montreal General Hospital'),(5112,3809,'fr','name','Hôpital Général de Montréal'),(5113,3810,'ar','name','جامعة الخليج العربي'),(5114,3810,'en','name','Arabian Gulf University'),(5115,3810,'fa','name','دانشگاه خلیج عربی'),(5116,3811,'en','name','Southern Utah University'),(5117,3812,'en','name','Mount Gould Hospital'),(5118,3813,'el','name','ινστιτούτο υγείας του παιδιού'),(5119,3813,'en','name','Institute of Child Health'),(5120,3814,'en','name','Banner Sun Health Research Institute'),(5121,3815,'en','name','National Chiayi University'),(5122,3815,'zh','name','國立嘉義大學'),(5123,3816,'he','name','מִשְׂגָּב לַדָּךְ'),(5124,3816,'no_lang_code','name','Misgav Ladach'),(5125,3817,'en','name','AnMed Health Medical Center'),(5126,3818,'en','name','Japan Women\'s University'),(5127,3818,'ja','name','日本女子大学'),(5128,3819,'nl','name','Elisabeth-TweeSteden Ziekenhuis'),(5129,3820,'en','name','Campus Bio-Medico University'),(5130,3820,'it','name','Università Campus Bio-Medico'),(5131,3821,'en','name','Chung-Ang University Hospital'),(5132,3821,'ko','name','중앙대학교의료원'),(5133,3822,'no_lang_code','name','Ingenieria Y Economia Del Transporte'),(5134,3823,'da','name','Sjællands universitetshospital, Køge'),(5135,3823,'en','name','Zealand University Hospital Køge'),(5136,3824,'sv','name','Lasarettet i Motala'),(5137,3825,'fr','name','Centre Hospitalier Victor Dupouy'),(5138,3826,'en','name','Amirkabir University of Technology'),(5139,3826,'fa','name','دانشگاه صنعتی امیرکبیر'),(5140,3827,'no_lang_code','name','Rolls-Royce (United Kingdom)'),(5141,3828,'en','name','Imo State University Teaching Hospital'),(5142,3829,'fa','name','بیمارستان خلیلی'),(5143,3829,'no_lang_code','name','Khalili Hospital'),(5144,3830,'en','name','Pilgrim Hospital'),(5145,3831,'en','name','Canberra Hospital'),(5146,3832,'en','name','Soon Chun Hyang University Cheonan Hospital'),(5147,3832,'ko','name','순천향대학교 천안병원'),(5148,3833,'en','name','Meiji University of Integrative Medicine'),(5149,3833,'ja','name','明治国際医療大学'),(5150,3834,'en','name','Punjab Medical College'),(5151,3835,'en','name','Alameda Health System'),(5152,3836,'en','name','Iowa City VA Health Care System'),(5153,3837,'no_lang_code','name','Pivotal Labs'),(5154,3838,'en','name','Staten Island University Hospital'),(5155,3839,'en','name','University of Matanzas, University of Matanzas \"Camilo Cienfuegos\"'),(5156,3839,'es','name','Universidad de Matanzas \"Camilo Cienfuegos\"'),(5157,3840,'en','name','University of Mogi das Cruzes'),(5158,3840,'pt','name','Universidade de Mogi das Cruzes'),(5159,3841,'no_lang_code','name','National Grid (United Kingdom)'),(5160,3842,'en','name','Rangaraya Medical College'),(5161,3843,'de','name','Sigmund Freud PrivatUniversität Wien Paris'),(5162,3843,'en','name','Sigmund Freud University Vienna'),(5163,3844,'ar','name','جامعة القدس'),(5164,3844,'en','name','Al-Quds University'),(5165,3844,'he','name','אוניברסיטת אל-קודס'),(5166,3845,'fr','name','Centre Hospitalier Edmond Garcin'),(5167,3846,'en','name','Porter Adventist Hospital'),(5168,3846,'fr','name','Hôpital adventiste porter'),(5169,3847,'fr','name','Hôpital Boucicaut'),(5170,3848,'en','name','Chase Farm Hospital'),(5171,3849,'bn','name','ইসলামী বিশ্ববিদ্যালয়'),(5172,3849,'en','name','Islamic University'),(5173,3850,'en','name','Tianjin Medical University Eye Hospital'),(5174,3851,'en','name','Tokyo Teishin Hospital'),(5175,3851,'ja','name','東京逓信病院'),(5176,3852,'en','name','Children\'s Hospital & Medical Center'),(5177,3853,'en','name','Hunan University of Technology'),(5178,3854,'en','name','University Park Pathology Associates'),(5179,3855,'en','name','Akashi Medical Center'),(5180,3855,'ja','name','明石医療センター'),(5181,3856,'en','name','Have Dreams'),(5182,3857,'en','name','Saint Francis Health System'),(5183,3858,'no_lang_code','name','Prime Focus World'),(5184,3859,'de','name','BG Universitätsklinikum Bergmannsheil Bochum'),(5185,3859,'en','name','BG University Hospital Bergmannsheil Bochum'),(5186,3860,'no_lang_code','name','UK Coal'),(5187,3861,'es','name','Hospital Metropolitano'),(5188,3862,'en','name','Aaron Diamond AIDS Research Center'),(5189,3863,'en','name','Cheikh Anta Diop University'),(5190,3863,'fr','name','Université Cheikh Anta Diop'),(5191,3864,'en','name','Washington State Board of Education'),(5192,3865,'no_lang_code','name','Western Forest Products'),(5193,3866,'en','name','Simpson College'),(5194,3867,'en','name','Center for Infectious Disease Research'),(5195,3868,'no_lang_code','name','IQuum (United States)'),(5196,3869,'pt','name','Hospital Garcia de Orta'),(5197,3870,'en','name','Royal Darwin Hospital'),(5198,3871,'ja','name','一橋大学'),(5199,3871,'no_lang_code','name','Hitotsubashi University'),(5200,3872,'en','name','Ifakara Health Institute'),(5201,3873,'no_lang_code','name','XMG Studio (Canada)'),(5202,3874,'no_lang_code','name','Process Research Ortech (Canada)'),(5203,3875,'en','name','Royal Edinburgh Hospital'),(5204,3876,'en','name','Yehuda Abarbanel Mental Health Center'),(5205,3876,'he','name','אברבנאל - המרכז לבריאות הנפש'),(5206,3877,'en','name','Center for Research and Telecommunication Experimentation for Networked Communities'),(5207,3878,'en','name','Peking Union Medical College Hospital'),(5208,3878,'zh','name','北京协和医院'),(5209,3879,'en','name','Chaudhary Sarwan Kumar Himachal Pradesh Krishi Vishvavidyalaya'),(5210,3880,'en','name','Buskerud University College'),(5211,3881,'en','name','Saint Luke\'s Hospital'),(5212,3882,'en','name','Maccabi Health Care Services'),(5213,3882,'he','name','מכבי שירותי בריאות‎'),(5214,3883,'pt','name','Instituto Superior Politécnico Gaya'),(5215,3884,'en','name','Ronald Reagan UCLA Medical Center'),(5216,3885,'en','name','Scripps Mercy Hospital'),(5217,3886,'en','name','Beijing Hua Xin Hospital'),(5218,3886,'zh','name','北京华信医院'),(5219,3887,'en','name','Saudi Aramco Medical Services Organization'),(5220,3888,'en','name','Alliant International University'),(5221,3889,'es','name','Hospital de Sagunto'),(5222,3890,'no_lang_code','name','Phylonix (United States)'),(5223,3891,'en','name','Pusan National University Yangsan Hospital'),(5224,3891,'ko','name','양산부산대학교병원'),(5225,3892,'no_lang_code','name','Voestalpine (Austria)'),(5226,3893,'en','name','Kaiser Permanente Santa Rosa Medical Center'),(5227,3894,'en','name','Reading Hospital'),(5228,3895,'en','name','Kilimanjaro Christian Medical Centre'),(5229,3895,'sw','name','KCMC'),(5230,3896,'tr','name','Etimesgut Asker Hastanesi'),(5231,3897,'no_lang_code','name','Materials and Electrochemical Research (United States)'),(5232,3898,'en','name','Resurrection Health Care'),(5233,3899,'no_lang_code','name','Vaexjoe Energi Ab'),(5234,3900,'no_lang_code','name','Beijing Chuiyangliu Hospital'),(5235,3900,'zh','name','北京市垂杨柳医院'),(5236,3901,'no_lang_code','name','Agropur cooperative'),(5237,3902,'it','name','Ospedale Sant\'Anna'),(5238,3903,'en','name','Maryland Science Center'),(5239,3904,'pt','name','Centro Universitário de Belo Horizonte, Centro Universitário de belo Horizonte'),(5240,3905,'fr','name','Centre Hospitalier Universitaire Henri-Mondor'),(5241,3906,'en','name','Froedtert Menomonee Falls Hospital'),(5242,3907,'en','name','Georgian Court University'),(5243,3908,'no_lang_code','name','Advanced Fuel Research (United States)'),(5244,3909,'en','name','Harris Health System'),(5245,3910,'fi','name','Reumasäätiön sairaala'),(5246,3911,'no_lang_code','name','Olivieri Foods'),(5247,3912,'tr','name','Rize Devlet Hastanesi'),(5248,3913,'en','name','Scientific Committee On Oceanic Research'),(5249,3914,'no_lang_code','name','Eurofins (France)'),(5250,3915,'en','name','Credit Valley Hospital'),(5251,3916,'en','name','Institute of Occupational Medicine and Environmental Health'),(5252,3916,'pl','name','Instytut Medycyny Pracy i Zdrowia Środowiskowego'),(5253,3917,'en','name','Smithsonian Astrophysical Observatory'),(5254,3917,'es','name','Observatorio Astrofísico Smithsonian'),(5255,3918,'en','name','National Institute on Deafness and Other Communication Disorders'),(5256,3919,'es','name','Red Universitaria Nacional'),(5257,3920,'en','name','Novant Health Forsyth Medical Center'),(5258,3921,'en','name','Winthrop University'),(5259,3922,'pt','name','Instituto de Engenharia de Sistemas e Computadores Investigação e Desenvolvimento'),(5260,3923,'en','name','University of Wisconsin American Family Children\'s Hospital'),(5261,3924,'en','name','Gerontological Society of America'),(5262,3925,'en','name','Al-Makassed Islamic Charitable Society Hospital'),(5263,3926,'en','name','Leighton Hospital'),(5264,3927,'en','name','Mater Children\'s Hospital'),(5265,3928,'en','name','Centre of Advanced Studies'),(5266,3929,'en','name','Ardabil University of Medical Sciences'),(5267,3929,'fa','name','دانشگاه علوم پزشکی اردبیل'),(5268,3930,'en','name','Military Hospital of Tunis'),(5269,3931,'en','name','Hanyang University Seoul Hospital'),(5270,3932,'en','name','New Mexico VA Health Care System'),(5271,3933,'en','name','Institute of Studies for the Integration of Systems'),(5272,3933,'it','name','l’Istituto di Studi per l’Integrazione dei Sistemi'),(5273,3934,'en','name','Colonial War Memorial Hospital'),(5274,3935,'en','name','Sharp Mary Birch Hospital for Women & Newborns'),(5275,3936,'en','name','Franciscan Hospital for Children'),(5276,3937,'en','name','Park University'),(5277,3938,'en','name','Buffalo General Medical Center'),(5278,3939,'en','name','German Kazakh University'),(5279,3939,'kk','name','Kazakhstan-Nemis Universitet'),(5280,3940,'be','name','Магілёўскі дзяржаўны ўніверсітэт харчавання'),(5281,3940,'en','name','Mogilev State University of Food Technologies'),(5282,3941,'en','name','Animal Health Trust'),(5283,3942,'en','name','Gandhi Medical College'),(5284,3942,'hi','name','गांधी चिकित्सा महाविद्यालय, भोपाल'),(5285,3942,'te','name','గాంధీ వైద్య కళాశాల'),(5286,3943,'en','name','Coriell Institute For Medical Research'),(5287,3944,'no_lang_code','name','Intracom Telecom (Greece)'),(5288,3945,'en','name','Lynn University'),(5289,3946,'es','name','Hospital Vozandes'),(5290,3947,'en','name','Shanghai Agrobiological Gene Center'),(5291,3947,'zh','name','上海市农业生物基因中心'),(5292,3948,'en','name','Helen Joseph Hospital'),(5293,3949,'en','name','Fukuoka University'),(5294,3949,'ja','name','福岡大学'),(5295,3950,'en','name','Yeungnam University Medical Center'),(5296,3950,'ko','name','영남대학교병원'),(5297,3951,'en','name','Oklahoma Baptist University'),(5298,3952,'en','name','Shanghai Center For Bioinformation Technology'),(5299,3952,'zh','name','上海生物信息技术研究中心'),(5300,3953,'it','name','Ospedale San Luigi Gonzaga'),(5301,3954,'en','name','Library of Congress'),(5302,3954,'es','name','Biblioteca del Congreso de Estados Unidos'),(5303,3954,'fr','name','Bibliothèque du Congrès'),(5304,3955,'en','name','Hakodate Central General Hospital'),(5305,3955,'ja','name','函館中央病院'),(5306,3956,'fr','name','Hôpital Jean-Verdier'),(5307,3957,'en','name','Meir Medical Center'),(5308,3957,'he','name','מרכז רפואי מאיר'),(5309,3958,'en','name','Kempegowda Institute of Medical Sciences'),(5310,3958,'kn','name','ಕೆಂಪೇಗೌಡ ವೈದ್ಯಕೀಯ ವಿಜ್ಞಾನ ಸಂಸ್ಥೆ'),(5311,3959,'no_lang_code','name','Doosan (United Kingdom)'),(5312,3960,'en','name','Louisiana State University at Eunice'),(5313,3960,'fr','name','Université d\'État de louisiane à eunice'),(5314,3961,'en','name','Seirei Social Welfare Community'),(5315,3962,'en','name','National Medical Center'),(5316,3963,'en','name','San Giovanni Addolorata Hospital'),(5317,3963,'it','name','Azienda Ospedaliera San Giovanni Addolorata'),(5318,3964,'el','name','γενικο νοσοκομειο αττικης'),(5319,3964,'en','name','General Hospital of Attica'),(5320,3965,'en','name','Guilan University of Medical Sciences'),(5321,3965,'fa','name','دانشگاه علوم پزشکی گیلان'),(5322,3966,'en','name','Johns Hopkins Bayview Medical Center'),(5323,3967,'en','name','Jiangsu Province Hospital'),(5324,3967,'zh','name','江苏省人民医院'),(5325,3968,'en','name','International Flame Research Foundation'),(5326,3968,'it','name','Fondazione Internazionale per la Ricerca Sulla Combustione'),(5327,3969,'en','name','Southern California University of Health Sciences'),(5328,3970,'en','name','Lady Ridgeway Hospital for Children'),(5329,3970,'si','name','රිජ්වේ ආර්යා ළමා රෝහල'),(5330,3970,'ta','name','லேடி ரிட்ஜ்வே வைத்தியசாலையில்'),(5331,3971,'en','name','National Institute of General Medical Sciences'),(5332,3972,'en','name','Henry M. Jackson Foundation'),(5333,3973,'en','name','Southport and Formby District General Hospital'),(5334,3974,'en','name','UK Health and Environment Research Institute'),(5335,3975,'es','name','Hospital Clinico San Borja Arriaran, Hospital San Borja Arriarán'),(5336,3976,'en','name','Medical Education Institute'),(5337,3977,'en','name','University Hospital of North Durham'),(5338,3978,'de','name','Lukaskrankenhaus'),(5339,3979,'en','name','Brentwood Biomedical Research Institute'),(5340,3980,'en','name','Conemaugh Memorial Medical Center'),(5341,3981,'en','name','National Yunlin University of Science and Technology'),(5342,3982,'he','name','אסותא מרכזים רפואיים'),(5343,3982,'no_lang_code','name','Assuta Medical Center'),(5344,3983,'en','name','Philadelphia Department of Public Health'),(5345,3984,'pt','name','Hospital Pró-Cardíaco'),(5346,3985,'en','name','VA St. Louis Health Care System'),(5347,3986,'en','name','Kyungpook National University Hospital'),(5348,3986,'ko','name','경북대학교병원'),(5349,3987,'en','name','Resources For The Future'),(5350,3988,'en','name','Russells Hall Hospital'),(5351,3989,'en','name','Bozok University'),(5352,3989,'tr','name','Bozok Universitesi'),(5353,3990,'no_lang_code','name','BASF (Canada)'),(5354,3991,'en','name','Redeemer University College'),(5355,3992,'en','name','Baker University'),(5356,3993,'da','name','Sundhedsstyrelsen'),(5357,3993,'en','name','Danish Health and Medicines Authority, National Board of Health'),(5358,3994,'de','name','FH Kufstein'),(5359,3994,'en','name','University of Applied Sciences Kufstein'),(5360,3995,'en','name','Guy\'s Hospital'),(5361,3996,'en','name','Sleep and Human Health Institute'),(5362,3997,'en','name','Kokushikan University'),(5363,3997,'ja','name','国士舘大学'),(5364,3998,'en','name','Kudret Eye Hospital'),(5365,3998,'tr','name','Kudret Göz Hastanesi'),(5366,3999,'en','name','Queen Alexandra Hospital'),(5367,4000,'en','name','Obstetrics and Gynecology Hospital of Fudan University'),(5368,4000,'zh','name','复旦大学附属妇产科医院'),(5369,4001,'en','name','Olabisi Onabanjo University Teaching Hospital'),(5370,4002,'en','name','Isra University'),(5371,4003,'en','name','Boston Biomedical Research Institute'),(5372,4004,'nl','name','Jeroen Bosch Ziekenhuis'),(5373,4005,'no_lang_code','name','Stemcell Technologies'),(5374,4006,'en','name','University of Agronomic Sciences and Veterinary Medicine of Bucharest'),(5375,4006,'ro','name','Universitatea de Științe Agronomice și Medicină Veterinară din București'),(5376,4007,'en','name','Southland Hospital'),(5377,4008,'es','name','Hospital Nuestra Señora de Alarcos'),(5378,4009,'en','name','Sansum Medical Clinic'),(5379,4010,'no_lang_code','name','Cell and Tissue Systems (United States)'),(5380,4011,'en','name','Letterkenny University Hospital'),(5381,4011,'ga','name','Ospidéal Ginearálta Leitir Ceanainn'),(5382,4012,'en','name','Chelyabinsk State University'),(5383,4012,'ru','name','Челябинский государственный университет'),(5384,4013,'en','name','Omar Bongo University'),(5385,4013,'fr','name','Université Omar Bongo'),(5386,4014,'en','name','Science Research Laboratory'),(5387,4015,'no_lang_code','name','Beta Technology Limited'),(5388,4016,'en','name','University Hospital of the West Indies'),(5389,4017,'en','name','Quaid-i-Azam University'),(5390,4017,'ur','name','جامعہ قائداعظم'),(5391,4018,'en','name','Indira Gandhi Institute of Child Health'),(5392,4019,'no_lang_code','name','Hôpital Antoine-Béclère'),(5393,4020,'en','name','Bhavnagar University'),(5394,4021,'es','name','Hospital Universitario de Fuenlabrada'),(5395,4022,'en','name','Alfred Health'),(5396,4023,'en','name','Qazvin University of Medical Sciences'),(5397,4023,'fa','name','دانشگاه علوم پزشكي و خدمات درماني قزوین'),(5398,4024,'fr','name','Centre Hospitalier Universitaire Pointe-à-Pitre'),(5399,4025,'en','name','Funabashi Central Hospital'),(5400,4025,'ja','name','船橋中央病院'),(5401,4026,'pt','name','Hospital Santa Marcelina'),(5402,4027,'en','name','Starship Children\'s Health'),(5403,4028,'en','name','Chinese Culture University'),(5404,4028,'zh','name','中國文化大學'),(5405,4029,'en','name','Daisy Hill Hospital'),(5406,4029,'ga','name','Otharlann Chnoc na Nóiníní'),(5407,4030,'pt','name','Hospital da Restauração'),(5408,4031,'en','name','University of New Mexico Hospital'),(5409,4031,'es','name','Hospital de la Universidad de Nuevo México'),(5410,4032,'en','name','University of Louisville Hospital'),(5411,4033,'no_lang_code','name','Seeders (South Korea)'),(5412,4034,'en','name','Tzu Chi University'),(5413,4034,'zh','name','慈濟大學'),(5414,4035,'es','name','Hospital Virgen de los Lirios'),(5415,4036,'en','name','The Association of the European Rail Industry,'),(5416,4036,'fr','name','Union des Industries Ferroviaires Européennes'),(5417,4037,'fr','name','Hôtel-Dieu de Lyon'),(5418,4038,'en','name','Sarah Lawrence College'),(5419,4039,'fr','name','Centre Hospitalier Universitaire de Rabat-Salé'),(5420,4040,'en','name','Yonsei University Health System'),(5421,4041,'en','name','Guangzhou Chest Hospital'),(5422,4041,'zh','name','广州市胸科医院'),(5423,4042,'fr','name','Hôpital Civil de Charleroi'),(5424,4043,'en','name','Father Muller Medical College Hospital'),(5425,4043,'hi','name','फादर म्युलर मेडिकल कॉलेज'),(5426,4043,'kn','name','ಫಾದೆರ್ ಮುಲ್ಲರ್ ಮೆಡಿಕಲ್ ಕಾಳಜ್'),(5427,4043,'ml','name','ഫാദർ മുള്ളെർ മെഡിക്കൽ കോളേജ്'),(5428,4043,'ta','name','பாதர் முல்லெர் மெடிக்கல் காலேஜ்'),(5429,4043,'te','name','ఫాదర్ ముల్లెర్ మెడికల్ కాలేజ్'),(5430,4044,'en','name','Notre Dame Seishin University'),(5431,4044,'ja','name','ノートルダム清心女子大学'),(5432,4045,'en','name','International Space University'),(5433,4046,'en','name','University Hospitals Geneva Medical Center'),(5434,4047,'en','name','Hospital Ludovica'),(5435,4047,'es','name','Hospital de Niños Superiora Sor María Ludovica'),(5436,4048,'en','name','Beijing Computational Science Research Center'),(5437,4048,'zh','name','北京计算科学研究中心'),(5438,4049,'en','name','Pinderfields Hospital'),(5439,4050,'en','name','Sichuan Provincial Academy of Natural Resource Sciences'),(5440,4050,'zh','name','四川省自然资源科学院'),(5441,4051,'no_lang_code','name','Tamkang University'),(5442,4051,'zh','name','淡江大學'),(5443,4052,'en','name','Third Affiliated Hospital of Sun Yat-sen University'),(5444,4053,'en','name','Harold Wood Hospital'),(5445,4054,'en','name','Nippon Steel Yawata Memorial Hospital'),(5446,4054,'ja','name','製鉄記念八幡病院'),(5447,4055,'en','name','Health Sciences University of Hokkaido'),(5448,4055,'ja','name','北海道医療大学'),(5449,4056,'en','name','Sequoia Hospital'),(5450,4057,'en','name','Changwon National University'),(5451,4057,'ko','name','창원대학교'),(5452,4058,'en','name','RMIT University'),(5453,4059,'en','name','National United University'),(5454,4060,'en','name','Missouri Botanical Garden'),(5455,4061,'en','name','VA Boston Healthcare System'),(5456,4062,'tr','name','Dr. Siyami Ersek Göğüs Kalp Ve Damar Cerrahisi Eğitim Ve Araştırma Hastanesi'),(5457,4063,'no_lang_code','name','Advanced Bioscience Laboratories (United States)'),(5458,4064,'en','name','Saint Mary\'s University of Minnesota'),(5459,4065,'en','name','Interuniversity Consortium for Magnetic Resonance'),(5460,4065,'it','name','Consorzio Interuniversitario Risonanze Magnetiche di Metallo Proteine'),(5461,4066,'es','name','Complejo Hospitalario Torrecárdenas'),(5462,4067,'no_lang_code','name','Renault (France)'),(5463,4068,'en','name','Killingbeck'),(5464,4069,'en','name','Lev Hasharon Hospital'),(5465,4069,'he','name','מרכז רפואי לבריאות הנפש לב השרון'),(5466,4070,'nl','name','Medisch Centrum Alkmaar'),(5467,4071,'en','name','Mission Hospital'),(5468,4072,'en','name','Catholic University of the Maule'),(5469,4072,'es','name','Universidad Católica del Maule'),(5470,4073,'en','name','National Institutes of Health Clinical Center'),(5471,4074,'no_lang_code','name','Teer Coatings (United Kingdom)'),(5472,4075,'en','name','Ibaraki Prefectural University of Health Sciences'),(5473,4075,'ja','name','茨城県立医療大学'),(5474,4076,'en','name','Allama Iqbal Medical College'),(5475,4076,'ur','name','علامہ اقبال میڈیکل کالج'),(5476,4077,'ja','name','旭川厚生病院'),(5477,4077,'no_lang_code','name','Asahikawa Kosei Hospital'),(5478,4078,'en','name','UCLA Medical Center'),(5479,4079,'en','name','Social Insurance Saitama Chuo Hospital'),(5480,4079,'ja','name','埼玉メディカルセンター'),(5481,4080,'en','name','Far Eastern State Medical University'),(5482,4080,'ru','name','Дальневосточный государственный медицинский университет'),(5483,4081,'en','name','Behavioral Health Research Center of the Southwest'),(5484,4082,'en','name','University of Malawi'),(5485,4083,'ko','name','삼육대학교'),(5486,4083,'no_lang_code','name','Sahmyook University'),(5487,4084,'en','name','University of Zulia'),(5488,4084,'es','name','La Universidad del Zulia'),(5489,4085,'fr','name','Hôtel-Dieu de France'),(5490,4086,'ja','name','京都桂病院'),(5491,4086,'no_lang_code','name','Kyoto Katsura Hospital'),(5492,4087,'en','name','Abderrahmane Mami Hospital'),(5493,4088,'en','name','Kuban State Medical University'),(5494,4088,'ru','name','Кубанский государственный медицинский университет'),(5495,4089,'en','name','Tamil Nadu Veterinary and Animal Sciences University'),(5496,4089,'ta','name','தமிழ்நாடு கால்நடை மருத்துவ அறிவியல் பல்கலைக்கழகம்'),(5497,4090,'pl','name','Wojewódzki Szpital Zespolony'),(5498,4091,'en','name','Nambour General Hospital'),(5499,4092,'en','name','Montreal Children\'s Hospital'),(5500,4092,'fr','name','Hôpital de Montréal pour enfants'),(5501,4093,'en','name','Andong National University'),(5502,4093,'ko','name','안동대학교'),(5503,4094,'no_lang_code','name','CFD Research Corporation (United States)'),(5504,4095,'en','name','Memorial Hospital of South Bend'),(5505,4096,'en','name','Selma University'),(5506,4097,'en','name','Sandwell General Hospital'),(5507,4098,'en','name','University of Tulsa'),(5508,4098,'fr','name','Université de tulsa'),(5509,4099,'en','name','University Heights Center'),(5510,4100,'en','name','Education Development Center'),(5511,4101,'fr','name','Hôpital d\'Instruction des Armées Sainte-Anne'),(5512,4102,'en','name','Memorial Regional Hospital'),(5513,4103,'el','name','Οφθαλμολογικό Νοσοκομείο Αθηνών'),(5514,4103,'en','name','Athens Eye Hospital'),(5515,4104,'en','name','Sanford USD Medical Center'),(5516,4105,'ar','name','مستشفى الملك فهد بجدة'),(5517,4105,'en','name','King Fahad Hospital Jeddah'),(5518,4106,'en','name','Saint Xavier University'),(5519,4107,'en','name','Southern General Hospital'),(5520,4108,'no_lang_code','name','Biomedware (United States)'),(5521,4109,'ar','name','مستشفى الدمام المركزي'),(5522,4109,'no_lang_code','name','Dammam Central Hospital'),(5523,4110,'en','name','Seokyeong University'),(5524,4110,'ko','name','서경대학교'),(5525,4111,'en','name','Connecticut Department of Mental Health and Addiction Services'),(5526,4112,'no_lang_code','name','Invotek'),(5527,4113,'ar','name','مستشفى النهضة'),(5528,4113,'no_lang_code','name','Al Nahdha Hospital'),(5529,4114,'en','name','Ibis Reproductive Health'),(5530,4115,'en','name','Mercy St. Vincent Medical Center'),(5531,4116,'en','name','Baby Memorial Hospital'),(5532,4117,'en','name','Rainbow Babies & Children\'s Hospital'),(5533,4118,'no_lang_code','name','Nova Chemicals (Canada)'),(5534,4119,'en','name','Shin Kong WHS Memorial Hospital'),(5535,4120,'de','name','Institut für Mobil- und Satellitenfunktechnik'),(5536,4120,'en','name','Institute for Mobile and Satellite Communication Technology'),(5537,4121,'no_lang_code','name','Academic Edge'),(5538,4122,'en','name','Great Western Hospital'),(5539,4123,'en','name','Shenzhen Third People’s Hospital'),(5540,4123,'zh','name','深圳市第三人民医院'),(5541,4124,'ja','name','兵庫県立西宮病院'),(5542,4124,'no_lang_code','name','Hyogo Prefectural Nishinomiya Hospital'),(5543,4125,'en','name','Khyber Teaching Hospital'),(5544,4126,'en','name','Southern Hills Medical Center'),(5545,4127,'en','name','Telethon Foundation'),(5546,4127,'it','name','Fondazione Telethon'),(5547,4128,'en','name','American Society for Microbiology'),(5548,4129,'en','name','Manchester Royal Eye Hospital'),(5549,4130,'en','name','The Pirbright Institute'),(5550,4131,'en','name','Sin-Lau Christian Hospital'),(5551,4132,'no_lang_code','name','Apption'),(5552,4133,'en','name','R. K. Khan Hospital'),(5553,4134,'no_lang_code','name','Nokia (Belgium)'),(5554,4135,'en','name','LAC+USC Medical Center'),(5555,4136,'no_lang_code','name','SOLINET'),(5556,4137,'ar','name','مستشفى الملك فهد المركزي بجازان'),(5557,4137,'en','name','King Fahad Central Hospital'),(5558,4138,'ar','name','المستشفى الأميري'),(5559,4138,'no_lang_code','name','Amiri Hospital'),(5560,4139,'en','name','University Hospital Limerick'),(5561,4139,'ga','name','Ospidéal na hOllscoile, Luimneach'),(5562,4140,'en','name','Arkansas State Department of Human Services'),(5563,4141,'en','name','Southern University at Shreveport'),(5564,4142,'en','name','Government Medical College'),(5565,4143,'en','name','Wuhan Medical Center for Women and Children'),(5566,4144,'en','name','Stavropol State Medical University'),(5567,4144,'ru','name','Ставропольский государственный медицинский университет'),(5568,4145,'cy','name','Prifysgol Westminster'),(5569,4145,'en','name','University of Westminster'),(5570,4146,'en','name','Cape Cod Hospital'),(5571,4147,'en','name','California Baptist University'),(5572,4148,'en','name','Central Institute for the Deaf'),(5573,4149,'en','name','Launceston General Hospital'),(5574,4150,'it','name','Ospedale di Livorno'),(5575,4151,'en','name','Osaka University of Health and Sport Sciences'),(5576,4151,'ja','name','大阪体育大学'),(5577,4152,'no_lang_code','name','New England Biolabs (United States)'),(5578,4153,'en','name','Caroline Chisholm Centre for Health Ethics'),(5579,4154,'no_lang_code','name','Pilkington (United Kingdom)'),(5580,4155,'no_lang_code','name','Jennerex Biotherapeutics (Canada)'),(5581,4156,'no_lang_code','name','Encana (Canada)'),(5582,4157,'fr','name','Institut Sénégalais de Recherches Agricoles'),(5583,4158,'en','name','Carlo Forlanini Hospital'),(5584,4159,'en','name','Alder Hey Children\'s Hospital'),(5585,4160,'en','name','St.John\'s Medical College Hospital'),(5586,4161,'en','name','Atlanta VA Medical Center'),(5587,4162,'no_lang_code','name','Xerox (Canada)'),(5588,4163,'en','name','American Hospital Association'),(5589,4164,'no_lang_code','name','Pouliadis Associates Corporation'),(5590,4165,'en','name','Yunnan University of Traditional Chinese Medicine'),(5591,4165,'zh','name','云南中医药大学'),(5592,4166,'de','name','Leibniz-Institut für Festkörper- und Werkstoffforschung Dresden'),(5593,4166,'en','name','Leibniz Institute for Solid State and Materials Research'),(5594,4167,'no_lang_code','name','Kantar Health (United States)'),(5595,4168,'en','name','National Hispanic University'),(5596,4169,'en','name','Children\'s Mercy Hospital'),(5597,4170,'en','name','Health Protection Scotland'),(5598,4171,'en','name','Guthrie Hospice'),(5599,4172,'no_lang_code','name','PSA Peugeot Citroën (France)'),(5600,4173,'en','name','Thomas Jefferson University Hospital'),(5601,4174,'en','name','Clalit Health Services'),(5602,4174,'he','name','שירותי בריאות כללית'),(5603,4175,'en','name','University Hospital of Alexandroupolis'),(5604,4176,'en','name','Public Health Solutions'),(5605,4177,'en','name','Shahid Bahonar University of Kerman'),(5606,4177,'fa','name','دانشگاه شهید باهنر کرمان'),(5607,4178,'en','name','Pennsylvania Department of Human Services'),(5608,4179,'en','name','Nil Ratan Sircar Medical College and Hospital'),(5609,4179,'ne','name','नील रतन सरकार मेडिकल कॉलेज र अस्पताल'),(5610,4180,'en','name','Wise & Munro Learning Research'),(5611,4181,'en','name','Fenway Health'),(5612,4182,'en','name','National Cheng Kung University Hospital'),(5613,4183,'en','name','Canadian Dairy Network'),(5614,4184,'no_lang_code','name','Baylis Medical (Canada)'),(5615,4185,'en','name','Airedale General Hospital'),(5616,4186,'pt','name','Universidade de Franca'),(5617,4187,'en','name','KIST Medical College'),(5618,4188,'en','name','Kintampo Health Research Centre'),(5619,4189,'en','name','SRM Institute of Science and Technology'),(5620,4189,'ta','name','திரு. இராமசாமி நினைவுப் பல்கலைக்கழகம்'),(5621,4190,'en','name','Taipei Medical University'),(5622,4191,'en','name','Polyclinic General Hospital'),(5623,4192,'en','name','Hizen Psychiatric Center'),(5624,4192,'ja','name','肥前精神医療センター'),(5625,4193,'no_lang_code','name','Airbus (Spain)'),(5626,4194,'ja','name','日本医科大学千葉北総病院'),(5627,4194,'no_lang_code','name','Chiba Hokusou Hospital'),(5628,4195,'en','name','Sriram Chandra Bhanja Medical College Hospital'),(5629,4195,'or','name','ଶ୍ରୀରାମ ଚନ୍ଦ୍ର ଭଞ୍ଜ ଭେଷଜ ମହାବିଦ୍ୟାଳୟ'),(5630,4196,'en','name','Hunter New England Local Health District'),(5631,4197,'en','name','Royal Surrey NHS Foundation Trust'),(5632,4198,'en','name','Massachusetts Department of Public Health'),(5633,4199,'en','name','St Mary\'s Hospital'),(5634,4200,'en','name','Washington DC VA Medical Center'),(5635,4201,'en','name','Hokkaido Institute of Public Health'),(5636,4201,'ja','name','北海道立衛生研究所'),(5637,4202,'en','name','Bangalore University'),(5638,4202,'fr','name','Université de bangalore'),(5639,4202,'hi','name','बंगलौर विश्वविद्यालय'),(5640,4202,'kn','name','ಬೆಂಗಳೂರು ವಿಶ್ವವಿದ್ಯಾಲಯ'),(5641,4202,'mr','name','बंगळुरू विद्यापीठ'),(5642,4202,'ta','name','பெங்களூர்ப் பல்கலைக்கழகம்'),(5643,4202,'te','name','బెంగుళూరు విశ్వవిద్యాలయం'),(5644,4203,'nl','name','Altrecht GGZ'),(5645,4204,'en','name','Global Medical Imaging'),(5646,4205,'en','name','Kansas City VA Medical Center'),(5647,4206,'en','name','Oita University Hospital'),(5648,4206,'ja','name','大分大学医学部附属病院'),(5649,4207,'en','name','MRC Human Nutrition Research'),(5650,4208,'no_lang_code','name','Bolder Biotechnology, Inc.'),(5651,4209,'en','name','Botsford Hospital'),(5652,4210,'en','name','Jacksonville University'),(5653,4210,'es','name','Universidad de Jacksonville'),(5654,4210,'fr','name','Université de jacksonville'),(5655,4211,'en','name','Scunthorpe General Hospital'),(5656,4212,'no_lang_code','name','Inovamais'),(5657,4213,'en','name','Eisenhower Medical Center'),(5658,4214,'no_lang_code','name','D\'Appolonia (Italy)'),(5659,4215,'en','name','Madras Medical College'),(5660,4215,'ta','name','மதராசு மருத்துவக் கல்லூரி'),(5661,4215,'te','name','మద్రాస్ వైద్య కళాశాల'),(5662,4216,'el','name','ΚΩΝΣΤΑΝΤΟΠΟΥΛΕΙΟ ΓΕΝΙΚΟ ΝΟΣΟΚΟΜΕΙΟ ΝΕΑΣ ΙΩΝΙΑΣ'),(5663,4216,'en','name','Agia Olga Hospital'),(5664,4217,'ar','name','أطفال مستشفى تونس'),(5665,4217,'en','name','Children\'s Hospital'),(5666,4218,'fr','name','Hôpital Albert-Chenevier'),(5667,4219,'en','name','Dartmouth Institute for Health Policy and Clinical Practice'),(5668,4220,'en','name','Tumaini University'),(5669,4220,'sw','name','Chuo Kikuu cha Tumaini'),(5670,4221,'en','name','American Academy of Pediatrics'),(5671,4222,'en','name','Kootenai Medical Center'),(5672,4223,'en','name','Mercy Medical Center'),(5673,4224,'en','name','The Graduate University for Advanced Studies, SOKENDAI'),(5674,4224,'ja','name','総合研究大学院大学'),(5675,4225,'no_lang_code','name','National Nuclear Corporation (United Kingdom)'),(5676,4226,'en','name','Frankston Hospital'),(5677,4227,'it','name','Ospedale Martini'),(5678,4228,'es','name','Hospital General de La Rioja'),(5679,4229,'en','name','Fatima Jinnah Medical University'),(5680,4229,'ur','name','فاطمہ جناح میڈیکل کالج'),(5681,4230,'en','name','Gentofte Hospital'),(5682,4231,'it','name','Ospedale Buccheri la Ferla Fatebenefratelli'),(5683,4232,'en','name','Jiangsu Normal University'),(5684,4232,'zh','name','江苏师范大学'),(5685,4233,'en','name','Minot State University'),(5686,4233,'fr','name','Université d\'État de minot'),(5687,4234,'ja','name','大阪教育大学'),(5688,4234,'no_lang_code','name','Osaka Kyoiku University'),(5689,4235,'en','name','Garrahan Hospital'),(5690,4236,'en','name','Tumor Hospital of Guangxi Medical University'),(5691,4236,'zh','name','广西医科大学肿瘤医院'),(5692,4237,'es','name','Institut d\'Investigació Aplicada de l\'Automòbil'),(5693,4237,'no_lang_code','name','Applus+ IDIADA (Spain)'),(5694,4238,'fr','name','Hôpital Universitaire Dupuytren'),(5695,4239,'no_lang_code','name','Micralyne'),(5696,4240,'en','name','The University of Texas of the Permian Basin'),(5697,4241,'en','name','Department of Defence'),(5698,4242,'en','name','Stockholm Environment Institute'),(5699,4243,'ja','name','ペプチドリーム'),(5700,4243,'no_lang_code','name','Peptidream (Japan)'),(5701,4244,'no_lang_code','name','Sinhgad Dental College and Hospital'),(5702,4245,'cy','name','Ysbyty Stoke Mandeville'),(5703,4245,'en','name','Stoke Mandeville Hospital'),(5704,4246,'en','name','MRC Epidemiology Unit'),(5705,4247,'en','name','New Mexico Regional Federal Medical Center'),(5706,4248,'en','name','Nishijin Hospital'),(5707,4248,'ja','name','西陣病院'),(5708,4249,'en','name','Gelre Hospitals'),(5709,4249,'nl','name','Gelre Ziekenhuizen'),(5710,4250,'es','name','Hospital del Niño'),(5711,4251,'en','name','Temple Street Children\'s University Hospital'),(5712,4252,'en','name','Ohio Northern University'),(5713,4253,'en','name','Greenville Memorial Hospital'),(5714,4254,'no_lang_code','name','Enel (Italy)'),(5715,4255,'fr','name','Hopital Universitaire Habib Bourguiba'),(5716,4256,'pl','name','Wojewódzki Szpital Zespolony im. Jędrzeja Śniadeckiego'),(5717,4257,'en','name','Shodair Children\'s Hospital'),(5718,4258,'en','name','Michael E. DeBakey VA Medical Center'),(5719,4259,'en','name','Sinai Hospital'),(5720,4260,'en','name','Royal Manchester Children\'s Hospital'),(5721,4261,'en','name','Liaocheng People\'s Hospital'),(5722,4261,'zh','name','聊城市人民医院'),(5723,4262,'no_lang_code','name','Jaslok Hospital'),(5724,4263,'fr','name','Hôpital Saint-Jacques'),(5725,4264,'en','name','Shuto General Hospital'),(5726,4264,'ja','name','周東総合病院'),(5727,4265,'en','name','Institute for Medical Research and Occupational Health'),(5728,4266,'en','name','Southeastern Louisiana University'),(5729,4266,'es','name','Universidad del Sudeste de Luisiana'),(5730,4267,'en','name','Hermanos Ameijeiras Hospital'),(5731,4267,'es','name','Hospital Clínico Quirúrgico \"Hermanos Ameijeiras\"'),(5732,4268,'en','name','Deaconess Hospital'),(5733,4269,'en','name','Guangzhou Eighth People\'s Hospital'),(5734,4269,'zh','name','广州市第八人民医院'),(5735,4270,'en','name','Tamil University'),(5736,4270,'ml','name','തമിഴ് സർവകലാശാല'),(5737,4270,'ta','name','தமிழ்ப் பல்கலைக்கழகம், தஞ்சாவூர்'),(5738,4271,'ar','name','مستشفى ابن سينا'),(5739,4271,'no_lang_code','name','Ibn Sina Hospital'),(5740,4272,'bn','name','আসাম বিশ্ববিদ্যালয়'),(5741,4272,'en','name','Assam University'),(5742,4272,'hi','name','असम विश्वविद्यालय'),(5743,4273,'en','name','Kanazawa Medical University'),(5744,4273,'ja','name','金沢医科大学'),(5745,4274,'en','name','MRC Toxicology Unit'),(5746,4275,'en','name','Mitsubishi Kyoto Hospital'),(5747,4275,'ja','name','三菱京都病院'),(5748,4276,'en','name','Institute of the Pupils of the Army'),(5749,4276,'pt','name','Instituto dos Pupilos do Exército'),(5750,4277,'en','name','University of South Alabama Medical Center'),(5751,4278,'no_lang_code','name','STMicroelectronics (Italy)'),(5752,4279,'en','name','East Texas Medical Center'),(5753,4280,'en','name','International University of Health and Welfare'),(5754,4280,'ja','name','国際医療福祉大学'),(5755,4281,'en','name','Kyung Hee University East-West Neo Medical Center'),(5756,4281,'ko','name','경희대학교 동서신의학병원 - 협진진료센터'),(5757,4282,'en','name','Martha-Maria Hospital'),(5758,4283,'en','name','Los Alamos Medical Center'),(5759,4284,'en','name','Miriam Hospital'),(5760,4285,'en','name','Princess Royal Maternity Hospital'),(5761,4286,'en','name','Benedictine University'),(5762,4287,'en','name','Ewha Womans University'),(5763,4287,'ko','name','이화여자대학교'),(5764,4288,'en','name','Royal Bolton Hospital'),(5765,4289,'en','name','Sichuan University of Science and Engineering'),(5766,4289,'zh','name','四川理工学院'),(5767,4290,'tr','name','Pamukkale Üniversitesi Hastaneleri'),(5768,4291,'en','name','Primary Children\'s Hospital'),(5769,4292,'en','name','Osaka Dental University'),(5770,4292,'ja','name','大阪歯科大学'),(5771,4293,'en','name','Sevastopol National Technical University'),(5772,4293,'ru','name','Севастопольский национальный технический университет'),(5773,4293,'uk','name','Севастопольський національний технічний університет'),(5774,4294,'no_lang_code','name','Fujitsu (United Kingdom)'),(5775,4295,'en','name','Kenyatta National Hospital'),(5776,4296,'no_lang_code','name','Biomedical Development Corporation'),(5777,4297,'en','name','Santa Maria Nuova Hospital'),(5778,4297,'it','name','Ospedale di Santa Maria Nuova'),(5779,4298,'ar','name','مستشفى الملك خالد'),(5780,4298,'en','name','King Khaled Hospital'),(5781,4299,'en','name','Ryhov Hospital Jönköping'),(5782,4300,'ja','name','草加市立病院'),(5783,4300,'no_lang_code','name','Soka Municipal Hospital'),(5784,4301,'en','name','University Children\'s Hospital, Belgrade'),(5785,4301,'sr','name','Univerzitetska dečja klinika u Beogradu'),(5786,4302,'en','name','Lviv Polytechnic National University'),(5787,4302,'pl','name','Politechnika Lwowska'),(5788,4302,'ru','name','Национальный университет «Львовская политехника»'),(5789,4302,'uk','name','Національний університет «Львівська політехніка»'),(5790,4303,'en','name','Public Health – Seattle & King County'),(5791,4304,'en','name','New Jersey City University'),(5792,4305,'tr','name','Ankara Atatürk Göğüs Hastalıkları Ve Göğüs Cerrahisi Eğitim Ve Araştırma Hastanesi'),(5793,4306,'en','name','Gifu Red Cross Hospital'),(5794,4306,'ja','name','岐阜赤十字病院'),(5795,4307,'fr','name','Hôpital Maison Blanche'),(5796,4308,'no_lang_code','name','Universal Hi-Tech Development'),(5797,4309,'en','name','Chang Gung Children\'s Hospital'),(5798,4310,'en','name','Queen Margaret Hospital'),(5799,4311,'en','name','Framingham Union Hospital'),(5800,4312,'en','name','Central Connecticut State University'),(5801,4312,'es','name','Universidad Estatal de Connecticut Central'),(5802,4313,'en','name','Holy Cross Hospital'),(5803,4314,'en','name','Clinical Centre of Kragujevac'),(5804,4314,'sr','name','Клинички центар Крагујевац'),(5805,4315,'en','name','Arkansas Department of Health'),(5806,4316,'en','name','Ningbo No.6 Hospital'),(5807,4316,'zh','name','宁波市第六医院'),(5808,4317,'en','name','Hera General Hospital'),(5809,4318,'no_lang_code','name','Glencore (Switzerland)'),(5810,4319,'en','name','Chungbuk National University Hospital'),(5811,4320,'en','name','Ministry of Health'),(5812,4320,'vi','name','Bộ Y tế (Việt Nam)'),(5813,4321,'en','name','Association of European Renewable Energy Research Centres'),(5814,4322,'nl','name','Kiwa'),(5815,4323,'no_lang_code','name','CRE Group (United States)'),(5816,4324,'fr','name','Hôpital de Sion'),(5817,4325,'en','name','MRC Cognition and Brain Sciences Unit'),(5818,4326,'en','name','Middlemore Hospital'),(5819,4327,'en','name','Arkansas Foundation for Medical Care'),(5820,4328,'ba','name','Юғары иҡтисад мәктәбе'),(5821,4328,'en','name','National Research University Higher School of Economics'),(5822,4328,'ru','name','Высшая школа экономики'),(5823,4329,'no_lang_code','name','Nimbus Landscape Materials (United States)'),(5824,4330,'en','name','Union Hospital'),(5825,4331,'no_lang_code','name','Ada Technologies (United States)'),(5826,4332,'en','name','Oregon Department of Human Services'),(5827,4333,'en','name','Baltimore County Department of Health'),(5828,4334,'en','name','North Eastern Hill University'),(5829,4334,'ur','name','نارتھ ایسٹ ہل یونیورسٹی'),(5830,4335,'en','name','Earth and Space Research'),(5831,4336,'en','name','Saint Peter\'s University Hospital'),(5832,4337,'es','name','Hospital General Universitario de Albacete'),(5833,4338,'it','name','Azienda Ospedaliera di Desio e Vimercate'),(5834,4339,'en','name','Addenbrooke\'s Hospital'),(5835,4340,'de','name','Österreichische Agentur für Gesundheit und Ernährungssicherheit'),(5836,4340,'en','name','Austrian Agency for Health and Food Safety'),(5837,4341,'en','name','Rose Medical Center'),(5838,4342,'no_lang_code','name','Klein Buendel (United States)'),(5839,4343,'en','name','John Innes Centre'),(5840,4344,'it','name','Ospedale Monaldi'),(5841,4345,'en','name','DR. B.R.A. Institute Rotary Cancer Hospital'),(5842,4346,'en','name','University Hospital Medical Center at Treichville'),(5843,4346,'fr','name','Centre Hospitalier Universitaire de Treichville'),(5844,4347,'en','name','United States Office of Personnel Management'),(5845,4348,'en','name','Stanley Medical College'),(5846,4348,'ta','name','இசுடான்லி மருத்துவக் கல்லூரி'),(5847,4349,'en','name','Bowie State University'),(5848,4350,'en','name','Connecticut Mental Health Center'),(5849,4351,'no_lang_code','name','Nanoprobes (United States)'),(5850,4352,'en','name','Seoul St. Mary\'s Hospital'),(5851,4353,'no_lang_code','name','Applied Biological Materials (Canada)'),(5852,4354,'en','name','Health Forecasting'),(5853,4355,'en','name','Siksha O Anusandhan University'),(5854,4356,'en','name','Children\'s Hospital at Dartmouth Hitchcock'),(5855,4357,'en','name','Aurora Sinai Medical Center'),(5856,4358,'ar','name','مستشفى عسير المركزي'),(5857,4358,'en','name','Asir Central Hospital'),(5858,4359,'it','name','Ospedale di Monfalcone'),(5859,4360,'en','name','SSM Health Care'),(5860,4361,'en','name','The Keystone Center'),(5861,4362,'es','name','Hospital Doctor Hernán Henríquez Aravena'),(5862,4363,'en','name','Penza State University'),(5863,4363,'ru','name','Пензенский государственный университет'),(5864,4364,'en','name','Indira Gandhi Medical College'),(5865,4365,'en','name','Metropolitan State University'),(5866,4366,'no_lang_code','name','Virtually Better'),(5867,4367,'en','name','Council of Chief State School Officers'),(5868,4368,'ja','name','もりのみや ほｓぴたｌ'),(5869,4368,'no_lang_code','name','Morinomiya Hospital'),(5870,4369,'no_lang_code','name','Fortis Hospital'),(5871,4370,'de','name','Kantonsspital Aarau'),(5872,4371,'en','name','Nicosia General Hospital'),(5873,4372,'en','name','Le Bonheur Children\'s Hospital'),(5874,4373,'el','name','Γενικό Νοσοκομείο Πατρών'),(5875,4373,'no_lang_code','name','Agios Andreas Hospital'),(5876,4374,'fr','name','Hôpital Mustapha Pacha'),(5877,4375,'en','name','Jinnah University for Women'),(5878,4375,'ur','name','جناح یونیورسٹی برائے خواتین'),(5879,4376,'en','name','Gujarat Ayurved University'),(5880,4376,'gu','name','ગુજરાત આયુર્વેદ યુનિવર્સિટી'),(5881,4376,'hi','name','गुजरात आयुर्वेद विश्वविद्यालय'),(5882,4377,'tr','name','Farabi Hastanesi'),(5883,4378,'en','name','Princess Royal Hospital'),(5884,4379,'ro','name','Spitalul Clinic de Recuperare'),(5885,4380,'en','name','Sree Chitra Thirunal Institute for Medical Sciences and Technology'),(5886,4381,'ja','name','相澤病院'),(5887,4381,'no_lang_code','name','Aizawa Hospital'),(5888,4382,'en','name','Smith-Kettlewell Eye Research Institute'),(5889,4383,'en','name','Metropolitan University of Educational Sciences'),(5890,4383,'es','name','Universidad Metropolitana de Ciencias de la Educación'),(5891,4384,'no_lang_code','name','Kestrel Corporation'),(5892,4385,'pt','name','Hospital Maria Pia'),(5893,4386,'el','name','Γενικό Νοσοκομείο Σισμανόγλειο'),(5894,4386,'en','name','Sismanoglio General Hospital'),(5895,4387,'en','name','Kohat University of Science and Technology'),(5896,4388,'en','name','University of Massachusetts Donahue Institute'),(5897,4389,'en','name','Tokyo Yamate Medical Center'),(5898,4389,'ja','name','東京山手メディカルセンター'),(5899,4390,'ja','name','高知県立中央病院'),(5900,4390,'no_lang_code','name','Kochi Municipal Central Hospital'),(5901,4391,'en','name','IIT Research Institute'),(5902,4392,'ar','name','وزارة الصحة'),(5903,4392,'en','name','Ministry of Health'),(5904,4393,'en','name','West Virginia Wesleyan College'),(5905,4394,'en','name','Affiliated Hospital of Guangdong Medical College Hospital'),(5906,4395,'es','name','Hospital del Trabajador'),(5907,4396,'en','name','Hospital for Sick Children'),(5908,4397,'ja','name','勝又病院'),(5909,4397,'no_lang_code','name','Katsumata Hospital'),(5910,4398,'en','name','Franklin Institute'),(5911,4399,'fr','name','Hôpital Saint-Michel'),(5912,4400,'fr','name','Hôpital Paule de Viguier'),(5913,4401,'en','name','Hamamatsu University'),(5914,4401,'ja','name','浜松大学'),(5915,4402,'fr','name','Centre hospitalier Robert-Ballanger'),(5916,4403,'en','name','Canadian Medical Association'),(5917,4403,'fr','name','Association Médicale Canadienne'),(5918,4404,'en','name','National Institute of Biomedical Genomics'),(5919,4405,'en','name','Kansas Department for Children and Families'),(5920,4406,'en','name','Punjab Institute of Medical Sciences'),(5921,4407,'en','name','Medical Research Institute'),(5922,4408,'en','name','Republic of Palau Ministry of Health'),(5923,4409,'en','name','Northwest Research Associates'),(5924,4410,'en','name','University of North Alabama'),(5925,4411,'no_lang_code','name','Clinical Tools, Inc.'),(5926,4412,'en','name','Southport and Ormskirk Hospital NHS Trust'),(5927,4413,'no_lang_code','name','Nexeon (United Kingdom)'),(5928,4414,'en','name','McGill University and Génome Québec Innovation Centre'),(5929,4415,'no_lang_code','name','Atom Sciences'),(5930,4416,'en','name','Govind Ballabh Pant Hospital'),(5931,4417,'en','name','Oral Roberts University'),(5932,4418,'en','name','Hospital of Lithuanian University of Health Sciences Kaunas Clinics'),(5933,4418,'lt','name','Lietuvos sveikatos mokslų universiteto ligoninė Kauno klinikos'),(5934,4419,'no_lang_code','name','Qurient (South Korea)'),(5935,4420,'en','name','Fujian Provincial Cancer Hospital'),(5936,4420,'zh','name','福建省肿瘤医院'),(5937,4421,'en','name','VA Long Beach Healthcare System'),(5938,4422,'ko','name','단국대학교'),(5939,4422,'no_lang_code','name','Dankook University'),(5940,4423,'en','name','Sharp Cabrillo Hospital'),(5941,4424,'en','name','Shaikh Zayed Postgraduate Medical Institute'),(5942,4424,'ur','name','شیخ زید پوسٹ گریجویٹ میڈیکل انسٹی ٹیوٹ'),(5943,4425,'en','name','Medical Trust Hospital'),(5944,4426,'en','name','BGS Global Hospital'),(5945,4427,'en','name','Niabi Zoological Society'),(5946,4428,'en','name','University Hospital of North Tees'),(5947,4429,'en','name','Public Health Foundation of India'),(5948,4429,'te','name','భారత ప్రజారోగ్య సమాఖ్య'),(5949,4430,'en','name','Promotion of Operational Links With Integrated Services'),(5950,4431,'fr','name','Hôpital Foch'),(5951,4432,'en','name','Des Moines University'),(5952,4432,'fr','name','Université de des moines'),(5953,4433,'en','name','Royal United Hospital Bath NHS Trust'),(5954,4434,'en','name','Kingston Hospital NHS Trust'),(5955,4435,'en','name','Kaiser Foundation Hospital'),(5956,4436,'en','name','Nikko Memorial Hospital'),(5957,4436,'ja','name','日鋼記念病院'),(5958,4437,'en','name','University of Gondar'),(5959,4438,'en','name','Kaweah Delta Health Care District'),(5960,4439,'en','name','Kent Hospital'),(5961,4439,'tr','name','Kent Hastanesi'),(5962,4440,'en','name','Cambridge Health Alliance'),(5963,4441,'en','name','Second Affiliated Hospital of Zhejiang University'),(5964,4442,'en','name','National Taiwan Normal University'),(5965,4443,'en','name','American Chemical Society'),(5966,4444,'es','name','Hospital Universitario de San Vicente Fundación'),(5967,4445,'en','name','Polish Mother’s Memorial Hospital Research Institute'),(5968,4445,'pl','name','Instytut Centrum Zdrowia Matki Polki w Łodzi'),(5969,4446,'en','name','Ministry of Health'),(5970,4447,'en','name','Dong-Eui University'),(5971,4447,'ko','name','동의대학교'),(5972,4448,'en','name','Muljibhai Patel Urological Hospital'),(5973,4449,'en','name','Harborview Medical Center'),(5974,4450,'fr','name','Centre hospitalier régional de la Citadelle'),(5975,4451,'en','name','Japan Agency for Marine-Earth Science and Technology'),(5976,4451,'ja','name','海洋研究開発機構'),(5977,4452,'en','name','Karakalpak State University'),(5978,4453,'en','name','Nishi Niigata Chuo National Hospital'),(5979,4453,'ja','name','国立病院機構西新潟中央病院'),(5980,4454,'en','name','University of Yamanashi'),(5981,4454,'ja','name','山梨大学'),(5982,4455,'ko','name','을지대학교병원'),(5983,4455,'no_lang_code','name','Eulji General Hospital'),(5984,4456,'en','name','Akron General Medical Center'),(5985,4457,'en','name','Eastern Mennonite University'),(5986,4458,'en','name','Christ Hospital'),(5987,4459,'en','name','Central College'),(5988,4460,'en','name','Mater Dei Hospital'),(5989,4461,'no_lang_code','name','Caisson Laboratories (United States)'),(5990,4462,'en','name','Samsung Medical Center'),(5991,4463,'en','name','Crouse Hospital'),(5992,4464,'no_lang_code','name','Metropolitan Hospital'),(5993,4465,'no_lang_code','name','Format International Ltd'),(5994,4466,'no_lang_code','name','Bhatia Hospital'),(5995,4467,'en','name','Providence Health & Services Oregon and Southwest Washington'),(5996,4468,'en','name','Ealing Hospital'),(5997,4469,'en','name','Shumei University'),(5998,4469,'ja','name','秀明大学'),(5999,4470,'de','name','Franziskus Hospital Bielefeld'),(6000,4470,'en','name','Francis Hospital'),(6001,4471,'en','name','Governador Celso Ramos Hospital'),(6002,4472,'en','name','Sapporo National Hospital'),(6003,4472,'ja','name','国立病院機構北海道がんセンター'),(6004,4473,'en','name','Amersham Hospital'),(6005,4474,'en','name','Japanese Red Cross Society Wakayama Medical Center'),(6006,4474,'ja','name','日本赤十字社和歌山医療センター'),(6007,4475,'en','name','St Mark\'s Hospital'),(6008,4476,'en','name','Raigmore Hospital'),(6009,4477,'en','name','Ayrshire Central Hospital'),(6010,4478,'en','name','University of Rajasthan'),(6011,4478,'fr','name','Université du rajasthan'),(6012,4478,'hi','name','राजस्थान विश्वविद्यालय'),(6013,4478,'pa','name','ਰਾਜਸਥਾਨ ਯੂਨੀਵਰਸਿਟੀ'),(6014,4479,'en','name','MedStar Health'),(6015,4480,'en','name','East Stroudsburg University'),(6016,4480,'fr','name','Université de pennsylvanie d\'east stroudsburg'),(6017,4481,'en','name','Sri Dharmasthala Manjunatheshwara College of Dental Sciences & Hospital'),(6018,4482,'en','name','Southlake Regional Health Center'),(6019,4483,'de','name','Augusta Krankenhaus'),(6020,4484,'en','name','Piedmont Athens Regional'),(6021,4485,'en','name','Subang Jaya Medical Centre'),(6022,4486,'en','name','Center for Forensic Mental Health, Chiba University'),(6023,4486,'ja','name','千葉大学 社会精神保健研究センター'),(6024,4487,'en','name','Regional Environmental Center for Central and Eastern Europe'),(6025,4488,'no_lang_code','name','Volvo (Sweden)'),(6026,4488,'sv','name','Volvokoncernen'),(6027,4489,'en','name','Luton and Dunstable Hospital'),(6028,4490,'en','name','Barnsley Hospital'),(6029,4491,'en','name','Shanghai Mental Health Center'),(6030,4491,'zh','name','上海市精神卫生中心'),(6031,4492,'en','name','458th Hospital PLA'),(6032,4492,'zh','name','中国人民解放军第四五八'),(6033,4493,'no_lang_code','name','Sibtech (United States)'),(6034,4494,'en','name','MetroWest Medical Center'),(6035,4495,'en','name','Forrest General Hospital'),(6036,4496,'en','name','John F. Kennedy Medical Center'),(6037,4497,'tr','name','Okmeydanı Eğitim ve Araştırma Hastanesi'),(6038,4498,'no_lang_code','name','University of Veterinary Medicine in Košice'),(6039,4498,'sk','name','Univerzita veterinárskeho lekárstva a farmácie v Košiciach'),(6040,4499,'en','name','Utsunomiya University'),(6041,4499,'ja','name','宇都宮大学'),(6042,4500,'no_lang_code','name','Academia Sinica'),(6043,4500,'zh','name','中央研究院'),(6044,4501,'en','name','California State Polytechnic University'),(6045,4501,'es','name','Universidad Estatal Politécnica de California, Pomona'),(6046,4501,'fr','name','Université d\'État polytechnique de californie à pomona'),(6047,4502,'pt','name','Hospital de Santa Maria'),(6048,4503,'ja','name','安城更生病院'),(6049,4503,'no_lang_code','name','Anjo Kosei Hospital'),(6050,4504,'hi','name','Devi Ahilya Vishwavidyalaya, देवि अहिल्या विश्वविद्यालय'),(6051,4505,'en','name','Governor\'s Institutes of Vermont'),(6052,4506,'en','name','B.C. Women\'s Hospital & Health Centre'),(6053,4507,'en','name','Ashland University'),(6054,4508,'fr','name','Bicêtre Hospital, Hospice de la Vieillesse Hommes'),(6055,4509,'en','name','Edward Hospital'),(6056,4510,'no_lang_code','name','Teck (Canada)'),(6057,4511,'en','name','SangStat Medical Corporation'),(6058,4512,'en','name','Tokyo University of Agriculture'),(6059,4512,'ja','name','東京農業大学'),(6060,4513,'en','name','Periyar University'),(6061,4513,'ta','name','பெரியார் பல்கலைக்கழகம்'),(6062,4514,'en','name','Greenslopes Private Hospital'),(6063,4515,'en','name','Banner Estrella Medical Center'),(6064,4516,'no_lang_code','name','Lanxess (Canada)'),(6065,4517,'pt','name','Hospital de Santa Marta'),(6066,4518,'en','name','Riverview Hospital'),(6067,4519,'en','name','Command Hospital Air Force'),(6068,4520,'bn','name','বর্ধমান বিশ্ববিদ্যালয়'),(6069,4520,'en','name','University of Burdwan'),(6070,4521,'en','name','Alabama Department of Mental Health'),(6071,4522,'en','name','First Hospital of Lanzhou University'),(6072,4523,'en','name','Iwate Prefectural Kamaishi Hospital'),(6073,4524,'en','name','Southmead Hospital'),(6074,4525,'en','name','First Affiliated Hospital of Jinan University'),(6075,4525,'zh','name','暨南大学附属第一医院'),(6076,4526,'es','name','Hospital Militar de Santiago'),(6077,4527,'fr','name','Hôpital Manchester'),(6078,4528,'en','name','Saifee Hospital'),(6079,4529,'en','name','Changhua Christian Hospital'),(6080,4530,'no_lang_code','name','Mpilo Central Hospital'),(6081,4531,'en','name','New Jewish Home'),(6082,4532,'en','name','Warren Spring Laboratory'),(6083,4533,'en','name','Huntsman Marine Science Centre'),(6084,4534,'en','name','Mount Sinai Hospital'),(6085,4535,'en','name','Tianjin University of Traditional Chinese Medicine'),(6086,4535,'zh','name','天津中医药大学'),(6087,4536,'en','name','Aultman Health Foundation'),(6088,4537,'es','name','Hospital Universitario Infanta Sofía'),(6089,4538,'no_lang_code','name','Kinan Hospital'),(6090,4539,'de','name','Hochschule Kaiserslautern'),(6091,4539,'en','name','University of Applied Sciences Kaiserslautern'),(6092,4540,'en','name','Emory University Hospital'),(6093,4541,'en','name','Institute of Child and Mother Health'),(6094,4542,'de','name','VDI/VDE Innovation + Technik'),(6095,4543,'en','name','Creative Health Care Management'),(6096,4544,'en','name','Pai Chai University'),(6097,4544,'ko','name','배재대학교'),(6098,4545,'en','name','Hawaii Permanente Medical Group'),(6099,4546,'en','name','Hollins University'),(6100,4547,'hu','name','Békés Megyei Központi Kórház'),(6101,4548,'en','name','Minnesota Medical Association'),(6102,4549,'en','name','Dr. Agarwal\'s Eye Hospital'),(6103,4550,'no','name','Helse Førde'),(6104,4551,'en','name','Shalvata Mental Health Center'),(6105,4551,'he','name','המרכז לבריאות הנפש שלוותה'),(6106,4552,'en','name','Morristown Hamblen Hospital Foundation'),(6107,4553,'en','name','Munroe Regional Medical Center'),(6108,4554,'en','name','Sweet Briar College'),(6109,4555,'en','name','Auckland City Hospital'),(6110,4556,'en','name','Methodist Dallas Medical Center'),(6111,4557,'en','name','Bạch Mai Hospital'),(6112,4557,'vi','name','Bệnh viện Bạch Mai'),(6113,4558,'en','name','Archbishop Makarios III Hospital'),(6114,4559,'fr','name','Centre Hospitalier Saint-Denis'),(6115,4560,'en','name','Queen Elizabeth Hospital'),(6116,4561,'en','name','Jimma University'),(6117,4562,'no_lang_code','name','Bellbrook Labs (United States)'),(6118,4563,'en','name','Grochowski Hospital'),(6119,4564,'en','name','Prince Charles Hospital'),(6120,4565,'en','name','Estonian Interuniversity Population Research Centre'),(6121,4566,'no_lang_code','name','Cameco (Canada)'),(6122,4567,'en','name','Kyoto Women\'s University'),(6123,4567,'ja','name','京都女子大学'),(6124,4568,'en','name','Foundation for Advancement of International Medical Education and Research'),(6125,4569,'en','name','Chicago State University'),(6126,4569,'fr','name','Université d\'État de chicago'),(6127,4570,'en','name','University of Seoul'),(6128,4570,'ko','name','서울시립대학교'),(6129,4571,'en','name','Asahi University'),(6130,4571,'ja','name','朝日大学'),(6131,4572,'en','name','Gold Coast Hospital'),(6132,4573,'en','name','Veterans Health Administration'),(6133,4574,'en','name','Lander University'),(6134,4575,'en','name','Athens Information Technology'),(6135,4576,'en','name','Soonchunhyang University Hospital'),(6136,4577,'en','name','Cheng Ching Hospital'),(6137,4577,'zh','name','澄清湖医院'),(6138,4578,'en','name','B.P. Koirala Institute of Health Sciences'),(6139,4578,'ne','name','विपी कोइराला स्वास्थ्य विज्ञान प्रतिष्ठान'),(6140,4579,'en','name','Secretariat of the Pacific Community'),(6141,4580,'en','name','Coppin State University'),(6142,4581,'en','name','Charles Clifford Dental Hospital'),(6143,4582,'hr','name','Klinika za psihijatriju Vrapče'),(6144,4583,'en','name','Shaughnessy Hospital'),(6145,4584,'pt','name','Instituto Superior de Administração e Gestão'),(6146,4585,'it','name','Ospedale San Pietro Fatebenefratelli'),(6147,4586,'en','name','Oregon National Primate Research Center'),(6148,4587,'en','name','University Hospital Llandough'),(6149,4588,'en','name','Hampton University'),(6150,4588,'fr','name','Université de hampton'),(6151,4589,'en','name','Royal Sussex County Hospital'),(6152,4590,'es','name','Hospital Central Militar'),(6153,4591,'en','name','Bassett Medical Center'),(6154,4592,'fr','name','Hôpital Civil, Strasbourg'),(6155,4593,'tr','name','Şişli Etfal Eğitim ve Araştırma Hastanesi'),(6156,4594,'en','name','Holy Name Medical Center'),(6157,4595,'en','name','Jorvi Hospital'),(6158,4595,'fi','name','Jorvin sairaala'),(6159,4596,'en','name','St. Jerome\'s University'),(6160,4597,'en','name','University of Nigeria Teaching Hospital'),(6161,4598,'en','name','R. G. Kar Medical College and Hospital'),(6162,4599,'it','name','Ospedale Bellaria, Ospedale Bellaria \"Carlo Alberto Pizzardi\"'),(6163,4600,'en','name','Hebei Normal University of Science and Technology'),(6164,4600,'zh','name','河北科技师范学院'),(6165,4601,'en','name','Acıbadem Adana Hospital'),(6166,4602,'en','name','Minoh City Hospital'),(6167,4602,'ja','name','箕面市立病院'),(6168,4603,'en','name','Asanogawa General Hospital'),(6169,4603,'ja','name','浅ノ川総合病院'),(6170,4604,'en','name','Long Beach City College'),(6171,4605,'no_lang_code','name','Hewlett-Packard (United Kingdom)'),(6172,4606,'en','name','Burnley General Teaching Hospital'),(6173,4607,'en','name','Armed Forces Medical College'),(6174,4607,'ml','name','ആംഡ് ഫോഴ്സസ് മെഡിക്കൽ കോളേജ്'),(6175,4608,'ja','name','オーガンテクノロジーズ'),(6176,4608,'no_lang_code','name','Organ Technologies (Japan)'),(6177,4609,'en','name','Russian University of Transport'),(6178,4609,'ru','name','Российский университет транспорта'),(6179,4610,'no_lang_code','name','Sotiria General Hospital'),(6180,4611,'en','name','First Affiliated Hospital of Nanchang University'),(6181,4611,'zh','name','南昌大学第一附属医院'),(6182,4612,'en','name','Dong-A University Hospital'),(6183,4612,'ko','name','동아대학교의료원'),(6184,4613,'en','name','Detroit Medical Center'),(6185,4614,'en','name','Base Hospital'),(6186,4614,'pt','name','Hospital de Base'),(6187,4615,'en','name','CSI Holdsworth Memorial Hospital'),(6188,4616,'en','name','Yamagata University Hospital'),(6189,4616,'ja','name','山形大学医学部附属病院'),(6190,4617,'en','name','Jinnah Medical & Dental College'),(6191,4618,'en','name','Gloucestershire Royal Hospital'),(6192,4619,'ja','name','岸和田徳洲会病院'),(6193,4619,'no_lang_code','name','Kishiwada Tokushukai Hospital'),(6194,4620,'es','name','Hospital de León'),(6195,4621,'en','name','Interuniversity Consortium for Nanoelectronics'),(6196,4621,'it','name','Consorzio Nazionale Interuniversitario per la Nanoelettronica'),(6197,4622,'ja','name','新小倉病院'),(6198,4622,'no_lang_code','name','ShinKokura Hospital'),(6199,4623,'en','name','Aspen Center For Physics'),(6200,4623,'fr','name','Centre pour la physique d\'aspen'),(6201,4624,'no_lang_code','name','Vala Sciences (United States)'),(6202,4625,'en','name','Evergreen Health Medical Center'),(6203,4626,'pt','name','Escola Superior de Saúde do Alcoitão'),(6204,4627,'en','name','C. S. Mott Children\'s Hospital'),(6205,4628,'en','name','Saint Francis Memorial Hospital'),(6206,4629,'no_lang_code','name','Talaria (United States)'),(6207,4630,'en','name','Harbor–UCLA Medical Center'),(6208,4631,'no_lang_code','name','Bugando Medical Centre'),(6209,4632,'fr','name','Hôpital Broussais'),(6210,4633,'en','name','Kyungsung University'),(6211,4633,'ko','name','경성대학교'),(6212,4634,'en','name','Agricultural Research Organization'),(6213,4634,'he','name','מנהל המחקר החקלאי - מרכז וולקני'),(6214,4635,'no_lang_code','name','IBM (United States)'),(6215,4636,'bn','name','শাহজালাল বিজ্ঞান ও প্রযুক্তি বিশ্ববিদ্যালয়'),(6216,4636,'en','name','Shahjalal University of Science and Technology'),(6217,4637,'en','name','Good Samaritan Hospital'),(6218,4638,'en','name','Poultry Industry Council'),(6219,4639,'en','name','Lincoln University - Missouri'),(6220,4640,'en','name','Jeju National University'),(6221,4640,'ko','name','제주대학교'),(6222,4641,'en','name','Riverside Regional Medical Center'),(6223,4642,'en','name','American Association of University Women'),(6224,4643,'en','name','Lister Hospital'),(6225,4644,'en','name','Mathematical Sciences Research Institute'),(6226,4645,'en','name','Social Insurance Futase Hospital'),(6227,4645,'ja','name','社会保険 二瀬病院'),(6228,4646,'en','name','Loma Linda University Children\'s Hospital'),(6229,4647,'en','name','Spring Branch Medical Center'),(6230,4648,'pt','name','Universidade de Uberaba'),(6231,4649,'en','name','American Association For The Advancement of Science'),(6232,4649,'es','name','Asociación Estadounidense para el Avance de la Ciencia'),(6233,4649,'fr','name','Association américaine pour l\'avancement de la science'),(6234,4650,'en','name','Erasmus Hospital'),(6235,4650,'fr','name','Hôpital Érasme'),(6236,4650,'nl','name','Erasmus Ziekenhuis'),(6237,4651,'en','name','South Western Sydney Local Health District'),(6238,4652,'en','name','MetroHealth Medical Center'),(6239,4653,'en','name','Sir Paul Boffa Hospital'),(6240,4654,'en','name','McLaughlin Research Institute'),(6241,4655,'en','name','Halifax Health Medical Center'),(6242,4656,'en','name','Gaylord Hospital'),(6243,4657,'en','name','American Physical Society'),(6244,4657,'fr','name','Société américaine de physique'),(6245,4658,'en','name','Sinai Health System'),(6246,4659,'en','name','Oregon Research Institute'),(6247,4660,'en','name','Wilson College'),(6248,4661,'en','name','Hatanpää Hospital'),(6249,4661,'fi','name','Hatanpaan Sairaala'),(6250,4662,'en','name','University of Arkansas at Fayetteville'),(6251,4662,'es','name','Universidad de Arkansas'),(6252,4662,'fr','name','Université de l\'arkansas'),(6253,4663,'no_lang_code','name','Gastops (Canada)'),(6254,4664,'en','name','University of Minnesota Children\'s Hospital'),(6255,4665,'en','name','King Chulalongkorn Memorial Hospital'),(6256,4665,'th','name','โรงพยาบาลจุฬาลงกรณ์'),(6257,4666,'no_lang_code','name','Rolls-Royce (Germany)'),(6258,4667,'en','name','Scottish Universities Environmental Research Centre'),(6259,4668,'en','name','Hammersmith Hospital'),(6260,4669,'en','name','Memorial Hospital'),(6261,4670,'en','name','Nihon University'),(6262,4670,'ja','name','日本大学'),(6263,4671,'en','name','National Kinki Chuo Hospital for Chest Disease'),(6264,4671,'ja','name','国立病院機構近畿中央胸部疾患センター'),(6265,4672,'en','name','Self-Defense Forces Central Hospital'),(6266,4672,'ja','name','自衛隊中央病院'),(6267,4673,'no_lang_code','name','Advanced Medical Electronics (United States)'),(6268,4674,'it','name','Ospedale Santa Corona'),(6269,4675,'en','name','Milton Keynes Hospital'),(6270,4676,'no_lang_code','name','Thermo Fisher Scientific (China)'),(6271,4677,'en','name','Eltron Research'),(6272,4678,'ja','name','じゃ しずおか こせいれん えんしゅ ほｓぴたｌ'),(6273,4678,'no_lang_code','name','JA Shizuoka Koseiren ENSHU hospital'),(6274,4679,'en','name','Good Samaritan Hospital Medical Center'),(6275,4680,'no_lang_code','name','Eesti Innovatsiooni Instituut'),(6276,4681,'en','name','Henrico Doctors\' Hospital'),(6277,4682,'en','name','McMaster University Medical Centre'),(6278,4683,'en','name','Gay Men\'s Health Crisis'),(6279,4684,'en','name','Texas Health Dallas'),(6280,4685,'en','name','Saint John Regional Hospital'),(6281,4686,'en','name','Statistics Canada'),(6282,4686,'fr','name','Statistique Canada'),(6283,4687,'en','name','Shriners Hospitals for Children Medical Center - Lexington'),(6284,4688,'no_lang_code','name','Microsoft Research (United Kingdom)'),(6285,4689,'no_lang_code','name','Western Research Company, Inc.'),(6286,4690,'pt','name','Universidade Cruzeiro do Sul'),(6287,4691,'en','name','Marietta Memorial Hospital'),(6288,4692,'it','name','Consorzio Interuniversitario Per L\'Ottimizzazione E La Ricerca Operativa'),(6289,4693,'en','name','NHS Greater Glasgow and Clyde'),(6290,4694,'en','name','University of South Carolina Beaufort'),(6291,4695,'fr','name','Hôpital Albert Michallon'),(6292,4696,'ar','name','مستشفى الجهراء'),(6293,4696,'no_lang_code','name','Jahra Hospital'),(6294,4697,'en','name','Government Medical College'),(6295,4697,'mr','name','शासकीय वैद्यकीय महाविद्यालय व रुग्णालय, औरंगाबाद'),(6296,4698,'en','name','Royal Preston Hospital'),(6297,4699,'en','name','Georgia College & State University'),(6298,4700,'en','name','Komfo Anokye Teaching Hospital'),(6299,4701,'en','name','William Woods University'),(6300,4702,'no_lang_code','name','Adenosine Therapeutics (United States)'),(6301,4703,'es','name','Hospital Perpetuo Socorro'),(6302,4704,'en','name','Narayana Health'),(6303,4705,'hu','name','Bajcsy-Zsilinszky Kórház és Rendelőintézet'),(6304,4706,'en','name','Kwai Chung Hospital'),(6305,4706,'zh','name','葵涌醫院'),(6306,4707,'en','name','Nara Advanced Teachers College for Women, Nara Women\'s University'),(6307,4707,'ja','name','奈良女子大学'),(6308,4708,'ja','name','名古屋共立病院'),(6309,4708,'no_lang_code','name','Nagoya Kyouritsu Hospital'),(6310,4709,'en','name','Chonnam National University'),(6311,4709,'ko','name','전남대학교'),(6312,4710,'no_lang_code','name','Motorola (France)'),(6313,4711,'en','name','Ipswich Hospital'),(6314,4712,'ja','name','篠ノ井総合病院'),(6315,4712,'no_lang_code','name','Shinonoi General Hospital'),(6316,4713,'en','name','Makassed General Hospital'),(6317,4714,'en','name','Steel Construction Institute'),(6318,4715,'en','name','Monklands Hospital'),(6319,4716,'it','name','Ospedale San Giuseppe'),(6320,4717,'en','name','Capital District Health Authority'),(6321,4718,'no_lang_code','name','Rio Tinto (United Kingdom)'),(6322,4719,'en','name','North Shore University Hospital'),(6323,4720,'en','name','University of the Pacific'),(6324,4720,'es','name','Universidad del Pacífico'),(6325,4720,'fr','name','Université du pacifique'),(6326,4721,'en','name','Northwest Missouri State University'),(6327,4722,'en','name','MedStar Harbor Hospital'),(6328,4723,'pt','name','Hospital Geral de Fortaleza'),(6329,4724,'no_lang_code','name','Innovation Research and Training'),(6330,4725,'en','name','Englewood Hospital and Medical Center'),(6331,4726,'ja','name','平鹿総合病院'),(6332,4726,'no_lang_code','name','Hiraka General Hospital'),(6333,4727,'en','name','Kushiro City General Hospital'),(6334,4727,'ja','name','市立釧路総合病院'),(6335,4728,'en','name','University of Houston - Downtown'),(6336,4728,'es','name','Universidad de Houston-Downtown'),(6337,4729,'en','name','Nizhny Novgorod State Pedagogical University'),(6338,4729,'ru','name','Нижегородский государственный технический университет им. Р. Е. Алексеева'),(6339,4730,'fi','name','Kymenlaakson keskussairaala'),(6340,4731,'en','name','Grambling State University'),(6341,4731,'fr','name','Université d\'État de grambling'),(6342,4732,'no_lang_code','name','Applica Sprl'),(6343,4733,'en','name','Catawba Valley Medical Center'),(6344,4734,'no_lang_code','name','Manipal Hospital'),(6345,4735,'en','name','Sheffield Children\'s Hospital'),(6346,4736,'en','name','Legacy Good Samaritan Medical Center'),(6347,4737,'en','name','Rebecca Sieff Hospital'),(6348,4738,'en','name','Miami VA Healthcare System'),(6349,4739,'en','name','Skokie Hospital'),(6350,4740,'fr','name','Hôpital El Ayachi'),(6351,4741,'ar','name','مستشفى الملك فيصل التخصصي'),(6352,4741,'en','name','King Faisal Specialist Hospital & Research Centre'),(6353,4742,'en','name','Children\'s Hospital of Fudan University'),(6354,4743,'en','name','Latifa Hospital'),(6355,4744,'en','name','Nagahama City Hospital'),(6356,4744,'ja','name','長浜市病院'),(6357,4745,'en','name','George E. Wahlen Department of VA Medical Center'),(6358,4746,'en','name','Henry Dunant Hospital'),(6359,4747,'en','name','Eduardo Mondlane University'),(6360,4747,'pt','name','Universidade Eduardo Mondlane'),(6361,4748,'en','name','Milwaukee County Medical Complex'),(6362,4749,'en','name','North Mississippi Medical Center'),(6363,4750,'fa','name','بیمارستان قائم'),(6364,4750,'no_lang_code','name','Ghaem Hospital'),(6365,4751,'en','name','Mercy Medical Center'),(6366,4752,'en','name','Ideta Eye Hospital'),(6367,4752,'ja','name','出田眼科病院'),(6368,4753,'en','name','Bhopal Memorial Hospital & Research Centre'),(6369,4754,'en','name','Sam Higginbottom Institute of Agriculture'),(6370,4754,'hi','name','सैम हिग्गिनबॉटम कृषि, प्रौद्योगिकी एवं विज्ञान संस्थान'),(6371,4754,'ml','name','അലഹബാദ് അഗ്രികൾച്ചറൽ ഇൻസ്റ്റിറ്റ്യൂട്ട്'),(6372,4755,'en','name','University of Sioux Falls'),(6373,4756,'en','name','Saint Petersburg Academic University'),(6374,4756,'ru','name','Санкт-Петербургский академический университет — научно-образовательный центр нанотехнологий'),(6375,4757,'en','name','Kent and Sussex Hospital'),(6376,4758,'es','name','Hospital Universitario Infanta Leonor'),(6377,4759,'no_lang_code','name','Ambergen (United States)'),(6378,4760,'tr','name','Bursa Yuksek Ihtisas Egitim Ve Arastirma Hastanesi'),(6379,4761,'en','name','Mubarak Al Kabeer Hospital'),(6380,4762,'en','name','Hoag Memorial Hospital Presbyterian'),(6381,4763,'bn','name','বাঁকুড়া সম্মিলনী মেডিক্যাল কলেজ'),(6382,4763,'en','name','Bankura Sammilani Medical College'),(6383,4764,'en','name','Foundation for Medical Research'),(6384,4765,'en','name','West Australian Sleep Disorders Research Institute'),(6385,4766,'no_lang_code','name','Abratech Corporation'),(6386,4767,'en','name','Children\'s Hospital of Eastern Ontario'),(6387,4767,'fr','name','Centre hospitalier pour enfants de l\'est de l\'Ontario'),(6388,4768,'en','name','Avera Health'),(6389,4769,'en','name','University of Eswatini'),(6390,4770,'pt','name','Universidade de Santo Amaro'),(6391,4771,'en','name','Baoji University of Arts and Sciences'),(6392,4771,'zh','name','宝鸡文理学院'),(6393,4772,'de','name','Asklepios Klinik Barmbek'),(6394,4772,'en','name','Asklepios Hospital Barmbek'),(6395,4773,'pl','name','Okręgowy Szpital Kolejowy'),(6396,4774,'en','name','Cardinal Stritch University'),(6397,4775,'en','name','Royal Glamorgan Hospital'),(6398,4776,'en','name','Glostrup Hospital'),(6399,4777,'en','name','Huntington Medical Research Institutes'),(6400,4778,'it','name','Azienda Ospedaliera Universitaria Policlinico \"Paolo Giaccone\" di Palermo'),(6401,4779,'en','name','Hubei Cancer Hospital'),(6402,4779,'zh','name','湖北省肿瘤医院'),(6403,4780,'en','name','Northern California Institute for Research and Education'),(6404,4781,'en','name','University of the West Indies'),(6405,4782,'en','name','American Geosciences Institute'),(6406,4783,'no_lang_code','name','Petro-Canada'),(6407,4784,'es','name','Hospital Virgen del Puerto'),(6408,4785,'ja','name','西田病院'),(6409,4785,'no_lang_code','name','Nishida Hospital'),(6410,4786,'en','name','Crozer-Keystone Health System'),(6411,4787,'en','name','Queen Elizabeth Hospital'),(6412,4788,'en','name','CTO Hospital'),(6413,4788,'it','name','Ospedale Centro Traumatologico Ortopedico'),(6414,4789,'en','name','Ningbo First Hospital'),(6415,4789,'zh','name','宁波市第一医院'),(6416,4790,'en','name','Haifa Medical Center'),(6417,4791,'en','name','National Hsinchu University of Education'),(6418,4792,'pt','name','Instituto Superior de Saúde do Alto Ave'),(6419,4793,'no_lang_code','name','IQ Solutions'),(6420,4794,'en','name','National Centre for Research and Development'),(6421,4795,'en','name','Hangzhou First People\'s Hospital'),(6422,4795,'zh','name','杭州市第一人民医院'),(6423,4796,'en','name','Lebanon Valley College'),(6424,4797,'no_lang_code','name','ISA Associate'),(6425,4798,'no_lang_code','name','Evangelismos Hospital'),(6426,4799,'en','name','South African Medical Research Council'),(6427,4800,'en','name','Kennedy Krieger Institute'),(6428,4801,'en','name','South African Institute for Medical Research'),(6429,4802,'en','name','Saint Joseph\'s University'),(6430,4802,'es','name','Universidad de San José'),(6431,4802,'fr','name','Université saint-joseph de philadelphie'),(6432,4803,'en','name','Southern University at New Orleans'),(6433,4804,'en','name','Hamilton General Hospital'),(6434,4805,'no_lang_code','name','Siga Technologies (United States)'),(6435,4806,'en','name','Montana Department of Public Health and Human Services'),(6436,4807,'en','name','Greenbrier Valley Medical Center'),(6437,4808,'en','name','University of Calabar'),(6438,4808,'yo','name','Yunifásítì ìlú Calabar'),(6439,4809,'ja','name','柏市立柏病院'),(6440,4809,'no_lang_code','name','Kashiwa Municipal Hospital'),(6441,4810,'en','name','St Clara Hospital'),(6442,4810,'nl','name','Sint Clara Ziekenhuis'),(6443,4811,'en','name','Lu\'an First People\'s Hospital'),(6444,4812,'en','name','Malta Council for Science and Technology'),(6445,4813,'en','name','Government General Hospital'),(6446,4814,'no_lang_code','name','Engi-Mat (United States)'),(6447,4815,'en','name','Five Branches University'),(6448,4816,'no_lang_code','name','Guelph Chemical Labs'),(6449,4817,'en','name','Bangalore Medical College and Research Institute'),(6450,4817,'kn','name','ಬೆಂಗಳೂರು ವೈದ್ಯಕೀಯ ವಿದ್ಯಾಲಯ'),(6451,4818,'en','name','California Lutheran University'),(6452,4819,'ga','name','Forbairt'),(6453,4820,'no_lang_code','name','HealthMark Multimedia'),(6454,4821,'en','name','Mercy Hospital'),(6455,4822,'de','name','Bundeswehrkrankenhaus'),(6456,4823,'it','name','Azienda Ospedaliera Carlo Poma'),(6457,4824,'en','name','Northern General Hospital'),(6458,4825,'en','name','Sewanee: The University of the South'),(6459,4826,'en','name','Physicians for a National Health Program'),(6460,4827,'ja','name','白鷺病院'),(6461,4827,'no_lang_code','name','Shirasagi Hospital'),(6462,4828,'en','name','Gordon Research Conferences'),(6463,4829,'en','name','Queen Elizabeth Hospital'),(6464,4830,'en','name','European Road Transport Telematics Implementation Co-Ordination'),(6465,4831,'no_lang_code','name','DELL (United States)'),(6466,4832,'en','name','Kaiser Permanente Oakland Medical Center'),(6467,4833,'en','name','Aquatic Animal Health Research Laboratory'),(6468,4834,'ja','name','虎の門病院'),(6469,4834,'no_lang_code','name','Toranomon Hospital'),(6470,4835,'ms','name','Hospital Tengku Ampuan Afzan'),(6471,4836,'en','name','Dominican Hospital'),(6472,4837,'en','name','303 Hospital of People\'s Liberation Army'),(6473,4837,'zh','name','中国人民解放军303医院'),(6474,4838,'ja','name','北野病院'),(6475,4838,'no_lang_code','name','Kitano Hospital'),(6476,4839,'en','name','CHA Gangnam Medical Center'),(6477,4840,'en','name','Royal University of Phnom Penh'),(6478,4840,'km','name','សាកលវិទ្យាល័យភូមិន្ទភ្នំពេញ'),(6479,4841,'en','name','Oglethorpe University'),(6480,4842,'en','name','IBM Research - Haifa'),(6481,4843,'en','name','MedStar Washington Hospital Center'),(6482,4844,'en','name','Euresearch Association'),(6483,4845,'en','name','Smt. N.H.L. Municipal Medical College'),(6484,4845,'gu','name','શ્રીમતી. એનએચએલ મ્યુનિસિપલ મેડિકલ કોલેજ'),(6485,4846,'en','name','University of the Ryukyus University Hospital'),(6486,4846,'ja','name','琉球大学医学部附属病院'),(6487,4847,'en','name','Favaloro University'),(6488,4847,'es','name','Universidad Favaloro'),(6489,4848,'en','name','Morton Plant Hospital'),(6490,4849,'es','name','Hospital Universitario Severo Ochoa'),(6491,4850,'en','name','Oakwood University'),(6492,4851,'no_lang_code','name','Lucideon (United Kingdom)'),(6493,4852,'en','name','University of Wisconsin–Parkside'),(6494,4852,'fr','name','Université du Wisconsin–Parkside'),(6495,4853,'en','name','Aishin Memorial Hospital'),(6496,4853,'ja','name','愛心メモリアル病院'),(6497,4854,'en','name','Hungarian Institute of Occupational Health'),(6498,4854,'hu','name','Országos Munkahigiénés és Foglalkozásegészségügyi Intézet'),(6499,4855,'es','name','Instituto Tecnológico de Aragón'),(6500,4856,'fr','name','Ministère des Transports'),(6501,4857,'en','name','Doctors Medical Center'),(6502,4858,'en','name','Evangel University'),(6503,4859,'en','name','University of Carabobo'),(6504,4859,'es','name','Universidad de Carabobo'),(6505,4860,'en','name','Association of Schools of Allied Health Professions'),(6506,4861,'en','name','Rutland Regional Medical Center'),(6507,4862,'en','name','Hospital Authority'),(6508,4862,'zh','name','醫院管理局'),(6509,4863,'en','name','State University System of Florida'),(6510,4863,'es','name','Sistema universitario estatal de Florida'),(6511,4864,'en','name','University of Wisconsin–Stevens Point'),(6512,4864,'fr','name','Université du Wisconsin–Stevens Point'),(6513,4865,'en','name','Kumamoto Medical Center'),(6514,4865,'ja','name','熊本医療センター'),(6515,4866,'en','name','Natural Resources Institute'),(6516,4867,'no_lang_code','name','Rotunda Hospital'),(6517,4868,'en','name','Sophiahemmet Hospital'),(6518,4868,'sv','name','Sophiahemmet Sjukhus'),(6519,4869,'en','name','University of California Davis Medical Center'),(6520,4870,'en','name','Kyoto Sangyo University'),(6521,4870,'ja','name','京都産業大学'),(6522,4871,'en','name','Institute for Cancer Prevention'),(6523,4872,'en','name','Saddleback Memorial Medical Center'),(6524,4873,'en','name','Touro University Nevada'),(6525,4873,'fr','name','Université touro du nevada'),(6526,4874,'en','name','Judge Baker Children\'s Center'),(6527,4875,'en','name','Matsuyama University'),(6528,4875,'ja','name','松山大学'),(6529,4876,'en','name','Biological Sciences Curriculum Study'),(6530,4877,'es','name','Hospital General de Niños Ricardo Gutierrez'),(6531,4878,'es','name','Centro Agronomico Tropical de Investigacion y Ensenanza Catie'),(6532,4879,'en','name','American Society of Civil Engineers'),(6533,4880,'en','name','Hanyang University Medical Center'),(6534,4880,'ko','name','한양대학교병원 응급실'),(6535,4881,'en','name','Northern State Medical University'),(6536,4881,'ru','name','Северный государственный медицинский университет'),(6537,4882,'ko','name','(주)인실리코젠'),(6538,4882,'no_lang_code','name','Insilicogen (South Korea)'),(6539,4883,'en','name','Canterbury District Health Board'),(6540,4884,'en','name','VA Northern California Health Care System'),(6541,4885,'de','name','Ostschweizer Kinderspital'),(6542,4885,'en','name','Children\'s Hospital in Eastern Switzerland'),(6543,4886,'en','name','Jehangir Hospital'),(6544,4887,'es','name','Hospital General de Agudos Dr. TEODORO ALVAREZ'),(6545,4888,'es','name','Hospital Universitario Infanta Cristina'),(6546,4889,'en','name','Federal Teaching Hospital Abakaliki'),(6547,4890,'ar','name','جامعة كسلا'),(6548,4890,'en','name','Kassala University'),(6549,4891,'en','name','Dankook University Hospital'),(6550,4891,'ko','name','단국대학교의과대학부속병원'),(6551,4892,'en','name','China Jiliang University'),(6552,4893,'en','name','Southampton Hospital'),(6553,4894,'en','name','Mahatma Gandhi Medical College and Research Institute'),(6554,4895,'en','name','Canniesburn Hospital'),(6555,4896,'it','name','Azienda Ospedaliera Fatebenefratelli e Oftalmico'),(6556,4897,'en','name','Memorial Hospital'),(6557,4898,'en','name','Shaoxing People\'s Hospital'),(6558,4898,'zh','name','绍兴市人民医院'),(6559,4899,'el','name','Γενικό Νοσοκομείο Αθηνών Ιπποκράτειο'),(6560,4899,'en','name','Hippocration General Hospital'),(6561,4900,'en','name','Shanghai Skin Disease Hospital'),(6562,4900,'zh','name','上海皮肤病医院长宁区门诊部'),(6563,4901,'no_lang_code','name','Resodyn Corporation (United States)'),(6564,4902,'tr','name','Fatih Sultan Mehmet Eğitim Ve Araştırma Hastanesi'),(6565,4903,'en','name','Atlanta Medical Center'),(6566,4904,'no_lang_code','name','IRIS Educational Media'),(6567,4905,'en','name','South Essex Partnership University Foundation NHS Trust'),(6568,4906,'en','name','Royal National Hospital for Rheumatic Diseases'),(6569,4907,'nl','name','Rijnland Ziekenhuis'),(6570,4908,'ja','name','厚生連高岡病院'),(6571,4908,'no_lang_code','name','Kouseiren Takaoka Hospital'),(6572,4909,'en','name','Deaconess Hospital'),(6573,4910,'en','name','University of Tehran'),(6574,4910,'fa','name','دانشگاه تهران'),(6575,4911,'pl','name','Szpital Uniwersytecki w Krakowie'),(6576,4912,'en','name','Feng Chia University'),(6577,4913,'en','name','National Chung Hsing University'),(6578,4914,'en','name','Children\'s Hospital of Richmond at VCU'),(6579,4915,'en','name','Deaconess Hospital'),(6580,4916,'en','name','University of Kentucky HealthCare'),(6581,4917,'en','name','Cheil General Hospital and Women\'s Healthcare Center'),(6582,4918,'en','name','American Mathematical Society'),(6583,4918,'es','name','Sociedad Estadounidense de Matemática'),(6584,4919,'en','name','First Affiliated Hospital of Harbin Medical University'),(6585,4920,'en','name','Southern Illinois University System'),(6586,4920,'fr','name','Université de l\'illinois du sud'),(6587,4921,'en','name','Yeditepe University Hospital'),(6588,4921,'tr','name','Yeditepe Üniversitesi Hastanesi'),(6589,4922,'en','name','University of Minnesota Morris'),(6590,4922,'fr','name','Université du minnesota à morris'),(6591,4923,'en','name','Shenandoah University'),(6592,4924,'en','name','Israel Defense Forces Medical Corps'),(6593,4925,'en','name','New Cross Hospital'),(6594,4926,'ro','name','Institutul Clinic Fundeni'),(6595,4927,'en','name','Government Medical College'),(6596,4928,'en','name','Chonburi Hospital'),(6597,4928,'th','name','โรงพยาบาลชลบุรี'),(6598,4929,'en','name','Khoo Teck Puat Hospital'),(6599,4930,'en','name','University Clinical Hospital Mostar'),(6600,4930,'hr','name','Sveučilišna klinička bolnica Mostar'),(6601,4931,'en','name','Research Corporation of The University of Hawaii'),(6602,4932,'it','name','Ospedale San Bortolo'),(6603,4933,'en','name','Inje University Seoul Paik Hospital'),(6604,4933,'ko','name','인제대학교백병원'),(6605,4934,'en','name','Sri Venkateswara University'),(6606,4934,'hi','name','श्री वेंकटेश्वर विश्वविद्यालय'),(6607,4934,'ta','name','சிறீ வெங்கடேசுவரா பல்கலைக்கழகம்'),(6608,4934,'te','name','శ్రీ వేంకటేశ్వర విశ్వవిద్యాలయం'),(6609,4934,'ur','name','جامعہ سری وینکٹیشورا'),(6610,4935,'en','name','Bronglais General Hospital'),(6611,4936,'en','name','American Hospital'),(6612,4936,'tr','name','Amerikan Hastanesi'),(6613,4937,'en','name','University Hospital Innsbruck'),(6614,4938,'en','name','Goa Dental College and Hospital'),(6615,4939,'en','name','Aminu Kano Teaching Hospital'),(6616,4940,'en','name','Mater Adult Hospital'),(6617,4941,'en','name','Wakayama University'),(6618,4941,'ja','name','和歌山大学'),(6619,4942,'en','name','Andalusian School of Public Health'),(6620,4942,'es','name','Escuela Andaluza de Salud Pública'),(6621,4943,'en','name','Obihiro National Hospital'),(6622,4943,'ja','name','国立病院機構帯広病院'),(6623,4944,'no_lang_code','name','Canon (Canada)'),(6624,4945,'en','name','Municipal Hirakata City Hospital'),(6625,4945,'ja','name','市立枚方市民病院'),(6626,4946,'en','name','Kings Mill Hospital'),(6627,4947,'en','name','Stony Brook University Hospital'),(6628,4948,'en','name','Ratchaburi Hospital'),(6629,4948,'th','name','โรงพยาบาลราชบุรี'),(6630,4949,'no_lang_code','name','Shaanxi Yulin Energy Group'),(6631,4950,'en','name','Gallaecia Higher School'),(6632,4950,'pt','name','Escola Superior Gallaecia'),(6633,4951,'en','name','Higashi Nagoya National Hospital'),(6634,4951,'ja','name','国立病院機構東名古屋病院'),(6635,4952,'no_lang_code','name','Inotek Pharmaceuticals (United States)'),(6636,4953,'en','name','Mennonite Christian Hospital'),(6637,4953,'zh','name','門諾醫院'),(6638,4954,'en','name','Calderdale Royal Hospital'),(6639,4955,'en','name','Crittenton Hospital Medical Center'),(6640,4956,'ar','name','الجامعة اللبنانية'),(6641,4956,'en','name','Lebanese University'),(6642,4956,'fr','name','Université Libanaise'),(6643,4957,'es','name','Hospital Valle del Nalón'),(6644,4958,'fr','name','Hôpital de La Grave'),(6645,4959,'en','name','Govt. Dental College & Hospital'),(6646,4960,'en','name','Odessa National Polytechnic University'),(6647,4960,'ru','name','Одесский национальный политехнический университет'),(6648,4960,'uk','name','Одеський національний політехнічний університет'),(6649,4961,'en','name','Royal Alexandra Children\'s Hospital'),(6650,4962,'en','name','Aga Khan University Hospital'),(6651,4963,'en','name','Loyola University Medical Center'),(6652,4964,'en','name','Cheltenham General Hospital'),(6653,4965,'en','name','Advocate Children\'s Hospital'),(6654,4966,'no_lang_code','name','Curtiss-Wright (Canada)'),(6655,4967,'en','name','South Carolina State Department of Mental Health'),(6656,4968,'en','name','Kettering General Hospital NHS Trust'),(6657,4969,'en','name','Gastroenterology Medical Center and Hospital'),(6658,4970,'bn','name','নর্থবেঙ্গল মেডিক্যাল কলেজ'),(6659,4970,'en','name','North Bengal Medical College and Hospital'),(6660,4971,'en','name','St Göran\'s Children\'s Hospital'),(6661,4972,'en','name','Lovelace Health System'),(6662,4973,'es','name','Centro Sociosanitario Nuestra Señora del Pino'),(6663,4974,'en','name','University of Arkansas at Monticello'),(6664,4975,'en','name','Choithram Hospital and Research Centre'),(6665,4976,'bn','name','খুলনা মেডিকেল কলেজ'),(6666,4976,'en','name','Khulna Medical College'),(6667,4977,'en','name','National Defense Academy of Japan'),(6668,4977,'ja','name','防衛大学校'),(6669,4978,'en','name','Baptist Memorial Hospital'),(6670,4979,'en','name','Baptist Medical Center Beaches'),(6671,4980,'tr','name','Ege Üniversitesi Tıp Fakültesi Hastanesi'),(6672,4981,'pt','name','Escola Superior de Educação de Almeida Garrett'),(6673,4982,'en','name','Altnagelvin Area Hospital'),(6674,4983,'en','name','Kessler Institute for Rehabilitation'),(6675,4984,'ar','name','جامعة السادس من أكتوبر'),(6676,4984,'en','name','October 6 University'),(6677,4985,'pt','name','Universidade Regional do Cariri'),(6678,4986,'es','name','Universidad del Desarrollo'),(6679,4987,'en','name','Suffolk University'),(6680,4987,'es','name','Universidad de Suffolk'),(6681,4988,'en','name','Heritage University'),(6682,4989,'ko','name','삼육의료원서울병원'),(6683,4989,'no_lang_code','name','Sahmyook Medical Center'),(6684,4990,'no_lang_code','name','TPL (United States)'),(6685,4991,'pt','name','Hospital Mãe de Deus'),(6686,4992,'en','name','Mater Dei Hospital'),(6687,4993,'en','name','Yeungnam University'),(6688,4993,'ko','name','영남대학교'),(6689,4994,'en','name','Urho Kaleva Kekkonen Institute'),(6690,4995,'en','name','Hallym University Medical Center'),(6691,4995,'ko','name','한림대학교의료원'),(6692,4996,'en','name','Sendai Kousei Hospital'),(6693,4996,'ja','name','仙台厚生病院'),(6694,4997,'en','name','University Medical Center Rizk Hospital'),(6695,4998,'en','name','Unity Hospital'),(6696,4999,'en','name','Gansu Agricultural University'),(6697,4999,'zh','name','甘肃农业大学'),(6698,5000,'en','name','Royal Columbian Hospital'),(6699,5001,'no_lang_code','name','Galenea (United States)'),(6700,5002,'en','name','York Hospital'),(6701,5003,'no_lang_code','name','SignalChem (Canada)'),(6702,5004,'en','name','Centre for innovative process engineering'),(6703,5005,'no_lang_code','name','Alpha Technologies (Canada)'),(6704,5006,'en','name','Oak Crest Institute of Science'),(6705,5007,'ja','name','富永病院'),(6706,5007,'no_lang_code','name','Tominaga hospital'),(6707,5008,'en','name','Hearthstone Alzheimer Care'),(6708,5009,'en','name','Native American Cancer Research'),(6709,5010,'no_lang_code','name','Fianium (United Kingdom)'),(6710,5011,'en','name','Philadelphia Fire Department'),(6711,5012,'no_lang_code','name','Aradigm (United States)'),(6712,5013,'no_lang_code','name','iProgen Biotech (Canada)'),(6713,5014,'no_lang_code','name','Stratonics (United States)'),(6714,5015,'no_lang_code','name','Scientific Solutions (United States)'),(6715,5016,'tr','name','Türkiye Yüksek İhtisas Hastanesi'),(6716,5017,'es','name','Instituto de Salud Pública de Navarra'),(6717,5018,'en','name','Saint Vincent Hospital'),(6718,5019,'en','name','California Rural Indian Health Board'),(6719,5020,'en','name','Fresno Unified School District'),(6720,5021,'no_lang_code','name','ECBio (Portugal)'),(6721,5022,'en','name','Park Centre for Mental Health'),(6722,5023,'no_lang_code','name','Morinaga Institute of Biological Science'),(6723,5024,'en','name','National Institute of Agricultural Science and Technology'),(6724,5025,'no_lang_code','name','Biodynamic Research Corporation (United States)'),(6725,5026,'en','name','Center for Naval Analyses'),(6726,5027,'no_lang_code','name','Nanoco Technologies (United Kingdom)'),(6727,5028,'gd','name','Banca Rìoghail na h-Alba'),(6728,5028,'no_lang_code','name','Royal Bank of Scotland (United Kingdom)'),(6729,5029,'en','name','American Indian Center'),(6730,5030,'en','name','Community Connections'),(6731,5031,'de','name','Deutsche Klinik für Diagnostik'),(6732,5032,'no_lang_code','name','Ultra Electronics (Canada)'),(6733,5033,'en','name','Zübeyde Hanim Maternity Hospital'),(6734,5034,'no_lang_code','name','EcoMetrix'),(6735,5035,'no_lang_code','name','Tucker-Davis Technologies (United States)'),(6736,5036,'no_lang_code','name','Implant Sciences (United States)'),(6737,5037,'no_lang_code','name','KCTS 9 (United States)'),(6738,5038,'en','name','Des Moines Area Community College'),(6739,5039,'no_lang_code','name','Liminal BioSciences (Canada)'),(6740,5040,'en','name','Foundation for Blood Research'),(6741,5041,'en','name','Mt. Hood Community College'),(6742,5042,'no_lang_code','name','DeltaMetrics (United States)'),(6743,5043,'en','name','Central Aerohydrodynamic Institute'),(6744,5043,'ru','name','Центральный аэрогидродинамический институт имени профессора Н.Е. Жуковского'),(6745,5044,'no_lang_code','name','Wilson Wolf Manufacturing (United States)'),(6746,5045,'no_lang_code','name','Decision Demographics (United States)'),(6747,5046,'en','name','Communication Matters'),(6748,5047,'en','name','Blood Transfusion Centre of Slovenia'),(6749,5048,'no_lang_code','name','Cambridge Scientific (United States)'),(6750,5049,'no_lang_code','name','Ivoclar Vivadent (Liechtenstein)'),(6751,5050,'no_lang_code','name','Actelion (Switzerland)'),(6752,5051,'en','name','National Evolutionary Synthesis Center'),(6753,5052,'no_lang_code','name','Scarab Genomics (United States)'),(6754,5053,'no_lang_code','name','Allozyne (United States)'),(6755,5054,'en','name','Singapore Science Park'),(6756,5054,'ms','name','Taman Sains Singapura'),(6757,5054,'zh','name','新加坡科学园'),(6758,5055,'en','name','Food Research Institute'),(6759,5056,'no_lang_code','name','Stottler Henke Associates (United States)'),(6760,5057,'no_lang_code','name','NeurAxon (Canada)'),(6761,5058,'no_lang_code','name','Cell Culture Company (United States)'),(6762,5059,'en','name','Orange County Research Center'),(6763,5060,'pt','name','Fundação de Medicina Tropical'),(6764,5061,'no_lang_code','name','Carterra (United States)'),(6765,5062,'en','name','Bostwick Laboratories'),(6766,5063,'en','name','Harrisburg Area Community College'),(6767,5064,'en','name','National Medical Products Administration'),(6768,5065,'no_lang_code','name','Online Technologies (United States)'),(6769,5066,'no_lang_code','name','Xention (United Kingdom)'),(6770,5067,'en','name','Passaic County Community College'),(6771,5068,'en','name','Bandim Health Project'),(6772,5068,'pt','name','Projecto de Saúde Bandim'),(6773,5069,'en','name','Dick Young Productions'),(6774,5070,'en','name','Pima Prevention Partnership'),(6775,5071,'no_lang_code','name','SciberQuest (United States)'),(6776,5072,'en','name','Madison Area Technical College'),(6777,5073,'no_lang_code','name','BASF (United States)'),(6778,5074,'no_lang_code','name','ABB (Sweden)'),(6779,5075,'en','name','Department of Community and Human Services'),(6780,5076,'no_lang_code','name','Altravax (United States)'),(6781,5077,'en','name','Perm State Medical Academy'),(6782,5077,'ru','name','Пермский государственный медицинский университет'),(6783,5078,'en','name','National Microelectronics Institute'),(6784,5079,'no_lang_code','name','Fujirebio (Belgium)'),(6785,5080,'en','name','Mount Carmel College of Nursing'),(6786,5081,'en','name','Amarillo College'),(6787,5082,'no_lang_code','name','TMO Renewables (United Kingdom)'),(6788,5083,'en','name','VA New Jersey Health Care System'),(6789,5084,'en','name','MotherToBaby'),(6790,5085,'en','name','Macedonian Academy of Sciences and Arts'),(6791,5086,'en','name','St. Joseph\'s Hospital'),(6792,5087,'en','name','Health & Safety Laboratory'),(6793,5088,'en','name','St. Elisabeth Hospital'),(6794,5089,'pt','name','Irmandade da Santa Casa de Misericórdia de São Paulo'),(6795,5090,'no_lang_code','name','Vestas (Denmark)'),(6796,5091,'en','name','Peijas Hospital'),(6797,5091,'fi','name','Peijaksen sairaala'),(6798,5092,'en','name','Arizona Office of the Governor'),(6799,5093,'it','name','Istituto Nanoscienze'),(6800,5094,'en','name','Saint Vincent Hospital'),(6801,5095,'no_lang_code','name','Danaher (United Kingdom)'),(6802,5096,'en','name','National Institute of Dental and Craniofacial Research'),(6803,5097,'en','name','South Carolina HIV/AIDS Council'),(6804,5098,'en','name','Orthopaedic Center'),(6805,5099,'ja','name','富山県立中央病院'),(6806,5099,'no_lang_code','name','Toyama Prefectural Central Hospital'),(6807,5100,'en','name','National Defense Medical College Hospital'),(6808,5100,'ja','name','防衛医科大学校病院'),(6809,5101,'no_lang_code','name','Aerpio Pharmaceuticals (United States)'),(6810,5102,'no_lang_code','name','Red Hill Studios'),(6811,5103,'en','name','Canadian Fitness and Lifestyle Research Institute'),(6812,5104,'en','name','Southeast Community College'),(6813,5105,'no_lang_code','name','Theageneio General Hospital'),(6814,5106,'en','name','Overlake Hospital Medical Center'),(6815,5107,'no_lang_code','name','Impact Assessment'),(6816,5108,'en','name','New England Center for Children'),(6817,5109,'en','name','Cedars-Sinai Kerlan-Jobe Institute'),(6818,5110,'en','name','New York College of Podiatric Medicine'),(6819,5111,'pt','name','Biocant'),(6820,5112,'no_lang_code','name','Modellium (Canada)'),(6821,5113,'es','name','Centro Médico Nacional La Raza'),(6822,5114,'no_lang_code','name','Siloam Biosciences (United States)'),(6823,5115,'en','name','Guthrie Foundation'),(6824,5116,'en','name','St. John Medical Center'),(6825,5117,'no_lang_code','name','Ingenza (United Kingdom)'),(6826,5118,'no_lang_code','name','Universal Sensors (United States)'),(6827,5119,'no_lang_code','name','Intelligent Optical Systems (United States)'),(6828,5120,'en','name','KKR Tohoku Kosai Hospital'),(6829,5120,'ja','name','東北公済病院'),(6830,5121,'en','name','BOOMHealth'),(6831,5122,'it','name','Ospedale Maggiore'),(6832,5123,'ja','name','市立豊中病院'),(6833,5123,'no_lang_code','name','Toyonaka Municipal Hospital'),(6834,5124,'en','name','Philander Smith College'),(6835,5125,'no_lang_code','name','La Jolla Science Applications (United States)'),(6836,5126,'no_lang_code','name','Integrity Testing Laboratory (Canada)'),(6837,5127,'en','name','Shea Ear Clinic'),(6838,5128,'en','name','Saudi Center for Organ Transplantation'),(6839,5129,'en','name','Hawaii Agriculture Research Center'),(6840,5130,'en','name','St.Petersburg V.M.Bekhterev Psychoneurological Research Institute'),(6841,5130,'ru','name','Санкт-Петербургский научно-исследовательский психоневрологический институт им. В.М. Бехтерева'),(6842,5131,'no_lang_code','name','Nanoptics (United States)'),(6843,5132,'en','name','Austen Riggs Center'),(6844,5133,'en','name','Pathfinder International'),(6845,5134,'en','name','University of Arkansas Medical Center'),(6846,5135,'no_lang_code','name','GC Image (United States)'),(6847,5136,'no_lang_code','name','Bridge12 Technologies (United States)'),(6848,5137,'en','name','Harvard Affiliated Emergency Medicine Residency'),(6849,5138,'no_lang_code','name','Phrixus Pharmaceuticals (United States)'),(6850,5139,'no_lang_code','name','Cabezon Group (United States)'),(6851,5140,'en','name','Harlem United'),(6852,5141,'fr','name','Institut Arnault Tzanck'),(6853,5142,'en','name','American Association for the Study of Liver Diseases'),(6854,5143,'en','name','Opotek Incorporation'),(6855,5143,'no_lang_code','name','Opotek (United States)'),(6856,5144,'no_lang_code','name','Alliance Pharmaceutical (United States)'),(6857,5145,'en','name','Norwich Research Park'),(6858,5146,'en','name','Glasgow Life'),(6859,5147,'no_lang_code','name','National Instruments (United Kingdom)'),(6860,5148,'en','name','Environmental Research Institute of Michigan'),(6861,5149,'no_lang_code','name','Agricultural Development Advisory Service (United Kingdom)'),(6862,5150,'en','name','Monterey Peninsula College'),(6863,5151,'de','name','Unfallkrankenhaus Wien Lorenz Böhler'),(6864,5152,'no_lang_code','name','Cemka-Eval (France)'),(6865,5153,'no_lang_code','name','Toxikon (United States)'),(6866,5154,'no_lang_code','name','Stoelting (United States)'),(6867,5155,'no_lang_code','name','rEVO Biologics (United States)'),(6868,5156,'no_lang_code','name','Roche (Canada)'),(6869,5157,'it','name','Azienda Ospedaliera di Perugia'),(6870,5158,'no_lang_code','name','TriboFilm Research (United States)'),(6871,5159,'it','name','Centro Cardiologico Monzino'),(6872,5160,'no_lang_code','name','BlueInGreen (United States)'),(6873,5161,'en','name','Mahatma Gandhi Kashi Vidyapith'),(6874,5161,'hi','name','महात्मा गाँधी काशी विद्यापीठ'),(6875,5161,'ta','name','மகாத்மா காந்தி காசி வித்யாபீடம்'),(6876,5162,'no_lang_code','name','Integran (Canada)'),(6877,5163,'no_lang_code','name','BioLegend (United States)'),(6878,5164,'no_lang_code','name','VinTech (United States)'),(6879,5165,'en','name','National Institute of Arthritis and Musculoskeletal and Skin Diseases'),(6880,5166,'en','name','Latino Health Institute (United States)'),(6881,5167,'no_lang_code','name','Okino Computer Graphics (Canada)'),(6882,5168,'en','name','Saskatchewan Hospice Palliative Care Association'),(6883,5169,'no_lang_code','name','Indus Instruments (United States)'),(6884,5170,'en','name','Loud Crow Interactive'),(6885,5171,'no_lang_code','name','Sharp Laboratories of Europe (United Kingdom)'),(6886,5172,'en','name','Healthcare Technology Systems'),(6887,5173,'en','name','Gyeongsangnam-do Agricultural Research and Extension Services'),(6888,5173,'ko','name','경상남도농업기술원'),(6889,5174,'no_lang_code','name','Cochlear (Switzerland)'),(6890,5175,'ar','name','مستشفى توام'),(6891,5175,'en','name','Tawam Hospital'),(6892,5176,'en','name','Highline College'),(6893,5177,'no_lang_code','name','Neuroscript (United States)'),(6894,5178,'no_lang_code','name','KeraNetics (United States)'),(6895,5179,'en','name','Association of State and Territorial Health Officials'),(6896,5180,'en','name','Kanagawa Institute of Technology'),(6897,5180,'ja','name','神奈川工科大学'),(6898,5181,'en','name','Hubbs-Sea World Research Institute'),(6899,5182,'no_lang_code','name','Bio-Synthesis (United States)'),(6900,5183,'no_lang_code','name','Prototypes (United States)'),(6901,5184,'no_lang_code','name','Oceanit (United States)'),(6902,5185,'en','name','Wellington Hospital'),(6903,5186,'en','name','Maine Maritime Academy'),(6904,5187,'en','name','Diamond Headache Clinic'),(6905,5188,'pt','name','Centro de Genética Clínica'),(6906,5189,'it','name','Istituto per lo Studio e la Prevenzione Oncologica'),(6907,5190,'no_lang_code','name','Companhia União Fabril'),(6908,5191,'en','name','Huddersfield Royal Infirmary'),(6909,5192,'no_lang_code','name','JEOL (United Kingdom)'),(6910,5193,'no_lang_code','name','Addcomp (Netherlands)'),(6911,5194,'no_lang_code','name','Watershed Associates'),(6912,5195,'sv','name','Sunderby sjukhus'),(6913,5196,'en','name','City of Bradford Metropolitan District Council'),(6914,5197,'en','name','International Neuroscience Institute'),(6915,5198,'de','name','Max-Planck-Institut für Dynamik und Selbstorganisation'),(6916,5198,'en','name','Max Planck Institute for Dynamics and Self-Organization'),(6917,5199,'no_lang_code','name','NeuroDx Development (United States)'),(6918,5200,'da','name','Regionshospitalet Viborg'),(6919,5200,'en','name','Viborg Regional Hospital'),(6920,5201,'en','name','Institute of Theoretical and Experimental Biophysics'),(6921,5201,'ru','name','Федеральное государственное бюджетное учреждение науки Институт теоретической и экспериментальной биофизики Российской академии наук'),(6922,5202,'pt','name','Centro Brasileiro de Estudos em Dermatologia'),(6923,5203,'en','name','American Nurses Association'),(6924,5204,'no_lang_code','name','Boston Applied Technologies (United States)'),(6925,5205,'en','name','Central Council for Research in Ayurvedic Science'),(6926,5206,'en','name','Sunnybrook Hospital'),(6927,5207,'no_lang_code','name','Monteco (Canada)'),(6928,5208,'no_lang_code','name','Premier Foods (United Kingdom)'),(6929,5209,'no_lang_code','name','MediSpectra (United States)'),(6930,5210,'en','name','Sunderland Eye Infirmary'),(6931,5211,'en','name','Zensa Hospital'),(6932,5212,'en','name','American Society for Reproductive Medicine'),(6933,5213,'no_lang_code','name','Inscent (United States)'),(6934,5214,'en','name','Tianjin Third Central Hospital'),(6935,5214,'zh','name','天津市第三中心医院'),(6936,5215,'en','name','Confederation of National Associations of Tanners and Dressers of the European Community'),(6937,5216,'en','name','Ontario Ministry of Labour'),(6938,5216,'fr','name','Ministère du Travail'),(6939,5217,'en','name','Philosophy of Science Association'),(6940,5218,'en','name','National Association of School Nurses'),(6941,5219,'en','name','Northwestern Memorial Hospital'),(6942,5220,'no_lang_code','name','MAX Mobility (United States)'),(6943,5221,'no_lang_code','name','ChemGreen Innovation (Canada)'),(6944,5222,'no_lang_code','name','MacConnell Research (United States)'),(6945,5223,'no_lang_code','name','Hitachi (United Kingdom)'),(6946,5224,'en','name','Red Rocks Community College'),(6947,5225,'it','name','Figli Adottivi e Genitori Naturali'),(6948,5226,'en','name','Edinburgh Royal Infirmary'),(6949,5227,'no_lang_code','name','Jet Process Corporation (United States)'),(6950,5228,'en','name','National Institute of Health and Family Welfare'),(6951,5228,'hi','name','राष्ट्रीय स्वास्थ्य और परिवार कल्याण संस्थान'),(6952,5229,'no_lang_code','name','360pi (Canada)'),(6953,5230,'en','name','National Renewable Energy Centre'),(6954,5231,'it','name','Fondazione Istituto Neurologico Nazionale Casimiro Mondino'),(6955,5232,'no_lang_code','name','Picarro (United States)'),(6956,5233,'en','name','Institute of Livestock and Grassland Science'),(6957,5233,'ja','name','畜産研究部門'),(6958,5234,'no_lang_code','name','Integrated DNA Technologies (United States)'),(6959,5235,'no_lang_code','name','Chembio (United States)'),(6960,5236,'en','name','Western General Hospital'),(6961,5237,'pt','name','Instituto H. Ellis'),(6962,5238,'no_lang_code','name','Advanced Circulatory System (United States)'),(6963,5239,'en','name','American College of Surgeons'),(6964,5240,'no_lang_code','name','StataCorp (United States)'),(6965,5241,'en','name','St. Joseph Medical Center'),(6966,5242,'en','name','Central Institute of Psychiatry'),(6967,5242,'hi','name','केन्द्रीय मनश्चिकित्सा संस्थान'),(6968,5243,'en','name','The Tech Interactive'),(6969,5244,'en','name','San Francisco Film Society'),(6970,5245,'en','name','Pamela Youde Nethersole Eastern Hospital'),(6971,5245,'zh','name','東區尤德夫人那打素醫院'),(6972,5246,'en','name','Rollins College'),(6973,5247,'no_lang_code','name','Sema Construction (United States)'),(6974,5248,'no_lang_code','name','GVD Corporation (United States)'),(6975,5249,'en','name','F.D. Ovcharenko Institute of Biocolloidal Chemistry'),(6976,5249,'uk','name','Інститут біоколоїдної хімії ім. Ф. Д. Овчаренка'),(6977,5250,'no_lang_code','name','Area Detector Systems Corporation (United States)'),(6978,5251,'en','name','Toyama Institute of Health'),(6979,5251,'ja','name','富山県衛生研究所'),(6980,5252,'no_lang_code','name','Dyson (United Kingdom)'),(6981,5253,'en','name','Philippine General Hospital'),(6982,5254,'en','name','P. D. Hinduja Hospital and Medical Research Centre'),(6983,5255,'no_lang_code','name','Nature Technology Corporation (United States)'),(6984,5256,'no_lang_code','name','Ion Physics (United States)'),(6985,5257,'en','name','W.M. Keck Observatory'),(6986,5258,'en','name','William Beaumont Army Medical Center'),(6987,5259,'fr','name','Collège Shawinigan'),(6988,5260,'de','name','Städtisches Klinikum Karlsruhe'),(6989,5261,'en','name','Capital Allergy and Respiratory Disease Center'),(6990,5262,'no_lang_code','name','Adasa (Spain)'),(6991,5263,'en','name','Queen Saovabha Memorial Institute'),(6992,5264,'no_lang_code','name','Phcc (United States)'),(6993,5265,'en','name','Saint Vincent College'),(6994,5266,'no_lang_code','name','SonaCare Medical (United States)'),(6995,5267,'en','name','Ministry of Justice'),(6996,5268,'no_lang_code','name','P&P Optica (Canada)'),(6997,5269,'en','name','Island Peer Review Organization'),(6998,5270,'en','name','Florence–Darlington Technical College'),(6999,5271,'no_lang_code','name','Performance Polymer Solutions (United States)'),(7000,5272,'en','name','Center for Science in the Public Interest (United States)'),(7001,5273,'no_lang_code','name','FFA Sciences (United States)'),(7002,5274,'en','name','Wakayama Rosai Hospital'),(7003,5274,'ja','name','和歌山ろうさい病院'),(7004,5275,'fr','name','Institut de Virologie'),(7005,5276,'no_lang_code','name','BM-Science'),(7006,5277,'en','name','Vision Eye Institute'),(7007,5278,'no_lang_code','name','InnerSea Technology (United States)'),(7008,5279,'en','name','Rancho Santiago Community College District'),(7009,5280,'no_lang_code','name','Mandel Scientific (Canada)'),(7010,5281,'en','name','Fond du Lac Tribal and Community College'),(7011,5282,'en','name','St. Francis Hospital'),(7012,5283,'en','name','Association for Symbolic Logic'),(7013,5284,'en','name','Wexford General Hospital'),(7014,5284,'ga','name','Ospidéal Ginearálta Loch Garman'),(7015,5285,'no_lang_code','name','Stallergenes Greer (France)'),(7016,5286,'en','name','American Academy of Dermatology'),(7017,5287,'no_lang_code','name','Local Data Company (United Kingdom)'),(7018,5288,'no_lang_code','name','Juvaris BioTherapeutics (United States)'),(7019,5289,'ja','name','日本電信電話株式会社'),(7020,5289,'no_lang_code','name','NTT (Japan)'),(7021,5290,'no_lang_code','name','Cooperative Resources International (United States)'),(7022,5291,'no_lang_code','name','Endacea (United States)'),(7023,5292,'no_lang_code','name','Endomedix (United States)'),(7024,5293,'en','name','Royal Institute of British Architects'),(7025,5294,'en','name','St. James Hospital and Health Centers'),(7026,5295,'en','name','Fukuoka Institute of Technology'),(7027,5295,'ja','name','福岡工業大学'),(7028,5296,'en','name','North Sydney Orthopaedic and Sports Medicine Centre'),(7029,5297,'fr','name','Institut de Recherche pour le Développement'),(7030,5298,'en','name','National Partnership for Environmental Technology Education'),(7031,5299,'en','name','Merrimack College'),(7032,5300,'no_lang_code','name','Blackrock Microsystems (United States)'),(7033,5301,'en','name','Institute of Experimental Cardiology'),(7034,5302,'en','name','Cascade AIDS Project'),(7035,5303,'no_lang_code','name','Allocadia (Canada)'),(7036,5304,'en','name','Food Research Institute'),(7037,5304,'ja','name','食品総合研究所'),(7038,5305,'en','name','Botanical Society of America'),(7039,5306,'en','name','Penrose Hospital'),(7040,5307,'no_lang_code','name','21st Century Therapeutics (United States)'),(7041,5308,'en','name','Institute for Advanced Studies in Basic Sciences'),(7042,5308,'fa','name','مرکز تحصیلات تکمیلی در علوم پایه زنجان'),(7043,5309,'no_lang_code','name','Boulder Language Technologies (United States)'),(7044,5310,'en','name','Academy of Medical Sciences'),(7045,5311,'no_lang_code','name','ABB (United States)'),(7046,5312,'no_lang_code','name','ANI Pharmaceuticals (United States)'),(7047,5313,'no_lang_code','name','Virscio (United States)'),(7048,5314,'en','name','University of California, Irvine Medical Center'),(7049,5315,'en','name','Connecticut Business and Industry Association'),(7050,5316,'it','name','Istituto Neurologico Mediterraneo'),(7051,5317,'no_lang_code','name','Capstone Therapeutics (United States)'),(7052,5318,'en','name','Yaroslavl State Medical Academy'),(7053,5318,'ru','name','Ярославский государственный медицинский университет'),(7054,5319,'en','name','National Institute of Perinatología Isidro Espinosa de los Reyes'),(7055,5319,'es','name','Instituto Nacional de Perinatología'),(7056,5320,'en','name','BioNB'),(7057,5321,'en','name','Saint Vincent\'s Catholic Medical Center'),(7058,5322,'bn','name','ভারতীয় মহাকাশ গবেষণা সংস্থা'),(7059,5322,'en','name','Indian Space Research Organisation'),(7060,5322,'gu','name','ઇસરો'),(7061,5322,'hi','name','भारतीय अंतरिक्ष अनुसंधान संगठन'),(7062,5322,'kn','name','ಭಾರತೀಯ ಬಾಹ್ಯಾಕಾಶ ಸಂಶೋಧನೆ ಸಂಸ್ಥೆ'),(7063,5322,'ml','name','ഇന്ത്യൻ സ്പേസ് റിസർച്ച് ഓർഗനൈസേഷൻ'),(7064,5322,'mr','name','भारतीय अंतराळ संशोधन संस्था'),(7065,5322,'ne','name','भारतीय अन्तरिक्ष अनुसन्धान संगठन'),(7066,5322,'pa','name','ਇਸਰੋ'),(7067,5322,'ta','name','இந்திய விண்வெளி ஆய்வு மையம்'),(7068,5322,'te','name','భారతీయ అంతరిక్ష పరిశోధనా సంస్థ'),(7069,5323,'no_lang_code','name','Recombinant Technologies (United States)'),(7070,5324,'no_lang_code','name','Parsons Brinckerhoff'),(7071,5325,'en','name','Langley Environmental Partners Society'),(7072,5326,'ja','name','横浜南共済病院'),(7073,5326,'no_lang_code','name','Yokohama Minami Kyosai Hospital'),(7074,5327,'no_lang_code','name','PLx Pharma (United States)'),(7075,5328,'en','name','Misericordia University'),(7076,5329,'en','name','Archaeology Southwest'),(7077,5330,'no_lang_code','name','Aspen Aerogels (United States)'),(7078,5331,'en','name','Central Laboratory for Radiological Protection'),(7079,5331,'pl','name','Centralnego Laboratorium Ochrony Radiologicznej'),(7080,5332,'no_lang_code','name','Haematologic Technologies (United States)'),(7081,5333,'en','name','St. Vincent Charity Hospital'),(7082,5334,'en','name','National Marine Mammal Foundation'),(7083,5335,'en','name','Allen Institute for Brain Science'),(7084,5336,'en','name','Refugee and Immigrant Center'),(7085,5337,'en','name','Administrative Staff College of India'),(7086,5338,'no_lang_code','name','Thermal-Lube (Canada)'),(7087,5339,'no_lang_code','name','TRIA Bioscience (United States)'),(7088,5340,'no_lang_code','name','Gooch & Housego (United Kingdom)'),(7089,5341,'en','name','Foothill College'),(7090,5342,'en','name','Colorado Judicial Branch'),(7091,5343,'no_lang_code','name','Oxford Lasers (United Kingdom)'),(7092,5344,'en','name','New York City Health and Hospitals Corporation'),(7093,5345,'fr','name','Science pour tous'),(7094,5346,'en','name','Notre Dame of Maryland University'),(7095,5347,'en','name','National Council on Ethics in Human Research'),(7096,5347,'fr','name','Conseil national d\'éthique en recherche chez l\'humain'),(7097,5348,'it','name','Oasi Maria SS'),(7098,5349,'en','name','Texas State Technical College Harlingen'),(7099,5350,'en','name','BC Research (Canada)'),(7100,5351,'en','name','Sustrans'),(7101,5352,'no_lang_code','name','Amplimmune (United States)'),(7102,5353,'en','name','Hernia Center'),(7103,5354,'no_lang_code','name','Hsiri Therapeutics (United States)'),(7104,5355,'no_lang_code','name','Sterling Research Group (United States)'),(7105,5356,'no_lang_code','name','Rowan Williams Davies & Irwin (Canada)'),(7106,5357,'en','name','Agile Mind'),(7107,5358,'en','name','Hipple Cancer Research Center'),(7108,5359,'en','name','St. Davnet\'s Hospital'),(7109,5359,'ga','name','Ospidéal Naomh Damhnait'),(7110,5360,'en','name','Arapahoe House'),(7111,5361,'no_lang_code','name','Springboard (Canada)'),(7112,5362,'da','name','Vejle Sygehus'),(7113,5362,'en','name','Vejle Hospital'),(7114,5363,'en','name','Center for Clinical Studies'),(7115,5364,'it','name','Ospedale degli Infermi'),(7116,5365,'en','name','Academy of Radiology Research'),(7117,5366,'en','name','Chief Dull Knife College'),(7118,5367,'en','name','Institute of Physiology and Pathology of Hearing'),(7119,5368,'no_lang_code','name','BioMedomics (United States)'),(7120,5369,'en','name','National Environmental Health Association'),(7121,5370,'no_lang_code','name','Horizon Research (United States)'),(7122,5371,'pt','name','Instituto de Infectologia Emílio Ribas'),(7123,5372,'en','name','Hamilton Regional Laboratory Medicine Program'),(7124,5373,'no_lang_code','name','Capital Consulting Corporation (United States)'),(7125,5374,'en','name','Center for Complex Infectious Diseases'),(7126,5375,'en','name','National Audit Office'),(7127,5376,'en','name','Columbia College - South Carolina'),(7128,5377,'en','name','Matsumoto Livestock Hygiene Service Center'),(7129,5378,'en','name','Australian Red Cross Lifeblood'),(7130,5379,'no_lang_code','name','MycoLogic (Canada)'),(7131,5380,'en','name','Joint Center for Structural Genomics'),(7132,5381,'en','name','KentuckyOne Health'),(7133,5382,'en','name','St. Luke\'s Cataract and Laser Institute'),(7134,5383,'no_lang_code','name','NVE Corporation (United States)'),(7135,5384,'en','name','Wakefield Hospital'),(7136,5385,'en','name','Swedish Medical Center'),(7137,5386,'bg','name','Институт по електрохимия и енергийни системи'),(7138,5386,'en','name','Institute of Electrochemistry and Energy Systems'),(7139,5387,'en','name','Third Affiliated Hospital of Guangzhou Medical University'),(7140,5387,'zh','name','广州医科大学附属第三医院'),(7141,5388,'no_lang_code','name','Air Canada'),(7142,5389,'no_lang_code','name','Pacific Biosciences (United States)'),(7143,5390,'no_lang_code','name','Adif (Spain)'),(7144,5391,'no_lang_code','name','Yecuris (United States)'),(7145,5392,'en','name','National Institute of Blood Transfusion'),(7146,5392,'fr','name','Institut National de la Transfusion Sanguine'),(7147,5393,'en','name','Christian Community Health Center'),(7148,5394,'no_lang_code','name','GigaGen (United States)'),(7149,5395,'en','name','Academy of Medicine'),(7150,5396,'en','name','Clinical Center of Vojvodina'),(7151,5396,'sr','name','Klinički centar Vojvodine'),(7152,5397,'en','name','National Institute on Drug Abuse'),(7153,5398,'en','name','Community Health Awareness Group'),(7154,5399,'no_lang_code','name','Woomera Therapeutics'),(7155,5400,'en','name','University of British Columbia Hospital'),(7156,5401,'en','name','St. Francis Hospital'),(7157,5402,'es','name','Hospital Quirón Teknon'),(7158,5403,'en','name','Newcastle City Council'),(7159,5404,'en','name','Center for Research in Environmental Epidemiology'),(7160,5404,'es','name','Centro de Investigación en Epidemiología Ambiental'),(7161,5405,'no_lang_code','name','Moberg Research (United States)'),(7162,5406,'en','name','Manchester VA Medical Center'),(7163,5407,'no_lang_code','name','WinProbe (United States)'),(7164,5408,'en','name','PHS Commissioned Officers Foundation'),(7165,5409,'no_lang_code','name','Ford Motor Company (United States)'),(7166,5410,'no_lang_code','name','Cornerstone Systems Northwest (United States)'),(7167,5411,'no_lang_code','name','Taiga Biotechnologies (United States)'),(7168,5412,'no_lang_code','name','Front Range Scientific Computations'),(7169,5413,'en','name','Texas Endosurgery Institute'),(7170,5414,'en','name','Hughston Clinic'),(7171,5415,'en','name','Zunyi Medical University'),(7172,5415,'zh','name','遵义医学院'),(7173,5416,'no_lang_code','name','Asuragen (United States)'),(7174,5417,'en','name','Calgary Laboratory Services'),(7175,5418,'en','name','Gansu University of Traditional Chinese Medicine'),(7176,5418,'zh','name','甘肃中医学院'),(7177,5419,'no_lang_code','name','Columbus Technologies and Services (United States)'),(7178,5420,'no_lang_code','name','Y Touring Theatre Company'),(7179,5421,'en','name','Biomedical Research Foundation of the Academy of Athens'),(7180,5422,'en','name','National Center on Institutions and Alternatives'),(7181,5423,'no_lang_code','name','Novartis (France)'),(7182,5424,'no_lang_code','name','Nordic Life Science Pipeline (Canada)'),(7183,5425,'no_lang_code','name','Therapyx (United States)'),(7184,5426,'sk','name','Národný Onkologický Ústav'),(7185,5427,'fr','name','Centre Hospitalier Frèderic-Henri Manhès'),(7186,5428,'it','name','Ospedale regionale di Lugano'),(7187,5429,'en','name','National Institute of Cardiovascular Diseases'),(7188,5430,'en','name','Institute of Chemical Biology and Fundamental Medicine'),(7189,5430,'ru','name','Федеральное государственное бюджетное учреждение науки Институт химической биологии и фундаментальной медицины Сибирского отделения Российской академии наук'),(7190,5431,'no_lang_code','name','Malesci (Italy)'),(7191,5432,'en','name','Oita Red Cross Hospital'),(7192,5432,'ja','name','大分赤十字病院'),(7193,5433,'en','name','Valencian Infertility Institute'),(7194,5434,'en','name','Progress Educational Trust'),(7195,5435,'en','name','East Bay Community Recovery Project'),(7196,5436,'no_lang_code','name','Fugro (United States)'),(7197,5437,'en','name','Bienestar'),(7198,5438,'nl','name','AZ Klina'),(7199,5439,'no_lang_code','name','Swami Vivekananda Yoga Anusandhana Samsthana'),(7200,5440,'en','name','Denver Center for the Performing Arts'),(7201,5441,'en','name','Sri Jayadeva Institute of Cardiovascular Sciences and Research'),(7202,5442,'en','name','Hispanic Association of Colleges and Universities'),(7203,5443,'no_lang_code','name','Arrayomics (United States)'),(7204,5444,'en','name','Toyota Memorial Hospital'),(7205,5444,'ja','name','トヨタ記念病院'),(7206,5445,'no_lang_code','name','Film and Video Umbrella (United Kingdom)'),(7207,5446,'no_lang_code','name','Adherent Technologies (United States)'),(7208,5447,'no_lang_code','name','Advanced Mechanical Technology (United States)'),(7209,5448,'en','name','Community College of Philadelphia'),(7210,5449,'no_lang_code','name','Applied Research Corporation (United States)'),(7211,5450,'en','name','Seattle Central College'),(7212,5451,'no_lang_code','name','AAC (United States)'),(7213,5452,'no_lang_code','name','Tianjin Nankai Hospital'),(7214,5452,'zh','name','天津市南开医院'),(7215,5453,'en','name','National Institute for Children’s Health Quality'),(7216,5454,'en','name','Osmania Medical College'),(7217,5454,'te','name','ఉస్మానియా మెడికల్ కాలేజీ'),(7218,5454,'ur','name','عثمانیہ میڈیکل کالج'),(7219,5455,'en','name','Emory Eye Center'),(7220,5456,'no_lang_code','name','Science Approach (United States)'),(7221,5457,'no_lang_code','name','Biothermal (United States)'),(7222,5458,'no_lang_code','name','Wave 80 Biosciences (United States)'),(7223,5459,'fr','name','Association Nationale de la Recherche et de la Technologie'),(7224,5460,'en','name','Paine College'),(7225,5461,'no_lang_code','name','Icogenex (United States)'),(7226,5462,'no_lang_code','name','DEKK-TEC (United States)'),(7227,5463,'no_lang_code','name','Source Signal Imaging'),(7228,5464,'en','name','Russian Academy of Natural Sciences'),(7229,5465,'no_lang_code','name','Plastic Logic (United Kingdom)'),(7230,5466,'en','name','Rural Alaska Community Action Program'),(7231,5467,'en','name','Guy\'s and St Thomas\' NHS Foundation Trust'),(7232,5468,'no_lang_code','name','Optym (United States)'),(7233,5469,'en','name','W. Alton Jones Cell Science Center'),(7234,5470,'fr','name','Laboratoire d\'Enzymologie et Biochimie Structurales'),(7235,5471,'no_lang_code','name','TMD Technologies (United Kingdom)'),(7236,5472,'no_lang_code','name','GlySens (United States)'),(7237,5473,'en','name','LRS Institute of Tuberculosis and Respiratory Diseases'),(7238,5474,'en','name','New World Laboratories'),(7239,5475,'en','name','European Chemical Industry Council'),(7240,5475,'fr','name','Conseil Européen des Fédérations de l\'Industrie Chimique'),(7241,5476,'it','name','Azienda Ospedaliera San Camillo-Forlanini, Ospedale Carlo Forlanini'),(7242,5477,'no_lang_code','name','Monsanto (United States)'),(7243,5478,'no_lang_code','name','GT Advanced Technologies (United States)'),(7244,5479,'no_lang_code','name','Metabolic Technologies (United States)'),(7245,5480,'no_lang_code','name','KGL Skin Study Center'),(7246,5481,'en','name','Salisbury NHS Foundation Trust'),(7247,5482,'no_lang_code','name','Sensonics International (United States)'),(7248,5483,'en','name','Oglala Sioux Tribal Council'),(7249,5484,'en','name','National Center for Environmental Health'),(7250,5485,'en','name','Mississippi Sports Medicine and Orthopaedic Center'),(7251,5486,'no_lang_code','name','Information Ventures (United States)'),(7252,5487,'en','name','Algebra Project'),(7253,5488,'en','name','New Mexico Clinical Research & Osteoporosis Center'),(7254,5489,'ja','name','大津市民病院'),(7255,5489,'no_lang_code','name','Otsu Municipal Hospital'),(7256,5490,'en','name','National Quality Forum'),(7257,5491,'de','name','Klinikum Aschaffenburg'),(7258,5492,'en','name','American Board of Internal Medicine'),(7259,5493,'en','name','Suburban Hospital'),(7260,5494,'no_lang_code','name','Flexion Therapeutics (United States)'),(7261,5495,'en','name','Maulana Azad Institute of Dental Sciences'),(7262,5496,'no_lang_code','name','Centurion Biofuels (Canada)'),(7263,5497,'en','name','BC Centre for Aquatic Health Sciences'),(7264,5498,'en','name','Cooper Clinic'),(7265,5499,'en','name','United States Congress'),(7266,5500,'en','name','Austin Diagnostic Clinic'),(7267,5501,'en','name','Dr. Bhim Rao Ambedkar University'),(7268,5502,'en','name','South Dakota Academy of Science'),(7269,5503,'no_lang_code','name','Tianjin Tianhe Hospital'),(7270,5503,'zh','name','天津市天和医院'),(7271,5504,'pt','name','Centro Hospitalar de Lisboa Central'),(7272,5505,'es','name','Instituto Nacional de Investigaciones Nucleares'),(7273,5506,'no_lang_code','name','5T Torino (Italy)'),(7274,5507,'en','name','Huntingdon College'),(7275,5508,'fr','name','Agence de Médecine Préventive'),(7276,5509,'en','name','Ogori Daiichi General Hospital'),(7277,5509,'ja','name','小郡第一総合病院'),(7278,5510,'en','name','American Federation of Mineralogical Societies'),(7279,5511,'en','name','Boreskov Institute of Catalysis, Institute of Catalysis'),(7280,5511,'ru','name','Федеральное государственное бюджетное учреждение науки Институт катализа им. Г.К. Борескова Сибирского отделения Российской академии наук'),(7281,5512,'en','name','Ideon Science Park'),(7282,5513,'no_lang_code','name','Pfizer (Sweden)'),(7283,5514,'en','name','National Centre for Research'),(7284,5515,'no_lang_code','name','Heska (United States)'),(7285,5516,'en','name','Finlay Institute'),(7286,5517,'no_lang_code','name','ABB (Switzerland)'),(7287,5518,'no_lang_code','name','Seralogix (United States)'),(7288,5519,'en','name','Weil Institute of Critical Care Medicine'),(7289,5520,'it','name','Istituto Nazionale per le Malattie Infettive Lazzaro Spallanzani'),(7290,5521,'no_lang_code','name','Tri Y Environmental Research Institute (Canada)'),(7291,5522,'en','name','Council on Social Work Education'),(7292,5523,'es','name','Instituto Valenciano de Investigaciones Agrarias'),(7293,5524,'en','name','Clinical Orthopaedics and Related Research'),(7294,5525,'en','name','Traffic Injury Research Foundation'),(7295,5525,'fr','name','Fondation de recherches sur les blessures de la route'),(7296,5526,'en','name','Cincinnati Museum Center'),(7297,5527,'en','name','Kennedy Center'),(7298,5528,'en','name','Center for Research and Technology Thessaly'),(7299,5529,'no_lang_code','name','PricewaterhouseCoopers (Canada)'),(7300,5530,'en','name','Mental Health Center of Denver'),(7301,5531,'en','name','Iona College'),(7302,5532,'en','name','Trinity Mother Frances Hospitals and Clinics'),(7303,5533,'en','name','St. Mary\'s Hospital'),(7304,5534,'en','name','Society for Advancement of Chicanos and Native Americans in Science'),(7305,5535,'en','name','Carter Center'),(7306,5536,'en','name','United States Consumer Product Safety Commission'),(7307,5536,'es','name','Comisión para la Seguridad de los Productos de Consumo de los Estados Unidos'),(7308,5537,'no_lang_code','name','Advanced Technology and Research Corporation (United States)'),(7309,5538,'no_lang_code','name','Virtalis (United Kingdom)'),(7310,5539,'en','name','Applied Computer Security Associates'),(7311,5540,'en','name','Wheelock College'),(7312,5541,'en','name','St. Luke\'s Hospital'),(7313,5542,'en','name','St. Vincent\'s Hospital'),(7314,5542,'ko','name','가톨릭대학교 성빈센트병원'),(7315,5543,'no_lang_code','name','Superconductor Technologies (United States)'),(7316,5544,'en','name','American Academy of Neurology'),(7317,5545,'en','name','Neuropsychiatric Research Institute'),(7318,5546,'en','name','Warde Medical Laboratory'),(7319,5547,'en','name','Itasca Community College'),(7320,5548,'no_lang_code','name','Giner (United States)'),(7321,5549,'en','name','American Aging Association'),(7322,5550,'en','name','St Mary\'s University College'),(7323,5551,'en','name','Takamatsu Red Cross Hospital'),(7324,5551,'ja','name','高松赤十字病院'),(7325,5552,'no_lang_code','name','Tioma Therapeutics (United States)'),(7326,5553,'it','name','Centro di Riferimento Oncologico della Basilicata'),(7327,5554,'no_lang_code','name','Bayer (Belgium)'),(7328,5555,'no_lang_code','name','Ambulatory Monitoring (United States)'),(7329,5556,'no_lang_code','name','EcoSynthetix (Canada)'),(7330,5557,'no_lang_code','name','Meadowlark Optics (United States)'),(7331,5558,'no_lang_code','name','Novozymes (United Kingdom)'),(7332,5559,'en','name','St. Andrews University'),(7333,5560,'en','name','Chulabhorn Research Institute'),(7334,5560,'th','name','สถาบันวิจัยจุฬาภรณ์'),(7335,5561,'no_lang_code','name','Vida Health Communications (United States)'),(7336,5562,'en','name','Australian Council of Learned Academies'),(7337,5563,'en','name','Women Medical College'),(7338,5564,'en','name','Stockholm South General Hospital'),(7339,5565,'en','name','New York Structural Biology Center'),(7340,5566,'ja','name','山形市立病院済生館'),(7341,5566,'no_lang_code','name','Yamagata City Hospital Saiseikan'),(7342,5567,'no_lang_code','name','Thermo Fisher Scientific (Sweden)'),(7343,5568,'no_lang_code','name','PCAS (Canada)'),(7344,5569,'en','name','Mount Auburn Hospital'),(7345,5570,'en','name','Discovery Place'),(7346,5571,'en','name','Benjamin Rose Institute on Aging'),(7347,5572,'en','name','Red Cross Hospital'),(7348,5573,'en','name','National Research Institute of Chinese Medicine'),(7349,5573,'zh','name','國立中國醫藥研究所'),(7350,5574,'en','name','Philadelphia Fight'),(7351,5575,'en','name','COMSATS University Islamabad'),(7352,5575,'ur','name','کومسٹس انسٹیٹیوٹ آف انفارمیشن ٹیکنالوجی'),(7353,5576,'en','name','Pushpawati Singhania Research Institute'),(7354,5577,'no_lang_code','name','Edge Enterprises (United States)'),(7355,5578,'en','name','College of Saint Rose'),(7356,5579,'no_lang_code','name','PlastiPure (United States)'),(7357,5580,'en','name','Australia and New Zealand Dialysis and Transplant Registry'),(7358,5581,'no_lang_code','name','HyperMed (United States)'),(7359,5582,'en','name','Office of the Medical Examiner of Cook County'),(7360,5583,'en','name','Alder Hey Children\'s NHS Foundation Trust'),(7361,5584,'no_lang_code','name','Amphora NDT (United Kingdom)'),(7362,5585,'ar','name','هيئة البيئة'),(7363,5585,'en','name','Environment Agency Abu Dhabi'),(7364,5586,'en','name','Virus Unit'),(7365,5587,'en','name','Education Connection'),(7366,5588,'no_lang_code','name','Agriculture Environmental Renewal Canada (Canada)'),(7367,5589,'it','name','Ospedale Civile di Giaveno'),(7368,5590,'en','name','Desert Botanical Garden'),(7369,5591,'no_lang_code','name','Saaten Union (United Kingdom)'),(7370,5592,'en','name','Cape Shoulder Institute'),(7371,5593,'no_lang_code','name','EDJ Associates'),(7372,5594,'no_lang_code','name','Sainsbury\'s (United Kingdom)'),(7373,5595,'en','name','City of Scientific Research and Technological Applications'),(7374,5596,'en','name','Delaware Technical Community College'),(7375,5597,'en','name','Eurotransplant'),(7376,5598,'en','name','Northwest Clinical Research Center'),(7377,5599,'en','name','Southern Arizona AIDS Foundation'),(7378,5600,'en','name','Faculty of Medicine of Marília'),(7379,5600,'pt','name','Faculdade de Medicina de Marília'),(7380,5601,'en','name','Camden County College'),(7381,5602,'en','name','Ohio Dominican University'),(7382,5603,'en','name','American Educational Research Association'),(7383,5604,'en','name','Concordia College - Minnesota'),(7384,5605,'en','name','Society of Toxicology'),(7385,5606,'no_lang_code','name','Grove Instruments (United States)'),(7386,5607,'en','name','UMass Memorial Health Care'),(7387,5608,'no_lang_code','name','Eli Lilly (United Kingdom)'),(7388,5609,'en','name','Cornea Research Foundation of America'),(7389,5610,'de','name','Max-Planck-Institut für Kolloid- und Grenzflächenforschung'),(7390,5610,'en','name','Max Planck Institute of Colloids and Interfaces'),(7391,5611,'en','name','Yukon Kuskokwim Health Corporation'),(7392,5612,'no_lang_code','name','TeraView (United Kingdom)'),(7393,5613,'en','name','Institute of Radiation Protection and Dosimetry'),(7394,5613,'pt','name','Instituto de Radioproteção e Dosimetria'),(7395,5614,'en','name','Abisko Scientific Research Station'),(7396,5615,'no_lang_code','name','Murty Pharmaceuticals (United States)'),(7397,5616,'no_lang_code','name','Leap of Faith Technologies (United States)'),(7398,5617,'no_lang_code','name','Larus Technologies (Canada)'),(7399,5618,'no_lang_code','name','Campden BRI (United Kingdom)'),(7400,5619,'no_lang_code','name','Innovative Targeting Solutions (Canada)'),(7401,5620,'no_lang_code','name','23andMe (United States)'),(7402,5621,'es','name','Fundación Cardiovascular de Colombia'),(7403,5622,'no_lang_code','name','AST Products (United States)'),(7404,5623,'en','name','Committee on Climate Change'),(7405,5624,'en','name','County of Mendocino'),(7406,5625,'no_lang_code','name','ARTSCO (United States)'),(7407,5626,'no_lang_code','name','ECI Biotech (United States)'),(7408,5627,'en','name','Heart and Stroke Foundation'),(7409,5628,'no_lang_code','name','Atkins (United Kingdom)'),(7410,5629,'de','name','Wilhelminenspital'),(7411,5629,'en','name','Wilhelminen Hospital'),(7412,5630,'no_lang_code','name','Orphagen Pharmaceuticals (United States)'),(7413,5631,'no_lang_code','name','PicoCal (United States)'),(7414,5632,'en','name','Plant Biotechnology Institute'),(7415,5633,'en','name','Chris O’Brien Lifehouse'),(7416,5634,'no_lang_code','name','Vcom3D (United States)'),(7417,5635,'es','name','Colegio de Postgraduados'),(7418,5636,'no_lang_code','name','Elsoms (United Kingdom)'),(7419,5637,'no_lang_code','name','Actelion (United States)'),(7420,5638,'en','name','East Midlands Development Agency'),(7421,5639,'nl','name','Sticares InterACT'),(7422,5640,'no_lang_code','name','Atactic Technologies (United States)'),(7423,5641,'no_lang_code','name','Mikro Systems (United States)'),(7424,5642,'en','name','New England Aquarium'),(7425,5643,'en','name','East Los Angeles College'),(7426,5644,'no_lang_code','name','ElectroChem (United States)'),(7427,5645,'no_lang_code','name','Ion Beam Applications (United States)'),(7428,5646,'no_lang_code','name','Techshot (United States)'),(7429,5647,'en','name','San Mateo County Community College District'),(7430,5648,'no_lang_code','name','INC Research (United States)'),(7431,5649,'no_lang_code','name','Egis Pharmaceuticals (Hungary)'),(7432,5650,'en','name','Washington County Youth Service Bureau'),(7433,5651,'en','name','Baranov Central Institute of Aviation Motor Development'),(7434,5651,'ru','name','Центральный институт авиационного моторостроения им. П.И. Баранова'),(7435,5652,'en','name','Michigan Headache and Neurological Institute'),(7436,5653,'en','name','St. Joseph\'s Hospital'),(7437,5654,'en','name','Europdonor Foundation'),(7438,5655,'no_lang_code','name','Centro Radiológico Computarizado Corporació Sanitària (Spain)'),(7439,5656,'en','name','Center for Community Alternatives'),(7440,5657,'no_lang_code','name','Thales (United Kingdom)'),(7441,5658,'en','name','Women\'s Hospital'),(7442,5659,'no_lang_code','name','Orbital Research (United States)'),(7443,5660,'en','name','Mental Health Association of Southeastern Pennsylvania'),(7444,5661,'no_lang_code','name','ImmunoPrecise (Canada)'),(7445,5662,'no_lang_code','name','Cenix BioScience (Germany)'),(7446,5663,'en','name','Salem Hospital'),(7447,5664,'en','name','Miami Dade College'),(7448,5665,'no_lang_code','name','Tracer Technologies (United States)'),(7449,5666,'en','name','St. Vincent Hospital'),(7450,5667,'en','name','Cuban Neuroscience Center'),(7451,5668,'no_lang_code','name','Synta Pharmaceuticals (United States)'),(7452,5669,'no_lang_code','name','Guru Nanak Eye Centre'),(7453,5670,'no_lang_code','name','NYSERNet (United States)'),(7454,5671,'no_lang_code','name','Cyberkinetics (United States)'),(7455,5672,'en','name','American Association for Dental Research'),(7456,5673,'no_lang_code','name','Sorbent Technologies (United States)'),(7457,5674,'no_lang_code','name','Lockheed Martin (Canada)'),(7458,5675,'ja','name','豊川市民病院'),(7459,5675,'no_lang_code','name','Toyokawa City Hospital'),(7460,5676,'no_lang_code','name','Vidasym (United States)'),(7461,5677,'en','name','Indian Institute of Horticultural Research'),(7462,5678,'no_lang_code','name','Innovative Surface Technologies (United States)'),(7463,5679,'no_lang_code','name','INVIDI Technologies (Canada)'),(7464,5680,'en','name','Society for Risk Analysis'),(7465,5681,'en','name','Arctic Research Consortium of the United States'),(7466,5682,'en','name','Via Christi Hospital St. Francis'),(7467,5683,'no_lang_code','name','Asahi Chemical & Industry (Japan)'),(7468,5684,'en','name','Polisher Research Institute'),(7469,5685,'en','name','European Centre for Disease Prevention and Control'),(7470,5685,'sv','name','Europeiskt centrum för förebyggande och kontroll av sjukdomar'),(7471,5686,'en','name','American Urological Association'),(7472,5687,'en','name','Miwa Hospital'),(7473,5687,'ja','name','三輪病院'),(7474,5688,'en','name','Theiss Research'),(7475,5689,'en','name','Edward Via College of Osteopathic Medicine'),(7476,5690,'en','name','Center for Innovative Public Health Research'),(7477,5691,'no_lang_code','name','Turner Consulting Group (United States)'),(7478,5692,'no_lang_code','name','Orkla (Sweden)'),(7479,5693,'no_lang_code','name','Syngenta (United States)'),(7480,5694,'en','name','Northern Ohio Recovery Association'),(7481,5695,'de','name','Deutsches Rheuma-Forschungszentrum Berlin'),(7482,5695,'en','name','German Rheumatism Research Centre'),(7483,5696,'no_lang_code','name','Precision Therapeutics (United States)'),(7484,5697,'pt','name','Prefeitura da Cidade do Rio de Janeiro'),(7485,5698,'en','name','Institute For Ecology of Industrial Areas'),(7486,5698,'pl','name','Instytut Ekologii Terenów Uprzemysłowionych'),(7487,5699,'de','name','Münchner Leukämielabor'),(7488,5699,'no_lang_code','name','Munich Leukemia Laboratory (Germany)'),(7489,5700,'en','name','Saitama Children\'s Medical Center'),(7490,5700,'ja','name','埼玉県立小児医療センター'),(7491,5701,'no_lang_code','name','Wavetrend (United Kingdom)'),(7492,5702,'en','name','National Committee for Quality Assurance'),(7493,5703,'no_lang_code','name','Behavioral Assessment Incorporation (United States)'),(7494,5704,'no_lang_code','name','Colibri Technologies (Canada)'),(7495,5705,'it','name','Ospedale di Rivoli'),(7496,5706,'es','name','Centro Oncológico de Galicia'),(7497,5707,'no_lang_code','name','Ford Motor Company (United Kingdom)'),(7498,5708,'no_lang_code','name','HealthSim (United States)'),(7499,5709,'en','name','National Network of Public Health Institutes'),(7500,5710,'en','name','Hospital del Tórax'),(7501,5710,'es','name','Instituto Nacional del Tórax'),(7502,5711,'en','name','British Council'),(7503,5712,'no_lang_code','name','Emerson (United Kingdom)'),(7504,5713,'en','name','Africare'),(7505,5714,'en','name','Institute for Biological Sciences'),(7506,5715,'hr','name','Klinička bolnica \"Sveti Duh\"'),(7507,5716,'en','name','Center for Scientific Studies'),(7508,5716,'es','name','Centro de Estudios Científicos'),(7509,5717,'en','name','Emory Clinic'),(7510,5718,'no_lang_code','name','PAI Life Sciences (United States)'),(7511,5719,'en','name','New York Eye and Ear Infirmary'),(7512,5720,'no_lang_code','name','Polaris (United States)'),(7513,5721,'en','name','Arizona Heart Institute'),(7514,5722,'en','name','Porter Brook Medical Centre'),(7515,5723,'en','name','Association of Information Technology Companies of Northern Greece'),(7516,5724,'no_lang_code','name','Novosibirsk Institute of Organic Chemistry'),(7517,5724,'ru','name','Историческая справка НИОХ'),(7518,5725,'en','name','San Antonio Fighting Back'),(7519,5726,'en','name','American Nurses Credentialing Center'),(7520,5727,'no_lang_code','name','SimBiotic Software (United States)'),(7521,5728,'en','name','World Health Organization - Denmark'),(7522,5728,'fr','name','Organisation mondiale de la santé'),(7523,5728,'ru','name','Всемирная организация здравоохранения'),(7524,5729,'no_lang_code','name','PTAC (United States)'),(7525,5730,'en','name','Tongde Hospital of Zhejiang Province'),(7526,5730,'zh','name','浙江省立同德医院'),(7527,5731,'de','name','Fraunhofer-Institut für Algorithmen und Wissenschaftliches Rechnen SCAI'),(7528,5731,'en','name','Fraunhofer Institute for Algorithms and Scientific Computing'),(7529,5732,'en','name','Croatian Institute of Transfusion Medicine'),(7530,5732,'hr','name','Hrvatski Zavod za Transfuzijsku Medicinu'),(7531,5733,'no_lang_code','name','Clarovita Nutrition (Canada)'),(7532,5734,'en','name','Rochdale Infirmary'),(7533,5735,'en','name','Prairie Agricultural Machinery Institute'),(7534,5736,'en','name','St. Luke\'s Hospital Foundation'),(7535,5737,'en','name','Richmond Community College'),(7536,5738,'en','name','Bakersfield College'),(7537,5739,'no_lang_code','name','RC Electronics (United States)'),(7538,5740,'en','name','National Transplant Organization'),(7539,5740,'es','name','Organización Nacional de Trasplantes'),(7540,5741,'no_lang_code','name','Biopsy Sciences (United States)'),(7541,5742,'ja','name','東京都保健医療公社荏原病院'),(7542,5742,'no_lang_code','name','Ebara Hospital'),(7543,5743,'en','name','Baptist Health South Florida'),(7544,5744,'no_lang_code','name','Cytograft Tissue Engineering (United States)'),(7545,5745,'en','name','Centre of Studies on Geography and Spatial Planning'),(7546,5745,'pt','name','Centro de Estudos em Geografia e Ordenamento do Territorio'),(7547,5746,'en','name','Public Health Management Corporation'),(7548,5747,'en','name','College of Alameda'),(7549,5748,'en','name','Arizona Geological Survey'),(7550,5749,'en','name','Foundation for Advancements in Science and Education'),(7551,5750,'no_lang_code','name','Marker Gene Technologies (United States)'),(7552,5751,'en','name','Franklin County Genealogical & Historical Society'),(7553,5752,'en','name','National Institute of Pathology'),(7554,5753,'fr','name','Centre Hospitalier Universitaire de Tokoin'),(7555,5754,'en','name','Edmonds Community College'),(7556,5755,'no_lang_code','name','Immusoft (United States)'),(7557,5756,'en','name','California Western School of Law'),(7558,5757,'en','name','Dudley Observatory'),(7559,5758,'en','name','Laser and Skin Surgery Center of Indiana'),(7560,5759,'en','name','St. Petersburg College'),(7561,5760,'no_lang_code','name','Aronora (United States)'),(7562,5761,'en','name','University Rehabilitation Institute'),(7563,5761,'sl','name','Univerzitetni Rehabilitacijski Inštitut'),(7564,5762,'en','name','Community Anti Drug Coalitions of America'),(7565,5763,'en','name','Elizabeth Glaser Pediatric AIDS Foundation'),(7566,5764,'no_lang_code','name','Apex Biomedical (United States)'),(7567,5765,'en','name','RG Stone Urology & Laparoscopy Hospital'),(7568,5765,'hi','name','आरजी स्टोन यूरोलॉजी और लैप्रोस्कोपी अस्पताल'),(7569,5766,'no_lang_code','name','Vical (United States)'),(7570,5767,'no_lang_code','name','6WIND (France)'),(7571,5768,'no_lang_code','name','Advanced MRI Technologies (United States)'),(7572,5769,'en','name','Institute of Nuclear Chemistry and Technology'),(7573,5769,'pl','name','Instytut Chemii i Techniki Jądrowej'),(7574,5770,'en','name','Great Lakes Inter Tribal Council'),(7575,5771,'en','name','Coalition for a Drug Free Hawaii'),(7576,5772,'en','name','EdLab Group'),(7577,5773,'en','name','Mississippi School for Mathematics and Science'),(7578,5774,'no_lang_code','name','Kane Biotech (Canada)'),(7579,5775,'en','name','New Mexico Resonance'),(7580,5776,'no_lang_code','name','Johnson Matthey (United States)'),(7581,5777,'no_lang_code','name','Environmental Consultants and Contractors'),(7582,5778,'en','name','Mount Marty College'),(7583,5779,'no_lang_code','name','KCI (United States)'),(7584,5780,'no_lang_code','name','Genlantis (United States)'),(7585,5781,'no_lang_code','name','Menssana Research (United States)'),(7586,5782,'en','name','Chemical Diversity Research Institute'),(7587,5782,'ru','name','Исследовательский Институт Химического Разнообразия'),(7588,5783,'en','name','Carthage College'),(7589,5784,'no_lang_code','name','Quintessence Biosciences (United States)'),(7590,5785,'no_lang_code','name','Electronic BioSciences (United States)'),(7591,5786,'en','name','South Carolina Technical College System'),(7592,5787,'no_lang_code','name','Tejas Networks (India)'),(7593,5788,'pt','name','Associacao Protectora dos Diabeticos de Portugal'),(7594,5789,'en','name','St. Paul\'s Hospital'),(7595,5790,'fr','name','Institut Régional de Médecine Physique et de Réadaptation'),(7596,5791,'en','name','International Centers for Excellence in Research'),(7597,5792,'en','name','Tourette Association of America'),(7598,5793,'en','name','Nezhat Medical Center'),(7599,5794,'pt','name','Instituto Geográfico Português'),(7600,5795,'fr','name','Institut Calot'),(7601,5796,'it','name','Ospedale Civile Edoardo Agnelli'),(7602,5797,'no_lang_code','name','Oralys (Canada)'),(7603,5798,'en','name','Whitchurch Hospital'),(7604,5799,'en','name','Association of Health Care Journalists'),(7605,5800,'en','name','Birmingham Women\'s Hospital'),(7606,5801,'en','name','National Institute of Medical Sciences and Nutrition Salvador Zubirán'),(7607,5801,'es','name','Instituto Nacional de Ciencias Médicas y Nutrición Salvador Zubirán'),(7608,5802,'en','name','Tanzania Food and Nutrition Center'),(7609,5803,'en','name','Child Trends'),(7610,5804,'en','name','Czech Environmental Information Agency'),(7611,5805,'en','name','American Society for Pharmacology and Experimental Therapeutics'),(7612,5806,'en','name','Epsom and St Helier University Hospitals NHS Trust'),(7613,5807,'en','name','Our Lady of Lourdes Regional Medical Center'),(7614,5808,'en','name','Hudson Valley Regional Emergency Medical Services Council'),(7615,5809,'no_lang_code','name','LC Resources (United States)'),(7616,5810,'en','name','Hough Ear Institute'),(7617,5811,'en','name','Ohio Department of Agriculture'),(7618,5812,'no_lang_code','name','RxBio (United States)'),(7619,5813,'no_lang_code','name','Kelly Services (United States)'),(7620,5814,'no_lang_code','name','Aeon Imaging (United States)'),(7621,5815,'en','name','Fatima Jinnah Dental College'),(7622,5816,'en','name','Royal Society of Canada'),(7623,5816,'fr','name','La Société royale du Canada'),(7624,5817,'ja','name','済生会熊本病院'),(7625,5817,'no_lang_code','name','Saiseikai Kumamoto Hospital'),(7626,5818,'en','name','Ohkawara Neurosurgical Hospital'),(7627,5818,'ja','name','大川原脳神経外科病院'),(7628,5819,'en','name','Eye and Ear Foundation'),(7629,5820,'en','name','Wrightington Hospital'),(7630,5821,'no_lang_code','name','Merck (France)'),(7631,5822,'en','name','Tachikawa Medical Center'),(7632,5822,'ja','name','立川メディカルセンター'),(7633,5823,'en','name','Shepherd University'),(7634,5824,'no_lang_code','name','Intertek (Canada)'),(7635,5825,'en','name','Informed Families'),(7636,5826,'en','name','National Association for Biomedical Research'),(7637,5827,'it','name','Istituto Nazionale di Ricerca per gli Alimenti e la Nutrizione'),(7638,5828,'en','name','Research and Productivity Council'),(7639,5829,'en','name','Unity Health System'),(7640,5830,'en','name','Worthing Hospital'),(7641,5831,'en','name','Tauranga Hospital'),(7642,5832,'no_lang_code','name','AccelLab (Canada)'),(7643,5833,'en','name','Mission to the Street for Christ'),(7644,5834,'no_lang_code','name','Sierra Nevada Corporation (United States)'),(7645,5835,'no_lang_code','name','Opmedic Group (Canada)'),(7646,5836,'en','name','Ome Municipal General Hospital'),(7647,5836,'ja','name','青梅市立総合病院'),(7648,5837,'en','name','College of St. Scholastica'),(7649,5838,'en','name','Wyckoff Heights Medical Center'),(7650,5839,'en','name','Southern California Coastal Water Research Project'),(7651,5840,'ja','name','キッコーマン株式会社'),(7652,5840,'no_lang_code','name','Kikkoman (Japan)'),(7653,5841,'en','name','Harper Adams University'),(7654,5842,'no_lang_code','name','Abbott (Canada)'),(7655,5843,'en','name','State Research Center of Virology and Biotechnology VECTOR'),(7656,5843,'ru','name','Федеральное бюджетное учреждение науки Государственный научный центр вирусологии и биотехнологии Вектор'),(7657,5844,'no_lang_code','name','Advanced Photonic Crystals (United States)'),(7658,5845,'no_lang_code','name','Clancy Docwra (United Kingdom)'),(7659,5846,'no_lang_code','name','Premiere Global Services (United States)'),(7660,5847,'en','name','St. Patrick Hospital'),(7661,5848,'no_lang_code','name','MetaMedia Training International (United States)'),(7662,5849,'no_lang_code','name','Kryton International (Canada)'),(7663,5850,'no_lang_code','name','SWITCH Materials (Canada)'),(7664,5851,'no_lang_code','name','Avensys (Canada)'),(7665,5852,'nl','name','Onze Lieve Vrouwziekenhuis Hospital'),(7666,5853,'en','name','Capital Institute of Pediatrics'),(7667,5853,'zh','name','首都儿科研究所'),(7668,5854,'en','name','Cope Community Services'),(7669,5855,'no_lang_code','name','Gratings Incorporated (United States)'),(7670,5856,'no_lang_code','name','Molecular LogiX (United States)'),(7671,5857,'no_lang_code','name','Biotest (Germany)'),(7672,5858,'en','name','Arapahoe Community College'),(7673,5859,'no_lang_code','name','Alacron (United States)'),(7674,5860,'en','name','College of DuPage'),(7675,5861,'en','name','City College'),(7676,5861,'fr','name','La Cité Collégiale'),(7677,5862,'en','name','International Craniofacial Institute'),(7678,5863,'en','name','High Institute for Education and Research in Transfusion Medicine'),(7679,5863,'fa','name','موسسه عالی آموزشی و پژوهشی طب انتقال خون'),(7680,5864,'en','name','Hopkins Architects'),(7681,5864,'fr','name','Hopkins Architectes'),(7682,5865,'en','name','Deborah Heart and Lung Center'),(7683,5866,'no_lang_code','name','Conestoga Meat Packers (Canada)'),(7684,5867,'no_lang_code','name','Syandus (United States)'),(7685,5868,'no_lang_code','name','Viocare (United States)'),(7686,5869,'en','name','Tianjin Economic-Technological Development Area'),(7687,5869,'zh','name','天津经济技术开发区'),(7688,5870,'en','name','Toronto Public Health'),(7689,5871,'no_lang_code','name','Dynamis Pharmaceuticals (United States)'),(7690,5872,'no_lang_code','name','Inverness Research (United States)'),(7691,5873,'en','name','Society for Canadian Women in Science and Technology'),(7692,5874,'en','name','Danish Institute against Torture'),(7693,5875,'de','name','Klinikum Nürnberg'),(7694,5875,'en','name','Nuremberg Hospital'),(7695,5876,'no_lang_code','name','Halma Water Management (United Kingdom)'),(7696,5877,'en','name','York General Hospital'),(7697,5878,'en','name','Memphis Fire Services'),(7698,5879,'en','name','Farmingdale State College'),(7699,5880,'no_lang_code','name','Apotex Pharmachem (Canada)'),(7700,5881,'no_lang_code','name','Aurora Flight Sciences (United States)'),(7701,5882,'no_lang_code','name','Industrial Tomography Systems (United Kingdom)'),(7702,5883,'en','name','Positive Living Society of British Columbia'),(7703,5884,'no_lang_code','name','Cryomagnetics (United States)'),(7704,5885,'en','name','Nine Circles Community Health Centre'),(7705,5886,'no_lang_code','name','MASSolutions (Canada)'),(7706,5887,'en','name','National Institute of Epidemiology'),(7707,5888,'no_lang_code','name','Prediction Sciences (United States)'),(7708,5889,'no_lang_code','name','Aptagen (United States)'),(7709,5890,'no_lang_code','name','MMTC (United States)'),(7710,5891,'no_lang_code','name','BIT-TECH (United States)'),(7711,5892,'en','name','Australian Academy of the Humanities'),(7712,5893,'it','name','Policlinico Umberto I'),(7713,5894,'en','name','American Planning Association'),(7714,5895,'no_lang_code','name','PortaScience (United States)'),(7715,5896,'en','name','UPMC Health System'),(7716,5897,'en','name','Urology Associates'),(7717,5898,'en','name','National Cancer Institute of Thailand'),(7718,5898,'th','name','สถาบันมะเร็งแห่งชาติ'),(7719,5899,'en','name','American College of Healthcare Executives'),(7720,5900,'fr','name','Cégep de la Gaspésie et des Îles'),(7721,5901,'en','name','International Prevention Research Institute'),(7722,5902,'en','name','Carlow University'),(7723,5903,'en','name','Kentucky Science Center'),(7724,5904,'no_lang_code','name','Geospace Research (United States)'),(7725,5905,'en','name','New York Law School'),(7726,5906,'en','name','American Legacy Foundation'),(7727,5907,'it','name','IRCCS Policlinico San Donato'),(7728,5908,'en','name','Terasaki Foundation'),(7729,5909,'en','name','EMO GVM Centro Cuore Columbus'),(7730,5910,'en','name','AgResearch'),(7731,5911,'no_lang_code','name','OmegaChem (Canada)'),(7732,5912,'no_lang_code','name','Noble (United States)'),(7733,5913,'en','name','Ferrum College'),(7734,5914,'en','name','National Institute of Biological Resources'),(7735,5915,'no_lang_code','name','Cerner (United States)'),(7736,5916,'no_lang_code','name','JWK Corporation (United States)'),(7737,5917,'no_lang_code','name','Gradient Lens Corporation (United States)'),(7738,5918,'en','name','Neighborhood House'),(7739,5919,'no_lang_code','name','Architecture Technology Corporation (United States)'),(7740,5920,'en','name','Zabok General Hospital'),(7741,5920,'hr','name','Opća bolnica Zabok'),(7742,5921,'en','name','G. B. Bietti Foundation'),(7743,5921,'it','name','Fondazione G.B. Bietti'),(7744,5922,'en','name','Bethel College'),(7745,5923,'en','name','St Vincent\'s Health'),(7746,5924,'en','name','Santa Fe College'),(7747,5925,'no_lang_code','name','Seacoast Science (United States)'),(7748,5926,'en','name','Cegep of Saint Jérôme'),(7749,5926,'fr','name','Cegep de Saint Jerome, Cégep de saint-jérôme'),(7750,5927,'en','name','LAM Foundation'),(7751,5928,'en','name','Oglala Lakota College'),(7752,5929,'no_lang_code','name','Energy Science Laboratories (United States)'),(7753,5930,'en','name','Tokyo Dental College Ichikawa General Hospital'),(7754,5930,'ja','name','東京歯科大学 市川総合病院'),(7755,5931,'en','name','Vaccine Research Institute of San Diego'),(7756,5932,'en','name','Biomedical Research and Training Institute'),(7757,5933,'en','name','WestCare Foundation'),(7758,5934,'no_lang_code','name','Air Products (United Kingdom)'),(7759,5935,'fr','name','Institut National d\'Oncologie'),(7760,5936,'en','name','Worcester Memorial Hospital'),(7761,5937,'en','name','St. Joseph Hospital'),(7762,5938,'no_lang_code','name','Orolia (United States)'),(7763,5939,'en','name','Montgomery County Community College'),(7764,5940,'en','name','Russian Research Center for Molecular Diagnostics and Therapy'),(7765,5941,'ar','name','كلية دبي للصيدلة'),(7766,5941,'en','name','Dubai Pharmacy College'),(7767,5942,'no_lang_code','name','Synopsys (United States)'),(7768,5943,'no_lang_code','name','Cel-Sci (United States)'),(7769,5944,'en','name','American College of Physician Executives'),(7770,5945,'no_lang_code','name','Surgical Specialties (Canada)'),(7771,5946,'en','name','Council on Competitiveness'),(7772,5947,'no_lang_code','name','Plexon (United States)'),(7773,5948,'en','name','Wisconsin Heart Hospital'),(7774,5949,'en','name','Northwest Community Hospital'),(7775,5950,'no_lang_code','name','Perrigo (United States)'),(7776,5951,'en','name','American Association of Poison Control Centers'),(7777,5952,'it','name','Istituto Scientifico Romagnolo per lo Studio e la Cura dei Tumori'),(7778,5953,'no_lang_code','name','Baxter (Austria)'),(7779,5954,'en','name','Yokohama City Seibu Hospital'),(7780,5955,'en','name','Anixter Center'),(7781,5956,'en','name','National Institute for Food and Nutrition Science'),(7782,5957,'no_lang_code','name','TRS Technologies (United States)'),(7783,5958,'en','name','WAMC Northeast Public Radio'),(7784,5959,'en','name','Zhejiang Cancer Hospital'),(7785,5959,'zh','name','浙江省肿瘤医院'),(7786,5960,'no_lang_code','name','Iomai (United States)'),(7787,5961,'en','name','Foundation for the Fight against Pediatric Neurological Disease'),(7788,5961,'es','name','Fundación para la Lucha contra las Enfermedades Neurológicas de la Infancia'),(7789,5962,'en','name','Wellmont Health Systems'),(7790,5963,'en','name','Henan Provincial Center for Disease Control and Prevention'),(7791,5963,'zh','name','河南省疾病预防控制中心'),(7792,5964,'el','name','Κλινική Άγιος Λουκάς'),(7793,5964,'en','name','St. Luke\'s Hospital'),(7794,5965,'en','name','Midwest Cardiovascular Research Foundation'),(7795,5966,'en','name','United States Department of Housing and Urban Development'),(7796,5966,'es','name','Departamento de Vivienda y Desarrollo Urbano de los Estados Unidos'),(7797,5966,'fr','name','Département du logement et du développement urbain des États-unis'),(7798,5967,'ja','name','アサヒビール株式会社'),(7799,5967,'no_lang_code','name','Asahi Breweries (Japan)'),(7800,5968,'es','name','Instituto de Estudios Avanzados'),(7801,5969,'no_lang_code','name','Lucerna (United States)'),(7802,5970,'de','name','Klinik Hirslanden'),(7803,5971,'en','name','St. Louis VA Medical Center'),(7804,5972,'no_lang_code','name','Environment and Health Group (United States)'),(7805,5973,'en','name','Institute of Particle Physics'),(7806,5974,'no_lang_code','name','PerkinElmer (United Kingdom)'),(7807,5975,'en','name','Office of Disease Prevention and Health Promotion'),(7808,5976,'no_lang_code','name','Lend Lease (United Kingdom)'),(7809,5977,'en','name','National Hospital Abuja'),(7810,5978,'no_lang_code','name','LAC Group (United States)'),(7811,5979,'no_lang_code','name','Chelsea Technologies (United Kingdom)'),(7812,5980,'ja','name','堺市立総合医療センター'),(7813,5980,'no_lang_code','name','Sakai Municipal Hospital'),(7814,5981,'en','name','American Society of Nephrology'),(7815,5982,'no_lang_code','name','Gradient (United States)'),(7816,5983,'en','name','Sarah Cannon'),(7817,5984,'en','name','Loma Linda Veterans Association for Research and Education'),(7818,5985,'en','name','Victoria Hospital'),(7819,5986,'no_lang_code','name','Systems Control (United States)'),(7820,5987,'en','name','Genesis Laboratories'),(7821,5988,'no_lang_code','name','Compuware (United States)'),(7822,5989,'no_lang_code','name','TiNi Alloy (United States)'),(7823,5990,'fr','name','Fédération des cégeps'),(7824,5991,'en','name','Veterinary and Agrochemical Research Centre'),(7825,5991,'fr','name','Centre d\'Étude et de Recherches Vétérinaires et Agrochimiques'),(7826,5991,'nl','name','Centrum voor Onderzoek in Diergeneeskunde en Agrochemie'),(7827,5992,'da','name','Børneklinikken Randers'),(7828,5993,'en','name','Cleveland Clinic Florida'),(7829,5994,'no_lang_code','name','ICF International (United States)'),(7830,5995,'en','name','Second Affiliated Hospital & Yuying Children\'s Hospital of Wenzhou Medical University'),(7831,5995,'zh','name','温州医科大学附属第二医院'),(7832,5996,'en','name','Rajiv Gandhi University of Health Sciences'),(7833,5996,'hi','name','राजीव गांधी स्वास्थ्य विज्ञान विश्वविद्यालय'),(7834,5997,'en','name','St Peter\'s Hospital'),(7835,5998,'en','name','Korea Institute of Toxicology'),(7836,5998,'ko','name','안전성평가연구소'),(7837,5999,'en','name','National Institute for Health and Care Excellence'),(7838,6000,'en','name','Western State Hospital'),(7839,6001,'en','name','North Dakota State College of Science'),(7840,6002,'en','name','Vale of Leven District General Hospital'),(7841,6003,'no_lang_code','name','Upsight (Canada)'),(7842,6004,'en','name','Atlanta Allergy and Asthma Clinic'),(7843,6005,'en','name','Niagara College'),(7844,6006,'en','name','American Association of Physicists in Medicine'),(7845,6007,'en','name','Chippewa Valley Technical College'),(7846,6008,'en','name','Alabama Southern Community College'),(7847,6009,'no_lang_code','name','Orcca Technology (United States)'),(7848,6010,'fr','name','Centre Hospitalier Intercommunal de Poissy'),(7849,6011,'en','name','Nordic Institute of Dental Materials'),(7850,6012,'en','name','Hong Kong Jockey Club'),(7851,6012,'zh','name','香港賽馬會'),(7852,6013,'en','name','Forensic Sciences Department'),(7853,6014,'fr','name','Cegep de Sept Iles, Cégep de sept-Îles'),(7854,6015,'no_lang_code','name','BioSci Research Canada (Canada)'),(7855,6016,'no_lang_code','name','Robotiq (Canada)'),(7856,6017,'no_lang_code','name','Tertl Studos (United States)'),(7857,6018,'en','name','Gamalei Institute of Epidemiology and Microbiology'),(7858,6018,'ru','name','Национальный исследовательский центр эпидемиологии и микробиологии имени почётного академика Н. Ф. Гамалеи'),(7859,6019,'no_lang_code','name','EnviroSim (Canada)'),(7860,6020,'no_lang_code','name','Ogikubo Hospital'),(7861,6021,'no_lang_code','name','Behringwerke (Germany)'),(7862,6022,'en','name','Vijayanagara Institute of Medical Sciences'),(7863,6022,'kn','name','ವಿಜಯನಗರ ವೈದ್ಯಕೀಯ ವಿಜ್ಞಾನ ಸಂಸ್ಥೆ'),(7864,6023,'en','name','Papageorgiou General Hospital'),(7865,6024,'en','name','Asian and Pacific Islander American Health Forum'),(7866,6025,'en','name','St. Margaret\'s Hospital for Women'),(7867,6026,'no_lang_code','name','Futures Group (United States)'),(7868,6027,'de','name','Apherese Forschungsinstitut'),(7869,6028,'no_lang_code','name','BioReliance (United States)'),(7870,6029,'ja','name','佐々木研究所'),(7871,6029,'no_lang_code','name','Sasaki Institute'),(7872,6030,'es','name','Complejo Hospitalario de Pontevedra'),(7873,6031,'en','name','Methodist Healthcare'),(7874,6032,'en','name','Waterbury Hospital'),(7875,6033,'en','name','Institute of Biomedical Problems'),(7876,6033,'ru','name','Федеральное государственное бюджетное учреждение науки Государственный научный центр Российской Федерации - Институт медико-биологических проблем Российской академии наук'),(7877,6034,'no_lang_code','name','Centre for Technology Research & Innovation (Cyprus)'),(7878,6035,'no_lang_code','name','MandalMed (United States)'),(7879,6036,'no_lang_code','name','Ventria Bioscience (United States)'),(7880,6037,'no_lang_code','name','Vi Technology (United States)'),(7881,6038,'en','name','Franciscan Hammond Clinic'),(7882,6039,'en','name','Society of British Water and Wastewater Industries'),(7883,6040,'no_lang_code','name','TopoGEN (United States)'),(7884,6041,'no_lang_code','name','Axcelon Biopolymers (Canada)'),(7885,6042,'en','name','Amity Foundation'),(7886,6043,'en','name','Morton Arboretum'),(7887,6044,'de','name','Tiroler Krebsforschungsinstitut'),(7888,6044,'en','name','Tyrolean Cancer Research Institute'),(7889,6045,'no_lang_code','name','Quasars (United States)'),(7890,6046,'no_lang_code','name','PENTAX Medical Company (United States)'),(7891,6047,'en','name','North Riding Infirmary'),(7892,6048,'en','name','Western Technical College'),(7893,6049,'en','name','Genomics Institute of the Novartis Research Foundation'),(7894,6050,'en','name','Family Research Institute'),(7895,6051,'en','name','Nottingham City Council'),(7896,6052,'no_lang_code','name','Servelec Technologies (United Kingdom)'),(7897,6053,'no_lang_code','name','Pasadero (United States)'),(7898,6054,'en','name','Royal Dutch Kentalis'),(7899,6054,'nl','name','Koninklijke Kentalis'),(7900,6055,'en','name','International Institute for Population Sciences'),(7901,6056,'en','name','Department of Alcohol, Drug, and Mental Health Services'),(7902,6057,'en','name','Zuoying Armed Forces General Hospital'),(7903,6057,'zh','name','國軍高雄總醫院'),(7904,6058,'en','name','Ruby Hall Clinic'),(7905,6059,'es','name','Instituto Nacional de Enfermedades Respiratorias, Instituto Nacional de Enfermedades Respiratorias Ismael Cosío Villegas'),(7906,6060,'it','name','Ospedale Humanitas Gradenigo'),(7907,6061,'en','name','National Institute for Research in Reproductive Health'),(7908,6061,'hi','name','राष्ट्रीय प्रजनन स्वास्थ्य अनुसंधान संस्थान'),(7909,6062,'no_lang_code','name','NXP (United Kingdom)'),(7910,6063,'en','name','D.I. Ivanovsky Institute of Virology Russian Academy of Medical Sciences'),(7911,6063,'ru','name','НИИ вирусологии имени Д. И. Ивановского РАМН'),(7912,6064,'no_lang_code','name','Vega Wave Systems (United States)'),(7913,6065,'no_lang_code','name','LI-COR Biosciences (United States)'),(7914,6066,'no_lang_code','name','Aker Arctic (Canada)'),(7915,6067,'no_lang_code','name','SciAps (United States)'),(7916,6068,'he','name','קומפיוג\'ן'),(7917,6068,'no_lang_code','name','Compugen (Israel)'),(7918,6069,'en','name','Ornsköldsvik Hospital'),(7919,6069,'sv','name','Örnsköldsviks sjukhus'),(7920,6070,'en','name','TiFN'),(7921,6071,'no_lang_code','name','CW Optics (United States)'),(7922,6072,'en','name','Montana Council of Teachers of Mathematics'),(7923,6073,'en','name','Australian Academy of Science'),(7924,6074,'de','name','Isar-Amper-Klinikum München-Ost'),(7925,6075,'en','name','National Institute of Cholera and Enteric Diseases'),(7926,6076,'en','name','Earlham Institute'),(7927,6077,'en','name','Health Media Lab'),(7928,6078,'en','name','Denver VA Medical Center'),(7929,6079,'pt','name','Escola Superior de Tecnologia da Saúde de Coimbra'),(7930,6080,'en','name','Wesley Hospital'),(7931,6081,'en','name','Human BioMolecular Research Institute'),(7932,6082,'no_lang_code','name','Advanced Computer System (Italy)'),(7933,6083,'no_lang_code','name','Tuen Mun Hospital'),(7934,6083,'zh','name','屯門醫院'),(7935,6084,'en','name','Lexington Richland Alcohol And Drug Abuse Council'),(7936,6085,'no_lang_code','name','General Motors (Germany)'),(7937,6086,'en','name','Massachusetts Bay Community College'),(7938,6087,'en','name','Missouri Bone and Joint Center'),(7939,6088,'en','name','Matsunami General Hospital'),(7940,6088,'ja','name','松波病院'),(7941,6089,'fr','name','Collège d\'Alma'),(7942,6090,'it','name','Ospedale di San Donà di Piave'),(7943,6091,'no_lang_code','name','General Electric (Sweden)'),(7944,6092,'en','name','Access Community Health Network'),(7945,6093,'de','name','Max-Planck-Institut für Stoffwechselforschung'),(7946,6093,'en','name','Max Planck Institute for Metabolism Research'),(7947,6094,'no_lang_code','name','Cerestech (Canada)'),(7948,6095,'en','name','Southern Governors Association'),(7949,6096,'en','name','Guangzhou Blood Center'),(7950,6097,'no_lang_code','name','Ionwerks (United States)'),(7951,6098,'no_lang_code','name','New York Audio Productions (United States)'),(7952,6099,'no_lang_code','name','Quest Clinical Research (United States)'),(7953,6100,'en','name','Utah Valley Regional Medical Center'),(7954,6101,'en','name','Central Potato Research Institute'),(7955,6102,'no_lang_code','name','Jazz Pharmaceuticals (United States)'),(7956,6103,'no_lang_code','name','Altana (Germany)'),(7957,6104,'en','name','Uwajima City Hospital'),(7958,6104,'ja','name','宇和島市病院'),(7959,6105,'en','name','Astronomical Society of the Pacific'),(7960,6106,'en','name','Science East Association'),(7961,6107,'no_lang_code','name','Nesher Technologies (United States)'),(7962,6108,'no_lang_code','name','Siemens (Portugal)'),(7963,6109,'no_lang_code','name','Sri Gokulam Hospital'),(7964,6110,'en','name','Institute of Basic Biological Problems'),(7965,6110,'ru','name','Федеральное государственное бюджетное учреждение науки Институт фундаментальных проблем биологии РАН'),(7966,6111,'no_lang_code','name','LNKChemsolutions'),(7967,6112,'en','name','Central Electricity Generating Board'),(7968,6113,'no_lang_code','name','Cytobank (United States)'),(7969,6114,'en','name','The Langton Grammar School for Boys'),(7970,6115,'en','name','Latvian Institute of Organic Synthesis'),(7971,6115,'lv','name','Latvijas Organiskās Sintēzes Institūts'),(7972,6116,'en','name','National Perinatal Information Center'),(7973,6117,'en','name','Council on Undergraduate Research'),(7974,6118,'it','name','Semeion Centro Ricerche di Scienze della Comunicazione'),(7975,6119,'no_lang_code','name','Reaction Biology Corporation (United States)'),(7976,6120,'it','name','Ospedale A. Perrino'),(7977,6121,'en','name','Canadian AIDS Society'),(7978,6121,'fr','name','Société Canadienne du Sida'),(7979,6122,'en','name','Centre for Process Innovation'),(7980,6123,'en','name','Cook Inlet Tribal Council'),(7981,6124,'es','name','Centro Rosarino de Estudios Perinatales'),(7982,6125,'en','name','Institute for Healthcare Improvement'),(7983,6126,'en','name','United States Army Aeromedical Research Lab'),(7984,6127,'de','name','v. Bodelschwinghsche Stiftungen Bethel'),(7985,6127,'en','name','v. Bodelschwing Foundation Bethel'),(7986,6128,'no_lang_code','name','Sanofi (Canada)'),(7987,6129,'no_lang_code','name','ImmuNext (United States)'),(7988,6130,'no_lang_code','name','Sparos (Portugal)'),(7989,6131,'en','name','Jean Hailes'),(7990,6132,'en','name','Japan Biological Informatics Consortium'),(7991,6132,'ja','name','般社団法人バイオ産業情報化コンソーシアム'),(7992,6133,'no_lang_code','name','CustomKYnetics (United States)'),(7993,6134,'no_lang_code','name','Alternative Futures Associates'),(7994,6135,'en','name','Together'),(7995,6136,'en','name','APT Foundation'),(7996,6137,'en','name','Hull and East Yorkshire Hospitals NHS Trust'),(7997,6138,'en','name','Greater Manchester STEM Centre'),(7998,6139,'en','name','National Institute of Clinical Neurosciences'),(7999,6139,'hu','name','Országos Idegsebészeti Tudományos Intézet'),(8000,6140,'en','name','Greenfield Community College'),(8001,6141,'en','name','Visions of Science Network for Learning'),(8002,6142,'fr','name','Institut de Recherche en Opthalmologie'),(8003,6143,'en','name','Shonan Institute of Technology'),(8004,6143,'ja','name','湘南工科大学'),(8005,6144,'de','name','Max-Planck-Institut für Physik Komplexer Systeme'),(8006,6144,'en','name','Max Planck Institute for the Physics of Complex Systems'),(8007,6145,'en','name','Erskine College'),(8008,6146,'en','name','National Institute for Biotechnology and Genetic Engineering'),(8009,6147,'no_lang_code','name','GNS Healthcare (United States)'),(8010,6148,'en','name','Waterwise'),(8011,6149,'ja','name','徳島県立中央病院'),(8012,6149,'no_lang_code','name','Tokushima Prefectural Central Hospital'),(8013,6150,'en','name','Wireless Innovation Forum'),(8014,6151,'de','name','GP Forschungsgruppe, Instituts für Grundlagen und Programmforschung'),(8015,6152,'no_lang_code','name','Photodigm (United States)'),(8016,6153,'no_lang_code','name','Global Relay (Canada)'),(8017,6154,'en','name','Park Plaza Hospital'),(8018,6155,'no_lang_code','name','InstaRecon (United States)'),(8019,6156,'no_lang_code','name','Autoimmune Technologies (United States)'),(8020,6157,'en','name','Environmental Law Institute'),(8021,6158,'no_lang_code','name','Dynavax Technologies (United States)'),(8022,6159,'en','name','University of Health Sciences and Pharmacy'),(8023,6160,'en','name','Central Oregon Community College'),(8024,6161,'no_lang_code','name','Rigaku (United Kingdom)'),(8025,6162,'en','name','Indian Agricultural Research Institute'),(8026,6162,'hi','name','भारतीय कृषि अनुसंधान संस्थान'),(8027,6162,'ta','name','இந்திய வேளாண் ஆராய்ச்சிக் கழகம்'),(8028,6163,'no_lang_code','name','Acumen (United States)'),(8029,6164,'no_lang_code','name','Maine Molecular Quality Controls (United States)'),(8030,6165,'it','name','Nuovo Ospedale San Giovanni di Dio'),(8031,6166,'en','name','Genetics and IVF Institute'),(8032,6167,'no_lang_code','name','OcuMetrics (United States)'),(8033,6168,'no_lang_code','name','Kent Displays (United States)'),(8034,6169,'en','name','Proteogenomics Research Institute for Systems Medicine'),(8035,6170,'es','name','Instituto de Neurologia Y Neurocirugia'),(8036,6171,'en','name','Prince Albert Grand Council'),(8037,6172,'no_lang_code','name','Teva Pharmaceuticals (Canada)'),(8038,6173,'en','name','National Institute for Pharmaceutical Research and Development'),(8039,6174,'fr','name','Institut pour la Recherche sur le Cancer de Lille'),(8040,6175,'de','name','Max-Planck-Institut für Chemische Physik Fester Stoffe'),(8041,6175,'en','name','Max Planck Institute for Chemical Physics of Solids'),(8042,6176,'no_lang_code','name','ImQuest BioSciences (United States)'),(8043,6177,'en','name','Fortis Escorts Heart Institute'),(8044,6178,'en','name','American Indian Science and Engineering Society'),(8045,6179,'no_lang_code','name','Robin Medical (United States)'),(8046,6180,'en','name','Marie Selby Botanical Gardens'),(8047,6181,'no_lang_code','name','Ingegneria dei Sistemi (United Kingdom)'),(8048,6182,'no_lang_code','name','DiscoveryBioMed (United States)'),(8049,6183,'en','name','Bradford Royal Infirmary'),(8050,6184,'en','name','Whittington Hospital'),(8051,6185,'no_lang_code','name','Institute for Learning Innovation (United States)'),(8052,6186,'en','name','Morris Brown College'),(8053,6187,'cy','name','Ysbyty Cyffredinol Glangwili'),(8054,6187,'en','name','Glangwili General Hospital'),(8055,6188,'en','name','Palmerston North Hospital'),(8056,6189,'de','name','Stiftung Patientensicherheit Schweiz'),(8057,6189,'fr','name','Fondation pour la Sécurité des Patients'),(8058,6190,'en','name','Shanghai Blood Center'),(8059,6191,'en','name','Wesley Guild Hospital'),(8060,6192,'ja','name','小樽市立病院'),(8061,6192,'no_lang_code','name','Otaru Municipal Hospital'),(8062,6193,'en','name','Samaritan Center'),(8063,6194,'en','name','Maternity and Children\'s Hospital'),(8064,6195,'no_lang_code','name','Technology For Magnetic Resonance (United States)'),(8065,6196,'en','name','International Institute of Anthropology'),(8066,6197,'en','name','Worcestershire Royal Hospital'),(8067,6198,'en','name','Fernández-Vega Ophthalmological Institute'),(8068,6199,'en','name','Montrose Center'),(8069,6200,'en','name','Paul Smith\'s College'),(8070,6201,'no_lang_code','name','NuvoGen Research (United States)'),(8071,6202,'fr','name','Centre Ophtalmologique d\'Imagerie et de Laser'),(8072,6203,'no_lang_code','name','Dianon (United States)'),(8073,6204,'no_lang_code','name','Condax (United States)'),(8074,6205,'en','name','Institute of Bioorganic Chemistry'),(8075,6205,'ru','name','Федеральное государственное бюджетное учреждение науки Институт биоорганической химии им. академиков М.М. Шемякина и Ю.А. Овчинникова Российской академии наук'),(8076,6206,'ja','name','山口県済生会下関総合病院'),(8077,6206,'no_lang_code','name','Saiseikai Shimonoseki General Hospital'),(8078,6207,'no_lang_code','name','Hauser (United States)'),(8079,6208,'no_lang_code','name','Advanced Lightweight Engineering (Netherlands)'),(8080,6209,'pt','name','Instituto Lauro de Souza Lima'),(8081,6210,'en','name','Pasadena City College'),(8082,6211,'en','name','City Colleges of Chicago'),(8083,6211,'es','name','Colegios Comunitarios de Chicago'),(8084,6212,'no_lang_code','name','Alethia Biotherapeutics (Canada)'),(8085,6213,'en','name','Roessingh Research and Development'),(8086,6214,'no_lang_code','name','International Rectifier (United Kingdom)'),(8087,6215,'no_lang_code','name','Indium Corporation (United States)'),(8088,6216,'no_lang_code','name','MicroLink Devices (United States)'),(8089,6217,'it','name','Ospedale Civile di Vittorio Veneto'),(8090,6218,'en','name','College of Family Physicians of Canada'),(8091,6218,'fr','name','Le Collège des Médecins de Famille du Canada'),(8092,6219,'en','name','Talladega College'),(8093,6220,'en','name','Combustion Institute'),(8094,6221,'no_lang_code','name','Cell Gate (United States)'),(8095,6222,'it','name','Istituto di Biomedicina e di Immunologia Molecolare Alberto Monroy'),(8096,6223,'en','name','Institute of Organic Chemistry'),(8097,6223,'pl','name','Instytut Chemii Organicznej PAN'),(8098,6224,'fr','name','Hôpital de l\'Antiquaille'),(8099,6225,'no_lang_code','name','Mapp Biopharmaceutical (United States)'),(8100,6226,'en','name','Baylor College of Medicine Children’s Foundation'),(8101,6227,'en','name','Indian Institute of Toxicology Research'),(8102,6227,'hi','name','भारतीय विषविज्ञान अनुसंधान संस्थान'),(8103,6228,'no_lang_code','name','SRK Healthcare (United States)'),(8104,6229,'en','name','American Ceramic Society'),(8105,6230,'it','name','Fondazione Salvatore Maugeri'),(8106,6231,'en','name','Northern New Mexico College'),(8107,6232,'en','name','Oregon Clinic'),(8108,6233,'no_lang_code','name','LungLife AI (United States)'),(8109,6234,'no_lang_code','name','Sirnaomics (United States)'),(8110,6235,'no_lang_code','name','Kardium (Canada)'),(8111,6236,'en','name','Methodist Richardson Medical Center'),(8112,6237,'no_lang_code','name','Analogue Theatre (United Kingdom)'),(8113,6238,'en','name','Cystic Fibrosis Research Foundation'),(8114,6239,'no_lang_code','name','Sensei Biotherapeutics (United States)'),(8115,6240,'en','name','American Association of Variable Star Observers'),(8116,6241,'fr','name','Centre hospitalier de Rouffach'),(8117,6242,'en','name','Special Health Resources for Texas'),(8118,6243,'no_lang_code','name','Indian Drugs and Pharmaceuticals Limited'),(8119,6244,'no_lang_code','name','Gateway Community Services (United States)'),(8120,6245,'en','name','Stone Child College'),(8121,6246,'en','name','Educational Service District 112'),(8122,6247,'en','name','H2O 4 All'),(8123,6248,'no_lang_code','name','Agennix (United States)'),(8124,6249,'en','name','National Maritime Museum'),(8125,6250,'en','name','Riekes Center for Human Enhancement'),(8126,6251,'en','name','Ministry of Food and Drug Safety'),(8127,6252,'en','name','National Institute of Metrology Quality and Technology'),(8128,6252,'pt','name','Instituto Nacional de Metrologia, Qualidade e Tecnologia'),(8129,6253,'no_lang_code','name','MicroOptical Engineering (United States)'),(8130,6254,'de','name','Max-Planck-Institut für molekulare Pflanzenphysiologie'),(8131,6254,'en','name','Max Planck Institute of Molecular Plant Physiology'),(8132,6255,'no_lang_code','name','BioChem Technology (United States)'),(8133,6256,'no_lang_code','name','Synthecon (United States)'),(8134,6257,'no_lang_code','name','Ribonomics (United States)'),(8135,6258,'en','name','Confederation of European Forest Owners'),(8136,6258,'fr','name','Confédération Européenne des Propriétaires Forestiers'),(8137,6259,'no_lang_code','name','DSM (Switzerland)'),(8138,6260,'en','name','Chicago Institute for Psychoanalysis'),(8139,6261,'es','name','Fundación Instituto Valenciano de Oncología'),(8140,6262,'en','name','Sacred Space Foundation'),(8141,6263,'en','name','St. Joseph\'s Hospital'),(8142,6264,'pt','name','Instituto de Botânica'),(8143,6265,'no_lang_code','name','Cytel (United States)'),(8144,6266,'no_lang_code','name','Earth Images Foundation (United States)'),(8145,6267,'en','name','National Hemophilia Foundation'),(8146,6268,'en','name','Converse College'),(8147,6269,'no_lang_code','name','Carter Printing Company (United States)'),(8148,6270,'no_lang_code','name','Trudell Medical International (Canada)'),(8149,6271,'no_lang_code','name','Transfusion and Transplantation Technologies (United States)'),(8150,6272,'en','name','International Technology and Engineering Educators Association'),(8151,6273,'en','name','Vanha Vaasa hospital'),(8152,6273,'fi','name','Vanhan Vaasan Sairaala'),(8153,6274,'en','name','Northside Hospital'),(8154,6275,'en','name','Institute of Minerals and Materials Technology'),(8155,6276,'en','name','Washington Department of Social and Health Services'),(8156,6277,'en','name','Center for Image Processing in Education'),(8157,6278,'it','name','Consorzio Catania Ricerche'),(8158,6279,'en','name','Federal Emergency Management Agency'),(8159,6279,'es','name','Agencia Federal para el Manejo de Emergencias'),(8160,6280,'no_lang_code','name','Cochlear (United States)'),(8161,6281,'pt','name','Centro de Biotecnologia Agrícola e Agro Alimentar do Alentejo'),(8162,6282,'no_lang_code','name','South Carolina ETV (United States)'),(8163,6283,'en','name','Latvian Biomedical Research and Study Centre'),(8164,6283,'lv','name','Latvijas Biomedicīnas Pētījumu un Studiju Centrs'),(8165,6284,'no_lang_code','name','Agave BioSystems (United States)'),(8166,6285,'no_lang_code','name','Center of Molecular Immunology (Cuba)'),(8167,6286,'no_lang_code','name','National One Call (United Kingdom)'),(8168,6287,'no_lang_code','name','Kapteyn Murnane Laboratories'),(8169,6288,'en','name','North American Association of Central Cancer Registries'),(8170,6289,'hu','name','Péterfy Sándor Utcai Kórház-Rendelőintézet és Baleseti Központ'),(8171,6290,'fr','name','Association pour le Développement de la Recherche et de l\'Innovation du Québec'),(8172,6291,'no_lang_code','name','Second Foundation (United States)'),(8173,6292,'en','name','El Paso Community College'),(8174,6293,'fr','name','Hôpital d\'Enfants'),(8175,6294,'no_lang_code','name','Advanced Genetic Systems (United States)'),(8176,6295,'en','name','Energy Saving Trust'),(8177,6296,'en','name','Research Institute of Ophthalmology'),(8178,6297,'no_lang_code','name','Tata Motors (United Kingdom)'),(8179,6298,'no_lang_code','name','Meridian Instrument (United States)'),(8180,6299,'no_lang_code','name','Medical Decision Modeling (United States)'),(8181,6300,'en','name','St. Mark\'s Hospital'),(8182,6301,'it','name','MultiMedica'),(8183,6302,'no_lang_code','name','Touch of Life Technologies (United States)'),(8184,6303,'no_lang_code','name','FMC (United States)'),(8185,6304,'en','name','Zeynep Kamil Hospital'),(8186,6304,'tr','name','Zeynep Kamil Kadın ve Çocuk Hastalıkları Eğitim Ve Araştırma Hastanesi'),(8187,6305,'en','name','Franciscan Health'),(8188,6306,'en','name','San Antonio College'),(8189,6307,'no_lang_code','name','Signum Biosciences (United States)'),(8190,6308,'en','name','Northland College'),(8191,6309,'en','name','National Azulejo Museum'),(8192,6309,'pt','name','Museu Nacional do Azulejo'),(8193,6310,'no_lang_code','name','EKOS Corporation'),(8194,6311,'no_lang_code','name','Regis Technologies (United States)'),(8195,6312,'en','name','Catawba College'),(8196,6313,'en','name','Tygerberg Hospital'),(8197,6314,'en','name','Institute of Primate Research'),(8198,6315,'en','name','Northern Illinois Council on Alcohol and Substance Abuse'),(8199,6316,'en','name','Volunteers of America Los Angeles'),(8200,6317,'en','name','Children\'s Tumor Foundation'),(8201,6318,'no_lang_code','name','Meticube (Portugal)'),(8202,6319,'en','name','Westminster College - Pennsylvania'),(8203,6320,'no_lang_code','name','OriGene (United States)'),(8204,6321,'no_lang_code','name','Evotec (United States)'),(8205,6322,'no_lang_code','name','InnoSense (United States)'),(8206,6323,'en','name','Zane State College'),(8207,6324,'en','name','Orlando Regional Medical Center'),(8208,6325,'es','name','Instituto Costarricense de Investigación y Enseñanza en Nutrición y Salud'),(8209,6326,'en','name','A.V. Topchiev Institute of Petrochemical Synthesis'),(8210,6326,'ru','name','Институт нефтехимического синтеза им. А.В.Топчиева'),(8211,6327,'no_lang_code','name','OSI Systems (United States)'),(8212,6328,'en','name','Alaska Federation of Natives'),(8213,6329,'en','name','Jarvis Christian College'),(8214,6330,'no_lang_code','name','Cirrascale (United States)'),(8215,6331,'no_lang_code','name','Argonon (United Kingdom)'),(8216,6332,'pt','name','Instituto de Artes Visuais, Design e Marketing'),(8217,6333,'no_lang_code','name','QUAD Engineering (Canada)'),(8218,6334,'no_lang_code','name','DiscoveRx (United States)'),(8219,6335,'en','name','International Society for Computational Biology'),(8220,6336,'de','name','Hochrhein Institut für Rehabilitationsforschung'),(8221,6337,'ja','name','ノバルティス ファーマ株式会社'),(8222,6337,'no_lang_code','name','Novartis (Japan)'),(8223,6338,'de','name','Klinikum Braunschweig'),(8224,6339,'no_lang_code','name','Vancouver Biotech (Canada)'),(8225,6340,'sr','name','Institut za kardiovaskularne bolesti Dedinje'),(8226,6341,'en','name','Saint Francis Medical Center'),(8227,6342,'en','name','Fuller Theological Seminary'),(8228,6342,'es','name','Seminario Teológico Fuller'),(8229,6343,'fr','name','Centre Hospitalier de l\'Agglomération de Nevers'),(8230,6344,'no_lang_code','name','UNICOM Global (United States)'),(8231,6345,'en','name','St. Peter\'s Hospital'),(8232,6346,'en','name','Belgian Centre for Corrosion Study'),(8233,6346,'fr','name','Centre Belge d\'Etude de la Corrosion'),(8234,6347,'en','name','Shelton State Community College'),(8235,6348,'no_lang_code','name','A Thinking Ape (Canada)'),(8236,6349,'no_lang_code','name','Potomac Photonics (United States)'),(8237,6350,'no_lang_code','name','Altarum Institute'),(8238,6351,'en','name','National Center for Disease Control'),(8239,6351,'mr','name','राष्ट्रीय संसर्गजन्य रोग नियंत्रण संस्था'),(8240,6352,'en','name','Kurashiki Medical Center'),(8241,6352,'ja','name','倉敷成人病センター'),(8242,6353,'no_lang_code','name','Dimension Technologies (United States)'),(8243,6354,'no_lang_code','name','Aktiv-Dry (United States)'),(8244,6355,'en','name','Lahey Medical Center'),(8245,6356,'no_lang_code','name','BlueRISC (United States)'),(8246,6357,'en','name','Orthopaedic Hospital'),(8247,6358,'no_lang_code','name','Sun Innovations (United States)'),(8248,6359,'en','name','American Council on Education'),(8249,6360,'en','name','Richmond University Medical Center'),(8250,6361,'no_lang_code','name','HEICO (United States)'),(8251,6362,'en','name','Arts Council England'),(8252,6363,'no_lang_code','name','Kestrel Labs (United States)'),(8253,6364,'en','name','Nuclear Decommissioning Authority'),(8254,6365,'no_lang_code','name','Limagrain (United Kingdom)'),(8255,6366,'en','name','National Institute of Immunohaematology'),(8256,6367,'es','name','Complejo Hospitalario de Cáceres'),(8257,6368,'de','name','Paul Drude Institut für Festkörperelektronik'),(8258,6368,'en','name','Paul Drude Institute for Solid State Electronics'),(8259,6369,'no_lang_code','name','IQVIA (United States)'),(8260,6370,'en','name','UPMC Altoona'),(8261,6371,'no_lang_code','name','D-Wave Systems (Canada)'),(8262,6372,'no_lang_code','name','Palatin Technologies (United States)'),(8263,6373,'en','name','Central Research Institute of Epidemiology'),(8264,6373,'ru','name','ФБУН Центральный НИИ эпидемиологии Роспотребнадзора'),(8265,6374,'no_lang_code','name','Biogate Laboratories (Canada)'),(8266,6375,'en','name','Institute of Biophysics'),(8267,6375,'ru','name','Федеральное государственное бюджетное учреждение науки Институт биофизики клетки Российской академии наук'),(8268,6376,'no_lang_code','name','Bio Signal Group (United States)'),(8269,6377,'ja','name','サンスター'),(8270,6377,'no_lang_code','name','Sunstar (Japan)'),(8271,6378,'en','name','Cicatelli Associates'),(8272,6379,'no_lang_code','name','Simpleware (United Kingdom)'),(8273,6380,'it','name','Casa di Cura Villa Garda'),(8274,6381,'en','name','Hastings College'),(8275,6382,'en','name','National Kidney Foundation'),(8276,6383,'en','name','United States Agency for International Development'),(8277,6383,'es','name','Agencia de los Estados Unidos para el Desarrollo Internacional'),(8278,6383,'fr','name','Agence des États-Unis pour le Développement International'),(8279,6384,'no_lang_code','name','Gerber Technology (United States)'),(8280,6385,'en','name','Forth Valley Royal Hospital'),(8281,6386,'no_lang_code','name','KDH Research & Communication (United States)'),(8282,6387,'fr','name','Clinique de Genolier'),(8283,6388,'en','name','Swedish Institute for Health Economics'),(8284,6388,'sv','name','Institutet för Hälso- och Sjukvårdsekonomi'),(8285,6389,'no_lang_code','name','A K Industries (United Kingdom)'),(8286,6390,'en','name','Japan Women\'s College of Physical Education'),(8287,6390,'ja','name','日本女子体育大学'),(8288,6391,'en','name','Mesa Community College'),(8289,6392,'no_lang_code','name','VitaCyte (United States)'),(8290,6393,'no_lang_code','name','Workplace Technologies Research'),(8291,6394,'en','name','Headache & Pain Center of Palm Beach'),(8292,6395,'it','name','Ospedale Civile Di Ivrea'),(8293,6396,'ja','name','済生会若草病院'),(8294,6396,'no_lang_code','name','Saiseikai Wakakusa Hospital'),(8295,6397,'en','name','VA North Texas Health Care System'),(8296,6398,'no_lang_code','name','CDM Group (United States)'),(8297,6399,'no_lang_code','name','Chemat Technology (United States)'),(8298,6400,'en','name','Royal Victoria Infirmary'),(8299,6401,'en','name','Institute of Cytology'),(8300,6401,'ru','name','Федеральное государственное бюджетное учреждение науки Институт цитологии Российской академии наук'),(8301,6402,'en','name','American Lung Association'),(8302,6403,'no_lang_code','name','ANDE (United States)'),(8303,6404,'en','name','National Center for Genome Resources'),(8304,6405,'en','name','National Vaccine and Serum Institute'),(8305,6406,'no_lang_code','name','FuelCell Energy (Canada)'),(8306,6407,'pt','name','Faculdade de Ciências Médicas de Minas Gerais'),(8307,6408,'no_lang_code','name','Adamis Pharmaceuticals (United States)'),(8308,6409,'en','name','National Technical Information Service'),(8309,6410,'en','name','College of Exploration'),(8310,6411,'no_lang_code','name','Diamond Materials (United States)'),(8311,6412,'en','name','Mediterranean Agronomic Institute of Chania'),(8312,6413,'en','name','Association of Women\'s Health Obstetric and Neonatal Nurses'),(8313,6414,'en','name','Estonian Academy of Sciences'),(8314,6415,'en','name','Cambridge City Council'),(8315,6416,'no_lang_code','name','Nutreco (Canada)'),(8316,6417,'no_lang_code','name','Vista Photonics (United States)'),(8317,6418,'en','name','Kazan Institute of Biochemistry and Biophysics'),(8318,6418,'ru','name','Федеральное государственное бюджетное учреждение науки Казанский институт биохимии и биофизики Казанского научного центра Российской академии наук'),(8319,6419,'en','name','Toneyama National Hospital'),(8320,6419,'ja','name','刀根山国立病院'),(8321,6420,'en','name','Bennington College'),(8322,6421,'en','name','Island Institute'),(8323,6422,'fr','name','Institut National d\'Hygiène du Maroc'),(8324,6423,'pl','name','Samodzielny Publiczny Centralny Szpital Kliniczny'),(8325,6424,'en','name','Acadia Institute of Oceanography'),(8326,6425,'en','name','United States Army Medical Research Institute of Infectious Diseases'),(8327,6426,'en','name','Boxer Wachler Vision Institute'),(8328,6427,'en','name','Schizophrenia Research Foundation'),(8329,6428,'en','name','Royal Armouries'),(8330,6429,'no_lang_code','name','Simonsen Laboratories'),(8331,6430,'ja','name','佐久総合病院'),(8332,6430,'no_lang_code','name','Saku Central Hospital'),(8333,6431,'no_lang_code','name','Al Omooma Hospital'),(8334,6432,'no_lang_code','name','STMicroelectronics (Canada)'),(8335,6433,'en','name','Passport to Knowledge'),(8336,6434,'no_lang_code','name','Goldwind (China)'),(8337,6435,'en','name','Central Electrochemical Research Institute'),(8338,6436,'no_lang_code','name','zuChem (United States)'),(8339,6437,'no_lang_code','name','Caterpillar (United States)'),(8340,6438,'en','name','Forestry Commission Scotland'),(8341,6439,'no_lang_code','name','Fonterra (New Zealand)'),(8342,6440,'no_lang_code','name','Lpath (United States)'),(8343,6441,'no_lang_code','name','JS Genetics (United States)'),(8344,6442,'en','name','San Diego Biomedical Research Institute'),(8345,6443,'en','name','New Mexico Consortium'),(8346,6444,'en','name','Foundation for Advanced Education in the Sciences'),(8347,6445,'en','name','Miyagi Prefectural Hospital Organization'),(8348,6445,'ja','name','宮城県立病院機構'),(8349,6446,'en','name','Agricultural Biotechnology Institute'),(8350,6447,'en','name','Holland College'),(8351,6447,'fr','name','Collège holland'),(8352,6448,'no_lang_code','name','Mascoma (Canada)'),(8353,6449,'en','name','Sterling Hospitals'),(8354,6450,'en','name','Karachi Institute of Radiotherapy and Nuclear Medicine'),(8355,6451,'en','name','Washington Adventist Hospital'),(8356,6452,'en','name','Bogomoletz Institute of Physiology'),(8357,6452,'uk','name','Інститут фізіології ім. О.О. Богомольця'),(8358,6453,'no_lang_code','name','Consorcio Regional de Transportes de Madrid'),(8359,6454,'no_lang_code','name','Fluxion Biosciences (United States)'),(8360,6455,'no_lang_code','name','Arkema (United States)'),(8361,6456,'no_lang_code','name','Galderma (United States)'),(8362,6457,'ja','name','八尾徳洲会総合病院'),(8363,6457,'no_lang_code','name','Yao Tokushukai General Hospital'),(8364,6458,'en','name','New Hampshire Hospital'),(8365,6459,'no_lang_code','name','Seashell Technology (United States)'),(8366,6460,'fr','name','Centre d\'Étude du Polymorphisme Humain, Fondation Jean Dausset-CEPH'),(8367,6461,'no_lang_code','name','SimQuest (United States)'),(8368,6462,'no_lang_code','name','Applied Photonics (United Kingdom)'),(8369,6463,'no_lang_code','name','Nautilus Biosciences (Canada)'),(8370,6464,'es','name','Instituto de Diagnóstico e Investigaciones Metabólicas'),(8371,6465,'no_lang_code','name','G & A Technical Software (United States)'),(8372,6466,'no_lang_code','name','Fluidity Software (United States)'),(8373,6467,'en','name','Institute of Molecular Biology and Genetics'),(8374,6467,'uk','name','Інститут молекулярної біології і генетики'),(8375,6468,'en','name','White Memorial Medical Center'),(8376,6469,'en','name','Lycoming College'),(8377,6470,'pt','name','Instituto de Medicina Integral Professor Fernando Figueira'),(8378,6471,'ja','name','株式会社 林原'),(8379,6471,'no_lang_code','name','Hayashibara (Japan)'),(8380,6472,'en','name','Operation UNITE'),(8381,6473,'en','name','Tarzana Treatment Centers'),(8382,6474,'no_lang_code','name','Science Take-Out (United States)'),(8383,6475,'en','name','World Health Organization Regional Office for Europe'),(8384,6475,'fr','name','Bureau régional de l’OMS pour l’Europe'),(8385,6475,'nl','name','Regionalbüro für Europa'),(8386,6476,'en','name','American College of Radiology'),(8387,6477,'en','name','Center for Practical Bioethics'),(8388,6478,'en','name','Chicago Association for Research and Education in Science'),(8389,6479,'no_lang_code','name','Barrett Technology (United States)'),(8390,6480,'en','name','Society of Automotive Engineers International'),(8391,6481,'no_lang_code','name','AureoGen Biosciences (United States)'),(8392,6482,'en','name','National Institute of Neurological Disorders and Stroke'),(8393,6483,'no_lang_code','name','Tengion (United States)'),(8394,6484,'en','name','West Virginia School of Osteopathic Medicine'),(8395,6485,'no_lang_code','name','Incell Corporation (United States)'),(8396,6486,'en','name','Parker University'),(8397,6487,'en','name','Presbyterian College'),(8398,6488,'en','name','Institute of Cardiology'),(8399,6488,'ru','name','Федеральное государственное бюджетное научное учреждение Научно-исследовательский институт кардиологии'),(8400,6489,'no_lang_code','name','Jeremy Benn Associates (United Kingdom)'),(8401,6490,'en','name','Institute of Immunological Engineering'),(8402,6491,'no_lang_code','name','Feilden Clegg Bradley Studios (United Kingdom)'),(8403,6492,'en','name','Merit Network'),(8404,6493,'en','name','Cuyahoga Community College'),(8405,6494,'en','name','Red Deer College'),(8406,6495,'en','name','Treasury Board of Canada Secretariat'),(8407,6495,'fr','name','Secrétariat du Conseil du Trésor du Canada'),(8408,6496,'no_lang_code','name','Pharmaceutical Product Development (United States)'),(8409,6497,'en','name','Tallahassee Community College'),(8410,6498,'ja','name','日産化学株式会社'),(8411,6498,'no_lang_code','name','Nissan Chemical Corporation (Japan)'),(8412,6499,'en','name','Swiss Paraplegic Center'),(8413,6500,'en','name','Center for Dermatology and Laser Surgery'),(8414,6501,'no_lang_code','name','ImageCat (United States)'),(8415,6502,'no_lang_code','name','Geninov (Canada)'),(8416,6503,'sr','name','Klinički centar Niš, Клинички центар Ниш'),(8417,6504,'en','name','Croatian Veterinary Institute'),(8418,6504,'hr','name','Hrvatski veterinarski institut Zagreb'),(8419,6505,'en','name','Howard Brown Health Center'),(8420,6506,'en','name','Fond du Lac Reservation'),(8421,6507,'en','name','Toyama City Hospital'),(8422,6507,'ja','name','富山市立富山市民病院'),(8423,6508,'en','name','National Conference on Interstate Milk Shipments'),(8424,6509,'de','name','Klinikum Oldenburg'),(8425,6510,'no_lang_code','name','Verafin (Canada)'),(8426,6511,'en','name','Sri Ramakrishna Institute of Paramedical Sciences'),(8427,6512,'no_lang_code','name','MBio Diagnostics (United States)'),(8428,6513,'no_lang_code','name','Treatment Innovations (United States)'),(8429,6514,'en','name','Houston Independent School District'),(8430,6515,'en','name','Shriners Hospitals for Children - Spokane'),(8431,6516,'en','name','Regis College'),(8432,6517,'en','name','Conestoga College'),(8433,6518,'en','name','Yvette clinic'),(8434,6518,'fr','name','Clinique de l\'Yvette'),(8435,6519,'no_lang_code','name','White Point Systems (United States)'),(8436,6520,'en','name','Healthcare Education Associates'),(8437,6521,'en','name','Park Nicollet Health Services'),(8438,6522,'en','name','City of York Council'),(8439,6523,'no_lang_code','name','Alpha Genesis (United States)'),(8440,6524,'en','name','Florida Orthopaedic Institute'),(8441,6525,'no_lang_code','name','Circle Solutions'),(8442,6526,'en','name','National Institute Of Hygiene And Epidemiology'),(8443,6526,'vi','name','Viện Vệ sinh dịch tễ Trung ương'),(8444,6527,'en','name','Institute for Family Health'),(8445,6528,'ja','name','森永製菓株式会社'),(8446,6528,'no_lang_code','name','Morinaga (Japan)'),(8447,6529,'fr','name','Hôpital privé Clairval'),(8448,6530,'pt','name','Fundação Universitária de Cardiologia, Instituto de Cardiologia do Rio Grande do Sul'),(8449,6531,'en','name','Biotechnical Services'),(8450,6532,'no_lang_code','name','Prism Clinical Imaging (United States)'),(8451,6533,'en','name','Surrey Place Centre'),(8452,6534,'no_lang_code','name','Alberti\'s Window (United States)'),(8453,6535,'en','name','Valley Hospital'),(8454,6536,'no_lang_code','name','Operational Technologies Corporation (United States)'),(8455,6537,'en','name','Shanghai Cancer Institute'),(8456,6538,'en','name','Institute for Biological Instrumentation'),(8457,6538,'ru','name','Институт биологического приборостроения РАН'),(8458,6539,'en','name','Watford General Hospital'),(8459,6540,'ja','name','塩野義製薬'),(8460,6540,'no_lang_code','name','Shionogi (Japan)'),(8461,6541,'no_lang_code','name','Sizewise (United States)'),(8462,6542,'en','name','Engineering Conferences International'),(8463,6543,'no_lang_code','name','NanoCellect Biomedical (United States)'),(8464,6544,'no_lang_code','name','Sarver and Associates (United States)'),(8465,6545,'no_lang_code','name','3D-Micromac (Germany)'),(8466,6546,'en','name','Northlake Medical Center'),(8467,6547,'en','name','NEC Corporation of America'),(8468,6547,'no_lang_code','name','NEC (United States)'),(8469,6548,'no_lang_code','name','Interklinik'),(8470,6549,'no_lang_code','name','RadioMedix (United States)'),(8471,6550,'no_lang_code','name','Bracco (Switzerland)'),(8472,6551,'ja','name','中外製薬'),(8473,6551,'no_lang_code','name','Roche (Japan)'),(8474,6552,'no_lang_code','name','Immune Response BioPharma (United States)'),(8475,6553,'en','name','Mississippi Gulf Coast Community College'),(8476,6554,'no_lang_code','name','Cadence Biomedical (United States)'),(8477,6555,'sk','name','Onkologický Ústav Svätej Alžbety'),(8478,6556,'en','name','Valley Medical Center'),(8479,6557,'en','name','National Migraine Centre'),(8480,6558,'no_lang_code','name','Merck Serono (Switzerland)'),(8481,6559,'en','name','Center for Economic and Policy Research'),(8482,6560,'en','name','State Science and Technology Institute'),(8483,6561,'no_lang_code','name','PhosphorTech (United States)'),(8484,6562,'en','name','Torbay Hospital'),(8485,6563,'no_lang_code','name','Cytex Therapeutics (United States)'),(8486,6564,'en','name','Roland Institute of Pharmaceutical Sciences'),(8487,6565,'no_lang_code','name','CHI Associates (United States)'),(8488,6566,'en','name','Citadel'),(8489,6566,'fr','name','Académie militaire de caroline du sud'),(8490,6567,'it','name','Istituto Ortopedico Galeazzi'),(8491,6568,'en','name','National Tuberculosis Institute'),(8492,6569,'en','name','Academy of Sciences of Moldova'),(8493,6569,'ro','name','Academia de Științe a Moldovei'),(8494,6569,'ru','name','Академия наук Молдавии'),(8495,6570,'de','name','Max-Planck-Institut für Informatik'),(8496,6570,'en','name','Max Planck Institute for Informatics'),(8497,6571,'no_lang_code','name','ACRI Group (France)'),(8498,6572,'no_lang_code','name','Phoenix Science and Technology (United States)'),(8499,6573,'no_lang_code','name','Naprogenix (United States)'),(8500,6574,'en','name','Tri-County Health Department'),(8501,6575,'en','name','Pharmo Institute'),(8502,6576,'en','name','Area Cooperative Education Services'),(8503,6577,'en','name','Raghudeep Eye Hospital'),(8504,6578,'en','name','National Center for HIV/AIDS Viral Hepatitis STD and TB Prevention'),(8505,6579,'no_lang_code','name','Foster-Miller (United States)'),(8506,6580,'en','name','Central Research Institute'),(8507,6580,'hi','name','केंद्रीय अनुसंधान संस्थान'),(8508,6581,'en','name','Chinese National Human Genome Center'),(8509,6582,'en','name','Institute for Animal Production System in Mediterranean Environment'),(8510,6582,'it','name','Istituto per il Sistema Produzione Animale in Ambiente Mediterraneo'),(8511,6583,'en','name','National Centre for Atmospheric Science'),(8512,6584,'en','name','New York City Department of Education'),(8513,6584,'es','name','Departamento de Educación de la Ciudad de Nueva York'),(8514,6584,'fr','name','Département de l\'Éducation de la ville de new york'),(8515,6585,'en','name','Maria Cecilia Hospital'),(8516,6586,'ja','name','国立さくら病院'),(8517,6586,'no_lang_code','name','Kunitachi Sakura Hospital'),(8518,6587,'fr','name','Centre International de Recherches Médicales de Franceville'),(8519,6588,'fr','name','Coalition des Organismes Communautaires Québécois de Lutte Contre le Sida'),(8520,6589,'no_lang_code','name','Saneron CCEL Therapeutics (United States)'),(8521,6590,'en','name','West Cumberland Hospital'),(8522,6591,'no_lang_code','name','DesignMedix (United States)'),(8523,6592,'no_lang_code','name','SC Solutions (United States)'),(8524,6593,'en','name','Tianjin People\'s Hospital'),(8525,6593,'zh','name','天津市人民医院'),(8526,6594,'en','name','Hillsborough Community College'),(8527,6595,'en','name','National Center for Environmental Assessment (EPA)'),(8528,6596,'no_lang_code','name','ManTech International (United States)'),(8529,6597,'no_lang_code','name','NovaSterilis (United States)'),(8530,6598,'en','name','Papua New Guinea Institute of Medical Research'),(8531,6599,'en','name','Saint Elizabeth Regional Medical Center'),(8532,6600,'en','name','American Society For Testing and Materials'),(8533,6601,'no_lang_code','name','Cairn Research (United Kingdom)'),(8534,6602,'en','name','Korea Atomic Energy Research Institute'),(8535,6602,'ko','name','한국원자력연구원'),(8536,6603,'en','name','National Association of State Mental Health Program Directors'),(8537,6604,'no_lang_code','name','Weifang People\'s Hospital'),(8538,6604,'zh','name','潍坊市人民医院'),(8539,6605,'ja','name','日本たばこ産業株式会社'),(8540,6605,'no_lang_code','name','Japan Tobacco (Japan)'),(8541,6606,'en','name','National Institute of Amazonian Research'),(8542,6606,'pt','name','Instituto Nacional de Pesquisas da Amazônia'),(8543,6607,'en','name','VA West Los Angeles Medical Center'),(8544,6608,'en','name','Academy of Sciences Republic of Uzbekistan'),(8545,6608,'ru','name','Академия наук Узбекистана'),(8546,6608,'tg','name','Академияи илмҳои Ӯзбакистон'),(8547,6608,'uz','name','Oʻzbekiston Respublikasi Fanlar Akademiyasi'),(8548,6609,'no_lang_code','name','Nicoya Lifesciences (Canada)'),(8549,6610,'no_lang_code','name','WisdomTools (United States)'),(8550,6611,'no_lang_code','name','Carl Zeiss (United States)'),(8551,6612,'no_lang_code','name','Team Industrial Services (United States)'),(8552,6613,'no_lang_code','name','Robert Olson Consulting (United States)'),(8553,6614,'en','name','University of Jamestown'),(8554,6615,'no_lang_code','name','OFM Research (United States)'),(8555,6616,'no_lang_code','name','Seamon (United States)'),(8556,6617,'en','name','Elizabethtown College'),(8557,6618,'en','name','St. Mary\'s College of Maryland'),(8558,6619,'en','name','Spine Institute of Louisiana'),(8559,6620,'no_lang_code','name','Raptamer Discovery Group (United States)'),(8560,6621,'as','name','আঞ্চলিক চিকিৎসা গৱেষণা কেন্দ্ৰ, ডিব্ৰুগড়'),(8561,6621,'en','name','Regional Medical Research Centre'),(8562,6622,'no_lang_code','name','Technology Dynamics (United States)'),(8563,6623,'en','name','Dominican College of Blauvelt'),(8564,6624,'de','name','Max Planck Institut für Chemische Energiekonversion'),(8565,6624,'en','name','Max Planck Institute for Chemical Energy Conversion'),(8566,6625,'en','name','Yodogawa Christian Hospital'),(8567,6625,'ja','name','淀川キリスト教病院'),(8568,6626,'fr','name','Centre Eugène Marquis'),(8569,6627,'it','name','CSI Piemonte'),(8570,6628,'no_lang_code','name','American Life Science Pharmaceuticals (United States)'),(8571,6629,'en','name','Design Council'),(8572,6630,'en','name','Waukesha Memorial Hospital'),(8573,6631,'no_lang_code','name','Sensor Electronics (United States)'),(8574,6632,'en','name','Pacific Medical Research Foundation'),(8575,6633,'en','name','Institute of Gene Biology'),(8576,6633,'ru','name','Институт биологии гена'),(8577,6634,'en','name','European Molecular Biology Laboratory'),(8578,6635,'en','name','Guttmacher Institute'),(8579,6636,'no_lang_code','name','NORAM (Canada)'),(8580,6637,'no_lang_code','name','Viasystems (United States)'),(8581,6638,'no_lang_code','name','Anacomp (United States)'),(8582,6639,'es','name','Instituto Nacional de Rehabilitación Psicofísica'),(8583,6640,'de','name','Forschungsinstitut für Kinderernährung'),(8584,6641,'no_lang_code','name','Guild Associates (United States)'),(8585,6642,'en','name','Italian Scientific Institute for the Spine'),(8586,6642,'it','name','Istituto Scientifico Italiano Colonna Vertebrale'),(8587,6643,'en','name','ZNA Middelheim Hospital'),(8588,6644,'pt','name','Faculdade de Ciências Médicas da Santa Casa de São Paulo'),(8589,6645,'no_lang_code','name','Millar (United States)'),(8590,6646,'no_lang_code','name','Technology Assessment and Transfer (United States)'),(8591,6647,'en','name','Ottawa Regional Cancer Foundation'),(8592,6648,'en','name','Diabetes & Glandular Disease Clinic'),(8593,6649,'no_lang_code','name','Modulim (United States)'),(8594,6650,'en','name','Baptist Health Care'),(8595,6651,'en','name','Office of the Chief Medical Examiner'),(8596,6652,'en','name','Yuan\'s General Hospital'),(8597,6652,'zh','name','阮綜合醫院'),(8598,6653,'fr','name','Centre Médical de Vidy'),(8599,6654,'no_lang_code','name','Theradex Oncology (United States)'),(8600,6655,'en','name','Renal Association'),(8601,6656,'it','name','Ospedale Psichiatrico Paolo Pini'),(8602,6657,'en','name','Institute for Marine Biosciences'),(8603,6658,'no_lang_code','name','INFICON (United States)'),(8604,6659,'no_lang_code','name','Alere (United States)'),(8605,6660,'en','name','Indian Institute of Integrative Medicine'),(8606,6661,'en','name','Linn Benton Community College'),(8607,6662,'it','name','Istituto di Tipizzazione Tissutale e Problemi della Dialisi'),(8608,6663,'tr','name','Türkiye Cumhuriyeti Devlet Demiryolları Hastanesi'),(8609,6664,'en','name','Children’s Discovery Museum of San Jose'),(8610,6665,'no_lang_code','name','Insmed (United States)'),(8611,6666,'no_lang_code','name','EarthSky'),(8612,6667,'no_lang_code','name','Oncor (United States)'),(8613,6668,'en','name','Nashville State Community College'),(8614,6669,'en','name','Parkland Memorial Hospital'),(8615,6670,'de','name','Max-Planck-Institut für die Physik des Lichts'),(8616,6670,'en','name','Max Planck Institute for the Science of Light'),(8617,6671,'no_lang_code','name','Proton (United Kingdom)'),(8618,6672,'en','name','Oakton Community College'),(8619,6673,'en','name','Global Hospitals'),(8620,6674,'en','name','Gimbel Eye Centre'),(8621,6675,'bg','name','Национална кардиологична болница'),(8622,6675,'en','name','National Heart Hospital'),(8623,6676,'no_lang_code','name','Mosaiques Diagnostics and Therapeutics (Germany)'),(8624,6677,'en','name','Holy Names University'),(8625,6678,'en','name','United States Public Health Service Commissioned Officers Association'),(8626,6679,'no_lang_code','name','NDI Group (United States)'),(8627,6680,'it','name','Ospedale dei Pellegrini'),(8628,6681,'en','name','Student Assistance Services'),(8629,6682,'en','name','Merici College'),(8630,6682,'fr','name','Collège Mérici'),(8631,6683,'no_lang_code','name','DIApedia (United States)'),(8632,6684,'no_lang_code','name','Cybernet Systems Corporation (United States)'),(8633,6685,'en','name','Center for Applied Linguistics'),(8634,6686,'en','name','Premier Community Health'),(8635,6687,'pt','name','Centro Hospitalar Lisboa Norte'),(8636,6688,'en','name','Shibaura Institute of Technology'),(8637,6688,'ja','name','芝浦工業大学'),(8638,6689,'no_lang_code','name','Spectris (United Kingdom)'),(8639,6690,'no_lang_code','name','Lord Corporation (United States)'),(8640,6691,'en','name','Alberta Community Council on HIV'),(8641,6692,'en','name','Filippo Del Ponte Hospital'),(8642,6692,'it','name','Ospedale Filippo Del Ponte Varese'),(8643,6693,'en','name','National Metallurgical Laboratory'),(8644,6694,'en','name','Chiba Cancer Center'),(8645,6694,'ja','name','千葉県がんセンター'),(8646,6695,'no_lang_code','name','DesignBuilder Software (United Kingdom)'),(8647,6696,'en','name','Inova Fairfax Hospital'),(8648,6697,'no_lang_code','name','Medical Imaging Applications (United States)'),(8649,6698,'en','name','Aspen Global Change Institute'),(8650,6699,'no_lang_code','name','Karo Pharma (Sweden)'),(8651,6700,'en','name','Royal College of Surgeons of Edinburgh'),(8652,6701,'en','name','Northern Territory Health Services'),(8653,6702,'en','name','Adelphi Research'),(8654,6703,'en','name','Noto General Hospital'),(8655,6703,'ja','name','公立能登総合病院'),(8656,6704,'no_lang_code','name','International Trypanotolerance Centre'),(8657,6705,'no_lang_code','name','Diacon (Canada)'),(8658,6706,'no_lang_code','name','National Integrated Solutions (United Kingdom)'),(8659,6707,'no_lang_code','name','MGS Research (United States)'),(8660,6708,'no_lang_code','name','Novus Biologicals (United States)'),(8661,6709,'en','name','National Environmental Engineering Research Institute'),(8662,6710,'en','name','National Center for Chronic Disease Prevention and Health Promotion'),(8663,6711,'no_lang_code','name','Nicolet Chartrand Knoll (Canada)'),(8664,6712,'en','name','El Camino College'),(8665,6713,'en','name','Posnick Center for Facial Plastic Surgery'),(8666,6714,'no_lang_code','name','Center For Remote Sensing (United States)'),(8667,6715,'no_lang_code','name','Evolutionary Genomics (United States)'),(8668,6716,'ro','name','Institutul Oncologic Bucuresti'),(8669,6717,'no_lang_code','name','South Australian Water Corporation'),(8670,6718,'no_lang_code','name','Ajinomoto Althea (United States)'),(8671,6719,'no_lang_code','name','Beneficial Designs (United States)'),(8672,6720,'en','name','Taste and Smell Clinic'),(8673,6721,'en','name','Nazareth College'),(8674,6722,'en','name','St. Mary\'s Medical Center'),(8675,6723,'no_lang_code','name','Honda (Germany)'),(8676,6724,'ja','name','大塚眼科病院'),(8677,6724,'no_lang_code','name','Ohtsuka Eye Hospital'),(8678,6725,'en','name','Family Health Centers of San Diego'),(8679,6726,'no_lang_code','name','New Span Opto-Technology (United States)'),(8680,6727,'no_lang_code','name','Hexcel (United Kingdom)'),(8681,6728,'en','name','Santa Barbara City College'),(8682,6729,'de','name','Max-Planck-Institut für Entwicklungsbiologie'),(8683,6729,'en','name','Max Planck Institute for Developmental Biology'),(8684,6730,'no_lang_code','name','Philip Morris International (Germany)'),(8685,6731,'en','name','Grewal Eye Institute'),(8686,6732,'en','name','Tzu Chi Foundation'),(8687,6733,'pt','name','Instituto de Engenharia de Sistemas e Computadores Microsistemas e Nanotecnologias'),(8688,6734,'en','name','Institute of Transplantation Sciences'),(8689,6735,'en','name','Chicago Public Schools'),(8690,6736,'en','name','County College of Morris'),(8691,6737,'en','name','Steadman Clinic'),(8692,6738,'en','name','Pavlov Institute of Physiology of the Russian Academy of Sciences'),(8693,6738,'ru','name','Федеральное государственное бюджетное учреждение науки Институт физиологии им. И.П. Павлова Российской академии наук'),(8694,6739,'no_lang_code','name','Planet Biotechnology (United States)'),(8695,6740,'en','name','University of Mount Union'),(8696,6740,'fr','name','Université de mount union'),(8697,6741,'no_lang_code','name','Tanner Research (United States)'),(8698,6742,'es','name','EsSALUD, Seguro Social de Salud del Perú'),(8699,6743,'no_lang_code','name','HydraTek (Canada)'),(8700,6744,'en','name','Institute for Safe Medication Practices'),(8701,6745,'en','name','Akebono Clinic'),(8702,6746,'no_lang_code','name','Petrobras (Brazil)'),(8703,6747,'en','name','Let\'s Talk Science'),(8704,6748,'de','name','Max-Planck-Institut für Marine Mikrobiologie'),(8705,6748,'en','name','Max Planck Institute for Marine Microbiology'),(8706,6749,'no_lang_code','name','GeneTrace Systems (United States)'),(8707,6750,'en','name','East Bay Institute for Research & Education'),(8708,6751,'en','name','Southeast Alaska Regional Health Consortium'),(8709,6752,'fr','name','Centre d\'Exploration et de Recherche Médicale par Emission de Positons'),(8710,6753,'no_lang_code','name','Agenta Biotechnologies (United States)'),(8711,6754,'no_lang_code','name','QED Labs'),(8712,6755,'en','name','Michigan Department of Agriculture and Rural Development'),(8713,6756,'en','name','National Association for Public Health Statistics and Information Systems'),(8714,6757,'en','name','St. Thomas Hospital'),(8715,6758,'no_lang_code','name','Johnson & Johnson (Germany)'),(8716,6759,'no_lang_code','name','Onconova Therapeutics (United States)'),(8717,6760,'no_lang_code','name','ON Semiconductor (Canada)'),(8718,6761,'en','name','St Richard\'s Hospital'),(8719,6762,'en','name','International Hearing Foundation'),(8720,6763,'en','name','Sisseton Wahpeton College'),(8721,6764,'no_lang_code','name','Hoare Lea (United Kingdom)'),(8722,6765,'no_lang_code','name','INRIX (United Kingdom)'),(8723,6766,'en','name','Nova Scotia Community College'),(8724,6767,'no_lang_code','name','EKF Diagnostics (United States)'),(8725,6768,'en','name','National Agriculture and Food Research Organization'),(8726,6768,'ja','name','農業・食品産業技術総合研究機構'),(8727,6769,'en','name','University of Health Sciences İstanbul Ümranyie Training and Research Hospital'),(8728,6769,'tr','name','Ümraniye Eğitim ve Araştırma Hastanesi'),(8729,6770,'it','name','Casa di Cura Columbus'),(8730,6771,'no_lang_code','name','Canadian Electric Vehicles (Canada)'),(8731,6772,'en','name','Biophysical Society'),(8732,6773,'en','name','Neuroscience Institute'),(8733,6773,'it','name','Istituto di Neuroscienze'),(8734,6774,'en','name','Boston VA Research Institute'),(8735,6775,'en','name','Orthopedic Foot & Ankle Center'),(8736,6776,'de','name','Max Planck Institut für Biologie'),(8737,6776,'en','name','Max Planck Institute for Biology'),(8738,6777,'no_lang_code','name','Molsoft (United States)'),(8739,6778,'no_lang_code','name','Optron Systems (United States)'),(8740,6779,'en','name','Christus Health'),(8741,6780,'en','name','Kuwait Cancer Control Center'),(8742,6781,'no_lang_code','name','ALD NanoSolutions (United States)'),(8743,6782,'en','name','Phoenix VA Health Care System'),(8744,6783,'no_lang_code','name','Provid Pharmaceuticals (United States)'),(8745,6784,'en','name','London Women\'s Clinic'),(8746,6785,'no_lang_code','name','Natural Selection (United States)'),(8747,6786,'es','name','Administración Nacional de Laboratorios e Institutos de Salud'),(8748,6787,'no_lang_code','name','Auritec Pharmaceuticals (United States)'),(8749,6788,'en','name','Taiwan Adventist Hospital'),(8750,6788,'zh','name','台安医院'),(8751,6789,'en','name','Nuffield Council on Bioethics'),(8752,6790,'en','name','Conservation International'),(8753,6791,'no_lang_code','name','Thermalin Diabetes (United States)'),(8754,6792,'en','name','John Wesley Community Health Institute'),(8755,6793,'en','name','Portland Cement Association'),(8756,6794,'en','name','Warrington Hospital'),(8757,6795,'no_lang_code','name','SeaWell Networks (Canada)'),(8758,6796,'no_lang_code','name','Antigen Discovery (United States)'),(8759,6797,'no_lang_code','name','Greenfield Research (Canada)'),(8760,6798,'en','name','Institute for Veterinary Medical Research'),(8761,6798,'hu','name','Állatorvos Tudományi Intézet'),(8762,6799,'en','name','Doane University'),(8763,6800,'no_lang_code','name','Severn Trent (United Kingdom)'),(8764,6801,'en','name','Children\'s Health Ireland at Crumlin'),(8765,6801,'ga','name','Sláinte Leanaí Éireann ag Cromghlinn'),(8766,6802,'en','name','Deep River Science Academy'),(8767,6803,'no_lang_code','name','IONICS Mass Spectrometry (Canada)'),(8768,6804,'en','name','Lille Catholic University'),(8769,6804,'fr','name','Université Catholique de Lille'),(8770,6805,'en','name','Heart Clinic of Louisiana'),(8771,6806,'no_lang_code','name','GlaxoSmithKline (United States)'),(8772,6807,'en','name','Tri-City Medical Center'),(8773,6808,'en','name','Royal Astronomical Society of Canada'),(8774,6809,'en','name','Clinical Immunology Society'),(8775,6810,'en','name','Arizona Academy of Science'),(8776,6811,'no_lang_code','name','BioFusionary Corporation (United States)'),(8777,6812,'no_lang_code','name','Anvik Corporation (United States)'),(8778,6813,'no_lang_code','name','Center for Value Based Medicine (United States)'),(8779,6814,'fr','name','Hôpital René Huguenin'),(8780,6815,'no_lang_code','name','Advanced Materials Technology (United States)'),(8781,6816,'en','name','Norton Healthcare'),(8782,6817,'no_lang_code','name','CyberFluor and Kronen Systems Incorporated'),(8783,6818,'en','name','Global HIV Vaccine Enterprise'),(8784,6819,'en','name','Sitaram Bhartia Institute of Science and Research'),(8785,6820,'en','name','Montana Wyoming Tribal Leaders Council'),(8786,6821,'no_lang_code','name','Tinderbox Consultants (United Kingdom)'),(8787,6822,'no_lang_code','name','UT Dots (United States)'),(8788,6823,'en','name','Oxford Centre for Computational Neuroscience'),(8789,6824,'en','name','Productive Rehabilitation Institute of Dallas for Ergonomics'),(8790,6825,'en','name','St. Joseph Hospital'),(8791,6826,'en','name','Hazardous Materials Training and Research Institute'),(8792,6827,'de','name','Max-Planck-Institut für Biologische Kybernetik'),(8793,6827,'en','name','Max Planck Institute for Biological Cybernetics'),(8794,6828,'no_lang_code','name','CytoCure (United States)'),(8795,6829,'no_lang_code','name','Geron (United States)'),(8796,6830,'no_lang_code','name','Biopeptide (United States)'),(8797,6831,'no_lang_code','name','Assystem (Germany)'),(8798,6832,'no_lang_code','name','Harrington Software Associates'),(8799,6833,'no_lang_code','name','NeoClone (United States)'),(8800,6834,'no_lang_code','name','Passat (Canada)'),(8801,6835,'en','name','National Aquarium'),(8802,6836,'en','name','South Dakota Department of Social Services'),(8803,6837,'en','name','Institute of Cytology and Genetics'),(8804,6837,'ru','name','Федеральный исследовательский центр Институт цитологии и генетики Сибирского отделения Российской академии наук'),(8805,6838,'no_lang_code','name','Boston Medical Products (United States)'),(8806,6839,'en','name','Victorian Order of Nurses'),(8807,6840,'no_lang_code','name','Aedas (United Kingdom)'),(8808,6841,'no_lang_code','name','Integrated BioTherapeutics (United States)'),(8809,6842,'en','name','Tabba Heart Institute'),(8810,6843,'fr','name','Institut de la Main'),(8811,6844,'en','name','Canadian Obesity Network'),(8812,6844,'fr','name','Réseau Canadien en l’Obésité'),(8813,6845,'no_lang_code','name','Chemica Technologies (United States)'),(8814,6846,'en','name','Obihiro Kosei General Hospital'),(8815,6846,'ja','name','帯広厚生病院'),(8816,6847,'en','name','New Economics Foundation'),(8817,6848,'hu','name','Állami Szívkórház'),(8818,6849,'en','name','Kidwai Memorial Institute of Oncology'),(8819,6850,'no_lang_code','name','AlertMe (United Kingdom)'),(8820,6851,'en','name','Engelhardt Institute of Molecular Biology'),(8821,6851,'ru','name','Федеральное государственное бюджетное учреждение науки Институт молекулярной биологии им. В.А. Энгельгардта Российской академии наук'),(8822,6852,'no_lang_code','name','Quantum Simulations (United States)'),(8823,6853,'en','name','Salem VA Medical Center'),(8824,6854,'no_lang_code','name','Capcom Vancouver (Canada)'),(8825,6855,'en','name','Centre for Life'),(8826,6856,'ja','name','明治'),(8827,6856,'no_lang_code','name','Meiji (Japan)'),(8828,6857,'en','name','Mary Baldwin College'),(8829,6858,'no_lang_code','name','Celdara Medical (United States)'),(8830,6859,'en','name','Institute for Broadening Participation'),(8831,6860,'en','name','Nuffield Foundation'),(8832,6861,'no_lang_code','name','Promiliad Biopharma (United States)'),(8833,6862,'en','name','Tenshi Hospital'),(8834,6862,'ja','name','天使病院'),(8835,6863,'ja','name','浴風会病院'),(8836,6863,'no_lang_code','name','Yokufukai Hospital'),(8837,6864,'no_lang_code','name','Applied System Technologies (United States)'),(8838,6865,'no_lang_code','name','SaskTel (Canada)'),(8839,6866,'no_lang_code','name','21st Century Medicine (United States)'),(8840,6867,'en','name','Kyoto Research Park'),(8841,6867,'ja','name','京都リサーチパーク'),(8842,6868,'en','name','Society for Academic Emergency Medicine'),(8843,6869,'no_lang_code','name','Unicon Research (United States)'),(8844,6870,'en','name','Hartwick College'),(8845,6871,'no_lang_code','name','Telesensory (United States)'),(8846,6872,'es','name','Administracion de los Servicios de Salud del Estado'),(8847,6873,'no_lang_code','name','VisionQuest Biomedical (United States)'),(8848,6874,'en','name','Clark Planetarium'),(8849,6875,'no_lang_code','name','SVT Associates (United States)'),(8850,6876,'en','name','Center for Clinical & Basic Research'),(8851,6877,'en','name','Santa Clara Valley Health and Hospital System'),(8852,6878,'en','name','Black Women’s Health Imperative'),(8853,6879,'en','name','Science North'),(8854,6880,'en','name','European Monitoring Centre for Drugs and Drug Addiction'),(8855,6880,'pt','name','Observatório Europeu da Droga e da Toxicodependência'),(8856,6881,'en','name','Chabot Space and Science Center'),(8857,6882,'no_lang_code','name','MagneSensors (United States)'),(8858,6883,'no_lang_code','name','Pipehawk (United Kingdom)'),(8859,6884,'en','name','Indian Institute of Science Education and Research Pune'),(8860,6884,'hi','name','भारतीय विज्ञान शिक्षा एवं अनुसंधान संस्थान, पुणे'),(8861,6885,'en','name','Government Dental College & Research Institute'),(8862,6886,'en','name','Policy Research Associates'),(8863,6887,'en','name','United States Department of the Treasury'),(8864,6887,'es','name','Departamento del Tesoro de los Estados Unidos'),(8865,6887,'fr','name','Département du trésor des États-unis'),(8866,6888,'en','name','Kirkwood Community College'),(8867,6889,'fr','name','Centre de Recherche et d’Information sur la Démocratie et l\'Autonomie'),(8868,6890,'no_lang_code','name','Applied Behavioral Research (United States)'),(8869,6891,'no_lang_code','name','STATegics (United States)'),(8870,6892,'en','name','Institute of Life Sciences'),(8871,6893,'ja','name','メルク'),(8872,6893,'no_lang_code','name','Merck (Japan)'),(8873,6894,'no_lang_code','name','Droplet Measurement Technologies (United States)'),(8874,6895,'en','name','Latino Commission on AIDS'),(8875,6895,'es','name','La Comisión Latina sobre el SIDA'),(8876,6896,'en','name','Seminole State College of Florida'),(8877,6897,'en','name','Iowa Department of Inspections and Appeals'),(8878,6898,'en','name','Valencia College'),(8879,6899,'fi','name','Orion Oyj'),(8880,6899,'no_lang_code','name','Orion Corporation (Finland)'),(8881,6900,'en','name','Korea Institute of Energy Research'),(8882,6901,'en','name','Voorhees College'),(8883,6902,'no_lang_code','name','Kromek (United States)'),(8884,6903,'no_lang_code','name','Interlab (United States)'),(8885,6904,'ja','name','大分県立病院'),(8886,6904,'no_lang_code','name','Oita Prefectural Hospital'),(8887,6905,'no_lang_code','name','Cook General BioTechnology (United States)'),(8888,6906,'no_lang_code','name','Muprime Technology (Canada)'),(8889,6907,'no_lang_code','name','Ash Stevens (United States)'),(8890,6908,'en','name','Singapore National Eye Center'),(8891,6909,'en','name','Williams LifeSkills'),(8892,6910,'en','name','Our Lady of Lourdes Hospital'),(8893,6910,'ga','name','Ospidéal Mhuire Lourdes'),(8894,6911,'en','name','European Neuroscience Institute Göttingen'),(8895,6912,'en','name','Aquinas Institute of Theology'),(8896,6913,'no_lang_code','name','Edenspace Systems (United States)'),(8897,6914,'en','name','Society of General Physiologists'),(8898,6915,'en','name','Salt Lake Community College'),(8899,6916,'no_lang_code','name','Springer Nature (New Zealand)'),(8900,6917,'en','name','Central Rice Research Institute'),(8901,6918,'en','name','Tianjin Children\'s Hospital'),(8902,6918,'zh','name','天津市儿童医院'),(8903,6919,'en','name','Columbia Education'),(8904,6920,'de','name','Max-Planck-Institut für Evolutionäre Anthropologie'),(8905,6920,'en','name','Max Planck Institute for Evolutionary Anthropology'),(8906,6921,'no_lang_code','name','Sasol (South Africa)'),(8907,6922,'no_lang_code','name','Navigen (United States)'),(8908,6923,'en','name','Sequoia Foundation'),(8909,6924,'en','name','Research Institute for Olympic Sports'),(8910,6925,'de','name','Fraunhofer-Institut für Angewandte Optik und Feinmechanik'),(8911,6925,'en','name','Fraunhofer Institute for Applied Optics and Precision Engineering'),(8912,6926,'en','name','National Institute of Indian Medical Heritage'),(8913,6926,'hi','name','राष्ट्रीय भारतीय आयुर्विज्ञान संपदा संस्थान'),(8914,6927,'en','name','Midwest Eye Institute'),(8915,6928,'es','name','Centro Hospitalario Pereira Rossell, Hospital Pereira Rossell'),(8916,6929,'en','name','Marie Curie'),(8917,6930,'en','name','HIV Netherlands Australia Thailand Research Collaboration'),(8918,6931,'no_lang_code','name','Enapter (Italy)'),(8919,6932,'no_lang_code','name','Palladian Partners'),(8920,6933,'no_lang_code','name','Fresenius Medical Care (United States)'),(8921,6934,'en','name','Gansu Provincial Hospital'),(8922,6934,'zh','name','甘肃省人民医院'),(8923,6935,'en','name','Santa Fe Community College'),(8924,6936,'en','name','National Sanitation Foundation International'),(8925,6937,'en','name','Pakistan Health Research Council'),(8926,6937,'ur','name','مجلس البحوث الطبية في باكستان'),(8927,6938,'en','name','Roskamp Institute'),(8928,6939,'en','name','National Food Administration'),(8929,6940,'en','name','AID Atlanta'),(8930,6941,'ro','name','Institutul Național de Endocrinologie C.I. Parhon'),(8931,6942,'it','name','Istituto Dermopatico dell\'Immacolata'),(8932,6943,'en','name','Coastal Bend Wellness Foundation'),(8933,6944,'no_lang_code','name','Novasentis (United States)'),(8934,6945,'no_lang_code','name','Convergent Manufacturing Technologies (Canada)'),(8935,6946,'en','name','H. R. MacMillan Space Centre'),(8936,6947,'en','name','American College of Chest Physicians'),(8937,6948,'no_lang_code','name','Polysciences (United States)'),(8938,6949,'en','name','Osaka Rosai Hospital'),(8939,6949,'ja','name','大阪労災病院'),(8940,6950,'en','name','Hokkaido Agricultural Research Center'),(8941,6950,'ja','name','北海道農業研究センター'),(8942,6951,'es','name','Asociación Civil Impacta Salud y Educación'),(8943,6952,'en','name','Russell Sage College'),(8944,6953,'no_lang_code','name','Omneuron (United States)'),(8945,6954,'no_lang_code','name','Southeast TechInventures (United States)'),(8946,6955,'en','name','China Rehabilitation Research Center'),(8947,6956,'en','name','Institute of Human Behaviour and Allied Sciences'),(8948,6957,'it','name','Istituto Ortopedico Gaetano Pini'),(8949,6958,'en','name','House Clinic'),(8950,6959,'en','name','American Medical Informatics Association'),(8951,6960,'en','name','Center for Telepsychology'),(8952,6961,'no_lang_code','name','Mo Sci Corporation (United States)'),(8953,6962,'no_lang_code','name','GLC Biotechnology (United States)'),(8954,6963,'en','name','Woodland Hills Medical Center'),(8955,6964,'de','name','Fraunhofer Institut für Toxikologie und Experimentelle Medizin'),(8956,6964,'en','name','Fraunhofer Institute for Toxicology and Experimental Medicine'),(8957,6965,'en','name','Howard Community College'),(8958,6966,'no_lang_code','name','Martec (Canada)'),(8959,6967,'de','name','Leibniz-Institut für Präventionsforschung und Epidemiologie - BIPS'),(8960,6967,'en','name','Leibniz Institute for Prevention Research and Epidemiology - BIPS'),(8961,6968,'en','name','Northwest Indian College'),(8962,6969,'en','name','Associated Skin Care Specialists'),(8963,6970,'en','name','Northeastern Oklahoma A&M College'),(8964,6971,'bg','name','Институт по биология и имунология на размножаването'),(8965,6971,'en','name','Institute of Biology and Immunology of Reproduction'),(8966,6972,'en','name','National Public Radio'),(8967,6973,'en','name','St. Joseph’s University Medical Center'),(8968,6974,'en','name','Community Rehabilitation Center'),(8969,6975,'en','name','Collaborative Research Group'),(8970,6976,'no_lang_code','name','Proto Corporation (United States)'),(8971,6977,'en','name','Osaka Occupational Health Research Center'),(8972,6977,'ja','name','大阪労働衛生総合センター'),(8973,6978,'fr','name','Centre Hospitalier de Tourcoing'),(8974,6979,'en','name','Defense Advanced Research Projects Agency'),(8975,6980,'en','name','Department of Services for Children Youth and their Families'),(8976,6981,'de','name','Orthopädisches Spital Speising'),(8977,6981,'en','name','Orthopaedic Hospital Speising'),(8978,6982,'fr','name','Hôpital Militaire Avicenne'),(8979,6983,'no_lang_code','name','Watershed'),(8980,6984,'en','name','Tianjin First Center Hospital'),(8981,6984,'zh','name','天津市第一中心医院'),(8982,6985,'ja','name','王子総合病院'),(8983,6985,'no_lang_code','name','Oji General Hospital'),(8984,6986,'en','name','My Brother\'s Keeper'),(8985,6987,'en','name','St. Joseph\'s Hospital'),(8986,6988,'sv','name','Uddevalla sjukhus'),(8987,6989,'no_lang_code','name','IMRIS (Canada)'),(8988,6990,'no_lang_code','name','Polestar Technologies (United States)'),(8989,6991,'en','name','Thames Valley Children\'s Centre'),(8990,6992,'en','name','Wollongong Hospital'),(8991,6993,'no_lang_code','name','CCS Associates (United States)'),(8992,6994,'no_lang_code','name','Virginia Technologies (United States)'),(8993,6995,'no_lang_code','name','Transgene (France)'),(8994,6996,'en','name','GF Strong Rehabilitation Centre'),(8995,6997,'en','name','Sound Health Options'),(8996,6998,'no_lang_code','name','Baxter (United States)'),(8997,6999,'no_lang_code','name','Consad (United States)'),(8998,7000,'en','name','Yokkaichi Social Insurance Hospital'),(8999,7000,'ja','name','四日市羽津医療センター'),(9000,7001,'en','name','Institute for Social Security and Services for State Workers'),(9001,7001,'es','name','Instituto de Seguridad y Servicios Sociales de los Trabajadores del Estado'),(9002,7002,'en','name','Henry Ford College'),(9003,7003,'it','name','Centro San Giovanni di Dio Fatebenefratelli'),(9004,7004,'en','name','Psychological Health Associates'),(9005,7005,'no_lang_code','name','SeraCare Life Sciences (United States)'),(9006,7006,'no_lang_code','name','TDIC (United States)'),(9007,7007,'en','name','National Museum of Ancient Art'),(9008,7007,'pt','name','Museu Nacional de Arte Antiga'),(9009,7008,'en','name','National Council for Science and the Environment'),(9010,7009,'no_lang_code','name','Minerva Biotechnologies (United States)'),(9011,7010,'en','name','Electric Power Research Institute'),(9012,7011,'en','name','Stepping Hill Hospital'),(9013,7012,'no_lang_code','name','Element Six (United Kingdom)'),(9014,7013,'en','name','New York Heart Research Foundation'),(9015,7014,'sr','name','Institut za Zdravstvenu Zastitu Majke i Deteta'),(9016,7015,'en','name','Amrith Educational and Cultural Society'),(9017,7016,'en','name','Del Mar College'),(9018,7017,'en','name','Kettering Foundation'),(9019,7018,'en','name','Glendale Community College'),(9020,7019,'en','name','Don Carlo Gnocchi Foundation'),(9021,7020,'en','name','American Cancer Society'),(9022,7021,'de','name','Barmherzige Brüder Klinikum St. Elisabeth in Straubing'),(9023,7022,'en','name','Oncology Nursing Society'),(9024,7023,'en','name','Mount Mercy University'),(9025,7024,'no_lang_code','name','Galen Research (United Kingdom)'),(9026,7025,'no_lang_code','name','Inframat Corporation (United States)'),(9027,7026,'en','name','Ontario AIDS Network'),(9028,7027,'no_lang_code','name','Ligand Pharmaceuticals (United States)'),(9029,7028,'no_lang_code','name','GT Urological (United States)'),(9030,7029,'no_lang_code','name','BioFormatix (United States)'),(9031,7030,'en','name','MUJHU Research Collaboration'),(9032,7031,'en','name','Mendez National Institute of Transplantation'),(9033,7032,'en','name','North Central College'),(9034,7033,'ar','name','مستشفى زايد العسكري'),(9035,7033,'en','name','Zayed Military Hospital'),(9036,7034,'en','name','Mercy Medical Center'),(9037,7035,'en','name','EuroEspes Biomedical Research Center'),(9038,7036,'fr','name','Cegep Edouard Montpetit, Collège Édouard-Montpetit'),(9039,7037,'en','name','Center for Renewable Energy Sources and Saving'),(9040,7038,'no_lang_code','name','Royan Institute'),(9041,7039,'en','name','Wartburg College'),(9042,7040,'en','name','Northwest Hospital and Medical Center'),(9043,7041,'en','name','Uijeongbu St. Mary\'s Hospital'),(9044,7042,'no_lang_code','name','Amgen (Germany)'),(9045,7043,'en','name','Fertility Medical Group'),(9046,7044,'no_lang_code','name','OG Technologies (United States)'),(9047,7045,'en','name','Adrian College'),(9048,7046,'no_lang_code','name','Luminex (Canada)'),(9049,7047,'no_lang_code','name','CleverSys (United States)'),(9050,7048,'en','name','Webb Institute'),(9051,7049,'no_lang_code','name','Blue Spurs (Canada)'),(9052,7050,'en','name','Coastline Community College'),(9053,7051,'no_lang_code','name','Regeneron (United States)'),(9054,7052,'en','name','Tamworth Hospital'),(9055,7053,'en','name','Presentation College'),(9056,7054,'en','name','Transitional Learning Center'),(9057,7055,'de','name','Deutsches Primatenzentrum'),(9058,7055,'en','name','German Primate Center'),(9059,7056,'en','name','Randolph College'),(9060,7057,'en','name','Shanghai Research Center for Acupuncture and Meridians'),(9061,7057,'zh','name','上海市针灸经络研究中心'),(9062,7058,'no_lang_code','name','Fluorous Technologies (United States)'),(9063,7059,'no_lang_code','name','Degenkolb (United States)'),(9064,7060,'en','name','National Nutrition and Food Technology Research Institute'),(9065,7061,'no_lang_code','name','Endres Machining Innovations (United States)'),(9066,7062,'no_lang_code','name','X-ray Instrumentation Associates (United States)'),(9067,7063,'no_lang_code','name','Delcam (United Kingdom)'),(9068,7064,'no_lang_code','name','Affinity Water (United Kingdom)'),(9069,7065,'en','name','Wangjing Hospital of China Academy of Chinese Medical Sciences'),(9070,7065,'zh','name','中国中医科学院望京医院'),(9071,7066,'en','name','Kentucky Wesleyan College'),(9072,7067,'no_lang_code','name','FoodChek Systems (Canada)'),(9073,7068,'it','name','CTO Andrea Alesini'),(9074,7069,'en','name','UK Biobank'),(9075,7070,'en','name','Tung Wah Eastern Hospital'),(9076,7070,'zh','name','東華東院'),(9077,7071,'no_lang_code','name','Organisation de Coordination pour la lutte contre les Endémies en Afrique Centrale'),(9078,7072,'en','name','Heritage Foundation'),(9079,7073,'en','name','Discovery Centre'),(9080,7074,'no_lang_code','name','Curis (United States)'),(9081,7075,'en','name','Global Neuroscience Initiative Foundation'),(9082,7076,'es','name','Instituto Zaldivar'),(9083,7077,'no_lang_code','name','Dr. Reddy\'s Laboratories (United Kingdom)'),(9084,7078,'en','name','Community Based Research Centre'),(9085,7079,'el','name','ΩΝΑΣΕΙΟ ΚΑΡΔΙΟΧΕΙΡΟΥΡΓΙΚΟ ΚΕΝΤΡΟ'),(9086,7079,'en','name','Onassis Cardiac Surgery Center'),(9087,7080,'en','name','Saint Joseph\'s College of Maine'),(9088,7081,'en','name','Royal Society of Medicine'),(9089,7082,'no_lang_code','name','DCS Corporation (United States)'),(9090,7083,'ja','name','津山中央病院'),(9091,7083,'no_lang_code','name','Tsuyama Chuo Hospital'),(9092,7084,'en','name','Ofwat'),(9093,7085,'en','name','Shriners Hospitals for Children - Erie'),(9094,7086,'no_lang_code','name','Optra (United States)'),(9095,7087,'en','name','Thai Red Cross Society'),(9096,7088,'no_lang_code','name','Medigen (United States)'),(9097,7089,'no_lang_code','name','Koester Performance Research (United States)'),(9098,7090,'no_lang_code','name','Tissue Genesis (United States)'),(9099,7091,'no_lang_code','name','M-Solv (United Kingdom)'),(9100,7092,'no_lang_code','name','Aecom (United States)'),(9101,7093,'hu','name','Toldy Ferenc Kórház'),(9102,7094,'en','name','American Dental Education Association'),(9103,7095,'en','name','Everett Community College'),(9104,7096,'no_lang_code','name','bioMérieux (United States)'),(9105,7097,'no_lang_code','name','Laing O\'Rourke (United Kingdom)'),(9106,7098,'en','name','St. Anthony Hospital'),(9107,7099,'en','name','Association of State Supervisors of Mathematics'),(9108,7100,'no_lang_code','name','Mohawk Innovative Technology (United States)'),(9109,7101,'en','name','Brain Trauma Foundation'),(9110,7102,'fr','name','Centre National Hospitalier et Universitaire Hubert Koutoukou MAGA'),(9111,7103,'en','name','Matsudo City Hospital'),(9112,7103,'ja','name','松戸市立病院'),(9113,7104,'no_lang_code','name','Spencer Technologies (United States)'),(9114,7105,'de','name','Max-Planck-Institut für Hirnforschung'),(9115,7105,'en','name','Max Planck Institute for Brain Research'),(9116,7106,'en','name','Monterey County Health Department'),(9117,7107,'en','name','St Vincent Medical Center'),(9118,7108,'en','name','Contra Costa Health Services'),(9119,7109,'en','name','American College of Medical Genetics'),(9120,7110,'en','name','St. Luke\'s Medical Center'),(9121,7111,'nl','name','Vincent Van Gogh Voor Geestelijke Gezondheidszorg'),(9122,7112,'en','name','Okayama Red Cross General Hospital'),(9123,7112,'ja','name','岡山赤十字病院'),(9124,7113,'no_lang_code','name','Crinetics Pharmaceuticals (United States)'),(9125,7114,'en','name','Georgia Department of Community Health'),(9126,7115,'no_lang_code','name','Educational Film Center (United States)'),(9127,7116,'en','name','AARP'),(9128,7117,'en','name','United Hospital'),(9129,7118,'no_lang_code','name','NewsHour Productions (United States)'),(9130,7119,'ja','name','サッポロホールディングス'),(9131,7119,'no_lang_code','name','Sapporo Holdings (Japan)'),(9132,7120,'en','name','Northwick Park Institute for Medical Research'),(9133,7121,'en','name','Dumfries and Galloway Royal Infirmary'),(9134,7122,'no_lang_code','name','Covance (United States)'),(9135,7123,'no_lang_code','name','American Superconductor (United States)'),(9136,7124,'no_lang_code','name','Medtronic (Netherlands)'),(9137,7125,'no_lang_code','name','MRF Geosystems (Canada)'),(9138,7126,'en','name','National Institute of Health'),(9139,7126,'it','name','Istituto Superiore di Sanità'),(9140,7127,'no_lang_code','name','A4F-Algafuel (Portugal)'),(9141,7128,'no_lang_code','name','Creatv MicroTech (United States)'),(9142,7129,'en','name','Princeton Baptist Medical Center'),(9143,7130,'en','name','Clinical Trial Investigators'),(9144,7131,'en','name','Central Veterinary Research Laboratory'),(9145,7132,'no_lang_code','name','Prentke Romich Company (United States)'),(9146,7133,'en','name','AIDS and Clinical Immunology Research Center'),(9147,7134,'fa','name','پژوهشگاه صنعت نفت'),(9148,7134,'no_lang_code','name','National Iranian Oil Company (Iran)'),(9149,7135,'en','name','Vivekananda Institute of Medical Sciences'),(9150,7136,'en','name','Institute of Dermatology'),(9151,7136,'th','name','สถาบันโรคผิวหนัง'),(9152,7137,'no_lang_code','name','FONA International (Canada)'),(9153,7138,'en','name','Woodend Hospital'),(9154,7139,'en','name','Immunization Action Coalition'),(9155,7140,'en','name','Connecticut Pre Engineering Program'),(9156,7141,'en','name','Corporation for National Research Initiatives'),(9157,7142,'el','name','Μπενάκειο Φυτοπαθολογικό Ινστιτούτο'),(9158,7142,'en','name','Benaki Phytopathological Institute'),(9159,7143,'en','name','Broward College'),(9160,7144,'en','name','Ministry of Foreign Affairs and International Cooperation'),(9161,7144,'it','name','Ministero degli Affari Esteri'),(9162,7145,'en','name','Department of Agriculture and Food Western Australia'),(9163,7146,'en','name','Centre for Chronic Disease Control'),(9164,7147,'fr','name','Cegep regional de Lanaudiere, Cégep Régional de Lanaudière'),(9165,7148,'no_lang_code','name','Sinmat (United States)'),(9166,7149,'no_lang_code','name','Takara (United States)'),(9167,7150,'en','name','Matsuyama Red Cross Hospital'),(9168,7150,'ja','name','松山赤十字病院'),(9169,7151,'no_lang_code','name','Policy Analysis (United States)'),(9170,7152,'no_lang_code','name','Ondine Biopharma (United States)'),(9171,7153,'en','name','National Institute on Alcohol Abuse and Alcoholism'),(9172,7154,'en','name','Institute of Human Genetics'),(9173,7154,'pl','name','Instytutu Genetyki Człowieka PAN'),(9174,7155,'en','name','Academy of Scientific Research and Technology'),(9175,7156,'en','name','Matrix Institute on Addictions'),(9176,7157,'no_lang_code','name','BioDetection Instruments (United States)'),(9177,7158,'en','name','PRA Health Sciences'),(9178,7159,'no_lang_code','name','Analiza (United States)'),(9179,7160,'en','name','Saskatchewan Seniors Mechanism'),(9180,7161,'en','name','Blackfeet Community College'),(9181,7162,'en','name','American Academy of Family Physicians'),(9182,7163,'no_lang_code','name','United Environment and Energy (United States)'),(9183,7164,'en','name','National Institute of Oncology'),(9184,7165,'en','name','United Tribes Technical College'),(9185,7166,'en','name','Central Leather Research Institute'),(9186,7167,'no_lang_code','name','Telesage (United States)'),(9187,7168,'fr','name','Château Gombert'),(9188,7169,'en','name','Computer History Museum'),(9189,7170,'no_lang_code','name','Hartley & Associates'),(9190,7171,'en','name','European School of Oncology'),(9191,7172,'no_lang_code','name','Certara (United States)'),(9192,7173,'en','name','Zhejiang Hospital'),(9193,7173,'zh','name','浙江医院'),(9194,7174,'en','name','Diabetes Care Center'),(9195,7175,'no_lang_code','name','Prodrive (United Kingdom)'),(9196,7176,'en','name','Centenary College of Louisiana'),(9197,7177,'no_lang_code','name','Concepts NREC (United States)'),(9198,7178,'no_lang_code','name','EEI Communications (United States)'),(9199,7179,'en','name','European Committee of Professional Diving Instructors'),(9200,7179,'fr','name','Comité Européen des Instructeurs de Plongée Professionnels'),(9201,7180,'en','name','Navajo Nation Division of Health'),(9202,7181,'fr','name','Cegep de La Pocatiere, Cégep de la pocatière'),(9203,7182,'no_lang_code','name','CytRx (United States)'),(9204,7183,'ja','name','一般財団法人住友病院'),(9205,7183,'no_lang_code','name','Sumitomo Hospital'),(9206,7184,'fr','name','Fondation Ophtalmologique Adolphe de Rothschild'),(9207,7185,'en','name','National Center for Biotechnology Information'),(9208,7186,'no_lang_code','name','Digital Payment Technologies (Canada)'),(9209,7187,'en','name','Critical Path Institute'),(9210,7188,'no_lang_code','name','Fermalogic (United States)'),(9211,7189,'en','name','Wiley College'),(9212,7190,'en','name','Zhujiang Hospital'),(9213,7191,'en','name','Turtle Mountain Community College'),(9214,7192,'no_lang_code','name','Applied Thin Films (United States)'),(9215,7193,'en','name','Framingham State University'),(9216,7193,'fr','name','Université d\'État de framingham'),(9217,7194,'en','name','Daejeon Sun Hospital'),(9218,7194,'ko','name','대전선병원'),(9219,7195,'en','name','National Institute of Neurology Mongi-Ben Hamida'),(9220,7195,'fr','name','Institut National de Neurologie Mongi-Ben Hamida'),(9221,7196,'no_lang_code','name','Parirenyatwa Hospital'),(9222,7197,'en','name','Association Vinçotte Nuclear, Nuclear Safety Institute'),(9223,7198,'it','name','Consorzio per la Ricerca e l\'Educazione Permanente'),(9224,7199,'no_lang_code','name','Xemed (United States)'),(9225,7200,'no_lang_code','name','Bioanalytical Systems (United States)'),(9226,7201,'en','name','Canadian Association of Psychosocial Oncology'),(9227,7202,'no_lang_code','name','Junk King (United States)'),(9228,7203,'no_lang_code','name','SRA International (United States)'),(9229,7204,'no_lang_code','name','Pearson (United States)'),(9230,7205,'en','name','Lady of Mercy Medical Center'),(9231,7206,'no_lang_code','name','Innovative Chemical and Environmental Technologies (United States)'),(9232,7207,'en','name','Pittsburgh Public Schools'),(9233,7208,'en','name','DHHS Alliance'),(9234,7209,'en','name','Hull Royal Infirmary'),(9235,7210,'en','name','Institute of Problems of Chemical Physics'),(9236,7210,'ru','name','Институт проблем химической физики'),(9237,7211,'en','name','Air & Waste Management Association'),(9238,7212,'en','name','City Eye Centre'),(9239,7213,'es','name','Instituto Venezolano de Investigaciones Científicas'),(9240,7214,'en','name','Wycombe General Hospital'),(9241,7215,'en','name','American Society of Hematology'),(9242,7216,'en','name','American International College'),(9243,7217,'no_lang_code','name','Simulations Plus (United States)'),(9244,7218,'en','name','DGA Partners'),(9245,7219,'no_lang_code','name','Insilicos (United States)'),(9246,7220,'en','name','Mount Wachusett Community College'),(9247,7221,'fr','name','Cégep de l\'Abitibi Témiscamingue, Cégep de l\'abitibi-témiscamingue'),(9248,7222,'en','name','National Vital Statistics System'),(9249,7223,'no_lang_code','name','Actian (United States)'),(9250,7224,'de','name','Klinikum Lippe'),(9251,7225,'no_lang_code','name','Affinergy (United States)'),(9252,7226,'no_lang_code','name','HBP (United States)'),(9253,7227,'no_lang_code','name','BioSense (United States)'),(9254,7228,'be','name','Институт тепло- и массообмена имени А.В. Лыкова Национальной академии наук Беларуси'),(9255,7228,'en','name','A.V. Luikov Heat and Mass Transfer Institute'),(9256,7229,'no_lang_code','name','Aridis Pharmaceuticals (United States)'),(9257,7230,'en','name','Theda Clark Medical Center'),(9258,7231,'en','name','Hastings Center'),(9259,7232,'en','name','Aliviane'),(9260,7233,'en','name','American Foundation for Donation and Transplantation'),(9261,7234,'en','name','Texas State Technical College Waco'),(9262,7235,'no_lang_code','name','AntiCancer (United States)'),(9263,7236,'en','name','Holon Institute of Technology'),(9264,7237,'en','name','National Action Council for Minorities in Engineering'),(9265,7238,'fr','name','Groupe Hospitalier du Havre'),(9266,7239,'fr','name','Centre Jean Perrin'),(9267,7240,'no_lang_code','name','DxRay (United States)'),(9268,7241,'no_lang_code','name','Sensor Research and Development Corporation (United States)'),(9269,7242,'en','name','Taos Orthopaedic Institute'),(9270,7243,'en','name','Environmental Mutagenesis and Genomics Society'),(9271,7244,'en','name','Cooperative Research Centre for Tissue Growth and Repair'),(9272,7245,'en','name','Aberdeen Royal Infirmary'),(9273,7246,'en','name','Peterborough City Hospital'),(9274,7247,'no_lang_code','name','Akina (United States)'),(9275,7248,'en','name','Diablo Valley College'),(9276,7249,'en','name','Kobe City College of Technology'),(9277,7249,'ja','name','神戸市立工業高等専門学校'),(9278,7250,'no_lang_code','name','Real Time Analyzers (United States)'),(9279,7251,'en','name','Royal Institution of Chartered Surveyors'),(9280,7252,'no_lang_code','name','Gold Standard Simulations (United Kingdom)'),(9281,7253,'no_lang_code','name','Tornado Spectral Systems (Canada)'),(9282,7254,'ro','name','Institutul Cantacuzino'),(9283,7255,'no_lang_code','name','AiCure (United States)'),(9284,7256,'en','name','Connecticut Department of Children and Families'),(9285,7257,'en','name','Iowa Lakes Community College'),(9286,7258,'no_lang_code','name','Immersion (United States)'),(9287,7259,'en','name','Mason Parks & Recreation Foundation'),(9288,7260,'no_lang_code','name','Natus (United States)'),(9289,7261,'en','name','North Jersey Community Research Initiative'),(9290,7262,'en','name','JMI Laboratories'),(9291,7263,'en','name','Confederation of European Forest Owners'),(9292,7264,'en','name','The Eastman Institute'),(9293,7264,'sv','name','Eastmaninstitutet'),(9294,7265,'no_lang_code','name','FJE Enterprises (United States)'),(9295,7266,'it','name','Ospedale Sant\'Orsola di Brescia'),(9296,7267,'no_lang_code','name','Vista Scientific (United States)'),(9297,7268,'no_lang_code','name','Intel (Ireland)'),(9298,7269,'no_lang_code','name','Qiagen (Germany)'),(9299,7270,'no_lang_code','name','Wright Medical Technology (United States)'),(9300,7271,'en','name','Max Planck Florida Institute for Neuroscience'),(9301,7272,'no_lang_code','name','Platypus Technologies (United States)'),(9302,7273,'en','name','Emmanuel College - Massachusetts'),(9303,7274,'en','name','Overseas Development Institute'),(9304,7275,'en','name','Moraine Valley Community College'),(9305,7276,'no_lang_code','name','Apath (United States)'),(9306,7277,'en','name','Alaska Department of Fish and Game'),(9307,7278,'en','name','NatureServe'),(9308,7279,'en','name','Press Ganey'),(9309,7280,'no_lang_code','name','Uken (Canada)'),(9310,7281,'en','name','St Vincent\'s Clinic'),(9311,7282,'no_lang_code','name','Glyndwr Innovations (United Kingdom)'),(9312,7283,'no_lang_code','name','Wright Materials Research (United States)'),(9313,7284,'no_lang_code','name','D. E. Shaw Research'),(9314,7285,'en','name','Sunderland Royal Hospital'),(9315,7286,'en','name','Varberg Hospital'),(9316,7286,'sv','name','Hallands Sjukhus Varberg'),(9317,7287,'en','name','Eastern Oklahoma State College'),(9318,7288,'no_lang_code','name','Nokia (Portugal)'),(9319,7289,'no_lang_code','name','VenatoRx Pharmaceuticals (United States)'),(9320,7290,'no_lang_code','name','HemoShear (United States)'),(9321,7291,'no_lang_code','name','DeltaQuest Foundation (United States)'),(9322,7292,'en','name','Spinal Diagnostics and Treatment Center'),(9323,7293,'no_lang_code','name','Dawkins Productions (United States)'),(9324,7294,'en','name','Regional Hospital of Bellinzona and Valleys'),(9325,7294,'it','name','Ospedale Regionale di Bellinzona e Valli'),(9326,7295,'en','name','Valley Breast Care & Woman\'s Health Center'),(9327,7296,'en','name','Waynesburg University'),(9328,7297,'no_lang_code','name','Active Motif (United States)'),(9329,7298,'en','name','Inova Children\'s Hospital'),(9330,7299,'no_lang_code','name','Applied Human Factors (United States)'),(9331,7300,'en','name','Institute of Materials Research and Engineering'),(9332,7301,'no_lang_code','name','AFC Energy (United Kingdom)'),(9333,7302,'no_lang_code','name','SynZyme Technologies (United States)'),(9334,7303,'en','name','California Family Health Council'),(9335,7304,'no_lang_code','name','Wicab (United States)'),(9336,7305,'en','name','Western Consortium for Public Health'),(9337,7306,'en','name','Podiatry Institute'),(9338,7307,'no_lang_code','name','Oxonica (United Kingdom)'),(9339,7308,'en','name','Trafford General Hospital'),(9340,7309,'en','name','National Institute for Women in Trades, Technology & Sciences'),(9341,7310,'no_lang_code','name','Membrane Reactor Technologies (Canada)'),(9342,7311,'en','name','St. Charles Medical Center'),(9343,7312,'en','name','Victoria Hospital'),(9344,7313,'en','name','National Acoustic Laboratories'),(9345,7314,'en','name','Pain Management Center of Paducah'),(9346,7315,'no_lang_code','name','Manhattan Scientifics (United States)'),(9347,7316,'no_lang_code','name','ArmaGen (United States)'),(9348,7317,'en','name','New England College of Optometry'),(9349,7318,'en','name','Burdenko Neurosurgery Institute'),(9350,7318,'ru','name','Федеральное государственное автономное учреждение Научно-исследовательский институт нейрохирургии имени академика Н.Н. Бурденко Министерства здравоохранения Российской Федерации'),(9351,7319,'en','name','Palm Beach State College'),(9352,7320,'en','name','Rust College'),(9353,7321,'no_lang_code','name','Photozig (United States)'),(9354,7322,'en','name','Connecticut Agricultural Experiment Station'),(9355,7323,'no_lang_code','name','Minnetronix (United States)'),(9356,7324,'en','name','City of Edinburgh Council'),(9357,7325,'en','name','Peninsula Regional Medical Center'),(9358,7326,'en','name','Centerforce'),(9359,7327,'en','name','Dartmouth Psychiatric Research Center'),(9360,7328,'no_lang_code','name','Mirna Therapeutics (United States)'),(9361,7329,'no_lang_code','name','Corning (United States)'),(9362,7330,'en','name','Allegany College of Maryland'),(9363,7331,'no_lang_code','name','Danaher (United States)'),(9364,7332,'en','name','National Eisteddfod of Wales'),(9365,7333,'it','name','Fondazione Ospedale Salesi'),(9366,7334,'no_lang_code','name','En\'Urga (United States)'),(9367,7335,'no_lang_code','name','International Severity Information Systems (United States)'),(9368,7336,'en','name','William Harvey Hospital'),(9369,7337,'ca','name','Institut Municipal d\'Assistència Sanitària'),(9370,7338,'no_lang_code','name','Agilent Technologies (United States)'),(9371,7339,'en','name','National Association of Biology Teachers'),(9372,7340,'no_lang_code','name','Plantvax (United States)'),(9373,7341,'no_lang_code','name','Chem-Space Associates (United States)'),(9374,7342,'en','name','West Suffolk Hospital'),(9375,7343,'no_lang_code','name','dbaza health (United States)'),(9376,7344,'en','name','Electrical and Computer Engineering Department Heads Association'),(9377,7345,'en','name','Piedmont Virginia Community College'),(9378,7346,'de','name','Leibniz-Institut DSMZ-Deutsche Sammlung von Mikroorganismen und Zellkulturen'),(9379,7346,'en','name','Leibniz Institute DSMZ – German Collection of Microorganisms and Cell Cultures'),(9380,7347,'no_lang_code','name','Aston Martin Lagonda (United Kingdom)'),(9381,7348,'en','name','All Africa Leprosy Tuberculosis and Rehabilitation Training Centre'),(9382,7349,'ja','name','汐田総合病院'),(9383,7349,'no_lang_code','name','Shioda General Hospital'),(9384,7350,'en','name','Royal Albert Edward Infirmary'),(9385,7351,'fr','name','Centre hospitalier Etterbeek-Ixelles'),(9386,7352,'ja','name','大鵬薬品工業'),(9387,7352,'no_lang_code','name','Taiho Pharmaceutical (Japan)'),(9388,7353,'en','name','Institute of Liver and Biliary Sciences'),(9389,7354,'no_lang_code','name','Intelligent Fiber Optic Systems (United States)'),(9390,7355,'no_lang_code','name','Ametek (United States)'),(9391,7356,'en','name','Sea Education Association'),(9392,7357,'en','name','CGH Medical Center'),(9393,7358,'en','name','Campbell Clinic'),(9394,7359,'no_lang_code','name','Avacta (United Kingdom)'),(9395,7360,'no_lang_code','name','Verizon (United States)'),(9396,7361,'en','name','Project HOPE'),(9397,7362,'en','name','Institute of Evolutionary Physiology and Biochemistry'),(9398,7362,'ru','name','Федеральное государственное бюджетное учреждение науки Институт эволюционной физиологии и биохимии им. И.М. Сеченова Российской академии наук'),(9399,7363,'en','name','Lynn Health Science Institute'),(9400,7364,'en','name','New Mexico Department of Human Services'),(9401,7365,'en','name','Freshwater Fisheries Society of BC'),(9402,7366,'en','name','United Christian Hospital'),(9403,7367,'no_lang_code','name','SciTech Development (United States)'),(9404,7368,'bg','name','национална многопрофилна транспортна болница цар борис ііі'),(9405,7368,'en','name','National Transport Hospital \"Tzar Boris III\"'),(9406,7369,'no_lang_code','name','Synergy Enterprises (United States)'),(9407,7370,'no_lang_code','name','4D Soft (Hungary)'),(9408,7371,'en','name','International Society for Infectious Diseases'),(9409,7372,'en','name','Centre for Infectious Disease Research in Zambia'),(9410,7373,'no_lang_code','name','Fusion (United States)'),(9411,7374,'en','name','Latvian Academy of Sciences'),(9412,7375,'en','name','Interstate Shellfish Sanitation Conference'),(9413,7376,'es','name','Centro Medico Nacional Siglo XXI'),(9414,7377,'no_lang_code','name','InterDigital (United States)'),(9415,7378,'no_lang_code','name','PhysioGenix (United States)'),(9416,7379,'en','name','Forum for the Future'),(9417,7380,'de','name','Universitäts-Herzzentrum Freiburg-Bad Krozingen'),(9418,7380,'en','name','University Heart Center Freiburg'),(9419,7381,'en','name','Philippe Pinel Institute'),(9420,7381,'fr','name','Institut Philippe Pinel de Montréal'),(9421,7382,'ja','name','千葉県脳血管センタ'),(9422,7382,'no_lang_code','name','Chiba Cerebral and Cardiovascular Center'),(9423,7383,'en','name','Suita Municipal Hospital'),(9424,7383,'ja','name','市立吹田市民病院'),(9425,7384,'en','name','Association of Dutch Burn Centres'),(9426,7384,'nl','name','Vereniging Samenwerkende Brandwondencentra'),(9427,7385,'no_lang_code','name','Schafer Corporation (United States)'),(9428,7386,'en','name','Jerusalem Mental Health Center'),(9429,7386,'he','name','המרכז לבריאות הנפש ירושלים'),(9430,7387,'no_lang_code','name','Learning in Motion (United States)'),(9431,7388,'no_lang_code','name','QM Power (United States)'),(9432,7389,'no_lang_code','name','Social Solutions International (United States)'),(9433,7390,'no_lang_code','name','Biomomentum (Canada)'),(9434,7391,'fr','name','Service Régional Vaudois de Transfusion Sanguine'),(9435,7392,'en','name','Notre Dame College'),(9436,7393,'pt','name','Instituto Adolfo Lutz'),(9437,7394,'de','name','Herz- und Diabeteszentrum Nordrhein-Westfalen'),(9438,7394,'en','name','Heart and Diabetes Center North Rhine-Westphalia'),(9439,7395,'en','name','Takatsuki Red Cross Hospital'),(9440,7395,'ja','name','高槻赤十字病院'),(9441,7396,'no_lang_code','name','DNA Polymerase Technology (United States)'),(9442,7397,'no_lang_code','name','ParaTechs (United States)'),(9443,7398,'no_lang_code','name','Montserrat Volcano Observatory'),(9444,7399,'no_lang_code','name','Inflazyme (Canada)'),(9445,7400,'en','name','Spanish Centre for Pharmacoepidemiologic Research'),(9446,7400,'es','name','Centro Español de Investigación Farmacoepidemiológica'),(9447,7401,'en','name','Botanical Research Institute of Texas'),(9448,7402,'no_lang_code','name','Dynamic Graphics (United States)'),(9449,7403,'no_lang_code','name','Colibri Software (Canada)'),(9450,7404,'en','name','Grand Forks Human Nutrition Research Center'),(9451,7405,'no_lang_code','name','Chemring Technology Solutions (United Kingdom)'),(9452,7406,'no_lang_code','name','Carepayment (United States)'),(9453,7407,'en','name','National Association of State Boards of Education'),(9454,7408,'en','name','Transcultural Mental Health Institute'),(9455,7409,'en','name','Ann Becker and Associates'),(9456,7410,'en','name','Hampton VA Medical Center'),(9457,7411,'no_lang_code','name','CASI Pharmaceuticals (United States)'),(9458,7412,'en','name','San Jacinto College'),(9459,7413,'ja','name','山形県立中央病院'),(9460,7413,'no_lang_code','name','Yamagata Prefectural Central Hospital'),(9461,7414,'no_lang_code','name','XRSciences (United States)'),(9462,7415,'no_lang_code','name','Bio Products Laboratory (United Kingdom)'),(9463,7416,'en','name','American Board of Emergency Medicine'),(9464,7417,'no_lang_code','name','Consarc Design Group (United Kingdom)'),(9465,7418,'en','name','LaserVision'),(9466,7419,'no_lang_code','name','Intelligent Mechatronic Systems (Canada)'),(9467,7420,'fr','name','Hôpital de Ville-Évrard'),(9468,7421,'en','name','Wheeling Hospital'),(9469,7422,'it','name','Ospedale San Bassiano'),(9470,7423,'en','name','Southern College of Optometry'),(9471,7424,'no_lang_code','name','Ashwin-Ushas (United States)'),(9472,7425,'no_lang_code','name','Incom (United States)'),(9473,7426,'no_lang_code','name','XL Sci-Tech (United States)'),(9474,7427,'no_lang_code','name','Lifepharms (United States)'),(9475,7428,'no_lang_code','name','Cubist Pharmaceuticals (United States)'),(9476,7429,'fr','name','Neurocentre Magendie'),(9477,7430,'no_lang_code','name','HedgePath Pharmaceuticals (United States)'),(9478,7431,'en','name','Indian Institute of Management Bangalore'),(9479,7431,'hi','name','भारतीय प्रबंध संस्थान बेंगलूर'),(9480,7431,'kn','name','ಇಂಡಿಯನ್‌ ಇನ್‌ಸ್ಟಿಟ್ಯೂಟ್‌ ಆಫ್‌ ಮ್ಯಾನೇಜ್‌ಮೆಂಟ್‌ ಬೆಂಗಳೂರು'),(9481,7431,'ml','name','ഇന്ത്യൻ ഇൻസ്റ്റിറ്റ്യൂട്ട് ഓഫ് മാനേജ്‌മെന്റ്, ബാംഗ്ലൂർ'),(9482,7431,'ta','name','இந்திய மேலாண்மை கழகம் பெங்களூரு'),(9483,7431,'te','name','ఇండియన్ ఇన్‌స్టిట్యూట్ ఆఫ్ మేనేజ్‌మెంట్ బెంగుళూరు'),(9484,7432,'en','name','Fatima Mata National College'),(9485,7432,'ml','name','ഫാത്തിമ മാതാ നാഷണൽ കോളേജ്'),(9486,7433,'en','name','Children\'s Heart Center Nevada'),(9487,7434,'en','name','Telus World of Science'),(9488,7435,'en','name','MentorNet'),(9489,7436,'no_lang_code','name','Prognosys Biosciences (United States)'),(9490,7437,'en','name','Phoebe Putney Memorial Hospital'),(9491,7438,'no_lang_code','name','ImmuneXcite (United States)'),(9492,7439,'en','name','Canadian Council on Animal Care'),(9493,7440,'no_lang_code','name','Collagen Matrix (United States)'),(9494,7441,'en','name','Ohio County Behavioral Health Authorities'),(9495,7442,'no_lang_code','name','Life Prediction Technologies (Canada)'),(9496,7443,'en','name','Vokkaligara Sangha Dental College & Hospital'),(9497,7444,'en','name','Quebec Consortium for Industrial Bioprocess Research and Innovation'),(9498,7444,'fr','name','Consortium de Recherche et Innovations en Bioprocédés Industriels au Québec'),(9499,7445,'es','name','Profamilia'),(9500,7446,'no_lang_code','name','ABS Materials (United States)'),(9501,7447,'it','name','Gruppo di Ricerca Geriatrica'),(9502,7448,'fr','name','Fondation de Rothschild'),(9503,7449,'no_lang_code','name','Public Data Queries (United States)'),(9504,7450,'en','name','Russell Sage Foundation'),(9505,7451,'en','name','Western Pennsylvania Hospital'),(9506,7452,'no_lang_code','name','Pharis Biotec (Germany)'),(9507,7453,'en','name','Blast Theory'),(9508,7454,'en','name','Milwaukee Area Technical College'),(9509,7455,'en','name','Robert Wood Johnson Foundation'),(9510,7456,'en','name','Clinical Trials and Surveys Corporation'),(9511,7457,'en','name','American Indian Higher Education Consortium'),(9512,7458,'no_lang_code','name','Data Voice Exchange (United States)'),(9513,7459,'en','name','All-China Sports Federation'),(9514,7460,'en','name','Development Center for Biotechnology'),(9515,7461,'en','name','American Society for Cybernetics'),(9516,7462,'en','name','Central New Mexico Community College'),(9517,7463,'no_lang_code','name','Biomedical Frontiers (United States)'),(9518,7464,'no_lang_code','name','Epigen Biosciences (United States)'),(9519,7465,'no_lang_code','name','Quanser (Canada)'),(9520,7466,'no_lang_code','name','NovelMed Therapeutics (United States)'),(9521,7467,'no_lang_code','name','Infrared Fiber Systems (United States)'),(9522,7468,'en','name','CeMM Research Center for Molecular Medicine'),(9523,7469,'no_lang_code','name','Rockland Immunochemicals (United States)'),(9524,7470,'no_lang_code','name','Vancouver Enterprise Forum'),(9525,7471,'en','name','American Political Science Association'),(9526,7472,'en','name','Red River College'),(9527,7473,'no_lang_code','name','IPL (Canada)'),(9528,7474,'en','name','Warwick Hospital'),(9529,7475,'en','name','Mountain Home VA Healthcare System'),(9530,7476,'no_lang_code','name','Systex (United States)'),(9531,7477,'de','name','Institut für Klinische Forschung und Entwicklung'),(9532,7478,'sv','name','Länssjukhuset Sundsvall-Härnösand'),(9533,7479,'en','name','Tapestry Health'),(9534,7480,'en','name','Menorah Park Center for Senior Living'),(9535,7481,'en','name','Ministry of Agriculture, Forestry and Fisheries'),(9536,7481,'ja','name','農林水産省'),(9537,7482,'en','name','Ackerman Institute for the Family'),(9538,7483,'en','name','Hand and Wrist Center of Houston'),(9539,7484,'en','name','West Virginia High Technology Consortium Foundation'),(9540,7485,'en','name','Thompson Cancer Survival Center'),(9541,7486,'en','name','Cincinnati Eye Institute'),(9542,7487,'en','name','Institute of Immunology'),(9543,7488,'en','name','Applied Genetics Laboratories'),(9544,7489,'it','name','Casa di cura Pierangeli'),(9545,7490,'en','name','Medical Care Development'),(9546,7491,'en','name','Butte College'),(9547,7492,'en','name','Institute for Facial Esthetics'),(9548,7493,'no_lang_code','name','GlaxoSmithKline (Canada)'),(9549,7494,'en','name','Wuhan Asia Heart Hospital'),(9550,7494,'zh','name','武汉亚洲心脏病医院'),(9551,7495,'en','name','Education Training And Research'),(9552,7496,'en','name','Sussex Eye Hospital'),(9553,7497,'no_lang_code','name','CyberLogic (United States)'),(9554,7498,'no_lang_code','name','Thermo Fisher Scientific (Lithuania)'),(9555,7499,'no_lang_code','name','Interactive Drama (United States)'),(9556,7500,'no_lang_code','name','Seccuris (Canada)'),(9557,7501,'no_lang_code','name','JBS International (United States)'),(9558,7502,'no_lang_code','name','DNAtrix (United States)'),(9559,7503,'en','name','Northwick Park Hospital'),(9560,7504,'en','name','Carter Center'),(9561,7505,'en','name','Anderson Orthopaedic Clinic'),(9562,7506,'no_lang_code','name','RiboMed Biotechnologies (United States)'),(9563,7507,'en','name','International Laser Center'),(9564,7508,'no_lang_code','name','Proton OnSite (United States)'),(9565,7509,'no_lang_code','name','Aecom (United Kingdom)'),(9566,7510,'en','name','Uzsoki Hospital'),(9567,7510,'hu','name','Uzsoki Utcai Kórház'),(9568,7511,'en','name','Albertus Magnus College'),(9569,7512,'en','name','Hachinohe National College of Technology'),(9570,7512,'ja','name','八戸工業高等専門学校 庶務課'),(9571,7513,'no_lang_code','name','Orbis Biosciences (United States)'),(9572,7514,'en','name','Louisville Metabolic and Atherosclerosis Research Center'),(9573,7515,'no_lang_code','name','RAGT Seeds (United Kingdom)'),(9574,7516,'no_lang_code','name','Sun Pharma (India)'),(9575,7517,'no_lang_code','name','Sunovion (United States)'),(9576,7518,'no_lang_code','name','TomoWave Laboratories (United States)'),(9577,7519,'no_lang_code','name','Synageva BioPharma (United States)'),(9578,7520,'no_lang_code','name','PharmaSeq (United States)'),(9579,7521,'en','name','Massachusetts Eye Research and Surgery Institute'),(9580,7522,'en','name','Math Learning Center'),(9581,7523,'fr','name','Centre de Médecine Préventive'),(9582,7524,'en','name','Sheldon Jackson College'),(9583,7525,'el','name','Υπουργείο Δημόσιας Τάξης και Προστασίας του Πολίτη'),(9584,7525,'en','name','Ministry of Public Order and Citizen Protection'),(9585,7526,'no_lang_code','name','Peter Brett Associates'),(9586,7527,'en','name','Saskatchewan Health Quality Council'),(9587,7528,'no_lang_code','name','Gene Check (United States)'),(9588,7529,'en','name','DaVinci Institute'),(9589,7530,'en','name','Department of Justice'),(9590,7531,'no_lang_code','name','Sea Run Holdings (United States)'),(9591,7532,'en','name','Peru State College'),(9592,7533,'en','name','National Institute of Malaria Research'),(9593,7533,'hi','name','राष्ट्रीय मलेरिया अनुसंधान संस्थान'),(9594,7534,'de','name','Katholisches Klinikum Koblenz'),(9595,7535,'en','name','Bangur Institute of Neurosciences'),(9596,7536,'no_lang_code','name','Alexion Pharmaceuticals (United States)'),(9597,7537,'en','name','Centre for Interdisciplinary Research in Rehabilitation'),(9598,7537,'fr','name','Centre de Recherche Interdisciplinaire en Réadaptation'),(9599,7538,'no_lang_code','name','Dynex Semiconductor (United Kingdom)'),(9600,7539,'en','name','National Center for Healthy Housing'),(9601,7540,'no_lang_code','name','Radiant Creative Group'),(9602,7541,'fi','name','Kuopion Liikuntalääketieteen Tutkimuslaitos'),(9603,7542,'en','name','Indepth Network'),(9604,7543,'no_lang_code','name','Audiology (United States)'),(9605,7544,'no_lang_code','name','SoyMeds (United States)'),(9606,7545,'no_lang_code','name','Lakes Environmental (Canada)'),(9607,7546,'en','name','Waikato District Health Board'),(9608,7547,'en','name','St. Patrick\'s Hospital'),(9609,7548,'no_lang_code','name','InBios International (United States)'),(9610,7549,'no_lang_code','name','Caldic (Canada)'),(9611,7550,'en','name','Gordon-Conwell Theological Seminary'),(9612,7551,'no_lang_code','name','Hawaii Biotech (United States)'),(9613,7552,'ja','name','参天製薬株式会社'),(9614,7552,'no_lang_code','name','Santen (Japan)'),(9615,7553,'no_lang_code','name','Shifa Biomedical (United States)'),(9616,7554,'en','name','Cooperative Research Centre for Beef Genetic Technologies'),(9617,7555,'no_lang_code','name','Shasta Crystals (United States)'),(9618,7556,'en','name','Research Institute for Production Development'),(9619,7556,'ja','name','般財団法人生産開発科学研究所'),(9620,7557,'no_lang_code','name','State Volunteer Mutual Insurance (United States)'),(9621,7558,'en','name','IntraHealth International'),(9622,7559,'no_lang_code','name','Senecio Software (United States)'),(9623,7560,'nl','name','Zaans Medisch Centrum'),(9624,7561,'en','name','Syracuse VA Medical Center'),(9625,7562,'no_lang_code','name','AugmenTech (United States)'),(9626,7563,'no_lang_code','name','Lentigen Technology (United States)'),(9627,7564,'en','name','Otsu Red Cross Hospital'),(9628,7564,'ja','name','大津赤十字病院'),(9629,7565,'it','name','Ospedaliera di Piacenza'),(9630,7566,'en','name','Pittsburgh Tissue Engineering Initiative'),(9631,7567,'en','name','Southcentral Foundation'),(9632,7568,'no_lang_code','name','Intuitive Biosciences (United States)'),(9633,7569,'en','name','Green Valley High School'),(9634,7570,'en','name','Shriners Hospitals for Children - Chicago'),(9635,7571,'no_lang_code','name','Omicia (United States)'),(9636,7572,'no_lang_code','name','Cardiome (Canada)'),(9637,7573,'cy','name','Yr Archifau Cenedlaethol'),(9638,7573,'en','name','National Archives'),(9639,7574,'ja','name','群馬県済生会前橋病院'),(9640,7574,'no_lang_code','name','Gunma Saiseikai Maebashi Hospital'),(9641,7575,'en','name','California Institute for Regenerative Medicine'),(9642,7576,'it','name','Ospedale per gli Infermi'),(9643,7577,'no_lang_code','name','Polyglot Systems (United States)'),(9644,7578,'ja','name','大正製薬'),(9645,7578,'no_lang_code','name','Taisho Pharmaceutical (Japan)'),(9646,7579,'en','name','Cypress Health Region'),(9647,7580,'no_lang_code','name','Halsall (Canada)'),(9648,7581,'en','name','Park Nicollet Methodist Hospital'),(9649,7582,'en','name','Prestera Center'),(9650,7583,'no_lang_code','name','Unisys (United States)'),(9651,7584,'en','name','Ministry of Agriculture, Food and Rural Affairs'),(9652,7584,'fr','name','Ministère de l\'Agriculture, de l\'Alimenntation et des Affaires Rurales'),(9653,7585,'en','name','Alaska Department of Environmental Conservation'),(9654,7586,'en','name','Wentworth Douglass Hospital'),(9655,7587,'en','name','Dorn Research Institute'),(9656,7588,'en','name','OrthoCarolina'),(9657,7589,'no_lang_code','name','Evident Point (Canada)'),(9658,7590,'en','name','Rothamsted Research'),(9659,7591,'no_lang_code','name','InXsol (United States)'),(9660,7592,'en','name','Calhoun Community College'),(9661,7593,'no_lang_code','name','Copernicus Therapeutics (United States)'),(9662,7594,'no_lang_code','name','Precision Combustion (United States)'),(9663,7595,'en','name','Oklahoma Foundation for Digestive Research'),(9664,7596,'en','name','Marin Health and Human Services'),(9665,7597,'no_lang_code','name','eSpin Technologies (United States)'),(9666,7598,'cy','name','Amgueddfa Victoria ac Albert'),(9667,7598,'en','name','Victoria and Albert Museum'),(9668,7599,'no_lang_code','name','Educational Service Incorporation'),(9669,7600,'ja','name','行岡病院'),(9670,7600,'no_lang_code','name','Yukioka Hospital'),(9671,7601,'en','name','Aletheia House'),(9672,7602,'no_lang_code','name','Galderma (France)'),(9673,7603,'en','name','Royal Berkshire NHS Foundation Trust'),(9674,7604,'en','name','Bard College at Simon\'s Rock'),(9675,7605,'en','name','Dallas County Community College District'),(9676,7605,'es','name','Colegios Comunitarios del Condado de Dallas'),(9677,7606,'en','name','Academy for Educational Development'),(9678,7607,'en','name','Yokohama Municipal Citizen\'s Hospital'),(9679,7607,'ja','name','横浜市営市民病院'),(9680,7608,'no_lang_code','name','Rehabtek (United States)'),(9681,7609,'en','name','European Organisation for Research and Treatment of Cancer'),(9682,7609,'fr','name','Organisation européenne pour la recherche et le traitement du cancer'),(9683,7610,'en','name','Information and Communication Technologies Centre'),(9684,7611,'en','name','United States Food and Drug Administration'),(9685,7612,'en','name','Winchester Science Centre'),(9686,7613,'en','name','New York State Office of Alcoholism and Substance Abuse Services'),(9687,7614,'no_lang_code','name','Lineage Cell Therapeutics (United States)'),(9688,7615,'en','name','River Region Human Services'),(9689,7616,'en','name','American Occupational Therapy Association'),(9690,7617,'en','name','Dr. Daneshbod Labratory'),(9691,7618,'ar','name','مستشفى السلطان قابوس'),(9692,7618,'en','name','Sultan Qaboos Hospital'),(9693,7619,'no_lang_code','name','Canadian Green Tech (Canada)'),(9694,7620,'en','name','Trinity Washington University'),(9695,7620,'es','name','Universidad Trinity Washington'),(9696,7621,'no_lang_code','name','Clearpath Robotics (Canada)'),(9697,7622,'no_lang_code','name','System Biosciences (United States)'),(9698,7623,'en','name','Pakistan Institute of Medical Sciences'),(9699,7623,'ur','name','پاکستان طبی سائنس انسٹی ٹیوٹ'),(9700,7624,'no_lang_code','name','ImmuRx (United States)'),(9701,7625,'no_lang_code','name','Continental (Germany)'),(9702,7626,'en','name','Lorain County Community College'),(9703,7627,'en','name','Foundation for Research into Traditional Chinese Medicine'),(9704,7628,'no_lang_code','name','National Recovery Technologies (United States)'),(9705,7629,'no_lang_code','name','Scisys (United Kingdom)'),(9706,7630,'en','name','Sage College of Albany'),(9707,7631,'en','name','Scientific Consulting Group'),(9708,7632,'en','name','Trenton Psychiatric Hospital'),(9709,7633,'en','name','College of American Pathologists'),(9710,7634,'en','name','Shepherd Center'),(9711,7635,'en','name','Washington Adventist University'),(9712,7635,'fr','name','Université adventiste de washington'),(9713,7636,'en','name','M.G. Kholodny Institute of Botany'),(9714,7637,'en','name','Micro and Nanotechnology Innovation Centre'),(9715,7638,'no_lang_code','name','Bellus Health (Canada)'),(9716,7639,'no_lang_code','name','E.ON (United States)'),(9717,7640,'no_lang_code','name','MassTech (United States)'),(9718,7641,'no_lang_code','name','Urigen Pharmaceuticals (United States)'),(9719,7642,'en','name','Family and Medical Counseling Service'),(9720,7643,'en','name','Indiana Academy of Science'),(9721,7644,'en','name','United Engineering Foundation'),(9722,7645,'en','name','Association of Chief Police Officers'),(9723,7646,'no_lang_code','name','Geotechnical Observations (United Kingdom)'),(9724,7647,'en','name','American College of Physicians'),(9725,7648,'es','name','Instituto Nacional de Enfermedades Neoplásicas'),(9726,7649,'en','name','Tao Yuan General Hospital'),(9727,7649,'zh','name','桃園醫院'),(9728,7650,'no_lang_code','name','Nestlé (United States)'),(9729,7651,'en','name','Techniquest'),(9730,7652,'en','name','American Association of Blood Banks'),(9731,7653,'no_lang_code','name','Vion Pharmaceuticals (United States)'),(9732,7654,'no_lang_code','name','Human Computer Interaction (Switzerland)'),(9733,7655,'no_lang_code','name','Renewable Energy Systems (United States)'),(9734,7656,'en','name','Ministry of Manpower'),(9735,7656,'zh','name','新加坡人力部'),(9736,7657,'en','name','Dean McGee Eye Institute'),(9737,7658,'en','name','Institute of Contemporary Psychoanalysis'),(9738,7659,'no_lang_code','name','Compound Semiconductor Technologies (United Kingdom)'),(9739,7660,'en','name','Karnataka Veterinary Animal and Fisheries Sciences University'),(9740,7660,'ne','name','कर्नाटक वेटेरिनरी, मत्स्य पालन र पशु विज्ञान विश्वविद्यालय'),(9741,7661,'en','name','Academy for Science and Design'),(9742,7662,'en','name','Southern Nevada Health District'),(9743,7663,'no_lang_code','name','SFC Fluidics (United States)'),(9744,7664,'en','name','Bishop State Community College'),(9745,7665,'en','name','Bio Behavioral Institute'),(9746,7666,'no_lang_code','name','ProteinSimple (United States)'),(9747,7667,'en','name','Tyne and Wear Archives and Museums'),(9748,7668,'en','name','North American Primary Care Research Group'),(9749,7669,'en','name','Northwestern Medical Faculty Foundation'),(9750,7670,'pt','name','Centro Hospitalar de Lisboa Ocidental'),(9751,7671,'en','name','Shriners Hospitals for Children - Philadelphia'),(9752,7672,'en','name','United States Drug Testing Laboratories'),(9753,7673,'en','name','Institute for the Study of Learning and Expertise'),(9754,7674,'en','name','Yedikule Teaching Hospital'),(9755,7674,'tr','name','Yedikule Göğüs Hastalıkları ve Göğüs Cerrahisi Eğitim ve Araştırma Hastanesi'),(9756,7675,'it','name','Istituto Zooprofilattico Sperimentale della Sardegna'),(9757,7676,'no_lang_code','name','Optum (United States)'),(9758,7677,'en','name','National Institute of Rehabilitation'),(9759,7677,'es','name','Instituto Nacional de Rehabilitación'),(9760,7678,'en','name','Virginia Museum of Natural History'),(9761,7679,'en','name','Gunma Prefectural Cardiovascular Center'),(9762,7679,'ja','name','群馬県立心臓血管センター'),(9763,7680,'no_lang_code','name','ReproCELL (United States)'),(9764,7681,'no_lang_code','name','Jim Metzner Productions (United States)'),(9765,7682,'en','name','Alzheimer\'s Association'),(9766,7683,'ja','name','さいたま市立病院'),(9767,7683,'no_lang_code','name','Saitama Municipal Hospital'),(9768,7684,'en','name','Animal and Plant Health Agency'),(9769,7685,'en','name','Nyack Hospital'),(9770,7686,'no_lang_code','name','Kimberly-Clark (United States)'),(9771,7687,'en','name','Tri County Technical College'),(9772,7688,'no_lang_code','name','Synedgen (United States)'),(9773,7689,'no_lang_code','name','Global Convergence (United States)'),(9774,7690,'en','name','Guangzhou Institute of Dermatology'),(9775,7691,'en','name','Wishaw General Hospital'),(9776,7692,'sv','name','Centrallasarettet Växjö'),(9777,7693,'en','name','William Jewell College'),(9778,7694,'en','name','Royal Institution of Great Britain'),(9779,7695,'en','name','American Sports Medicine Institute'),(9780,7696,'no_lang_code','name','Biomedical Research Models (United States)'),(9781,7697,'no_lang_code','name','Amunix (United States)'),(9782,7698,'en','name','Ohta Nishinouchi Hospital'),(9783,7698,'ja','name','太田西ノ内病院'),(9784,7699,'en','name','Teaching Hospital Kandy'),(9785,7699,'si','name','මහනුවර ශික්ෂණ රෝහල'),(9786,7700,'en','name','William S. Middleton Memorial Veterans Hospital'),(9787,7701,'en','name','Chitose Institute of Science and Technology'),(9788,7701,'ja','name','千歳科学技術大学'),(9789,7702,'no_lang_code','name','Talaris Therapeutics (United States)'),(9790,7703,'en','name','West Park Healthcare Centre'),(9791,7704,'ja','name','東京都立松沢病院'),(9792,7704,'no_lang_code','name','Tokyo Metropolitan Matsuzawa Hospital'),(9793,7705,'no_lang_code','name','OEpic Semiconductors (United States)'),(9794,7706,'no_lang_code','name','Public Health Television (United States)'),(9795,7707,'en','name','Police Forensic Science Laboratory Dundee'),(9796,7708,'no_lang_code','name','Boston Scientific (United States)'),(9797,7709,'no_lang_code','name','Advaxis (United States)'),(9798,7710,'en','name','Middlesex County College'),(9799,7711,'de','name','Max-Planck-Institut für Kognitions- und Neurowissenschaften'),(9800,7711,'en','name','Max Planck Institute for Human Cognitive and Brain Sciences'),(9801,7712,'no_lang_code','name','Advanced Diamond Technologies (United States)'),(9802,7713,'en','name','Allegheny Valley Hospital'),(9803,7714,'no_lang_code','name','Cygnus (United States)'),(9804,7715,'ja','name','富士通株式会社'),(9805,7715,'no_lang_code','name','Fujitsu (Japan)'),(9806,7716,'no_lang_code','name','EMT Associates (United States)'),(9807,7717,'no_lang_code','name','Lockheed Martin Orincon (United States)'),(9808,7718,'en','name','CARE USA'),(9809,7719,'en','name','Western Attica General Hospital'),(9810,7720,'en','name','Centerstone'),(9811,7721,'no_lang_code','name','Alkermes (United States)'),(9812,7722,'en','name','Pacific Tower'),(9813,7723,'en','name','Sher Fertility'),(9814,7724,'en','name','Psychiatric Foundation of North Carolina'),(9815,7725,'en','name','Hydrologic Research Center'),(9816,7726,'ja','name','帝人株式会社'),(9817,7726,'no_lang_code','name','Teijin (Japan)'),(9818,7727,'en','name','D.F. Chebotarev Institute of Gerontology'),(9819,7727,'uk','name','Інститут геронтології ім. Д.Ф.Чеботарьова'),(9820,7728,'no_lang_code','name','AdipoGenix (United States)'),(9821,7729,'no_lang_code','name','Ciencia (United States)'),(9822,7730,'no_lang_code','name','Takeda (Norway)'),(9823,7731,'no_lang_code','name','Mantech (Canada)'),(9824,7732,'en','name','Las Vegas Institute'),(9825,7733,'en','name','University Teaching Hospital of Kigali'),(9826,7733,'fr','name','Centre Hospitalier Universitaire de Kigali'),(9827,7734,'no_lang_code','name','Norgen Biotek Corporation (Canada)'),(9828,7735,'en','name','Institute for Atomic and Molecular Physics'),(9829,7736,'no_lang_code','name','Viro Dynamics (United States)'),(9830,7737,'fr','name','Institut de Technologie Agroalimentaire'),(9831,7738,'en','name','Organization of American States'),(9832,7738,'es','name','Organización de los Estados Americanos'),(9833,7738,'fr','name','Organisation des États Américains'),(9834,7738,'pt','name','Organização dos Estados Americanos'),(9835,7739,'en','name','HealthCare Interactive'),(9836,7740,'no_lang_code','name','Stemmatters (Portugal)'),(9837,7741,'no_lang_code','name','Cooper and Company (United States)'),(9838,7742,'no_lang_code','name','United Utilities (United Kingdom)'),(9839,7743,'no_lang_code','name','Motorola (United Kingdom)'),(9840,7744,'en','name','Kenya Agricultural Research Institute'),(9841,7745,'en','name','McREL International'),(9842,7746,'en','name','National Audubon Society'),(9843,7747,'en','name','Bamfield Marine Sciences Centre'),(9844,7748,'en','name','Central Glass and Ceramic Research Institute'),(9845,7749,'en','name','Institute of Cellular and Intracellular Symbiosis'),(9846,7749,'ru','name','Федеральное государственное бюджетное учреждение науки Институт биофизики клетки Российской академии наук'),(9847,7750,'en','name','At Bristol'),(9848,7751,'fr','name','Centre hospitalier de Tulle'),(9849,7752,'en','name','Ono Clinic'),(9850,7752,'ja','name','小野クリニック'),(9851,7753,'no_lang_code','name','MedShape (United States)'),(9852,7754,'en','name','Korea Electronics Technology Institute'),(9853,7755,'en','name','T. D. Medical College'),(9854,7756,'en','name','Moss Rehabilitation Hospital'),(9855,7757,'en','name','Federal Correctional Institution Schuylkill'),(9856,7758,'no_lang_code','name','Novartis (United Kingdom)'),(9857,7759,'ja','name','高野病院'),(9858,7759,'no_lang_code','name','Takano Hospital'),(9859,7760,'en','name','Piedmont Technical College'),(9860,7761,'en','name','Linguistic Society of America'),(9861,7762,'en','name','Long Island Association for AIDS Care'),(9862,7763,'no_lang_code','name','AdvR (United States)'),(9863,7764,'en','name','Lynchburg Family Medicine'),(9864,7765,'ja','name','済生会宇都宮病院'),(9865,7765,'no_lang_code','name','Saiseikai Utsunomiya hospital'),(9866,7766,'en','name','Pelosi Medical Center'),(9867,7767,'en','name','Houston Institute for Clinical Research'),(9868,7768,'en','name','Saitama Cancer Center'),(9869,7768,'ja','name','埼玉県立がんセンター'),(9870,7769,'no_lang_code','name','Faraday Technology (United States)'),(9871,7770,'en','name','Valley Hospital Medical Center'),(9872,7771,'en','name','United States Pharmacopeial Convention'),(9873,7771,'es','name','Convención de la Farmacopea de Estados Unidos'),(9874,7772,'en','name','National JALMA Institute for Leprosy & Other Mycobacterial Diseases'),(9875,7773,'no_lang_code','name','Adrianor'),(9876,7774,'no_lang_code','name','Cortex Pharmaceuticals (United States)'),(9877,7775,'no_lang_code','name','BioPAL (United States)'),(9878,7776,'en','name','Education Coordinating Council'),(9879,7777,'it','name','Ospedale di Circolo di Busto Arsizio'),(9880,7778,'pt','name','Secretaria da Saúde'),(9881,7779,'no_lang_code','name','Hyperion Technologies (Canada)'),(9882,7780,'en','name','Coker College'),(9883,7781,'no_lang_code','name','Sommer Materials Research (United States)'),(9884,7782,'en','name','National Dairy Research Institute'),(9885,7782,'hi','name','राष्ट्रीय डेरी अनुसंधान संस्थान'),(9886,7783,'en','name','Institute of Molecular Genetics'),(9887,7783,'ru','name','Федеральное государственное бюджетное учреждение науки Институт молекулярной генетики Российской академии наук'),(9888,7784,'de','name','Max-Planck-Institut für Molekulare Genetik'),(9889,7784,'en','name','Max Planck Institute for Molecular Genetics'),(9890,7785,'no_lang_code','name','Germinal (United Kingdom)'),(9891,7786,'en','name','Entomological Society of America'),(9892,7787,'en','name','Council of State and Territorial Epidemiologists'),(9893,7788,'en','name','European Brain Research Institute'),(9894,7789,'en','name','Scotch Whisky Research Institute'),(9895,7790,'en','name','Bethel College - Kansas'),(9896,7791,'en','name','Family Medicine Residency of Idaho'),(9897,7792,'fr','name','Laboratoire National Henri Becquerel'),(9898,7793,'en','name','Headache Wellness Center'),(9899,7794,'no_lang_code','name','Genia Photonics (Canada)'),(9900,7795,'de','name','Universitätsklinikum Augsburg'),(9901,7795,'en','name','University Hospital Augsburg'),(9902,7796,'en','name','Baltimore City Community College'),(9903,7797,'de','name','Paul Gerhardt Diakonie'),(9904,7798,'no_lang_code','name','Dakota Technologies (United States)'),(9905,7799,'en','name','Liberty Science Center'),(9906,7800,'en','name','University of Utah Hospital'),(9907,7800,'es','name','Hospital de la Universidad de Utah'),(9908,7801,'no_lang_code','name','Epitope (United States)'),(9909,7802,'en','name','Society of General Internal Medicine'),(9910,7803,'en','name','Fleet Science Center'),(9911,7804,'en','name','Southern California Alcohol and Drug Programs'),(9912,7805,'en','name','Finnish Brain Research and Rehabilitation Center Neuron'),(9913,7806,'fr','name','Centre Hospitalier du Mans'),(9914,7807,'en','name','Susquehanna Health'),(9915,7808,'it','name','Centro Diagnostico Italiano'),(9916,7809,'en','name','Lyndon State College'),(9917,7810,'en','name','Boston Public Schools'),(9918,7811,'no_lang_code','name','Thermo Fisher Scientific (United Kingdom)'),(9919,7812,'en','name','College of Menominee Nation'),(9920,7813,'no_lang_code','name','Infosys (India)'),(9921,7814,'no_lang_code','name','Tsubame Rosai Hospital'),(9922,7815,'ja','name','沼津市立病院'),(9923,7815,'no_lang_code','name','Numazu City Hospital'),(9924,7816,'en','name','National Space Centre'),(9925,7817,'en','name','Association for Women in Science'),(9926,7818,'en','name','Wagner College'),(9927,7819,'fr','name','Cégep André Laurendeau, Cégep andré-laurendeau'),(9928,7820,'en','name','武田薬品工業株式会社, Takeda Yakuhin Kōgyō kabushiki gaisha'),(9929,7820,'no_lang_code','name','Takeda (United States)'),(9930,7821,'en','name','Bedford Institute of Oceanography'),(9931,7822,'en','name','Gwinnett Coalition for Health & Human Services'),(9932,7823,'es','name','Ministerio de Salud'),(9933,7824,'en','name','Armed Forces Institute of Pathology'),(9934,7825,'en','name','Yamaguchi Red Cross Hospital'),(9935,7825,'ja','name','山口赤十字病院'),(9936,7826,'en','name','Lyon College'),(9937,7827,'en','name','Wake Technical Community College'),(9938,7828,'no_lang_code','name','Scottish Water (United Kingdom)'),(9939,7829,'en','name','South Carolina Research Authority'),(9940,7830,'en','name','McMaster Children\'s Hospital'),(9941,7831,'en','name','Florida Department of Children and Families'),(9942,7832,'en','name','Women in Engineering ProActive Network'),(9943,7833,'no_lang_code','name','QR Pharma (United States)'),(9944,7834,'en','name','National Institute of Genetic Engineering and Biotechnology'),(9945,7834,'fa','name','پژوهشگاه ملي مهندسي ژنتيك و زيست فناوري'),(9946,7835,'en','name','Haymarket Center'),(9947,7836,'no_lang_code','name','IB Innovation Consortium (Italy)'),(9948,7837,'no_lang_code','name','Costain (United Kingdom)'),(9949,7838,'en','name','Greater Manchester Police'),(9950,7839,'no_lang_code','name','Morgan Stanley (United Kingdom)'),(9951,7840,'en','name','Bronx Veterans Medical Research Foundation'),(9952,7841,'en','name','Women\'s College Hospital'),(9953,7842,'en','name','Curry College'),(9954,7843,'en','name','Istanbul Eye Hospital'),(9955,7843,'tr','name','İstanbul Göz Hastanesi'),(9956,7844,'no_lang_code','name','3E (Belgium)'),(9957,7845,'no_lang_code','name','Vivo Biosciences (United States)'),(9958,7846,'no_lang_code','name','Walsh Group'),(9959,7847,'no_lang_code','name','CanAm Bioresearch (Canada)'),(9960,7848,'ja','name','株式会社資生堂'),(9961,7848,'no_lang_code','name','Shiseido Group (Japan)'),(9962,7849,'en','name','St. John\'s College'),(9963,7850,'no_lang_code','name','ArchieMD (United States)'),(9964,7851,'no_lang_code','name','XOMA (United States)'),(9965,7852,'no_lang_code','name','TimeDomain CVD (United States)'),(9966,7853,'no_lang_code','name','Arthur D. Little (United States)'),(9967,7854,'no_lang_code','name','Qinetiq (United States)'),(9968,7855,'no_lang_code','name','Agilent Technologies (United Kingdom)'),(9969,7856,'no_lang_code','name','VirRx (United States)'),(9970,7857,'en','name','Nagano College of Nursing'),(9971,7857,'ja','name','長野県看護大学'),(9972,7858,'en','name','Research Institute for Fragrance Materials'),(9973,7859,'no_lang_code','name','MPI Research (United States)'),(9974,7860,'en','name','Winter Haven Hospital'),(9975,7861,'en','name','Fraunhofer USA Center for Molecular Biotechnology'),(9976,7862,'no_lang_code','name','Agenus (United States)'),(9977,7863,'en','name','National Geophysical Research Institute'),(9978,7863,'hi','name','राष्ट्रीय भूभौतिकीय अनुसंधान संस्थान'),(9979,7863,'ml','name','നാഷണൽ ജിയോഫിസിക്കൽ റിസർച്ച് ഇൻസ്റ്റിറ്റ്യൂട്ട്,ഹൈദരാബാദ്'),(9980,7863,'te','name','జాతీయ భూభౌతిక పరిశోధనా సంస్థ'),(9981,7864,'es','name','Instituto de la Visión'),(9982,7865,'en','name','Bevill State Community College'),(9983,7866,'en','name','Tanzania Commission for Science and Technology'),(9984,7866,'sw','name','Tume ya Sayansi na Teknolojia Tanzania'),(9985,7867,'no_lang_code','name','Intelligent Energy (United Kingdom)'),(9986,7868,'no_lang_code','name','Materials and Systems Research (United States)'),(9987,7869,'en','name','Saint Louis Science Center'),(9988,7870,'en','name','Molecular Cardiology and Neuromuscular Institute'),(9989,7871,'no_lang_code','name','ProteoSys (Germany)'),(9990,7872,'en','name','Budker Institute of Nuclear Physics'),(9991,7872,'ru','name','Институт ядерной физики'),(9992,7873,'en','name','People’s University'),(9993,7874,'no_lang_code','name','MetroLaser (United States)'),(9994,7875,'en','name','St. Luke’s Boise Medical Center'),(9995,7876,'en','name','Tochigi Cancer Center'),(9996,7876,'ja','name','栃木県立がんセンター'),(9997,7877,'no_lang_code','name','DMetrix (United States)'),(9998,7878,'en','name','Guangxi Veterinary Research Institute'),(9999,7879,'ja','name','大阪府済生会吹田病院'),(10000,7879,'no_lang_code','name','Saiseikai Suita Hospital'),(10001,7880,'en','name','Wisconsin Department of Agriculture Trade and Consumer Protection'),(10002,7881,'da','name','Dansk Sundhedsinstitut, Dansk Sygehus Institut'),(10003,7882,'en','name','St. Francis Medical Center'),(10004,7883,'en','name','Quincy College'),(10005,7884,'en','name','Iowa Central Community College'),(10006,7885,'en','name','Orange County Healthcare Agency'),(10007,7886,'no_lang_code','name','iQmetrix (Canada)'),(10008,7887,'en','name','Center for Culture and Experience Economy'),(10009,7888,'fr','name','Clinique de la Défense'),(10010,7889,'en','name','Research Triangle Park Foundation'),(10011,7890,'no_lang_code','name','Critical Software (Portugal)'),(10012,7891,'no_lang_code','name','Syncrotronics Corporation (United States)'),(10013,7892,'en','name','Association for Institutional Research'),(10014,7893,'no_lang_code','name','Teva Pharmaceuticals (United States)'),(10015,7894,'no_lang_code','name','LightBridge Healthcare Research (United States)'),(10016,7895,'es','name','Corporación para Investigaciones Biológicas'),(10017,7896,'no_lang_code','name','Neocera (United States)'),(10018,7897,'en','name','St. Joseph Hospital'),(10019,7898,'ja','name','富士レビオ株式会社'),(10020,7898,'no_lang_code','name','Fujirebio (Japan)'),(10021,7899,'en','name','Vaccine & Gene Therapy Institute of Florida'),(10022,7900,'es','name','Fundación Santa Fe de Bogotá'),(10023,7901,'no_lang_code','name','Evans Analytical Group (United States)'),(10024,7902,'no_lang_code','name','Fillauer (United States)'),(10025,7903,'en','name','ECRI Institute'),(10026,7904,'da','name','Det Nationale Forskningscenter for Arbejdsmiljø'),(10027,7904,'en','name','National Research Centre for the Working Environment'),(10028,7905,'en','name','Basic NWFL'),(10029,7906,'en','name','Canadian Institute for Energy Training'),(10030,7906,'fr','name','Institut Canadien de Formation en Energie'),(10031,7907,'en','name','Durham College'),(10032,7908,'no_lang_code','name','A&G Pharmaceutical (United States)'),(10033,7909,'bn','name','পশ্চিমবঙ্গ স্বাস্থ্যবিজ্ঞান বিশ্ববিদ্যালয়'),(10034,7909,'en','name','West Bengal University of Health Sciences'),(10035,7909,'hi','name','पश्चिम बंगाल स्वास्थ्य विज्ञान विश्वविद्यालय'),(10036,7910,'en','name','St. Stephen’s Hospital'),(10037,7911,'no_lang_code','name','Dassault Systèmes (United States)'),(10038,7912,'en','name','Westchester Medical Center'),(10039,7913,'no_lang_code','name','Lake Shore Cryotronics (United States)'),(10040,7914,'no_lang_code','name','Luminex (United States)'),(10041,7915,'es','name','Instituto Ramón y Cajal de Investigación Sanitaria'),(10042,7916,'no_lang_code','name','BioMarin (United States)'),(10043,7917,'en','name','Canadian AIDS Treatment Information Exchange'),(10044,7918,'no_lang_code','name','ProteoTech (United States)'),(10045,7919,'en','name','Valley Baptist Medical Center'),(10046,7920,'no_lang_code','name','Sigmovir Biosystems (United States)'),(10047,7921,'no_lang_code','name','PricewaterhouseCoopers (United States)'),(10048,7922,'no_lang_code','name','Tascon Industries (United States)'),(10049,7923,'no_lang_code','name','Emergent BioSolutions (Canada)'),(10050,7924,'en','name','Casa Esperanza'),(10051,7925,'en','name','Cincinnati Sportsmedicine and Orthopaedic Center'),(10052,7926,'en','name','Texas Scottish Rite Hospital for Children'),(10053,7927,'no_lang_code','name','Optimum Technologies (United States)'),(10054,7928,'no_lang_code','name','Advanced MicroLabs (United States)'),(10055,7929,'en','name','West Palm Beach VA Medical Center'),(10056,7930,'no_lang_code','name','Biostruxs (United States)'),(10057,7931,'en','name','Education and Research Institute'),(10058,7932,'no_lang_code','name','Mabvax Therapeutics (United States)'),(10059,7933,'en','name','National Conference of State Legislatures'),(10060,7934,'en','name','National Institute for Health Development'),(10061,7934,'et','name','Tervise Arengu Instituut'),(10062,7935,'en','name','Baycrest Hospital'),(10063,7936,'no_lang_code','name','Tetramer Technologies (United States)'),(10064,7937,'fr','name','Centre Orthopédique Santy'),(10065,7938,'no_lang_code','name','Computational Physics (United States)'),(10066,7939,'en','name','Texas Lutheran University'),(10067,7940,'no_lang_code','name','Market Intelligence Strategy Centre (Australia)'),(10068,7941,'bg','name','Институт по физиология на растенията и генетика'),(10069,7941,'en','name','Institute of Plant Physiology and Genetics'),(10070,7942,'no_lang_code','name','Socratech (United States)'),(10071,7943,'es','name','Instituto Nacional de Salud'),(10072,7944,'no_lang_code','name','ALK-Abelló (Denmark)'),(10073,7945,'no_lang_code','name','Zywie (United States)'),(10074,7946,'en','name','Illinois Department of Human Services'),(10075,7947,'en','name','St. Eugenio Hospital'),(10076,7947,'it','name','Ospedale S. Eugenio'),(10077,7948,'no_lang_code','name','L3Harris (Canada)'),(10078,7949,'no_lang_code','name','OptoSonics (United States)'),(10079,7950,'no_lang_code','name','DNA Software (United States)'),(10080,7951,'no_lang_code','name','Medicago (Canada)'),(10081,7952,'no_lang_code','name','Response Biomedical (Canada)'),(10082,7953,'en','name','Fowler Kennedy Sport Medicine Clinic'),(10083,7954,'en','name','Developmental Studies Center'),(10084,7955,'no_lang_code','name','Conecta'),(10085,7956,'en','name','Didi Hirsch Mental Health Services'),(10086,7957,'no_lang_code','name','H & N Instruments (United States)'),(10087,7958,'no_lang_code','name','CPS Research'),(10088,7959,'no_lang_code','name','Forecasting International (United States)'),(10089,7960,'no_lang_code','name','Mircom Technologies (Canada)'),(10090,7961,'en','name','New North Citizens Council'),(10091,7962,'no_lang_code','name','Aegera Therapeutics (Canada)'),(10092,7963,'en','name','Health and Hospital Corporation'),(10093,7964,'pt','name','Instituto Nacional de Saúde'),(10094,7965,'en','name','Society for Public Health Education'),(10095,7966,'en','name','National Coalition of STD Directors'),(10096,7967,'fr','name','Centre Hospitalier de la Côte Basque'),(10097,7968,'no_lang_code','name','Westinghouse Electric (Sweden)'),(10098,7969,'en','name','Quality of Life Research Center'),(10099,7970,'no_lang_code','name','Scott Sabolich Prosthetics And Research (United States)'),(10100,7971,'en','name','Sheffield Kidney Institute'),(10101,7972,'no_lang_code','name','ViewPlus (United States)'),(10102,7973,'no_lang_code','name','DSM (United States)'),(10103,7974,'no_lang_code','name','Nitek (United States)'),(10104,7975,'en','name','Mater Mothers\' Hospital'),(10105,7976,'no_lang_code','name','Lipella Pharmaceuticals (United States)'),(10106,7977,'no_lang_code','name','Omega Optics (United States)'),(10107,7978,'en','name','St. Joseph\'s Children\'s Hospital'),(10108,7979,'de','name','Fraunhofer-Institut für Molekularbiologie und Angewandte Oekologie'),(10109,7979,'en','name','Fraunhofer Institute for Molecular Biology and Applied Ecology'),(10110,7980,'no_lang_code','name','Ocutech (United States)'),(10111,7981,'de','name','Max-Born-Institut für Nichtlineare Optik und Kurzzeitspektroskopie'),(10112,7981,'en','name','Max-Born-Institute for Nonlinear Optics and Short Pulse Spectroscopy'),(10113,7982,'en','name','Daytona State College'),(10114,7983,'en','name','United Hospital Fund'),(10115,7984,'en','name','V.P. Komisarenko Institute of Endocrinology and Metabolism'),(10116,7984,'uk','name','Інститут ендокринології та обміну речовин ім. В.П. Комісаренка'),(10117,7985,'no_lang_code','name','Behavioral Research Incorporated (United States)'),(10118,7986,'de','name','Institut für biologische Forschung'),(10119,7987,'en','name','Canadian Memorial Chiropractic College'),(10120,7988,'en','name','Southeast Louisiana Veterans Health Care System'),(10121,7989,'en','name','Shriners Hospitals for Children - Honolulu'),(10122,7990,'en','name','Algonquin College'),(10123,7990,'fr','name','Collège Algonquin'),(10124,7991,'en','name','Leicester Royal Infirmary'),(10125,7992,'en','name','Lines for Life'),(10126,7993,'en','name','Natural Science Collections Alliance'),(10127,7994,'no_lang_code','name','Scottish and Southern Energy (United Kingdom)'),(10128,7995,'fr','name','Association francophone pour le savoir'),(10129,7996,'no_lang_code','name','Christie (Canada)'),(10130,7997,'no_lang_code','name','DOSECC Exploration Services (United States)'),(10131,7998,'en','name','China Institute of Veterinary Drug Control'),(10132,7998,'zh','name','中国兽医药品监察所'),(10133,7999,'no_lang_code','name','Natural Pharmacia International (United States)'),(10134,8000,'ar','name','أكاديمية أسباير‎'),(10135,8000,'en','name','Aspire Academy'),(10136,8001,'no_lang_code','name','Xerox (United States)'),(10137,8002,'en','name','University of Abuja Teaching Hospital'),(10138,8003,'en','name','Thunder Bay Regional Health Sciences Centre'),(10139,8004,'en','name','Zhejiang Provincial People\'s Hospital'),(10140,8005,'no_lang_code','name','Polaris Motion (Canada)'),(10141,8006,'ja','name','市立四日市病院'),(10142,8006,'no_lang_code','name','Yokkaichi Municipal Hospital'),(10143,8007,'en','name','American Society of Andrology'),(10144,8008,'no_lang_code','name','NovoBiotic Pharmaceuticals'),(10145,8009,'no_lang_code','name','Cell Signaling Technology (United States)'),(10146,8010,'cy','name','Ysbyty Cyffredinol Llwynhelyg'),(10147,8010,'en','name','Withybush General Hospital'),(10148,8011,'no_lang_code','name','MicroTransponder (United States)'),(10149,8012,'en','name','St. Mary\'s Medical Center'),(10150,8013,'en','name','Royal Geographical Society'),(10151,8014,'ja','name','小田原市立病院'),(10152,8014,'no_lang_code','name','Odawara Municipal Hospital'),(10153,8015,'en','name','Center for Environmental Health'),(10154,8016,'de','name','Fritz-Haber-Institut der Max-Planck-Gesellschaft'),(10155,8016,'en','name','Fritz Haber Institute of the Max Planck Society'),(10156,8017,'no_lang_code','name','FTSE (Japan)'),(10157,8018,'no_lang_code','name','Eutropics Pharmaceuticals (United States)'),(10158,8019,'no_lang_code','name','Immersion (Canada)'),(10159,8020,'en','name','American Society for Parenteral and Enteral Nutrition'),(10160,8021,'no_lang_code','name','Welichem Biotech (Canada)'),(10161,8022,'no_lang_code','name','Auerbach Associates (United States)'),(10162,8023,'en','name','Virginia Wesleyan College'),(10163,8024,'no_lang_code','name','Weinberg Medical Physics (United States)'),(10164,8025,'en','name','Kennedy Space Center'),(10165,8025,'es','name','Centro Espacial John F. Kennedy'),(10166,8026,'en','name','Clinicians Report Foundation'),(10167,8027,'no_lang_code','name','Athersys (United States)'),(10168,8028,'en','name','Visiting Nurse Service of New York'),(10169,8029,'en','name','Manchester Royal Infirmary'),(10170,8030,'it','name','Centro di Riferimento Oncologico'),(10171,8031,'no_lang_code','name','Mitre (United States)'),(10172,8032,'en','name','H.T. Harvey & Associates'),(10173,8033,'no_lang_code','name','Astro-Med (United States)'),(10174,8034,'no_lang_code','name','Antigen Express (United States)'),(10175,8035,'en','name','Rothman Institute'),(10176,8036,'no_lang_code','name','Plentyoffish Media (Canada)'),(10177,8037,'no_lang_code','name','Reliable Biopharmaceutical Corporation (United States)'),(10178,8038,'en','name','Suffolk County Department of Health Services'),(10179,8039,'en','name','Nagahama Institute of Bio-Science and Technology'),(10180,8039,'ja','name','長浜バイオ大学'),(10181,8040,'no_lang_code','name','Zen Bio (United States)'),(10182,8041,'no_lang_code','name','Ferring Pharmaceuticals (Denmark)'),(10183,8042,'en','name','Bay Zoltán Foundation for Applied Research'),(10184,8042,'hu','name','Bay Zoltán Alkalmazott Kutatási Közhasznú Nonprofit Kft'),(10185,8043,'en','name','Tilganga Institute of Ophthalmology'),(10186,8043,'ne','name','तिलगंगा आँखाकेन्द्र'),(10187,8044,'no_lang_code','name','Advantagene (United States)'),(10188,8045,'es','name','Direccion General de Epidemiologia'),(10189,8046,'en','name','National Trust'),(10190,8047,'no_lang_code','name','Bechtel (United States)'),(10191,8048,'no_lang_code','name','BioStrategies (United States)'),(10192,8049,'en','name','Manchester College'),(10193,8050,'en','name','Fort Worth Museum of Science and History'),(10194,8051,'en','name','Abacus Health Solutions'),(10195,8052,'hu','name','Országos Pszichiátriai és Neurológiai Intézet'),(10196,8053,'en','name','Occupational Safety & Health Administration'),(10197,8054,'no_lang_code','name','Lundin Mining (Portugal)'),(10198,8055,'en','name','Okinawa Prefectural Chubu Hospital'),(10199,8055,'ja','name','沖縄県立中部病院'),(10200,8056,'en','name','TB Alliance'),(10201,8057,'en','name','Steadman Philippon Research Institute'),(10202,8058,'en','name','Pennsylvania Hospital'),(10203,8059,'no_lang_code','name','GrammaTech (United States)'),(10204,8060,'en','name','National Institute of Health Dr. Ricardo Jorge'),(10205,8060,'pt','name','Instituto Nacional de Saúde Dr. Ricardo Jorge'),(10206,8061,'en','name','Tomah VA Medical Center'),(10207,8062,'en','name','Onslow Memorial Hospital'),(10208,8063,'no_lang_code','name','Consolidated Safety Services-Dynamac (United States)'),(10209,8064,'tr','name','Adli Tıp Kurumu'),(10210,8065,'en','name','Dallas County'),(10211,8066,'en','name','Fort Peck Community College'),(10212,8067,'es','name','Hospital Intermutual de Levante'),(10213,8068,'no_lang_code','name','AgentSheets (United States)'),(10214,8069,'no_lang_code','name','Avanti Polar Lipids (United States)'),(10215,8070,'en','name','Millennium Pain Center'),(10216,8071,'no_lang_code','name','Capsugel (United States)'),(10217,8072,'no_lang_code','name','Applied BioPhysics (United States)'),(10218,8073,'en','name','Overton Brooks VA Medical Center'),(10219,8074,'en','name','Delaware County Community College'),(10220,8075,'no_lang_code','name','ActionDog (United Kingdom)'),(10221,8076,'en','name','Reformar'),(10222,8077,'en','name','Matsue Red Cross Hospital'),(10223,8077,'ja','name','松江赤十字病院'),(10224,8078,'en','name','Kagoshima Medical Center'),(10225,8078,'ja','name','鹿児島医療センター'),(10226,8079,'en','name','Fairview Developmental Center'),(10227,8080,'it','name','Ospedale Microcitemico'),(10228,8081,'no_lang_code','name','Terpenoid Therapeutics (United States)'),(10229,8082,'no_lang_code','name','Advanced Cooling Technologies (United States)'),(10230,8083,'en','name','Yukon River Inter Tribal Watershed Council'),(10231,8084,'no_lang_code','name','Sabbagh Associates'),(10232,8085,'en','name','Paradise Valley Hospital'),(10233,8086,'en','name','Georgia Department of Agriculture'),(10234,8087,'de','name','Wunschbaby Institut für Kinderwunsch'),(10235,8088,'no_lang_code','name','Willis Towers Watson (United Kingdom)'),(10236,8089,'no_lang_code','name','Advanced Brain Monitoring (United States)'),(10237,8090,'no_lang_code','name','Orthocare Innovations (United States)'),(10238,8091,'en','name','Ministry of Justice'),(10239,8091,'tr','name','Adalet Bakanlığı'),(10240,8092,'no_lang_code','name','MetaMateria (United States)'),(10241,8093,'no_lang_code','name','Celaya, Emparanza y Galdos Internacional (Spain)'),(10242,8094,'en','name','Bethany College - Kansas'),(10243,8095,'no_lang_code','name','Sigma Technologies (United States)'),(10244,8096,'en','name','Reproductive Medicine Associates of New Jersey'),(10245,8097,'no_lang_code','name','Geotab (Canada)'),(10246,8098,'en','name','Cooperative Clinical Drug Research and Development'),(10247,8099,'no_lang_code','name','NanoComposix (United States)'),(10248,8100,'en','name','National Center for Health Statistics'),(10249,8101,'no_lang_code','name','Envigo (Germany)'),(10250,8102,'no_lang_code','name','Cell Preservation Services (United States)'),(10251,8103,'en','name','Greenwood Genetic Center'),(10252,8104,'en','name','Summa Health System'),(10253,8105,'en','name','Australian Institute of Nuclear Science and Engineering'),(10254,8106,'no_lang_code','name','Altor BioScience (United States)'),(10255,8107,'fr','name','Institut Claudius Regaud'),(10256,8108,'en','name','Surgical Materials Testing Laboratory'),(10257,8109,'de','name','München Klinik'),(10258,8109,'en','name','Munich Municipal Hospital Group'),(10259,8110,'no_lang_code','name','Edvotek (United States)'),(10260,8111,'en','name','Bristol Institute for Transfusion Sciences'),(10261,8112,'en','name','American College of Cardiology'),(10262,8113,'en','name','Wolters Kluwer Health'),(10263,8114,'ja','name','大阪府済生会中津病院'),(10264,8114,'no_lang_code','name','Saiseikai Nakatsu Hospital'),(10265,8115,'en','name','Shriners for Children Medical Center - Pasadena'),(10266,8116,'en','name','Canadian College of Naturopathic Medicine'),(10267,8117,'en','name','Beatson West of Scotland Cancer Centre'),(10268,8118,'en','name','Defence Food Research Laboratory'),(10269,8118,'hi','name','रक्षा खाद्य शोध प्रयोगशाला'),(10270,8119,'en','name','Asbury University'),(10271,8120,'en','name','Southern Regional Area Health Education Centers'),(10272,8121,'fr','name','Institut de Médecine Tropicale du Service de Santé des Armées'),(10273,8122,'en','name','Hebrew Home of Greater Washington'),(10274,8123,'en','name','International Food Policy Research Institute'),(10275,8123,'es','name','Instituto Internacional de Investigación sobre Políticas Alimentarias'),(10276,8123,'fr','name','Institut International de Recherche sur les Politiques Alimentaires'),(10277,8124,'en','name','Youth Science Canada'),(10278,8125,'en','name','National Institute of Ayurveda'),(10279,8125,'hi','name','राष्ट्रीय आयुर्विज्ञान संस्थान'),(10280,8126,'no_lang_code','name','Active Signal Technologies (United States)'),(10281,8127,'no_lang_code','name','iTherX (United States)'),(10282,8128,'no_lang_code','name','ING Robotic Aviation'),(10283,8129,'no_lang_code','name','DMH Associates (United States)'),(10284,8130,'no_lang_code','name','Colgate-Palmolive (United States)'),(10285,8131,'no_lang_code','name','Conversion Energy Enterprises (United States)'),(10286,8132,'no_lang_code','name','Schlumberger (United Kingdom)'),(10287,8133,'no_lang_code','name','Cirrus Logic (United Kingdom)'),(10288,8134,'en','name','Tachikawa Hospital'),(10289,8134,'ja','name','立川病院'),(10290,8135,'en','name','Vrinnevi Hospital'),(10291,8135,'sv','name','Vrinnevisjukhuset i Norrköping'),(10292,8136,'en','name','Military Institute of Hygiene and Epidemiology'),(10293,8136,'pl','name','Wojskowy Instytut Higieny i Epidemiologii'),(10294,8137,'no_lang_code','name','Beckham Company (United States)'),(10295,8138,'no_lang_code','name','Tristan Technologies (United States)'),(10296,8139,'en','name','Anderson Orthopaedic Research Institute'),(10297,8140,'no_lang_code','name','Epirus Biopharmaceuticals (United States)'),(10298,8141,'en','name','West Jefferson Medical Center'),(10299,8142,'en','name','Gila River Indian Community'),(10300,8143,'no_lang_code','name','Novozymes (United States)'),(10301,8144,'no_lang_code','name','Polaris Health Direction'),(10302,8145,'no_lang_code','name','Steris (United States)'),(10303,8146,'sv','name','Vårdcentralen Teleborg'),(10304,8147,'en','name','Institute of Molecular Genetics Luigi Luca Cavalli-Sforza'),(10305,8147,'it','name','Istituto di Genetica Molecolare'),(10306,8148,'no_lang_code','name','QLT (Canada)'),(10307,8149,'en','name','Progeria Research Foundation'),(10308,8150,'no_lang_code','name','Giro (Canada)'),(10309,8151,'en','name','Notre Dame de Namur University'),(10310,8151,'fr','name','Université notre-dame-de-namur'),(10311,8152,'no_lang_code','name','Kodak (United Kingdom)'),(10312,8153,'no_lang_code','name','Transposagen Biopharmaceuticals (United States)'),(10313,8154,'en','name','National Disease Research Interchange'),(10314,8155,'en','name','Valley Presbyterian Hospital'),(10315,8156,'en','name','Wayne Memorial Hospital'),(10316,8157,'en','name','Center for Genetic Engineering and Biotechnology'),(10317,8157,'es','name','Centro de Ingeniería Genética y Biotecnología'),(10318,8158,'en','name','Council of State Governments'),(10319,8159,'en','name','Inter-Tribal Council of Michigan'),(10320,8160,'no_lang_code','name','PowerWorld (United States)'),(10321,8161,'no_lang_code','name','Abeome Corporation (United States)'),(10322,8162,'en','name','AIDS Committee of Toronto'),(10323,8163,'no_lang_code','name','Michigan Molecular Institute (United States)'),(10324,8164,'no_lang_code','name','Noble Life Sciences (United States)'),(10325,8165,'no_lang_code','name','Etubics (United States)'),(10326,8166,'en','name','National Suicide Research Foundation'),(10327,8167,'en','name','Diné College'),(10328,8168,'no_lang_code','name','MyScience (United Kingdom)'),(10329,8169,'no_lang_code','name','Parallel Synthesis Technologies (United States)'),(10330,8170,'en','name','Québec International'),(10331,8171,'no_lang_code','name','Peake DeLancey Printers (United States)'),(10332,8172,'en','name','Chemical Pharmaceutical Research Institute'),(10333,8173,'en','name','Rath Research Institute'),(10334,8174,'it','name','Ospedale di Mirano'),(10335,8175,'no_lang_code','name','Thromgen (United States)'),(10336,8176,'de','name','Allgemeine Unfallversicherungsanstalt'),(10337,8177,'en','name','Materials Science & Engineering'),(10338,8178,'no_lang_code','name','Levret'),(10339,8179,'en','name','AIDS Service Center of New York City'),(10340,8180,'en','name','Bacone College'),(10341,8181,'no_lang_code','name','CyberTech (United States)'),(10342,8182,'ja','name','桜橋渡辺病院'),(10343,8182,'no_lang_code','name','Sakurabashi Watanabe Hospital'),(10344,8183,'en','name','Computer Aids for Chemical Engineering'),(10345,8184,'no_lang_code','name','DuPont (United Kingdom)'),(10346,8185,'no_lang_code','name','KMS Fusion (United States)'),(10347,8186,'no_lang_code','name','Utsi Electronics (United Kingdom)'),(10348,8187,'en','name','Hyogo Brain and Heart Center'),(10349,8187,'ja','name','兵庫県立姫路循環器病センター'),(10350,8188,'no_lang_code','name','VideoMining (United States)'),(10351,8189,'no_lang_code','name','Nanomaterials & Nanofabrication Laboratories (United States)'),(10352,8190,'en','name','New England Board of Higher Education'),(10353,8191,'no_lang_code','name','Nottingham Scientific (United Kingdom)'),(10354,8192,'no_lang_code','name','Continuum Dynamics (United States)'),(10355,8193,'en','name','Tacoma/Valley Radiation Oncology Centers'),(10356,8194,'no_lang_code','name','Exocell (United States)'),(10357,8195,'no_lang_code','name','Panasonic (United Kingdom)'),(10358,8196,'en','name','China University of Science and Technology'),(10359,8196,'zh','name','中華科技大學'),(10360,8197,'en','name','La Jolla Bioengineering Institute'),(10361,8198,'en','name','China Institute of Sport Science'),(10362,8198,'zh','name','国家体育总局体育科学研究所'),(10363,8199,'en','name','Stanley Street Treatment and Resources'),(10364,8200,'en','name','Hope Heart Institute'),(10365,8201,'no_lang_code','name','Phenomenome Discoveries (Canada)'),(10366,8202,'en','name','Joint Commission'),(10367,8203,'en','name','Toronto East General Hospital'),(10368,8204,'it','name','Società Italiana di Medicina Generale'),(10369,8205,'en','name','New Victoria Theatre'),(10370,8206,'no_lang_code','name','GlaxoSmithKline (Switzerland)'),(10371,8207,'en','name','Retina Foundation of the Southwest'),(10372,8208,'de','name','Medizinisches Versorgungszentrum'),(10373,8208,'en','name','Center for HIV and Hepatogastroenterology'),(10374,8209,'no_lang_code','name','World Precision Instruments (United States)'),(10375,8210,'no_lang_code','name','Jarvik Heart (United States)'),(10376,8211,'en','name','Health Services Center'),(10377,8212,'no_lang_code','name','FibroGen (United States)'),(10378,8213,'fr','name','Images & Réseaux'),(10379,8214,'en','name','Kunming Institute of Precious Metals'),(10380,8215,'it','name','IRCCS Materno Infantile Burlo Garofolo, Ospedale Infantile Burlo Garofolo'),(10381,8216,'en','name','International Society for Experimental Hematology'),(10382,8217,'en','name','DairyNZ'),(10383,8218,'en','name','Livingstone College'),(10384,8219,'en','name','Yuli Veterans Hospital'),(10385,8219,'zh','name','七月退伍军人医院'),(10386,8220,'en','name','St. Joseph Health System'),(10387,8221,'en','name','Utah Department of Human Services'),(10388,8222,'no_lang_code','name','Umpqua Research Company (United States)'),(10389,8223,'en','name','Malawi-Liverpool-Wellcome Trust Clinical Research Programme'),(10390,8224,'no_lang_code','name','Ocular Surface Center'),(10391,8225,'no_lang_code','name','Tactus Technology (United States)'),(10392,8226,'en','name','Swedish Covenant Hospital'),(10393,8227,'no_lang_code','name','Translink (United Kingdom)'),(10394,8228,'en','name','Stillman College'),(10395,8229,'en','name','Tsukuba Medical Center Hospital'),(10396,8229,'ja','name','筑波メディカルセンター病院'),(10397,8230,'no_lang_code','name','Pro Change Behavior Systems (United States)'),(10398,8231,'en','name','Gundersen Lutheran Hospital'),(10399,8232,'en','name','Environmental Protection Agency'),(10400,8233,'en','name','White Mountains Community College'),(10401,8234,'no_lang_code','name','Saint-Gobain (United States)'),(10402,8235,'no_lang_code','name','Vesticon (United States)'),(10403,8236,'en','name','St. Luke\'s Hospital'),(10404,8237,'no_lang_code','name','Sharklet Technologies (United States)'),(10405,8238,'no_lang_code','name','Enzo Biochem (United States)'),(10406,8239,'en','name','Maaruti College of Dental sciences & Research Center'),(10407,8240,'en','name','Colorado Center for Reproductive Medicine'),(10408,8241,'en','name','International Center for Research on Women'),(10409,8242,'no_lang_code','name','WRc (United Kingdom)'),(10410,8243,'no_lang_code','name','ProSci Incorporated (United States)'),(10411,8244,'en','name','Swami Devi Dyal Hospital and Dental College'),(10412,8245,'en','name','Trillium Health Centre'),(10413,8246,'en','name','International Rescue Committee'),(10414,8247,'en','name','Girls Incorporated'),(10415,8248,'no_lang_code','name','Atmel (United States)'),(10416,8249,'no_lang_code','name','Isowater Corporation (Canada)'),(10417,8250,'no_lang_code','name','Crosslight Software (Canada)'),(10418,8251,'no_lang_code','name','Dot Metrics Technologies (United States)'),(10419,8252,'fr','name','Centre d\'Etudes Prospectives et d\'Informations Internationales'),(10420,8253,'en','name','Alwar Pharmacy College'),(10421,8254,'en','name','Block Center'),(10422,8255,'no_lang_code','name','Safran Electronics (Canada)'),(10423,8256,'en','name','Galiano Conservancy Association'),(10424,8257,'en','name','State Research Center for Applied Microbiology and Biotechnology'),(10425,8257,'ru','name','Федеральное бюджетное учреждение науки Государственный научный центр прикладной микробиологии и биотехнологии'),(10426,8258,'de','name','Max-Planck-Institut für Molekulare Physiologie'),(10427,8258,'en','name','Max Planck Institute of Molecular Physiology'),(10428,8259,'en','name','Lancaster Theological Seminary, United Church of Christ'),(10429,8260,'hu','name','Petz Aladár Megyei Oktató Kórház'),(10430,8261,'en','name','Cardiopulmonary Research Science and Technology Institute'),(10431,8262,'no_lang_code','name','NeuroBioTex (United States)'),(10432,8263,'en','name','Northwest Portland Area Indian Health Board'),(10433,8264,'no_lang_code','name','EyePoint Pharmaceuticals (United States)'),(10434,8265,'en','name','Burton Hospitals NHS Foundation Trust'),(10435,8266,'no_lang_code','name','Exponents (United States)'),(10436,8267,'no_lang_code','name','InPore Vape Technologies (United States)'),(10437,8268,'no_lang_code','name','Simbex (United States)'),(10438,8269,'en','name','Libreville Hospital'),(10439,8269,'fr','name','Centre Hospitalier de Libreville'),(10440,8270,'no_lang_code','name','ASL Analytical (United States)'),(10441,8271,'no_lang_code','name','Vortant Technologies (United States)'),(10442,8272,'en','name','Eastern Iowa Community College'),(10443,8273,'pt','name','Estrutura de Missão para os Assuntos do Mar'),(10444,8274,'no_lang_code','name','Innovative Micro Technology (United States)'),(10445,8275,'en','name','National Dental Centre of Singapore'),(10446,8276,'en','name','Mater Private Hospital'),(10447,8277,'en','name','Upsala College'),(10448,8278,'en','name','Southwest Tennessee Community College'),(10449,8279,'en','name','Saddleback College'),(10450,8280,'en','name','Warneford Hospital'),(10451,8281,'no_lang_code','name','United Therapeutics (United States)'),(10452,8282,'en','name','VA Central California Health Care System'),(10453,8283,'en','name','Fairbanks Native Association'),(10454,8284,'no_lang_code','name','LaunchPoint Technologies (United States)'),(10455,8285,'en','name','Tennessee Department of Health'),(10456,8286,'no_lang_code','name','Iridian Spectral Technologies (Canada)'),(10457,8287,'cy','name','Y Gymdeithas Frenhinol'),(10458,8287,'en','name','Royal Society'),(10459,8288,'ja','name','渓仁会グループ'),(10460,8288,'no_lang_code','name','Teine Keijinkai Hospital'),(10461,8289,'no_lang_code','name','Greater Saskatoon Chamber of Commerce'),(10462,8290,'no_lang_code','name','BioSurfaces (United States)'),(10463,8291,'no_lang_code','name','NovaLipids (Canada)'),(10464,8292,'en','name','Institute for Disabilities Research and Training'),(10465,8293,'en','name','Victoria General Hospital'),(10466,8294,'no_lang_code','name','Mt. San Antonio College'),(10467,8295,'en','name','Institute of Nutrition of Central America and Panama'),(10468,8295,'es','name','Instituto de Nutrición de Centro América y Panamá'),(10469,8296,'en','name','Population Services International'),(10470,8297,'en','name','Indian Grassland and Fodder Research Institute'),(10471,8298,'en','name','Recovery Consultants of Atlanta'),(10472,8299,'en','name','Consortium GARR'),(10473,8300,'no_lang_code','name','PSIwebware (United States)'),(10474,8301,'en','name','Institute of Himalayan Bioresource Technology'),(10475,8302,'en','name','Mexican Social Security Institute'),(10476,8302,'es','name','Instituto Mexicano del Seguro Social'),(10477,8303,'en','name','Human Resources Research Organization'),(10478,8304,'no_lang_code','name','NanoSonic (United States)'),(10479,8305,'en','name','Colorado Center for Bone Research'),(10480,8306,'no_lang_code','name','Carl Zeiss (United Kingdom)'),(10481,8307,'no_lang_code','name','Doctors Company (United States)'),(10482,8308,'no_lang_code','name','Electrovaya (Canada)'),(10483,8309,'en','name','Applied Science and Technology Research Institute'),(10484,8310,'no_lang_code','name','NexTalk (United States)'),(10485,8311,'no_lang_code','name','MédiMabs (Canada)'),(10486,8312,'no_lang_code','name','DiaMedica (Canada)'),(10487,8313,'en','name','Institute of Noetic Sciences'),(10488,8314,'no_lang_code','name','BioLinx (United States)'),(10489,8315,'es','name','Comisión Honoraria de Lucha contra el cáncer'),(10490,8316,'en','name','Rural Development Administration'),(10491,8317,'en','name','European Society for Medical Oncology'),(10492,8318,'no_lang_code','name','Pacific Design Technologies (United States)'),(10493,8319,'en','name','Institute of Ocular Microsurgery'),(10494,8319,'es','name','Instituto de Microcirugía Ocular'),(10495,8320,'en','name','Behavior Therapy Associates'),(10496,8321,'en','name','Tropical Diseases Research Centre'),(10497,8322,'no_lang_code','name','Daniel H. Wagner Associates (United States)'),(10498,8323,'en','name','Veterans Biomedical Research Institute'),(10499,8324,'no_lang_code','name','Acadian Seaplants (Canada)'),(10500,8325,'no_lang_code','name','Pulse Biosciences (United States)'),(10501,8326,'no_lang_code','name','Albany Molecular Research (United States)'),(10502,8327,'de','name','Kinderwunsch Zentrum Linz'),(10503,8327,'en','name','Women\'s General Hospital'),(10504,8328,'en','name','Northern Älvsborg county hospital'),(10505,8328,'sv','name','Norra Älvsborgs Länssjukhus'),(10506,8329,'no_lang_code','name','L.B. Foster Rail Technologies (Canada)'),(10507,8330,'no_lang_code','name','PDL BioPharma (United States)'),(10508,8331,'no_lang_code','name','Cell2B (Portugal)'),(10509,8332,'bg','name','Специализираната Болница за Активно лечение по Онкология'),(10510,8332,'en','name','Specialised Hospital for Active Treatment of Oncology'),(10511,8333,'en','name','Maria Mitchell Association'),(10512,8334,'en','name','Wordsley Hospital'),(10513,8335,'en','name','Matsushita Memorial Hospital'),(10514,8335,'ja','name','松下記念病院'),(10515,8336,'en','name','Beijing Red Cross Blood Center'),(10516,8337,'ja','name','医療法人 福井心臓血圧センター 福井循環器病院'),(10517,8337,'no_lang_code','name','Fukui CardioVascular Center'),(10518,8338,'no_lang_code','name','AbleNet (United States)'),(10519,8339,'no_lang_code','name','Summit (United Kingdom)'),(10520,8340,'no_lang_code','name','Motion Control (United States)'),(10521,8341,'no_lang_code','name','Insight Genetics (United States)'),(10522,8342,'en','name','University of Missouri Health System'),(10523,8343,'fr','name','Centre de Santé et de Services Sociaux Cavendish'),(10524,8344,'en','name','Biomedical Research Institute'),(10525,8345,'no_lang_code','name','Genomas (United States)'),(10526,8346,'no_lang_code','name','E.ON (United Kingdom)'),(10527,8347,'en','name','Employee Benefit Research Institute'),(10528,8348,'no_lang_code','name','Cisco Systems (United States)'),(10529,8349,'no_lang_code','name','Sanofi (Germany)'),(10530,8350,'en','name','Arizona Department of Education'),(10531,8351,'en','name','American Society of International Law'),(10532,8352,'no_lang_code','name','ABS Consulting (United States)'),(10533,8353,'no_lang_code','name','ProThera Biologics (United States)'),(10534,8354,'no_lang_code','name','Pharmaceutical Formulations (United States)'),(10535,8355,'pl','name','Instytut Ekspertyz Sądowych'),(10536,8356,'no_lang_code','name','Actuated Medical (United States)'),(10537,8357,'en','name','Center for Occupational and Environmental Neurology'),(10538,8358,'no_lang_code','name','FHC (United States)'),(10539,8359,'en','name','VA Loma Linda Healthcare System'),(10540,8360,'no_lang_code','name','Accelopment (Switzerland)'),(10541,8361,'en','name','Norwich Community Hospital'),(10542,8362,'cs','name','Ústav pro Péči o Matku a Dítě'),(10543,8362,'en','name','Institute for the Care of Mother and Child'),(10544,8363,'en','name','American Enterprise Institute'),(10545,8364,'en','name','Kaiser Family Foundation'),(10546,8365,'en','name','San Gallicano Hospital'),(10547,8366,'no_lang_code','name','Primorigen Biosciences (United States)'),(10548,8367,'en','name','Vardhman Mahavir Medical College & Safdarjung Hospital'),(10549,8367,'hi','name','वर्धमान महावीर मेडिकल कॉलेज और सफदरजंग अस्पताल'),(10550,8368,'no_lang_code','name','Gaudenzia (United States)'),(10551,8369,'en','name','Sutter Medical Center'),(10552,8370,'no_lang_code','name','SeaStar Solutions (Canada)'),(10553,8371,'no_lang_code','name','MayaTech (United States)'),(10554,8372,'en','name','The Society for Post-Acute and Long-Term Care Medicine'),(10555,8373,'en','name','Twin Cities Spine Center'),(10556,8374,'no_lang_code','name','ID-FISH Technology (United States)'),(10557,8375,'en','name','National Business Group on Health'),(10558,8376,'no_lang_code','name','LabCorp (United States)'),(10559,8377,'no_lang_code','name','White Design (United Kingdom)'),(10560,8378,'en','name','Association of Asian Pacific Community Health Organizations'),(10561,8379,'en','name','Royal Society of Arts'),(10562,8380,'sk','name','Ocná klinika'),(10563,8381,'es','name','Centro Nacional de Investigaciones Científicas'),(10564,8382,'en','name','Laser and Skin Surgery Center of New York'),(10565,8383,'no_lang_code','name','Vivonics (United States)'),(10566,8384,'en','name','Withington Community Hospital'),(10567,8385,'no_lang_code','name','Hiden Analytical (United Kingdom)'),(10568,8386,'en','name','Institution of Civil Engineers'),(10569,8387,'en','name','Asian Institute of Technology'),(10570,8387,'th','name','สถาบันเทคโนโลยีแห่งเอเชีย'),(10571,8388,'it','name','Cassa di Risparmio in Bologna'),(10572,8389,'en','name','College Board'),(10573,8390,'en','name','Institute of Environmental Science and Research'),(10574,8391,'en','name','Human Media'),(10575,8392,'en','name','National Food and Nutrition Institute'),(10576,8392,'pl','name','Instytut Zywnosci Zywienia'),(10577,8393,'en','name','National Organization for Drug Control and Research'),(10578,8394,'en','name','Electrochemical Society'),(10579,8395,'en','name','Arthritis and Rheumatology Clinics of Kansas'),(10580,8396,'en','name','Indian Institute of Chemical Technology'),(10581,8396,'ml','name','ഇന്ത്യൻ ഇൻസ്ററിററ്യൂട്ട് ഓഫ് കെമിക്കൽ ടെക്നോളജി, ഹൈദ്രബാദ്'),(10582,8396,'te','name','ఇండియన్ ఇనిస్టిట్యూట్ ఆఫ్ కెమికల్ టెక్నాలజీ'),(10583,8397,'en','name','National Institute of Rheumatic Diseases'),(10584,8398,'en','name','Tuscaloosa VA Medical Center'),(10585,8399,'en','name','Texas Orthopedic Hospital'),(10586,8400,'en','name','Little Big Horn College'),(10587,8401,'en','name','Serving Children and Adults in Need'),(10588,8402,'fr','name','Cegep de Matane, Cégep de matane'),(10589,8403,'no_lang_code','name','JP Laboratories (United States)'),(10590,8404,'en','name','Kirklees Council'),(10591,8405,'no_lang_code','name','Cenergia (Denmark)'),(10592,8406,'en','name','Hackensack University Medical Center at Pascack Valley'),(10593,8407,'en','name','Mount St. Mary\'s University'),(10594,8408,'en','name','Yukon University'),(10595,8409,'en','name','Institute of Biomedical Chemistry'),(10596,8409,'ru','name','Научно-исследовательский институт биомедицинской химии имени В.Н. Ореховича'),(10597,8410,'en','name','Greenville Technical College'),(10598,8411,'nl','name','AZ Sint-Blasius'),(10599,8412,'no_lang_code','name','Estée Lauder (United States)'),(10600,8413,'en','name','Peterson & Smith Equine Hospital'),(10601,8414,'no_lang_code','name','Expression Therapeutics (United States)'),(10602,8415,'en','name','Houston Advanced Research Center'),(10603,8416,'en','name','Kanagawa Cardiovascular and Respiratory Center'),(10604,8416,'ja','name','神奈川県立循環器呼吸器病センター'),(10605,8417,'en','name','College of Physicians of Philadelphia'),(10606,8418,'en','name','Association For Women in Mathematics'),(10607,8419,'en','name','Iolani School'),(10608,8420,'no_lang_code','name','Petro Geotech (Canada)'),(10609,8421,'no_lang_code','name','Photonic BioSystems (United States)'),(10610,8422,'en','name','National Institute of Pharmaceutical Education and Research'),(10611,8422,'hi','name','नेशनल इंस्टिट्यूट ऑफ फार्मास्यूटिकल एजुकेशन एंड रिसर्च'),(10612,8422,'te','name','నేషనల్ ఇన్స్టిట్యూట్ ఆఫ్ ఫార్మస్యూటికల్ ఎడ్యుకేషన్'),(10613,8423,'ja','name','南青山アイクリニック'),(10614,8423,'no_lang_code','name','Minamiaoyama Eye Clinic'),(10615,8424,'en','name','Galveston College'),(10616,8425,'en','name','Her Majesty\'s Government Communications Centre'),(10617,8426,'no_lang_code','name','Cambrian Innovation (United States)'),(10618,8427,'no_lang_code','name','ImmuneChem (Canada)'),(10619,8428,'de','name','Otto Wagner Spital'),(10620,8428,'en','name','Otto Wagner Hospital'),(10621,8429,'en','name','San Juan College'),(10622,8430,'en','name','Central Research Institute of Electric Power Industry'),(10623,8430,'ja','name','電力中央研究所'),(10624,8431,'en','name','Wellborn Road Veterinary Medical Center'),(10625,8432,'no_lang_code','name','SolPowered Energy Corporation (Canada)'),(10626,8433,'no_lang_code','name','Comply (United States)'),(10627,8434,'en','name','Audubon Nature Institute'),(10628,8435,'en','name','Community Health Action of Staten Island'),(10629,8436,'en','name','Whatcom Community College'),(10630,8437,'en','name','Taipei Municipal Women and Children\'s Hospital'),(10631,8438,'no_lang_code','name','MagMutual (United States)'),(10632,8439,'en','name','Upton Hospital'),(10633,8440,'en','name','Nutrition Foundation of India'),(10634,8441,'it','name','Istituto Giannina Gaslini'),(10635,8442,'en','name','Social Science Education Consortium'),(10636,8443,'en','name','Central Remedial Clinic'),(10637,8444,'en','name','National Institute of Cardiovascular Diseases'),(10638,8445,'no_lang_code','name','IMMCO Diagnostics (United States)'),(10639,8446,'no_lang_code','name','W. L. Gore & Associates (United States)'),(10640,8447,'no_lang_code','name','Centrose (United States)'),(10641,8448,'no_lang_code','name','Fujimoto Pharmaceutical Corporation (Japan)'),(10642,8449,'en','name','Southwestern College - California'),(10643,8450,'en','name','North Carolina Institute of Medicine'),(10644,8451,'en','name','New Jersey Department of Environmental Protection'),(10645,8451,'fr','name','Département de la protection de l\'environnement du new jersey'),(10646,8452,'en','name','Bismarck State College'),(10647,8453,'no_lang_code','name','Molecules for Health (United States)'),(10648,8454,'no_lang_code','name','Nikon (United Kingdom)'),(10649,8455,'no_lang_code','name','Global Vaccines (United States)'),(10650,8456,'no_lang_code','name','Imaging Systems Technology (United States)'),(10651,8457,'pt','name','Centro Hospitalar de Vila Nova de Gaia'),(10652,8458,'no_lang_code','name','BiologicsMD (United States)'),(10653,8459,'en','name','Association for the Development of Education and Research on Corporate Social Responsibility'),(10654,8459,'fr','name','ADERSE, Association pour le Développement de l\'Enseignement et de la Recherche sur la Responsabilité Sociale de l\'Entreprise'),(10655,8460,'en','name','Tanana Chiefs Conference'),(10656,8461,'en','name','Methodist Rehabilitation Center'),(10657,8462,'no_lang_code','name','Virtual Centre of Excellence In Mobile and Personal Communications'),(10658,8463,'no_lang_code','name','HTG Molecular Diagnostics (United States)'),(10659,8464,'pl','name','Instytut Gruźlicy i Chorób Płuc'),(10660,8465,'en','name','Southern California Institute for Research and Education'),(10661,8466,'fr','name','Cégep Garneau'),(10662,8467,'en','name','San Dieguito Alliance'),(10663,8468,'en','name','Wisconsin Medical Society'),(10664,8469,'no_lang_code','name','Decision Systems (United States)'),(10665,8470,'no_lang_code','name','Auxagen (United States)'),(10666,8471,'ja','name','鳥取県立中央病院'),(10667,8471,'no_lang_code','name','Tottori Prefectural Central Hospital'),(10668,8472,'en','name','Auburn School District'),(10669,8473,'no_lang_code','name','Oceans Limited (Canada)'),(10670,8474,'it','name','Istituto Nazionale Biostrutture e Biosistemi'),(10671,8475,'en','name','American Society for Neurochemistry'),(10672,8476,'no_lang_code','name','AstraZeneca (United States)'),(10673,8477,'en','name','Glynn Hospitality Group'),(10674,8478,'en','name','Technological Assistance Institute for Intellectual Disability'),(10675,8479,'en','name','Institute of Mathematical Statistics'),(10676,8480,'en','name','Spring Hill College'),(10677,8481,'no_lang_code','name','Precigen (United States)'),(10678,8482,'en','name','San Antonio State Chest Hospital'),(10679,8483,'en','name','Fetal Medicine Foundation of America'),(10680,8484,'en','name','MRC Prion Unit'),(10681,8485,'no_lang_code','name','Isto Biologics (United States)'),(10682,8486,'no_lang_code','name','OPKO Health (Canada)'),(10683,8487,'en','name','Washington Educational Telecommunications Association'),(10684,8488,'en','name','Murray State College'),(10685,8489,'en','name','Ohio Heart & Vascular Center'),(10686,8490,'en','name','Society for Neuroscience'),(10687,8491,'no_lang_code','name','STMicroelectronics (United Kingdom)'),(10688,8492,'it','name','Istituto Zooprofilattico Sperimentale dell\'Umbria e delle Marche'),(10689,8493,'no_lang_code','name','Institute of Bioengineering Technologies (United States)'),(10690,8494,'en','name','International Development Research Centre'),(10691,8494,'fr','name','Centre de recherches pour le développement international'),(10692,8495,'ar','name','مجمع السلمانية الطبي'),(10693,8495,'en','name','Salmaniya Medical Complex'),(10694,8496,'no_lang_code','name','Ross Laboratories (United States)'),(10695,8497,'en','name','International Epidemiology Institute'),(10696,8498,'en','name','Graduate School Neurosciences Amsterdam Rotterdam'),(10697,8499,'en','name','Turgut Ozal Medical Center'),(10698,8499,'tr','name','Turgut Özal Tıp Merkezi'),(10699,8500,'no_lang_code','name','United Biomedical (United States)'),(10700,8501,'en','name','Insall Scott Kelly Institute'),(10701,8502,'no_lang_code','name','Helicos Biosciences (United States)'),(10702,8503,'de','name','Max-Planck-Institut für Pflanzenzüchtungsforschung'),(10703,8503,'en','name','Max Planck Institute for Plant Breeding Research'),(10704,8504,'en','name','Institute of Statistical Science, Academia Sinica'),(10705,8504,'zh','name','中央研究院 統計科學研究所'),(10706,8505,'no_lang_code','name','Analysis Group (United States)'),(10707,8506,'no_lang_code','name','Cynosure (United States)'),(10708,8507,'el','name','Τεχνολογικό Εκπαιδευτικό Ίδρυμα Αθήνας'),(10709,8507,'en','name','Technological Educational Institute of Athens'),(10710,8508,'fr','name','Association Française de Normalisation'),(10711,8509,'no_lang_code','name','MEG-3 (Canada)'),(10712,8510,'en','name','North American Vascular Biology Organization'),(10713,8511,'en','name','Substance Abuse Foundation'),(10714,8512,'en','name','Austin Community College'),(10715,8513,'en','name','Toronto Centre for Phenogenomics'),(10716,8514,'en','name','National Institute of Health of Thailand'),(10717,8514,'th','name','สถาบันวิจัยวิทยาศาสตร์สาธารณสุข'),(10718,8515,'en','name','Peggy Notebaert Nature Museum'),(10719,8516,'en','name','Swedish Council on Technology Assessment in Health Care'),(10720,8516,'sv','name','Svenska beredning för medicinsk utvärdering Health Care'),(10721,8517,'no_lang_code','name','REALITY Publishing (United States)'),(10722,8518,'no_lang_code','name','Tungs\' Taichung MetroHarbor Hospital'),(10723,8518,'zh','name','童綜合醫院'),(10724,8519,'fr','name','Institut Cardiovasculaire Paris Sud'),(10725,8520,'no_lang_code','name','VWR International (United States)'),(10726,8521,'en','name','National Cancer Center of Georgia'),(10727,8522,'no_lang_code','name','RxSight (United States)'),(10728,8523,'en','name','Tamil Nadu Government Dental College and Hospital'),(10729,8524,'no_lang_code','name','Transcendent Endeavors (United States)'),(10730,8525,'de','name','Klinikum Ludwigsburg'),(10731,8526,'en','name','Capitol Technology University'),(10732,8527,'it','name','Società per l’Assistenza al Malato Oncologico Terminale'),(10733,8528,'en','name','Sundaram Medical Foundation'),(10734,8529,'no_lang_code','name','Terragon Environmental Technologies (Canada)'),(10735,8530,'no_lang_code','name','Twin Star Medical (United States)'),(10736,8531,'no_lang_code','name','Athena Group (United States)'),(10737,8532,'no_lang_code','name','Bossa Nova Technologies (United States)'),(10738,8533,'no_lang_code','name','Symbiotech (United States)'),(10739,8534,'no_lang_code','name','Amorfix (Canada)'),(10740,8535,'no_lang_code','name','Bioo Scientific (United States)'),(10741,8536,'no_lang_code','name','Intrafinity (Canada)'),(10742,8537,'en','name','Leicestershire Partnership NHS Trust'),(10743,8538,'en','name','American Osteopathic Association'),(10744,8539,'en','name','Lambton College'),(10745,8540,'en','name','Al-Ameen College of Pharmacy'),(10746,8541,'en','name','Neurosciences Institute'),(10747,8542,'no_lang_code','name','CorSolutions (United States)'),(10748,8543,'no_lang_code','name','ChemMotif (United States)'),(10749,8544,'en','name','King\'s College - Pennsylvania'),(10750,8545,'no_lang_code','name','Trinity Investments (Japan)'),(10751,8546,'no_lang_code','name','Optivia Biotechnology (United States)'),(10752,8547,'no_lang_code','name','PRP Architects (United Kingdom)'),(10753,8548,'en','name','St. Mary Medical Center'),(10754,8549,'en','name','Lake Erie College of Osteopathic Medicine'),(10755,8550,'en','name','Indiana Hand to Shoulder Center'),(10756,8551,'en','name','Institute of Psychiatry and Neurology'),(10757,8552,'no_lang_code','name','URS Corporation (United Kingdom)'),(10758,8553,'it','name','Cefriel'),(10759,8554,'en','name','Cumberland Infirmary'),(10760,8555,'en','name','Healthcare Financial Management Association'),(10761,8556,'no_lang_code','name','Micro Magnetics (United States)'),(10762,8557,'no_lang_code','name','SABMiller (United Kingdom)'),(10763,8558,'en','name','La Clinica del Pueblo'),(10764,8559,'no_lang_code','name','Material Sciences (United States)'),(10765,8560,'en','name','Eden Medical'),(10766,8561,'en','name','Defence Research Laboratory'),(10767,8561,'hi','name','रक्षा अनुसंधान प्रयोगशाला'),(10768,8562,'en','name','Tzaneion General Hospital'),(10769,8563,'no_lang_code','name','MWH (United Kingdom)'),(10770,8564,'en','name','Cardiff Royal Infirmary'),(10771,8565,'en','name','RCSI & UCD Malaysia Campus'),(10772,8566,'en','name','International Center of Neurologic Restoration'),(10773,8566,'es','name','Centro Internacional de Restauración Neurológica'),(10774,8567,'no_lang_code','name','Fox Learning Systems (United States)'),(10775,8568,'no_lang_code','name','PharmaIN (United States)'),(10776,8569,'en','name','Guangxi Center for Disease Prevention and Control'),(10777,8569,'zh','name','广西壮族自治区疾病预防控制中心'),(10778,8570,'en','name','Taleghani General Hospital'),(10779,8570,'fa','name','بیمارستان طالقانی تهران'),(10780,8571,'no_lang_code','name','Advanced Imaging Research (United States)'),(10781,8572,'en','name','Wuhan Children\'s Hospital'),(10782,8572,'zh','name','武汉市儿童医院'),(10783,8573,'en','name','Sunny Hill Health Centre for Children'),(10784,8574,'en','name','Campbellsville University'),(10785,8574,'fr','name','Université de campbellsville'),(10786,8575,'en','name','Virginia Department of Agriculture and Consumer Services'),(10787,8576,'no_lang_code','name','Integrated Environmental Solutions (United Kingdom)'),(10788,8577,'no_lang_code','name','Vaccinex (United States)'),(10789,8578,'no_lang_code','name','Jacobs (United Kingdom)'),(10790,8579,'no_lang_code','name','InSituTec (United States)'),(10791,8580,'bn','name','বারডেম'),(10792,8580,'en','name','Bangladesh Institute of Research and Rehabilitation for Diabetes Endocrine and Metabolic Disorders'),(10793,8581,'no_lang_code','name','Aerosol Dynamics (United States)'),(10794,8582,'en','name','Taipei Municipal YangMing Hospital'),(10795,8582,'zh','name','台北市立阳明医院'),(10796,8583,'no_lang_code','name','Patheon (Canada)'),(10797,8584,'no_lang_code','name','Cellecta (United States)'),(10798,8585,'en','name','Central Forensic Science Laboratory'),(10799,8586,'no_lang_code','name','Nano-C (United States)'),(10800,8587,'en','name','Ise Red Cross Hospital'),(10801,8587,'ja','name','日本赤十字社 伊勢赤十字病院'),(10802,8588,'pt','name','Faculdade de Medicina do ABC'),(10803,8589,'no_lang_code','name','Wilson Energy (United Kingdom)'),(10804,8590,'en','name','Fairmont State University'),(10805,8590,'fr','name','Université d\'État de fairmont'),(10806,8591,'no_lang_code','name','MIRA (United Kingdom)'),(10807,8592,'no_lang_code','name','NeurOp (United States)'),(10808,8593,'no_lang_code','name','Chimera Technologies (United States)'),(10809,8594,'en','name','Orlando Health'),(10810,8595,'fr','name','Centre Hospitalier de Cannes'),(10811,8596,'no_lang_code','name','Targazyme (United States)'),(10812,8597,'en','name','Institute of Protein Research'),(10813,8597,'ru','name','Федеральное государственное бюджетное учреждение науки Институт белка Российской академии наук'),(10814,8598,'no_lang_code','name','Osel (United States)'),(10815,8599,'en','name','Taipei Municipal Jen-Ai Hospital'),(10816,8600,'fr','name','Groupe Hospitalier Intercommunal Le Raincy Montfermeil'),(10817,8601,'fr','name','Centre d\'Enseignement et de Recherches des Industries Alimentaires et Chimiques'),(10818,8602,'no_lang_code','name','GenProMarkers (United States)'),(10819,8603,'nl','name','AZ Maria Middelares'),(10820,8604,'en','name','Regional Plant Resource Centre'),(10821,8605,'en','name','Eindhoven Cancer Registry'),(10822,8606,'en','name','John Hunter Children\'s Hospital'),(10823,8607,'en','name','Florence Nightingale Museum'),(10824,8608,'no_lang_code','name','Cellex (United States)'),(10825,8609,'en','name','Albany Law School'),(10826,8609,'fr','name','Faculté de droit d\'albany'),(10827,8610,'no_lang_code','name','Waters (United Kingdom)'),(10828,8611,'no_lang_code','name','Exelus (United States)'),(10829,8612,'no_lang_code','name','Thermofin (Canada)'),(10830,8613,'no_lang_code','name','Epigenomics (Germany)'),(10831,8614,'en','name','Wildlife Trusts'),(10832,8615,'no_lang_code','name','Celerion (Canada)'),(10833,8616,'en','name','Western Interstate Commission for Higher Education'),(10834,8617,'de','name','Max-Planck-Institut für Wissenschaftsgeschichte'),(10835,8617,'en','name','Max Planck Institute for the History of Science'),(10836,8618,'en','name','Richmond Behavioral Health Authority'),(10837,8619,'en','name','Canadian Breast Cancer Network'),(10838,8620,'no_lang_code','name','wTe Corporation (United States)'),(10839,8621,'no_lang_code','name','Key Tech (United States)'),(10840,8622,'no_lang_code','name','Extrel (United States)'),(10841,8623,'en','name','Kelsey-Seybold Clinic'),(10842,8624,'no_lang_code','name','Azevan Pharmaceuticals (United States)'),(10843,8625,'en','name','South African Brain Research Institute'),(10844,8626,'no_lang_code','name','Essex and Suffolk Water (United Kingdom)'),(10845,8627,'en','name','Tuality Community Hospital'),(10846,8628,'no_lang_code','name','Molecular Kinetics (United States)'),(10847,8629,'no_lang_code','name','Spectrasonics (United States)'),(10848,8630,'no_lang_code','name','AbsInt (Germany)'),(10849,8631,'no_lang_code','name','Acoustic MedSystems (United States)'),(10850,8632,'en','name','National Archives'),(10851,8632,'ga','name','Cartlann Náisiúnta na hÉireann'),(10852,8633,'en','name','Sturdy Memorial Hospital'),(10853,8634,'en','name','National Institute of Child Health'),(10854,8635,'no_lang_code','name','Skanska (United Kingdom)'),(10855,8636,'no_lang_code','name','Science Education Solutions (United States)'),(10856,8637,'en','name','Institute for the Future'),(10857,8638,'no_lang_code','name','Kelda Group (United Kingdom)'),(10858,8639,'en','name','Ackerman Academy of Dermatopathology'),(10859,8640,'en','name','Royal National Institute of Blind'),(10860,8641,'ja','name','横須賀共済病院'),(10861,8641,'no_lang_code','name','Yokosuka Kyosai Hospital'),(10862,8642,'en','name','VA Central Iowa Health Care System'),(10863,8643,'no_lang_code','name','Oxford Instruments (United Kingdom)'),(10864,8644,'en','name','Koo Foundation Sun Yat-Sen Cancer Center'),(10865,8645,'en','name','St. Margaret Memorial Hospital'),(10866,8646,'no_lang_code','name','Environmental Design Solutions Limited (United Kingdom)'),(10867,8647,'en','name','St. Mary\'s Hospital'),(10868,8648,'no_lang_code','name','FM Technologies (United States)'),(10869,8649,'no_lang_code','name','Lundbeck (United States)'),(10870,8650,'en','name','TMJ Association'),(10871,8651,'en','name','Toyama Rosai Hospital'),(10872,8651,'ja','name','富山労災病院'),(10873,8652,'no_lang_code','name','Magellan BioScience (United States)'),(10874,8653,'no_lang_code','name','Neostem (United States)'),(10875,8654,'en','name','Bethany College - West Virginia'),(10876,8655,'en','name','Orange County Bar Foundation'),(10877,8656,'no_lang_code','name','Orkla (Norway)'),(10878,8657,'en','name','Drug Safety Research Unit'),(10879,8658,'no_lang_code','name','Waterloo CFD Engineering Consulting'),(10880,8659,'en','name','EngenderHealth'),(10881,8660,'no_lang_code','name','Celator Pharmaceuticals (Canada)'),(10882,8661,'no_lang_code','name','Mound Laser & Photonics Center (United States)'),(10883,8662,'no_lang_code','name','Chung Hsiao Municipal Hospital'),(10884,8663,'no_lang_code','name','ENVIRON (United States)'),(10885,8664,'en','name','Kronos Longevity Research Institute'),(10886,8665,'no_lang_code','name','Originus (United States)'),(10887,8666,'no_lang_code','name','TheraSource (United States)'),(10888,8667,'en','name','Moscow State University of Fine Chemical Technologies'),(10889,8667,'ru','name','Московский государственный университет тонких химических технологий имени М. В. Ломоносова'),(10890,8668,'en','name','Texas Back Institute'),(10891,8669,'no_lang_code','name','Talking Lights (United States)'),(10892,8670,'no_lang_code','name','Siemens (United States)'),(10893,8671,'no_lang_code','name','KineMed (United States)'),(10894,8672,'en','name','Harper College'),(10895,8672,'fr','name','Collège harper'),(10896,8673,'en','name','National Institute for Viral Disease Control and Prevention'),(10897,8674,'no_lang_code','name','InterScience (United States)'),(10898,8675,'no_lang_code','name','Collaborative Drug Discovery (United States)'),(10899,8676,'no_lang_code','name','ISCA Technologies (United States)'),(10900,8677,'en','name','Tokyo Rinkai Hospital'),(10901,8677,'ja','name','東京臨海病院'),(10902,8678,'en','name','Wm. Jennings Bryan Dorn VA Medical Center'),(10903,8679,'en','name','Fortune Society'),(10904,8680,'en','name','Saint George Hospital'),(10905,8681,'fr','name','Institut Océanographique'),(10906,8682,'en','name','International Centre for Infectious Diseases'),(10907,8683,'no_lang_code','name','Ameriprise Financial (United States)'),(10908,8684,'en','name','Allegheny County'),(10909,8685,'en','name','Saint Thomas West Hospital'),(10910,8686,'en','name','Pakistan Institute of Nuclear Science and Technology'),(10911,8687,'no_lang_code','name','Structured Materials Industries (United States)'),(10912,8688,'en','name','National Geographic Society'),(10913,8689,'no_lang_code','name','Bionetics (United States)'),(10914,8690,'no_lang_code','name','Infotech Soft (United States)'),(10915,8691,'fr','name','Collège Lionel Groulx, Collège lionel-groulx'),(10916,8692,'en','name','USMMA Alumni Association and Foundation'),(10917,8693,'en','name','Frédéric Joliot-Curie National Research Institute for Radiobiology and Radiohygiene'),(10918,8694,'no_lang_code','name','Nanotek Instruments (United States)'),(10919,8695,'en','name','Eunice Kennedy Shriver National Institute of Child Health and Human Development'),(10920,8696,'no_lang_code','name','ElSohly Laboratories (United States)'),(10921,8697,'en','name','Olympic Park Sports Medicine Centre'),(10922,8698,'fr','name','Centre Hospitalier Le Vinatier'),(10923,8699,'en','name','Orthopaedic Research of Virginia'),(10924,8700,'no_lang_code','name','Megger (United Kingdom)'),(10925,8701,'en','name','Israelite Hospital'),(10926,8701,'it','name','Ospedale Israelitico'),(10927,8702,'en','name','College of the North Atlantic'),(10928,8703,'en','name','Seattle Institute for Biomedical and Clinical Research'),(10929,8704,'de','name','Krankenhaus Salem'),(10930,8705,'no_lang_code','name','Kent SeaTech Corporation (United States)'),(10931,8706,'en','name','Aberdeen City Council'),(10932,8707,'no_lang_code','name','Lonza (United Kingdom)'),(10933,8708,'en','name','Ministry of Social Affairs and Social Services'),(10934,8708,'he','name','משרד הרווחה והשירותים החברתיים‎'),(10935,8709,'en','name','American Society for Nutrition'),(10936,8710,'en','name','American College of Gastroenterology'),(10937,8711,'no_lang_code','name','APT Therapeutics (United States)'),(10938,8712,'en','name','Meiho University'),(10939,8713,'en','name','Okayama Rosai Hospital'),(10940,8713,'ja','name','岡山労災病院'),(10941,8714,'no_lang_code','name','20/20 GeneSystem (United States)'),(10942,8715,'pl','name','Krakowskie Centrum Rehabilitacji'),(10943,8716,'en','name','Parkview Health'),(10944,8717,'en','name','Australian Academy of Technological Sciences and Engineering'),(10945,8718,'no_lang_code','name','Banyan Biomarkers (United States)'),(10946,8719,'en','name','Council for Chemical Research'),(10947,8720,'no_lang_code','name','Systems Technology (United States)'),(10948,8721,'en','name','Special Service for Groups'),(10949,8722,'en','name','American Institute of Architects'),(10950,8723,'no_lang_code','name','CarboMer (United States)'),(10951,8724,'no_lang_code','name','Optimum Therapeutics (United States)'),(10952,8725,'en','name','Center for Medical Education and Clinical Research Norberto Quirno'),(10953,8725,'es','name','Centro de Educación Médica e Investigaciones Clínicas Norberto Quirno'),(10954,8726,'en','name','Association of Public Health Laboratories'),(10955,8727,'en','name','St. Paul\'s Hospital'),(10956,8728,'no_lang_code','name','Odyssey Trust'),(10957,8729,'en','name','Glasgow Science Centre'),(10958,8730,'ja','name','ブリストル・マイヤーズ スクイブ'),(10959,8730,'no_lang_code','name','Bristol-Myers Squibb (Japan)'),(10960,8731,'no_lang_code','name','Magellan Aerospace (Canada)'),(10961,8732,'fr','name','Centre Hospitalier Intercommunal de Villeneuve-Saint-Georges'),(10962,8733,'en','name','Kestrel Institute'),(10963,8734,'en','name','Human Gene Therapy Research Institute'),(10964,8735,'no_lang_code','name','SatCon Technology Corporation (United States)'),(10965,8736,'no_lang_code','name','OncoImmune (United States)'),(10966,8737,'no_lang_code','name','Cellerant Therapeutics (United States)'),(10967,8738,'no_lang_code','name','Procter & Gamble (United States)'),(10968,8739,'en','name','Birmingham City Council'),(10969,8740,'no_lang_code','name','Vesuvius (United Kingdom)'),(10970,8741,'no_lang_code','name','IMPCO Technologies (Canada)'),(10971,8742,'de','name','Max-Planck-Institut für Psychiatrie'),(10972,8742,'en','name','Max Planck Institute of Psychiatry'),(10973,8743,'en','name','Vector Control Research Centre'),(10974,8744,'pt','name','Faculdade Evangélica do Paraná'),(10975,8745,'fr','name','Centre de Chirurgie Plastique'),(10976,8746,'no_lang_code','name','HemoCleanse (United States)'),(10977,8747,'is','name','Íslensk erfðagreining'),(10978,8747,'no_lang_code','name','deCODE Genetics (Iceland)'),(10979,8748,'no_lang_code','name','NovaFlux (United States)'),(10980,8749,'no_lang_code','name','C-Tech Innovation (United Kingdom)'),(10981,8750,'en','name','Occupational Health and Safety Research Institute'),(10982,8750,'fr','name','Institut de Recherche Robert-Sauvé en Santé et en Sécurité du Travail'),(10983,8751,'en','name','Maryville College'),(10984,8752,'no_lang_code','name','Pennon Group (United Kingdom)'),(10985,8753,'no_lang_code','name','Rocky Mountain Bicycles (Canada)'),(10986,8754,'en','name','Collinge and Associates'),(10987,8755,'no_lang_code','name','Zynex (United States)'),(10988,8756,'no_lang_code','name','Lectenz Bio (United States)'),(10989,8757,'no_lang_code','name','Associated Compiler Experts (Netherlands)'),(10990,8758,'en','name','Energy and Resources Institute'),(10991,8758,'ta','name','ஆற்றல் மற்றும் வளங்கள் நிறுவனம்'),(10992,8759,'de','name','Max Grundig Klinik'),(10993,8759,'en','name','Max Grundig Hospital'),(10994,8760,'en','name','Moredun Foundation'),(10995,8761,'en','name','Tokyo Metropolitan Geriatric Hospital'),(10996,8761,'ja','name','東京都健康長寿医療センター'),(10997,8762,'no_lang_code','name','Charles River Associates'),(10998,8763,'en','name','American Society of Human Genetics'),(10999,8764,'en','name','Arts Catalyst'),(11000,8765,'no_lang_code','name','Nanotherapeutics (United States)'),(11001,8766,'en','name','College of New Rochelle'),(11002,8767,'en','name','Institute of Education Sciences'),(11003,8768,'no_lang_code','name','QuantTera (United States)'),(11004,8769,'no_lang_code','name','Vajira Hospital'),(11005,8769,'th','name','วชิรพยาบาล'),(11006,8770,'no_lang_code','name','Dendritech (United States)'),(11007,8771,'no_lang_code','name','Bruker (Germany)'),(11008,8772,'en','name','Los Angeles Unified School District'),(11009,8773,'nl','name','Adelante'),(11010,8774,'es','name','Complejo Hospitalario de Ourense'),(11011,8775,'no_lang_code','name','Fundação Estadual de Produção e Pesquisa em Saúde'),(11012,8776,'en','name','St. Jude Medical Center'),(11013,8777,'no_lang_code','name','LumArray (United States)'),(11014,8778,'no_lang_code','name','Innovative BioTherapies (United States)'),(11015,8779,'en','name','American Society of Plant Biologists'),(11016,8780,'en','name','National Center for Nanoscience and Technology'),(11017,8780,'zh','name','国家纳米科学中心'),(11018,8781,'no_lang_code','name','Mediomics (United States)'),(11019,8782,'no_lang_code','name','Micropharma (Canada)'),(11020,8783,'no_lang_code','name','Sensor Electronic Technology (United States)'),(11021,8784,'en','name','Pellissippi State Community College'),(11022,8785,'en','name','Aspire Health Partners'),(11023,8786,'en','name','Tata Main Hospital'),(11024,8787,'no_lang_code','name','SeaLite Engineering (United States)'),(11025,8788,'de','name','Helios Kliniken'),(11026,8789,'no_lang_code','name','Novan Therapeutics (United States)'),(11027,8790,'en','name','Rehabilitation Engineering and Assistive Technology Society of North America'),(11028,8791,'en','name','Cleveland University'),(11029,8792,'en','name','Brevard County Board of County Commissioners'),(11030,8793,'en','name','Center for Creative Leadership'),(11031,8794,'en','name','Netherlands Pharmacovigilance Centre Lareb'),(11032,8794,'nl','name','Bijwerkingen Centrum Lareb'),(11033,8795,'no_lang_code','name','TLC Precision Wafer Technology (United States)'),(11034,8796,'en','name','Society of Hispanic Professional Engineers Foundation'),(11035,8797,'en','name','Palmetto General Hospital'),(11036,8798,'en','name','Hungarian Institute for Forensic Sciences'),(11037,8798,'hu','name','Bűnügyi Szakértői és Kutatóintézet'),(11038,8799,'it','name','Ospedale Vito Fazzi'),(11039,8800,'no_lang_code','name','Phoenicia Biosciences (United States)'),(11040,8801,'en','name','Defence Institute of Physiology and Allied Sciences'),(11041,8801,'hi','name','कार्यकी और संबद्ध विज्ञान रक्षा संस्थान'),(11042,8802,'no_lang_code','name','Ag-West Bio (Canada)'),(11043,8803,'no_lang_code','name','Rogue Research (Canada)'),(11044,8804,'en','name','National Institute of Occupational Health'),(11045,8805,'fr','name','Société Française de Rhumatologie'),(11046,8806,'en','name','Institute for Health and Recovery'),(11047,8807,'no_lang_code','name','Lonza (United States)'),(11048,8808,'en','name','Saskatchewan Disease Control Laboratory'),(11049,8809,'no_lang_code','name','Quidel Corporation (United States)'),(11050,8810,'en','name','Syrian Center for Tobacco Studies'),(11051,8811,'en','name','Our Lady of Lourdes Medical Center'),(11052,8812,'no_lang_code','name','Levin Group (United States)'),(11053,8813,'en','name','Bloomfield College'),(11054,8814,'en','name','San Diego Museum of Man'),(11055,8815,'no_lang_code','name','Degge Group (United States)'),(11056,8816,'en','name','Adelphi Laboratory Center'),(11057,8817,'en','name','American Congress of Obstetricians and Gynecologists'),(11058,8818,'no_lang_code','name','Thomas Keating Ltd'),(11059,8819,'no_lang_code','name','Knowledge Based Systems (United States)'),(11060,8820,'no_lang_code','name','VHA (United States)'),(11061,8821,'no_lang_code','name','Advanced Scientific Concepts (United States)'),(11062,8822,'no_lang_code','name','Material Methods (United States)'),(11063,8823,'no_lang_code','name','TRUMPF (United Kingdom)'),(11064,8824,'en','name','Sesame Workshop'),(11065,8825,'no_lang_code','name','CorTechs Labs (United States)'),(11066,8826,'en','name','National Veterinary Research Institute'),(11067,8827,'en','name','Visiting Nurse Associations of America'),(11068,8828,'en','name','Institute of Genetics and Biophysics'),(11069,8828,'it','name','Istituto di Genetica e Biofisica'),(11070,8829,'no_lang_code','name','Bridger Photonics (United States)'),(11071,8830,'en','name','Frontier Science & Technology Research Foundation'),(11072,8831,'en','name','Wisconsin Division of Public Health'),(11073,8832,'it','name','Ospedale SS. Annunziata'),(11074,8833,'en','name','Tokyo Metropolitan Children\'s Medical Center'),(11075,8833,'ja','name','東京都子供の医療センター'),(11076,8834,'en','name','Takeda'),(11077,8834,'ja','name','武田薬品工業'),(11078,8834,'no_lang_code','name','Takeda (Japan)'),(11079,8835,'no_lang_code','name','AquaTerra (United Kingdom)'),(11080,8836,'en','name','Netherlands Institute for Innovative Ocular Surgery'),(11081,8837,'no_lang_code','name','Dover (United States)'),(11082,8838,'la','name','Civita'),(11083,8839,'no_lang_code','name','Bionova Holding Corporation (United States)'),(11084,8840,'bg','name','Национален център по обществено здраве и анализи'),(11085,8840,'en','name','National Center of Public Health and Analyses'),(11086,8841,'en','name','Leeds General Infirmary'),(11087,8842,'no_lang_code','name','Pattern Discovery Technologies (Canada)'),(11088,8843,'en','name','Center for Disease Control'),(11089,8844,'no_lang_code','name','Critical Pharmaceuticals (United Kingdom)'),(11090,8845,'no_lang_code','name','Pall Corporation (United Kingdom)'),(11091,8846,'en','name','National Institute of Water and Atmospheric Research'),(11092,8847,'no_lang_code','name','Immtech Pharmaceuticals (United States)'),(11093,8848,'en','name','National Institute for Occupational Health'),(11094,8849,'en','name','Barraquer Opthalmology Center'),(11095,8849,'es','name','Clínica Oftalmológica Barraquer'),(11096,8850,'en','name','Change Happens'),(11097,8851,'en','name','San Antonio Uniformed Services Health Education Consortium'),(11098,8852,'en','name','Clinical and Laboratory Standards Institute'),(11099,8853,'it','name','Istituti Fisioterapici Ospitalieri'),(11100,8854,'en','name','Thrombosis and Atherosclerosis Research Institute'),(11101,8855,'en','name','Tianjin Hospital'),(11102,8855,'zh','name','天津市天津医院'),(11103,8856,'en','name','Graham International Implant Institute'),(11104,8857,'en','name','Osborne Head and Neck Institute'),(11105,8858,'ja','name','岡山中央病院'),(11106,8858,'no_lang_code','name','Okayama Central Hospital'),(11107,8859,'en','name','Tirat Carmel Mental Health Center'),(11108,8859,'he','name','המרכז לבריאות הנפש'),(11109,8860,'no_lang_code','name','Serco (United Kingdom)'),(11110,8861,'en','name','Swiss Paraplegic Research'),(11111,8862,'en','name','Stratheden Hospital'),(11112,8863,'en','name','TriHealth'),(11113,8864,'en','name','Museum of Science and Industry'),(11114,8865,'no_lang_code','name','Data Management Services (United States)'),(11115,8866,'no_lang_code','name','COI Ceramics (United States)'),(11116,8867,'en','name','Saving Sight'),(11117,8868,'en','name','Defence Science and Technology Laboratory'),(11118,8869,'fr','name','Centre d\'études de l\'emploi'),(11119,8870,'no_lang_code','name','TechLab (United States)'),(11120,8871,'no_lang_code','name','Hyper Tech Research (United States)'),(11121,8872,'no_lang_code','name','Atmospheric and Space Technology Research Associates (United States)'),(11122,8873,'no_lang_code','name','General Dynamics (United Kingdom)'),(11123,8874,'no_lang_code','name','Q-Track Corporation (United States)'),(11124,8875,'de','name','Sana Klinikum Offenbach'),(11125,8876,'no_lang_code','name','CJ America (United States)'),(11126,8877,'no_lang_code','name','King Shaw Associates (United Kingdom)'),(11127,8878,'no_lang_code','name','Pelamis Wave Power (United Kingdom)'),(11128,8879,'en','name','Ministry of Health'),(11129,8879,'pt','name','Ministério da Saúde'),(11130,8880,'no_lang_code','name','MD Precision (Canada)'),(11131,8881,'en','name','Waterford Institute'),(11132,8882,'en','name','Foundation for Independent Higher Education'),(11133,8883,'da','name','Svendborg Sygehus'),(11134,8884,'en','name','Biocor Institute'),(11135,8884,'es','name','Biocor Instituto'),(11136,8885,'en','name','St Louis Community College'),(11137,8886,'en','name','Eye Institute of Utah'),(11138,8887,'pt','name','Agência Para a Energia'),(11139,8888,'en','name','Amyotrophic Lateral Sclerosis Therapy Development Institute'),(11140,8889,'no_lang_code','name','GlobeImmune (United States)'),(11141,8890,'no_lang_code','name','North East of England Process Industry Cluster (United Kingdom)'),(11142,8891,'en','name','Silesian Center for Heart Disease'),(11143,8892,'en','name','Local Government Commission'),(11144,8893,'ja','name','横浜市立みなと赤十字病院'),(11145,8893,'no_lang_code','name','Yokohama Municipal Minato Red Cross Hospital'),(11146,8894,'no_lang_code','name','IPAC Chemicals (Canada)'),(11147,8895,'no_lang_code','name','Philips (United Kingdom)'),(11148,8896,'no_lang_code','name','Magor (Canada)'),(11149,8897,'en','name','St. Joseph\'s Hospital'),(11150,8898,'no_lang_code','name','Genomatica (United States)'),(11151,8899,'en','name','Seven Counties Services'),(11152,8900,'no_lang_code','name','Pd Ld (United States)'),(11153,8901,'en','name','EAC Network'),(11154,8902,'en','name','Sports Science Institute of South Africa'),(11155,8903,'en','name','Methodist Sports Medicine'),(11156,8904,'en','name','Miles College'),(11157,8905,'no_lang_code','name','Morphonix (United States)'),(11158,8906,'en','name','Molecular Biology Consortium'),(11159,8907,'no_lang_code','name','Syntrix Biosystems (United States)'),(11160,8908,'no_lang_code','name','Gencoa (United Kingdom)'),(11161,8909,'en','name','Ministry of Agriculture, Livestock, and Food Supply'),(11162,8909,'pt','name','Ministério da Agricultura, Pecuária e Abastecimento'),(11163,8910,'en','name','Museum of Life and Science'),(11164,8911,'en','name','Chadron State College'),(11165,8912,'en','name','Wholistic Stress Control Institute'),(11166,8913,'en','name','Chartered Institution of Civil Engineering Surveyors'),(11167,8914,'no_lang_code','name','Stratus Aeronautics (Canada)'),(11168,8915,'en','name','Turku City Hospital'),(11169,8915,'fi','name','Turun kaupunginsairaala'),(11170,8916,'en','name','Silverstein Institute'),(11171,8917,'es','name','Instituto de Neurología de Buenos Aires'),(11172,8918,'en','name','National Egg Regulatory Officials'),(11173,8919,'en','name','Point Richmond Tech Center'),(11174,8920,'en','name','Thai Moogambigai Dental College and Hospital'),(11175,8921,'no_lang_code','name','Owlstone Medical (United Kingdom)'),(11176,8922,'no_lang_code','name','RWE (United Kingdom)'),(11177,8923,'en','name','National Institute of Fitness and Sports in Kanoya'),(11178,8923,'ja','name','鹿屋体育大学'),(11179,8924,'en','name','Rochester Area Foundation'),(11180,8925,'en','name','American Pain Society'),(11181,8926,'en','name','National Institute for Mathematical Sciences'),(11182,8927,'no_lang_code','name','Alchem Laboratories (United States)'),(11183,8928,'no_lang_code','name','eHuman (United States)'),(11184,8929,'en','name','Town and Country Planning Association'),(11185,8930,'en','name','Saint Michael\'s Medical Center'),(11186,8931,'no_lang_code','name','Buffalo BioLabs'),(11187,8932,'fr','name','Centre Muraz'),(11188,8933,'en','name','Heartland Health Region'),(11189,8934,'no_lang_code','name','Santec Systems (United States)'),(11190,8935,'en','name','Lake County'),(11191,8936,'no_lang_code','name','Humanitas (United States)'),(11192,8937,'ja','name','岡山済生会総合病院'),(11193,8937,'no_lang_code','name','Okayama Saiseikai General Hospital'),(11194,8938,'no_lang_code','name','Advanced Materials and Devices (United States)'),(11195,8939,'no_lang_code','name','CSL (Germany)'),(11196,8940,'no_lang_code','name','Leatherhead Food Research'),(11197,8941,'fr','name','Centre d’Étude et de Valorisation des Algues'),(11198,8942,'en','name','Taichung Armed Forces General Hospital'),(11199,8942,'zh','name','國軍臺中總醫院'),(11200,8943,'en','name','Council for the Advancement of Science Writing'),(11201,8944,'en','name','Research Institute of Innovative Technology for the Earth'),(11202,8944,'ja','name','地球環境産業技術研究機構'),(11203,8945,'en','name','Montshire Museum of Science'),(11204,8946,'en','name','Carbon Trust'),(11205,8947,'no_lang_code','name','Scott Instrument Company (United States)'),(11206,8948,'no_lang_code','name','HiretheWorld (Canada)'),(11207,8949,'en','name','Ducks Unlimited Canada'),(11208,8949,'fr','name','Canards Illimités Canada'),(11209,8950,'no_lang_code','name','Brain Insights (United States)'),(11210,8951,'en','name','St. John\'s Hospital'),(11211,8952,'no_lang_code','name','Westinghouse Electric (United States)'),(11212,8953,'de','name','Sozialstiftung Bamberg'),(11213,8954,'no_lang_code','name','ScienceScope (United Kingdom)'),(11214,8955,'en','name','Orthopedic Specialty Hospital'),(11215,8956,'en','name','Stobhill Hospital'),(11216,8957,'en','name','Actua'),(11217,8958,'en','name','American Council of Learned Societies'),(11218,8959,'en','name','Wolters Kluwer Health'),(11219,8960,'pt','name','Instituto de Moléstias Cardiovasculares'),(11220,8961,'en','name','Sasha Bruce Youthwork'),(11221,8962,'en','name','Illinois College of Optometry'),(11222,8963,'en','name','Ulster Hospital'),(11223,8964,'en','name','Norton Medical Centre'),(11224,8965,'en','name','Detroit Area Pre College Engineering Program'),(11225,8966,'no_lang_code','name','Arbutus Biopharma (Canada)'),(11226,8967,'no_lang_code','name','Field Diagnostic Services (United States)'),(11227,8968,'en','name','Lexington Clinic'),(11228,8969,'pt','name','Instituto de Neurologia de Curitiba'),(11229,8970,'en','name','Zoological Society of San Diego'),(11230,8971,'no_lang_code','name','3T Ophthalmics (United States)'),(11231,8972,'da','name','Sygehus Sønderjylland'),(11232,8972,'en','name','Hospital of Southern Jutland'),(11233,8973,'no_lang_code','name','CardioFocus (United States)'),(11234,8974,'en','name','Myers-JDC-Brookdale Institute'),(11235,8975,'no_lang_code','name','Integra LifeSciences (United States)'),(11236,8976,'en','name','Institute of Bioinformatics and Applied Biotechnology'),(11237,8977,'en','name','Bourn Hall Clinic'),(11238,8978,'no_lang_code','name','Social Sectors Development Strategies (United States)'),(11239,8979,'en','name','National Veterinary Research and Quarantine Service'),(11240,8980,'en','name','National Hospital of Pediatrics'),(11241,8981,'bn','name','পশ্চিমবঙ্গ রাষ্ট্রীয় বিশ্ববিদ্যালয়'),(11242,8981,'en','name','West Bengal State University'),(11243,8982,'en','name','Peralta Community College District'),(11244,8983,'es','name','Institut Kaplan'),(11245,8984,'no_lang_code','name','Fortis Hospital'),(11246,8985,'no_lang_code','name','Split Engineering (United States)'),(11247,8986,'en','name','Independent Colleges Office'),(11248,8987,'en','name','Rhode Island Spine Center'),(11249,8988,'en','name','DigiBC (Canada)'),(11250,8989,'en','name','California Institute for Biomedical Research'),(11251,8990,'fr','name','ADERA'),(11252,8991,'en','name','Oklahoma Foundation for Medical Quality'),(11253,8992,'ja','name','大阪府済生会茨木病院'),(11254,8992,'no_lang_code','name','Saiseikai Ibaraki Hospital'),(11255,8993,'no_lang_code','name','Bruker (United States)'),(11256,8994,'no_lang_code','name','AstraZeneca (United Kingdom)'),(11257,8995,'no_lang_code','name','Wellstat (United States)'),(11258,8996,'no_lang_code','name','Cumberland Pharmaceuticals (United States)'),(11259,8997,'no_lang_code','name','Heidelberg University'),(11260,8998,'no_lang_code','name','Eion (Canada)'),(11261,8999,'en','name','Alberta Science Network'),(11262,9000,'no_lang_code','name','Perceptronics Solutions (United States)'),(11263,9001,'no_lang_code','name','Phytronix (Canada)'),(11264,9002,'no_lang_code','name','Kodak (United States)'),(11265,9003,'no_lang_code','name','Apogee Biotechnology (United States)'),(11266,9004,'en','name','Parkland Health & Hospital System'),(11267,9005,'no_lang_code','name','Molecular Oncology (United States)'),(11268,9006,'en','name','North Carolina State Education Assistance Authority'),(11269,9007,'en','name','Joseph Rowntree Foundation'),(11270,9008,'en','name','Central Tuber Crops Research Institute'),(11271,9009,'en','name','Muroran Institute of Technology'),(11272,9009,'ja','name','室蘭工業大学'),(11273,9010,'en','name','Defiance College'),(11274,9011,'en','name','Asian American Recovery Services'),(11275,9012,'en','name','Nevada Division of Public and Behavioral Health'),(11276,9013,'no_lang_code','name','CemeCon (Germany)'),(11277,9014,'en','name','Netherlands Forensic Institute'),(11278,9014,'nl','name','Nederlands Forensisch Instituut'),(11279,9015,'en','name','Macomb Community College'),(11280,9016,'no_lang_code','name','Qiagen (United States)'),(11281,9017,'no_lang_code','name','Circulatory Technology (United States)'),(11282,9018,'en','name','Tate'),(11283,9019,'en','name','Hindu College of Pharmacy'),(11284,9020,'en','name','St. Francis Medical Center'),(11285,9021,'ja','name','大日本住友製薬株式会社'),(11286,9021,'no_lang_code','name','Sumitomo Dainippon Pharma (Japan)'),(11287,9022,'no_lang_code','name','Clod Ensemble (United Kingdom)'),(11288,9023,'no_lang_code','name','ITI Energy (United Kingdom)'),(11289,9024,'en','name','Gabrichevsky Institute of Epidemiology and Microbiology'),(11290,9024,'ru','name','Московский научно-исследовательский институт эпидемиологии и микробиологии им.Г.Н.Габричевского'),(11291,9025,'no_lang_code','name','TechEn (United States)'),(11292,9026,'en','name','Museum of Science and Industry'),(11293,9027,'en','name','Contra Costa Community College District'),(11294,9028,'no_lang_code','name','EP (United States)'),(11295,9029,'en','name','Defence Research and Development Establishment'),(11296,9029,'ta','name','இந்திய பாதுகாப்பு ஆராய்ச்சி மேம்பாட்டு தொழிலகம்'),(11297,9030,'no_lang_code','name','Altria (United States)'),(11298,9031,'en','name','Tusculum College'),(11299,9032,'en','name','Fast Track Drugs and Biologics'),(11300,9033,'no_lang_code','name','Ogilvy Public Relations (United States)'),(11301,9034,'pt','name','Instituto Dante Pazzanese de Cardiologia'),(11302,9035,'no_lang_code','name','Luxfer Group (United Kingdom)'),(11303,9036,'en','name','Cabrillo College'),(11304,9037,'no_lang_code','name','Weidlinger Associates (United States)'),(11305,9038,'fr','name','Centre Hospitalier Laennec'),(11306,9039,'cs','name','Endokrinologický ústav'),(11307,9039,'en','name','Institute of Endocrinology'),(11308,9040,'en','name','Winchester Medical Center'),(11309,9041,'en','name','Vancouver Aquarium'),(11310,9042,'no_lang_code','name','Mimosa Acoustics (United States)'),(11311,9043,'no_lang_code','name','Medical Discovery Partners (United States)'),(11312,9044,'en','name','Inter-American Tropical Tuna Commission'),(11313,9044,'es','name','Comisión Interamericana del Atún Tropical'),(11314,9045,'en','name','AdventHealth Tampa'),(11315,9046,'no_lang_code','name','Araim Pharmaceuticals (United States)'),(11316,9047,'en','name','National Institute of Mental Health'),(11317,9047,'ja','name','国立精神衛生研究所'),(11318,9048,'en','name','National Institute of Nutrition'),(11319,9048,'vi','name','Viện Dinh Dưỡng Quốc Gia'),(11320,9049,'no_lang_code','name','Novartis (Austria)'),(11321,9050,'no_lang_code','name','GlycoMira Therapeutics (United States)'),(11322,9051,'no_lang_code','name','Molecular Design International (United States)'),(11323,9052,'en','name','Appalachian College Association'),(11324,9053,'en','name','Central Drug Research Institute'),(11325,9053,'hi','name','केन्द्रीय औषधि अनुसंधान संस्थान'),(11326,9053,'te','name','కేంద్రీయ ఔషధ పరిశోధనా సంస్థ'),(11327,9054,'no_lang_code','name','Protein Potential (United States)'),(11328,9055,'no_lang_code','name','Sofina Foods (Canada)'),(11329,9056,'en','name','Mountain Empire Community College'),(11330,9057,'no_lang_code','name','Pipeline Industries Guild (United Kingdom)'),(11331,9058,'no_lang_code','name','Control Technology Incorporation (United States)'),(11332,9059,'en','name','Zhengzhou People\'s Hospital'),(11333,9059,'zh','name','郑州人民医院网站'),(11334,9060,'en','name','Michigan Ear Institute'),(11335,9061,'en','name','BPP University'),(11336,9062,'no_lang_code','name','Herman Miller (United States)'),(11337,9063,'en','name','Alcohol Research Group'),(11338,9064,'ja','name','豊岡病院'),(11339,9064,'no_lang_code','name','Toyooka Hospital'),(11340,9065,'en','name','Asian Cultural Council'),(11341,9066,'no_lang_code','name','Viva Pharmaceutical (Canada)'),(11342,9067,'no_lang_code','name','Advanced Tissue (United States)'),(11343,9068,'no_lang_code','name','A&L Canada Laboratories (Canada)'),(11344,9069,'no_lang_code','name','Saltire Software (United States)'),(11345,9070,'no_lang_code','name','Poly Med (United States)'),(11346,9071,'nl','name','Rijndam Revalidatiecentrum'),(11347,9072,'fr','name','Centre National de la Médecine et des Sciences des Sports'),(11348,9073,'en','name','Eastern Florida State College'),(11349,9074,'en','name','Institute of Nutrition and Food Hygiene'),(11350,9074,'es','name','Instituto de Nutricion e Higiene de los Alimentos'),(11351,9075,'no_lang_code','name','Superconducting Systems (United States)'),(11352,9076,'no_lang_code','name','Karyopharm Therapeutics (United States)'),(11353,9077,'no_lang_code','name','ITN Energy Systems (United States)'),(11354,9078,'no_lang_code','name','Ebert and Associates'),(11355,9079,'en','name','Tarrant County College'),(11356,9080,'en','name','Tucson Orthopaedic Institute'),(11357,9081,'en','name','Sumitomo Besshi Hospital'),(11358,9081,'ja','name','住友別子病院'),(11359,9082,'no_lang_code','name','Biosearch Technologies (United States)'),(11360,9083,'en','name','Bank Street College of Education'),(11361,9084,'no_lang_code','name','Fu Associates (United States)'),(11362,9085,'en','name','Fukuoka Industrial Technology Center'),(11363,9085,'ja','name','福岡県工業技術センター'),(11364,9086,'no_lang_code','name','Convergent Engineering (United States)'),(11365,9087,'en','name','Mohave Community College'),(11366,9088,'no_lang_code','name','Applied Energetics (United States)'),(11367,9089,'en','name','Cheltenham Festivals'),(11368,9090,'no_lang_code','name','NovaDigm Therapeutics (United States)'),(11369,9091,'no_lang_code','name','BioVectra (Canada)'),(11370,9092,'en','name','Belmont Center for Comprehensive Treatment'),(11371,9093,'de','name','Friedrich Miescher Laboratory, Friedrich-Miescher-Laboratorium für Biologische Arbeitsgruppen in der Max-Planck-Gesellschaft'),(11372,9094,'nl','name','Crucell'),(11373,9094,'no_lang_code','name','Johnson & Johnson (Netherlands)'),(11374,9095,'en','name','Pinkus Dermatopathology Laboratory'),(11375,9096,'en','name','International Water Management Institute'),(11376,9097,'no_lang_code','name','Applied Research Associates (United States)'),(11377,9098,'ja','name','エーザイ株式会社'),(11378,9098,'no_lang_code','name','Eisai (Japan)'),(11379,9099,'no_lang_code','name','Ansun BioPharma (United States)'),(11380,9100,'en','name','Constructing Excellence'),(11381,9101,'en','name','Orange County Heart Institute and Research Center'),(11382,9102,'ja','name','宝塚市立病院'),(11383,9102,'no_lang_code','name','Takarazuka City Hospital'),(11384,9103,'en','name','LaGrange College'),(11385,9104,'no_lang_code','name','Diffinity Genomics (United States)'),(11386,9105,'en','name','MalariaGEN'),(11387,9106,'no_lang_code','name','Rohde & Schwarz (United Kingdom)'),(11388,9107,'no_lang_code','name','Nanospectra Biosciences (United States)'),(11389,9108,'en','name','Candiolo Cancer Institute'),(11390,9108,'fr','name','Istituto di Candiolo'),(11391,9109,'no_lang_code','name','ABB (United Kingdom)'),(11392,9110,'en','name','Center for Crisis Psychology'),(11393,9110,'no','name','Senter for Krisepsykologi'),(11394,9111,'no_lang_code','name','La Jolla Pharmaceutical (United States)'),(11395,9112,'en','name','Standing to Achieve New Directions'),(11396,9113,'de','name','Klinikum Saarbrücken'),(11397,9114,'en','name','Gold Skin Care Center'),(11398,9115,'en','name','Nordland Hospital Trust'),(11399,9115,'no','name','Nordlandssykehuset'),(11400,9116,'no_lang_code','name','Sengenia (United Kingdom)'),(11401,9117,'en','name','Phoenix Houses of New England'),(11402,9118,'en','name','Pacific Health Foundation'),(11403,9119,'no_lang_code','name','Mercator MedSystems (United States)'),(11404,9120,'de','name','Belgische Wissenschaftsinstitut für Öffentliche Gesundheit'),(11405,9120,'en','name','Scientific Institute of Public Health'),(11406,9120,'fr','name','Institut Scientifique de Santé Publique'),(11407,9120,'nl','name','Wetenschappelijk Instituut Volksgezondheid'),(11408,9121,'en','name','Civil Aviation Authority'),(11409,9122,'no_lang_code','name','AstraZeneca (Sweden)'),(11410,9123,'it','name','Azienda Ospedaliera Sant’Antonio Abate di Gallarate'),(11411,9124,'en','name','Northern Virginia Community College'),(11412,9125,'en','name','Rhode Island Department of Children, Youth & Families'),(11413,9126,'en','name','Tokyo Rosai Hospital'),(11414,9126,'ja','name','東京労災病院'),(11415,9127,'no_lang_code','name','Istituto De Angeli (Italy)'),(11416,9128,'en','name','Dutch College of General Practitioners'),(11417,9128,'nl','name','Nederlands Huisartsen Genootschap'),(11418,9129,'en','name','Piedmont HealthCare'),(11419,9130,'en','name','Captain James A. Lovell Federal Health Care Center'),(11420,9131,'en','name','Skin and Cancer Foundation'),(11421,9132,'no_lang_code','name','Lasmed (United States)'),(11422,9133,'no_lang_code','name','Pfizer (United Kingdom)'),(11423,9134,'no_lang_code','name','Sunny BioDiscovery (United States)'),(11424,9135,'no_lang_code','name','Aptose Biosciences (Canada)'),(11425,9136,'cy','name','Cyfoeth Naturiol Cymru'),(11426,9136,'en','name','Natural Resources Wales'),(11427,9137,'en','name','Triton College'),(11428,9138,'en','name','DDL Diagnostic Laboratory'),(11429,9139,'en','name','National Institute of Mental Health'),(11430,9139,'es','name','Instituto Nacional de Salud Mental'),(11431,9140,'no_lang_code','name','Reveo (United States)'),(11432,9141,'no_lang_code','name','Fox Chase Chemical Diversity Center'),(11433,9142,'no_lang_code','name','Aptuit (Italy)'),(11434,9143,'en','name','Elms College'),(11435,9144,'no_lang_code','name','PermSelect (United States)'),(11436,9145,'pt','name','Instituto Evandro Chagas'),(11437,9146,'de','name','Chemotherapeutisches Forschungsinstitut Georg-Speyer-Haus, Georg Speyer Haus'),(11438,9147,'no_lang_code','name','NeuroWave Systems (United States)'),(11439,9148,'en','name','Institute for Research in Fundamental Sciences'),(11440,9148,'fa','name','پژوهشگاه دانش‌های بنیادی'),(11441,9149,'en','name','Academy of the Social Sciences in Australia'),(11442,9150,'no_lang_code','name','Genesegues (United States)'),(11443,9151,'en','name','Institute for Myeloma & Bone Cancer Research'),(11444,9152,'de','name','Max-Planck-Institut für Biologie des Alterns'),(11445,9152,'en','name','Max Planck Institute for Biology of Ageing'),(11446,9153,'no_lang_code','name','Caelum Research Corporation (United States)'),(11447,9154,'en','name','Oasis of Hope Hospital'),(11448,9155,'no_lang_code','name','Sitar (United States)'),(11449,9156,'no_lang_code','name','Xoran Technologies (United States)'),(11450,9157,'en','name','Bucks County Division of Human Services'),(11451,9158,'fr','name','Laboratoire National de Santé'),(11452,9159,'no_lang_code','name','Aciont (United States)'),(11453,9160,'am','name','ጥቁር አንበሳ ሆስፒታል'),(11454,9160,'en','name','Tikur Anbessa Hospital'),(11455,9161,'es','name','Centro Médico Docente La Trinidad'),(11456,9162,'en','name','Montana State University–Northern'),(11457,9163,'en','name','Cure Spinal Muscular Atrophy'),(11458,9164,'en','name','Child and Family Research Institute'),(11459,9165,'no_lang_code','name','APD Life Sciences (United States)'),(11460,9166,'en','name','National Rehabilitation Center'),(11461,9166,'ko','name','국립재활원'),(11462,9167,'no_lang_code','name','Demtroys (Canada)'),(11463,9168,'no_lang_code','name','Reaction Engineering International (United States)'),(11464,9169,'en','name','Tosei General Hospital'),(11465,9169,'ja','name','公立陶生病院'),(11466,9170,'en','name','European Society of Concurrent Enterprising Network'),(11467,9170,'it','name','Società Europea di Rete Concorrente Simultanea'),(11468,9171,'no_lang_code','name','Neurobehavioral Research (United States)'),(11469,9172,'no_lang_code','name','James Cropper (United Kingdom)'),(11470,9173,'en','name','Cardiovascular Research Foundation'),(11471,9174,'en','name','Animal Diseases Research Institute'),(11472,9175,'en','name','Centre for Mental Health'),(11473,9176,'no_lang_code','name','Monsanto (United Kingdom)'),(11474,9177,'no_lang_code','name','Janssen (Belgium)'),(11475,9178,'en','name','College of the Mainland'),(11476,9179,'no_lang_code','name','Detroit R&D (United States)'),(11477,9180,'en','name','Whittier College'),(11478,9180,'fr','name','Collège whittier'),(11479,9181,'no_lang_code','name','Spectros Corporation (United States)'),(11480,9182,'no_lang_code','name','Cogmation Robotics (Canada)'),(11481,9183,'en','name','National Health Service Scotland'),(11482,9184,'en','name','Conference Board'),(11483,9185,'en','name','National Association of Health Data Organizations'),(11484,9186,'en','name','Ibaraki Prefectural Livestock Center'),(11485,9186,'ja','name','畜産センター／茨城県'),(11486,9187,'no_lang_code','name','Applied Sciences (United States)'),(11487,9188,'en','name','Franklin Regional Council of Governments'),(11488,9189,'en','name','Metropolitan Police Service'),(11489,9190,'en','name','Osys Technology'),(11490,9191,'en','name','Arthritis Foundation'),(11491,9192,'en','name','Fukuoka Dental College'),(11492,9192,'ja','name','福岡歯科大学'),(11493,9193,'en','name','Cankdeska Cikana Community College'),(11494,9194,'no_lang_code','name','Neurotronics (United States)'),(11495,9195,'de','name','Klinikum Ernst von Bergmann'),(11496,9196,'en','name','National Co-ordinating Centre for Public Engagement'),(11497,9197,'en','name','Pacific Resources for Education and Learning'),(11498,9198,'no_lang_code','name','Predictive Biology (United States)'),(11499,9199,'en','name','National Institute of Plant Genome Research'),(11500,9200,'no_lang_code','name','Arzeda (United States)'),(11501,9201,'en','name','National Institute for Occupational Safety and Health'),(11502,9202,'es','name','Parque Tecnológico de la Salud'),(11503,9203,'no_lang_code','name','Affymax (United States)'),(11504,9204,'no_lang_code','name','Cardno (United States)'),(11505,9205,'no_lang_code','name','STRATA Skin Sciences (United States)'),(11506,9206,'no_lang_code','name','Porter Novelli (United States)'),(11507,9207,'en','name','Fertility Center of Las Vegas'),(11508,9208,'en','name','Mater Hospital'),(11509,9209,'no_lang_code','name','Neuro Device Innovations (United States)'),(11510,9210,'en','name','National Alliance for Hispanic Health'),(11511,9211,'no_lang_code','name','Ajinomoto (Russia)'),(11512,9211,'ru','name','Аджиномото'),(11513,9212,'no_lang_code','name','Health Decisions (United States)'),(11514,9213,'no_lang_code','name','Arbor Vita (United States)'),(11515,9214,'en','name','Accents On Health'),(11516,9215,'en','name','Nemours Children\'s Clinic'),(11517,9216,'no_lang_code','name','Technology International Incorporated of Virginia (United States)'),(11518,9217,'no_lang_code','name','NeuroNexus (United States)'),(11519,9218,'en','name','Association of Occupational and Environmental Clinics'),(11520,9219,'no_lang_code','name','Enzon Pharmaceuticals (United States)'),(11521,9220,'es','name','Instituto de Cardiología y Cirugía Cardiovascular'),(11522,9221,'en','name','Ohio Academy of Science'),(11523,9222,'no_lang_code','name','Tasktop Technologies (Canada)'),(11524,9223,'no_lang_code','name','BrightOutcome (United States)'),(11525,9224,'en','name','Age UK'),(11526,9225,'en','name','Lane Community College'),(11527,9226,'en','name','National Forensic Institute'),(11528,9227,'no_lang_code','name','TerraBioGen (Canada)'),(11529,9228,'en','name','HealthRIGHT 360'),(11530,9229,'no_lang_code','name','Newton Labs (United States)'),(11531,9230,'nl','name','Stichting Epilepsie Instellingen Nederland'),(11532,9231,'no_lang_code','name','McGuireWoods'),(11533,9232,'no_lang_code','name','Sartorius (United Kingdom)'),(11534,9233,'no_lang_code','name','NuPotential (United States)'),(11535,9234,'en','name','Massachusetts Executive Office of Health and Human Services'),(11536,9235,'en','name','Kidney Centre'),(11537,9236,'no_lang_code','name','Thoratec Corporation (United States)'),(11538,9237,'en','name','Waianae Coast Comprehensive Health Center'),(11539,9238,'hu','name','Országos Korányi Tbc és Pulmonológiai Intézet'),(11540,9239,'de','name','St. Franziskus Hospital'),(11541,9240,'en','name','National Institute of Animal Health'),(11542,9240,'ja','name','動物衛生研究部門'),(11543,9241,'en','name','Yamaguchi Prefecture Central Hospital'),(11544,9241,'ja','name','山口県立総合医療センター'),(11545,9242,'en','name','Boston Children\'s Museum'),(11546,9243,'no_lang_code','name','Site Vision Surveys (United Kingdom)'),(11547,9244,'no_lang_code','name','Chrysalis BioTherapeutics (United States)'),(11548,9245,'no_lang_code','name','Biolog (United States)'),(11549,9246,'en','name','Lincoln University - Pennsylvania'),(11550,9246,'es','name','Universidad Lincoln'),(11551,9247,'en','name','Wesley Long Hospital'),(11552,9248,'no_lang_code','name','Electro Energy (United States)'),(11553,9249,'en','name','Sindh Institute of Urology and Transplantation'),(11554,9250,'no_lang_code','name','Chiral Photonics (United States)'),(11555,9251,'en','name','Royal Blackburn Teaching Hospital'),(11556,9252,'no_lang_code','name','Athens Research and Technology (United States)'),(11557,9253,'no_lang_code','name','Thrombodyne (United States)'),(11558,9254,'en','name','Central Institute of Medicinal and Aromatic Plants'),(11559,9254,'hi','name','केन्द्रीय औषधीय एवं सगंध पौधा संस्थान'),(11560,9254,'ml','name','സെൻട്രൽ ഇൻസ്റ്റിറ്റ്യൂട്ട് ഓഫ് മെഡിസിനൽ ആന്റ് അരോമാറ്റിക് പ്ലാൻറ്സ്'),(11561,9255,'fr','name','Centre de Génétique Moléculaire'),(11562,9256,'en','name','Panagiotis & Aglaia Kyriakou Children\'s Hospital'),(11563,9257,'no_lang_code','name','Active Space Technologies (Portugal)'),(11564,9258,'en','name','National Institute of Oceanography and Fisheries'),(11565,9259,'en','name','Vocational Instruction Project Community Services'),(11566,9260,'de','name','Museum für Naturkunde'),(11567,9260,'en','name','Museum für Naturkunde - Leibniz Institute for Evolution and Biodiversity Science'),(11568,9261,'no_lang_code','name','CHI Systems (United States)'),(11569,9262,'en','name','Faculty of Medicine of São José do Rio Preto'),(11570,9262,'pt','name','Faculdade de Medicina de São José do Rio Preto'),(11571,9263,'en','name','Arkansas Academy of Science'),(11572,9264,'no_lang_code','name','Hepatitis B Foundation'),(11573,9265,'en','name','Nuclear Threat Initiative'),(11574,9266,'no_lang_code','name','Polatomic (United States)'),(11575,9267,'en','name','Austin College'),(11576,9268,'no_lang_code','name','Organix (United States)'),(11577,9269,'en','name','Institute of Chemical Kinetics and Combustion'),(11578,9269,'ru','name','Федеральное государственное бюджетное учреждение науки Институт химической кинетики и горения им. В.В. Воеводского Сибирского отделения Российской академии наук'),(11579,9270,'no_lang_code','name','MAST Carbon (United Kingdom)'),(11580,9271,'no_lang_code','name','DSM (Canada)'),(11581,9272,'no_lang_code','name','Linde (United Kingdom)'),(11582,9273,'en','name','St. Joseph Medical Center'),(11583,9274,'no_lang_code','name','Total Child Health (United States)'),(11584,9275,'en','name','Foundation for Applied Molecular Evolution'),(11585,9276,'en','name','Trident Technical College'),(11586,9277,'en','name','Asian and Pacific Islander Wellness Center'),(11587,9278,'en','name','National Center for Clinical Laboratories'),(11588,9279,'en','name','Actuarial Research Corporation'),(11589,9280,'no_lang_code','name','LKT Laboratories (United States)'),(11590,9281,'it','name','Ospedale Eugenio Morelli'),(11591,9282,'fr','name','Centre Cardiologique du Nord'),(11592,9283,'pt','name','Secretaria Municipal de Saúde'),(11593,9284,'en','name','Mitsubishi Chemical Holdings'),(11594,9284,'ja','name','株式会社三菱ケミカルホールディングス'),(11595,9284,'no_lang_code','name','Mitsubishi Chemical Holdings (Japan)'),(11596,9285,'en','name','Jawaharlal Nehru Centre for Advanced Scientific Research'),(11597,9286,'ja','name','済生会滋賀県病院'),(11598,9286,'no_lang_code','name','Saiseikai Shigaken Hospital'),(11599,9287,'en','name','School for Advanced Research'),(11600,9288,'en','name','American Academy of Cosmetic Dentistry'),(11601,9289,'en','name','New England Complex Systems Institute'),(11602,9290,'no_lang_code','name','Osmania General Hospital'),(11603,9290,'te','name','ఉస్మానియా జనరల్ హాస్పిటల్'),(11604,9291,'ja','name','吉祥寺あさひ病院は'),(11605,9291,'no_lang_code','name','Toujinkai Hospital'),(11606,9292,'no_lang_code','name','Fractal Systems (Canada)'),(11607,9293,'no_lang_code','name','Precision Optics Corporation (United States)'),(11608,9294,'no_lang_code','name','Airak (United States)'),(11609,9295,'en','name','Favaloro Foundation'),(11610,9296,'no_lang_code','name','Photek (United Kingdom)'),(11611,9297,'en','name','Institute of Crop Science'),(11612,9297,'ja','name','次世代作物開発研究センター'),(11613,9298,'en','name','Swami Vivekanand Subharti University'),(11614,9299,'en','name','Institute for Molecular Medicine'),(11615,9300,'no_lang_code','name','Vescent Photonics (United States)'),(11616,9301,'en','name','Center for Severe Weather Research'),(11617,9302,'en','name','Canadian Coalition for Global Health Research'),(11618,9303,'no_lang_code','name','MATECH (United States)'),(11619,9304,'no_lang_code','name','Beryllium (United States)'),(11620,9305,'en','name','Institute for Infocomm Research'),(11621,9306,'en','name','Economic Policy Institute'),(11622,9307,'en','name','St. Luke\'s Hospital'),(11623,9308,'en','name','Whiston Hospital'),(11624,9309,'fr','name','Institut Alfred Fournier'),(11625,9310,'en','name','Pandit Bhagwat Dayal Sharma Post Graduate Institute of Medical Sciences'),(11626,9311,'en','name','Takayama Red Cross Hospital'),(11627,9311,'ja','name','高山赤十字病院'),(11628,9312,'no_lang_code','name','Sasken (India)'),(11629,9313,'en','name','International Crops Research Institute for the Semi-Arid Tropics'),(11630,9314,'no_lang_code','name','Guided Therapeutics (United States)'),(11631,9315,'en','name','Brookhaven Science Associates'),(11632,9316,'en','name','Alamo Colleges'),(11633,9317,'no_lang_code','name','PAREXEL International (France)'),(11634,9318,'es','name','Instituto Cardiovascular de Buenos Aires'),(11635,9319,'en','name','American Thoracic Society'),(11636,9320,'no_lang_code','name','DNASTAR (United States)'),(11637,9321,'no_lang_code','name','Dimera (United States)'),(11638,9322,'no_lang_code','name','Quantronix (United States)'),(11639,9323,'en','name','Council of Graduate Schools'),(11640,9324,'en','name','Center for American Archeology'),(11641,9325,'no_lang_code','name','Toshiba (United Kingdom)'),(11642,9326,'no_lang_code','name','Advanced Ceramics Manufacturing (United States)'),(11643,9327,'en','name','Western Institute For Biomedical Research'),(11644,9328,'no_lang_code','name','Envigo (United States)'),(11645,9329,'en','name','San Francisco Community Clinic Consortium'),(11646,9330,'en','name','Innovative Designs in Environments for an Aging Society'),(11647,9331,'en','name','Institute of Biochemistry'),(11648,9332,'en','name','Oregon Health Authority'),(11649,9333,'en','name','Aspirus Wausau Hospital'),(11650,9334,'en','name','Southern Colorado Clinic'),(11651,9335,'en','name','Native American Rehabilitation Association'),(11652,9336,'no_lang_code','name','InDevR (United States)'),(11653,9337,'no_lang_code','name','Supercon (United States)'),(11654,9338,'it','name','Istituto di Analisi dei Sistemi ed Informatica Antonio Ruberti'),(11655,9339,'en','name','Hyogo Prefectural Cancer Center'),(11656,9339,'ja','name','兵庫県立がんセンター'),(11657,9340,'no_lang_code','name','MultiCell Technologies (United States)'),(11658,9341,'en','name','Samuel S Fels Fund'),(11659,9342,'en','name','Georgia Department of Behavioral Health and Developmental Disabilities'),(11660,9343,'en','name','International Institute of Tropical Agriculture'),(11661,9343,'fr','name','Institut International d\'Agriculture Tropicale'),(11662,9344,'en','name','Teratology Society'),(11663,9345,'en','name','Manchester City Council'),(11664,9346,'en','name','Gatorade Sports Science Institute'),(11665,9347,'it','name','Servizio Sanitario Nazionale'),(11666,9348,'el','name','Νοσοκομείο Αφροδισίων & Δερματικών Νόσων Θεσσαλονίκης'),(11667,9348,'en','name','Hospital Venereal and Skin Diseases Thessaloniki'),(11668,9349,'no_lang_code','name','Neuros Medical (United States)'),(11669,9350,'en','name','Pankey Institute'),(11670,9351,'en','name','United States Breastfeeding Committee'),(11671,9352,'en','name','Carlsberg Laboratory'),(11672,9353,'no_lang_code','name','Walter Knoll (Germany)'),(11673,9354,'no_lang_code','name','ADVA Optical Networking (Germany)'),(11674,9355,'en','name','Southern New England Rehabilitation Center'),(11675,9356,'ja','name','大久保病院'),(11676,9356,'no_lang_code','name','Ohkubo Hospital'),(11677,9357,'en','name','Wentworth Hospital'),(11678,9358,'fr','name','Les Scientifines'),(11679,9359,'en','name','Ontario Tobacco Research Unit'),(11680,9359,'fr','name','Unite de Recherche sur le Tabac de L\'Ontario'),(11681,9360,'no_lang_code','name','EpiVax (United States)'),(11682,9361,'no_lang_code','name','Analogic (Canada)'),(11683,9362,'en','name','Headache Care Center'),(11684,9363,'en','name','Hellenic Center for Disease Control & Prevention'),(11685,9364,'en','name','World Health Organization - Egypt'),(11686,9364,'fr','name','Organisation mondiale de la santé'),(11687,9364,'ru','name','Всемирная организация здравоохранения'),(11688,9365,'en','name','Roy Castle Lung Cancer Foundation'),(11689,9366,'en','name','Phillips Academy'),(11690,9367,'no_lang_code','name','Gilead Sciences (United States)'),(11691,9368,'no_lang_code','name','Industrial Science & Technology Network (United States)'),(11692,9369,'pl','name','Instytut Farmaceutyczny'),(11693,9370,'en','name','Sterling College - Vermont'),(11694,9371,'en','name','Imperial College Healthcare NHS Trust'),(11695,9372,'no_lang_code','name','Huawei Technologies (United Kingdom)'),(11696,9373,'it','name','Ospedale degli Infermi'),(11697,9374,'en','name','Punjab Institute of Cardiology'),(11698,9375,'en','name','Cooper University Health Care'),(11699,9376,'en','name','Royal Lancaster Infirmary'),(11700,9377,'no_lang_code','name','Agile Sciences (United States)'),(11701,9378,'en','name','National Disaster Medical Center'),(11702,9378,'ja','name','国立病院機構災害医療センター'),(11703,9379,'en','name','Preferred Family Healthcare'),(11704,9380,'en','name','Northern Alberta Institute of Technology'),(11705,9381,'en','name','New Zealand College of Chiropractic'),(11706,9382,'en','name','Korea Center for Disease Control and Prevention'),(11707,9383,'no_lang_code','name','Targeson (United States)'),(11708,9384,'fr','name','Québec Science (Canada)'),(11709,9385,'en','name','Newberry College'),(11710,9386,'no_lang_code','name','Ansys (United Kingdom)'),(11711,9387,'no_lang_code','name','Kinder Magic Software (United States)'),(11712,9388,'en','name','Houston Headache & Neurological Institute'),(11713,9389,'no_lang_code','name','Recon Instruments (Canada)'),(11714,9390,'no_lang_code','name','2B Technologies (United States)'),(11715,9391,'no_lang_code','name','3D Molecular Designs (United States)'),(11716,9392,'en','name','Tochigi Medical Center'),(11717,9392,'ja','name','栃木医療センター'),(11718,9393,'no_lang_code','name','Pall Corporation (United States)'),(11719,9394,'en','name','Hungarian Meat Research Institute'),(11720,9395,'en','name','Vitalant'),(11721,9396,'no_lang_code','name','Titanium Metals Corporation (United Kingdom)'),(11722,9397,'en','name','Institute of Higher Nervous Activity and Neurophysiology'),(11723,9397,'ru','name','Федеральное государственное бюджетное учреждение науки Институт высшей нервной деятельности и нейрофизиологии Российской академии наук'),(11724,9398,'en','name','Lee College'),(11725,9399,'en','name','Foundation for Health Care Quality'),(11726,9400,'en','name','Lloyd\'s Register Foundation'),(11727,9401,'no_lang_code','name','McKesson (United States)'),(11728,9402,'no_lang_code','name','AdvanSource Biomaterials (United States)'),(11729,9403,'en','name','Tai Po Hospital'),(11730,9403,'zh','name','大埔醫院'),(11731,9404,'no_lang_code','name','Papa Ola Lokahi'),(11732,9405,'en','name','Virginia Commonwealth University Medical Center'),(11733,9406,'en','name','Island Health'),(11734,9407,'no_lang_code','name','Pro Ed (United States)'),(11735,9408,'it','name','Frascati Scienza'),(11736,9409,'en','name','Fleming College'),(11737,9410,'en','name','North Dakota Department of Human Services'),(11738,9411,'en','name','Strong Memorial Hospital'),(11739,9412,'en','name','Hagerstown Community College'),(11740,9413,'no_lang_code','name','EndoShape (United States)'),(11741,9414,'ja','name','キリン株式会社'),(11742,9414,'no_lang_code','name','Kirin (Japan)'),(11743,9415,'en','name','Los Angeles Community College District'),(11744,9416,'en','name','Neuroscience Education Institute'),(11745,9417,'en','name','Beijing Center for Disease Prevention and Control'),(11746,9417,'zh','name','北京市疾病预防控制中心'),(11747,9418,'no_lang_code','name','Bio Concept Laboratories (United States)'),(11748,9419,'no_lang_code','name','Endocyte (United States)'),(11749,9420,'no_lang_code','name','Sion Power (United States)'),(11750,9421,'no_lang_code','name','Vemco (Canada)'),(11751,9422,'no_lang_code','name','Empirical Technologies (United States)'),(11752,9423,'bg','name','Национален център по радиобиология и радиационна защита'),(11753,9423,'en','name','National Center of Radiobiology and Radiation Protection'),(11754,9424,'en','name','Logan University'),(11755,9425,'en','name','New York State Unified Court System'),(11756,9426,'fr','name','Hôpital Saint Roch'),(11757,9427,'no_lang_code','name','Laureate Learning Systems (United States)'),(11758,9428,'en','name','Central Leprosy Teaching & Research Institute'),(11759,9429,'it','name','Casa di Cura Villa Bianca'),(11760,9430,'en','name','Voluntary Health Services Hospital'),(11761,9431,'en','name','Baltimore Washington Center for Psychoanalysis'),(11762,9432,'en','name','African Field Epidemiology Network'),(11763,9433,'en','name','Michigan Psychoanalytic Institute'),(11764,9434,'en','name','International Rice Research Institute'),(11765,9435,'en','name','Institute of Occupational Safety'),(11766,9435,'sl','name','Zavod za varstvo pri delu'),(11767,9436,'no_lang_code','name','TransGenex Nanobiotech (United States)'),(11768,9437,'en','name','Council on Environmental Quality'),(11769,9438,'en','name','Indian Institute of Spices Research'),(11770,9439,'no_lang_code','name','Therapeutic Proteins International (United States)'),(11771,9440,'no_lang_code','name','Imperial Innovations (United Kingdom)'),(11772,9441,'en','name','Lone Star College'),(11773,9442,'de','name','Klinikum Stuttgart'),(11774,9443,'en','name','Reitan Neuropsychology Laboratory'),(11775,9444,'no_lang_code','name','ActivBiotics (United States)'),(11776,9445,'en','name','Rocky Mountain MS Center'),(11777,9446,'en','name','National Institute of Veterinary Research'),(11778,9447,'en','name','New Jersey Department of Human Services'),(11779,9448,'no_lang_code','name','Conciaricerca'),(11780,9449,'en','name','Johnson County Community College'),(11781,9450,'no_lang_code','name','Hewlett-Packard (United States)'),(11782,9451,'no_lang_code','name','Ekso Bionics (United States)'),(11783,9452,'en','name','National Polytechnic Institute'),(11784,9452,'es','name','Instituto Politécnico Nacional'),(11785,9453,'ja','name','高槻病院'),(11786,9453,'no_lang_code','name','Takatsuki General Hospital'),(11787,9454,'no_lang_code','name','MYcroarray (United States)'),(11788,9455,'no_lang_code','name','Covance (United Kingdom)'),(11789,9456,'en','name','Gujarat Technological University'),(11790,9457,'en','name','Society for Prevention Research'),(11791,9458,'no_lang_code','name','Balfour Beatty (United Kingdom)'),(11792,9459,'en','name','Georgetown College'),(11793,9460,'no_lang_code','name','TandemLaunch (Canada)'),(11794,9461,'en','name','Meta House'),(11795,9462,'en','name','Gadsden State Community College'),(11796,9463,'en','name','National Museum Wales'),(11797,9464,'no_lang_code','name','Pulmokine (United States)'),(11798,9465,'no_lang_code','name','Aquilent (United States)'),(11799,9466,'no_lang_code','name','Schrodinger (United States)'),(11800,9467,'no_lang_code','name','BioPhyZica (United States)'),(11801,9468,'en','name','Osteogenesis Imperfecta Foundation'),(11802,9469,'en','name','Dakota County Technical College'),(11803,9470,'es','name','Instituto de Medicina Tropical “Pedro Kourí”'),(11804,9471,'en','name','Centre of Biotechnology of Sfax'),(11805,9472,'no_lang_code','name','Alceon Corporation (United States)'),(11806,9473,'no_lang_code','name','General Motors (United States)'),(11807,9474,'en','name','D\'Youville College'),(11808,9475,'en','name','Mary Bird Perkins Cancer Center'),(11809,9476,'no_lang_code','name','Tekna Plasma Systems (Canada)'),(11810,9477,'en','name','Korea National Tuberculosis Association'),(11811,9478,'no_lang_code','name','Biological Monitoring Incorporated (United States)'),(11812,9479,'en','name','Bellin College'),(11813,9480,'no_lang_code','name','Therametric Technologies (United States)'),(11814,9481,'no_lang_code','name','Astraea Therapeutics (United States)'),(11815,9482,'en','name','Billings Clinic'),(11816,9483,'en','name','Tokyo National Hospital'),(11817,9483,'ja','name','国立病院機構東京病院'),(11818,9484,'en','name','Center for Human Reproduction'),(11819,9485,'en','name','Pulmonary Hypertension Association'),(11820,9486,'en','name','VA Maryland Health Care System'),(11821,9487,'en','name','Indian River State College'),(11822,9488,'en','name','New York Psychoanalytic Society and Institute'),(11823,9489,'en','name','Alta Bates Summit Medical Center'),(11824,9490,'no_lang_code','name','Sciencetech (Canada)'),(11825,9491,'en','name','GateWay Community College'),(11826,9492,'en','name','Houston Area Community Services'),(11827,9493,'en','name','Transport Scotland'),(11828,9494,'en','name','Normandale Community College'),(11829,9495,'it','name','Azienda Ospedaliera Ospedali Riuniti Papardo Piemonte'),(11830,9496,'no_lang_code','name','Process Simulations Limited (Canada)'),(11831,9497,'no_lang_code','name','Nordion (Canada)'),(11832,9498,'en','name','Ludwik Hirszfeld Institute of Immunology and Experimental Therapy'),(11833,9498,'pl','name','Instytut Immunologii i Terapii Doświadczalnej'),(11834,9499,'de','name','Max-Planck-Institut für Molekulare Zellbiologie und Genetik'),(11835,9499,'en','name','Max Planck Institute of Molecular Cell Biology and Genetics'),(11836,9500,'no_lang_code','name','Premitec (United States)'),(11837,9501,'no_lang_code','name','BioStar Systems (United States)'),(11838,9502,'no_lang_code','name','BioFine International (Canada)'),(11839,9503,'en','name','Center for Occupational Research and Development'),(11840,9504,'en','name','Okinawa Prefectural Institute of Health and Environment'),(11841,9504,'ja','name','健康と環境の沖縄県立大学'),(11842,9505,'no_lang_code','name','AlphaVax (United States)'),(11843,9506,'en','name','National Taichung University of Science and Technology'),(11844,9507,'fr','name','Centre d’Economie rurale'),(11845,9508,'en','name','Scripps Health'),(11846,9509,'en','name','Korea Forest Service'),(11847,9510,'en','name','Chestnut Hill College'),(11848,9511,'en','name','Center for Cancer Research'),(11849,9512,'no_lang_code','name','Biota Pharmaceuticals (United States)'),(11850,9513,'en','name','National Institute for Interdisciplinary Science and Technology'),(11851,9513,'ml','name','നാഷണൽ ഇൻസ്ററിററ്യൂട്ട് ഫോർ ഇൻറർ ഡിസിപ്ളിനറി സയൻസ് അൻഡ് ടെക്നോളജി, തിരുവനന്തപുരം'),(11852,9514,'no_lang_code','name','Maxeler Technologies (United Kingdom)'),(11853,9515,'en','name','Patricia and Phillip Frost Museum of Science'),(11854,9516,'no_lang_code','name','Norbord (Canada)'),(11855,9517,'en','name','Tokyo Metropolitan Kiyose Children\'s Hospital'),(11856,9517,'ja','name','東京都立小児総合医療センター'),(11857,9518,'en','name','European Network of Science Centres and Museums'),(11858,9519,'fr','name','Cegep de Victoriaville, Cégep de victoriaville'),(11859,9520,'en','name','National Academy of Medicine'),(11860,9521,'en','name','Salisbury District Hospital'),(11861,9522,'es','name','Instituto de Investigación Nutricional'),(11862,9523,'no_lang_code','name','Romny Scientific (United States)'),(11863,9524,'no_lang_code','name','MPB Technologies & Communications (Canada)'),(11864,9525,'no_lang_code','name','Cedrat Technologies (France)'),(11865,9526,'no_lang_code','name','Thomas Swan (United Kingdom)'),(11866,9527,'no_lang_code','name','Immunovaccine (Canada)'),(11867,9528,'no_lang_code','name','Genaera (United States)'),(11868,9529,'no_lang_code','name','Atkinson Noland and Associates (United States)'),(11869,9530,'no_lang_code','name','Agiltron (United States)'),(11870,9531,'en','name','United States Military Entrance Processing Command'),(11871,9532,'ja','name','済生会福岡総合病院'),(11872,9532,'no_lang_code','name','Saiseikai Fukuoka General Hospital'),(11873,9533,'no_lang_code','name','Bentley (Canada)'),(11874,9534,'en','name','Southwest College of Naturopathic Medicine & Health Sciences'),(11875,9535,'no_lang_code','name','Predictive Science (United States)'),(11876,9536,'en','name','Gerald P. Murphy Cancer Foundation'),(11877,9537,'en','name','Association of Bay Area Governments'),(11878,9538,'no_lang_code','name','Theralogix (United States)'),(11879,9539,'en','name','Association of Maternal and Child Health Programs'),(11880,9540,'no_lang_code','name','AeroVironment (United States)'),(11881,9541,'it','name','Fondazione Andrea Cesalpino'),(11882,9542,'no_lang_code','name','Tekion (Canada)'),(11883,9543,'en','name','Princess Alexandra Hospital'),(11884,9544,'en','name','American Association of Engineering Societies'),(11885,9545,'pt','name','Fundação Pró-Sangue Hemocentro de São Paulo'),(11886,9546,'nl','name','Instituut voor Landbouw en Visserijonderzoek'),(11887,9547,'no_lang_code','name','Newton Scientific Incorporation (United States)'),(11888,9548,'no_lang_code','name','Molecular Targeting Technologies (United States)'),(11889,9549,'no_lang_code','name','Xijing Hospital'),(11890,9549,'zh','name','西京医院'),(11891,9550,'en','name','Prescott College'),(11892,9551,'no_lang_code','name','Mendel Biotechnology (United States)'),(11893,9552,'en','name','Beijing Academy of Science and Technology'),(11894,9552,'zh','name','北京市电加工研究所'),(11895,9553,'en','name','Walton Centre'),(11896,9554,'no_lang_code','name','StemCells (United States)'),(11897,9555,'en','name','Cambrian College'),(11898,9556,'no_lang_code','name','Ecovative Design (United States)'),(11899,9557,'ja','name','全国農業協同組合連合会'),(11900,9557,'no_lang_code','name','Zen-Noh (Japan)'),(11901,9558,'no_lang_code','name','Neural Signals (United States)'),(11902,9559,'no_lang_code','name','Advanced Cell Technology (United States)'),(11903,9560,'no_lang_code','name','BLH Technologies (United States)'),(11904,9561,'no_lang_code','name','Sani Marc (Canada)'),(11905,9562,'en','name','Lawson State Community College'),(11906,9563,'en','name','Wesleyan College'),(11907,9564,'en','name','Plano Orthopedic Sports Medicine & Spine Center'),(11908,9565,'en','name','Truman Medical Center'),(11909,9566,'es','name','Sociedad Española de Cardiología'),(11910,9567,'en','name','San Francisco Center for Psychoanalysis'),(11911,9568,'no_lang_code','name','Suraj Eye Institute'),(11912,9569,'nl','name','Nederlands Instituut Voor Zuivel Oonderzoek'),(11913,9570,'no_lang_code','name','Ganeden Biotech (United States)'),(11914,9571,'en','name','AltaMed'),(11915,9572,'de','name','IFT Institut für Therapieforschung'),(11916,9572,'en','name','Institute for Therapy and Health Research'),(11917,9573,'en','name','Academy of Nutrition and Dietetics'),(11918,9574,'en','name','Kumoh National Institute of Technology'),(11919,9574,'ko','name','금오공과대학교'),(11920,9575,'nl','name','Ziekenhuisnetwerk Antwerpen Stuivenberg'),(11921,9576,'es','name','Instituto Chileno de Medicina Reproductiva'),(11922,9577,'no_lang_code','name','GMA Industries (United States)'),(11923,9578,'en','name','National Center for Epidemiology'),(11924,9578,'hu','name','Országos Epidemiológiai Központ'),(11925,9579,'it','name','Ospedale Civile di Venezia'),(11926,9580,'en','name','Boston Psychoanalytic Society and Institute'),(11927,9581,'it','name','Fondazione IRCCS Istituto Nazionale dei Tumori'),(11928,9582,'en','name','Knowle West Media Centre'),(11929,9583,'en','name','Bristol Community College'),(11930,9584,'no_lang_code','name','Ophir Corporation (United States)'),(11931,9585,'no_lang_code','name','Exemplar Genetics (United States)'),(11932,9586,'en','name','Lovelace Clinic Foundation Research'),(11933,9587,'no_lang_code','name','Skyre (United States)'),(11934,9588,'en','name','Cuyahoga County Board of Health'),(11935,9589,'en','name','Elmhurst College'),(11936,9590,'no_lang_code','name','Creative Electron (United States)'),(11937,9591,'fr','name','Institut Jules Bordet'),(11938,9592,'no_lang_code','name','Dynaflow (United States)'),(11939,9593,'en','name','Roseman University of Health Sciences'),(11940,9594,'en','name','Big Little Science Centre'),(11941,9595,'en','name','Riverside Community College District'),(11942,9596,'en','name','St. John Fisher College'),(11943,9597,'en','name','DNA EpiCenter'),(11944,9598,'en','name','Institute of Genomics and Integrative Biology'),(11945,9599,'en','name','Taranaki Base Hospital'),(11946,9600,'en','name','National Minority AIDS Council'),(11947,9601,'no_lang_code','name','Cytoskeleton (United States)'),(11948,9602,'no_lang_code','name','Parion Sciences (United States)'),(11949,9603,'en','name','Fraunhofer Portugal Research'),(11950,9604,'no_lang_code','name','Segue Corporation (United States)'),(11951,9605,'en','name','National AIDS Research Institute'),(11952,9606,'fr','name','L’École Supérieure de Biotechnologie de Strasbourg, École Supérieure de Biotechnologie de Strasbourg'),(11953,9607,'en','name','Alberta Centre for Advanced MNT Products (Canada)'),(11954,9608,'en','name','La Jolla Infectious Disease Institute'),(11955,9609,'no_lang_code','name','Council on Alcohol and Drugs (United States)'),(11956,9610,'no_lang_code','name','Rocky Mountain Research (United States)'),(11957,9611,'en','name','Lincoln Land Community College'),(11958,9612,'en','name','Crohn\'s and Colitis Foundation'),(11959,9613,'en','name','Chemeketa Community College'),(11960,9614,'no_lang_code','name','Visual Health Solutions (United States)'),(11961,9615,'no_lang_code','name','M Squared Lasers (United Kingdom)'),(11962,9616,'no_lang_code','name','PharmIdeas (Canada)'),(11963,9617,'en','name','Rothberg Institute For Childhood Diseases'),(11964,9618,'en','name','Tucson Medical Center'),(11965,9619,'en','name','Institute of Biocybernetics and Biomedical Engineering'),(11966,9620,'en','name','Woman\'s Hospital'),(11967,9621,'no_lang_code','name','UTRON Kinetics (United States)'),(11968,9622,'en','name','Midwest Orthopaedic Research Foundation'),(11969,9623,'no_lang_code','name','Cancer Genetics (United States)'),(11970,9624,'no_lang_code','name','Light Age (United States)'),(11971,9625,'en','name','Charitable Infirmary'),(11972,9626,'no_lang_code','name','Radisys (Canada)'),(11973,9627,'en','name','Merri Creek Management Committee'),(11974,9628,'no_lang_code','name','Photoswitch Biosciences (United States)'),(11975,9629,'en','name','International Tomography Center'),(11976,9629,'ru','name','Федеральное государственное бюджетное учреждение науки Институт Международный томографический центр Сибирского отделения Российской академии наук'),(11977,9630,'en','name','Tzu Chi College of Technology'),(11978,9630,'zh','name','慈濟技術學院'),(11979,9631,'en','name','Endocrine Society'),(11980,9632,'no_lang_code','name','Intuitive Surgical (United States)'),(11981,9633,'en','name','Netcare Sunninghill Hospital'),(11982,9634,'no_lang_code','name','KWS (United Kingdom)'),(11983,9635,'hu','name','Országos Reumatológiai és Fizioterápiás Intézet'),(11984,9636,'en','name','Institute of Cell Biophysics'),(11985,9636,'ru','name','Федеральное государственное бюджетное учреждение науки Институт биофизики клетки Российской академии наук'),(11986,9637,'en','name','Whittemore Peterson Institute'),(11987,9638,'en','name','Clatterbridge Cancer Centre NHS Foundation Trust'),(11988,9639,'no_lang_code','name','InterPhases Solar (United States)'),(11989,9640,'no_lang_code','name','GlaxoSmithKline (Germany)'),(11990,9641,'en','name','Bradford Teaching Hospitals NHS Foundation Trust'),(11991,9642,'en','name','Parkland College'),(11992,9643,'no_lang_code','name','HeartVista (United States)'),(11993,9644,'en','name','Center for Applied Special Technology'),(11994,9645,'no_lang_code','name','Repligen (United States)'),(11995,9646,'no_lang_code','name','Protasis (United States)'),(11996,9647,'it','name','Istituto Cantonale di Patologia'),(11997,9648,'en','name','Bellevue College'),(11998,9649,'en','name','Aichi Prefectural Government'),(11999,9649,'ja','name','愛知県'),(12000,9650,'en','name','Advocates for Youth'),(12001,9651,'en','name','National Institute of Health'),(12002,9652,'no_lang_code','name','SciMed Technologies (Canada)'),(12003,9653,'no_lang_code','name','Allied Innovative Systems (United States)'),(12004,9654,'en','name','Mount Saint Mary College'),(12005,9655,'en','name','Association of Food and Drug Officials'),(12006,9656,'ja','name','福岡県済生会八幡総合病院'),(12007,9656,'no_lang_code','name','Saiseikai Yahata General Hospital'),(12008,9657,'de','name','Nationaal Instituut voor Criminalistiek en Criminologie'),(12009,9657,'fr','name','Institut National de Criminalistique et de Criminologie'),(12010,9658,'no_lang_code','name','Diagnostics for the Real World (United States)'),(12011,9659,'en','name','Kessler Foundation'),(12012,9660,'en','name','Palladin Institute of Biochemistry'),(12013,9660,'uk','name','Інститут біохімії ім О.В Палладіна'),(12014,9661,'no_lang_code','name','Arietis (United States)'),(12015,9662,'no_lang_code','name','Immunotope (United States)'),(12016,9663,'en','name','Calspan-University of Buffalo Research Center'),(12017,9664,'it','name','Azienda di Rilievo Nazionale ed Alta Specializzazione'),(12018,9665,'no_lang_code','name','Vista Engineering (United States)'),(12019,9666,'no_lang_code','name','Walker (United States)'),(12020,9667,'ja','name','横浜栄共済病院'),(12021,9667,'no_lang_code','name','Yokohama Sakae Kyosai Hospital'),(12022,9668,'en','name','Baptist Hospital'),(12023,9668,'ko','name','침례병원'),(12024,9669,'no_lang_code','name','Loadpoint (United Kingdom)'),(12025,9670,'fr','name','Centre Antoine Lacassagne'),(12026,9671,'en','name','Shorter University'),(12027,9672,'no_lang_code','name','Puresyn (United States)'),(12028,9673,'en','name','Student Pugwash USA'),(12029,9674,'no_lang_code','name','Genetika'),(12030,9674,'ru','name','Федеральное государственное унитарное предприятие Государственный научно-исследовательский институт генетики и селекции промышленных микроорганизмов'),(12031,9675,'en','name','Institute of Cytology and Preventive Oncology'),(12032,9676,'no_lang_code','name','Potomac Affinity Proteins (United States)'),(12033,9677,'no_lang_code','name','Oxford Instruments (Canada)'),(12034,9678,'en','name','Indiana Hemophilia and Thrombosis Center'),(12035,9679,'de','name','Klinikum Bremen-Mitte'),(12036,9680,'en','name','Northampton Community College'),(12037,9681,'en','name','Western Maine Health'),(12038,9682,'en','name','El Dorado Hills Community Vision'),(12039,9683,'en','name','Saitama Red Cross Hospital'),(12040,9683,'ja','name','さいたま赤十字病院'),(12041,9684,'no_lang_code','name','Innoval Technology (United Kingdom)'),(12042,9685,'es','name','Instituto Médico La Floresta'),(12043,9686,'en','name','San Francisco General Hospital'),(12044,9687,'en','name','Museum of Man'),(12045,9687,'fr','name','Musée de l\'Homme'),(12046,9688,'fr','name','Centre Hospitalier Régional de Huy'),(12047,9689,'no_lang_code','name','Rimage Corporation (United States)'),(12048,9690,'en','name','Joliet Junior College'),(12049,9691,'en','name','National Center for Immunization and Respiratory Diseases'),(12050,9692,'en','name','Ohlone College'),(12051,9693,'en','name','Butterfly Conservation'),(12052,9694,'en','name','Plant Industry'),(12053,9695,'no_lang_code','name','Meso Scale Discovery (United States)'),(12054,9696,'en','name','San Antonio Metropolitan Health District'),(12055,9697,'en','name','New Mexico Museum of Natural History Foundation'),(12056,9698,'no_lang_code','name','Thinktank'),(12057,9699,'en','name','Stamford Hospital'),(12058,9700,'en','name','Evergreen Valley College'),(12059,9701,'en','name','National Institute of Medical Rehabilitation'),(12060,9701,'hu','name','Országos Orvosi Rehabilitációs Intézet'),(12061,9702,'no_lang_code','name','Terra Nova Learning Systems (United States)'),(12062,9703,'no_lang_code','name','Evergen Biotechnologies (United States)'),(12063,9704,'no_lang_code','name','Layton BioScience (United States)'),(12064,9705,'cs','name','Nemocnice Šternberk'),(12065,9706,'no_lang_code','name','Human Genome Sciences (United States)'),(12066,9707,'no_lang_code','name','ACTeon Environment (France)'),(12067,9708,'en','name','Buenos Aires National Academy of Medicine'),(12068,9708,'es','name','Academia Nacional de Medicina'),(12069,9709,'en','name','National Kidney and Transplant Institute'),(12070,9710,'en','name','National Institute of Neurology and Neurosurgery'),(12071,9710,'es','name','Instituto Nacional de Neurología y Neurocirugía'),(12072,9711,'en','name','Clinical Research Management'),(12073,9712,'en','name','La Frontera Arizona'),(12074,9713,'no_lang_code','name','Sony Corporation (United States)'),(12075,9714,'fr','name','Banque Populaire'),(12076,9715,'no_lang_code','name','Boehringer Ingelheim (United States)'),(12077,9716,'en','name','Agrifood Research Finland'),(12078,9717,'no_lang_code','name','Fairfield Crystal Technology (United States)'),(12079,9718,'no_lang_code','name','Glycobia (United States)'),(12080,9719,'no_lang_code','name','Hexagon (United Kingdom)'),(12081,9720,'no_lang_code','name','ProSensus (Canada)'),(12082,9721,'de','name','Profil Institut für Stoffwechselforschung'),(12083,9721,'en','name','Profil Institute for Metabolic Research'),(12084,9722,'no_lang_code','name','East Malling Research (United Kingdom)'),(12085,9723,'no_lang_code','name','Sunnyside Sea Farms (United States)'),(12086,9724,'en','name','The AIDS Support Organization'),(12087,9725,'en','name','Scripps Clinic'),(12088,9726,'en','name','Hertfordshire County Council'),(12089,972